/* This file is part of the KDE project
   Copyright (C) 2004 Lucijan Busch <lucijan@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeglobalsettings.h>
#include <kstdguiitem.h>
#include <tdeversion.h>

#include "kexidatasourcewizard.h"
#include "kexidswelcome.h"

KexiDSWelcome::KexiDSWelcome(KexiDataSourceWizard *parent)
 : TQWidget(parent)
{
	m_wiz = parent;
	KexiDSPixmap *pic = new KexiDSPixmap(this);

	TQLabel *lText = new TQLabel(i18n("Kexi can help you with creation of %2 using data sources in almost no time with the \"%1 Wizard\""), this);
	lText->setAlignment(AlignTop | AlignLeft | WordBreak);
	TQCheckBox *useWizard = new TQCheckBox(i18n("Create %1 using the \"%1 Wizard\""), this);
	connect(useWizard, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(setUseWizard(bool)));
	useWizard->setChecked(true);

	TQSpacerItem *spacer = new TQSpacerItem(320, 220);
	TQCheckBox *dontShow = new TQCheckBox(i18n("Do not show this wizard again"), this);

	TQGridLayout *g = new TQGridLayout(this);

	g->addMultiCellWidget(pic, 0, 4, 0, 0);
	g->addWidget(lText, 0, 1);
	g->addWidget(useWizard, 2, 1);
	g->addItem(spacer, 3, 1);
	g->addWidget(dontShow, 4, 1);
}

void
KexiDSWelcome::setUseWizard(bool use)
{
#if KDE_IS_VERSION(3,1,9) && !defined(TQ_WS_WIN)
	bool useIcons = TDEGlobalSettings::showIconsOnPushButtons();
#else
	bool useIcons = true;
#endif
	if(use)
	{
		KGuiItem forward = KStdGuiItem::forward(KStdGuiItem::UseRTL);

		if(useIcons)
			m_wiz->nextButton()->setIconSet( forward.iconSet() );

		m_wiz->nextButton()->setText(i18n("&Next"));
	}
	else
	{
		if(useIcons)
			m_wiz->nextButton()->setIconSet(SmallIconSet("apply"));

		m_wiz->nextButton()->setText(i18n("&Finish"));
	}

	m_wiz->finishNext(!use);
}

KexiDSWelcome::~KexiDSWelcome()
{
}

#include "kexidswelcome.moc"

