/*
 *  kis_previewdialog.cc - part of Chalk
 *
 *  Copyright (c) 2005 Sven Langkamp <longamp@reallygood.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <tqframe.h>
#include <tqhbox.h>
#include <tqgroupbox.h>
#include <tqlayout.h>

#include "kis_previewwidget.h"
#include "kis_previewdialog.h"

KisPreviewDialog::KisPreviewDialog( TQWidget *  parent, const char * name, bool modal, const TQString &caption)
    : super (parent, name, modal, caption, Ok | Cancel, Ok)
{
    TQHBox* layout = new TQHBox(this);
    layout->setSpacing( 6 );

    m_containerFrame = new TQFrame( layout, "container" );

    m_preview = new KisPreviewWidget( layout, "previewWidget" );

    setMainWidget(layout);
}

KisPreviewDialog::~KisPreviewDialog()
{

}

#include "kis_previewdialog.moc"
