/***************************************************************************
 *
 * knetworkmanager-wireless_network.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_WIRELESS_NETWORK_H
#define KNETWORKMANAGER_WIRELESS_NETWORK_H

#include "knetworkmanager.h"
#include "knetworkmanager-device.h"

#include <stdint.h>

class KNetworkManager;
class AccessPoint;
class WirelessNetworkPrivate;

namespace ConnectionSettings
{
	class WirelessConnection;
}

/*
	A wireless network represents multiple accesspoints
	that share the same essid and security-caps
*/
class WirelessNetwork
{
	public:
		// bitwise encoded enum
		// allows the specification on how multiple APs get grouped together
		enum MATCH_ATTRIBUTES
		{
			// only match APs with the same ssid
			MATCH_SSID = 1
		};

		WirelessNetwork(const WirelessNetwork& other);
		WirelessNetwork (TQ_UINT32 match = MATCH_SSID);
		~WirelessNetwork ();

		WirelessNetwork& operator= (const WirelessNetwork&);

		// check if the AccessPoint represents the same net
		bool contains(const AccessPoint * const);

		// add an AP to the Network
		bool       addAP(const AccessPoint * const);

		// combined flags of all APs
		TQ_UINT32   getFlags() const;

		// combined wpa-flags of all APs
		TQ_UINT32   getWpaFlags() const;

		// combined rsn-flags of all APs
		TQ_UINT32   getRsnFlags() const;

		// ssid of all APs
		const TQByteArray getSsid() const; 

		TQString    getDisplaySsid() const;
		bool       isEncrypted() const;

		// strength of the best AP
		TQ_UINT8    getStrength() const;

		void       setActive(bool active);
		bool       getActive() const;

		bool operator==(const WirelessNetwork&);

	private:
	  WirelessNetworkPrivate * d;
};

#endif /* KNETWORKMANAGER_WIRELESS_NETWORK_H */
