/***************************************************************************
 *
 * knetworkmanager-vpnplugin.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNPLUGIN_H
#define KNETWORKMANAGER_VPNPLUGIN_H

#include <tqwidget.h>
#include <tqmap.h>
#include <tqdbusdata.h>
#include <tqdbusvariant.h>
#include "knetworkmanager-plugin.h"

#define KNETWORKMANAGER_VPNPLUGIN "KNetworkManager/VPNPlugin"

class VPNConfigWidget : public TQWidget
{
	Q_OBJECT
  
	public:
		virtual ~VPNConfigWidget();
		VPNConfigWidget(TQWidget* parent = NULL, const char* name = NULL); 

		virtual void setVPNData(const TQStringList&, const TQMap<TQString,TQString>&);	
		virtual TQMap<TQString, TQString> getVPNProperties();
		virtual TQStringList getVPNRoutes();
		virtual bool hasChanged();
		virtual bool isValid(TQStringList&);
};

class VPNAuthenticationWidget : public TQWidget
{
	Q_OBJECT
  
	public:
		virtual ~VPNAuthenticationWidget();
		VPNAuthenticationWidget(TQWidget* parent = NULL, const char* name = NULL);
		
		virtual void setVPNData(const TQStringList&, const TQMap<TQString, TQString>&);
		virtual TQMap<TQString, TQString> getPasswords();
		virtual void setPasswords(TQString value, TQString data);
		virtual bool needsUserInteraction();
};

class VPNPlugin : public Plugin
{
	Q_OBJECT
  
	public:
		VPNPlugin(TQObject*, const char*, const TQStringList&);
		virtual ~VPNPlugin();

		virtual VPNConfigWidget* CreateConfigWidget(TQWidget* parent = 0);
		virtual VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent = 0);
};


#endif /* KNETWORKMANAGER_VPNPLUGIN_H */

