/***************************************************************************
 *
 * knetworkmanager-vpn_device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>

// TQt includes
#include <tqhostaddress.h>

// TQT_DBus includes
#include <tqdbuserror.h>
#include <tqdbusconnection.h>

// NM includes
#include <NetworkManager.h>
#include <NetworkManagerVPN.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-vpn_device.h"
#include "dbus/vpnconnectionproxy.h"
#include "knetworkmanager-hal_device_proxy.h"

class VPNDevicePrivate
{
public:
	VPNDevicePrivate(TQString service, TQString obj_path)
		: nmVPN(service, obj_path)
	{}
	~VPNDevicePrivate() {}

	DBus::VPNConnectionProxy nmVPN;
};

TQ_UINT32 VPNDevice::getState()
{
	TQT_DBusError err;
	return d->nmVPN.getVpnState(err);
}

VPNDevice::VPNDevice (const TQString & obj_path)
	: Device(obj_path)
{
	d = new VPNDevicePrivate(NM_DBUS_IFACE_SETTINGS_CONNECTION, obj_path);
	d->nmVPN.setConnection(TQT_DBusConnection::systemBus());
}

VPNDevice::~VPNDevice ()
{
	delete d;
}


#include "knetworkmanager-vpn_device.moc"
