/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>
#include <tqvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <tdelocale.h>

/* TQDbus headers */
#include <tqdbusconnection.h>
#include <tqdbusobjectpath.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbusvariant.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_secrets_dbus.h"
#include "knetworkmanager-connection_dbus.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-nmsettings.h"
#include "xmlmarshaller.h"
#include "stdio.h"

using namespace ConnectionSettings;

namespace ConnectionSettings
{

class ConnectionSecretsDBusPrivate
{
	public:
		ConnectionSecretsDBusPrivate(Connection* par)
			: parent(par)
      , currentRequest(-1)
    {}
		~ConnectionSecretsDBusPrivate() {}

		Connection* parent;
		int         currentRequest;
};

}

/*
	class Connection
*/
ConnectionSecretsDBus::ConnectionSecretsDBus(Connection* parent)
	: TQObject(parent)
{
	d = new ConnectionSecretsDBusPrivate(parent);
}

ConnectionSecretsDBus::~ConnectionSecretsDBus()
{
	delete d;
}

void
ConnectionSecretsDBus::SendGetSecretsError()
{
	GetSecretsAsyncError(d->currentRequest, TQT_DBusError::stdFailed("Requested setting is empty"));
}

void
ConnectionSecretsDBus::SendGetSecretsReply(ConnectionSettings::ConnectionSetting* setting)
{
	TQT_DBusMessage reply;

	kdDebug() << "SendGetSecretsReply1 id " << d->currentRequest << endl;

	// if no secret is needed we should not send one, right?
	if (d->currentRequest < 0)
		return;
	kdDebug() << "SendGetSecretsReply2" << endl;
/*
	// no such setting
	if (!setting)
	{
		GetSecretsAsyncError(d->currentRequest, TQT_DBusError::stdFailed("Requested setting is unknown"));
	}
	else
	{
	kdDebud() << "SendGetSecretsReply3" << endl;
		// copy the settingsmap over to a variantmap
		TQMap<TQString, TQT_DBusData> map = setting->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
	kdDebug() << "SendGetSecretsReply4" << endl;
			GetSecretsAsyncError(d->currentRequest, TQT_DBusError::stdFailed("Requested setting is empty"));
		}
		else
		{
	kdDebug() << "SendGetSecretsReply5" << endl;
			TQT_DBusDataMap<TQString> secrets(map);
			
			TQMap<TQString, TQT_DBusVariant> secrets;
			for (TQMap<TQString, TQT_DBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
			{
				TQT_DBusVariant var;
				var.value = it2.data();
				var.signature = var.value.buildDBusSignature();
				secrets.insert(it2.key(), var);
			}
	kdDebug() << "SendGetSecretsReply6" << endl;

			GetSecretsAsyncReply(d->currentRequest, secrets);
		}
	}*/

	TQT_DBusDataMap<TQString> settings;
	TQValueList<ConnectionSetting*> all_settings = d->parent->getSettings();

	// FIXME: ugly conversions, ask Kevin on how to make it better
	for (TQValueList<ConnectionSetting*>::Iterator it = all_settings.begin(); it != all_settings.end(); ++it)
	{
		kdDebug() << "  Processing Setting '" << (*it)->getType().ascii() << "'" << endl;
		if (!(*it)->isValid())
		{
			kdDebug() << "  Setting '" << (*it)->getType().ascii() << "' is not valid, discarding" << endl;
			continue;
		}

		// copy the settingsmap over to a variantmap
		TQMap<TQString, TQT_DBusData> map = (*it)->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
			kdDebug() << "  Setting '" << (*it)->getType().ascii() << "' is empty, discarding" << endl;
			continue;
		}

		kdDebug() << "  Attach setting '" << (*it)->getType().ascii() << "'" << endl;

		TQMap<TQString, TQT_DBusVariant> variant_map;

		for (TQMap<TQString, TQT_DBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
		{
			TQString dataxml = XMLMarshaller::fromTQT_DBusData(it2.data());
			kdDebug() << "    " << it2.key().ascii() << ": " << dataxml.replace('\n', ' ').ascii() << endl;
			TQT_DBusVariant var;
			var.value = it2.data();
			var.signature = var.value.buildDBusSignature();
			variant_map.insert(it2.key(), var);
		}

		// convert the variantma
		TQT_DBusDataMap<TQString> map2 = TQT_DBusDataMap<TQString>(variant_map);
		TQT_DBusData data = TQT_DBusData::fromStringKeyMap(map2);

		// insert this setting
		settings.insert((*it)->getType(), data);
	}
	
	GetSecretsAsyncReply(d->currentRequest, settings);
	d->currentRequest = -1;

}
	
void
ConnectionSecretsDBus::GetSecretsAsync(int id, const TQString& setting_name, const TQStringList& hints, bool request_new)
{
	printf("Connection::GetSecretsAsync for setting %s, %s\n", setting_name.ascii(), id);
	kdDebug() << "Connection::GetSecretsAsync for setting " << setting_name.ascii() << ", " << id << endl;
	d->currentRequest = id;
	emit SecretsNeeded(setting_name, hints, request_new);
}

void
ConnectionSecretsDBus::handleMethodReply(const TQT_DBusMessage& reply)
{
	TQT_DBusConnection::systemBus().send(reply);
}

bool
ConnectionSecretsDBus::handleSignalSend(const TQT_DBusMessage& reply)
{
	TQT_DBusConnection::systemBus().send(reply);
	return true;
}

TQString
ConnectionSecretsDBus::objectPath() const
{
	return TQString(d->parent->getObjectPath());
}

bool
ConnectionSecretsDBus::GetSecrets(const TQString&, const TQStringList&, bool, TQT_DBusDataMap<TQString>&, TQT_DBusError&) {
	// Dummy method
	return false;
}


#include "knetworkmanager-connection_secrets_dbus.moc"
