/* This file is part of KNemo
   Copyright (C) 2004 Percy Leonhardt <percy@eris23.de>

   KNemo is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   KNemo is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef NETTOOLSBACKEND_H
#define NETTOOLSBACKEND_H

#include <tqobject.h>

#include "backendbase.h"

class TDEProcess;

/**
 * The nettools backend runs 'ifconfig', 'iwconfig' and 'route'
 * and parses their output. It then triggers the interface
 * monitor to look for changes in the state of the interface.
 *
 * @short Update the information of the interfaces via nettools
 * @author Percy Leonhardt <percy@eris23.de>
 */

class NetToolsBackend : public TQObject, BackendBase
{
    Q_OBJECT
  
public:
    NetToolsBackend(TQDict<Interface>& interfaces );
    virtual ~NetToolsBackend();

    static BackendBase* createInstance( TQDict<Interface>& interfaces );

    void update();

private slots:
    void routeProcessExited( TDEProcess* process );
    void routeProcessStdout( TDEProcess* process, char* buffer, int buflen );
    void ifconfigProcessExited( TDEProcess* process );
    void ifconfigProcessStdout( TDEProcess* process, char* buffer, int buflen );
    void iwconfigProcessExited( TDEProcess* process );
    void iwconfigProcessStdout( TDEProcess* process, char* buffer, int buflen );

private:
    void parseRouteOutput();
    void parseIfconfigOutput();
    void updateInterfaceData( TQString& config, InterfaceData& data, int type );
    void parseIwconfigOutput();
    void updateWirelessData( TQString& config, WirelessData& data );

    TQString mRouteStdout;
    TQString mIfconfigStdout;
    TQString mIwconfigStdout;
    TDEProcess* mRouteProcess;
    TDEProcess* mIfconfigProcess;
    TDEProcess* mIwconfigProcess;
};

#endif // NETTOOLSBACKEND_H
