/***************************************************************************
                          transaction.h  -  description
                             -------------------
    begin                : Tue Jun 13 2006
    copyright            : (C) 2000-2006 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSACTION_H
#define TRANSACTION_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqpalette.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/registeritem.h>
#include <kmymoney/mymoneytransaction.h>
#include <kmymoney/mymoneysplit.h>
#include <kmymoney/mymoneysecurity.h>
#include <kmymoney/selectedtransaction.h>
#include <kmymoney/mymoneyaccount.h>

class TQTable;
class TransactionEditor;
class TransactionEditorContainer;

namespace KMyMoneyTransactionForm {
  class TransactionForm;
}; // namespace

namespace KMyMoneyRegister {

// keep the following list in sync with code in the constructor
// of KMyMoneyRegister::Register in register.cpp
typedef enum {
  NumberColumn = 0,
  DateColumn,
  AccountColumn,
  SecurityColumn,
  DetailColumn,
  ReconcileFlagColumn,
  PaymentColumn,
  DepositColumn,
  QuantityColumn,
  PriceColumn,
  ValueColumn,
  BalanceColumn,
  // insert new values above this line
  MaxColumns
} Column;

class Transaction : public RegisterItem
{
public:
  Transaction(Register* parent, const MyMoneyTransaction& transaction, const MyMoneySplit& split, int uniqueId);
  virtual ~Transaction() {}

  virtual const char* className(void) { return "Transaction"; }

  bool isSelectable(void) const { return true; }
  bool isSelected(void) const { return m_selected; }
  void setSelected(bool selected);

  bool canHaveFocus(void) const { return true; }
  bool hasFocus(void) const { return m_focus; }
  bool hasEditorOpen(void) const { return m_inEdit; }

  virtual bool isScheduled(void) const { return false; }

  void setFocus(bool focus, bool updateLens = true);

  bool isErronous(void) const { return m_erronous; }

  virtual const TQDate& sortPostDate(void) const { return m_transaction.postDate(); }
  virtual int sortSamePostDate(void) const { return 2; }
  virtual const TQDate& sortEntryDate(void) const { return m_transaction.entryDate(); }
  virtual const TQString& sortPayee(void) const { return m_payee; }
  virtual const MyMoneyMoney& sortValue(void) const { return m_split.shares(); }
  virtual const TQString& sortNumber(void) const { return m_split.number(); }
  virtual const TQString& sortEntryOrder(void) const { return m_uniqueId; }
  virtual CashFlowDirection sortType(void) const { return m_split.shares().isNegative() ? Payment : Deposit; }
  virtual const TQString& sortCategory(void) const { return m_category; }
  virtual MyMoneySplit::reconcileFlagE sortReconcileState(void) const { return m_split.reconcileFlag(); }

  virtual const TQString& id(void) const { return m_uniqueId; }
  const MyMoneyTransaction& transaction(void) const { return m_transaction; }
  const MyMoneySplit& split(void) const { return m_split; }

  void setBalance(const MyMoneyMoney& balance) { m_balance = balance; }
  const MyMoneyMoney& balance(void) const { return m_balance; }

  virtual int rowHeightHint(void) const;

  /**
    * This method sets the general paramaters required for the painting of a cell
    * in the register. These are:
    *
    * - background color (alternating)
    * - background color (imported transaction)
    * - background color (matched transaction)
    * - background color (selected transaction)
    * - cellRect (area covering the cell)
    * - textRect (area covering the text)
    * - color of the pen to do the painting of text and lines
    *
    * @param painter pointer to the TQPainter object
    * @param row vertical index of cell in register
    * @param col horizontal index of cell in register
    * @param cellRect ref to TQRect object receiving the area information for the cell
    * @param textRect ref to TQRect object receiving the area information for the text
    * @param cg ref to TQColorGroup object receiving the color information to be used
    */
  virtual bool paintRegisterCellSetup(TQPainter* painter, int& row, int& col, TQRect& cellRect, TQRect& textRect, TQColorGroup& cg, TQBrush& brush);

  /**
    * paints the focus if the current cell defined by (@a row, @a col) has the focus.
    *
    * @param painter pointer to the TQPainter object
    * @param row vertical index of cell in register
    * @param col horizontal index of cell in register
    * @param r area covering the cell
    * @param cg the color definitions to be used
    */
  void paintRegisterCellFocus(TQPainter* painter, int row, int col, const TQRect& r, const TQColorGroup& cg);

  /**
    * paints a cell of the register for the transaction. Uses paintRegisterCellSetup(), paintRegisterCellText()
    * paintRegisterGrid(), paintRegisterIcons() and paintRegisterCellFocus() to actually do the job.
    *
    * @param painter pointer to the TQPainter object
    * @param row vertical index of cell in register
    * @param col horizontal index of cell in register
    * @param r area covering the cell
    * @param selected unused but kept for compatibility
    * @param cg the color definitions to be used
    *
    */
  virtual void paintRegisterCell(TQPainter* painter, int row, int col, const TQRect& r, bool selected, const TQColorGroup& cg);
  virtual void paintRegisterCellText(TQPainter* painter, int row, int col, const TQRect& r, const TQColorGroup& cg, int align, const TQString& txt);
  virtual void paintRegisterCellBackground(TQPainter* painter, int row, int col, const TQRect& r, const TQBrush& backgroundBrush);
  virtual void paintRegisterGrid(TQPainter* painter, int row, int col, const TQRect& r, const TQColorGroup& cg) const;
  virtual void paintRegisterIcons(TQPainter* painter, int row, int col, const TQRect& r, const TQColorGroup& cg);

  virtual void paintFormCell(TQPainter* /* painter */, int /* row */, int /* col */, const TQRect& /* r */, bool /* selected */, const TQColorGroup& /* cg */);

  virtual bool formCellText(TQString& /* txt */, int& /* align */, int /* row */, int /* col */, TQPainter* /* painter */) { return false; }
  virtual void registerCellText(TQString& /* txt */, int& /* align */, int /* row */, int /* col */, TQPainter* /* painter */) {}
  virtual int registerColWidth(int /* col */, const TQFontMetrics& /* cellFontMetrics */) { return 0; }

  /**
    * Helper method for the above method.
    */
  void registerCellText(TQString& txt, int row, int col);

  virtual int formRowHeight(int row);
  virtual int formRowHeight(void) const;

  virtual void setupForm(KMyMoneyTransactionForm::TransactionForm* form);
  virtual void setupFormPalette(TQMap<TQString, TQWidget*>& editWidgets);
  virtual void setupRegisterPalette(TQMap<TQString, TQWidget*>& editWidgets);
  virtual void loadTab(KMyMoneyTransactionForm::TransactionForm* form) = 0;

  virtual void arrangeWidgetsInForm(TQMap<TQString, TQWidget*>& editWidgets) = 0;
  virtual void arrangeWidgetsInRegister(TQMap<TQString, TQWidget*>& editWidgets) = 0;
  virtual void tabOrderInForm(TQWidgetList& tabOrderWidgets) const = 0;
  virtual void tabOrderInRegister(TQWidgetList& tabOrderWidgets) const = 0;

  virtual KMyMoneyRegister::Action actionType(void) const = 0;

  TQWidget* focusWidget(TQWidget*) const;
  void arrangeWidget(TQTable* tbl, int row, int col, TQWidget* w) const;

  bool haveNumberField(void) const;

  bool matches(const TQString&) const;

  /**
    * Checks if the mouse hovered over an area that has a tooltip associated with it.
    * The mouse position is given in relative coordinates to the @a startRow and the
    * @a row and @a col of the item are also passed as relative values.
    *
    * If a tooltip shall be shown, this method presets the rectangle @a r with the
    * area in register coordinates and @a msg with the string that will be passed
    * to TQToolTip::tip. @a true is returned in this case.
    *
    * If no tooltip is available, @a false will be returned.
    */
  virtual bool maybeTip(const TQPoint& relpos, int row, int col, TQRect& r, TQString& msg);

  /**
    * This method returns the number of register rows required for a certain
    * item in expanded (@p expanded equals @a true) or collapsed (@p expanded
    * is @a false) mode.
    *
    * @param expanded returns number of maximum rows required for this item to
    *                 display all information (used for ledger lens and register
    *                 edit mode) or the minimum number of rows required.
    * @return number of rows required for mode selected by @p expanded
    */
  virtual int numRowsRegister(bool expanded) const = 0;

  virtual int numRowsRegister(void) const = 0;

  void leaveEditMode(void);
  void startEditMode(void);

  /**
    * This method creates an editor for the transaction
    */
  virtual TransactionEditor* createEditor(TransactionEditorContainer* regForm, const KMyMoneyRegister::SelectedTransactions& list, const TQDate& lastPostDate) = 0;

  virtual void setVisible(bool visible);

  virtual void setShowBalance(bool showBalance);

  /**
    * Return information if @a row should be shown (@a true )
    * or hidden (@a false ) in the form. Default is true.
    */
  virtual bool showRowInForm(int row) const { Q_UNUSED(row) return true; }

  /**
    * Control visibility of @a row in the transaction form.
    * Only row 0 has an effect, others return @a true.
    */
  virtual void setShowRowInForm(int row, bool show) { Q_UNUSED(row); Q_UNUSED(show) }

  virtual void setReducedIntensity(bool reduced) { m_reducedIntensity = reduced; }

protected:
  virtual void markAsErronous(TQPainter* p, int row, int col, const TQRect& r);
  virtual void markAttachment(TQPainter* painter, int row, int col, const TQRect& r);

  /**
    * This method converts m_split.reconcileFlag() into a readable string
    *
    * @param text Return textual representation e.g. "Cleared" (@a true) or just
    *             a flag e.g. "C" (@a false). Defaults to textual representation.
    * @return Textual representation or flag as selected via @p text of the
    *         reconciliation state of the split
    */
  TQString reconcileState(bool text = true) const;

  /**
    * Helper method to reduce a multi line memo text into a single line.
    *
    * @param txt TQString that will receive the single line memo text
    * @param split const reference to the split to take the memo from
    */
  void singleLineMemo(TQString& txt, const MyMoneySplit& split) const;

  virtual void setupPalette(const TQPalette& palette, TQMap<TQString, TQWidget*>& editWidgets);

protected:
  MyMoneyTransaction      m_transaction;
  MyMoneySplit            m_split;
  MyMoneyAccount          m_account;
  MyMoneyMoney            m_balance;
  TQTable*                 m_form;
  TQString                 m_category;
  TQString                 m_payee;
  TQString                 m_payeeHeader;
  TQString                 m_categoryHeader;
  TQString                 m_splitCurrencyId;
  TQString                 m_uniqueId;
  int                     m_formRowHeight;
  bool                    m_selected;
  bool                    m_focus;
  bool                    m_erronous;
  bool                    m_inEdit;
  bool                    m_inRegisterEdit;
  bool                    m_showBalance;
  bool                    m_reducedIntensity;
};

class StdTransaction : public Transaction
{
public:
  StdTransaction(Register* parent, const MyMoneyTransaction& transaction, const MyMoneySplit& split, int uniqueId);
  virtual ~StdTransaction() {}

  virtual const char* className(void) { return "StdTransaction"; }

  bool formCellText(TQString& txt, int& align, int row, int col, TQPainter* painter = 0);
  void registerCellText(TQString& txt, int& align, int row, int col, TQPainter* painter = 0);

  int registerColWidth(int col, const TQFontMetrics& cellFontMetrics);
  void setupForm(KMyMoneyTransactionForm::TransactionForm* form);
  void loadTab(KMyMoneyTransactionForm::TransactionForm* form);

  int numColsForm(void) const { return 4; }

  void arrangeWidgetsInForm(TQMap<TQString, TQWidget*>& editWidgets);
  void arrangeWidgetsInRegister(TQMap<TQString, TQWidget*>& editWidgets);
  void tabOrderInForm(TQWidgetList& tabOrderWidgets) const;
  void tabOrderInRegister(TQWidgetList& tabOrderWidgets) const;
  KMyMoneyRegister::Action actionType(void) const;

  int numRowsRegister(bool expanded) const;

  /**
    * Provided for internal reasons. No API change. See RegisterItem::numRowsRegister()
    */
  int numRowsRegister(void) const { return RegisterItem::numRowsRegister(); }

  TransactionEditor* createEditor(TransactionEditorContainer* regForm, const KMyMoneyRegister::SelectedTransactions& list, const TQDate& lastPostDate);

  /**
    * Return information if @a row should be shown (@a true )
    * or hidden (@a false ) in the form. Default is true.
    */
  virtual bool showRowInForm(int row) const;

  /**
    * Control visibility of @a row in the transaction form.
    * Only row 0 has an effect, others return @a true.
    */
  virtual void setShowRowInForm(int row, bool show);

protected:
  void setupFormHeader(const TQString& id);

private:
  bool m_showAccountRow;
};

class InvestTransaction : public Transaction
{
public:
  InvestTransaction(Register* parent, const MyMoneyTransaction& transaction, const MyMoneySplit& split, int uniqueId);
  virtual ~InvestTransaction() {}

  virtual const TQString& sortSecurity(void) const { return m_security.name(); }
  virtual const char* className(void) { return "InvestTransaction"; }

  // virtual void paintRegisterCell(TQPainter* painter, int row, int col, const TQRect& r, bool selected, const TQColorGroup& cg);

  bool formCellText(TQString& txt, int& align, int row, int col, TQPainter* painter = 0);
  void registerCellText(TQString& txt, int& align, int row, int col, TQPainter* painter = 0);

  int registerColWidth(int col, const TQFontMetrics& cellFontMetrics);
  void setupForm(KMyMoneyTransactionForm::TransactionForm* form);

  /**
    * provide NOP here as the investment transaction form does not supply a tab
    */
  void loadTab(KMyMoneyTransactionForm::TransactionForm* /* form */) {}

  int numColsForm(void) const { return 4; }

  void arrangeWidgetsInForm(TQMap<TQString, TQWidget*>& editWidgets);
  void arrangeWidgetsInRegister(TQMap<TQString, TQWidget*>& editWidgets);
  void tabOrderInForm(TQWidgetList& tabOrderWidgets) const;
  void tabOrderInRegister(TQWidgetList& tabOrderWidgets) const;
  KMyMoneyRegister::Action actionType(void) const { return KMyMoneyRegister::ActionNone; }

  int numRowsRegister(bool expanded) const;

  /**
    * Provided for internal reasons. No API change. See RegisterItem::numRowsRegister()
    */
  int numRowsRegister(void) const { return RegisterItem::numRowsRegister(); }

  TransactionEditor* createEditor(TransactionEditorContainer* regForm, const KMyMoneyRegister::SelectedTransactions& list, const TQDate& lastPostDate);

  void splits(MyMoneySplit& assetAccountSplit, TQValueList<MyMoneySplit>& interestSplits, TQValueList<MyMoneySplit>& feeSplits) const;

protected:
  bool haveShares(void) const;
  bool haveFees(void) const;
  bool haveInterest(void) const;
  bool havePrice(void) const;
  bool haveAmount(void) const;
  bool haveAssetAccount(void) const;
  bool haveSplitRatio(void) const;

  /**
    * Returns textual representation of the activity identified
    * by @p type.
    *
    * @param txt reference to TQString where to store the result
    * @param type activity represented as investTransactionTypeE
    */
  void activity(TQString& txt, MyMoneySplit::investTransactionTypeE type) const;

private:
  TQValueList<MyMoneySplit>  m_feeSplits;
  TQValueList<MyMoneySplit>  m_interestSplits;
  MyMoneySplit              m_assetAccountSplit;
  MyMoneySecurity           m_security;
  MyMoneySecurity           m_currency;
  MyMoneySplit::investTransactionTypeE    m_transactionType;
  TQString                   m_feeCategory;
  TQString                   m_interestCategory;
  MyMoneyMoney              m_feeAmount;
  MyMoneyMoney              m_interestAmount;
  MyMoneyMoney              m_totalAmount;
};

}; // namespace

#endif
// vim:cin:si:ai:et:ts=2:sw=2:

