/***************************************************************************
                          mymoneykeyvaluecontainer.cpp
                             -------------------
    begin                : Sun Nov 10 2002
    copyright            : (C) 2002-2005 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneykeyvaluecontainer.h>
#include <kmymoney/mymoneyexception.h>

MyMoneyKeyValueContainer::MyMoneyKeyValueContainer()
{
}

MyMoneyKeyValueContainer::MyMoneyKeyValueContainer(const TQDomElement& node)
{
  if(!node.isNull()) {
    if("KEYVALUEPAIRS" != node.tagName())
      throw new MYMONEYEXCEPTION("Node was not KEYVALUEPAIRS");

    m_kvp.clear();

    TQDomNodeList nodeList = node.elementsByTagName("PAIR");
    for(unsigned int i = 0; i < nodeList.count(); ++i) {
      const TQDomElement& el(nodeList.item(i).toElement());
      m_kvp[el.attribute("key")] = el.attribute("value");
    }
  }
}

MyMoneyKeyValueContainer::~MyMoneyKeyValueContainer()
{
}

const TQString& MyMoneyKeyValueContainer::value(const TQString& key) const
{
  TQMap<TQString, TQString>::ConstIterator it;

  it = m_kvp.find(key);
  if(it != m_kvp.end())
    return (*it);
  return TQString::null;
}

void MyMoneyKeyValueContainer::setValue(const TQString& key, const TQString& value)
{
  m_kvp[key] = value;
}


void MyMoneyKeyValueContainer::setPairs(const TQMap<TQString, TQString>& list)
{
  m_kvp = list;
}

void MyMoneyKeyValueContainer::deletePair(const TQString& key)
{
  TQMap<TQString, TQString>::Iterator it;

  it = m_kvp.find(key);
  if(it != m_kvp.end())
    m_kvp.remove(it);
}

void MyMoneyKeyValueContainer::clear(void)
{
  m_kvp.clear();
}

bool MyMoneyKeyValueContainer::operator == (const MyMoneyKeyValueContainer& right) const
{
  TQMap<TQString, TQString>::ConstIterator it_a, it_b;

  it_a = m_kvp.begin();
  it_b = right.m_kvp.begin();

  while(it_a != m_kvp.end() && it_b != right.m_kvp.end()) {
    if(it_a.key() != it_b.key()
    || (((*it_a).length() != 0 || (*it_b).length() != 0) && *it_a != *it_b))
      return false;
    ++it_a;
    ++it_b;
  }

  return (it_a == m_kvp.end() && it_b == right.m_kvp.end());
}

void MyMoneyKeyValueContainer::writeXML(TQDomDocument& document, TQDomElement& parent) const
{
  if(m_kvp.count() != 0) {
    TQDomElement el = document.createElement("KEYVALUEPAIRS");

    TQMap<TQString, TQString>::ConstIterator it;
    for(it = m_kvp.begin(); it != m_kvp.end(); ++it)
    {
      TQDomElement pair = document.createElement("PAIR");
      pair.setAttribute("key", it.key());
      pair.setAttribute("value", it.data());
      el.appendChild(pair);
    }

    parent.appendChild(el);
  }
}
