/***************************************************************************
                          kstartuplogo.h
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTARTUPLOGO_H
#define KSTARTUPLOGO_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqwidget.h>
#include <tqguardedptr.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <ksplashscreen.h>

// ----------------------------------------------------------------------------
// Project Includes

class TDEStartupSplash : public KSplashScreen
{
  Q_OBJECT
  
  public:
    TDEStartupSplash(const TQPixmap &pixmap, WFlags f = 0);
    ~TDEStartupSplash();
    void message( const TQString &message, int alignment = AlignLeft, const TQColor &color = black);

  protected:
    void drawContents(TQPainter *p);

  private:
    class Private;
    Private *d;
};

// Simple class that just shows a picture
class TDEStartupLogo : public TQObject
{
  Q_OBJECT
  
public:
  TDEStartupLogo();
  ~TDEStartupLogo();

private:
  TQGuardedPtr<TQWidget>  m_splash;
};

#endif
