/***************************************************************************
                          kmymoneyonlinequoteconfig.cpp  -  description
                             -------------------
    begin                : Thu Dec 30 2004
    copyright            : (C) 2004 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

#include <tqregexp.h>
#include <tqcheckbox.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kiconloader.h>
#include <kguiitem.h>
#include <kpushbutton.h>
#include <klineedit.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "ksettingsonlinequotes.h"
#include "kmymoney2/converter/webpricequote.h"

KSettingsOnlineQuotes::KSettingsOnlineQuotes(TQWidget *parent, const char *name )
  : KSettingsOnlineQuotesDecl(parent, name)
{
  TQStringList groups = WebPriceQuote::quoteSources();

  loadList(true /*updateResetList*/);

  m_updateButton->setEnabled(false);

  TDEIconLoader* il = TDEGlobal::iconLoader();
  KGuiItem updateButtenItem( i18n("&Update" ),
                    TQIconSet(il->loadIcon("button_ok", TDEIcon::Small, TDEIcon::SizeSmall)),
                    i18n("Accepts the entered data and stores it"),
                    i18n("Use this to accept the modified data."));
  m_updateButton->setGuiItem(updateButtenItem);

  KGuiItem deleteButtenItem( i18n( "&Delete" ),
                      TQIconSet(il->loadIcon("edit-delete", TDEIcon::Small, TDEIcon::SizeSmall)),
                      i18n("Delete the selected source entry"),
                      i18n("Use this to delete the selected online source entry"));
  m_deleteButton->setGuiItem(deleteButtenItem);

  KGuiItem newButtenItem( i18n( "&New..." ),
                      TQIconSet(il->loadIcon("document-new", TDEIcon::Small, TDEIcon::SizeSmall)),
                      i18n("Create a new source entry for online quotes"),
                      i18n("Use this to create a new entry for online quotes"));
  m_newButton->setGuiItem(newButtenItem);

  connect(m_updateButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotUpdateEntry()));
  connect(m_newButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotNewEntry()));

  connect(m_quoteSourceList, TQT_SIGNAL(selectionChanged(TQListViewItem*)), this, TQT_SLOT(slotLoadWidgets(TQListViewItem*)));
  connect(m_quoteSourceList, TQT_SIGNAL(clicked(TQListViewItem*)), this, TQT_SLOT(slotLoadWidgets(TQListViewItem*)));
  connect(m_quoteSourceList, TQT_SIGNAL(itemRenamed(TQListViewItem*,const TQString&,int)), this, TQT_SLOT(slotEntryRenamed(TQListViewItem*,const TQString&,int)));

  connect(m_editURL, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotEntryChanged()));
  connect(m_editSymbol, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotEntryChanged()));
  connect(m_editDate, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotEntryChanged()));
  connect(m_editDateFormat, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotEntryChanged()));
  connect(m_editPrice, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotEntryChanged()));
  connect(m_skipStripping, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(slotEntryChanged()));

  // FIXME deleting a source is not yet implemented
  m_deleteButton->setEnabled(false);
}

void KSettingsOnlineQuotes::loadList(const bool updateResetList)
{
  TQStringList groups = WebPriceQuote::quoteSources();

  if(updateResetList)
    m_resetList.clear();
  m_quoteSourceList->clear();
  TQStringList::Iterator it;
  for(it = groups.begin(); it != groups.end(); ++it) {
    new TQListViewItem(m_quoteSourceList, *it);
    if(updateResetList)
      m_resetList += WebPriceQuoteSource(*it);
  }

  TQListViewItem* first = m_quoteSourceList->firstChild();
  if(first)
    m_quoteSourceList->setSelected(first, true);
  slotLoadWidgets(first);

  m_newButton->setEnabled(m_quoteSourceList->findItem(i18n("New Quote Source"), 0) == 0);
}

void KSettingsOnlineQuotes::resetConfig(void)
{
  TQStringList::ConstIterator it;
  TQStringList groups = WebPriceQuote::quoteSources();

  // delete all currently defined entries
  for(it = groups.begin(); it != groups.end(); ++it) {
    WebPriceQuoteSource(*it).remove();
  }

  // and write back the one's from the reset list
  TQValueList<WebPriceQuoteSource>::ConstIterator itr;
  for(itr = m_resetList.begin(); itr != m_resetList.end(); ++itr) {
    (*itr).write();
  }

  loadList();
}

void KSettingsOnlineQuotes::slotLoadWidgets(TQListViewItem* item)
{
  m_editURL->setEnabled(true);
  m_editSymbol->setEnabled(true);
  m_editPrice->setEnabled(true);
  m_editDate->setEnabled(true);
  m_editDateFormat->setEnabled(true);
  m_skipStripping->setEnabled(true);
  m_editURL->setText(TQString());
  m_editSymbol->setText(TQString());
  m_editPrice->setText(TQString());
  m_editDate->setText(TQString());
  m_editDateFormat->setText(TQString());

  if(item) {
    m_currentItem = WebPriceQuoteSource(item->text(0));
    m_editURL->setText(m_currentItem.m_url);
    m_editSymbol->setText(m_currentItem.m_sym);
    m_editPrice->setText(m_currentItem.m_price);
    m_editDate->setText(m_currentItem.m_date);
    m_editDateFormat->setText(m_currentItem.m_dateformat);
    m_skipStripping->setChecked(m_currentItem.m_skipStripping);
  } else {
    m_editURL->setEnabled(false);
    m_editSymbol->setEnabled(false);
    m_editPrice->setEnabled(false);
    m_editDate->setEnabled(false);
    m_editDateFormat->setEnabled(false);
    m_skipStripping->setEnabled(false);
  }

  m_updateButton->setEnabled(false);

}

void KSettingsOnlineQuotes::slotEntryChanged(void)
{
  bool modified = m_editURL->text() != m_currentItem.m_url
               || m_editSymbol->text() != m_currentItem.m_sym
               || m_editDate->text() != m_currentItem.m_date
               || m_editDateFormat->text() != m_currentItem.m_dateformat
               || m_editPrice->text() != m_currentItem.m_price
               || m_skipStripping->isChecked() != m_currentItem.m_skipStripping;

  m_updateButton->setEnabled(modified);
}

void KSettingsOnlineQuotes::slotUpdateEntry(void)
{
  m_currentItem.m_url = m_editURL->text();
  m_currentItem.m_sym = m_editSymbol->text();
  m_currentItem.m_date = m_editDate->text();
  m_currentItem.m_dateformat = m_editDateFormat->text();
  m_currentItem.m_price = m_editPrice->text();
  m_currentItem.m_skipStripping = m_skipStripping->isChecked();
  m_currentItem.write();
  slotEntryChanged();
}

void KSettingsOnlineQuotes::slotNewEntry(void)
{
  WebPriceQuoteSource newSource(i18n("New Quote Source"));
  newSource.write();
  loadList();
  TQListViewItem* item = m_quoteSourceList->findItem(i18n("New Quote Source"), 0);
  if(item) {
    m_quoteSourceList->setSelected(item, true);
    slotLoadWidgets(item);
  }
}

void KSettingsOnlineQuotes::slotEntryRenamed(TQListViewItem* item, const TQString& text, int /* col */)
{
  int nameCount = 0;
  TQListViewItemIterator it(m_quoteSourceList);
  while(it.current()) {
    if(it.current()->text(0) == text)
      ++nameCount;
    ++it;
  }

  // Make sure we get a non-empty and unique name
  if(text.length() > 0 && nameCount == 1) {
    m_currentItem.rename(text);
  } else {
    item->setText(0, m_currentItem.m_name);
  }
  m_newButton->setEnabled(m_quoteSourceList->findItem(i18n("New Quote Source"), 0) == 0);
}

#include "ksettingsonlinequotes.moc"
