/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITSTATE_H
#define KMFRULEOPTIONEDITSTATE_H

#include "../../core/kmfruleoptioneditinterface.h"

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>
class TDEInstance;
namespace KMF {
class IPTRule;
class KMFRuleEditorState;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditState : public KMFRuleOptionEditInterface {
	Q_OBJECT
  
public:
	KMFRuleOptionEditState(TQObject *parent = 0, const char *name = 0);

	~KMFRuleOptionEditState();
	void loadRule( IPTRule* rule );	
	TQWidget* editWidget();
	const TQString& optionEditName() const;
	const TQString& description() const;

private slots:
	void slotShowOverview();

private:
	KMFRuleEditorState *m_edit;
	IPTRule *m_rule;
	
};



class KMFRuleOptionEditStateFactory : public KLibFactory {
	Q_OBJECT
  
public:
	KMFRuleOptionEditStateFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditStateFactory() {
/* 		delete s_instance; */
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = TQOBJECT_OBJECT_NAME_STRING,
	                               const TQStringList &args = TQStringList() );
	/*     static TDEInstance* instance(); */

/*private:
	static TDEInstance* s_instance;*/
};

}







#endif
