/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "uptimesrc.h"
#include <tqtextstream.h> 
#include <tdelocale.h>

UptimeSrc::UptimeSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this, 30000){ // 30 seconds
	mEnabled = false; // disable this source by default to to save kicker space
	mID = "Uptime";
	mName = mID;
	mDescription = i18n("This source is provided by /proc/uptime.");
}

UptimeSrc::~UptimeSrc(){
}

std::list<Source*>UptimeSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQFile uptimeFile("/proc/uptime" );
	if(uptimeFile.open(IO_ReadOnly))
		list.push_back(new UptimeSrc(inParent, uptimeFile));
	return list;
}

TQString UptimeSrc::fetchValue(){
	TQString s = "n/a";
	int secs;
	if(mSourceFile.open(IO_ReadOnly)) {
		TQTextStream stream( &mSourceFile );
		stream >> secs;
		
        //TQString seconds = TQString::number(secs % 60).rightJustify(2, '0');
		TQString minutes = TQString::number(secs / 60 % 60).rightJustify(2, '0');
		TQString hours = TQString::number(secs / 3600 % 24).rightJustify(2, '0');
		TQString days = TQString::number(secs / 86400);
		if(days != "0")
			s = mTimeFormatLong.arg(days).arg(hours).arg(minutes);
		else
			s = mTimeFormatShort.arg(hours).arg(minutes);
        mSourceFile.close();
	}
	return s;
}

void UptimeSrc::realizeWidget() {
    LabelSource::realizeWidget();
    mTimeFormatLong = i18n("%1d %2:%3");
    mTimeFormatShort = i18n("%1:%2");
}
