/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "sysfreqsrc.h"
#include <tqtextstream.h> 
#include <tqfile.h>
#include <tqdir.h>
#include <tdelocale.h>

SysFreqSrc::SysFreqSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "cpufreq" + mSourceFile.name().section( '/', -3, -3, TQString::SectionSkipEmpty ).remove("cpu");
	mName = mID;
	mDescription = i18n("This source is provided by the Linux kernel cpufreq subsystem.");
}

SysFreqSrc::~SysFreqSrc(){
}

std::list<Source*>SysFreqSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;

	TQDir cpuDir( "/sys/devices/system/cpu" );
	if ( cpuDir.exists() ){
		cpuDir.setFilter( TQDir::Dirs | TQDir::NoSymLinks );
		cpuDir.setSorting( TQDir::Name);
		for ( unsigned int i = 0; i < cpuDir.count(); i++ ){
			if(cpuDir[i].startsWith("cpu")){
				TQFile sysFreqFile(cpuDir.canonicalPath() + "/" + cpuDir[i] + "/cpufreq/scaling_cur_freq");
				if(sysFreqFile.open(IO_ReadOnly))
					list.push_back(new SysFreqSrc(inParent, sysFreqFile));
			}
		}
	}
	return list;
}

TQString SysFreqSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream(&mSourceFile);
		s = KHzinHumanReadable(textStream.readLine().toUInt());
		mSourceFile.close();
	}
	return s;
}

