/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef IBMACPITHERMALSRC_H
#define IBMACPITHERMALSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <tqfile.h>
#include <list>

/**
 * IBMACPIThermalSrc reads temperature values from /proc/acpi/ibm/thermal
 * which is provided by the ibm-acpi kernel module.
 */
class IBMACPIThermalSrc : public LabelSource {
	Q_OBJECT
	 //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File and index
	 */
	IBMACPIThermalSrc(TQWidget* inParent, const TQFile& inSourceFile, unsigned int inIndex);
	virtual ~IBMACPIThermalSrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(TQWidget* inParent);
	
	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual TQString fetchValue();

private:
	/**
	 * Returns the name (such as CPU, GPU, ...) of the sensor according to a given index
	 */
	static TQString index2Name(unsigned int inIndex);

	/**
	 * the index of the source in /proc/acpi/ibm/thermal
	 */
	unsigned int mIndex;

	/**
	 * The file from which the value is read
	 */
	TQFile mSourceFile;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //IBMACPITHERMALSRC_H
