/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "ibmacpithermalsrc.h"
#include <tqtextstream.h> 
#include <tqfile.h>
#include <tdelocale.h>

IBMACPIThermalSrc::IBMACPIThermalSrc(TQWidget* inParent, const TQFile& inSourceFile, unsigned int inIndex):
		LabelSource(inParent),
		mIndex(inIndex),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	//mName = mName.setNum(inIndex+1).prepend("IBM");
	mID = IBMACPIThermalSrc::index2Name(inIndex);
	mName = mID;
	mDescription = i18n("This source is provided by the ACPI driver for IBM ThinkPads.");
}

IBMACPIThermalSrc::~IBMACPIThermalSrc(){
}

std::list<Source*>IBMACPIThermalSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQFile ibmFile( "/proc/acpi/ibm/thermal" );
	if(ibmFile.open(IO_ReadOnly)){
		TQTextStream textStream( &ibmFile );
		TQString s = textStream.readLine();
		ibmFile.close();
		s = s.remove("temperatures:");
		TQStringList entries = TQStringList::split(' ' ,s);
		for ( unsigned int i = 0; i < entries.size(); i++ ){
			if(!entries[i].startsWith("-") && !entries[i].startsWith("0"))
				list.push_back(new IBMACPIThermalSrc(inParent, ibmFile, i));	
		}
	}
	return list;
}

TQString IBMACPIThermalSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream( &mSourceFile );
		s = textStream.readLine();
		mSourceFile.close();
		s = s.section(':', 1, 1).section(' ', mIndex, mIndex, TQString::SectionSkipEmpty).stripWhiteSpace();
		s = formatTemperature(s);	
	}
	return s;
}

TQString IBMACPIThermalSrc::index2Name(unsigned int inIndex){
	switch(inIndex){
	case 0:
		return "CPU";
	case 1:
		return "MiniPCI";
	case 2:
		return "HDD";
	case 3:
		return "GPU";
	case 4:
		return "Battery1";
	case 6:
		return "Battery2";
	default:
		return "ibmacpi" + TQString().setNum(inIndex);
	}
}
