/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "sourcelistitem.h"
#include <tqcheckbox.h> 

//#include <kdebug.h>

SourceListItem::SourceListItem(Source* inSource, TQCheckListItem* inParent, Type tt):
		TQCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQCheckListItem* inParent, TQListViewItem* after, Type tt):
		TQCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListViewItem* inParent, Type tt):
		TQCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListViewItem* inParent, TQListViewItem* after, Type tt):
		TQCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListView* inParent, Type tt):
		TQCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListView* inParent, TQListViewItem* after, Type tt):
		TQCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListViewItem* inParent, const TQPixmap& p):
		TQCheckListItem(inParent, inSource->getName(), p){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, TQListView* inParent, const TQPixmap& p):
		TQCheckListItem(inParent, inSource->getName(), p){
	mSource = inSource;
	initItem();
}

SourceListItem::~SourceListItem(){
}

void SourceListItem::initItem(){
	//setText(1, mSource->getName());
	//item->setText(2, source->getDescription());

	connect(mSource, TQT_SIGNAL(enabledChanged(bool, Source*)), this, TQT_SLOT(setEnabled(bool)));
	setOn(mSource->isEnabled());
}

void SourceListItem::updateText() {
    setText(0, mSource->getName());
}

Source* SourceListItem::getSource(){
	return mSource;
}

void SourceListItem::setName(const TQString& inName){
	setText(1, inName);
}

void SourceListItem::setEnabled(bool inEnabled){
	mSource->setMaybeEnabled(inEnabled);
}

void SourceListItem::stateChange(bool inOn){
	TQCheckListItem::stateChange(inOn);
	setEnabled(inOn);
}
