/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "configfilter.h"
#include "filtereditor.h"

#include "misc/config.h"
#include "misc.h"

#include <tdelistview.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <tdemessagebox.h>
#include <klineeditdlg.h>

#include <klineedit.h>
#include <kcolorbutton.h>
#include <kdialogbase.h>

#include <ntqcheckbox.h>
#include <ntqlayout.h>
#include <ntqtabwidget.h>

using namespace KFTPGrabberBase;

namespace KFTPWidgets {

ConfigFilter::ConfigFilter(TQWidget *parent, const char *name)
 : TQWidget(parent, name)
{
  // Create the main widget
  TQVBoxLayout *t = new TQVBoxLayout(this, 0, 0);
  
  m_editorLayout = new ConfigFilterLayout(this);
  t->addWidget(m_editorLayout);
  
  m_filterEditor = new FilterEditor(this);
  m_editorLayout->tabWidget->insertTab(m_filterEditor, i18n("Filters"), 0);
  m_editorLayout->tabWidget->setCurrentPage(0);
  m_editorLayout->tabWidget->setMargin(KDialog::spacingHint());

  loadSettings();

  // Connect the slots
  connect(m_editorLayout->addExtButton, SIGNAL(clicked()), this, SLOT(slotAddAscii()));
  connect(m_editorLayout->removeExtButton, SIGNAL(clicked()), this, SLOT(slotRemoveAscii()));
}

void ConfigFilter::loadSettings()
{
  m_filterEditor->reset();
  asciiLoadExtensions();
}

void ConfigFilter::saveSettings()
{
  // Save the settings
  KFTPCore::Config::setAsciiList(asciiToStringList());
}

void ConfigFilter::slotAddAscii()
{
  if (!m_editorLayout->newExtension->text().stripWhiteSpace().isEmpty()) {
    new TQListViewItem(m_editorLayout->extensionList, m_editorLayout->newExtension->text().stripWhiteSpace());
    m_editorLayout->newExtension->clear();
  }
}

void ConfigFilter::slotRemoveAscii()
{
  if (!m_editorLayout->extensionList->selectedItem())
    return;

  delete m_editorLayout->extensionList->selectedItem();
}

void ConfigFilter::asciiLoadExtensions()
{
  // Load the ascii extensions
  m_editorLayout->extensionList->clear();
  TQStringList p_extensions = KFTPCore::Config::asciiList();

  TQStringList::iterator end( p_extensions.end() );
  for (TQStringList::iterator i( p_extensions.begin() ); i != end; ++i) {
    new TQListViewItem(m_editorLayout->extensionList, (*i));
  }

}

TQStringList ConfigFilter::asciiToStringList()
{
  TQStringList p_extensions;
  TQListViewItem *i = m_editorLayout->extensionList->firstChild();
  while (i) {
    p_extensions.append(i->text(0));

    i = i->itemBelow();
  }

  return p_extensions;
}

}
#include "configfilter.moc"
