/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2006 by the KFTPGrabber developers
 * Copyright (C) 2003-2006 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPENGINEFTPSOCKET_H
#define KFTPENGINEFTPSOCKET_H

#include <kstreamsocket.h>
#include <kserversocket.h>
#include <kssl.h>

#include <ntqguardedptr.h>
#include <ntqfile.h>

#include "speedlimiter.h"
#include "socket.h"

namespace KFTPEngine {

class FtpDirectoryParser;
class Ssl;

/**
 * @author Jernej Kos <kostko@jweb-network.net>
 */
class FtpSocket : public KNetwork::KStreamSocket, public Socket, public SpeedLimiterItem
{
Q_OBJECT
friend class Commands::Base;
friend class FtpCommandConnect;
friend class FtpCommandNegotiateData;
friend class FtpCommandList;
public:
    FtpSocket(Thread *thread);
    ~FtpSocket();
    
    void protoConnect(const KURL &url);
    void protoDisconnect();
    void protoAbort();
    void protoGet(const KURL &source, const KURL &destination);
    void protoPut(const KURL &source, const KURL &destination);
    void protoRemove(const KURL &path);
    void protoRename(const KURL &source, const KURL &destination);
    void protoChmodSingle(const KURL &path, int mode);
    void protoMkdir(const KURL &path);
    void protoList(const KURL &path);
    void protoRaw(const TQString &raw);
    void protoSiteToSite(Socket *socket, const KURL &source, const KURL &destination);
    void protoKeepAlive();
    
    void changeWorkingDirectory(const TQString &path, bool shouldCreate = false);
    
    void poll();
    
    int features() { return SF_FXP_TRANSFER | SF_RAW_COMMAND; }
    
    bool isConnected() { return m_login; }
    bool isEncrypted() { return isConnected() && getConfigInt("ssl"); }
    
    void setSslClientCertificate(KSSLPKCS12 *certificate) { m_clientCert = certificate; }
    
    bool isResponse(const TQString &code);
    TQString getResponse() { return m_response; }
    bool isMultiline() { return !m_multiLineCode.isEmpty(); }
    
    void sendCommand(const TQString &command);
    void resetCommandClass(ResetCode code = Ok);
    
    void setupPassiveTransferSocket(const TQString &host, int port);
    KNetwork::TDESocketAddress setupActiveTransferSocket();
    
    TQFile *getTransferFile() { return &m_transferFile; }
    
    void checkTransferEnd();
    void checkTransferStart();
    void resetTransferStart() { m_transferStart = 0; }
protected:
    void processBuffer();
    void parseLine(const TQString &line);
    void variableBufferUpdate(TQ_LONG size);
    void closeDataTransferSocket();
    void initializeTransferSocket();
    void transferCompleted();
private:
    bool m_login;
    
    TQString m_buffer;
    TQString m_multiLineCode;
    TQString m_response;
    
    TQGuardedPtr<KNetwork::KStreamSocket> m_transferSocket;
    TQGuardedPtr<KNetwork::TDEServerSocket> m_serverSocket;
    FtpDirectoryParser *m_directoryParser;
    
    char m_controlBuffer[1024];
    
    TQFile m_transferFile;
    char *m_transferBuffer;
    int m_transferBufferSize;
    int m_transferStart;
    int m_transferEnd;
    
    bool m_transferConnecting;
    bool m_controlConnecting;
    
    Ssl *m_controlSsl;
    Ssl *m_dataSsl;
    KSSLPKCS12 *m_clientCert;
protected slots:
    void slotConnected();
    void slotControlTryRead();
    void slotError();
    
    void slotDataAccept(KNetwork::KStreamSocket *socket);
    void slotDataConnected();
    void slotDataTryRead();
    void slotDataTryWrite();
};

}

#endif
