/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef KERRYAPP_H
#define KERRYAPP_H

#include <kuniqueapplication.h>
#include <ksystemtray.h>
#include <kglobalaccel.h>

#define kerryApp ((KerryApplication*)tqApp)
#define MAX_HISTORY_ITEMS 10

class kerry;
class TDECmdLineArgs;
class SearchDlg;
class KHelpMenu;
class TDEAboutData;
class TDEProcess;

class KerryApplication : public KUniqueApplication
{
    Q_OBJECT
  

  public:
    KerryApplication();
    ~KerryApplication();
    void init(const TDEAboutData* about);
    int newInstance();
    void search(const TQString&);

  protected:
    SearchDlg* hitListWindow;
    KSystemTray* sysTrayIcon;

  protected slots:
    void searchPrimarySelection();
    void clearHistory();
    void configure();
    void configChanged();
    void aboutToShowSysTrayMenu();
    void historySelected(int);
    void quitKerry();
    void checkBeagleBuildIndex();

  private:
    TDEGlobalAccel *globalKeys;
};

#endif // KERRYAPP_H
