/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef PGMSETTINGS_H
#define PGMSETTINGS_H

#include <ntqtabdialog.h>

class TQButtonGroup;
class TQLineEdit;


class ChooseDriver : public TQWidget
{
public:
    ChooseDriver(TQWidget* parent);
    void setDebuggerCmd(const TQString& cmd);
    TQString debuggerCmd() const;
protected:
    TQLineEdit* m_debuggerCmd;
};


class OutputSettings : public TQWidget
{
    Q_OBJECT
public:
    OutputSettings(TQWidget* parent);
    void setTTYLevel(int l);
    int ttyLevel() const { return m_ttyLevel; }
protected:
    int m_ttyLevel;
    TQButtonGroup* m_group;
protected slots:
    void slotLevelChanged(int);
};


class ProgramSettings : public TQTabDialog
{
    Q_OBJECT
public:
    ProgramSettings(TQWidget* parent, TQString exeName, bool modal = true);

public:
    ChooseDriver m_chooseDriver;
    OutputSettings m_output;
};

#endif
