/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef GDBDRIVER_H
#define GDBDRIVER_H

#include "dbgdriver.h"


class GdbDriver : public DebuggerDriver
{
    Q_OBJECT
public:
    GdbDriver();
    ~GdbDriver();
    
    virtual TQString driverName() const;
    virtual TQString defaultInvocation() const;
    virtual TQStringList boolOptionList() const;
    void setDefaultInvocation(TQString cmd) { m_defaultCmd = cmd; }
    static TQString defaultGdb();
    virtual bool startup(TQString cmdStr);
    virtual void commandFinished(CmdQueueItem* cmd);
    virtual CmdQueueItem* executeCmd(DbgCommand,
				     bool clearLow = false);
    virtual CmdQueueItem* executeCmd(DbgCommand, TQString strArg,
				     bool clearLow = false);
    virtual CmdQueueItem* executeCmd(DbgCommand, int intArg,
				     bool clearLow = false);
    virtual CmdQueueItem* executeCmd(DbgCommand, TQString strArg, int intArg,
				     bool clearLow = false);
    virtual CmdQueueItem* executeCmd(DbgCommand, TQString strArg1, TQString strArg2,
				     bool clearLow = false);
    virtual CmdQueueItem* executeCmd(DbgCommand, int intArg1, int intArg2,
				     bool clearLow = false);
    virtual CmdQueueItem* queueCmd(DbgCommand,
				   QueueMode mode);
    virtual CmdQueueItem* queueCmd(DbgCommand, TQString strArg,
				   QueueMode mode);
    virtual CmdQueueItem* queueCmd(DbgCommand, int intArg,
				   QueueMode mode);
    virtual CmdQueueItem* queueCmd(DbgCommand, TQString strArg, int intArg,
				   QueueMode mode);
    virtual CmdQueueItem* queueCmd(DbgCommand, TQString strArg1, TQString strArg2,
				   QueueMode mode);

    virtual void terminate();
    virtual void detachAndTerminate();
    virtual void interruptInferior();
    virtual void setPrintTQStringDataCmd(const char* cmd);
    virtual ExprValue* parseTQCharArray(const char* output, bool wantErrorValue, bool qt3like);
    virtual void parseBackTrace(const char* output, std::list<StackFrame>& stack);
    virtual bool parseFrameChange(const char* output, int& frameNo,
				  TQString& file, int& lineNo, DbgAddr& address);
    virtual bool parseBreakList(const char* output, std::list<Breakpoint>& brks);
    virtual std::list<ThreadInfo> parseThreadList(const char* output);
    virtual bool parseBreakpoint(const char* output, int& id,
				 TQString& file, int& lineNo, TQString& address);
    virtual void parseLocals(const char* output, std::list<ExprValue*>& newVars);
    virtual ExprValue* parsePrintExpr(const char* output, bool wantErrorValue);
    virtual bool parseChangeWD(const char* output, TQString& message);
    virtual bool parseChangeExecutable(const char* output, TQString& message);
    virtual bool parseCoreFile(const char* output);
    virtual uint parseProgramStopped(const char* output, TQString& message);
    virtual TQStringList parseSharedLibs(const char* output);
    virtual bool parseFindType(const char* output, TQString& type);
    virtual std::list<RegisterInfo> parseRegisters(const char* output);
    virtual bool parseInfoLine(const char* output,
			       TQString& addrFrom, TQString& addrTo);
    virtual std::list<DisassembledCode> parseDisassemble(const char* output);
    virtual TQString parseMemoryDump(const char* output, std::list<MemoryDump>& memdump);
    virtual TQString parseSetVariable(const char* output);
    virtual TQString editableValue(VarTree* value);
protected:
    int m_gdbMajor, m_gdbMinor;
    TQString m_programWD;		/* just an intermediate storage */
    TQString m_redirect;			/* redirection to /dev/null */
    bool m_haveCoreFile;
    TQString m_defaultCmd;		/* how to invoke gdb */

    TQString makeCmdString(DbgCommand cmd, TQString strArg);
    TQString makeCmdString(DbgCommand cmd, int intArg);
    TQString makeCmdString(DbgCommand cmd, TQString strArg, int intArg);
    TQString makeCmdString(DbgCommand cmd, TQString strArg1, TQString strArg2);
    TQString makeCmdString(DbgCommand cmd, int intArg1, int intArg2);
    void parseMarker();
};

#endif // GDBDRIVER_H
