//
// C++ Interface: kbsiteinfo
//
// Description: 
//
//
// Author: Magnus Kulke <mkulke@magnusmachine>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KBSITEINFO_H
#define KBSITEINFO_H

#include <ntqstring.h>

#include <list>

/**
@author Magnus Kulke
*/

using namespace std;

class KbSiteInfo
{
public:
	KbSiteInfo();
	~KbSiteInfo();
	TQString GetInfo() { return m_info; };
	TQString GetUser() { return m_user; };
	TQString GetPass() { return m_pass; };
	TQString GetName() { return m_name; };
	TQString GetDefaultDirectory() { return m_defaultdir; };
	int GetAlternativeFxp() { return m_altfxp; };
	int GetCorrectPasv() { return m_correctpasv; };
	int GetPasv() { return m_pasv; };
	int GetTls() { return m_tls; };
	void SetPasv(int pasv) { m_pasv = pasv; };
	void SetTls(int tls) { m_tls = tls; };
	void SetDefaultDirectory(TQString path) { m_defaultdir = path; };
	void SetAlternativeFxp(int i) { m_altfxp = i; };
	void SetCorrectPasv(int i) { m_correctpasv = i; };
	void SetUser(TQString user) { m_user = user; };
	void SetInfo(TQString info) { m_info = info; };
	void SetPass(TQString pass) { m_pass = pass; };
	void SetName(TQString name) { m_name = name; };
	bool IsLegit();
	static list<KbSiteInfo> ParseBookmarks();
	static bool WriteBookmarks(const list<KbSiteInfo> bookmarks);
	void Clear();
private:
	list<KbSiteInfo> goo;
	TQString m_user;
	TQString m_info;
	TQString m_name;
	TQString m_pass;
	TQString m_defaultdir;
	int m_altfxp;
	int m_correctpasv;
	int m_pasv;
	int m_tls; 
};

#endif
