// vim: set tabstop=4 shiftwidth=4 noexpandtab:
// kate: indent-mode csands; indent-width 4; replace-tabs-save off; replace-tabs off; replace-trailing-space-save off; space-indent off; tabs-indents on; tab-width 4;
/*
Gwenview - A simple image viewer for TDE
Copyright 2005 Aurelien Gateau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "vtabwidget.moc"

// TQt
#include <tqwidgetstack.h>

// KDE
#include <tdemultitabbar.h>

namespace Gwenview {


struct VTabWidget::Private {
	KMultiTabBar* mTabBar;
	TQWidgetStack* mStack;
	bool mEmpty;
};

	
VTabWidget::VTabWidget(TQWidget* parent)
: TQWidget(parent)
{
	d=new Private;
	d->mEmpty=true;
	d->mTabBar=new KMultiTabBar(KMultiTabBar::Vertical, this);
	d->mTabBar->setPosition(KMultiTabBar::Left);
	d->mTabBar->setStyle(KMultiTabBar::KDEV3ICON);
	d->mStack=new TQWidgetStack(this);
	TQHBoxLayout* layout=new TQHBoxLayout(this);
	layout->add(d->mTabBar);
	layout->add(d->mStack);
}


VTabWidget::~VTabWidget() {
	delete d;
}


void VTabWidget::addTab(TQWidget* child, const TQPixmap& pix, const TQString& label) {
	int id=d->mStack->addWidget(child);
	d->mTabBar->appendTab(pix, id, label);
	connect(d->mTabBar->tab(id), TQT_SIGNAL(clicked(int)),
		this, TQT_SLOT(slotClicked(int)) );

	if (d->mEmpty) {
		d->mTabBar->tab(id)->setOn(true);
		d->mEmpty=false;
	}
}


void VTabWidget::slotClicked(int id) {
	d->mStack->raiseWidget(id);
	TQPtrList<KMultiTabBarTab>* tabs=d->mTabBar->tabs();
	TQPtrListIterator<KMultiTabBarTab> it(*tabs);
	for (; it.current(); ++it) {
		KMultiTabBarTab* tab=it.current();
		tab->setOn(tab->id()==id);
	}
}


} // namespace
