/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



#ifndef CHTMLWRITEDISPLAY_H
#define CHTMLWRITEDISPLAY_H

//BibleTime includes
#include "cplainwritedisplay.h"

//TQt includes
#include <tqwidget.h>
#include <tqtextedit.h>

class CWriteWindow;

class TQPopupMenu;

class TDEToggleAction;
class TDEFontAction;
class TDEFontSizeAction;

class KColorButton;

/** The WYSIWYG implementation of the write display interface.
  * @author The BibleTime team
  */
class CHTMLWriteDisplay : public CPlainWriteDisplay  {
	Q_OBJECT
  
public:
	/**
	* Sets the new text for this display widget.
	*/
	virtual void setText( const TQString& newText );
	/**
	* Returns the text of this edit widget.
	*/
	virtual const TQString plainText();

	/**
	* Creates the necessary action objects and puts them on the toolbar.
	*/
	virtual void setupToolbar(TDEToolBar * bar, TDEActionCollection * actionCollection);

protected:
	friend class CDisplay;
	CHTMLWriteDisplay(CWriteWindow* parentWindow, TQWidget* parent);
	~CHTMLWriteDisplay();
	/**
	* Reimplementation to show a popup menu if the right mouse butoon was clicked.
	*/
	virtual TQPopupMenu* createPopupMenu( const TQPoint& pos );

protected slots:
	void toggleBold();
	void toggleItalic();
	void toggleUnderline();

	void alignLeft();
	void alignCenter();
	void alignRight();

	void slotFontChanged( const TQFont& );
	/**
	* The text's alignment changed. Enable the right buttons.
	*/
	void slotAlignmentChanged( int );
	/**
	* Is called when a new color was selected.
	*/
	void slotColorSelected( const TQColor& );
	/**
	* Is called when a text with another color was selected.
	*/
	void slotColorChanged( const TQColor& );

private:
	struct {
		TDEToggleAction* bold;
		TDEToggleAction* italic;
		TDEToggleAction* underline;

		TDEToggleAction* alignLeft;
		TDEToggleAction* alignCenter;
		TDEToggleAction* alignRight;

		TDEFontAction* fontChooser;
		TDEFontSizeAction* fontSizeChooser;

		//popup menu
		TDEAction* selectAll;
	}
	m_actions;
	KColorButton* m_colorButton;
};

#endif
