/***************************************************************************
 *   Copyright (C) 2005 Ian Monroe <ian@monroe.nu>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef PLAYLISTSELECTION_H
#define PLAYLISTSELECTION_H

#include <tdelistview.h>

class NewDynamic;
class KDialogBase;
class DynamicMode;

//this is a widget used in newdynamic.ui
class PlaylistSelection : public TDEListView
{
        Q_OBJECT
  
    public:
        PlaylistSelection(TQWidget* parent, const char* name);
        virtual TQSize sizeHint() const
        {
            return minimumSizeHint();
        }

    private:
        void loadChildren(TQListViewItem* browserParent, TQListViewItem* selectionParent);
};

namespace ConfigDynamic
{
    void addDynamic( NewDynamic* dialog );
    void dynamicDialog( TQWidget* parent );
    void editDynamicPlaylist( TQWidget* parent, DynamicMode* mode );
    void loadDynamicMode( DynamicMode* saveMe, NewDynamic* dialog );

    KDialogBase* basicDialog( TQWidget* parent );
}

class SelectionListItem : public TQCheckListItem
{
    public:
        SelectionListItem( TQListViewItem  * parent, const TQString& text, TQListViewItem* browserEquivalent );
        SelectionListItem( TQCheckListItem * parent, const TQString& text, TQListViewItem* browserEquivalent );

        virtual TQString name() const;

    protected:
        virtual void stateChange( bool );

    private:
        TQListViewItem* m_browserEquivalent;
};

#endif /*PLAYLISTSELECTION_H*/
