#include <stdlib.h>

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static TDECmdLineOptions options[] =
{
    TDECmdLineLastOption
};

int main(int argc, char *argv[])
{

    TDELocale::setMainCatalogue("adept");

    putenv( "TQT_IM_MODULE=xim" );
    TQString description = i18n("Adept Manager");

    TDEAboutData aboutData( "adept_manager",
                          I18N_NOOP("Adept Manager"),
                          "2.1 Cruiser",
                          description.latin1(),
                          TDEAboutData::License_BSD,
                          I18N_NOOP("(c) 2005, 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    TDECmdLineArgs::init( argc, argv, &aboutData );
    TDECmdLineArgs::addCmdLineOptions( options );

    TDEApplication app;

    TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();
    // if (args && args->isSet("xy")) ...

    /* TDEConfig* config = TDEGlobal::config();
    config->setGroup("General Settings");
    TQString version = config->readEntry("Version"); */

    TDEGlobal::locale()->insertCatalogue(TQString::fromUtf8("libept"));
    TDEGlobal::locale()->insertCatalogue(TQString::fromUtf8("libapt-front"));

    TestApp *ta = new TestApp();

    app.setMainWidget(ta);
    ta->show();

    return app.exec();
}
