/***************************************************************************
                          tabwidget.cpp - Widget with tabs 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */
#include <tdelocale.h>
#include <kiconloader.h>

/* QT INCLUDES */
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqtabwidget.h>
#include <tqtabbar.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include "kommanderplugin.h"
#include <specials.h>
#include "tabwidget.h"

enum Functions {
  FirstFunction = 357,
  TAB_setTabIcon,
  TAB_tabLabel,
  TAB_isTabEnabled,
  TAB_setTabEnabled,
  TAB_showTabBar,
  TAB_setCurrentPage,
  TAB_setTabLabel,
  LastFunction
};

TabWidget::TabWidget(TQWidget *a_parent, const char *a_name, int a_flags)
	: TQTabWidget(a_parent, a_name, a_flags), KommanderWidget(TQT_TQOBJECT(this))
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);

  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(TAB_setTabIcon, "setTabIcon(TQString widget, int Tab, TQString Icon)", i18n("Sets an icon on the specified tab. Index is zero based."), 3);
  KommanderPlugin::registerFunction(TAB_tabLabel, "tabLabel(TQString widget, int Tab)", i18n("Returns the tab label at the given index. Index is zero based."), 2);
  KommanderPlugin::registerFunction(TAB_isTabEnabled, "isTabEnabled(TQString widget, int Tab)", i18n("Returns true if tab at specified index is enabled, otherwise returns false."), 2);
  KommanderPlugin::registerFunction(TAB_setTabEnabled, "setTabEnabled(TQString widget, int Tab, bool Enabled)", i18n("Sets the tab at the given index to enabled or disabled."), 3);
  KommanderPlugin::registerFunction(TAB_showTabBar, "showTabBar(TQString widget, bool Show)", i18n("Show or hide the tabs on the tab widget."), 2);
  KommanderPlugin::registerFunction(TAB_setCurrentPage, "setCurrentPage(TQString widget, TQString Page)", i18n("Set the current page by name."), 2);
  KommanderPlugin::registerFunction(TAB_setTabLabel, "setTabLabel(TQString widget, int Tab, TQString Text)", i18n("Sets the tab tab label."), 3);
}

TabWidget::~TabWidget()
{
}

TQString TabWidget::currentState() const
{
  return TQString("default");
}

bool TabWidget::isKommanderWidget() const
{
  return true;
}

TQStringList TabWidget::associatedText() const
{
  return KommanderWidget::associatedText();
}

void TabWidget::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void TabWidget::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText( a_text );
}

TQString TabWidget::populationText() const
{
  return KommanderWidget::populationText();
}

void TabWidget::populate()
{
}

void TabWidget::showEvent(TQShowEvent* e)
{
  TQTabWidget::showEvent(e);
  emit widgetOpened();
}

void TabWidget::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool TabWidget::isFunctionSupported(int f)
{
  return f == DCOP::currentItem || f == DCOP::setCurrentItem || f == DCOP::insertTab || (f >= FirstFunction && f <= LastFunction) ;
}

TQString TabWidget::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::currentItem:
      return TQString::number(currentPageIndex());
    case DCOP::setCurrentItem:
      setCurrentPage(args[0].toUInt());
      break;
    case DCOP::insertTab:
      insertTab(0L, args[0], args[1].toUInt());
      break;
    case TAB_tabLabel:
    {
      TQString s = this->label(args[0].toInt());
      return s.remove("&");
      break;
    }
    case TAB_setTabIcon:
    {
      TQWidget *w = page(args[0].toInt());
      setTabIconSet(w, TDEGlobal::iconLoader()->loadIcon(args[1], TDEIcon::NoGroup, TDEIcon::SizeMedium));
      break;
    }
    case TAB_isTabEnabled:
    {
      TQWidget *w = page(args[0].toInt());
      return TQString::number(this->isTabEnabled(w));
      break;
    }
    case TAB_setTabLabel:
    {
      TQWidget *w = page(args[0].toInt());
      setTabLabel(w, args[1]);
      break;
    }
    case TAB_setTabEnabled:
    {
      TQWidget *w = page(args[0].toInt());
      this->setTabEnabled(w, args[1].toInt());
     break;
    }
    case TAB_setCurrentPage:
    {
      int cnt = this->count();
      int i = 0;
      bool found = false;
      while (i < cnt) {
        TQString s = this->label(i);
        if (s.remove("&") == args[0])
        {
          setCurrentPage(i);
          found = true;
          break;
        }
        i++;
      }
      return TQString::number(found);
      break;
    }
    case TAB_showTabBar:
    {
      TQTabBar *t = this->tabBar();
      if (args[0].toInt() == 1)
        t->show();
      else
        t->hide();
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}

#include "tabwidget.moc"
