#!/bin/sh

# create temporary home
HOME=@CMAKE_CURRENT_BINARY_DIR@/test-home
mkdir $HOME $HOME/.trinity $HOME/.trinity/share
ln -s @CMAKE_SOURCE_DIR@/mimetypes $HOME/.trinity/share/mimelnk
export HOME

# run dcop server
../../dcop/dcopserver --nofork &
DCOP_SERVER_PID=$!

# update tdesycoca using mime types from source
../../kded/tdebuildsycoca --noincremental --nosignal

# perform test
./kmimetypetest
STATE=$?

# cleanup
kill $DCOP_SERVER_PID
rm -fr test-home
exit $STATE
