/* soapC.cpp
   Generated by gSOAP 2.7.3 from ./groupwise.h
   Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.3 2006-05-18 13:53:47 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version != 1 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_ngwt__DayOfMonth:
		return soap_in_ngwt__DayOfMonth(soap, NULL, NULL, "ngwt:DayOfMonth");
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_ngwt__WeekOfYear:
		return soap_in_ngwt__WeekOfYear(soap, NULL, NULL, "ngwt:WeekOfYear");
	case SOAP_TYPE_ngwt__DayOfYear:
		return soap_in_ngwt__DayOfYear(soap, NULL, NULL, "ngwt:DayOfYear");
	case SOAP_TYPE_short:
		return soap_in_short(soap, NULL, NULL, "xsd:short");
	case SOAP_TYPE_ngwt__GMTOffset:
		return soap_in_ngwt__GMTOffset(soap, NULL, NULL, "ngwt:GMTOffset");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_ngwt__Month:
		return soap_in_ngwt__Month(soap, NULL, NULL, "ngwt:Month");
	case SOAP_TYPE_ngwt__Minute:
		return soap_in_ngwt__Minute(soap, NULL, NULL, "ngwt:Minute");
	case SOAP_TYPE_ngwt__Hour:
		return soap_in_ngwt__Hour(soap, NULL, NULL, "ngwt:Hour");
	case SOAP_TYPE_ngwt__Day:
		return soap_in_ngwt__Day(soap, NULL, NULL, "ngwt:Day");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLong:
		return soap_in_unsignedLong(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_ngwe__ItemType:
		return soap_in_ngwe__ItemType(soap, NULL, NULL, "ngwe:ItemType");
	case SOAP_TYPE_ngwe__Field:
		return soap_in_ngwe__Field(soap, NULL, NULL, "ngwe:Field");
	case SOAP_TYPE_ngwe__EventType:
		return soap_in_ngwe__EventType(soap, NULL, NULL, "ngwe:EventType");
	case SOAP_TYPE_ngwt__WeekDay:
		return soap_in_ngwt__WeekDay(soap, NULL, NULL, "ngwt:WeekDay");
	case SOAP_TYPE_ngwt__VersionStatus:
		return soap_in_ngwt__VersionStatus(soap, NULL, NULL, "ngwt:VersionStatus");
	case SOAP_TYPE_ngwt__VersionEventType:
		return soap_in_ngwt__VersionEventType(soap, NULL, NULL, "ngwt:VersionEventType");
	case SOAP_TYPE_ngwt__StatusTrackingOptions:
		return soap_in_ngwt__StatusTrackingOptions(soap, NULL, NULL, "ngwt:StatusTrackingOptions");
	case SOAP_TYPE_ngwt__RuleActionType:
		return soap_in_ngwt__RuleActionType(soap, NULL, NULL, "ngwt:RuleActionType");
	case SOAP_TYPE_ngwt__RetractType:
		return soap_in_ngwt__RetractType(soap, NULL, NULL, "ngwt:RetractType");
	case SOAP_TYPE_ngwt__RecipientType:
		return soap_in_ngwt__RecipientType(soap, NULL, NULL, "ngwt:RecipientType");
	case SOAP_TYPE_ngwt__PostalAddressType:
		return soap_in_ngwt__PostalAddressType(soap, NULL, NULL, "ngwt:PostalAddressType");
	case SOAP_TYPE_ngwt__PhoneNumberType:
		return soap_in_ngwt__PhoneNumberType(soap, NULL, NULL, "ngwt:PhoneNumberType");
	case SOAP_TYPE_ngwt__OccurrenceType:
		return soap_in_ngwt__OccurrenceType(soap, NULL, NULL, "ngwt:OccurrenceType");
	case SOAP_TYPE_ngwt__NotificationType:
		return soap_in_ngwt__NotificationType(soap, NULL, NULL, "ngwt:NotificationType");
	case SOAP_TYPE_ngwt__MessageType:
		return soap_in_ngwt__MessageType(soap, NULL, NULL, "ngwt:MessageType");
	case SOAP_TYPE_ngwt__MessageList:
		return soap_in_ngwt__MessageList(soap, NULL, NULL, "ngwt:MessageList");
	case SOAP_TYPE_ngwt__LinkType:
		return soap_in_ngwt__LinkType(soap, NULL, NULL, "ngwt:LinkType");
	case SOAP_TYPE_ngwt__JunkMatchType:
		return soap_in_ngwt__JunkMatchType(soap, NULL, NULL, "ngwt:JunkMatchType");
	case SOAP_TYPE_ngwt__JunkHandlingListType:
		return soap_in_ngwt__JunkHandlingListType(soap, NULL, NULL, "ngwt:JunkHandlingListType");
	case SOAP_TYPE_ngwt__ItemSource:
		return soap_in_ngwt__ItemSource(soap, NULL, NULL, "ngwt:ItemSource");
	case SOAP_TYPE_ngwt__ItemSecurity:
		return soap_in_ngwt__ItemSecurity(soap, NULL, NULL, "ngwt:ItemSecurity");
	case SOAP_TYPE_ngwt__ItemOptionsPriority:
		return soap_in_ngwt__ItemOptionsPriority(soap, NULL, NULL, "ngwt:ItemOptionsPriority");
	case SOAP_TYPE_ngwt__ItemClass:
		return soap_in_ngwt__ItemClass(soap, NULL, NULL, "ngwt:ItemClass");
	case SOAP_TYPE_ngwt__Frequency:
		return soap_in_ngwt__Frequency(soap, NULL, NULL, "ngwt:Frequency");
	case SOAP_TYPE_ngwt__FolderType:
		return soap_in_ngwt__FolderType(soap, NULL, NULL, "ngwt:FolderType");
	case SOAP_TYPE_ngwt__FolderACLStatus:
		return soap_in_ngwt__FolderACLStatus(soap, NULL, NULL, "ngwt:FolderACLStatus");
	case SOAP_TYPE_ngwt__FilterOp:
		return soap_in_ngwt__FilterOp(soap, NULL, NULL, "ngwt:FilterOp");
	case SOAP_TYPE_ngwt__FilterDate:
		return soap_in_ngwt__FilterDate(soap, NULL, NULL, "ngwt:FilterDate");
	case SOAP_TYPE_ngwt__Execution:
		return soap_in_ngwt__Execution(soap, NULL, NULL, "ngwt:Execution");
	case SOAP_TYPE_ngwt__DistributionType:
		return soap_in_ngwt__DistributionType(soap, NULL, NULL, "ngwt:DistributionType");
	case SOAP_TYPE_ngwt__DeltaSyncType:
		return soap_in_ngwt__DeltaSyncType(soap, NULL, NULL, "ngwt:DeltaSyncType");
	case SOAP_TYPE_ngwt__CustomType:
		return soap_in_ngwt__CustomType(soap, NULL, NULL, "ngwt:CustomType");
	case SOAP_TYPE_ngwt__CursorSeek:
		return soap_in_ngwt__CursorSeek(soap, NULL, NULL, "ngwt:CursorSeek");
	case SOAP_TYPE_ngwt__ContactType:
		return soap_in_ngwt__ContactType(soap, NULL, NULL, "ngwt:ContactType");
	case SOAP_TYPE_ngwt__CategoryType:
		return soap_in_ngwt__CategoryType(soap, NULL, NULL, "ngwt:CategoryType");
	case SOAP_TYPE_ngwt__CalendarFolderFlags:
		return soap_in_ngwt__CalendarFolderFlags(soap, NULL, NULL, "ngwt:CalendarFolderFlags");
	case SOAP_TYPE_ngwt__AppointmentConflict:
		return soap_in_ngwt__AppointmentConflict(soap, NULL, NULL, "ngwt:AppointmentConflict");
	case SOAP_TYPE_ngwt__AgeAction:
		return soap_in_ngwt__AgeAction(soap, NULL, NULL, "ngwt:AgeAction");
	case SOAP_TYPE_ngwt__AcceptLevel:
		return soap_in_ngwt__AcceptLevel(soap, NULL, NULL, "ngwt:AcceptLevel");
	case SOAP_TYPE_ngwe__ItemTypeList:
		return soap_in_ngwe__ItemTypeList(soap, NULL, NULL, "ngwe:ItemTypeList");
	case SOAP_TYPE_ngwe__FieldList:
		return soap_in_ngwe__FieldList(soap, NULL, NULL, "ngwe:FieldList");
	case SOAP_TYPE_ngwt__MessageTypeList:
		return soap_in_ngwt__MessageTypeList(soap, NULL, NULL, "ngwt:MessageTypeList");
	case SOAP_TYPE_ngwt__ItemSourceList:
		return soap_in_ngwt__ItemSourceList(soap, NULL, NULL, "ngwt:ItemSourceList");
	case SOAP_TYPE_ngwt__UUID:
		return soap_in_ngwt__UUID(soap, NULL, NULL, "ngwt:UUID");
	case SOAP_TYPE_ngwt__uid:
		return soap_in_ngwt__uid(soap, NULL, NULL, "ngwt:uid");
	case SOAP_TYPE_ngwt__View:
		return soap_in_ngwt__View(soap, NULL, NULL, "ngwt:View");
	case SOAP_TYPE__ngwe__removeEventsResponse:
		return soap_in__ngwe__removeEventsResponse(soap, NULL, NULL, "ngwe:removeEventsResponse");
	case SOAP_TYPE__ngwe__removeEventsRequest:
		return soap_in__ngwe__removeEventsRequest(soap, NULL, NULL, "ngwe:removeEventsRequest");
	case SOAP_TYPE__ngwe__removeEventConfigurationResponse:
		return soap_in__ngwe__removeEventConfigurationResponse(soap, NULL, NULL, "ngwe:removeEventConfigurationResponse");
	case SOAP_TYPE__ngwe__removeEventConfigurationRequest:
		return soap_in__ngwe__removeEventConfigurationRequest(soap, NULL, NULL, "ngwe:removeEventConfigurationRequest");
	case SOAP_TYPE__ngwe__getEventsResponse:
		return soap_in__ngwe__getEventsResponse(soap, NULL, NULL, "ngwe:getEventsResponse");
	case SOAP_TYPE__ngwe__getEventsRequest:
		return soap_in__ngwe__getEventsRequest(soap, NULL, NULL, "ngwe:getEventsRequest");
	case SOAP_TYPE__ngwe__getEventConfigurationResponse:
		return soap_in__ngwe__getEventConfigurationResponse(soap, NULL, NULL, "ngwe:getEventConfigurationResponse");
	case SOAP_TYPE__ngwe__getEventConfigurationRequest:
		return soap_in__ngwe__getEventConfigurationRequest(soap, NULL, NULL, "ngwe:getEventConfigurationRequest");
	case SOAP_TYPE__ngwe__configureEventsResponse:
		return soap_in__ngwe__configureEventsResponse(soap, NULL, NULL, "ngwe:configureEventsResponse");
	case SOAP_TYPE__ngwe__configureEventsRequest:
		return soap_in__ngwe__configureEventsRequest(soap, NULL, NULL, "ngwe:configureEventsRequest");
	case SOAP_TYPE__ngwe__cleanEventConfigurationResponse:
		return soap_in__ngwe__cleanEventConfigurationResponse(soap, NULL, NULL, "ngwe:cleanEventConfigurationResponse");
	case SOAP_TYPE__ngwe__cleanEventConfigurationRequest:
		return soap_in__ngwe__cleanEventConfigurationRequest(soap, NULL, NULL, "ngwe:cleanEventConfigurationRequest");
	case SOAP_TYPE_ngwe__Notify:
		return soap_in_ngwe__Notify(soap, NULL, NULL, "ngwe:Notify");
	case SOAP_TYPE_ngwe__EventTypeList:
		return soap_in_ngwe__EventTypeList(soap, NULL, NULL, "ngwe:EventTypeList");
	case SOAP_TYPE_ngwe__EventsList:
		return soap_in_ngwe__EventsList(soap, NULL, NULL, "ngwe:EventsList");
	case SOAP_TYPE_ngwe__Events:
		return soap_in_ngwe__Events(soap, NULL, NULL, "ngwe:Events");
	case SOAP_TYPE_ngwe__EventList:
		return soap_in_ngwe__EventList(soap, NULL, NULL, "ngwe:EventList");
	case SOAP_TYPE_ngwe__EventDefinition:
		return soap_in_ngwe__EventDefinition(soap, NULL, NULL, "ngwe:EventDefinition");
	case SOAP_TYPE_ngwe__Event:
		return soap_in_ngwe__Event(soap, NULL, NULL, "ngwe:Event");
	case SOAP_TYPE_ngwe__ContainerList:
		return soap_in_ngwe__ContainerList(soap, NULL, NULL, "ngwe:ContainerList");
	case SOAP_TYPE__ngwm__updateVersionStatusResponse:
		return soap_in__ngwm__updateVersionStatusResponse(soap, NULL, NULL, "ngwm:updateVersionStatusResponse");
	case SOAP_TYPE__ngwm__updateVersionStatusRequest:
		return soap_in__ngwm__updateVersionStatusRequest(soap, NULL, NULL, "ngwm:updateVersionStatusRequest");
	case SOAP_TYPE__ngwm__uncompleteResponse:
		return soap_in__ngwm__uncompleteResponse(soap, NULL, NULL, "ngwm:uncompleteResponse");
	case SOAP_TYPE__ngwm__uncompleteRequest:
		return soap_in__ngwm__uncompleteRequest(soap, NULL, NULL, "ngwm:uncompleteRequest");
	case SOAP_TYPE__ngwm__unacceptResponse:
		return soap_in__ngwm__unacceptResponse(soap, NULL, NULL, "ngwm:unacceptResponse");
	case SOAP_TYPE__ngwm__unacceptRequest:
		return soap_in__ngwm__unacceptRequest(soap, NULL, NULL, "ngwm:unacceptRequest");
	case SOAP_TYPE__ngwm__startFreeBusySessionResponse:
		return soap_in__ngwm__startFreeBusySessionResponse(soap, NULL, NULL, "ngwm:startFreeBusySessionResponse");
	case SOAP_TYPE__ngwm__startFreeBusySessionRequest:
		return soap_in__ngwm__startFreeBusySessionRequest(soap, NULL, NULL, "ngwm:startFreeBusySessionRequest");
	case SOAP_TYPE__ngwm__setTimestampResponse:
		return soap_in__ngwm__setTimestampResponse(soap, NULL, NULL, "ngwm:setTimestampResponse");
	case SOAP_TYPE__ngwm__setTimestampRequest:
		return soap_in__ngwm__setTimestampRequest(soap, NULL, NULL, "ngwm:setTimestampRequest");
	case SOAP_TYPE__ngwm__sendItemResponse:
		return soap_in__ngwm__sendItemResponse(soap, NULL, NULL, "ngwm:sendItemResponse");
	case SOAP_TYPE__ngwm__sendItemRequest:
		return soap_in__ngwm__sendItemRequest(soap, NULL, NULL, "ngwm:sendItemRequest");
	case SOAP_TYPE__ngwm__retractResponse:
		return soap_in__ngwm__retractResponse(soap, NULL, NULL, "ngwm:retractResponse");
	case SOAP_TYPE__ngwm__retractRequest:
		return soap_in__ngwm__retractRequest(soap, NULL, NULL, "ngwm:retractRequest");
	case SOAP_TYPE__ngwm__replyResponse:
		return soap_in__ngwm__replyResponse(soap, NULL, NULL, "ngwm:replyResponse");
	case SOAP_TYPE__ngwm__replyRequest:
		return soap_in__ngwm__replyRequest(soap, NULL, NULL, "ngwm:replyRequest");
	case SOAP_TYPE__ngwm__removeSignatureResponse:
		return soap_in__ngwm__removeSignatureResponse(soap, NULL, NULL, "ngwm:removeSignatureResponse");
	case SOAP_TYPE__ngwm__removeSignatureRequest:
		return soap_in__ngwm__removeSignatureRequest(soap, NULL, NULL, "ngwm:removeSignatureRequest");
	case SOAP_TYPE__ngwm__removeProxyUserResponse:
		return soap_in__ngwm__removeProxyUserResponse(soap, NULL, NULL, "ngwm:removeProxyUserResponse");
	case SOAP_TYPE__ngwm__removeProxyUserRequest:
		return soap_in__ngwm__removeProxyUserRequest(soap, NULL, NULL, "ngwm:removeProxyUserRequest");
	case SOAP_TYPE__ngwm__removeProxyAccessResponse:
		return soap_in__ngwm__removeProxyAccessResponse(soap, NULL, NULL, "ngwm:removeProxyAccessResponse");
	case SOAP_TYPE__ngwm__removeProxyAccessRequest:
		return soap_in__ngwm__removeProxyAccessRequest(soap, NULL, NULL, "ngwm:removeProxyAccessRequest");
	case SOAP_TYPE__ngwm__removeMembersResponse:
		return soap_in__ngwm__removeMembersResponse(soap, NULL, NULL, "ngwm:removeMembersResponse");
	case SOAP_TYPE__ngwm__removeMembersRequest:
		return soap_in__ngwm__removeMembersRequest(soap, NULL, NULL, "ngwm:removeMembersRequest");
	case SOAP_TYPE__ngwm__removeJunkEntryResponse:
		return soap_in__ngwm__removeJunkEntryResponse(soap, NULL, NULL, "ngwm:removeJunkEntryResponse");
	case SOAP_TYPE__ngwm__removeJunkEntryRequest:
		return soap_in__ngwm__removeJunkEntryRequest(soap, NULL, NULL, "ngwm:removeJunkEntryRequest");
	case SOAP_TYPE__ngwm__removeItemsResponse:
		return soap_in__ngwm__removeItemsResponse(soap, NULL, NULL, "ngwm:removeItemsResponse");
	case SOAP_TYPE__ngwm__removeItemsRequest:
		return soap_in__ngwm__removeItemsRequest(soap, NULL, NULL, "ngwm:removeItemsRequest");
	case SOAP_TYPE__ngwm__removeItemResponse:
		return soap_in__ngwm__removeItemResponse(soap, NULL, NULL, "ngwm:removeItemResponse");
	case SOAP_TYPE__ngwm__removeItemRequest:
		return soap_in__ngwm__removeItemRequest(soap, NULL, NULL, "ngwm:removeItemRequest");
	case SOAP_TYPE__ngwm__removeCustomDefinitionResponse:
		return soap_in__ngwm__removeCustomDefinitionResponse(soap, NULL, NULL, "ngwm:removeCustomDefinitionResponse");
	case SOAP_TYPE__ngwm__removeCustomDefinitionRequest:
		return soap_in__ngwm__removeCustomDefinitionRequest(soap, NULL, NULL, "ngwm:removeCustomDefinitionRequest");
	case SOAP_TYPE__ngwm__readCursorResponse:
		return soap_in__ngwm__readCursorResponse(soap, NULL, NULL, "ngwm:readCursorResponse");
	case SOAP_TYPE__ngwm__readCursorRequest:
		return soap_in__ngwm__readCursorRequest(soap, NULL, NULL, "ngwm:readCursorRequest");
	case SOAP_TYPE__ngwm__purgeResponse:
		return soap_in__ngwm__purgeResponse(soap, NULL, NULL, "ngwm:purgeResponse");
	case SOAP_TYPE__ngwm__purgeRequest:
		return soap_in__ngwm__purgeRequest(soap, NULL, NULL, "ngwm:purgeRequest");
	case SOAP_TYPE__ngwm__purgeDeletedItemsResponse:
		return soap_in__ngwm__purgeDeletedItemsResponse(soap, NULL, NULL, "ngwm:purgeDeletedItemsResponse");
	case SOAP_TYPE__ngwm__purgeDeletedItemsRequest:
		return soap_in__ngwm__purgeDeletedItemsRequest(soap, NULL, NULL, "ngwm:purgeDeletedItemsRequest");
	case SOAP_TYPE__ngwm__positionCursorResponse:
		return soap_in__ngwm__positionCursorResponse(soap, NULL, NULL, "ngwm:positionCursorResponse");
	case SOAP_TYPE__ngwm__positionCursorRequest:
		return soap_in__ngwm__positionCursorRequest(soap, NULL, NULL, "ngwm:positionCursorRequest");
	case SOAP_TYPE__ngwm__moveItemResponse:
		return soap_in__ngwm__moveItemResponse(soap, NULL, NULL, "ngwm:moveItemResponse");
	case SOAP_TYPE__ngwm__moveItemRequest:
		return soap_in__ngwm__moveItemRequest(soap, NULL, NULL, "ngwm:moveItemRequest");
	case SOAP_TYPE__ngwm__modifySignaturesResponse:
		return soap_in__ngwm__modifySignaturesResponse(soap, NULL, NULL, "ngwm:modifySignaturesResponse");
	case SOAP_TYPE__ngwm__modifySignaturesRequest:
		return soap_in__ngwm__modifySignaturesRequest(soap, NULL, NULL, "ngwm:modifySignaturesRequest");
	case SOAP_TYPE__ngwm__modifySettingsResponse:
		return soap_in__ngwm__modifySettingsResponse(soap, NULL, NULL, "ngwm:modifySettingsResponse");
	case SOAP_TYPE__ngwm__modifySettingsRequest:
		return soap_in__ngwm__modifySettingsRequest(soap, NULL, NULL, "ngwm:modifySettingsRequest");
	case SOAP_TYPE__ngwm__modifyProxyAccessResponse:
		return soap_in__ngwm__modifyProxyAccessResponse(soap, NULL, NULL, "ngwm:modifyProxyAccessResponse");
	case SOAP_TYPE__ngwm__modifyProxyAccessRequest:
		return soap_in__ngwm__modifyProxyAccessRequest(soap, NULL, NULL, "ngwm:modifyProxyAccessRequest");
	case SOAP_TYPE__ngwm__modifyPasswordResponse:
		return soap_in__ngwm__modifyPasswordResponse(soap, NULL, NULL, "ngwm:modifyPasswordResponse");
	case SOAP_TYPE__ngwm__modifyPasswordRequest:
		return soap_in__ngwm__modifyPasswordRequest(soap, NULL, NULL, "ngwm:modifyPasswordRequest");
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse:
		return soap_in__ngwm__modifyJunkMailSettingsResponse(soap, NULL, NULL, "ngwm:modifyJunkMailSettingsResponse");
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest:
		return soap_in__ngwm__modifyJunkMailSettingsRequest(soap, NULL, NULL, "ngwm:modifyJunkMailSettingsRequest");
	case SOAP_TYPE__ngwm__modifyJunkEntryResponse:
		return soap_in__ngwm__modifyJunkEntryResponse(soap, NULL, NULL, "ngwm:modifyJunkEntryResponse");
	case SOAP_TYPE__ngwm__modifyJunkEntryRequest:
		return soap_in__ngwm__modifyJunkEntryRequest(soap, NULL, NULL, "ngwm:modifyJunkEntryRequest");
	case SOAP_TYPE__ngwm__modifyItemsResponse:
		return soap_in__ngwm__modifyItemsResponse(soap, NULL, NULL, "ngwm:modifyItemsResponse");
	case SOAP_TYPE__ngwm__modifyItemsRequest:
		return soap_in__ngwm__modifyItemsRequest(soap, NULL, NULL, "ngwm:modifyItemsRequest");
	case SOAP_TYPE__ngwm__modifyItemResponse:
		return soap_in__ngwm__modifyItemResponse(soap, NULL, NULL, "ngwm:modifyItemResponse");
	case SOAP_TYPE__ngwm__modifyItemRequest:
		return soap_in__ngwm__modifyItemRequest(soap, NULL, NULL, "ngwm:modifyItemRequest");
	case SOAP_TYPE__ngwm__markUnReadResponse:
		return soap_in__ngwm__markUnReadResponse(soap, NULL, NULL, "ngwm:markUnReadResponse");
	case SOAP_TYPE__ngwm__markUnReadRequest:
		return soap_in__ngwm__markUnReadRequest(soap, NULL, NULL, "ngwm:markUnReadRequest");
	case SOAP_TYPE__ngwm__markUnPrivateResponse:
		return soap_in__ngwm__markUnPrivateResponse(soap, NULL, NULL, "ngwm:markUnPrivateResponse");
	case SOAP_TYPE__ngwm__markUnPrivateRequest:
		return soap_in__ngwm__markUnPrivateRequest(soap, NULL, NULL, "ngwm:markUnPrivateRequest");
	case SOAP_TYPE__ngwm__markReadResponse:
		return soap_in__ngwm__markReadResponse(soap, NULL, NULL, "ngwm:markReadResponse");
	case SOAP_TYPE__ngwm__markReadRequest:
		return soap_in__ngwm__markReadRequest(soap, NULL, NULL, "ngwm:markReadRequest");
	case SOAP_TYPE__ngwm__markPrivateResponse:
		return soap_in__ngwm__markPrivateResponse(soap, NULL, NULL, "ngwm:markPrivateResponse");
	case SOAP_TYPE__ngwm__markPrivateRequest:
		return soap_in__ngwm__markPrivateRequest(soap, NULL, NULL, "ngwm:markPrivateRequest");
	case SOAP_TYPE__ngwm__logoutResponse:
		return soap_in__ngwm__logoutResponse(soap, NULL, NULL, "ngwm:logoutResponse");
	case SOAP_TYPE__ngwm__logoutRequest:
		return soap_in__ngwm__logoutRequest(soap, NULL, NULL, "ngwm:logoutRequest");
	case SOAP_TYPE__ngwm__loginResponse:
		return soap_in__ngwm__loginResponse(soap, NULL, NULL, "ngwm:loginResponse");
	case SOAP_TYPE__ngwm__loginRequest:
		return soap_in__ngwm__loginRequest(soap, NULL, NULL, "ngwm:loginRequest");
	case SOAP_TYPE__ngwm__getUserListResponse:
		return soap_in__ngwm__getUserListResponse(soap, NULL, NULL, "ngwm:getUserListResponse");
	case SOAP_TYPE__ngwm__getUserListRequest:
		return soap_in__ngwm__getUserListRequest(soap, NULL, NULL, "ngwm:getUserListRequest");
	case SOAP_TYPE__ngwm__getTimezoneListResponse:
		return soap_in__ngwm__getTimezoneListResponse(soap, NULL, NULL, "ngwm:getTimezoneListResponse");
	case SOAP_TYPE__ngwm__getTimezoneListRequest:
		return soap_in__ngwm__getTimezoneListRequest(soap, NULL, NULL, "ngwm:getTimezoneListRequest");
	case SOAP_TYPE__ngwm__getTimestampResponse:
		return soap_in__ngwm__getTimestampResponse(soap, NULL, NULL, "ngwm:getTimestampResponse");
	case SOAP_TYPE__ngwm__getTimestampRequest:
		return soap_in__ngwm__getTimestampRequest(soap, NULL, NULL, "ngwm:getTimestampRequest");
	case SOAP_TYPE__ngwm__getSignaturesResponse:
		return soap_in__ngwm__getSignaturesResponse(soap, NULL, NULL, "ngwm:getSignaturesResponse");
	case SOAP_TYPE__ngwm__getSignaturesRequest:
		return soap_in__ngwm__getSignaturesRequest(soap, NULL, NULL, "ngwm:getSignaturesRequest");
	case SOAP_TYPE__ngwm__getSettingsResponse:
		return soap_in__ngwm__getSettingsResponse(soap, NULL, NULL, "ngwm:getSettingsResponse");
	case SOAP_TYPE__ngwm__getSettingsRequest:
		return soap_in__ngwm__getSettingsRequest(soap, NULL, NULL, "ngwm:getSettingsRequest");
	case SOAP_TYPE__ngwm__getRuleListResponse:
		return soap_in__ngwm__getRuleListResponse(soap, NULL, NULL, "ngwm:getRuleListResponse");
	case SOAP_TYPE__ngwm__getRuleListRequest:
		return soap_in__ngwm__getRuleListRequest(soap, NULL, NULL, "ngwm:getRuleListRequest");
	case SOAP_TYPE__ngwm__getProxyListResponse:
		return soap_in__ngwm__getProxyListResponse(soap, NULL, NULL, "ngwm:getProxyListResponse");
	case SOAP_TYPE__ngwm__getProxyListRequest:
		return soap_in__ngwm__getProxyListRequest(soap, NULL, NULL, "ngwm:getProxyListRequest");
	case SOAP_TYPE__ngwm__getProxyAccessListResponse:
		return soap_in__ngwm__getProxyAccessListResponse(soap, NULL, NULL, "ngwm:getProxyAccessListResponse");
	case SOAP_TYPE__ngwm__getProxyAccessListRequest:
		return soap_in__ngwm__getProxyAccessListRequest(soap, NULL, NULL, "ngwm:getProxyAccessListRequest");
	case SOAP_TYPE__ngwm__getQuickMessagesResponse:
		return soap_in__ngwm__getQuickMessagesResponse(soap, NULL, NULL, "ngwm:getQuickMessagesResponse");
	case SOAP_TYPE__ngwm__getQuickMessagesRequest:
		return soap_in__ngwm__getQuickMessagesRequest(soap, NULL, NULL, "ngwm:getQuickMessagesRequest");
	case SOAP_TYPE__ngwm__getLibraryListResponse:
		return soap_in__ngwm__getLibraryListResponse(soap, NULL, NULL, "ngwm:getLibraryListResponse");
	case SOAP_TYPE__ngwm__getLibraryListRequest:
		return soap_in__ngwm__getLibraryListRequest(soap, NULL, NULL, "ngwm:getLibraryListRequest");
	case SOAP_TYPE__ngwm__getLibraryItemResponse:
		return soap_in__ngwm__getLibraryItemResponse(soap, NULL, NULL, "ngwm:getLibraryItemResponse");
	case SOAP_TYPE__ngwm__getLibraryItemRequest:
		return soap_in__ngwm__getLibraryItemRequest(soap, NULL, NULL, "ngwm:getLibraryItemRequest");
	case SOAP_TYPE__ngwm__getJunkMailSettingsResponse:
		return soap_in__ngwm__getJunkMailSettingsResponse(soap, NULL, NULL, "ngwm:getJunkMailSettingsResponse");
	case SOAP_TYPE__ngwm__getJunkMailSettingsRequest:
		return soap_in__ngwm__getJunkMailSettingsRequest(soap, NULL, NULL, "ngwm:getJunkMailSettingsRequest");
	case SOAP_TYPE__ngwm__getJunkEntriesResponse:
		return soap_in__ngwm__getJunkEntriesResponse(soap, NULL, NULL, "ngwm:getJunkEntriesResponse");
	case SOAP_TYPE__ngwm__getJunkEntriesRequest:
		return soap_in__ngwm__getJunkEntriesRequest(soap, NULL, NULL, "ngwm:getJunkEntriesRequest");
	case SOAP_TYPE__ngwm__getItemsResponse:
		return soap_in__ngwm__getItemsResponse(soap, NULL, NULL, "ngwm:getItemsResponse");
	case SOAP_TYPE__ngwm__getItemsRequest:
		return soap_in__ngwm__getItemsRequest(soap, NULL, NULL, "ngwm:getItemsRequest");
	case SOAP_TYPE__ngwm__getItemResponse:
		return soap_in__ngwm__getItemResponse(soap, NULL, NULL, "ngwm:getItemResponse");
	case SOAP_TYPE__ngwm__getItemRequest:
		return soap_in__ngwm__getItemRequest(soap, NULL, NULL, "ngwm:getItemRequest");
	case SOAP_TYPE__ngwm__getFreeBusyResponse:
		return soap_in__ngwm__getFreeBusyResponse(soap, NULL, NULL, "ngwm:getFreeBusyResponse");
	case SOAP_TYPE__ngwm__getFreeBusyRequest:
		return soap_in__ngwm__getFreeBusyRequest(soap, NULL, NULL, "ngwm:getFreeBusyRequest");
	case SOAP_TYPE__ngwm__getFolderListResponse:
		return soap_in__ngwm__getFolderListResponse(soap, NULL, NULL, "ngwm:getFolderListResponse");
	case SOAP_TYPE__ngwm__getFolderListRequest:
		return soap_in__ngwm__getFolderListRequest(soap, NULL, NULL, "ngwm:getFolderListRequest");
	case SOAP_TYPE__ngwm__getFolderResponse:
		return soap_in__ngwm__getFolderResponse(soap, NULL, NULL, "ngwm:getFolderResponse");
	case SOAP_TYPE__ngwm__getFolderRequest:
		return soap_in__ngwm__getFolderRequest(soap, NULL, NULL, "ngwm:getFolderRequest");
	case SOAP_TYPE__ngwm__getDocumentTypeListResponse:
		return soap_in__ngwm__getDocumentTypeListResponse(soap, NULL, NULL, "ngwm:getDocumentTypeListResponse");
	case SOAP_TYPE__ngwm__getDocumentTypeListRequest:
		return soap_in__ngwm__getDocumentTypeListRequest(soap, NULL, NULL, "ngwm:getDocumentTypeListRequest");
	case SOAP_TYPE__ngwm__getDeltaInfoResponse:
		return soap_in__ngwm__getDeltaInfoResponse(soap, NULL, NULL, "ngwm:getDeltaInfoResponse");
	case SOAP_TYPE__ngwm__getDeltaInfoRequest:
		return soap_in__ngwm__getDeltaInfoRequest(soap, NULL, NULL, "ngwm:getDeltaInfoRequest");
	case SOAP_TYPE__ngwm__getDeltasResponse:
		return soap_in__ngwm__getDeltasResponse(soap, NULL, NULL, "ngwm:getDeltasResponse");
	case SOAP_TYPE__ngwm__getDeltasRequest:
		return soap_in__ngwm__getDeltasRequest(soap, NULL, NULL, "ngwm:getDeltasRequest");
	case SOAP_TYPE__ngwm__getCustomListResponse:
		return soap_in__ngwm__getCustomListResponse(soap, NULL, NULL, "ngwm:getCustomListResponse");
	case SOAP_TYPE__ngwm__getCustomListRequest:
		return soap_in__ngwm__getCustomListRequest(soap, NULL, NULL, "ngwm:getCustomListRequest");
	case SOAP_TYPE__ngwm__getCategoryListResponse:
		return soap_in__ngwm__getCategoryListResponse(soap, NULL, NULL, "ngwm:getCategoryListResponse");
	case SOAP_TYPE__ngwm__getCategoryListRequest:
		return soap_in__ngwm__getCategoryListRequest(soap, NULL, NULL, "ngwm:getCategoryListRequest");
	case SOAP_TYPE__ngwm__getAttachmentResponse:
		return soap_in__ngwm__getAttachmentResponse(soap, NULL, NULL, "ngwm:getAttachmentResponse");
	case SOAP_TYPE__ngwm__getAttachmentRequest:
		return soap_in__ngwm__getAttachmentRequest(soap, NULL, NULL, "ngwm:getAttachmentRequest");
	case SOAP_TYPE__ngwm__getAddressBookListResponse:
		return soap_in__ngwm__getAddressBookListResponse(soap, NULL, NULL, "ngwm:getAddressBookListResponse");
	case SOAP_TYPE__ngwm__getAddressBookListRequest:
		return soap_in__ngwm__getAddressBookListRequest(soap, NULL, NULL, "ngwm:getAddressBookListRequest");
	case SOAP_TYPE__ngwm__forwardResponse:
		return soap_in__ngwm__forwardResponse(soap, NULL, NULL, "ngwm:forwardResponse");
	case SOAP_TYPE__ngwm__forwardRequest:
		return soap_in__ngwm__forwardRequest(soap, NULL, NULL, "ngwm:forwardRequest");
	case SOAP_TYPE__ngwm__executeRuleResponse:
		return soap_in__ngwm__executeRuleResponse(soap, NULL, NULL, "ngwm:executeRuleResponse");
	case SOAP_TYPE__ngwm__executeRuleRequest:
		return soap_in__ngwm__executeRuleRequest(soap, NULL, NULL, "ngwm:executeRuleRequest");
	case SOAP_TYPE__ngwm__destroyCursorResponse:
		return soap_in__ngwm__destroyCursorResponse(soap, NULL, NULL, "ngwm:destroyCursorResponse");
	case SOAP_TYPE__ngwm__destroyCursorRequest:
		return soap_in__ngwm__destroyCursorRequest(soap, NULL, NULL, "ngwm:destroyCursorRequest");
	case SOAP_TYPE__ngwm__delegateResponse:
		return soap_in__ngwm__delegateResponse(soap, NULL, NULL, "ngwm:delegateResponse");
	case SOAP_TYPE__ngwm__delegateRequest:
		return soap_in__ngwm__delegateRequest(soap, NULL, NULL, "ngwm:delegateRequest");
	case SOAP_TYPE__ngwm__declineResponse:
		return soap_in__ngwm__declineResponse(soap, NULL, NULL, "ngwm:declineResponse");
	case SOAP_TYPE__ngwm__declineRequest:
		return soap_in__ngwm__declineRequest(soap, NULL, NULL, "ngwm:declineRequest");
	case SOAP_TYPE__ngwm__createSignatureResponse:
		return soap_in__ngwm__createSignatureResponse(soap, NULL, NULL, "ngwm:createSignatureResponse");
	case SOAP_TYPE__ngwm__createSignatureRequest:
		return soap_in__ngwm__createSignatureRequest(soap, NULL, NULL, "ngwm:createSignatureRequest");
	case SOAP_TYPE__ngwm__createProxyAccessResponse:
		return soap_in__ngwm__createProxyAccessResponse(soap, NULL, NULL, "ngwm:createProxyAccessResponse");
	case SOAP_TYPE__ngwm__createProxyAccessRequest:
		return soap_in__ngwm__createProxyAccessRequest(soap, NULL, NULL, "ngwm:createProxyAccessRequest");
	case SOAP_TYPE__ngwm__createJunkEntryResponse:
		return soap_in__ngwm__createJunkEntryResponse(soap, NULL, NULL, "ngwm:createJunkEntryResponse");
	case SOAP_TYPE__ngwm__createJunkEntryRequest:
		return soap_in__ngwm__createJunkEntryRequest(soap, NULL, NULL, "ngwm:createJunkEntryRequest");
	case SOAP_TYPE__ngwm__createItemsResponse:
		return soap_in__ngwm__createItemsResponse(soap, NULL, NULL, "ngwm:createItemsResponse");
	case SOAP_TYPE__ngwm__createItemsRequest:
		return soap_in__ngwm__createItemsRequest(soap, NULL, NULL, "ngwm:createItemsRequest");
	case SOAP_TYPE__ngwm__createItemResponse:
		return soap_in__ngwm__createItemResponse(soap, NULL, NULL, "ngwm:createItemResponse");
	case SOAP_TYPE__ngwm__createItemRequest:
		return soap_in__ngwm__createItemRequest(soap, NULL, NULL, "ngwm:createItemRequest");
	case SOAP_TYPE__ngwm__createCursorResponse:
		return soap_in__ngwm__createCursorResponse(soap, NULL, NULL, "ngwm:createCursorResponse");
	case SOAP_TYPE__ngwm__createCursorRequest:
		return soap_in__ngwm__createCursorRequest(soap, NULL, NULL, "ngwm:createCursorRequest");
	case SOAP_TYPE__ngwm__completeResponse:
		return soap_in__ngwm__completeResponse(soap, NULL, NULL, "ngwm:completeResponse");
	case SOAP_TYPE__ngwm__completeRequest:
		return soap_in__ngwm__completeRequest(soap, NULL, NULL, "ngwm:completeRequest");
	case SOAP_TYPE__ngwm__closeFreeBusySessionResponse:
		return soap_in__ngwm__closeFreeBusySessionResponse(soap, NULL, NULL, "ngwm:closeFreeBusySessionResponse");
	case SOAP_TYPE__ngwm__closeFreeBusySessionRequest:
		return soap_in__ngwm__closeFreeBusySessionRequest(soap, NULL, NULL, "ngwm:closeFreeBusySessionRequest");
	case SOAP_TYPE__ngwm__addMembersResponse:
		return soap_in__ngwm__addMembersResponse(soap, NULL, NULL, "ngwm:addMembersResponse");
	case SOAP_TYPE__ngwm__addMembersRequest:
		return soap_in__ngwm__addMembersRequest(soap, NULL, NULL, "ngwm:addMembersRequest");
	case SOAP_TYPE__ngwm__addItemsResponse:
		return soap_in__ngwm__addItemsResponse(soap, NULL, NULL, "ngwm:addItemsResponse");
	case SOAP_TYPE__ngwm__addItemsRequest:
		return soap_in__ngwm__addItemsRequest(soap, NULL, NULL, "ngwm:addItemsRequest");
	case SOAP_TYPE__ngwm__addItemResponse:
		return soap_in__ngwm__addItemResponse(soap, NULL, NULL, "ngwm:addItemResponse");
	case SOAP_TYPE__ngwm__addItemRequest:
		return soap_in__ngwm__addItemRequest(soap, NULL, NULL, "ngwm:addItemRequest");
	case SOAP_TYPE__ngwm__acceptShareResponse:
		return soap_in__ngwm__acceptShareResponse(soap, NULL, NULL, "ngwm:acceptShareResponse");
	case SOAP_TYPE__ngwm__acceptShareRequest:
		return soap_in__ngwm__acceptShareRequest(soap, NULL, NULL, "ngwm:acceptShareRequest");
	case SOAP_TYPE__ngwm__acceptResponse:
		return soap_in__ngwm__acceptResponse(soap, NULL, NULL, "ngwm:acceptResponse");
	case SOAP_TYPE__ngwm__acceptRequest:
		return soap_in__ngwm__acceptRequest(soap, NULL, NULL, "ngwm:acceptRequest");
	case SOAP_TYPE_ngwt__VersionEvent:
		return soap_in_ngwt__VersionEvent(soap, NULL, NULL, "ngwt:VersionEvent");
	case SOAP_TYPE_ngwt__Version:
		return soap_in_ngwt__Version(soap, NULL, NULL, "ngwt:Version");
	case SOAP_TYPE_ngwt__UserList:
		return soap_in_ngwt__UserList(soap, NULL, NULL, "ngwt:UserList");
	case SOAP_TYPE_ngwt__UserInfo:
		return soap_in_ngwt__UserInfo(soap, NULL, NULL, "ngwt:UserInfo");
	case SOAP_TYPE_ngwt__TrustedApplication:
		return soap_in_ngwt__TrustedApplication(soap, NULL, NULL, "ngwt:TrustedApplication");
	case SOAP_TYPE_ngwt__TransferFailedStatus:
		return soap_in_ngwt__TransferFailedStatus(soap, NULL, NULL, "ngwt:TransferFailedStatus");
	case SOAP_TYPE_ngwt__TimezoneList:
		return soap_in_ngwt__TimezoneList(soap, NULL, NULL, "ngwt:TimezoneList");
	case SOAP_TYPE_ngwt__TimezoneComponent:
		return soap_in_ngwt__TimezoneComponent(soap, NULL, NULL, "ngwt:TimezoneComponent");
	case SOAP_TYPE_ngwt__Timezone:
		return soap_in_ngwt__Timezone(soap, NULL, NULL, "ngwt:Timezone");
	case SOAP_TYPE_ngwt__Task:
		return soap_in_ngwt__Task(soap, NULL, NULL, "ngwt:Task");
	case SOAP_TYPE_ngwt__SystemFolder:
		return soap_in_ngwt__SystemFolder(soap, NULL, NULL, "ngwt:SystemFolder");
	case SOAP_TYPE_ngwt__StatusTracking:
		return soap_in_ngwt__StatusTracking(soap, NULL, NULL, "ngwt:StatusTracking");
	case SOAP_TYPE_ngwt__Status:
		return soap_in_ngwt__Status(soap, NULL, NULL, "ngwt:Status");
	case SOAP_TYPE_ngwt__SMimeOperation:
		return soap_in_ngwt__SMimeOperation(soap, NULL, NULL, "ngwt:SMimeOperation");
	case SOAP_TYPE_ngwt__SignatureData:
		return soap_in_ngwt__SignatureData(soap, NULL, NULL, "ngwt:SignatureData");
	case SOAP_TYPE_ngwt__Signatures:
		return soap_in_ngwt__Signatures(soap, NULL, NULL, "ngwt:Signatures");
	case SOAP_TYPE_ngwt__Signature:
		return soap_in_ngwt__Signature(soap, NULL, NULL, "ngwt:Signature");
	case SOAP_TYPE_ngwt__SharedNotification:
		return soap_in_ngwt__SharedNotification(soap, NULL, NULL, "ngwt:SharedNotification");
	case SOAP_TYPE_ngwt__SharedFolderNotification:
		return soap_in_ngwt__SharedFolderNotification(soap, NULL, NULL, "ngwt:SharedFolderNotification");
	case SOAP_TYPE_ngwt__SharedFolder:
		return soap_in_ngwt__SharedFolder(soap, NULL, NULL, "ngwt:SharedFolder");
	case SOAP_TYPE_ngwt__SettingsList:
		return soap_in_ngwt__SettingsList(soap, NULL, NULL, "ngwt:SettingsList");
	case SOAP_TYPE_ngwt__SettingsGroup:
		return soap_in_ngwt__SettingsGroup(soap, NULL, NULL, "ngwt:SettingsGroup");
	case SOAP_TYPE_ngwt__Settings:
		return soap_in_ngwt__Settings(soap, NULL, NULL, "ngwt:Settings");
	case SOAP_TYPE_ngwt__SendOptions:
		return soap_in_ngwt__SendOptions(soap, NULL, NULL, "ngwt:SendOptions");
	case SOAP_TYPE_ngwt__SendOptionsRequestReply:
		return soap_in_ngwt__SendOptionsRequestReply(soap, NULL, NULL, "ngwt:SendOptionsRequestReply");
	case SOAP_TYPE_ngwt__RuleList:
		return soap_in_ngwt__RuleList(soap, NULL, NULL, "ngwt:RuleList");
	case SOAP_TYPE_ngwt__RuleActionList:
		return soap_in_ngwt__RuleActionList(soap, NULL, NULL, "ngwt:RuleActionList");
	case SOAP_TYPE_ngwt__RuleAction:
		return soap_in_ngwt__RuleAction(soap, NULL, NULL, "ngwt:RuleAction");
	case SOAP_TYPE_ngwt__Rule:
		return soap_in_ngwt__Rule(soap, NULL, NULL, "ngwt:Rule");
	case SOAP_TYPE_ngwt__Rights:
		return soap_in_ngwt__Rights(soap, NULL, NULL, "ngwt:Rights");
	case SOAP_TYPE_ngwt__ReturnNotificationOptions:
		return soap_in_ngwt__ReturnNotificationOptions(soap, NULL, NULL, "ngwt:ReturnNotificationOptions");
	case SOAP_TYPE_ngwt__ReturnNotification:
		return soap_in_ngwt__ReturnNotification(soap, NULL, NULL, "ngwt:ReturnNotification");
	case SOAP_TYPE_ngwt__Resource:
		return soap_in_ngwt__Resource(soap, NULL, NULL, "ngwt:Resource");
	case SOAP_TYPE_ngwt__ReferenceInfo:
		return soap_in_ngwt__ReferenceInfo(soap, NULL, NULL, "ngwt:ReferenceInfo");
	case SOAP_TYPE_ngwt__RecurrenceRule:
		return soap_in_ngwt__RecurrenceRule(soap, NULL, NULL, "ngwt:RecurrenceRule");
	case SOAP_TYPE_ngwt__RecurrenceDateType:
		return soap_in_ngwt__RecurrenceDateType(soap, NULL, NULL, "ngwt:RecurrenceDateType");
	case SOAP_TYPE_ngwt__RecipientStatus:
		return soap_in_ngwt__RecipientStatus(soap, NULL, NULL, "ngwt:RecipientStatus");
	case SOAP_TYPE_ngwt__RecipientList:
		return soap_in_ngwt__RecipientList(soap, NULL, NULL, "ngwt:RecipientList");
	case SOAP_TYPE_ngwt__Recipient:
		return soap_in_ngwt__Recipient(soap, NULL, NULL, "ngwt:Recipient");
	case SOAP_TYPE_ngwt__QueryTarget:
		return soap_in_ngwt__QueryTarget(soap, NULL, NULL, "ngwt:QueryTarget");
	case SOAP_TYPE_ngwt__QueryFolder:
		return soap_in_ngwt__QueryFolder(soap, NULL, NULL, "ngwt:QueryFolder");
	case SOAP_TYPE_ngwt__Query:
		return soap_in_ngwt__Query(soap, NULL, NULL, "ngwt:Query");
	case SOAP_TYPE_ngwt__ProxyList:
		return soap_in_ngwt__ProxyList(soap, NULL, NULL, "ngwt:ProxyList");
	case SOAP_TYPE_ngwt__ProxyUser:
		return soap_in_ngwt__ProxyUser(soap, NULL, NULL, "ngwt:ProxyUser");
	case SOAP_TYPE_ngwt__Proxy:
		return soap_in_ngwt__Proxy(soap, NULL, NULL, "ngwt:Proxy");
	case SOAP_TYPE_ngwt__ProblemList:
		return soap_in_ngwt__ProblemList(soap, NULL, NULL, "ngwt:ProblemList");
	case SOAP_TYPE_ngwt__ProblemEntry:
		return soap_in_ngwt__ProblemEntry(soap, NULL, NULL, "ngwt:ProblemEntry");
	case SOAP_TYPE_ngwt__PostalAddressList:
		return soap_in_ngwt__PostalAddressList(soap, NULL, NULL, "ngwt:PostalAddressList");
	case SOAP_TYPE_ngwt__PostalAddress:
		return soap_in_ngwt__PostalAddress(soap, NULL, NULL, "ngwt:PostalAddress");
	case SOAP_TYPE_ngwt__PlainText:
		return soap_in_ngwt__PlainText(soap, NULL, NULL, "ngwt:PlainText");
	case SOAP_TYPE_ngwt__PhoneNumber:
		return soap_in_ngwt__PhoneNumber(soap, NULL, NULL, "ngwt:PhoneNumber");
	case SOAP_TYPE_ngwt__PhoneMessage:
		return soap_in_ngwt__PhoneMessage(soap, NULL, NULL, "ngwt:PhoneMessage");
	case SOAP_TYPE_ngwt__PhoneList:
		return soap_in_ngwt__PhoneList(soap, NULL, NULL, "ngwt:PhoneList");
	case SOAP_TYPE_ngwt__PhoneFlags:
		return soap_in_ngwt__PhoneFlags(soap, NULL, NULL, "ngwt:PhoneFlags");
	case SOAP_TYPE_ngwt__PersonalInfo:
		return soap_in_ngwt__PersonalInfo(soap, NULL, NULL, "ngwt:PersonalInfo");
	case SOAP_TYPE_ngwt__Organization:
		return soap_in_ngwt__Organization(soap, NULL, NULL, "ngwt:Organization");
	case SOAP_TYPE_ngwt__OfficeInfo:
		return soap_in_ngwt__OfficeInfo(soap, NULL, NULL, "ngwt:OfficeInfo");
	case SOAP_TYPE_ngwt__Note:
		return soap_in_ngwt__Note(soap, NULL, NULL, "ngwt:Note");
	case SOAP_TYPE_ngwt__NameAndEmail:
		return soap_in_ngwt__NameAndEmail(soap, NULL, NULL, "ngwt:NameAndEmail");
	case SOAP_TYPE_ngwt__MonthList:
		return soap_in_ngwt__MonthList(soap, NULL, NULL, "ngwt:MonthList");
	case SOAP_TYPE_ngwt__ModifyItem:
		return soap_in_ngwt__ModifyItem(soap, NULL, NULL, "ngwt:ModifyItem");
	case SOAP_TYPE_ngwt__MessagePart:
		return soap_in_ngwt__MessagePart(soap, NULL, NULL, "ngwt:MessagePart");
	case SOAP_TYPE_ngwt__MessageBody:
		return soap_in_ngwt__MessageBody(soap, NULL, NULL, "ngwt:MessageBody");
	case SOAP_TYPE_ngwt__Mail:
		return soap_in_ngwt__Mail(soap, NULL, NULL, "ngwt:Mail");
	case SOAP_TYPE_ngwt__LinkInfo:
		return soap_in_ngwt__LinkInfo(soap, NULL, NULL, "ngwt:LinkInfo");
	case SOAP_TYPE_ngwt__LibraryList:
		return soap_in_ngwt__LibraryList(soap, NULL, NULL, "ngwt:LibraryList");
	case SOAP_TYPE_ngwt__Library:
		return soap_in_ngwt__Library(soap, NULL, NULL, "ngwt:Library");
	case SOAP_TYPE_ngwt__JunkHandlingList:
		return soap_in_ngwt__JunkHandlingList(soap, NULL, NULL, "ngwt:JunkHandlingList");
	case SOAP_TYPE_ngwt__JunkEntry:
		return soap_in_ngwt__JunkEntry(soap, NULL, NULL, "ngwt:JunkEntry");
	case SOAP_TYPE_ngwt__ItemStatus:
		return soap_in_ngwt__ItemStatus(soap, NULL, NULL, "ngwt:ItemStatus");
	case SOAP_TYPE_ngwt__Items:
		return soap_in_ngwt__Items(soap, NULL, NULL, "ngwt:Items");
	case SOAP_TYPE_ngwt__ItemRefList:
		return soap_in_ngwt__ItemRefList(soap, NULL, NULL, "ngwt:ItemRefList");
	case SOAP_TYPE_ngwt__ItemRef:
		return soap_in_ngwt__ItemRef(soap, NULL, NULL, "ngwt:ItemRef");
	case SOAP_TYPE_ngwt__ItemOptions:
		return soap_in_ngwt__ItemOptions(soap, NULL, NULL, "ngwt:ItemOptions");
	case SOAP_TYPE_ngwt__ItemList:
		return soap_in_ngwt__ItemList(soap, NULL, NULL, "ngwt:ItemList");
	case SOAP_TYPE_ngwt__ItemChanges:
		return soap_in_ngwt__ItemChanges(soap, NULL, NULL, "ngwt:ItemChanges");
	case SOAP_TYPE_ngwt__Item:
		return soap_in_ngwt__Item(soap, NULL, NULL, "ngwt:Item");
	case SOAP_TYPE_ngwt__ImAddressList:
		return soap_in_ngwt__ImAddressList(soap, NULL, NULL, "ngwt:ImAddressList");
	case SOAP_TYPE_ngwt__ImAddress:
		return soap_in_ngwt__ImAddress(soap, NULL, NULL, "ngwt:ImAddress");
	case SOAP_TYPE_ngwt__Host:
		return soap_in_ngwt__Host(soap, NULL, NULL, "ngwt:Host");
	case SOAP_TYPE_ngwt__GroupMemberList:
		return soap_in_ngwt__GroupMemberList(soap, NULL, NULL, "ngwt:GroupMemberList");
	case SOAP_TYPE_ngwt__GroupMember:
		return soap_in_ngwt__GroupMember(soap, NULL, NULL, "ngwt:GroupMember");
	case SOAP_TYPE_ngwt__Group:
		return soap_in_ngwt__Group(soap, NULL, NULL, "ngwt:Group");
	case SOAP_TYPE_ngwt__FullName:
		return soap_in_ngwt__FullName(soap, NULL, NULL, "ngwt:FullName");
	case SOAP_TYPE_ngwt__From:
		return soap_in_ngwt__From(soap, NULL, NULL, "ngwt:From");
	case SOAP_TYPE_ngwt__FreeBusyStats:
		return soap_in_ngwt__FreeBusyStats(soap, NULL, NULL, "ngwt:FreeBusyStats");
	case SOAP_TYPE_ngwt__FreeBusyInfoList:
		return soap_in_ngwt__FreeBusyInfoList(soap, NULL, NULL, "ngwt:FreeBusyInfoList");
	case SOAP_TYPE_ngwt__FreeBusyUserList:
		return soap_in_ngwt__FreeBusyUserList(soap, NULL, NULL, "ngwt:FreeBusyUserList");
	case SOAP_TYPE_ngwt__FreeBusyInfo:
		return soap_in_ngwt__FreeBusyInfo(soap, NULL, NULL, "ngwt:FreeBusyInfo");
	case SOAP_TYPE_ngwt__FreeBusyBlock:
		return soap_in_ngwt__FreeBusyBlock(soap, NULL, NULL, "ngwt:FreeBusyBlock");
	case SOAP_TYPE_ngwt__FreeBusyBlockList:
		return soap_in_ngwt__FreeBusyBlockList(soap, NULL, NULL, "ngwt:FreeBusyBlockList");
	case SOAP_TYPE_ngwt__FolderList:
		return soap_in_ngwt__FolderList(soap, NULL, NULL, "ngwt:FolderList");
	case SOAP_TYPE_ngwt__FolderACLEntry:
		return soap_in_ngwt__FolderACLEntry(soap, NULL, NULL, "ngwt:FolderACLEntry");
	case SOAP_TYPE_ngwt__FolderACL:
		return soap_in_ngwt__FolderACL(soap, NULL, NULL, "ngwt:FolderACL");
	case SOAP_TYPE_ngwt__Folder:
		return soap_in_ngwt__Folder(soap, NULL, NULL, "ngwt:Folder");
	case SOAP_TYPE_ngwt__FilterGroup:
		return soap_in_ngwt__FilterGroup(soap, NULL, NULL, "ngwt:FilterGroup");
	case SOAP_TYPE_ngwt__FilterEntry:
		return soap_in_ngwt__FilterEntry(soap, NULL, NULL, "ngwt:FilterEntry");
	case SOAP_TYPE_ngwt__FilterElement:
		return soap_in_ngwt__FilterElement(soap, NULL, NULL, "ngwt:FilterElement");
	case SOAP_TYPE_ngwt__Filter:
		return soap_in_ngwt__Filter(soap, NULL, NULL, "ngwt:Filter");
	case SOAP_TYPE_ngwt__EmailAddressList:
		return soap_in_ngwt__EmailAddressList(soap, NULL, NULL, "ngwt:EmailAddressList");
	case SOAP_TYPE_ngwt__DocumentTypeList:
		return soap_in_ngwt__DocumentTypeList(soap, NULL, NULL, "ngwt:DocumentTypeList");
	case SOAP_TYPE_ngwt__DocumentType:
		return soap_in_ngwt__DocumentType(soap, NULL, NULL, "ngwt:DocumentType");
	case SOAP_TYPE_ngwt__DocumentRef:
		return soap_in_ngwt__DocumentRef(soap, NULL, NULL, "ngwt:DocumentRef");
	case SOAP_TYPE_ngwt__Document:
		return soap_in_ngwt__Document(soap, NULL, NULL, "ngwt:Document");
	case SOAP_TYPE_ngwt__Distribution:
		return soap_in_ngwt__Distribution(soap, NULL, NULL, "ngwt:Distribution");
	case SOAP_TYPE_ngwt__DeltaInfo:
		return soap_in_ngwt__DeltaInfo(soap, NULL, NULL, "ngwt:DeltaInfo");
	case SOAP_TYPE_ngwt__DelegateeStatus:
		return soap_in_ngwt__DelegateeStatus(soap, NULL, NULL, "ngwt:DelegateeStatus");
	case SOAP_TYPE_ngwt__DelegatedStatus:
		return soap_in_ngwt__DelegatedStatus(soap, NULL, NULL, "ngwt:DelegatedStatus");
	case SOAP_TYPE_ngwt__DayOfYearWeekList:
		return soap_in_ngwt__DayOfYearWeekList(soap, NULL, NULL, "ngwt:DayOfYearWeekList");
	case SOAP_TYPE_ngwt__DayOfYearWeek:
		return soap_in_ngwt__DayOfYearWeek(soap, NULL, NULL, "ngwt:DayOfYearWeek");
	case SOAP_TYPE_ngwt__DayOfYearList:
		return soap_in_ngwt__DayOfYearList(soap, NULL, NULL, "ngwt:DayOfYearList");
	case SOAP_TYPE_ngwt__DayOfWeek:
		return soap_in_ngwt__DayOfWeek(soap, NULL, NULL, "ngwt:DayOfWeek");
	case SOAP_TYPE_ngwt__DayOfMonthList:
		return soap_in_ngwt__DayOfMonthList(soap, NULL, NULL, "ngwt:DayOfMonthList");
	case SOAP_TYPE_ngwt__CustomList:
		return soap_in_ngwt__CustomList(soap, NULL, NULL, "ngwt:CustomList");
	case SOAP_TYPE_ngwt__Custom:
		return soap_in_ngwt__Custom(soap, NULL, NULL, "ngwt:Custom");
	case SOAP_TYPE_ngwt__ContainerRef:
		return soap_in_ngwt__ContainerRef(soap, NULL, NULL, "ngwt:ContainerRef");
	case SOAP_TYPE_ngwt__ContainerItem:
		return soap_in_ngwt__ContainerItem(soap, NULL, NULL, "ngwt:ContainerItem");
	case SOAP_TYPE_ngwt__ContactFolder:
		return soap_in_ngwt__ContactFolder(soap, NULL, NULL, "ngwt:ContactFolder");
	case SOAP_TYPE_ngwt__Contact:
		return soap_in_ngwt__Contact(soap, NULL, NULL, "ngwt:Contact");
	case SOAP_TYPE_ngwt__CommentStatus:
		return soap_in_ngwt__CommentStatus(soap, NULL, NULL, "ngwt:CommentStatus");
	case SOAP_TYPE_ngwt__CategoryRefList:
		return soap_in_ngwt__CategoryRefList(soap, NULL, NULL, "ngwt:CategoryRefList");
	case SOAP_TYPE_ngwt__CategoryList:
		return soap_in_ngwt__CategoryList(soap, NULL, NULL, "ngwt:CategoryList");
	case SOAP_TYPE_ngwt__Category:
		return soap_in_ngwt__Category(soap, NULL, NULL, "ngwt:Category");
	case SOAP_TYPE_ngwt__CalendarItem:
		return soap_in_ngwt__CalendarItem(soap, NULL, NULL, "ngwt:CalendarItem");
	case SOAP_TYPE_ngwt__CalendarFolderAttribute:
		return soap_in_ngwt__CalendarFolderAttribute(soap, NULL, NULL, "ngwt:CalendarFolderAttribute");
	case SOAP_TYPE_ngwt__BoxEntry:
		return soap_in_ngwt__BoxEntry(soap, NULL, NULL, "ngwt:BoxEntry");
	case SOAP_TYPE_ngwt__Authentication:
		return soap_in_ngwt__Authentication(soap, NULL, NULL, "ngwt:Authentication");
	case SOAP_TYPE_ngwt__AttachmentItemInfo:
		return soap_in_ngwt__AttachmentItemInfo(soap, NULL, NULL, "ngwt:AttachmentItemInfo");
	case SOAP_TYPE_ngwt__AttachmentInfo:
		return soap_in_ngwt__AttachmentInfo(soap, NULL, NULL, "ngwt:AttachmentInfo");
	case SOAP_TYPE_ngwt__AttachmentID:
		return soap_in_ngwt__AttachmentID(soap, NULL, NULL, "ngwt:AttachmentID");
	case SOAP_TYPE_ngwt__Appointment:
		return soap_in_ngwt__Appointment(soap, NULL, NULL, "ngwt:Appointment");
	case SOAP_TYPE_ngwt__Alarm:
		return soap_in_ngwt__Alarm(soap, NULL, NULL, "ngwt:Alarm");
	case SOAP_TYPE_ngwt__AddressBookList:
		return soap_in_ngwt__AddressBookList(soap, NULL, NULL, "ngwt:AddressBookList");
	case SOAP_TYPE_ngwt__AddressBookItem:
		return soap_in_ngwt__AddressBookItem(soap, NULL, NULL, "ngwt:AddressBookItem");
	case SOAP_TYPE_ngwt__AddressBook:
		return soap_in_ngwt__AddressBook(soap, NULL, NULL, "ngwt:AddressBook");
	case SOAP_TYPE_ngwt__AccessRightList:
		return soap_in_ngwt__AccessRightList(soap, NULL, NULL, "ngwt:AccessRightList");
	case SOAP_TYPE_ngwt__AccessRightEntry:
		return soap_in_ngwt__AccessRightEntry(soap, NULL, NULL, "ngwt:AccessRightEntry");
	case SOAP_TYPE_ngwt__AccessRightChanges:
		return soap_in_ngwt__AccessRightChanges(soap, NULL, NULL, "ngwt:AccessRightChanges");
	case SOAP_TYPE_ngwt__AccessRight:
		return soap_in_ngwt__AccessRight(soap, NULL, NULL, "ngwt:AccessRight");
	case SOAP_TYPE_ngwt__AccessMiscRight:
		return soap_in_ngwt__AccessMiscRight(soap, NULL, NULL, "ngwt:AccessMiscRight");
	case SOAP_TYPE_ngwt__AccessControlList:
		return soap_in_ngwt__AccessControlList(soap, NULL, NULL, "ngwt:AccessControlList");
	case SOAP_TYPE_ngwt__AccessControlListEntry:
		return soap_in_ngwt__AccessControlListEntry(soap, NULL, NULL, "ngwt:AccessControlListEntry");
	case SOAP_TYPE_xsd__language:
		return soap_in_xsd__language(soap, NULL, NULL, "xsd:language");
	case SOAP_TYPE_xsd__duration:
		return soap_in_xsd__duration(soap, NULL, NULL, "xsd:duration");
	case SOAP_TYPE_xsd__decimal:
		return soap_in_xsd__decimal(soap, NULL, NULL, "xsd:decimal");
	case SOAP_TYPE_xsd__date:
		return soap_in_xsd__date(soap, NULL, NULL, "xsd:date");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_ngwe__removeEventsResponse:
		return soap_in_PointerTo_ngwe__removeEventsResponse(soap, NULL, NULL, "ngwe:removeEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__removeEventsRequest:
		return soap_in_PointerTo_ngwe__removeEventsRequest(soap, NULL, NULL, "ngwe:removeEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationResponse:
		return soap_in_PointerTo_ngwe__removeEventConfigurationResponse(soap, NULL, NULL, "ngwe:removeEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationRequest:
		return soap_in_PointerTo_ngwe__removeEventConfigurationRequest(soap, NULL, NULL, "ngwe:removeEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwe__getEventsResponse:
		return soap_in_PointerTo_ngwe__getEventsResponse(soap, NULL, NULL, "ngwe:getEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__getEventsRequest:
		return soap_in_PointerTo_ngwe__getEventsRequest(soap, NULL, NULL, "ngwe:getEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationResponse:
		return soap_in_PointerTo_ngwe__getEventConfigurationResponse(soap, NULL, NULL, "ngwe:getEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationRequest:
		return soap_in_PointerTo_ngwe__getEventConfigurationRequest(soap, NULL, NULL, "ngwe:getEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwe__configureEventsResponse:
		return soap_in_PointerTo_ngwe__configureEventsResponse(soap, NULL, NULL, "ngwe:configureEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__configureEventsRequest:
		return soap_in_PointerTo_ngwe__configureEventsRequest(soap, NULL, NULL, "ngwe:configureEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationResponse:
		return soap_in_PointerTo_ngwe__cleanEventConfigurationResponse(soap, NULL, NULL, "ngwe:cleanEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationRequest:
		return soap_in_PointerTo_ngwe__cleanEventConfigurationRequest(soap, NULL, NULL, "ngwe:cleanEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusResponse:
		return soap_in_PointerTo_ngwm__updateVersionStatusResponse(soap, NULL, NULL, "ngwm:updateVersionStatusResponse");
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusRequest:
		return soap_in_PointerTo_ngwm__updateVersionStatusRequest(soap, NULL, NULL, "ngwm:updateVersionStatusRequest");
	case SOAP_TYPE_PointerTo_ngwm__uncompleteResponse:
		return soap_in_PointerTo_ngwm__uncompleteResponse(soap, NULL, NULL, "ngwm:uncompleteResponse");
	case SOAP_TYPE_PointerTo_ngwm__uncompleteRequest:
		return soap_in_PointerTo_ngwm__uncompleteRequest(soap, NULL, NULL, "ngwm:uncompleteRequest");
	case SOAP_TYPE_PointerTo_ngwm__unacceptResponse:
		return soap_in_PointerTo_ngwm__unacceptResponse(soap, NULL, NULL, "ngwm:unacceptResponse");
	case SOAP_TYPE_PointerTo_ngwm__unacceptRequest:
		return soap_in_PointerTo_ngwm__unacceptRequest(soap, NULL, NULL, "ngwm:unacceptRequest");
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionResponse:
		return soap_in_PointerTo_ngwm__startFreeBusySessionResponse(soap, NULL, NULL, "ngwm:startFreeBusySessionResponse");
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionRequest:
		return soap_in_PointerTo_ngwm__startFreeBusySessionRequest(soap, NULL, NULL, "ngwm:startFreeBusySessionRequest");
	case SOAP_TYPE_PointerTo_ngwm__setTimestampResponse:
		return soap_in_PointerTo_ngwm__setTimestampResponse(soap, NULL, NULL, "ngwm:setTimestampResponse");
	case SOAP_TYPE_PointerTo_ngwm__setTimestampRequest:
		return soap_in_PointerTo_ngwm__setTimestampRequest(soap, NULL, NULL, "ngwm:setTimestampRequest");
	case SOAP_TYPE_PointerTo_ngwm__sendItemResponse:
		return soap_in_PointerTo_ngwm__sendItemResponse(soap, NULL, NULL, "ngwm:sendItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__sendItemRequest:
		return soap_in_PointerTo_ngwm__sendItemRequest(soap, NULL, NULL, "ngwm:sendItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__retractResponse:
		return soap_in_PointerTo_ngwm__retractResponse(soap, NULL, NULL, "ngwm:retractResponse");
	case SOAP_TYPE_PointerTo_ngwm__retractRequest:
		return soap_in_PointerTo_ngwm__retractRequest(soap, NULL, NULL, "ngwm:retractRequest");
	case SOAP_TYPE_PointerTo_ngwm__replyResponse:
		return soap_in_PointerTo_ngwm__replyResponse(soap, NULL, NULL, "ngwm:replyResponse");
	case SOAP_TYPE_PointerTo_ngwm__replyRequest:
		return soap_in_PointerTo_ngwm__replyRequest(soap, NULL, NULL, "ngwm:replyRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureResponse:
		return soap_in_PointerTo_ngwm__removeSignatureResponse(soap, NULL, NULL, "ngwm:removeSignatureResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureRequest:
		return soap_in_PointerTo_ngwm__removeSignatureRequest(soap, NULL, NULL, "ngwm:removeSignatureRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserResponse:
		return soap_in_PointerTo_ngwm__removeProxyUserResponse(soap, NULL, NULL, "ngwm:removeProxyUserResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserRequest:
		return soap_in_PointerTo_ngwm__removeProxyUserRequest(soap, NULL, NULL, "ngwm:removeProxyUserRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessResponse:
		return soap_in_PointerTo_ngwm__removeProxyAccessResponse(soap, NULL, NULL, "ngwm:removeProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessRequest:
		return soap_in_PointerTo_ngwm__removeProxyAccessRequest(soap, NULL, NULL, "ngwm:removeProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeMembersResponse:
		return soap_in_PointerTo_ngwm__removeMembersResponse(soap, NULL, NULL, "ngwm:removeMembersResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeMembersRequest:
		return soap_in_PointerTo_ngwm__removeMembersRequest(soap, NULL, NULL, "ngwm:removeMembersRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryResponse:
		return soap_in_PointerTo_ngwm__removeJunkEntryResponse(soap, NULL, NULL, "ngwm:removeJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryRequest:
		return soap_in_PointerTo_ngwm__removeJunkEntryRequest(soap, NULL, NULL, "ngwm:removeJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeItemsResponse:
		return soap_in_PointerTo_ngwm__removeItemsResponse(soap, NULL, NULL, "ngwm:removeItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeItemsRequest:
		return soap_in_PointerTo_ngwm__removeItemsRequest(soap, NULL, NULL, "ngwm:removeItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeItemResponse:
		return soap_in_PointerTo_ngwm__removeItemResponse(soap, NULL, NULL, "ngwm:removeItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeItemRequest:
		return soap_in_PointerTo_ngwm__removeItemRequest(soap, NULL, NULL, "ngwm:removeItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionResponse:
		return soap_in_PointerTo_ngwm__removeCustomDefinitionResponse(soap, NULL, NULL, "ngwm:removeCustomDefinitionResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionRequest:
		return soap_in_PointerTo_ngwm__removeCustomDefinitionRequest(soap, NULL, NULL, "ngwm:removeCustomDefinitionRequest");
	case SOAP_TYPE_PointerTo_ngwm__readCursorResponse:
		return soap_in_PointerTo_ngwm__readCursorResponse(soap, NULL, NULL, "ngwm:readCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__readCursorRequest:
		return soap_in_PointerTo_ngwm__readCursorRequest(soap, NULL, NULL, "ngwm:readCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__purgeResponse:
		return soap_in_PointerTo_ngwm__purgeResponse(soap, NULL, NULL, "ngwm:purgeResponse");
	case SOAP_TYPE_PointerTo_ngwm__purgeRequest:
		return soap_in_PointerTo_ngwm__purgeRequest(soap, NULL, NULL, "ngwm:purgeRequest");
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsResponse:
		return soap_in_PointerTo_ngwm__purgeDeletedItemsResponse(soap, NULL, NULL, "ngwm:purgeDeletedItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsRequest:
		return soap_in_PointerTo_ngwm__purgeDeletedItemsRequest(soap, NULL, NULL, "ngwm:purgeDeletedItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__positionCursorResponse:
		return soap_in_PointerTo_ngwm__positionCursorResponse(soap, NULL, NULL, "ngwm:positionCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__positionCursorRequest:
		return soap_in_PointerTo_ngwm__positionCursorRequest(soap, NULL, NULL, "ngwm:positionCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__moveItemResponse:
		return soap_in_PointerTo_ngwm__moveItemResponse(soap, NULL, NULL, "ngwm:moveItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__moveItemRequest:
		return soap_in_PointerTo_ngwm__moveItemRequest(soap, NULL, NULL, "ngwm:moveItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesResponse:
		return soap_in_PointerTo_ngwm__modifySignaturesResponse(soap, NULL, NULL, "ngwm:modifySignaturesResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesRequest:
		return soap_in_PointerTo_ngwm__modifySignaturesRequest(soap, NULL, NULL, "ngwm:modifySignaturesRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsResponse:
		return soap_in_PointerTo_ngwm__modifySettingsResponse(soap, NULL, NULL, "ngwm:modifySettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsRequest:
		return soap_in_PointerTo_ngwm__modifySettingsRequest(soap, NULL, NULL, "ngwm:modifySettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessResponse:
		return soap_in_PointerTo_ngwm__modifyProxyAccessResponse(soap, NULL, NULL, "ngwm:modifyProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessRequest:
		return soap_in_PointerTo_ngwm__modifyProxyAccessRequest(soap, NULL, NULL, "ngwm:modifyProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordResponse:
		return soap_in_PointerTo_ngwm__modifyPasswordResponse(soap, NULL, NULL, "ngwm:modifyPasswordResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordRequest:
		return soap_in_PointerTo_ngwm__modifyPasswordRequest(soap, NULL, NULL, "ngwm:modifyPasswordRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsResponse:
		return soap_in_PointerTo_ngwm__modifyJunkMailSettingsResponse(soap, NULL, NULL, "ngwm:modifyJunkMailSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsRequest:
		return soap_in_PointerTo_ngwm__modifyJunkMailSettingsRequest(soap, NULL, NULL, "ngwm:modifyJunkMailSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryResponse:
		return soap_in_PointerTo_ngwm__modifyJunkEntryResponse(soap, NULL, NULL, "ngwm:modifyJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryRequest:
		return soap_in_PointerTo_ngwm__modifyJunkEntryRequest(soap, NULL, NULL, "ngwm:modifyJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyItemResponse:
		return soap_in_PointerTo_ngwm__modifyItemResponse(soap, NULL, NULL, "ngwm:modifyItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyItemRequest:
		return soap_in_PointerTo_ngwm__modifyItemRequest(soap, NULL, NULL, "ngwm:modifyItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__markUnReadResponse:
		return soap_in_PointerTo_ngwm__markUnReadResponse(soap, NULL, NULL, "ngwm:markUnReadResponse");
	case SOAP_TYPE_PointerTo_ngwm__markUnReadRequest:
		return soap_in_PointerTo_ngwm__markUnReadRequest(soap, NULL, NULL, "ngwm:markUnReadRequest");
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateResponse:
		return soap_in_PointerTo_ngwm__markUnPrivateResponse(soap, NULL, NULL, "ngwm:markUnPrivateResponse");
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateRequest:
		return soap_in_PointerTo_ngwm__markUnPrivateRequest(soap, NULL, NULL, "ngwm:markUnPrivateRequest");
	case SOAP_TYPE_PointerTo_ngwm__markReadResponse:
		return soap_in_PointerTo_ngwm__markReadResponse(soap, NULL, NULL, "ngwm:markReadResponse");
	case SOAP_TYPE_PointerTo_ngwm__markReadRequest:
		return soap_in_PointerTo_ngwm__markReadRequest(soap, NULL, NULL, "ngwm:markReadRequest");
	case SOAP_TYPE_PointerTo_ngwm__markPrivateResponse:
		return soap_in_PointerTo_ngwm__markPrivateResponse(soap, NULL, NULL, "ngwm:markPrivateResponse");
	case SOAP_TYPE_PointerTo_ngwm__markPrivateRequest:
		return soap_in_PointerTo_ngwm__markPrivateRequest(soap, NULL, NULL, "ngwm:markPrivateRequest");
	case SOAP_TYPE_PointerTo_ngwm__logoutResponse:
		return soap_in_PointerTo_ngwm__logoutResponse(soap, NULL, NULL, "ngwm:logoutResponse");
	case SOAP_TYPE_PointerTo_ngwm__logoutRequest:
		return soap_in_PointerTo_ngwm__logoutRequest(soap, NULL, NULL, "ngwm:logoutRequest");
	case SOAP_TYPE_PointerTo_ngwm__loginResponse:
		return soap_in_PointerTo_ngwm__loginResponse(soap, NULL, NULL, "ngwm:loginResponse");
	case SOAP_TYPE_PointerTo_ngwm__loginRequest:
		return soap_in_PointerTo_ngwm__loginRequest(soap, NULL, NULL, "ngwm:loginRequest");
	case SOAP_TYPE_PointerTo_ngwm__getUserListResponse:
		return soap_in_PointerTo_ngwm__getUserListResponse(soap, NULL, NULL, "ngwm:getUserListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getUserListRequest:
		return soap_in_PointerTo_ngwm__getUserListRequest(soap, NULL, NULL, "ngwm:getUserListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListResponse:
		return soap_in_PointerTo_ngwm__getTimezoneListResponse(soap, NULL, NULL, "ngwm:getTimezoneListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListRequest:
		return soap_in_PointerTo_ngwm__getTimezoneListRequest(soap, NULL, NULL, "ngwm:getTimezoneListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getTimestampResponse:
		return soap_in_PointerTo_ngwm__getTimestampResponse(soap, NULL, NULL, "ngwm:getTimestampResponse");
	case SOAP_TYPE_PointerTo_ngwm__getTimestampRequest:
		return soap_in_PointerTo_ngwm__getTimestampRequest(soap, NULL, NULL, "ngwm:getTimestampRequest");
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesResponse:
		return soap_in_PointerTo_ngwm__getSignaturesResponse(soap, NULL, NULL, "ngwm:getSignaturesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesRequest:
		return soap_in_PointerTo_ngwm__getSignaturesRequest(soap, NULL, NULL, "ngwm:getSignaturesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getSettingsResponse:
		return soap_in_PointerTo_ngwm__getSettingsResponse(soap, NULL, NULL, "ngwm:getSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getSettingsRequest:
		return soap_in_PointerTo_ngwm__getSettingsRequest(soap, NULL, NULL, "ngwm:getSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getRuleListResponse:
		return soap_in_PointerTo_ngwm__getRuleListResponse(soap, NULL, NULL, "ngwm:getRuleListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getRuleListRequest:
		return soap_in_PointerTo_ngwm__getRuleListRequest(soap, NULL, NULL, "ngwm:getRuleListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getProxyListResponse:
		return soap_in_PointerTo_ngwm__getProxyListResponse(soap, NULL, NULL, "ngwm:getProxyListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getProxyListRequest:
		return soap_in_PointerTo_ngwm__getProxyListRequest(soap, NULL, NULL, "ngwm:getProxyListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListResponse:
		return soap_in_PointerTo_ngwm__getProxyAccessListResponse(soap, NULL, NULL, "ngwm:getProxyAccessListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListRequest:
		return soap_in_PointerTo_ngwm__getProxyAccessListRequest(soap, NULL, NULL, "ngwm:getProxyAccessListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesResponse:
		return soap_in_PointerTo_ngwm__getQuickMessagesResponse(soap, NULL, NULL, "ngwm:getQuickMessagesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesRequest:
		return soap_in_PointerTo_ngwm__getQuickMessagesRequest(soap, NULL, NULL, "ngwm:getQuickMessagesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListResponse:
		return soap_in_PointerTo_ngwm__getLibraryListResponse(soap, NULL, NULL, "ngwm:getLibraryListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListRequest:
		return soap_in_PointerTo_ngwm__getLibraryListRequest(soap, NULL, NULL, "ngwm:getLibraryListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemResponse:
		return soap_in_PointerTo_ngwm__getLibraryItemResponse(soap, NULL, NULL, "ngwm:getLibraryItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemRequest:
		return soap_in_PointerTo_ngwm__getLibraryItemRequest(soap, NULL, NULL, "ngwm:getLibraryItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsResponse:
		return soap_in_PointerTo_ngwm__getJunkMailSettingsResponse(soap, NULL, NULL, "ngwm:getJunkMailSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsRequest:
		return soap_in_PointerTo_ngwm__getJunkMailSettingsRequest(soap, NULL, NULL, "ngwm:getJunkMailSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesResponse:
		return soap_in_PointerTo_ngwm__getJunkEntriesResponse(soap, NULL, NULL, "ngwm:getJunkEntriesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesRequest:
		return soap_in_PointerTo_ngwm__getJunkEntriesRequest(soap, NULL, NULL, "ngwm:getJunkEntriesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getItemsResponse:
		return soap_in_PointerTo_ngwm__getItemsResponse(soap, NULL, NULL, "ngwm:getItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getItemsRequest:
		return soap_in_PointerTo_ngwm__getItemsRequest(soap, NULL, NULL, "ngwm:getItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getItemResponse:
		return soap_in_PointerTo_ngwm__getItemResponse(soap, NULL, NULL, "ngwm:getItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__getItemRequest:
		return soap_in_PointerTo_ngwm__getItemRequest(soap, NULL, NULL, "ngwm:getItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyResponse:
		return soap_in_PointerTo_ngwm__getFreeBusyResponse(soap, NULL, NULL, "ngwm:getFreeBusyResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyRequest:
		return soap_in_PointerTo_ngwm__getFreeBusyRequest(soap, NULL, NULL, "ngwm:getFreeBusyRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFolderListResponse:
		return soap_in_PointerTo_ngwm__getFolderListResponse(soap, NULL, NULL, "ngwm:getFolderListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFolderListRequest:
		return soap_in_PointerTo_ngwm__getFolderListRequest(soap, NULL, NULL, "ngwm:getFolderListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFolderResponse:
		return soap_in_PointerTo_ngwm__getFolderResponse(soap, NULL, NULL, "ngwm:getFolderResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFolderRequest:
		return soap_in_PointerTo_ngwm__getFolderRequest(soap, NULL, NULL, "ngwm:getFolderRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListResponse:
		return soap_in_PointerTo_ngwm__getDocumentTypeListResponse(soap, NULL, NULL, "ngwm:getDocumentTypeListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListRequest:
		return soap_in_PointerTo_ngwm__getDocumentTypeListRequest(soap, NULL, NULL, "ngwm:getDocumentTypeListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoResponse:
		return soap_in_PointerTo_ngwm__getDeltaInfoResponse(soap, NULL, NULL, "ngwm:getDeltaInfoResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoRequest:
		return soap_in_PointerTo_ngwm__getDeltaInfoRequest(soap, NULL, NULL, "ngwm:getDeltaInfoRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDeltasResponse:
		return soap_in_PointerTo_ngwm__getDeltasResponse(soap, NULL, NULL, "ngwm:getDeltasResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDeltasRequest:
		return soap_in_PointerTo_ngwm__getDeltasRequest(soap, NULL, NULL, "ngwm:getDeltasRequest");
	case SOAP_TYPE_PointerTo_ngwm__getCustomListResponse:
		return soap_in_PointerTo_ngwm__getCustomListResponse(soap, NULL, NULL, "ngwm:getCustomListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getCustomListRequest:
		return soap_in_PointerTo_ngwm__getCustomListRequest(soap, NULL, NULL, "ngwm:getCustomListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListResponse:
		return soap_in_PointerTo_ngwm__getCategoryListResponse(soap, NULL, NULL, "ngwm:getCategoryListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListRequest:
		return soap_in_PointerTo_ngwm__getCategoryListRequest(soap, NULL, NULL, "ngwm:getCategoryListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentResponse:
		return soap_in_PointerTo_ngwm__getAttachmentResponse(soap, NULL, NULL, "ngwm:getAttachmentResponse");
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentRequest:
		return soap_in_PointerTo_ngwm__getAttachmentRequest(soap, NULL, NULL, "ngwm:getAttachmentRequest");
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListResponse:
		return soap_in_PointerTo_ngwm__getAddressBookListResponse(soap, NULL, NULL, "ngwm:getAddressBookListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListRequest:
		return soap_in_PointerTo_ngwm__getAddressBookListRequest(soap, NULL, NULL, "ngwm:getAddressBookListRequest");
	case SOAP_TYPE_PointerTo_ngwm__forwardResponse:
		return soap_in_PointerTo_ngwm__forwardResponse(soap, NULL, NULL, "ngwm:forwardResponse");
	case SOAP_TYPE_PointerTo_ngwm__forwardRequest:
		return soap_in_PointerTo_ngwm__forwardRequest(soap, NULL, NULL, "ngwm:forwardRequest");
	case SOAP_TYPE_PointerTo_ngwm__executeRuleResponse:
		return soap_in_PointerTo_ngwm__executeRuleResponse(soap, NULL, NULL, "ngwm:executeRuleResponse");
	case SOAP_TYPE_PointerTo_ngwm__executeRuleRequest:
		return soap_in_PointerTo_ngwm__executeRuleRequest(soap, NULL, NULL, "ngwm:executeRuleRequest");
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorResponse:
		return soap_in_PointerTo_ngwm__destroyCursorResponse(soap, NULL, NULL, "ngwm:destroyCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorRequest:
		return soap_in_PointerTo_ngwm__destroyCursorRequest(soap, NULL, NULL, "ngwm:destroyCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__delegateResponse:
		return soap_in_PointerTo_ngwm__delegateResponse(soap, NULL, NULL, "ngwm:delegateResponse");
	case SOAP_TYPE_PointerTo_ngwm__delegateRequest:
		return soap_in_PointerTo_ngwm__delegateRequest(soap, NULL, NULL, "ngwm:delegateRequest");
	case SOAP_TYPE_PointerTo_ngwm__declineResponse:
		return soap_in_PointerTo_ngwm__declineResponse(soap, NULL, NULL, "ngwm:declineResponse");
	case SOAP_TYPE_PointerTo_ngwm__declineRequest:
		return soap_in_PointerTo_ngwm__declineRequest(soap, NULL, NULL, "ngwm:declineRequest");
	case SOAP_TYPE_PointerTo_ngwm__createSignatureResponse:
		return soap_in_PointerTo_ngwm__createSignatureResponse(soap, NULL, NULL, "ngwm:createSignatureResponse");
	case SOAP_TYPE_PointerTo_ngwm__createSignatureRequest:
		return soap_in_PointerTo_ngwm__createSignatureRequest(soap, NULL, NULL, "ngwm:createSignatureRequest");
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessResponse:
		return soap_in_PointerTo_ngwm__createProxyAccessResponse(soap, NULL, NULL, "ngwm:createProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessRequest:
		return soap_in_PointerTo_ngwm__createProxyAccessRequest(soap, NULL, NULL, "ngwm:createProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryResponse:
		return soap_in_PointerTo_ngwm__createJunkEntryResponse(soap, NULL, NULL, "ngwm:createJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryRequest:
		return soap_in_PointerTo_ngwm__createJunkEntryRequest(soap, NULL, NULL, "ngwm:createJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__createItemsResponse:
		return soap_in_PointerTo_ngwm__createItemsResponse(soap, NULL, NULL, "ngwm:createItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__createItemsRequest:
		return soap_in_PointerTo_ngwm__createItemsRequest(soap, NULL, NULL, "ngwm:createItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__createItemResponse:
		return soap_in_PointerTo_ngwm__createItemResponse(soap, NULL, NULL, "ngwm:createItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__createItemRequest:
		return soap_in_PointerTo_ngwm__createItemRequest(soap, NULL, NULL, "ngwm:createItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__createCursorResponse:
		return soap_in_PointerTo_ngwm__createCursorResponse(soap, NULL, NULL, "ngwm:createCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__createCursorRequest:
		return soap_in_PointerTo_ngwm__createCursorRequest(soap, NULL, NULL, "ngwm:createCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__completeResponse:
		return soap_in_PointerTo_ngwm__completeResponse(soap, NULL, NULL, "ngwm:completeResponse");
	case SOAP_TYPE_PointerTo_ngwm__completeRequest:
		return soap_in_PointerTo_ngwm__completeRequest(soap, NULL, NULL, "ngwm:completeRequest");
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionResponse:
		return soap_in_PointerTo_ngwm__closeFreeBusySessionResponse(soap, NULL, NULL, "ngwm:closeFreeBusySessionResponse");
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionRequest:
		return soap_in_PointerTo_ngwm__closeFreeBusySessionRequest(soap, NULL, NULL, "ngwm:closeFreeBusySessionRequest");
	case SOAP_TYPE_PointerTo_ngwm__addMembersResponse:
		return soap_in_PointerTo_ngwm__addMembersResponse(soap, NULL, NULL, "ngwm:addMembersResponse");
	case SOAP_TYPE_PointerTo_ngwm__addMembersRequest:
		return soap_in_PointerTo_ngwm__addMembersRequest(soap, NULL, NULL, "ngwm:addMembersRequest");
	case SOAP_TYPE_PointerTo_ngwm__addItemsResponse:
		return soap_in_PointerTo_ngwm__addItemsResponse(soap, NULL, NULL, "ngwm:addItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__addItemsRequest:
		return soap_in_PointerTo_ngwm__addItemsRequest(soap, NULL, NULL, "ngwm:addItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__addItemResponse:
		return soap_in_PointerTo_ngwm__addItemResponse(soap, NULL, NULL, "ngwm:addItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__addItemRequest:
		return soap_in_PointerTo_ngwm__addItemRequest(soap, NULL, NULL, "ngwm:addItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__acceptShareResponse:
		return soap_in_PointerTo_ngwm__acceptShareResponse(soap, NULL, NULL, "ngwm:acceptShareResponse");
	case SOAP_TYPE_PointerTo_ngwm__acceptShareRequest:
		return soap_in_PointerTo_ngwm__acceptShareRequest(soap, NULL, NULL, "ngwm:acceptShareRequest");
	case SOAP_TYPE_PointerTo_ngwm__acceptResponse:
		return soap_in_PointerTo_ngwm__acceptResponse(soap, NULL, NULL, "ngwm:acceptResponse");
	case SOAP_TYPE_PointerTo_ngwm__acceptRequest:
		return soap_in_PointerTo_ngwm__acceptRequest(soap, NULL, NULL, "ngwm:acceptRequest");
	case SOAP_TYPE_PointerTongwt__Alarm:
		return soap_in_PointerTongwt__Alarm(soap, NULL, NULL, "ngwt:Alarm");
	case SOAP_TYPE_PointerTongwt__PhoneFlags:
		return soap_in_PointerTongwt__PhoneFlags(soap, NULL, NULL, "ngwt:PhoneFlags");
	case SOAP_TYPE_PointerTongwt__RecurrenceRule:
		return soap_in_PointerTongwt__RecurrenceRule(soap, NULL, NULL, "ngwt:RecurrenceRule");
	case SOAP_TYPE_PointerTongwt__RecurrenceDateType:
		return soap_in_PointerTongwt__RecurrenceDateType(soap, NULL, NULL, "ngwt:RecurrenceDateType");
	case SOAP_TYPE_PointerTongwt__SMimeOperation:
		return soap_in_PointerTongwt__SMimeOperation(soap, NULL, NULL, "ngwt:SMimeOperation");
	case SOAP_TYPE_PointerTongwt__LinkInfo:
		return soap_in_PointerTongwt__LinkInfo(soap, NULL, NULL, "ngwt:LinkInfo");
	case SOAP_TYPE_PointerTongwt__ItemOptions:
		return soap_in_PointerTongwt__ItemOptions(soap, NULL, NULL, "ngwt:ItemOptions");
	case SOAP_TYPE_PointerTongwt__AttachmentInfo:
		return soap_in_PointerTongwt__AttachmentInfo(soap, NULL, NULL, "ngwt:AttachmentInfo");
	case SOAP_TYPE_PointerTongwt__MessageBody:
		return soap_in_PointerTongwt__MessageBody(soap, NULL, NULL, "ngwt:MessageBody");
	case SOAP_TYPE_PointerTongwt__ReferenceInfo:
		return soap_in_PointerTongwt__ReferenceInfo(soap, NULL, NULL, "ngwt:ReferenceInfo");
	case SOAP_TYPE_PointerTongwt__PersonalInfo:
		return soap_in_PointerTongwt__PersonalInfo(soap, NULL, NULL, "ngwt:PersonalInfo");
	case SOAP_TYPE_PointerTongwt__OfficeInfo:
		return soap_in_PointerTongwt__OfficeInfo(soap, NULL, NULL, "ngwt:OfficeInfo");
	case SOAP_TYPE_PointerTongwt__PostalAddressList:
		return soap_in_PointerTongwt__PostalAddressList(soap, NULL, NULL, "ngwt:PostalAddressList");
	case SOAP_TYPE_PointerTongwt__PhoneList:
		return soap_in_PointerTongwt__PhoneList(soap, NULL, NULL, "ngwt:PhoneList");
	case SOAP_TYPE_PointerTongwt__ImAddressList:
		return soap_in_PointerTongwt__ImAddressList(soap, NULL, NULL, "ngwt:ImAddressList");
	case SOAP_TYPE_PointerTongwt__EmailAddressList:
		return soap_in_PointerTongwt__EmailAddressList(soap, NULL, NULL, "ngwt:EmailAddressList");
	case SOAP_TYPE_PointerTongwt__FullName:
		return soap_in_PointerTongwt__FullName(soap, NULL, NULL, "ngwt:FullName");
	case SOAP_TYPE_PointerTongwt__VersionStatus:
		return soap_in_PointerTongwt__VersionStatus(soap, NULL, NULL, "ngwt:VersionStatus");
	case SOAP_TYPE_PointerTongwt__FolderACL:
		return soap_in_PointerTongwt__FolderACL(soap, NULL, NULL, "ngwt:FolderACL");
	case SOAP_TYPE_PointerTongwt__RuleActionList:
		return soap_in_PointerTongwt__RuleActionList(soap, NULL, NULL, "ngwt:RuleActionList");
	case SOAP_TYPE_PointerTongwt__Execution:
		return soap_in_PointerTongwt__Execution(soap, NULL, NULL, "ngwt:Execution");
	case SOAP_TYPE_PointerTongwt__Query:
		return soap_in_PointerTongwt__Query(soap, NULL, NULL, "ngwt:Query");
	case SOAP_TYPE_PointerTongwt__FolderACLStatus:
		return soap_in_PointerTongwt__FolderACLStatus(soap, NULL, NULL, "ngwt:FolderACLStatus");
	case SOAP_TYPE_PointerTongwt__AccessControlList:
		return soap_in_PointerTongwt__AccessControlList(soap, NULL, NULL, "ngwt:AccessControlList");
	case SOAP_TYPE_PointerTongwt__WeekOfYear:
		return soap_in_PointerTongwt__WeekOfYear(soap, NULL, NULL, "ngwt:WeekOfYear");
	case SOAP_TYPE_PointerTongwt__OccurrenceType:
		return soap_in_PointerTongwt__OccurrenceType(soap, NULL, NULL, "ngwt:OccurrenceType");
	case SOAP_TYPE_PointerTongwt__ItemSecurity:
		return soap_in_PointerTongwt__ItemSecurity(soap, NULL, NULL, "ngwt:ItemSecurity");
	case SOAP_TYPE_PointerTongwt__ItemClass:
		return soap_in_PointerTongwt__ItemClass(soap, NULL, NULL, "ngwt:ItemClass");
	case SOAP_TYPE_PointerTongwt__ItemSource:
		return soap_in_PointerTongwt__ItemSource(soap, NULL, NULL, "ngwt:ItemSource");
	case SOAP_TYPE_PointerTongwt__ItemStatus:
		return soap_in_PointerTongwt__ItemStatus(soap, NULL, NULL, "ngwt:ItemStatus");
	case SOAP_TYPE_PointerTongwt__DeltaSyncType:
		return soap_in_PointerTongwt__DeltaSyncType(soap, NULL, NULL, "ngwt:DeltaSyncType");
	case SOAP_TYPE_PointerTongwt__RecipientStatus:
		return soap_in_PointerTongwt__RecipientStatus(soap, NULL, NULL, "ngwt:RecipientStatus");
	case SOAP_TYPE_PointerTongwt__FreeBusyBlockList:
		return soap_in_PointerTongwt__FreeBusyBlockList(soap, NULL, NULL, "ngwt:FreeBusyBlockList");
	case SOAP_TYPE_PointerTongwt__CalendarFolderAttribute:
		return soap_in_PointerTongwt__CalendarFolderAttribute(soap, NULL, NULL, "ngwt:CalendarFolderAttribute");
	case SOAP_TYPE_PointerTongwt__FilterDate:
		return soap_in_PointerTongwt__FilterDate(soap, NULL, NULL, "ngwt:FilterDate");
	case SOAP_TYPE_PointerTongwt__ContainerRef:
		return soap_in_PointerTongwt__ContainerRef(soap, NULL, NULL, "ngwt:ContainerRef");
	case SOAP_TYPE_PointerTongwt__CategoryType:
		return soap_in_PointerTongwt__CategoryType(soap, NULL, NULL, "ngwt:CategoryType");
	case SOAP_TYPE_PointerTongwt__AccessMiscRight:
		return soap_in_PointerTongwt__AccessMiscRight(soap, NULL, NULL, "ngwt:AccessMiscRight");
	case SOAP_TYPE_PointerTongwt__AccessRight:
		return soap_in_PointerTongwt__AccessRight(soap, NULL, NULL, "ngwt:AccessRight");
	case SOAP_TYPE_PointerTongwt__Rights:
		return soap_in_PointerTongwt__Rights(soap, NULL, NULL, "ngwt:Rights");
	case SOAP_TYPE_PointerTongwe__EventList:
		return soap_in_PointerTongwe__EventList(soap, NULL, NULL, "ngwe:EventList");
	case SOAP_TYPE_PointerTongwe__EventsList:
		return soap_in_PointerTongwe__EventsList(soap, NULL, NULL, "ngwe:EventsList");
	case SOAP_TYPE_PointerTongwe__Events:
		return soap_in_PointerTongwe__Events(soap, NULL, NULL, "ngwe:Events");
	case SOAP_TYPE_PointerTongwe__EventDefinition:
		return soap_in_PointerTongwe__EventDefinition(soap, NULL, NULL, "ngwe:EventDefinition");
	case SOAP_TYPE_PointerToxsd__duration:
		return soap_in_PointerToxsd__duration(soap, NULL, NULL, "xsd:duration");
	case SOAP_TYPE_PointerTongwe__Event:
		return soap_in_PointerTongwe__Event(soap, NULL, NULL, "ngwe:Event");
	case SOAP_TYPE_PointerTongwe__ContainerList:
		return soap_in_PointerTongwe__ContainerList(soap, NULL, NULL, "ngwe:ContainerList");
	case SOAP_TYPE_PointerTongwe__ItemTypeList:
		return soap_in_PointerTongwe__ItemTypeList(soap, NULL, NULL, "ngwe:ItemTypeList");
	case SOAP_TYPE_PointerTongwe__EventTypeList:
		return soap_in_PointerTongwe__EventTypeList(soap, NULL, NULL, "ngwe:EventTypeList");
	case SOAP_TYPE_PointerTongwe__ItemType:
		return soap_in_PointerTongwe__ItemType(soap, NULL, NULL, "ngwe:ItemType");
	case SOAP_TYPE_PointerTongwe__FieldList:
		return soap_in_PointerTongwe__FieldList(soap, NULL, NULL, "ngwe:FieldList");
	case SOAP_TYPE_PointerTongwt__FreeBusyUserList:
		return soap_in_PointerTongwt__FreeBusyUserList(soap, NULL, NULL, "ngwt:FreeBusyUserList");
	case SOAP_TYPE_PointerTongwt__RetractType:
		return soap_in_PointerTongwt__RetractType(soap, NULL, NULL, "ngwt:RetractType");
	case SOAP_TYPE_PointerTongwt__ItemList:
		return soap_in_PointerTongwt__ItemList(soap, NULL, NULL, "ngwt:ItemList");
	case SOAP_TYPE_PointerTongwt__CursorSeek:
		return soap_in_PointerTongwt__CursorSeek(soap, NULL, NULL, "ngwt:CursorSeek");
	case SOAP_TYPE_PointerTongwt__AccessRightChanges:
		return soap_in_PointerTongwt__AccessRightChanges(soap, NULL, NULL, "ngwt:AccessRightChanges");
	case SOAP_TYPE_PointerTongwt__ModifyItem:
		return soap_in_PointerTongwt__ModifyItem(soap, NULL, NULL, "ngwt:ModifyItem");
	case SOAP_TYPE_PointerTongwt__Host:
		return soap_in_PointerTongwt__Host(soap, NULL, NULL, "ngwt:Host");
	case SOAP_TYPE_PointerTongwt__Authentication:
		return soap_in_PointerTongwt__Authentication(soap, NULL, NULL, "ngwt:Authentication");
	case SOAP_TYPE_PointerTongwt__UserList:
		return soap_in_PointerTongwt__UserList(soap, NULL, NULL, "ngwt:UserList");
	case SOAP_TYPE_PointerTongwt__TimezoneList:
		return soap_in_PointerTongwt__TimezoneList(soap, NULL, NULL, "ngwt:TimezoneList");
	case SOAP_TYPE_PointerTongwt__Signatures:
		return soap_in_PointerTongwt__Signatures(soap, NULL, NULL, "ngwt:Signatures");
	case SOAP_TYPE_PointerTongwt__Settings:
		return soap_in_PointerTongwt__Settings(soap, NULL, NULL, "ngwt:Settings");
	case SOAP_TYPE_PointerTongwt__RuleList:
		return soap_in_PointerTongwt__RuleList(soap, NULL, NULL, "ngwt:RuleList");
	case SOAP_TYPE_PointerTongwt__ProxyList:
		return soap_in_PointerTongwt__ProxyList(soap, NULL, NULL, "ngwt:ProxyList");
	case SOAP_TYPE_PointerTongwt__AccessRightList:
		return soap_in_PointerTongwt__AccessRightList(soap, NULL, NULL, "ngwt:AccessRightList");
	case SOAP_TYPE_PointerTongwt__LibraryList:
		return soap_in_PointerTongwt__LibraryList(soap, NULL, NULL, "ngwt:LibraryList");
	case SOAP_TYPE_PointerTongwt__SettingsList:
		return soap_in_PointerTongwt__SettingsList(soap, NULL, NULL, "ngwt:SettingsList");
	case SOAP_TYPE_PointerTongwt__JunkHandlingList:
		return soap_in_PointerTongwt__JunkHandlingList(soap, NULL, NULL, "ngwt:JunkHandlingList");
	case SOAP_TYPE_PointerTongwt__FreeBusyInfoList:
		return soap_in_PointerTongwt__FreeBusyInfoList(soap, NULL, NULL, "ngwt:FreeBusyInfoList");
	case SOAP_TYPE_PointerTongwt__FreeBusyStats:
		return soap_in_PointerTongwt__FreeBusyStats(soap, NULL, NULL, "ngwt:FreeBusyStats");
	case SOAP_TYPE_PointerTongwt__FolderList:
		return soap_in_PointerTongwt__FolderList(soap, NULL, NULL, "ngwt:FolderList");
	case SOAP_TYPE_PointerTongwt__ItemSourceList:
		return soap_in_PointerTongwt__ItemSourceList(soap, NULL, NULL, "ngwt:ItemSourceList");
	case SOAP_TYPE_PointerTongwt__MessageTypeList:
		return soap_in_PointerTongwt__MessageTypeList(soap, NULL, NULL, "ngwt:MessageTypeList");
	case SOAP_TYPE_PointerTongwt__FolderType:
		return soap_in_PointerTongwt__FolderType(soap, NULL, NULL, "ngwt:FolderType");
	case SOAP_TYPE_PointerTongwt__DocumentTypeList:
		return soap_in_PointerTongwt__DocumentTypeList(soap, NULL, NULL, "ngwt:DocumentTypeList");
	case SOAP_TYPE_PointerTongwt__Items:
		return soap_in_PointerTongwt__Items(soap, NULL, NULL, "ngwt:Items");
	case SOAP_TYPE_PointerTongwt__DeltaInfo:
		return soap_in_PointerTongwt__DeltaInfo(soap, NULL, NULL, "ngwt:DeltaInfo");
	case SOAP_TYPE_PointerTongwt__CustomList:
		return soap_in_PointerTongwt__CustomList(soap, NULL, NULL, "ngwt:CustomList");
	case SOAP_TYPE_PointerTongwt__CategoryList:
		return soap_in_PointerTongwt__CategoryList(soap, NULL, NULL, "ngwt:CategoryList");
	case SOAP_TYPE_PointerTongwt__AddressBookList:
		return soap_in_PointerTongwt__AddressBookList(soap, NULL, NULL, "ngwt:AddressBookList");
	case SOAP_TYPE_PointerTongwt__Distribution:
		return soap_in_PointerTongwt__Distribution(soap, NULL, NULL, "ngwt:Distribution");
	case SOAP_TYPE_PointerTongwt__View:
		return soap_in_PointerTongwt__View(soap, NULL, NULL, "ngwt:View");
	case SOAP_TYPE_PointerTongwt__Status:
		return soap_in_PointerTongwt__Status(soap, NULL, NULL, "ngwt:Status");
	case SOAP_TYPE_PointerTongwt__ItemRefList:
		return soap_in_PointerTongwt__ItemRefList(soap, NULL, NULL, "ngwt:ItemRefList");
	case SOAP_TYPE_PointerTongwt__UserInfo:
		return soap_in_PointerTongwt__UserInfo(soap, NULL, NULL, "ngwt:UserInfo");
	case SOAP_TYPE_PointerTongwt__RecipientType:
		return soap_in_PointerTongwt__RecipientType(soap, NULL, NULL, "ngwt:RecipientType");
	case SOAP_TYPE_PointerTongwt__Timezone:
		return soap_in_PointerTongwt__Timezone(soap, NULL, NULL, "ngwt:Timezone");
	case SOAP_TYPE_PointerTongwt__Minute:
		return soap_in_PointerTongwt__Minute(soap, NULL, NULL, "ngwt:Minute");
	case SOAP_TYPE_PointerTongwt__Hour:
		return soap_in_PointerTongwt__Hour(soap, NULL, NULL, "ngwt:Hour");
	case SOAP_TYPE_PointerTongwt__DayOfWeek:
		return soap_in_PointerTongwt__DayOfWeek(soap, NULL, NULL, "ngwt:DayOfWeek");
	case SOAP_TYPE_PointerTongwt__Day:
		return soap_in_PointerTongwt__Day(soap, NULL, NULL, "ngwt:Day");
	case SOAP_TYPE_PointerTongwt__Month:
		return soap_in_PointerTongwt__Month(soap, NULL, NULL, "ngwt:Month");
	case SOAP_TYPE_PointerTongwt__TimezoneComponent:
		return soap_in_PointerTongwt__TimezoneComponent(soap, NULL, NULL, "ngwt:TimezoneComponent");
	case SOAP_TYPE_PointerTongwt__ProblemList:
		return soap_in_PointerTongwt__ProblemList(soap, NULL, NULL, "ngwt:ProblemList");
	case SOAP_TYPE_PointerTongwt__Signature:
		return soap_in_PointerTongwt__Signature(soap, NULL, NULL, "ngwt:Signature");
	case SOAP_TYPE_PointerTongwt__SignatureData:
		return soap_in_PointerTongwt__SignatureData(soap, NULL, NULL, "ngwt:SignatureData");
	case SOAP_TYPE_PointerTongwt__SettingsGroup:
		return soap_in_PointerTongwt__SettingsGroup(soap, NULL, NULL, "ngwt:SettingsGroup");
	case SOAP_TYPE_PointerTongwt__ReturnNotification:
		return soap_in_PointerTongwt__ReturnNotification(soap, NULL, NULL, "ngwt:ReturnNotification");
	case SOAP_TYPE_PointerTongwt__StatusTracking:
		return soap_in_PointerTongwt__StatusTracking(soap, NULL, NULL, "ngwt:StatusTracking");
	case SOAP_TYPE_PointerTongwt__SendOptionsRequestReply:
		return soap_in_PointerTongwt__SendOptionsRequestReply(soap, NULL, NULL, "ngwt:SendOptionsRequestReply");
	case SOAP_TYPE_PointerTongwt__Rule:
		return soap_in_PointerTongwt__Rule(soap, NULL, NULL, "ngwt:Rule");
	case SOAP_TYPE_PointerTongwt__RuleAction:
		return soap_in_PointerTongwt__RuleAction(soap, NULL, NULL, "ngwt:RuleAction");
	case SOAP_TYPE_PointerTongwt__CategoryRefList:
		return soap_in_PointerTongwt__CategoryRefList(soap, NULL, NULL, "ngwt:CategoryRefList");
	case SOAP_TYPE_PointerTongwt__Mail:
		return soap_in_PointerTongwt__Mail(soap, NULL, NULL, "ngwt:Mail");
	case SOAP_TYPE_PointerTongwt__ReturnNotificationOptions:
		return soap_in_PointerTongwt__ReturnNotificationOptions(soap, NULL, NULL, "ngwt:ReturnNotificationOptions");
	case SOAP_TYPE_PointerTongwt__MonthList:
		return soap_in_PointerTongwt__MonthList(soap, NULL, NULL, "ngwt:MonthList");
	case SOAP_TYPE_PointerTongwt__DayOfYearList:
		return soap_in_PointerTongwt__DayOfYearList(soap, NULL, NULL, "ngwt:DayOfYearList");
	case SOAP_TYPE_PointerTongwt__DayOfMonthList:
		return soap_in_PointerTongwt__DayOfMonthList(soap, NULL, NULL, "ngwt:DayOfMonthList");
	case SOAP_TYPE_PointerTongwt__DayOfYearWeekList:
		return soap_in_PointerTongwt__DayOfYearWeekList(soap, NULL, NULL, "ngwt:DayOfYearWeekList");
	case SOAP_TYPE_PointerTongwt__Frequency:
		return soap_in_PointerTongwt__Frequency(soap, NULL, NULL, "ngwt:Frequency");
	case SOAP_TYPE_PointerTongwt__DelegateeStatus:
		return soap_in_PointerTongwt__DelegateeStatus(soap, NULL, NULL, "ngwt:DelegateeStatus");
	case SOAP_TYPE_PointerTongwt__DelegatedStatus:
		return soap_in_PointerTongwt__DelegatedStatus(soap, NULL, NULL, "ngwt:DelegatedStatus");
	case SOAP_TYPE_PointerTongwt__CommentStatus:
		return soap_in_PointerTongwt__CommentStatus(soap, NULL, NULL, "ngwt:CommentStatus");
	case SOAP_TYPE_PointerTongwt__TransferFailedStatus:
		return soap_in_PointerTongwt__TransferFailedStatus(soap, NULL, NULL, "ngwt:TransferFailedStatus");
	case SOAP_TYPE_PointerTongwt__Recipient:
		return soap_in_PointerTongwt__Recipient(soap, NULL, NULL, "ngwt:Recipient");
	case SOAP_TYPE_PointerTongwt__Filter:
		return soap_in_PointerTongwt__Filter(soap, NULL, NULL, "ngwt:Filter");
	case SOAP_TYPE_PointerTongwt__QueryTarget:
		return soap_in_PointerTongwt__QueryTarget(soap, NULL, NULL, "ngwt:QueryTarget");
	case SOAP_TYPE_PointerTongwt__ProxyUser:
		return soap_in_PointerTongwt__ProxyUser(soap, NULL, NULL, "ngwt:ProxyUser");
	case SOAP_TYPE_PointerTongwt__ProblemEntry:
		return soap_in_PointerTongwt__ProblemEntry(soap, NULL, NULL, "ngwt:ProblemEntry");
	case SOAP_TYPE_PointerTongwt__PostalAddress:
		return soap_in_PointerTongwt__PostalAddress(soap, NULL, NULL, "ngwt:PostalAddress");
	case SOAP_TYPE_PointerTongwt__PhoneNumber:
		return soap_in_PointerTongwt__PhoneNumber(soap, NULL, NULL, "ngwt:PhoneNumber");
	case SOAP_TYPE_PointerToxsd__date:
		return soap_in_PointerToxsd__date(soap, NULL, NULL, "xsd:date");
	case SOAP_TYPE_PointerTongwt__ItemRef:
		return soap_in_PointerTongwt__ItemRef(soap, NULL, NULL, "ngwt:ItemRef");
	case SOAP_TYPE_PointerTongwt__UUID:
		return soap_in_PointerTongwt__UUID(soap, NULL, NULL, "ngwt:UUID");
	case SOAP_TYPE_PointerTongwt__SharedFolderNotification:
		return soap_in_PointerTongwt__SharedFolderNotification(soap, NULL, NULL, "ngwt:SharedFolderNotification");
	case SOAP_TYPE_PointerTongwt__MessagePart:
		return soap_in_PointerTongwt__MessagePart(soap, NULL, NULL, "ngwt:MessagePart");
	case SOAP_TYPE_PointerTongwt__Library:
		return soap_in_PointerTongwt__Library(soap, NULL, NULL, "ngwt:Library");
	case SOAP_TYPE_PointerTongwt__JunkEntry:
		return soap_in_PointerTongwt__JunkEntry(soap, NULL, NULL, "ngwt:JunkEntry");
	case SOAP_TYPE_PointerTongwt__JunkHandlingListType:
		return soap_in_PointerTongwt__JunkHandlingListType(soap, NULL, NULL, "ngwt:JunkHandlingListType");
	case SOAP_TYPE_PointerTongwt__Item:
		return soap_in_PointerTongwt__Item(soap, NULL, NULL, "ngwt:Item");
	case SOAP_TYPE_PointerTongwt__ItemChanges:
		return soap_in_PointerTongwt__ItemChanges(soap, NULL, NULL, "ngwt:ItemChanges");
	case SOAP_TYPE_PointerTongwt__ImAddress:
		return soap_in_PointerTongwt__ImAddress(soap, NULL, NULL, "ngwt:ImAddress");
	case SOAP_TYPE_PointerTongwt__GroupMember:
		return soap_in_PointerTongwt__GroupMember(soap, NULL, NULL, "ngwt:GroupMember");
	case SOAP_TYPE_PointerTongwt__GroupMemberList:
		return soap_in_PointerTongwt__GroupMemberList(soap, NULL, NULL, "ngwt:GroupMemberList");
	case SOAP_TYPE_PointerTongwt__FreeBusyInfo:
		return soap_in_PointerTongwt__FreeBusyInfo(soap, NULL, NULL, "ngwt:FreeBusyInfo");
	case SOAP_TYPE_PointerTongwt__NameAndEmail:
		return soap_in_PointerTongwt__NameAndEmail(soap, NULL, NULL, "ngwt:NameAndEmail");
	case SOAP_TYPE_PointerTongwt__AcceptLevel:
		return soap_in_PointerTongwt__AcceptLevel(soap, NULL, NULL, "ngwt:AcceptLevel");
	case SOAP_TYPE_PointerTongwt__FreeBusyBlock:
		return soap_in_PointerTongwt__FreeBusyBlock(soap, NULL, NULL, "ngwt:FreeBusyBlock");
	case SOAP_TYPE_PointerTongwt__Folder:
		return soap_in_PointerTongwt__Folder(soap, NULL, NULL, "ngwt:Folder");
	case SOAP_TYPE_PointerTongwt__FolderACLEntry:
		return soap_in_PointerTongwt__FolderACLEntry(soap, NULL, NULL, "ngwt:FolderACLEntry");
	case SOAP_TYPE_PointerTongwt__FilterElement:
		return soap_in_PointerTongwt__FilterElement(soap, NULL, NULL, "ngwt:FilterElement");
	case SOAP_TYPE_PointerTongwt__DocumentType:
		return soap_in_PointerTongwt__DocumentType(soap, NULL, NULL, "ngwt:DocumentType");
	case SOAP_TYPE_PointerTongwt__AgeAction:
		return soap_in_PointerTongwt__AgeAction(soap, NULL, NULL, "ngwt:AgeAction");
	case SOAP_TYPE_PointerTongwt__SendOptions:
		return soap_in_PointerTongwt__SendOptions(soap, NULL, NULL, "ngwt:SendOptions");
	case SOAP_TYPE_PointerTongwt__RecipientList:
		return soap_in_PointerTongwt__RecipientList(soap, NULL, NULL, "ngwt:RecipientList");
	case SOAP_TYPE_PointerTongwt__From:
		return soap_in_PointerTongwt__From(soap, NULL, NULL, "ngwt:From");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTongwt__DayOfYearWeek:
		return soap_in_PointerTongwt__DayOfYearWeek(soap, NULL, NULL, "ngwt:DayOfYearWeek");
	case SOAP_TYPE_PointerTongwt__Custom:
		return soap_in_PointerTongwt__Custom(soap, NULL, NULL, "ngwt:Custom");
	case SOAP_TYPE_PointerTongwt__CustomType:
		return soap_in_PointerTongwt__CustomType(soap, NULL, NULL, "ngwt:CustomType");
	case SOAP_TYPE_PointerTongwt__uid:
		return soap_in_PointerTongwt__uid(soap, NULL, NULL, "ngwt:uid");
	case SOAP_TYPE_PointerTongwt__Category:
		return soap_in_PointerTongwt__Category(soap, NULL, NULL, "ngwt:Category");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTounsignedLong:
		return soap_in_PointerTounsignedLong(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTongwt__AttachmentID:
		return soap_in_PointerTongwt__AttachmentID(soap, NULL, NULL, "ngwt:AttachmentID");
	case SOAP_TYPE_PointerTongwt__AttachmentItemInfo:
		return soap_in_PointerTongwt__AttachmentItemInfo(soap, NULL, NULL, "ngwt:AttachmentItemInfo");
	case SOAP_TYPE_PointerTongwt__AddressBook:
		return soap_in_PointerTongwt__AddressBook(soap, NULL, NULL, "ngwt:AddressBook");
	case SOAP_TYPE_PointerTongwt__AccessRightEntry:
		return soap_in_PointerTongwt__AccessRightEntry(soap, NULL, NULL, "ngwt:AccessRightEntry");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerTongwt__AccessControlListEntry:
		return soap_in_PointerTongwt__AccessControlListEntry(soap, NULL, NULL, "ngwt:AccessControlListEntry");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE__TQName:
	{	char **s;
		s = soap_in__TQName(soap, NULL, NULL, "TQName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "ngwt:DayOfMonth"))
		{	*type = SOAP_TYPE_ngwt__DayOfMonth;
			return soap_in_ngwt__DayOfMonth(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:WeekOfYear"))
		{	*type = SOAP_TYPE_ngwt__WeekOfYear;
			return soap_in_ngwt__WeekOfYear(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfYear"))
		{	*type = SOAP_TYPE_ngwt__DayOfYear;
			return soap_in_ngwt__DayOfYear(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:short"))
		{	*type = SOAP_TYPE_short;
			return soap_in_short(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:GMTOffset"))
		{	*type = SOAP_TYPE_ngwt__GMTOffset;
			return soap_in_ngwt__GMTOffset(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Month"))
		{	*type = SOAP_TYPE_ngwt__Month;
			return soap_in_ngwt__Month(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Minute"))
		{	*type = SOAP_TYPE_ngwt__Minute;
			return soap_in_ngwt__Minute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Hour"))
		{	*type = SOAP_TYPE_ngwt__Hour;
			return soap_in_ngwt__Hour(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Day"))
		{	*type = SOAP_TYPE_ngwt__Day;
			return soap_in_ngwt__Day(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLong;
			return soap_in_unsignedLong(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:ItemType"))
		{	*type = SOAP_TYPE_ngwe__ItemType;
			return soap_in_ngwe__ItemType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:Field"))
		{	*type = SOAP_TYPE_ngwe__Field;
			return soap_in_ngwe__Field(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:EventType"))
		{	*type = SOAP_TYPE_ngwe__EventType;
			return soap_in_ngwe__EventType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:WeekDay"))
		{	*type = SOAP_TYPE_ngwt__WeekDay;
			return soap_in_ngwt__WeekDay(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:VersionStatus"))
		{	*type = SOAP_TYPE_ngwt__VersionStatus;
			return soap_in_ngwt__VersionStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:VersionEventType"))
		{	*type = SOAP_TYPE_ngwt__VersionEventType;
			return soap_in_ngwt__VersionEventType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:StatusTrackingOptions"))
		{	*type = SOAP_TYPE_ngwt__StatusTrackingOptions;
			return soap_in_ngwt__StatusTrackingOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RuleActionType"))
		{	*type = SOAP_TYPE_ngwt__RuleActionType;
			return soap_in_ngwt__RuleActionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RetractType"))
		{	*type = SOAP_TYPE_ngwt__RetractType;
			return soap_in_ngwt__RetractType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RecipientType"))
		{	*type = SOAP_TYPE_ngwt__RecipientType;
			return soap_in_ngwt__RecipientType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PostalAddressType"))
		{	*type = SOAP_TYPE_ngwt__PostalAddressType;
			return soap_in_ngwt__PostalAddressType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PhoneNumberType"))
		{	*type = SOAP_TYPE_ngwt__PhoneNumberType;
			return soap_in_ngwt__PhoneNumberType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:OccurrenceType"))
		{	*type = SOAP_TYPE_ngwt__OccurrenceType;
			return soap_in_ngwt__OccurrenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:NotificationType"))
		{	*type = SOAP_TYPE_ngwt__NotificationType;
			return soap_in_ngwt__NotificationType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MessageType"))
		{	*type = SOAP_TYPE_ngwt__MessageType;
			return soap_in_ngwt__MessageType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MessageList"))
		{	*type = SOAP_TYPE_ngwt__MessageList;
			return soap_in_ngwt__MessageList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:LinkType"))
		{	*type = SOAP_TYPE_ngwt__LinkType;
			return soap_in_ngwt__LinkType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:JunkMatchType"))
		{	*type = SOAP_TYPE_ngwt__JunkMatchType;
			return soap_in_ngwt__JunkMatchType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:JunkHandlingListType"))
		{	*type = SOAP_TYPE_ngwt__JunkHandlingListType;
			return soap_in_ngwt__JunkHandlingListType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemSource"))
		{	*type = SOAP_TYPE_ngwt__ItemSource;
			return soap_in_ngwt__ItemSource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemSecurity"))
		{	*type = SOAP_TYPE_ngwt__ItemSecurity;
			return soap_in_ngwt__ItemSecurity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemOptionsPriority"))
		{	*type = SOAP_TYPE_ngwt__ItemOptionsPriority;
			return soap_in_ngwt__ItemOptionsPriority(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemClass"))
		{	*type = SOAP_TYPE_ngwt__ItemClass;
			return soap_in_ngwt__ItemClass(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Frequency"))
		{	*type = SOAP_TYPE_ngwt__Frequency;
			return soap_in_ngwt__Frequency(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FolderType"))
		{	*type = SOAP_TYPE_ngwt__FolderType;
			return soap_in_ngwt__FolderType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FolderACLStatus"))
		{	*type = SOAP_TYPE_ngwt__FolderACLStatus;
			return soap_in_ngwt__FolderACLStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FilterOp"))
		{	*type = SOAP_TYPE_ngwt__FilterOp;
			return soap_in_ngwt__FilterOp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FilterDate"))
		{	*type = SOAP_TYPE_ngwt__FilterDate;
			return soap_in_ngwt__FilterDate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Execution"))
		{	*type = SOAP_TYPE_ngwt__Execution;
			return soap_in_ngwt__Execution(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DistributionType"))
		{	*type = SOAP_TYPE_ngwt__DistributionType;
			return soap_in_ngwt__DistributionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DeltaSyncType"))
		{	*type = SOAP_TYPE_ngwt__DeltaSyncType;
			return soap_in_ngwt__DeltaSyncType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CustomType"))
		{	*type = SOAP_TYPE_ngwt__CustomType;
			return soap_in_ngwt__CustomType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CursorSeek"))
		{	*type = SOAP_TYPE_ngwt__CursorSeek;
			return soap_in_ngwt__CursorSeek(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ContactType"))
		{	*type = SOAP_TYPE_ngwt__ContactType;
			return soap_in_ngwt__ContactType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CategoryType"))
		{	*type = SOAP_TYPE_ngwt__CategoryType;
			return soap_in_ngwt__CategoryType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CalendarFolderFlags"))
		{	*type = SOAP_TYPE_ngwt__CalendarFolderFlags;
			return soap_in_ngwt__CalendarFolderFlags(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AppointmentConflict"))
		{	*type = SOAP_TYPE_ngwt__AppointmentConflict;
			return soap_in_ngwt__AppointmentConflict(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AgeAction"))
		{	*type = SOAP_TYPE_ngwt__AgeAction;
			return soap_in_ngwt__AgeAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AcceptLevel"))
		{	*type = SOAP_TYPE_ngwt__AcceptLevel;
			return soap_in_ngwt__AcceptLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:ItemTypeList"))
		{	*type = SOAP_TYPE_ngwe__ItemTypeList;
			return soap_in_ngwe__ItemTypeList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:FieldList"))
		{	*type = SOAP_TYPE_ngwe__FieldList;
			return soap_in_ngwe__FieldList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MessageTypeList"))
		{	*type = SOAP_TYPE_ngwt__MessageTypeList;
			return soap_in_ngwt__MessageTypeList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemSourceList"))
		{	*type = SOAP_TYPE_ngwt__ItemSourceList;
			return soap_in_ngwt__ItemSourceList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:UUID"))
		{	*type = SOAP_TYPE_ngwt__UUID;
			return soap_in_ngwt__UUID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:uid"))
		{	*type = SOAP_TYPE_ngwt__uid;
			return soap_in_ngwt__uid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:View"))
		{	*type = SOAP_TYPE_ngwt__View;
			return soap_in_ngwt__View(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:removeEventsResponse"))
		{	*type = SOAP_TYPE__ngwe__removeEventsResponse;
			return soap_in__ngwe__removeEventsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:removeEventsRequest"))
		{	*type = SOAP_TYPE__ngwe__removeEventsRequest;
			return soap_in__ngwe__removeEventsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:removeEventConfigurationResponse"))
		{	*type = SOAP_TYPE__ngwe__removeEventConfigurationResponse;
			return soap_in__ngwe__removeEventConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:removeEventConfigurationRequest"))
		{	*type = SOAP_TYPE__ngwe__removeEventConfigurationRequest;
			return soap_in__ngwe__removeEventConfigurationRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:getEventsResponse"))
		{	*type = SOAP_TYPE__ngwe__getEventsResponse;
			return soap_in__ngwe__getEventsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:getEventsRequest"))
		{	*type = SOAP_TYPE__ngwe__getEventsRequest;
			return soap_in__ngwe__getEventsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:getEventConfigurationResponse"))
		{	*type = SOAP_TYPE__ngwe__getEventConfigurationResponse;
			return soap_in__ngwe__getEventConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:getEventConfigurationRequest"))
		{	*type = SOAP_TYPE__ngwe__getEventConfigurationRequest;
			return soap_in__ngwe__getEventConfigurationRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:configureEventsResponse"))
		{	*type = SOAP_TYPE__ngwe__configureEventsResponse;
			return soap_in__ngwe__configureEventsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:configureEventsRequest"))
		{	*type = SOAP_TYPE__ngwe__configureEventsRequest;
			return soap_in__ngwe__configureEventsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:cleanEventConfigurationResponse"))
		{	*type = SOAP_TYPE__ngwe__cleanEventConfigurationResponse;
			return soap_in__ngwe__cleanEventConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:cleanEventConfigurationRequest"))
		{	*type = SOAP_TYPE__ngwe__cleanEventConfigurationRequest;
			return soap_in__ngwe__cleanEventConfigurationRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:Notify"))
		{	*type = SOAP_TYPE_ngwe__Notify;
			return soap_in_ngwe__Notify(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:EventTypeList"))
		{	*type = SOAP_TYPE_ngwe__EventTypeList;
			return soap_in_ngwe__EventTypeList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:EventsList"))
		{	*type = SOAP_TYPE_ngwe__EventsList;
			return soap_in_ngwe__EventsList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:Events"))
		{	*type = SOAP_TYPE_ngwe__Events;
			return soap_in_ngwe__Events(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:EventList"))
		{	*type = SOAP_TYPE_ngwe__EventList;
			return soap_in_ngwe__EventList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:EventDefinition"))
		{	*type = SOAP_TYPE_ngwe__EventDefinition;
			return soap_in_ngwe__EventDefinition(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:Event"))
		{	*type = SOAP_TYPE_ngwe__Event;
			return soap_in_ngwe__Event(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwe:ContainerList"))
		{	*type = SOAP_TYPE_ngwe__ContainerList;
			return soap_in_ngwe__ContainerList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:updateVersionStatusResponse"))
		{	*type = SOAP_TYPE__ngwm__updateVersionStatusResponse;
			return soap_in__ngwm__updateVersionStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:updateVersionStatusRequest"))
		{	*type = SOAP_TYPE__ngwm__updateVersionStatusRequest;
			return soap_in__ngwm__updateVersionStatusRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:uncompleteResponse"))
		{	*type = SOAP_TYPE__ngwm__uncompleteResponse;
			return soap_in__ngwm__uncompleteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:uncompleteRequest"))
		{	*type = SOAP_TYPE__ngwm__uncompleteRequest;
			return soap_in__ngwm__uncompleteRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:unacceptResponse"))
		{	*type = SOAP_TYPE__ngwm__unacceptResponse;
			return soap_in__ngwm__unacceptResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:unacceptRequest"))
		{	*type = SOAP_TYPE__ngwm__unacceptRequest;
			return soap_in__ngwm__unacceptRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:startFreeBusySessionResponse"))
		{	*type = SOAP_TYPE__ngwm__startFreeBusySessionResponse;
			return soap_in__ngwm__startFreeBusySessionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:startFreeBusySessionRequest"))
		{	*type = SOAP_TYPE__ngwm__startFreeBusySessionRequest;
			return soap_in__ngwm__startFreeBusySessionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:setTimestampResponse"))
		{	*type = SOAP_TYPE__ngwm__setTimestampResponse;
			return soap_in__ngwm__setTimestampResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:setTimestampRequest"))
		{	*type = SOAP_TYPE__ngwm__setTimestampRequest;
			return soap_in__ngwm__setTimestampRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:sendItemResponse"))
		{	*type = SOAP_TYPE__ngwm__sendItemResponse;
			return soap_in__ngwm__sendItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:sendItemRequest"))
		{	*type = SOAP_TYPE__ngwm__sendItemRequest;
			return soap_in__ngwm__sendItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:retractResponse"))
		{	*type = SOAP_TYPE__ngwm__retractResponse;
			return soap_in__ngwm__retractResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:retractRequest"))
		{	*type = SOAP_TYPE__ngwm__retractRequest;
			return soap_in__ngwm__retractRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:replyResponse"))
		{	*type = SOAP_TYPE__ngwm__replyResponse;
			return soap_in__ngwm__replyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:replyRequest"))
		{	*type = SOAP_TYPE__ngwm__replyRequest;
			return soap_in__ngwm__replyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeSignatureResponse"))
		{	*type = SOAP_TYPE__ngwm__removeSignatureResponse;
			return soap_in__ngwm__removeSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeSignatureRequest"))
		{	*type = SOAP_TYPE__ngwm__removeSignatureRequest;
			return soap_in__ngwm__removeSignatureRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeProxyUserResponse"))
		{	*type = SOAP_TYPE__ngwm__removeProxyUserResponse;
			return soap_in__ngwm__removeProxyUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeProxyUserRequest"))
		{	*type = SOAP_TYPE__ngwm__removeProxyUserRequest;
			return soap_in__ngwm__removeProxyUserRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeProxyAccessResponse"))
		{	*type = SOAP_TYPE__ngwm__removeProxyAccessResponse;
			return soap_in__ngwm__removeProxyAccessResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeProxyAccessRequest"))
		{	*type = SOAP_TYPE__ngwm__removeProxyAccessRequest;
			return soap_in__ngwm__removeProxyAccessRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeMembersResponse"))
		{	*type = SOAP_TYPE__ngwm__removeMembersResponse;
			return soap_in__ngwm__removeMembersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeMembersRequest"))
		{	*type = SOAP_TYPE__ngwm__removeMembersRequest;
			return soap_in__ngwm__removeMembersRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeJunkEntryResponse"))
		{	*type = SOAP_TYPE__ngwm__removeJunkEntryResponse;
			return soap_in__ngwm__removeJunkEntryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeJunkEntryRequest"))
		{	*type = SOAP_TYPE__ngwm__removeJunkEntryRequest;
			return soap_in__ngwm__removeJunkEntryRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__removeItemsResponse;
			return soap_in__ngwm__removeItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__removeItemsRequest;
			return soap_in__ngwm__removeItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeItemResponse"))
		{	*type = SOAP_TYPE__ngwm__removeItemResponse;
			return soap_in__ngwm__removeItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeItemRequest"))
		{	*type = SOAP_TYPE__ngwm__removeItemRequest;
			return soap_in__ngwm__removeItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeCustomDefinitionResponse"))
		{	*type = SOAP_TYPE__ngwm__removeCustomDefinitionResponse;
			return soap_in__ngwm__removeCustomDefinitionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:removeCustomDefinitionRequest"))
		{	*type = SOAP_TYPE__ngwm__removeCustomDefinitionRequest;
			return soap_in__ngwm__removeCustomDefinitionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:readCursorResponse"))
		{	*type = SOAP_TYPE__ngwm__readCursorResponse;
			return soap_in__ngwm__readCursorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:readCursorRequest"))
		{	*type = SOAP_TYPE__ngwm__readCursorRequest;
			return soap_in__ngwm__readCursorRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:purgeResponse"))
		{	*type = SOAP_TYPE__ngwm__purgeResponse;
			return soap_in__ngwm__purgeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:purgeRequest"))
		{	*type = SOAP_TYPE__ngwm__purgeRequest;
			return soap_in__ngwm__purgeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:purgeDeletedItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__purgeDeletedItemsResponse;
			return soap_in__ngwm__purgeDeletedItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:purgeDeletedItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__purgeDeletedItemsRequest;
			return soap_in__ngwm__purgeDeletedItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:positionCursorResponse"))
		{	*type = SOAP_TYPE__ngwm__positionCursorResponse;
			return soap_in__ngwm__positionCursorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:positionCursorRequest"))
		{	*type = SOAP_TYPE__ngwm__positionCursorRequest;
			return soap_in__ngwm__positionCursorRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:moveItemResponse"))
		{	*type = SOAP_TYPE__ngwm__moveItemResponse;
			return soap_in__ngwm__moveItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:moveItemRequest"))
		{	*type = SOAP_TYPE__ngwm__moveItemRequest;
			return soap_in__ngwm__moveItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifySignaturesResponse"))
		{	*type = SOAP_TYPE__ngwm__modifySignaturesResponse;
			return soap_in__ngwm__modifySignaturesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifySignaturesRequest"))
		{	*type = SOAP_TYPE__ngwm__modifySignaturesRequest;
			return soap_in__ngwm__modifySignaturesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifySettingsResponse"))
		{	*type = SOAP_TYPE__ngwm__modifySettingsResponse;
			return soap_in__ngwm__modifySettingsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifySettingsRequest"))
		{	*type = SOAP_TYPE__ngwm__modifySettingsRequest;
			return soap_in__ngwm__modifySettingsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyProxyAccessResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyProxyAccessResponse;
			return soap_in__ngwm__modifyProxyAccessResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyProxyAccessRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyProxyAccessRequest;
			return soap_in__ngwm__modifyProxyAccessRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyPasswordResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyPasswordResponse;
			return soap_in__ngwm__modifyPasswordResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyPasswordRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyPasswordRequest;
			return soap_in__ngwm__modifyPasswordRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyJunkMailSettingsResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse;
			return soap_in__ngwm__modifyJunkMailSettingsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyJunkMailSettingsRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest;
			return soap_in__ngwm__modifyJunkMailSettingsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyJunkEntryResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyJunkEntryResponse;
			return soap_in__ngwm__modifyJunkEntryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyJunkEntryRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyJunkEntryRequest;
			return soap_in__ngwm__modifyJunkEntryRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyItemsResponse;
			return soap_in__ngwm__modifyItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyItemsRequest;
			return soap_in__ngwm__modifyItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyItemResponse"))
		{	*type = SOAP_TYPE__ngwm__modifyItemResponse;
			return soap_in__ngwm__modifyItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:modifyItemRequest"))
		{	*type = SOAP_TYPE__ngwm__modifyItemRequest;
			return soap_in__ngwm__modifyItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markUnReadResponse"))
		{	*type = SOAP_TYPE__ngwm__markUnReadResponse;
			return soap_in__ngwm__markUnReadResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markUnReadRequest"))
		{	*type = SOAP_TYPE__ngwm__markUnReadRequest;
			return soap_in__ngwm__markUnReadRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markUnPrivateResponse"))
		{	*type = SOAP_TYPE__ngwm__markUnPrivateResponse;
			return soap_in__ngwm__markUnPrivateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markUnPrivateRequest"))
		{	*type = SOAP_TYPE__ngwm__markUnPrivateRequest;
			return soap_in__ngwm__markUnPrivateRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markReadResponse"))
		{	*type = SOAP_TYPE__ngwm__markReadResponse;
			return soap_in__ngwm__markReadResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markReadRequest"))
		{	*type = SOAP_TYPE__ngwm__markReadRequest;
			return soap_in__ngwm__markReadRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markPrivateResponse"))
		{	*type = SOAP_TYPE__ngwm__markPrivateResponse;
			return soap_in__ngwm__markPrivateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:markPrivateRequest"))
		{	*type = SOAP_TYPE__ngwm__markPrivateRequest;
			return soap_in__ngwm__markPrivateRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:logoutResponse"))
		{	*type = SOAP_TYPE__ngwm__logoutResponse;
			return soap_in__ngwm__logoutResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:logoutRequest"))
		{	*type = SOAP_TYPE__ngwm__logoutRequest;
			return soap_in__ngwm__logoutRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:loginResponse"))
		{	*type = SOAP_TYPE__ngwm__loginResponse;
			return soap_in__ngwm__loginResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:loginRequest"))
		{	*type = SOAP_TYPE__ngwm__loginRequest;
			return soap_in__ngwm__loginRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getUserListResponse"))
		{	*type = SOAP_TYPE__ngwm__getUserListResponse;
			return soap_in__ngwm__getUserListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getUserListRequest"))
		{	*type = SOAP_TYPE__ngwm__getUserListRequest;
			return soap_in__ngwm__getUserListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getTimezoneListResponse"))
		{	*type = SOAP_TYPE__ngwm__getTimezoneListResponse;
			return soap_in__ngwm__getTimezoneListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getTimezoneListRequest"))
		{	*type = SOAP_TYPE__ngwm__getTimezoneListRequest;
			return soap_in__ngwm__getTimezoneListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getTimestampResponse"))
		{	*type = SOAP_TYPE__ngwm__getTimestampResponse;
			return soap_in__ngwm__getTimestampResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getTimestampRequest"))
		{	*type = SOAP_TYPE__ngwm__getTimestampRequest;
			return soap_in__ngwm__getTimestampRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getSignaturesResponse"))
		{	*type = SOAP_TYPE__ngwm__getSignaturesResponse;
			return soap_in__ngwm__getSignaturesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getSignaturesRequest"))
		{	*type = SOAP_TYPE__ngwm__getSignaturesRequest;
			return soap_in__ngwm__getSignaturesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getSettingsResponse"))
		{	*type = SOAP_TYPE__ngwm__getSettingsResponse;
			return soap_in__ngwm__getSettingsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getSettingsRequest"))
		{	*type = SOAP_TYPE__ngwm__getSettingsRequest;
			return soap_in__ngwm__getSettingsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getRuleListResponse"))
		{	*type = SOAP_TYPE__ngwm__getRuleListResponse;
			return soap_in__ngwm__getRuleListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getRuleListRequest"))
		{	*type = SOAP_TYPE__ngwm__getRuleListRequest;
			return soap_in__ngwm__getRuleListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getProxyListResponse"))
		{	*type = SOAP_TYPE__ngwm__getProxyListResponse;
			return soap_in__ngwm__getProxyListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getProxyListRequest"))
		{	*type = SOAP_TYPE__ngwm__getProxyListRequest;
			return soap_in__ngwm__getProxyListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getProxyAccessListResponse"))
		{	*type = SOAP_TYPE__ngwm__getProxyAccessListResponse;
			return soap_in__ngwm__getProxyAccessListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getProxyAccessListRequest"))
		{	*type = SOAP_TYPE__ngwm__getProxyAccessListRequest;
			return soap_in__ngwm__getProxyAccessListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getQuickMessagesResponse"))
		{	*type = SOAP_TYPE__ngwm__getQuickMessagesResponse;
			return soap_in__ngwm__getQuickMessagesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getQuickMessagesRequest"))
		{	*type = SOAP_TYPE__ngwm__getQuickMessagesRequest;
			return soap_in__ngwm__getQuickMessagesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getLibraryListResponse"))
		{	*type = SOAP_TYPE__ngwm__getLibraryListResponse;
			return soap_in__ngwm__getLibraryListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getLibraryListRequest"))
		{	*type = SOAP_TYPE__ngwm__getLibraryListRequest;
			return soap_in__ngwm__getLibraryListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getLibraryItemResponse"))
		{	*type = SOAP_TYPE__ngwm__getLibraryItemResponse;
			return soap_in__ngwm__getLibraryItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getLibraryItemRequest"))
		{	*type = SOAP_TYPE__ngwm__getLibraryItemRequest;
			return soap_in__ngwm__getLibraryItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getJunkMailSettingsResponse"))
		{	*type = SOAP_TYPE__ngwm__getJunkMailSettingsResponse;
			return soap_in__ngwm__getJunkMailSettingsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getJunkMailSettingsRequest"))
		{	*type = SOAP_TYPE__ngwm__getJunkMailSettingsRequest;
			return soap_in__ngwm__getJunkMailSettingsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getJunkEntriesResponse"))
		{	*type = SOAP_TYPE__ngwm__getJunkEntriesResponse;
			return soap_in__ngwm__getJunkEntriesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getJunkEntriesRequest"))
		{	*type = SOAP_TYPE__ngwm__getJunkEntriesRequest;
			return soap_in__ngwm__getJunkEntriesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__getItemsResponse;
			return soap_in__ngwm__getItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__getItemsRequest;
			return soap_in__ngwm__getItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getItemResponse"))
		{	*type = SOAP_TYPE__ngwm__getItemResponse;
			return soap_in__ngwm__getItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getItemRequest"))
		{	*type = SOAP_TYPE__ngwm__getItemRequest;
			return soap_in__ngwm__getItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFreeBusyResponse"))
		{	*type = SOAP_TYPE__ngwm__getFreeBusyResponse;
			return soap_in__ngwm__getFreeBusyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFreeBusyRequest"))
		{	*type = SOAP_TYPE__ngwm__getFreeBusyRequest;
			return soap_in__ngwm__getFreeBusyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFolderListResponse"))
		{	*type = SOAP_TYPE__ngwm__getFolderListResponse;
			return soap_in__ngwm__getFolderListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFolderListRequest"))
		{	*type = SOAP_TYPE__ngwm__getFolderListRequest;
			return soap_in__ngwm__getFolderListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFolderResponse"))
		{	*type = SOAP_TYPE__ngwm__getFolderResponse;
			return soap_in__ngwm__getFolderResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getFolderRequest"))
		{	*type = SOAP_TYPE__ngwm__getFolderRequest;
			return soap_in__ngwm__getFolderRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDocumentTypeListResponse"))
		{	*type = SOAP_TYPE__ngwm__getDocumentTypeListResponse;
			return soap_in__ngwm__getDocumentTypeListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDocumentTypeListRequest"))
		{	*type = SOAP_TYPE__ngwm__getDocumentTypeListRequest;
			return soap_in__ngwm__getDocumentTypeListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDeltaInfoResponse"))
		{	*type = SOAP_TYPE__ngwm__getDeltaInfoResponse;
			return soap_in__ngwm__getDeltaInfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDeltaInfoRequest"))
		{	*type = SOAP_TYPE__ngwm__getDeltaInfoRequest;
			return soap_in__ngwm__getDeltaInfoRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDeltasResponse"))
		{	*type = SOAP_TYPE__ngwm__getDeltasResponse;
			return soap_in__ngwm__getDeltasResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getDeltasRequest"))
		{	*type = SOAP_TYPE__ngwm__getDeltasRequest;
			return soap_in__ngwm__getDeltasRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getCustomListResponse"))
		{	*type = SOAP_TYPE__ngwm__getCustomListResponse;
			return soap_in__ngwm__getCustomListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getCustomListRequest"))
		{	*type = SOAP_TYPE__ngwm__getCustomListRequest;
			return soap_in__ngwm__getCustomListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getCategoryListResponse"))
		{	*type = SOAP_TYPE__ngwm__getCategoryListResponse;
			return soap_in__ngwm__getCategoryListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getCategoryListRequest"))
		{	*type = SOAP_TYPE__ngwm__getCategoryListRequest;
			return soap_in__ngwm__getCategoryListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getAttachmentResponse"))
		{	*type = SOAP_TYPE__ngwm__getAttachmentResponse;
			return soap_in__ngwm__getAttachmentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getAttachmentRequest"))
		{	*type = SOAP_TYPE__ngwm__getAttachmentRequest;
			return soap_in__ngwm__getAttachmentRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getAddressBookListResponse"))
		{	*type = SOAP_TYPE__ngwm__getAddressBookListResponse;
			return soap_in__ngwm__getAddressBookListResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:getAddressBookListRequest"))
		{	*type = SOAP_TYPE__ngwm__getAddressBookListRequest;
			return soap_in__ngwm__getAddressBookListRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:forwardResponse"))
		{	*type = SOAP_TYPE__ngwm__forwardResponse;
			return soap_in__ngwm__forwardResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:forwardRequest"))
		{	*type = SOAP_TYPE__ngwm__forwardRequest;
			return soap_in__ngwm__forwardRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:executeRuleResponse"))
		{	*type = SOAP_TYPE__ngwm__executeRuleResponse;
			return soap_in__ngwm__executeRuleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:executeRuleRequest"))
		{	*type = SOAP_TYPE__ngwm__executeRuleRequest;
			return soap_in__ngwm__executeRuleRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:destroyCursorResponse"))
		{	*type = SOAP_TYPE__ngwm__destroyCursorResponse;
			return soap_in__ngwm__destroyCursorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:destroyCursorRequest"))
		{	*type = SOAP_TYPE__ngwm__destroyCursorRequest;
			return soap_in__ngwm__destroyCursorRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:delegateResponse"))
		{	*type = SOAP_TYPE__ngwm__delegateResponse;
			return soap_in__ngwm__delegateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:delegateRequest"))
		{	*type = SOAP_TYPE__ngwm__delegateRequest;
			return soap_in__ngwm__delegateRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:declineResponse"))
		{	*type = SOAP_TYPE__ngwm__declineResponse;
			return soap_in__ngwm__declineResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:declineRequest"))
		{	*type = SOAP_TYPE__ngwm__declineRequest;
			return soap_in__ngwm__declineRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createSignatureResponse"))
		{	*type = SOAP_TYPE__ngwm__createSignatureResponse;
			return soap_in__ngwm__createSignatureResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createSignatureRequest"))
		{	*type = SOAP_TYPE__ngwm__createSignatureRequest;
			return soap_in__ngwm__createSignatureRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createProxyAccessResponse"))
		{	*type = SOAP_TYPE__ngwm__createProxyAccessResponse;
			return soap_in__ngwm__createProxyAccessResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createProxyAccessRequest"))
		{	*type = SOAP_TYPE__ngwm__createProxyAccessRequest;
			return soap_in__ngwm__createProxyAccessRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createJunkEntryResponse"))
		{	*type = SOAP_TYPE__ngwm__createJunkEntryResponse;
			return soap_in__ngwm__createJunkEntryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createJunkEntryRequest"))
		{	*type = SOAP_TYPE__ngwm__createJunkEntryRequest;
			return soap_in__ngwm__createJunkEntryRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__createItemsResponse;
			return soap_in__ngwm__createItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__createItemsRequest;
			return soap_in__ngwm__createItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createItemResponse"))
		{	*type = SOAP_TYPE__ngwm__createItemResponse;
			return soap_in__ngwm__createItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createItemRequest"))
		{	*type = SOAP_TYPE__ngwm__createItemRequest;
			return soap_in__ngwm__createItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createCursorResponse"))
		{	*type = SOAP_TYPE__ngwm__createCursorResponse;
			return soap_in__ngwm__createCursorResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:createCursorRequest"))
		{	*type = SOAP_TYPE__ngwm__createCursorRequest;
			return soap_in__ngwm__createCursorRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:completeResponse"))
		{	*type = SOAP_TYPE__ngwm__completeResponse;
			return soap_in__ngwm__completeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:completeRequest"))
		{	*type = SOAP_TYPE__ngwm__completeRequest;
			return soap_in__ngwm__completeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:closeFreeBusySessionResponse"))
		{	*type = SOAP_TYPE__ngwm__closeFreeBusySessionResponse;
			return soap_in__ngwm__closeFreeBusySessionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:closeFreeBusySessionRequest"))
		{	*type = SOAP_TYPE__ngwm__closeFreeBusySessionRequest;
			return soap_in__ngwm__closeFreeBusySessionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addMembersResponse"))
		{	*type = SOAP_TYPE__ngwm__addMembersResponse;
			return soap_in__ngwm__addMembersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addMembersRequest"))
		{	*type = SOAP_TYPE__ngwm__addMembersRequest;
			return soap_in__ngwm__addMembersRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addItemsResponse"))
		{	*type = SOAP_TYPE__ngwm__addItemsResponse;
			return soap_in__ngwm__addItemsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addItemsRequest"))
		{	*type = SOAP_TYPE__ngwm__addItemsRequest;
			return soap_in__ngwm__addItemsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addItemResponse"))
		{	*type = SOAP_TYPE__ngwm__addItemResponse;
			return soap_in__ngwm__addItemResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:addItemRequest"))
		{	*type = SOAP_TYPE__ngwm__addItemRequest;
			return soap_in__ngwm__addItemRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:acceptShareResponse"))
		{	*type = SOAP_TYPE__ngwm__acceptShareResponse;
			return soap_in__ngwm__acceptShareResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:acceptShareRequest"))
		{	*type = SOAP_TYPE__ngwm__acceptShareRequest;
			return soap_in__ngwm__acceptShareRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:acceptResponse"))
		{	*type = SOAP_TYPE__ngwm__acceptResponse;
			return soap_in__ngwm__acceptResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwm:acceptRequest"))
		{	*type = SOAP_TYPE__ngwm__acceptRequest;
			return soap_in__ngwm__acceptRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:VersionEvent"))
		{	*type = SOAP_TYPE_ngwt__VersionEvent;
			return soap_in_ngwt__VersionEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Version"))
		{	*type = SOAP_TYPE_ngwt__Version;
			return soap_in_ngwt__Version(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:UserList"))
		{	*type = SOAP_TYPE_ngwt__UserList;
			return soap_in_ngwt__UserList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:UserInfo"))
		{	*type = SOAP_TYPE_ngwt__UserInfo;
			return soap_in_ngwt__UserInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:TrustedApplication"))
		{	*type = SOAP_TYPE_ngwt__TrustedApplication;
			return soap_in_ngwt__TrustedApplication(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:TransferFailedStatus"))
		{	*type = SOAP_TYPE_ngwt__TransferFailedStatus;
			return soap_in_ngwt__TransferFailedStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:TimezoneList"))
		{	*type = SOAP_TYPE_ngwt__TimezoneList;
			return soap_in_ngwt__TimezoneList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:TimezoneComponent"))
		{	*type = SOAP_TYPE_ngwt__TimezoneComponent;
			return soap_in_ngwt__TimezoneComponent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Timezone"))
		{	*type = SOAP_TYPE_ngwt__Timezone;
			return soap_in_ngwt__Timezone(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Task"))
		{	*type = SOAP_TYPE_ngwt__Task;
			return soap_in_ngwt__Task(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SystemFolder"))
		{	*type = SOAP_TYPE_ngwt__SystemFolder;
			return soap_in_ngwt__SystemFolder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:StatusTracking"))
		{	*type = SOAP_TYPE_ngwt__StatusTracking;
			return soap_in_ngwt__StatusTracking(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Status"))
		{	*type = SOAP_TYPE_ngwt__Status;
			return soap_in_ngwt__Status(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SMimeOperation"))
		{	*type = SOAP_TYPE_ngwt__SMimeOperation;
			return soap_in_ngwt__SMimeOperation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SignatureData"))
		{	*type = SOAP_TYPE_ngwt__SignatureData;
			return soap_in_ngwt__SignatureData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Signatures"))
		{	*type = SOAP_TYPE_ngwt__Signatures;
			return soap_in_ngwt__Signatures(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Signature"))
		{	*type = SOAP_TYPE_ngwt__Signature;
			return soap_in_ngwt__Signature(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SharedNotification"))
		{	*type = SOAP_TYPE_ngwt__SharedNotification;
			return soap_in_ngwt__SharedNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SharedFolderNotification"))
		{	*type = SOAP_TYPE_ngwt__SharedFolderNotification;
			return soap_in_ngwt__SharedFolderNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SharedFolder"))
		{	*type = SOAP_TYPE_ngwt__SharedFolder;
			return soap_in_ngwt__SharedFolder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SettingsList"))
		{	*type = SOAP_TYPE_ngwt__SettingsList;
			return soap_in_ngwt__SettingsList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SettingsGroup"))
		{	*type = SOAP_TYPE_ngwt__SettingsGroup;
			return soap_in_ngwt__SettingsGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Settings"))
		{	*type = SOAP_TYPE_ngwt__Settings;
			return soap_in_ngwt__Settings(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SendOptions"))
		{	*type = SOAP_TYPE_ngwt__SendOptions;
			return soap_in_ngwt__SendOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:SendOptionsRequestReply"))
		{	*type = SOAP_TYPE_ngwt__SendOptionsRequestReply;
			return soap_in_ngwt__SendOptionsRequestReply(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RuleList"))
		{	*type = SOAP_TYPE_ngwt__RuleList;
			return soap_in_ngwt__RuleList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RuleActionList"))
		{	*type = SOAP_TYPE_ngwt__RuleActionList;
			return soap_in_ngwt__RuleActionList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RuleAction"))
		{	*type = SOAP_TYPE_ngwt__RuleAction;
			return soap_in_ngwt__RuleAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Rule"))
		{	*type = SOAP_TYPE_ngwt__Rule;
			return soap_in_ngwt__Rule(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Rights"))
		{	*type = SOAP_TYPE_ngwt__Rights;
			return soap_in_ngwt__Rights(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ReturnNotificationOptions"))
		{	*type = SOAP_TYPE_ngwt__ReturnNotificationOptions;
			return soap_in_ngwt__ReturnNotificationOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ReturnNotification"))
		{	*type = SOAP_TYPE_ngwt__ReturnNotification;
			return soap_in_ngwt__ReturnNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Resource"))
		{	*type = SOAP_TYPE_ngwt__Resource;
			return soap_in_ngwt__Resource(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ReferenceInfo"))
		{	*type = SOAP_TYPE_ngwt__ReferenceInfo;
			return soap_in_ngwt__ReferenceInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RecurrenceRule"))
		{	*type = SOAP_TYPE_ngwt__RecurrenceRule;
			return soap_in_ngwt__RecurrenceRule(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RecurrenceDateType"))
		{	*type = SOAP_TYPE_ngwt__RecurrenceDateType;
			return soap_in_ngwt__RecurrenceDateType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RecipientStatus"))
		{	*type = SOAP_TYPE_ngwt__RecipientStatus;
			return soap_in_ngwt__RecipientStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:RecipientList"))
		{	*type = SOAP_TYPE_ngwt__RecipientList;
			return soap_in_ngwt__RecipientList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Recipient"))
		{	*type = SOAP_TYPE_ngwt__Recipient;
			return soap_in_ngwt__Recipient(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:QueryTarget"))
		{	*type = SOAP_TYPE_ngwt__QueryTarget;
			return soap_in_ngwt__QueryTarget(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:QueryFolder"))
		{	*type = SOAP_TYPE_ngwt__QueryFolder;
			return soap_in_ngwt__QueryFolder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Query"))
		{	*type = SOAP_TYPE_ngwt__Query;
			return soap_in_ngwt__Query(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ProxyList"))
		{	*type = SOAP_TYPE_ngwt__ProxyList;
			return soap_in_ngwt__ProxyList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ProxyUser"))
		{	*type = SOAP_TYPE_ngwt__ProxyUser;
			return soap_in_ngwt__ProxyUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Proxy"))
		{	*type = SOAP_TYPE_ngwt__Proxy;
			return soap_in_ngwt__Proxy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ProblemList"))
		{	*type = SOAP_TYPE_ngwt__ProblemList;
			return soap_in_ngwt__ProblemList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ProblemEntry"))
		{	*type = SOAP_TYPE_ngwt__ProblemEntry;
			return soap_in_ngwt__ProblemEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PostalAddressList"))
		{	*type = SOAP_TYPE_ngwt__PostalAddressList;
			return soap_in_ngwt__PostalAddressList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PostalAddress"))
		{	*type = SOAP_TYPE_ngwt__PostalAddress;
			return soap_in_ngwt__PostalAddress(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PlainText"))
		{	*type = SOAP_TYPE_ngwt__PlainText;
			return soap_in_ngwt__PlainText(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PhoneNumber"))
		{	*type = SOAP_TYPE_ngwt__PhoneNumber;
			return soap_in_ngwt__PhoneNumber(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PhoneMessage"))
		{	*type = SOAP_TYPE_ngwt__PhoneMessage;
			return soap_in_ngwt__PhoneMessage(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PhoneList"))
		{	*type = SOAP_TYPE_ngwt__PhoneList;
			return soap_in_ngwt__PhoneList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PhoneFlags"))
		{	*type = SOAP_TYPE_ngwt__PhoneFlags;
			return soap_in_ngwt__PhoneFlags(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:PersonalInfo"))
		{	*type = SOAP_TYPE_ngwt__PersonalInfo;
			return soap_in_ngwt__PersonalInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Organization"))
		{	*type = SOAP_TYPE_ngwt__Organization;
			return soap_in_ngwt__Organization(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:OfficeInfo"))
		{	*type = SOAP_TYPE_ngwt__OfficeInfo;
			return soap_in_ngwt__OfficeInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Note"))
		{	*type = SOAP_TYPE_ngwt__Note;
			return soap_in_ngwt__Note(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:NameAndEmail"))
		{	*type = SOAP_TYPE_ngwt__NameAndEmail;
			return soap_in_ngwt__NameAndEmail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MonthList"))
		{	*type = SOAP_TYPE_ngwt__MonthList;
			return soap_in_ngwt__MonthList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ModifyItem"))
		{	*type = SOAP_TYPE_ngwt__ModifyItem;
			return soap_in_ngwt__ModifyItem(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MessagePart"))
		{	*type = SOAP_TYPE_ngwt__MessagePart;
			return soap_in_ngwt__MessagePart(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:MessageBody"))
		{	*type = SOAP_TYPE_ngwt__MessageBody;
			return soap_in_ngwt__MessageBody(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Mail"))
		{	*type = SOAP_TYPE_ngwt__Mail;
			return soap_in_ngwt__Mail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:LinkInfo"))
		{	*type = SOAP_TYPE_ngwt__LinkInfo;
			return soap_in_ngwt__LinkInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:LibraryList"))
		{	*type = SOAP_TYPE_ngwt__LibraryList;
			return soap_in_ngwt__LibraryList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Library"))
		{	*type = SOAP_TYPE_ngwt__Library;
			return soap_in_ngwt__Library(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:JunkHandlingList"))
		{	*type = SOAP_TYPE_ngwt__JunkHandlingList;
			return soap_in_ngwt__JunkHandlingList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:JunkEntry"))
		{	*type = SOAP_TYPE_ngwt__JunkEntry;
			return soap_in_ngwt__JunkEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemStatus"))
		{	*type = SOAP_TYPE_ngwt__ItemStatus;
			return soap_in_ngwt__ItemStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Items"))
		{	*type = SOAP_TYPE_ngwt__Items;
			return soap_in_ngwt__Items(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemRefList"))
		{	*type = SOAP_TYPE_ngwt__ItemRefList;
			return soap_in_ngwt__ItemRefList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemRef"))
		{	*type = SOAP_TYPE_ngwt__ItemRef;
			return soap_in_ngwt__ItemRef(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemOptions"))
		{	*type = SOAP_TYPE_ngwt__ItemOptions;
			return soap_in_ngwt__ItemOptions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemList"))
		{	*type = SOAP_TYPE_ngwt__ItemList;
			return soap_in_ngwt__ItemList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ItemChanges"))
		{	*type = SOAP_TYPE_ngwt__ItemChanges;
			return soap_in_ngwt__ItemChanges(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Item"))
		{	*type = SOAP_TYPE_ngwt__Item;
			return soap_in_ngwt__Item(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ImAddressList"))
		{	*type = SOAP_TYPE_ngwt__ImAddressList;
			return soap_in_ngwt__ImAddressList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ImAddress"))
		{	*type = SOAP_TYPE_ngwt__ImAddress;
			return soap_in_ngwt__ImAddress(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Host"))
		{	*type = SOAP_TYPE_ngwt__Host;
			return soap_in_ngwt__Host(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:GroupMemberList"))
		{	*type = SOAP_TYPE_ngwt__GroupMemberList;
			return soap_in_ngwt__GroupMemberList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:GroupMember"))
		{	*type = SOAP_TYPE_ngwt__GroupMember;
			return soap_in_ngwt__GroupMember(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Group"))
		{	*type = SOAP_TYPE_ngwt__Group;
			return soap_in_ngwt__Group(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FullName"))
		{	*type = SOAP_TYPE_ngwt__FullName;
			return soap_in_ngwt__FullName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:From"))
		{	*type = SOAP_TYPE_ngwt__From;
			return soap_in_ngwt__From(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyStats"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyStats;
			return soap_in_ngwt__FreeBusyStats(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyInfoList"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyInfoList;
			return soap_in_ngwt__FreeBusyInfoList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyUserList"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyUserList;
			return soap_in_ngwt__FreeBusyUserList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyInfo"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyInfo;
			return soap_in_ngwt__FreeBusyInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyBlock"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyBlock;
			return soap_in_ngwt__FreeBusyBlock(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FreeBusyBlockList"))
		{	*type = SOAP_TYPE_ngwt__FreeBusyBlockList;
			return soap_in_ngwt__FreeBusyBlockList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FolderList"))
		{	*type = SOAP_TYPE_ngwt__FolderList;
			return soap_in_ngwt__FolderList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FolderACLEntry"))
		{	*type = SOAP_TYPE_ngwt__FolderACLEntry;
			return soap_in_ngwt__FolderACLEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FolderACL"))
		{	*type = SOAP_TYPE_ngwt__FolderACL;
			return soap_in_ngwt__FolderACL(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Folder"))
		{	*type = SOAP_TYPE_ngwt__Folder;
			return soap_in_ngwt__Folder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FilterGroup"))
		{	*type = SOAP_TYPE_ngwt__FilterGroup;
			return soap_in_ngwt__FilterGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FilterEntry"))
		{	*type = SOAP_TYPE_ngwt__FilterEntry;
			return soap_in_ngwt__FilterEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:FilterElement"))
		{	*type = SOAP_TYPE_ngwt__FilterElement;
			return soap_in_ngwt__FilterElement(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Filter"))
		{	*type = SOAP_TYPE_ngwt__Filter;
			return soap_in_ngwt__Filter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:EmailAddressList"))
		{	*type = SOAP_TYPE_ngwt__EmailAddressList;
			return soap_in_ngwt__EmailAddressList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DocumentTypeList"))
		{	*type = SOAP_TYPE_ngwt__DocumentTypeList;
			return soap_in_ngwt__DocumentTypeList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DocumentType"))
		{	*type = SOAP_TYPE_ngwt__DocumentType;
			return soap_in_ngwt__DocumentType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DocumentRef"))
		{	*type = SOAP_TYPE_ngwt__DocumentRef;
			return soap_in_ngwt__DocumentRef(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Document"))
		{	*type = SOAP_TYPE_ngwt__Document;
			return soap_in_ngwt__Document(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Distribution"))
		{	*type = SOAP_TYPE_ngwt__Distribution;
			return soap_in_ngwt__Distribution(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DeltaInfo"))
		{	*type = SOAP_TYPE_ngwt__DeltaInfo;
			return soap_in_ngwt__DeltaInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DelegateeStatus"))
		{	*type = SOAP_TYPE_ngwt__DelegateeStatus;
			return soap_in_ngwt__DelegateeStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DelegatedStatus"))
		{	*type = SOAP_TYPE_ngwt__DelegatedStatus;
			return soap_in_ngwt__DelegatedStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfYearWeekList"))
		{	*type = SOAP_TYPE_ngwt__DayOfYearWeekList;
			return soap_in_ngwt__DayOfYearWeekList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfYearWeek"))
		{	*type = SOAP_TYPE_ngwt__DayOfYearWeek;
			return soap_in_ngwt__DayOfYearWeek(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfYearList"))
		{	*type = SOAP_TYPE_ngwt__DayOfYearList;
			return soap_in_ngwt__DayOfYearList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfWeek"))
		{	*type = SOAP_TYPE_ngwt__DayOfWeek;
			return soap_in_ngwt__DayOfWeek(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:DayOfMonthList"))
		{	*type = SOAP_TYPE_ngwt__DayOfMonthList;
			return soap_in_ngwt__DayOfMonthList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CustomList"))
		{	*type = SOAP_TYPE_ngwt__CustomList;
			return soap_in_ngwt__CustomList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Custom"))
		{	*type = SOAP_TYPE_ngwt__Custom;
			return soap_in_ngwt__Custom(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ContainerRef"))
		{	*type = SOAP_TYPE_ngwt__ContainerRef;
			return soap_in_ngwt__ContainerRef(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ContainerItem"))
		{	*type = SOAP_TYPE_ngwt__ContainerItem;
			return soap_in_ngwt__ContainerItem(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:ContactFolder"))
		{	*type = SOAP_TYPE_ngwt__ContactFolder;
			return soap_in_ngwt__ContactFolder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Contact"))
		{	*type = SOAP_TYPE_ngwt__Contact;
			return soap_in_ngwt__Contact(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CommentStatus"))
		{	*type = SOAP_TYPE_ngwt__CommentStatus;
			return soap_in_ngwt__CommentStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CategoryRefList"))
		{	*type = SOAP_TYPE_ngwt__CategoryRefList;
			return soap_in_ngwt__CategoryRefList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CategoryList"))
		{	*type = SOAP_TYPE_ngwt__CategoryList;
			return soap_in_ngwt__CategoryList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Category"))
		{	*type = SOAP_TYPE_ngwt__Category;
			return soap_in_ngwt__Category(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CalendarItem"))
		{	*type = SOAP_TYPE_ngwt__CalendarItem;
			return soap_in_ngwt__CalendarItem(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:CalendarFolderAttribute"))
		{	*type = SOAP_TYPE_ngwt__CalendarFolderAttribute;
			return soap_in_ngwt__CalendarFolderAttribute(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:BoxEntry"))
		{	*type = SOAP_TYPE_ngwt__BoxEntry;
			return soap_in_ngwt__BoxEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Authentication"))
		{	*type = SOAP_TYPE_ngwt__Authentication;
			return soap_in_ngwt__Authentication(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AttachmentItemInfo"))
		{	*type = SOAP_TYPE_ngwt__AttachmentItemInfo;
			return soap_in_ngwt__AttachmentItemInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AttachmentInfo"))
		{	*type = SOAP_TYPE_ngwt__AttachmentInfo;
			return soap_in_ngwt__AttachmentInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AttachmentID"))
		{	*type = SOAP_TYPE_ngwt__AttachmentID;
			return soap_in_ngwt__AttachmentID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Appointment"))
		{	*type = SOAP_TYPE_ngwt__Appointment;
			return soap_in_ngwt__Appointment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:Alarm"))
		{	*type = SOAP_TYPE_ngwt__Alarm;
			return soap_in_ngwt__Alarm(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AddressBookList"))
		{	*type = SOAP_TYPE_ngwt__AddressBookList;
			return soap_in_ngwt__AddressBookList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AddressBookItem"))
		{	*type = SOAP_TYPE_ngwt__AddressBookItem;
			return soap_in_ngwt__AddressBookItem(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AddressBook"))
		{	*type = SOAP_TYPE_ngwt__AddressBook;
			return soap_in_ngwt__AddressBook(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessRightList"))
		{	*type = SOAP_TYPE_ngwt__AccessRightList;
			return soap_in_ngwt__AccessRightList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessRightEntry"))
		{	*type = SOAP_TYPE_ngwt__AccessRightEntry;
			return soap_in_ngwt__AccessRightEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessRightChanges"))
		{	*type = SOAP_TYPE_ngwt__AccessRightChanges;
			return soap_in_ngwt__AccessRightChanges(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessRight"))
		{	*type = SOAP_TYPE_ngwt__AccessRight;
			return soap_in_ngwt__AccessRight(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessMiscRight"))
		{	*type = SOAP_TYPE_ngwt__AccessMiscRight;
			return soap_in_ngwt__AccessMiscRight(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessControlList"))
		{	*type = SOAP_TYPE_ngwt__AccessControlList;
			return soap_in_ngwt__AccessControlList(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ngwt:AccessControlListEntry"))
		{	*type = SOAP_TYPE_ngwt__AccessControlListEntry;
			return soap_in_ngwt__AccessControlListEntry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:language"))
		{	*type = SOAP_TYPE_xsd__language;
			return soap_in_xsd__language(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:duration"))
		{	*type = SOAP_TYPE_xsd__duration;
			return soap_in_xsd__duration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:decimal"))
		{	*type = SOAP_TYPE_xsd__decimal;
			return soap_in_xsd__decimal(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:date"))
		{	*type = SOAP_TYPE_xsd__date;
			return soap_in_xsd__date(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "TQName"))
		{	char **s;
			*type = SOAP_TYPE__TQName;
			s = soap_in__TQName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_ngwt__DayOfMonth:
		return soap_out_ngwt__DayOfMonth(soap, tag, id, (const char *)ptr, "ngwt:DayOfMonth");
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_ngwt__WeekOfYear:
		return soap_out_ngwt__WeekOfYear(soap, tag, id, (const short *)ptr, "ngwt:WeekOfYear");
	case SOAP_TYPE_ngwt__DayOfYear:
		return soap_out_ngwt__DayOfYear(soap, tag, id, (const short *)ptr, "ngwt:DayOfYear");
	case SOAP_TYPE_short:
		return soap_out_short(soap, tag, id, (const short *)ptr, "xsd:short");
	case SOAP_TYPE_ngwt__GMTOffset:
		return soap_out_ngwt__GMTOffset(soap, tag, id, (const int *)ptr, "ngwt:GMTOffset");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_ngwt__Month:
		return soap_out_ngwt__Month(soap, tag, id, (const unsigned char *)ptr, "ngwt:Month");
	case SOAP_TYPE_ngwt__Minute:
		return soap_out_ngwt__Minute(soap, tag, id, (const unsigned char *)ptr, "ngwt:Minute");
	case SOAP_TYPE_ngwt__Hour:
		return soap_out_ngwt__Hour(soap, tag, id, (const unsigned char *)ptr, "ngwt:Hour");
	case SOAP_TYPE_ngwt__Day:
		return soap_out_ngwt__Day(soap, tag, id, (const unsigned char *)ptr, "ngwt:Day");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_unsignedLong:
		return soap_out_unsignedLong(soap, tag, id, (const unsigned long *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_ngwe__ItemType:
		return soap_out_ngwe__ItemType(soap, tag, id, (const enum ngwe__ItemType *)ptr, "ngwe:ItemType");
	case SOAP_TYPE_ngwe__Field:
		return soap_out_ngwe__Field(soap, tag, id, (const enum ngwe__Field *)ptr, "ngwe:Field");
	case SOAP_TYPE_ngwe__EventType:
		return soap_out_ngwe__EventType(soap, tag, id, (const enum ngwe__EventType *)ptr, "ngwe:EventType");
	case SOAP_TYPE_ngwt__WeekDay:
		return soap_out_ngwt__WeekDay(soap, tag, id, (const enum ngwt__WeekDay *)ptr, "ngwt:WeekDay");
	case SOAP_TYPE_ngwt__VersionStatus:
		return soap_out_ngwt__VersionStatus(soap, tag, id, (const enum ngwt__VersionStatus *)ptr, "ngwt:VersionStatus");
	case SOAP_TYPE_ngwt__VersionEventType:
		return soap_out_ngwt__VersionEventType(soap, tag, id, (const enum ngwt__VersionEventType *)ptr, "ngwt:VersionEventType");
	case SOAP_TYPE_ngwt__StatusTrackingOptions:
		return soap_out_ngwt__StatusTrackingOptions(soap, tag, id, (const enum ngwt__StatusTrackingOptions *)ptr, "ngwt:StatusTrackingOptions");
	case SOAP_TYPE_ngwt__RuleActionType:
		return soap_out_ngwt__RuleActionType(soap, tag, id, (const enum ngwt__RuleActionType *)ptr, "ngwt:RuleActionType");
	case SOAP_TYPE_ngwt__RetractType:
		return soap_out_ngwt__RetractType(soap, tag, id, (const enum ngwt__RetractType *)ptr, "ngwt:RetractType");
	case SOAP_TYPE_ngwt__RecipientType:
		return soap_out_ngwt__RecipientType(soap, tag, id, (const enum ngwt__RecipientType *)ptr, "ngwt:RecipientType");
	case SOAP_TYPE_ngwt__PostalAddressType:
		return soap_out_ngwt__PostalAddressType(soap, tag, id, (const enum ngwt__PostalAddressType *)ptr, "ngwt:PostalAddressType");
	case SOAP_TYPE_ngwt__PhoneNumberType:
		return soap_out_ngwt__PhoneNumberType(soap, tag, id, (const enum ngwt__PhoneNumberType *)ptr, "ngwt:PhoneNumberType");
	case SOAP_TYPE_ngwt__OccurrenceType:
		return soap_out_ngwt__OccurrenceType(soap, tag, id, (const enum ngwt__OccurrenceType *)ptr, "ngwt:OccurrenceType");
	case SOAP_TYPE_ngwt__NotificationType:
		return soap_out_ngwt__NotificationType(soap, tag, id, (const enum ngwt__NotificationType *)ptr, "ngwt:NotificationType");
	case SOAP_TYPE_ngwt__MessageType:
		return soap_out_ngwt__MessageType(soap, tag, id, (const enum ngwt__MessageType *)ptr, "ngwt:MessageType");
	case SOAP_TYPE_ngwt__MessageList:
		return soap_out_ngwt__MessageList(soap, tag, id, (const enum ngwt__MessageList *)ptr, "ngwt:MessageList");
	case SOAP_TYPE_ngwt__LinkType:
		return soap_out_ngwt__LinkType(soap, tag, id, (const enum ngwt__LinkType *)ptr, "ngwt:LinkType");
	case SOAP_TYPE_ngwt__JunkMatchType:
		return soap_out_ngwt__JunkMatchType(soap, tag, id, (const enum ngwt__JunkMatchType *)ptr, "ngwt:JunkMatchType");
	case SOAP_TYPE_ngwt__JunkHandlingListType:
		return soap_out_ngwt__JunkHandlingListType(soap, tag, id, (const enum ngwt__JunkHandlingListType *)ptr, "ngwt:JunkHandlingListType");
	case SOAP_TYPE_ngwt__ItemSource:
		return soap_out_ngwt__ItemSource(soap, tag, id, (const enum ngwt__ItemSource *)ptr, "ngwt:ItemSource");
	case SOAP_TYPE_ngwt__ItemSecurity:
		return soap_out_ngwt__ItemSecurity(soap, tag, id, (const enum ngwt__ItemSecurity *)ptr, "ngwt:ItemSecurity");
	case SOAP_TYPE_ngwt__ItemOptionsPriority:
		return soap_out_ngwt__ItemOptionsPriority(soap, tag, id, (const enum ngwt__ItemOptionsPriority *)ptr, "ngwt:ItemOptionsPriority");
	case SOAP_TYPE_ngwt__ItemClass:
		return soap_out_ngwt__ItemClass(soap, tag, id, (const enum ngwt__ItemClass *)ptr, "ngwt:ItemClass");
	case SOAP_TYPE_ngwt__Frequency:
		return soap_out_ngwt__Frequency(soap, tag, id, (const enum ngwt__Frequency *)ptr, "ngwt:Frequency");
	case SOAP_TYPE_ngwt__FolderType:
		return soap_out_ngwt__FolderType(soap, tag, id, (const enum ngwt__FolderType *)ptr, "ngwt:FolderType");
	case SOAP_TYPE_ngwt__FolderACLStatus:
		return soap_out_ngwt__FolderACLStatus(soap, tag, id, (const enum ngwt__FolderACLStatus *)ptr, "ngwt:FolderACLStatus");
	case SOAP_TYPE_ngwt__FilterOp:
		return soap_out_ngwt__FilterOp(soap, tag, id, (const enum ngwt__FilterOp *)ptr, "ngwt:FilterOp");
	case SOAP_TYPE_ngwt__FilterDate:
		return soap_out_ngwt__FilterDate(soap, tag, id, (const enum ngwt__FilterDate *)ptr, "ngwt:FilterDate");
	case SOAP_TYPE_ngwt__Execution:
		return soap_out_ngwt__Execution(soap, tag, id, (const enum ngwt__Execution *)ptr, "ngwt:Execution");
	case SOAP_TYPE_ngwt__DistributionType:
		return soap_out_ngwt__DistributionType(soap, tag, id, (const enum ngwt__DistributionType *)ptr, "ngwt:DistributionType");
	case SOAP_TYPE_ngwt__DeltaSyncType:
		return soap_out_ngwt__DeltaSyncType(soap, tag, id, (const enum ngwt__DeltaSyncType *)ptr, "ngwt:DeltaSyncType");
	case SOAP_TYPE_ngwt__CustomType:
		return soap_out_ngwt__CustomType(soap, tag, id, (const enum ngwt__CustomType *)ptr, "ngwt:CustomType");
	case SOAP_TYPE_ngwt__CursorSeek:
		return soap_out_ngwt__CursorSeek(soap, tag, id, (const enum ngwt__CursorSeek *)ptr, "ngwt:CursorSeek");
	case SOAP_TYPE_ngwt__ContactType:
		return soap_out_ngwt__ContactType(soap, tag, id, (const enum ngwt__ContactType *)ptr, "ngwt:ContactType");
	case SOAP_TYPE_ngwt__CategoryType:
		return soap_out_ngwt__CategoryType(soap, tag, id, (const enum ngwt__CategoryType *)ptr, "ngwt:CategoryType");
	case SOAP_TYPE_ngwt__CalendarFolderFlags:
		return soap_out_ngwt__CalendarFolderFlags(soap, tag, id, (const enum ngwt__CalendarFolderFlags *)ptr, "ngwt:CalendarFolderFlags");
	case SOAP_TYPE_ngwt__AppointmentConflict:
		return soap_out_ngwt__AppointmentConflict(soap, tag, id, (const enum ngwt__AppointmentConflict *)ptr, "ngwt:AppointmentConflict");
	case SOAP_TYPE_ngwt__AgeAction:
		return soap_out_ngwt__AgeAction(soap, tag, id, (const enum ngwt__AgeAction *)ptr, "ngwt:AgeAction");
	case SOAP_TYPE_ngwt__AcceptLevel:
		return soap_out_ngwt__AcceptLevel(soap, tag, id, (const enum ngwt__AcceptLevel *)ptr, "ngwt:AcceptLevel");
	case SOAP_TYPE_ngwe__ItemTypeList:
		return soap_out_ngwe__ItemTypeList(soap, tag, id, (const enum ngwe__ItemTypeList *)ptr, "ngwe:ItemTypeList");
	case SOAP_TYPE_ngwe__FieldList:
		return soap_out_ngwe__FieldList(soap, tag, id, (const enum ngwe__FieldList *)ptr, "ngwe:FieldList");
	case SOAP_TYPE_ngwt__MessageTypeList:
		return soap_out_ngwt__MessageTypeList(soap, tag, id, (const enum ngwt__MessageTypeList *)ptr, "ngwt:MessageTypeList");
	case SOAP_TYPE_ngwt__ItemSourceList:
		return soap_out_ngwt__ItemSourceList(soap, tag, id, (const enum ngwt__ItemSourceList *)ptr, "ngwt:ItemSourceList");
	case SOAP_TYPE_ngwt__UUID:
		return soap_out_ngwt__UUID(soap, tag, id, (const std::string *)ptr, "ngwt:UUID");
	case SOAP_TYPE_ngwt__uid:
		return soap_out_ngwt__uid(soap, tag, id, (const std::string *)ptr, "ngwt:uid");
	case SOAP_TYPE_ngwt__View:
		return soap_out_ngwt__View(soap, tag, id, (const std::string *)ptr, "ngwt:View");
	case SOAP_TYPE__ngwe__removeEventsResponse:
		return ((_ngwe__removeEventsResponse *)ptr)->soap_out(soap, "ngwe:removeEventsResponse", id, NULL);
	case SOAP_TYPE__ngwe__removeEventsRequest:
		return ((_ngwe__removeEventsRequest *)ptr)->soap_out(soap, "ngwe:removeEventsRequest", id, NULL);
	case SOAP_TYPE__ngwe__removeEventConfigurationResponse:
		return ((_ngwe__removeEventConfigurationResponse *)ptr)->soap_out(soap, "ngwe:removeEventConfigurationResponse", id, NULL);
	case SOAP_TYPE__ngwe__removeEventConfigurationRequest:
		return ((_ngwe__removeEventConfigurationRequest *)ptr)->soap_out(soap, "ngwe:removeEventConfigurationRequest", id, NULL);
	case SOAP_TYPE__ngwe__getEventsResponse:
		return ((_ngwe__getEventsResponse *)ptr)->soap_out(soap, "ngwe:getEventsResponse", id, NULL);
	case SOAP_TYPE__ngwe__getEventsRequest:
		return ((_ngwe__getEventsRequest *)ptr)->soap_out(soap, "ngwe:getEventsRequest", id, NULL);
	case SOAP_TYPE__ngwe__getEventConfigurationResponse:
		return ((_ngwe__getEventConfigurationResponse *)ptr)->soap_out(soap, "ngwe:getEventConfigurationResponse", id, NULL);
	case SOAP_TYPE__ngwe__getEventConfigurationRequest:
		return ((_ngwe__getEventConfigurationRequest *)ptr)->soap_out(soap, "ngwe:getEventConfigurationRequest", id, NULL);
	case SOAP_TYPE__ngwe__configureEventsResponse:
		return ((_ngwe__configureEventsResponse *)ptr)->soap_out(soap, "ngwe:configureEventsResponse", id, NULL);
	case SOAP_TYPE__ngwe__configureEventsRequest:
		return ((_ngwe__configureEventsRequest *)ptr)->soap_out(soap, "ngwe:configureEventsRequest", id, NULL);
	case SOAP_TYPE__ngwe__cleanEventConfigurationResponse:
		return ((_ngwe__cleanEventConfigurationResponse *)ptr)->soap_out(soap, "ngwe:cleanEventConfigurationResponse", id, NULL);
	case SOAP_TYPE__ngwe__cleanEventConfigurationRequest:
		return ((_ngwe__cleanEventConfigurationRequest *)ptr)->soap_out(soap, "ngwe:cleanEventConfigurationRequest", id, NULL);
	case SOAP_TYPE_ngwe__Notify:
		return ((ngwe__Notify *)ptr)->soap_out(soap, tag, id, "ngwe:Notify");
	case SOAP_TYPE_ngwe__EventTypeList:
		return ((ngwe__EventTypeList *)ptr)->soap_out(soap, tag, id, "ngwe:EventTypeList");
	case SOAP_TYPE_ngwe__EventsList:
		return ((ngwe__EventsList *)ptr)->soap_out(soap, tag, id, "ngwe:EventsList");
	case SOAP_TYPE_ngwe__Events:
		return ((ngwe__Events *)ptr)->soap_out(soap, tag, id, "ngwe:Events");
	case SOAP_TYPE_ngwe__EventList:
		return ((ngwe__EventList *)ptr)->soap_out(soap, tag, id, "ngwe:EventList");
	case SOAP_TYPE_ngwe__EventDefinition:
		return ((ngwe__EventDefinition *)ptr)->soap_out(soap, tag, id, "ngwe:EventDefinition");
	case SOAP_TYPE_ngwe__Event:
		return ((ngwe__Event *)ptr)->soap_out(soap, tag, id, "ngwe:Event");
	case SOAP_TYPE_ngwe__ContainerList:
		return ((ngwe__ContainerList *)ptr)->soap_out(soap, tag, id, "ngwe:ContainerList");
	case SOAP_TYPE__ngwm__updateVersionStatusResponse:
		return ((_ngwm__updateVersionStatusResponse *)ptr)->soap_out(soap, "ngwm:updateVersionStatusResponse", id, NULL);
	case SOAP_TYPE__ngwm__updateVersionStatusRequest:
		return ((_ngwm__updateVersionStatusRequest *)ptr)->soap_out(soap, "ngwm:updateVersionStatusRequest", id, NULL);
	case SOAP_TYPE__ngwm__uncompleteResponse:
		return ((_ngwm__uncompleteResponse *)ptr)->soap_out(soap, "ngwm:uncompleteResponse", id, NULL);
	case SOAP_TYPE__ngwm__uncompleteRequest:
		return ((_ngwm__uncompleteRequest *)ptr)->soap_out(soap, "ngwm:uncompleteRequest", id, NULL);
	case SOAP_TYPE__ngwm__unacceptResponse:
		return ((_ngwm__unacceptResponse *)ptr)->soap_out(soap, "ngwm:unacceptResponse", id, NULL);
	case SOAP_TYPE__ngwm__unacceptRequest:
		return ((_ngwm__unacceptRequest *)ptr)->soap_out(soap, "ngwm:unacceptRequest", id, NULL);
	case SOAP_TYPE__ngwm__startFreeBusySessionResponse:
		return ((_ngwm__startFreeBusySessionResponse *)ptr)->soap_out(soap, "ngwm:startFreeBusySessionResponse", id, NULL);
	case SOAP_TYPE__ngwm__startFreeBusySessionRequest:
		return ((_ngwm__startFreeBusySessionRequest *)ptr)->soap_out(soap, "ngwm:startFreeBusySessionRequest", id, NULL);
	case SOAP_TYPE__ngwm__setTimestampResponse:
		return ((_ngwm__setTimestampResponse *)ptr)->soap_out(soap, "ngwm:setTimestampResponse", id, NULL);
	case SOAP_TYPE__ngwm__setTimestampRequest:
		return ((_ngwm__setTimestampRequest *)ptr)->soap_out(soap, "ngwm:setTimestampRequest", id, NULL);
	case SOAP_TYPE__ngwm__sendItemResponse:
		return ((_ngwm__sendItemResponse *)ptr)->soap_out(soap, "ngwm:sendItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__sendItemRequest:
		return ((_ngwm__sendItemRequest *)ptr)->soap_out(soap, "ngwm:sendItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__retractResponse:
		return ((_ngwm__retractResponse *)ptr)->soap_out(soap, "ngwm:retractResponse", id, NULL);
	case SOAP_TYPE__ngwm__retractRequest:
		return ((_ngwm__retractRequest *)ptr)->soap_out(soap, "ngwm:retractRequest", id, NULL);
	case SOAP_TYPE__ngwm__replyResponse:
		return ((_ngwm__replyResponse *)ptr)->soap_out(soap, "ngwm:replyResponse", id, NULL);
	case SOAP_TYPE__ngwm__replyRequest:
		return ((_ngwm__replyRequest *)ptr)->soap_out(soap, "ngwm:replyRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeSignatureResponse:
		return ((_ngwm__removeSignatureResponse *)ptr)->soap_out(soap, "ngwm:removeSignatureResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeSignatureRequest:
		return ((_ngwm__removeSignatureRequest *)ptr)->soap_out(soap, "ngwm:removeSignatureRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeProxyUserResponse:
		return ((_ngwm__removeProxyUserResponse *)ptr)->soap_out(soap, "ngwm:removeProxyUserResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeProxyUserRequest:
		return ((_ngwm__removeProxyUserRequest *)ptr)->soap_out(soap, "ngwm:removeProxyUserRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeProxyAccessResponse:
		return ((_ngwm__removeProxyAccessResponse *)ptr)->soap_out(soap, "ngwm:removeProxyAccessResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeProxyAccessRequest:
		return ((_ngwm__removeProxyAccessRequest *)ptr)->soap_out(soap, "ngwm:removeProxyAccessRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeMembersResponse:
		return ((_ngwm__removeMembersResponse *)ptr)->soap_out(soap, "ngwm:removeMembersResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeMembersRequest:
		return ((_ngwm__removeMembersRequest *)ptr)->soap_out(soap, "ngwm:removeMembersRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeJunkEntryResponse:
		return ((_ngwm__removeJunkEntryResponse *)ptr)->soap_out(soap, "ngwm:removeJunkEntryResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeJunkEntryRequest:
		return ((_ngwm__removeJunkEntryRequest *)ptr)->soap_out(soap, "ngwm:removeJunkEntryRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeItemsResponse:
		return ((_ngwm__removeItemsResponse *)ptr)->soap_out(soap, "ngwm:removeItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeItemsRequest:
		return ((_ngwm__removeItemsRequest *)ptr)->soap_out(soap, "ngwm:removeItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeItemResponse:
		return ((_ngwm__removeItemResponse *)ptr)->soap_out(soap, "ngwm:removeItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeItemRequest:
		return ((_ngwm__removeItemRequest *)ptr)->soap_out(soap, "ngwm:removeItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__removeCustomDefinitionResponse:
		return ((_ngwm__removeCustomDefinitionResponse *)ptr)->soap_out(soap, "ngwm:removeCustomDefinitionResponse", id, NULL);
	case SOAP_TYPE__ngwm__removeCustomDefinitionRequest:
		return ((_ngwm__removeCustomDefinitionRequest *)ptr)->soap_out(soap, "ngwm:removeCustomDefinitionRequest", id, NULL);
	case SOAP_TYPE__ngwm__readCursorResponse:
		return ((_ngwm__readCursorResponse *)ptr)->soap_out(soap, "ngwm:readCursorResponse", id, NULL);
	case SOAP_TYPE__ngwm__readCursorRequest:
		return ((_ngwm__readCursorRequest *)ptr)->soap_out(soap, "ngwm:readCursorRequest", id, NULL);
	case SOAP_TYPE__ngwm__purgeResponse:
		return ((_ngwm__purgeResponse *)ptr)->soap_out(soap, "ngwm:purgeResponse", id, NULL);
	case SOAP_TYPE__ngwm__purgeRequest:
		return ((_ngwm__purgeRequest *)ptr)->soap_out(soap, "ngwm:purgeRequest", id, NULL);
	case SOAP_TYPE__ngwm__purgeDeletedItemsResponse:
		return ((_ngwm__purgeDeletedItemsResponse *)ptr)->soap_out(soap, "ngwm:purgeDeletedItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__purgeDeletedItemsRequest:
		return ((_ngwm__purgeDeletedItemsRequest *)ptr)->soap_out(soap, "ngwm:purgeDeletedItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__positionCursorResponse:
		return ((_ngwm__positionCursorResponse *)ptr)->soap_out(soap, "ngwm:positionCursorResponse", id, NULL);
	case SOAP_TYPE__ngwm__positionCursorRequest:
		return ((_ngwm__positionCursorRequest *)ptr)->soap_out(soap, "ngwm:positionCursorRequest", id, NULL);
	case SOAP_TYPE__ngwm__moveItemResponse:
		return ((_ngwm__moveItemResponse *)ptr)->soap_out(soap, "ngwm:moveItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__moveItemRequest:
		return ((_ngwm__moveItemRequest *)ptr)->soap_out(soap, "ngwm:moveItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifySignaturesResponse:
		return ((_ngwm__modifySignaturesResponse *)ptr)->soap_out(soap, "ngwm:modifySignaturesResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifySignaturesRequest:
		return ((_ngwm__modifySignaturesRequest *)ptr)->soap_out(soap, "ngwm:modifySignaturesRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifySettingsResponse:
		return ((_ngwm__modifySettingsResponse *)ptr)->soap_out(soap, "ngwm:modifySettingsResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifySettingsRequest:
		return ((_ngwm__modifySettingsRequest *)ptr)->soap_out(soap, "ngwm:modifySettingsRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyProxyAccessResponse:
		return ((_ngwm__modifyProxyAccessResponse *)ptr)->soap_out(soap, "ngwm:modifyProxyAccessResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyProxyAccessRequest:
		return ((_ngwm__modifyProxyAccessRequest *)ptr)->soap_out(soap, "ngwm:modifyProxyAccessRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyPasswordResponse:
		return ((_ngwm__modifyPasswordResponse *)ptr)->soap_out(soap, "ngwm:modifyPasswordResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyPasswordRequest:
		return ((_ngwm__modifyPasswordRequest *)ptr)->soap_out(soap, "ngwm:modifyPasswordRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse:
		return ((_ngwm__modifyJunkMailSettingsResponse *)ptr)->soap_out(soap, "ngwm:modifyJunkMailSettingsResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest:
		return ((_ngwm__modifyJunkMailSettingsRequest *)ptr)->soap_out(soap, "ngwm:modifyJunkMailSettingsRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyJunkEntryResponse:
		return ((_ngwm__modifyJunkEntryResponse *)ptr)->soap_out(soap, "ngwm:modifyJunkEntryResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyJunkEntryRequest:
		return ((_ngwm__modifyJunkEntryRequest *)ptr)->soap_out(soap, "ngwm:modifyJunkEntryRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyItemsResponse:
		return ((_ngwm__modifyItemsResponse *)ptr)->soap_out(soap, "ngwm:modifyItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyItemsRequest:
		return ((_ngwm__modifyItemsRequest *)ptr)->soap_out(soap, "ngwm:modifyItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__modifyItemResponse:
		return ((_ngwm__modifyItemResponse *)ptr)->soap_out(soap, "ngwm:modifyItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__modifyItemRequest:
		return ((_ngwm__modifyItemRequest *)ptr)->soap_out(soap, "ngwm:modifyItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__markUnReadResponse:
		return ((_ngwm__markUnReadResponse *)ptr)->soap_out(soap, "ngwm:markUnReadResponse", id, NULL);
	case SOAP_TYPE__ngwm__markUnReadRequest:
		return ((_ngwm__markUnReadRequest *)ptr)->soap_out(soap, "ngwm:markUnReadRequest", id, NULL);
	case SOAP_TYPE__ngwm__markUnPrivateResponse:
		return ((_ngwm__markUnPrivateResponse *)ptr)->soap_out(soap, "ngwm:markUnPrivateResponse", id, NULL);
	case SOAP_TYPE__ngwm__markUnPrivateRequest:
		return ((_ngwm__markUnPrivateRequest *)ptr)->soap_out(soap, "ngwm:markUnPrivateRequest", id, NULL);
	case SOAP_TYPE__ngwm__markReadResponse:
		return ((_ngwm__markReadResponse *)ptr)->soap_out(soap, "ngwm:markReadResponse", id, NULL);
	case SOAP_TYPE__ngwm__markReadRequest:
		return ((_ngwm__markReadRequest *)ptr)->soap_out(soap, "ngwm:markReadRequest", id, NULL);
	case SOAP_TYPE__ngwm__markPrivateResponse:
		return ((_ngwm__markPrivateResponse *)ptr)->soap_out(soap, "ngwm:markPrivateResponse", id, NULL);
	case SOAP_TYPE__ngwm__markPrivateRequest:
		return ((_ngwm__markPrivateRequest *)ptr)->soap_out(soap, "ngwm:markPrivateRequest", id, NULL);
	case SOAP_TYPE__ngwm__logoutResponse:
		return ((_ngwm__logoutResponse *)ptr)->soap_out(soap, "ngwm:logoutResponse", id, NULL);
	case SOAP_TYPE__ngwm__logoutRequest:
		return ((_ngwm__logoutRequest *)ptr)->soap_out(soap, "ngwm:logoutRequest", id, NULL);
	case SOAP_TYPE__ngwm__loginResponse:
		return ((_ngwm__loginResponse *)ptr)->soap_out(soap, "ngwm:loginResponse", id, NULL);
	case SOAP_TYPE__ngwm__loginRequest:
		return ((_ngwm__loginRequest *)ptr)->soap_out(soap, "ngwm:loginRequest", id, NULL);
	case SOAP_TYPE__ngwm__getUserListResponse:
		return ((_ngwm__getUserListResponse *)ptr)->soap_out(soap, "ngwm:getUserListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getUserListRequest:
		return ((_ngwm__getUserListRequest *)ptr)->soap_out(soap, "ngwm:getUserListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getTimezoneListResponse:
		return ((_ngwm__getTimezoneListResponse *)ptr)->soap_out(soap, "ngwm:getTimezoneListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getTimezoneListRequest:
		return ((_ngwm__getTimezoneListRequest *)ptr)->soap_out(soap, "ngwm:getTimezoneListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getTimestampResponse:
		return ((_ngwm__getTimestampResponse *)ptr)->soap_out(soap, "ngwm:getTimestampResponse", id, NULL);
	case SOAP_TYPE__ngwm__getTimestampRequest:
		return ((_ngwm__getTimestampRequest *)ptr)->soap_out(soap, "ngwm:getTimestampRequest", id, NULL);
	case SOAP_TYPE__ngwm__getSignaturesResponse:
		return ((_ngwm__getSignaturesResponse *)ptr)->soap_out(soap, "ngwm:getSignaturesResponse", id, NULL);
	case SOAP_TYPE__ngwm__getSignaturesRequest:
		return ((_ngwm__getSignaturesRequest *)ptr)->soap_out(soap, "ngwm:getSignaturesRequest", id, NULL);
	case SOAP_TYPE__ngwm__getSettingsResponse:
		return ((_ngwm__getSettingsResponse *)ptr)->soap_out(soap, "ngwm:getSettingsResponse", id, NULL);
	case SOAP_TYPE__ngwm__getSettingsRequest:
		return ((_ngwm__getSettingsRequest *)ptr)->soap_out(soap, "ngwm:getSettingsRequest", id, NULL);
	case SOAP_TYPE__ngwm__getRuleListResponse:
		return ((_ngwm__getRuleListResponse *)ptr)->soap_out(soap, "ngwm:getRuleListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getRuleListRequest:
		return ((_ngwm__getRuleListRequest *)ptr)->soap_out(soap, "ngwm:getRuleListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getProxyListResponse:
		return ((_ngwm__getProxyListResponse *)ptr)->soap_out(soap, "ngwm:getProxyListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getProxyListRequest:
		return ((_ngwm__getProxyListRequest *)ptr)->soap_out(soap, "ngwm:getProxyListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getProxyAccessListResponse:
		return ((_ngwm__getProxyAccessListResponse *)ptr)->soap_out(soap, "ngwm:getProxyAccessListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getProxyAccessListRequest:
		return ((_ngwm__getProxyAccessListRequest *)ptr)->soap_out(soap, "ngwm:getProxyAccessListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getQuickMessagesResponse:
		return ((_ngwm__getQuickMessagesResponse *)ptr)->soap_out(soap, "ngwm:getQuickMessagesResponse", id, NULL);
	case SOAP_TYPE__ngwm__getQuickMessagesRequest:
		return ((_ngwm__getQuickMessagesRequest *)ptr)->soap_out(soap, "ngwm:getQuickMessagesRequest", id, NULL);
	case SOAP_TYPE__ngwm__getLibraryListResponse:
		return ((_ngwm__getLibraryListResponse *)ptr)->soap_out(soap, "ngwm:getLibraryListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getLibraryListRequest:
		return ((_ngwm__getLibraryListRequest *)ptr)->soap_out(soap, "ngwm:getLibraryListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getLibraryItemResponse:
		return ((_ngwm__getLibraryItemResponse *)ptr)->soap_out(soap, "ngwm:getLibraryItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__getLibraryItemRequest:
		return ((_ngwm__getLibraryItemRequest *)ptr)->soap_out(soap, "ngwm:getLibraryItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__getJunkMailSettingsResponse:
		return ((_ngwm__getJunkMailSettingsResponse *)ptr)->soap_out(soap, "ngwm:getJunkMailSettingsResponse", id, NULL);
	case SOAP_TYPE__ngwm__getJunkMailSettingsRequest:
		return ((_ngwm__getJunkMailSettingsRequest *)ptr)->soap_out(soap, "ngwm:getJunkMailSettingsRequest", id, NULL);
	case SOAP_TYPE__ngwm__getJunkEntriesResponse:
		return ((_ngwm__getJunkEntriesResponse *)ptr)->soap_out(soap, "ngwm:getJunkEntriesResponse", id, NULL);
	case SOAP_TYPE__ngwm__getJunkEntriesRequest:
		return ((_ngwm__getJunkEntriesRequest *)ptr)->soap_out(soap, "ngwm:getJunkEntriesRequest", id, NULL);
	case SOAP_TYPE__ngwm__getItemsResponse:
		return ((_ngwm__getItemsResponse *)ptr)->soap_out(soap, "ngwm:getItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__getItemsRequest:
		return ((_ngwm__getItemsRequest *)ptr)->soap_out(soap, "ngwm:getItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__getItemResponse:
		return ((_ngwm__getItemResponse *)ptr)->soap_out(soap, "ngwm:getItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__getItemRequest:
		return ((_ngwm__getItemRequest *)ptr)->soap_out(soap, "ngwm:getItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__getFreeBusyResponse:
		return ((_ngwm__getFreeBusyResponse *)ptr)->soap_out(soap, "ngwm:getFreeBusyResponse", id, NULL);
	case SOAP_TYPE__ngwm__getFreeBusyRequest:
		return ((_ngwm__getFreeBusyRequest *)ptr)->soap_out(soap, "ngwm:getFreeBusyRequest", id, NULL);
	case SOAP_TYPE__ngwm__getFolderListResponse:
		return ((_ngwm__getFolderListResponse *)ptr)->soap_out(soap, "ngwm:getFolderListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getFolderListRequest:
		return ((_ngwm__getFolderListRequest *)ptr)->soap_out(soap, "ngwm:getFolderListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getFolderResponse:
		return ((_ngwm__getFolderResponse *)ptr)->soap_out(soap, "ngwm:getFolderResponse", id, NULL);
	case SOAP_TYPE__ngwm__getFolderRequest:
		return ((_ngwm__getFolderRequest *)ptr)->soap_out(soap, "ngwm:getFolderRequest", id, NULL);
	case SOAP_TYPE__ngwm__getDocumentTypeListResponse:
		return ((_ngwm__getDocumentTypeListResponse *)ptr)->soap_out(soap, "ngwm:getDocumentTypeListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getDocumentTypeListRequest:
		return ((_ngwm__getDocumentTypeListRequest *)ptr)->soap_out(soap, "ngwm:getDocumentTypeListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getDeltaInfoResponse:
		return ((_ngwm__getDeltaInfoResponse *)ptr)->soap_out(soap, "ngwm:getDeltaInfoResponse", id, NULL);
	case SOAP_TYPE__ngwm__getDeltaInfoRequest:
		return ((_ngwm__getDeltaInfoRequest *)ptr)->soap_out(soap, "ngwm:getDeltaInfoRequest", id, NULL);
	case SOAP_TYPE__ngwm__getDeltasResponse:
		return ((_ngwm__getDeltasResponse *)ptr)->soap_out(soap, "ngwm:getDeltasResponse", id, NULL);
	case SOAP_TYPE__ngwm__getDeltasRequest:
		return ((_ngwm__getDeltasRequest *)ptr)->soap_out(soap, "ngwm:getDeltasRequest", id, NULL);
	case SOAP_TYPE__ngwm__getCustomListResponse:
		return ((_ngwm__getCustomListResponse *)ptr)->soap_out(soap, "ngwm:getCustomListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getCustomListRequest:
		return ((_ngwm__getCustomListRequest *)ptr)->soap_out(soap, "ngwm:getCustomListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getCategoryListResponse:
		return ((_ngwm__getCategoryListResponse *)ptr)->soap_out(soap, "ngwm:getCategoryListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getCategoryListRequest:
		return ((_ngwm__getCategoryListRequest *)ptr)->soap_out(soap, "ngwm:getCategoryListRequest", id, NULL);
	case SOAP_TYPE__ngwm__getAttachmentResponse:
		return ((_ngwm__getAttachmentResponse *)ptr)->soap_out(soap, "ngwm:getAttachmentResponse", id, NULL);
	case SOAP_TYPE__ngwm__getAttachmentRequest:
		return ((_ngwm__getAttachmentRequest *)ptr)->soap_out(soap, "ngwm:getAttachmentRequest", id, NULL);
	case SOAP_TYPE__ngwm__getAddressBookListResponse:
		return ((_ngwm__getAddressBookListResponse *)ptr)->soap_out(soap, "ngwm:getAddressBookListResponse", id, NULL);
	case SOAP_TYPE__ngwm__getAddressBookListRequest:
		return ((_ngwm__getAddressBookListRequest *)ptr)->soap_out(soap, "ngwm:getAddressBookListRequest", id, NULL);
	case SOAP_TYPE__ngwm__forwardResponse:
		return ((_ngwm__forwardResponse *)ptr)->soap_out(soap, "ngwm:forwardResponse", id, NULL);
	case SOAP_TYPE__ngwm__forwardRequest:
		return ((_ngwm__forwardRequest *)ptr)->soap_out(soap, "ngwm:forwardRequest", id, NULL);
	case SOAP_TYPE__ngwm__executeRuleResponse:
		return ((_ngwm__executeRuleResponse *)ptr)->soap_out(soap, "ngwm:executeRuleResponse", id, NULL);
	case SOAP_TYPE__ngwm__executeRuleRequest:
		return ((_ngwm__executeRuleRequest *)ptr)->soap_out(soap, "ngwm:executeRuleRequest", id, NULL);
	case SOAP_TYPE__ngwm__destroyCursorResponse:
		return ((_ngwm__destroyCursorResponse *)ptr)->soap_out(soap, "ngwm:destroyCursorResponse", id, NULL);
	case SOAP_TYPE__ngwm__destroyCursorRequest:
		return ((_ngwm__destroyCursorRequest *)ptr)->soap_out(soap, "ngwm:destroyCursorRequest", id, NULL);
	case SOAP_TYPE__ngwm__delegateResponse:
		return ((_ngwm__delegateResponse *)ptr)->soap_out(soap, "ngwm:delegateResponse", id, NULL);
	case SOAP_TYPE__ngwm__delegateRequest:
		return ((_ngwm__delegateRequest *)ptr)->soap_out(soap, "ngwm:delegateRequest", id, NULL);
	case SOAP_TYPE__ngwm__declineResponse:
		return ((_ngwm__declineResponse *)ptr)->soap_out(soap, "ngwm:declineResponse", id, NULL);
	case SOAP_TYPE__ngwm__declineRequest:
		return ((_ngwm__declineRequest *)ptr)->soap_out(soap, "ngwm:declineRequest", id, NULL);
	case SOAP_TYPE__ngwm__createSignatureResponse:
		return ((_ngwm__createSignatureResponse *)ptr)->soap_out(soap, "ngwm:createSignatureResponse", id, NULL);
	case SOAP_TYPE__ngwm__createSignatureRequest:
		return ((_ngwm__createSignatureRequest *)ptr)->soap_out(soap, "ngwm:createSignatureRequest", id, NULL);
	case SOAP_TYPE__ngwm__createProxyAccessResponse:
		return ((_ngwm__createProxyAccessResponse *)ptr)->soap_out(soap, "ngwm:createProxyAccessResponse", id, NULL);
	case SOAP_TYPE__ngwm__createProxyAccessRequest:
		return ((_ngwm__createProxyAccessRequest *)ptr)->soap_out(soap, "ngwm:createProxyAccessRequest", id, NULL);
	case SOAP_TYPE__ngwm__createJunkEntryResponse:
		return ((_ngwm__createJunkEntryResponse *)ptr)->soap_out(soap, "ngwm:createJunkEntryResponse", id, NULL);
	case SOAP_TYPE__ngwm__createJunkEntryRequest:
		return ((_ngwm__createJunkEntryRequest *)ptr)->soap_out(soap, "ngwm:createJunkEntryRequest", id, NULL);
	case SOAP_TYPE__ngwm__createItemsResponse:
		return ((_ngwm__createItemsResponse *)ptr)->soap_out(soap, "ngwm:createItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__createItemsRequest:
		return ((_ngwm__createItemsRequest *)ptr)->soap_out(soap, "ngwm:createItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__createItemResponse:
		return ((_ngwm__createItemResponse *)ptr)->soap_out(soap, "ngwm:createItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__createItemRequest:
		return ((_ngwm__createItemRequest *)ptr)->soap_out(soap, "ngwm:createItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__createCursorResponse:
		return ((_ngwm__createCursorResponse *)ptr)->soap_out(soap, "ngwm:createCursorResponse", id, NULL);
	case SOAP_TYPE__ngwm__createCursorRequest:
		return ((_ngwm__createCursorRequest *)ptr)->soap_out(soap, "ngwm:createCursorRequest", id, NULL);
	case SOAP_TYPE__ngwm__completeResponse:
		return ((_ngwm__completeResponse *)ptr)->soap_out(soap, "ngwm:completeResponse", id, NULL);
	case SOAP_TYPE__ngwm__completeRequest:
		return ((_ngwm__completeRequest *)ptr)->soap_out(soap, "ngwm:completeRequest", id, NULL);
	case SOAP_TYPE__ngwm__closeFreeBusySessionResponse:
		return ((_ngwm__closeFreeBusySessionResponse *)ptr)->soap_out(soap, "ngwm:closeFreeBusySessionResponse", id, NULL);
	case SOAP_TYPE__ngwm__closeFreeBusySessionRequest:
		return ((_ngwm__closeFreeBusySessionRequest *)ptr)->soap_out(soap, "ngwm:closeFreeBusySessionRequest", id, NULL);
	case SOAP_TYPE__ngwm__addMembersResponse:
		return ((_ngwm__addMembersResponse *)ptr)->soap_out(soap, "ngwm:addMembersResponse", id, NULL);
	case SOAP_TYPE__ngwm__addMembersRequest:
		return ((_ngwm__addMembersRequest *)ptr)->soap_out(soap, "ngwm:addMembersRequest", id, NULL);
	case SOAP_TYPE__ngwm__addItemsResponse:
		return ((_ngwm__addItemsResponse *)ptr)->soap_out(soap, "ngwm:addItemsResponse", id, NULL);
	case SOAP_TYPE__ngwm__addItemsRequest:
		return ((_ngwm__addItemsRequest *)ptr)->soap_out(soap, "ngwm:addItemsRequest", id, NULL);
	case SOAP_TYPE__ngwm__addItemResponse:
		return ((_ngwm__addItemResponse *)ptr)->soap_out(soap, "ngwm:addItemResponse", id, NULL);
	case SOAP_TYPE__ngwm__addItemRequest:
		return ((_ngwm__addItemRequest *)ptr)->soap_out(soap, "ngwm:addItemRequest", id, NULL);
	case SOAP_TYPE__ngwm__acceptShareResponse:
		return ((_ngwm__acceptShareResponse *)ptr)->soap_out(soap, "ngwm:acceptShareResponse", id, NULL);
	case SOAP_TYPE__ngwm__acceptShareRequest:
		return ((_ngwm__acceptShareRequest *)ptr)->soap_out(soap, "ngwm:acceptShareRequest", id, NULL);
	case SOAP_TYPE__ngwm__acceptResponse:
		return ((_ngwm__acceptResponse *)ptr)->soap_out(soap, "ngwm:acceptResponse", id, NULL);
	case SOAP_TYPE__ngwm__acceptRequest:
		return ((_ngwm__acceptRequest *)ptr)->soap_out(soap, "ngwm:acceptRequest", id, NULL);
	case SOAP_TYPE_ngwt__VersionEvent:
		return ((ngwt__VersionEvent *)ptr)->soap_out(soap, tag, id, "ngwt:VersionEvent");
	case SOAP_TYPE_ngwt__Version:
		return ((ngwt__Version *)ptr)->soap_out(soap, tag, id, "ngwt:Version");
	case SOAP_TYPE_ngwt__UserList:
		return ((ngwt__UserList *)ptr)->soap_out(soap, tag, id, "ngwt:UserList");
	case SOAP_TYPE_ngwt__UserInfo:
		return ((ngwt__UserInfo *)ptr)->soap_out(soap, tag, id, "ngwt:UserInfo");
	case SOAP_TYPE_ngwt__TrustedApplication:
		return ((ngwt__TrustedApplication *)ptr)->soap_out(soap, tag, id, "ngwt:TrustedApplication");
	case SOAP_TYPE_ngwt__TransferFailedStatus:
		return ((ngwt__TransferFailedStatus *)ptr)->soap_out(soap, tag, id, "ngwt:TransferFailedStatus");
	case SOAP_TYPE_ngwt__TimezoneList:
		return ((ngwt__TimezoneList *)ptr)->soap_out(soap, tag, id, "ngwt:TimezoneList");
	case SOAP_TYPE_ngwt__TimezoneComponent:
		return ((ngwt__TimezoneComponent *)ptr)->soap_out(soap, tag, id, "ngwt:TimezoneComponent");
	case SOAP_TYPE_ngwt__Timezone:
		return ((ngwt__Timezone *)ptr)->soap_out(soap, tag, id, "ngwt:Timezone");
	case SOAP_TYPE_ngwt__Task:
		return ((ngwt__Task *)ptr)->soap_out(soap, tag, id, "ngwt:Task");
	case SOAP_TYPE_ngwt__SystemFolder:
		return ((ngwt__SystemFolder *)ptr)->soap_out(soap, tag, id, "ngwt:SystemFolder");
	case SOAP_TYPE_ngwt__StatusTracking:
		return ((ngwt__StatusTracking *)ptr)->soap_out(soap, tag, id, "ngwt:StatusTracking");
	case SOAP_TYPE_ngwt__Status:
		return ((ngwt__Status *)ptr)->soap_out(soap, tag, id, "ngwt:Status");
	case SOAP_TYPE_ngwt__SMimeOperation:
		return ((ngwt__SMimeOperation *)ptr)->soap_out(soap, tag, id, "ngwt:SMimeOperation");
	case SOAP_TYPE_ngwt__SignatureData:
		return ((ngwt__SignatureData *)ptr)->soap_out(soap, tag, id, "ngwt:SignatureData");
	case SOAP_TYPE_ngwt__Signatures:
		return ((ngwt__Signatures *)ptr)->soap_out(soap, tag, id, "ngwt:Signatures");
	case SOAP_TYPE_ngwt__Signature:
		return ((ngwt__Signature *)ptr)->soap_out(soap, tag, id, "ngwt:Signature");
	case SOAP_TYPE_ngwt__SharedNotification:
		return ((ngwt__SharedNotification *)ptr)->soap_out(soap, tag, id, "ngwt:SharedNotification");
	case SOAP_TYPE_ngwt__SharedFolderNotification:
		return ((ngwt__SharedFolderNotification *)ptr)->soap_out(soap, tag, id, "ngwt:SharedFolderNotification");
	case SOAP_TYPE_ngwt__SharedFolder:
		return ((ngwt__SharedFolder *)ptr)->soap_out(soap, tag, id, "ngwt:SharedFolder");
	case SOAP_TYPE_ngwt__SettingsList:
		return ((ngwt__SettingsList *)ptr)->soap_out(soap, tag, id, "ngwt:SettingsList");
	case SOAP_TYPE_ngwt__SettingsGroup:
		return ((ngwt__SettingsGroup *)ptr)->soap_out(soap, tag, id, "ngwt:SettingsGroup");
	case SOAP_TYPE_ngwt__Settings:
		return ((ngwt__Settings *)ptr)->soap_out(soap, tag, id, "ngwt:Settings");
	case SOAP_TYPE_ngwt__SendOptions:
		return ((ngwt__SendOptions *)ptr)->soap_out(soap, tag, id, "ngwt:SendOptions");
	case SOAP_TYPE_ngwt__SendOptionsRequestReply:
		return ((ngwt__SendOptionsRequestReply *)ptr)->soap_out(soap, tag, id, "ngwt:SendOptionsRequestReply");
	case SOAP_TYPE_ngwt__RuleList:
		return ((ngwt__RuleList *)ptr)->soap_out(soap, tag, id, "ngwt:RuleList");
	case SOAP_TYPE_ngwt__RuleActionList:
		return ((ngwt__RuleActionList *)ptr)->soap_out(soap, tag, id, "ngwt:RuleActionList");
	case SOAP_TYPE_ngwt__RuleAction:
		return ((ngwt__RuleAction *)ptr)->soap_out(soap, tag, id, "ngwt:RuleAction");
	case SOAP_TYPE_ngwt__Rule:
		return ((ngwt__Rule *)ptr)->soap_out(soap, tag, id, "ngwt:Rule");
	case SOAP_TYPE_ngwt__Rights:
		return ((ngwt__Rights *)ptr)->soap_out(soap, tag, id, "ngwt:Rights");
	case SOAP_TYPE_ngwt__ReturnNotificationOptions:
		return ((ngwt__ReturnNotificationOptions *)ptr)->soap_out(soap, tag, id, "ngwt:ReturnNotificationOptions");
	case SOAP_TYPE_ngwt__ReturnNotification:
		return ((ngwt__ReturnNotification *)ptr)->soap_out(soap, tag, id, "ngwt:ReturnNotification");
	case SOAP_TYPE_ngwt__Resource:
		return ((ngwt__Resource *)ptr)->soap_out(soap, tag, id, "ngwt:Resource");
	case SOAP_TYPE_ngwt__ReferenceInfo:
		return ((ngwt__ReferenceInfo *)ptr)->soap_out(soap, tag, id, "ngwt:ReferenceInfo");
	case SOAP_TYPE_ngwt__RecurrenceRule:
		return ((ngwt__RecurrenceRule *)ptr)->soap_out(soap, tag, id, "ngwt:RecurrenceRule");
	case SOAP_TYPE_ngwt__RecurrenceDateType:
		return ((ngwt__RecurrenceDateType *)ptr)->soap_out(soap, tag, id, "ngwt:RecurrenceDateType");
	case SOAP_TYPE_ngwt__RecipientStatus:
		return ((ngwt__RecipientStatus *)ptr)->soap_out(soap, tag, id, "ngwt:RecipientStatus");
	case SOAP_TYPE_ngwt__RecipientList:
		return ((ngwt__RecipientList *)ptr)->soap_out(soap, tag, id, "ngwt:RecipientList");
	case SOAP_TYPE_ngwt__Recipient:
		return ((ngwt__Recipient *)ptr)->soap_out(soap, tag, id, "ngwt:Recipient");
	case SOAP_TYPE_ngwt__QueryTarget:
		return ((ngwt__QueryTarget *)ptr)->soap_out(soap, tag, id, "ngwt:QueryTarget");
	case SOAP_TYPE_ngwt__QueryFolder:
		return ((ngwt__QueryFolder *)ptr)->soap_out(soap, tag, id, "ngwt:QueryFolder");
	case SOAP_TYPE_ngwt__Query:
		return ((ngwt__Query *)ptr)->soap_out(soap, tag, id, "ngwt:Query");
	case SOAP_TYPE_ngwt__ProxyList:
		return ((ngwt__ProxyList *)ptr)->soap_out(soap, tag, id, "ngwt:ProxyList");
	case SOAP_TYPE_ngwt__ProxyUser:
		return ((ngwt__ProxyUser *)ptr)->soap_out(soap, tag, id, "ngwt:ProxyUser");
	case SOAP_TYPE_ngwt__Proxy:
		return ((ngwt__Proxy *)ptr)->soap_out(soap, tag, id, "ngwt:Proxy");
	case SOAP_TYPE_ngwt__ProblemList:
		return ((ngwt__ProblemList *)ptr)->soap_out(soap, tag, id, "ngwt:ProblemList");
	case SOAP_TYPE_ngwt__ProblemEntry:
		return ((ngwt__ProblemEntry *)ptr)->soap_out(soap, tag, id, "ngwt:ProblemEntry");
	case SOAP_TYPE_ngwt__PostalAddressList:
		return ((ngwt__PostalAddressList *)ptr)->soap_out(soap, tag, id, "ngwt:PostalAddressList");
	case SOAP_TYPE_ngwt__PostalAddress:
		return ((ngwt__PostalAddress *)ptr)->soap_out(soap, tag, id, "ngwt:PostalAddress");
	case SOAP_TYPE_ngwt__PlainText:
		return ((ngwt__PlainText *)ptr)->soap_out(soap, tag, id, "ngwt:PlainText");
	case SOAP_TYPE_ngwt__PhoneNumber:
		return ((ngwt__PhoneNumber *)ptr)->soap_out(soap, tag, id, "ngwt:PhoneNumber");
	case SOAP_TYPE_ngwt__PhoneMessage:
		return ((ngwt__PhoneMessage *)ptr)->soap_out(soap, tag, id, "ngwt:PhoneMessage");
	case SOAP_TYPE_ngwt__PhoneList:
		return ((ngwt__PhoneList *)ptr)->soap_out(soap, tag, id, "ngwt:PhoneList");
	case SOAP_TYPE_ngwt__PhoneFlags:
		return ((ngwt__PhoneFlags *)ptr)->soap_out(soap, tag, id, "ngwt:PhoneFlags");
	case SOAP_TYPE_ngwt__PersonalInfo:
		return ((ngwt__PersonalInfo *)ptr)->soap_out(soap, tag, id, "ngwt:PersonalInfo");
	case SOAP_TYPE_ngwt__Organization:
		return ((ngwt__Organization *)ptr)->soap_out(soap, tag, id, "ngwt:Organization");
	case SOAP_TYPE_ngwt__OfficeInfo:
		return ((ngwt__OfficeInfo *)ptr)->soap_out(soap, tag, id, "ngwt:OfficeInfo");
	case SOAP_TYPE_ngwt__Note:
		return ((ngwt__Note *)ptr)->soap_out(soap, tag, id, "ngwt:Note");
	case SOAP_TYPE_ngwt__NameAndEmail:
		return ((ngwt__NameAndEmail *)ptr)->soap_out(soap, tag, id, "ngwt:NameAndEmail");
	case SOAP_TYPE_ngwt__MonthList:
		return ((ngwt__MonthList *)ptr)->soap_out(soap, tag, id, "ngwt:MonthList");
	case SOAP_TYPE_ngwt__ModifyItem:
		return ((ngwt__ModifyItem *)ptr)->soap_out(soap, tag, id, "ngwt:ModifyItem");
	case SOAP_TYPE_ngwt__MessagePart:
		return ((ngwt__MessagePart *)ptr)->soap_out(soap, tag, id, "ngwt:MessagePart");
	case SOAP_TYPE_ngwt__MessageBody:
		return ((ngwt__MessageBody *)ptr)->soap_out(soap, tag, id, "ngwt:MessageBody");
	case SOAP_TYPE_ngwt__Mail:
		return ((ngwt__Mail *)ptr)->soap_out(soap, tag, id, "ngwt:Mail");
	case SOAP_TYPE_ngwt__LinkInfo:
		return ((ngwt__LinkInfo *)ptr)->soap_out(soap, tag, id, "ngwt:LinkInfo");
	case SOAP_TYPE_ngwt__LibraryList:
		return ((ngwt__LibraryList *)ptr)->soap_out(soap, tag, id, "ngwt:LibraryList");
	case SOAP_TYPE_ngwt__Library:
		return ((ngwt__Library *)ptr)->soap_out(soap, tag, id, "ngwt:Library");
	case SOAP_TYPE_ngwt__JunkHandlingList:
		return ((ngwt__JunkHandlingList *)ptr)->soap_out(soap, tag, id, "ngwt:JunkHandlingList");
	case SOAP_TYPE_ngwt__JunkEntry:
		return ((ngwt__JunkEntry *)ptr)->soap_out(soap, tag, id, "ngwt:JunkEntry");
	case SOAP_TYPE_ngwt__ItemStatus:
		return ((ngwt__ItemStatus *)ptr)->soap_out(soap, tag, id, "ngwt:ItemStatus");
	case SOAP_TYPE_ngwt__Items:
		return ((ngwt__Items *)ptr)->soap_out(soap, tag, id, "ngwt:Items");
	case SOAP_TYPE_ngwt__ItemRefList:
		return ((ngwt__ItemRefList *)ptr)->soap_out(soap, tag, id, "ngwt:ItemRefList");
	case SOAP_TYPE_ngwt__ItemRef:
		return ((ngwt__ItemRef *)ptr)->soap_out(soap, tag, id, "ngwt:ItemRef");
	case SOAP_TYPE_ngwt__ItemOptions:
		return ((ngwt__ItemOptions *)ptr)->soap_out(soap, tag, id, "ngwt:ItemOptions");
	case SOAP_TYPE_ngwt__ItemList:
		return ((ngwt__ItemList *)ptr)->soap_out(soap, tag, id, "ngwt:ItemList");
	case SOAP_TYPE_ngwt__ItemChanges:
		return ((ngwt__ItemChanges *)ptr)->soap_out(soap, tag, id, "ngwt:ItemChanges");
	case SOAP_TYPE_ngwt__Item:
		return ((ngwt__Item *)ptr)->soap_out(soap, tag, id, "ngwt:Item");
	case SOAP_TYPE_ngwt__ImAddressList:
		return ((ngwt__ImAddressList *)ptr)->soap_out(soap, tag, id, "ngwt:ImAddressList");
	case SOAP_TYPE_ngwt__ImAddress:
		return ((ngwt__ImAddress *)ptr)->soap_out(soap, tag, id, "ngwt:ImAddress");
	case SOAP_TYPE_ngwt__Host:
		return ((ngwt__Host *)ptr)->soap_out(soap, tag, id, "ngwt:Host");
	case SOAP_TYPE_ngwt__GroupMemberList:
		return ((ngwt__GroupMemberList *)ptr)->soap_out(soap, tag, id, "ngwt:GroupMemberList");
	case SOAP_TYPE_ngwt__GroupMember:
		return ((ngwt__GroupMember *)ptr)->soap_out(soap, tag, id, "ngwt:GroupMember");
	case SOAP_TYPE_ngwt__Group:
		return ((ngwt__Group *)ptr)->soap_out(soap, tag, id, "ngwt:Group");
	case SOAP_TYPE_ngwt__FullName:
		return ((ngwt__FullName *)ptr)->soap_out(soap, tag, id, "ngwt:FullName");
	case SOAP_TYPE_ngwt__From:
		return ((ngwt__From *)ptr)->soap_out(soap, tag, id, "ngwt:From");
	case SOAP_TYPE_ngwt__FreeBusyStats:
		return ((ngwt__FreeBusyStats *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyStats");
	case SOAP_TYPE_ngwt__FreeBusyInfoList:
		return ((ngwt__FreeBusyInfoList *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyInfoList");
	case SOAP_TYPE_ngwt__FreeBusyUserList:
		return ((ngwt__FreeBusyUserList *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyUserList");
	case SOAP_TYPE_ngwt__FreeBusyInfo:
		return ((ngwt__FreeBusyInfo *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyInfo");
	case SOAP_TYPE_ngwt__FreeBusyBlock:
		return ((ngwt__FreeBusyBlock *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyBlock");
	case SOAP_TYPE_ngwt__FreeBusyBlockList:
		return ((ngwt__FreeBusyBlockList *)ptr)->soap_out(soap, tag, id, "ngwt:FreeBusyBlockList");
	case SOAP_TYPE_ngwt__FolderList:
		return ((ngwt__FolderList *)ptr)->soap_out(soap, tag, id, "ngwt:FolderList");
	case SOAP_TYPE_ngwt__FolderACLEntry:
		return ((ngwt__FolderACLEntry *)ptr)->soap_out(soap, tag, id, "ngwt:FolderACLEntry");
	case SOAP_TYPE_ngwt__FolderACL:
		return ((ngwt__FolderACL *)ptr)->soap_out(soap, tag, id, "ngwt:FolderACL");
	case SOAP_TYPE_ngwt__Folder:
		return ((ngwt__Folder *)ptr)->soap_out(soap, tag, id, "ngwt:Folder");
	case SOAP_TYPE_ngwt__FilterGroup:
		return ((ngwt__FilterGroup *)ptr)->soap_out(soap, tag, id, "ngwt:FilterGroup");
	case SOAP_TYPE_ngwt__FilterEntry:
		return ((ngwt__FilterEntry *)ptr)->soap_out(soap, tag, id, "ngwt:FilterEntry");
	case SOAP_TYPE_ngwt__FilterElement:
		return ((ngwt__FilterElement *)ptr)->soap_out(soap, tag, id, "ngwt:FilterElement");
	case SOAP_TYPE_ngwt__Filter:
		return ((ngwt__Filter *)ptr)->soap_out(soap, tag, id, "ngwt:Filter");
	case SOAP_TYPE_ngwt__EmailAddressList:
		return ((ngwt__EmailAddressList *)ptr)->soap_out(soap, tag, id, "ngwt:EmailAddressList");
	case SOAP_TYPE_ngwt__DocumentTypeList:
		return ((ngwt__DocumentTypeList *)ptr)->soap_out(soap, tag, id, "ngwt:DocumentTypeList");
	case SOAP_TYPE_ngwt__DocumentType:
		return ((ngwt__DocumentType *)ptr)->soap_out(soap, tag, id, "ngwt:DocumentType");
	case SOAP_TYPE_ngwt__DocumentRef:
		return ((ngwt__DocumentRef *)ptr)->soap_out(soap, tag, id, "ngwt:DocumentRef");
	case SOAP_TYPE_ngwt__Document:
		return ((ngwt__Document *)ptr)->soap_out(soap, tag, id, "ngwt:Document");
	case SOAP_TYPE_ngwt__Distribution:
		return ((ngwt__Distribution *)ptr)->soap_out(soap, tag, id, "ngwt:Distribution");
	case SOAP_TYPE_ngwt__DeltaInfo:
		return ((ngwt__DeltaInfo *)ptr)->soap_out(soap, tag, id, "ngwt:DeltaInfo");
	case SOAP_TYPE_ngwt__DelegateeStatus:
		return ((ngwt__DelegateeStatus *)ptr)->soap_out(soap, tag, id, "ngwt:DelegateeStatus");
	case SOAP_TYPE_ngwt__DelegatedStatus:
		return ((ngwt__DelegatedStatus *)ptr)->soap_out(soap, tag, id, "ngwt:DelegatedStatus");
	case SOAP_TYPE_ngwt__DayOfYearWeekList:
		return ((ngwt__DayOfYearWeekList *)ptr)->soap_out(soap, tag, id, "ngwt:DayOfYearWeekList");
	case SOAP_TYPE_ngwt__DayOfYearWeek:
		return ((ngwt__DayOfYearWeek *)ptr)->soap_out(soap, tag, id, "ngwt:DayOfYearWeek");
	case SOAP_TYPE_ngwt__DayOfYearList:
		return ((ngwt__DayOfYearList *)ptr)->soap_out(soap, tag, id, "ngwt:DayOfYearList");
	case SOAP_TYPE_ngwt__DayOfWeek:
		return ((ngwt__DayOfWeek *)ptr)->soap_out(soap, tag, id, "ngwt:DayOfWeek");
	case SOAP_TYPE_ngwt__DayOfMonthList:
		return ((ngwt__DayOfMonthList *)ptr)->soap_out(soap, tag, id, "ngwt:DayOfMonthList");
	case SOAP_TYPE_ngwt__CustomList:
		return ((ngwt__CustomList *)ptr)->soap_out(soap, tag, id, "ngwt:CustomList");
	case SOAP_TYPE_ngwt__Custom:
		return ((ngwt__Custom *)ptr)->soap_out(soap, tag, id, "ngwt:Custom");
	case SOAP_TYPE_ngwt__ContainerRef:
		return ((ngwt__ContainerRef *)ptr)->soap_out(soap, tag, id, "ngwt:ContainerRef");
	case SOAP_TYPE_ngwt__ContainerItem:
		return ((ngwt__ContainerItem *)ptr)->soap_out(soap, tag, id, "ngwt:ContainerItem");
	case SOAP_TYPE_ngwt__ContactFolder:
		return ((ngwt__ContactFolder *)ptr)->soap_out(soap, tag, id, "ngwt:ContactFolder");
	case SOAP_TYPE_ngwt__Contact:
		return ((ngwt__Contact *)ptr)->soap_out(soap, tag, id, "ngwt:Contact");
	case SOAP_TYPE_ngwt__CommentStatus:
		return ((ngwt__CommentStatus *)ptr)->soap_out(soap, tag, id, "ngwt:CommentStatus");
	case SOAP_TYPE_ngwt__CategoryRefList:
		return ((ngwt__CategoryRefList *)ptr)->soap_out(soap, tag, id, "ngwt:CategoryRefList");
	case SOAP_TYPE_ngwt__CategoryList:
		return ((ngwt__CategoryList *)ptr)->soap_out(soap, tag, id, "ngwt:CategoryList");
	case SOAP_TYPE_ngwt__Category:
		return ((ngwt__Category *)ptr)->soap_out(soap, tag, id, "ngwt:Category");
	case SOAP_TYPE_ngwt__CalendarItem:
		return ((ngwt__CalendarItem *)ptr)->soap_out(soap, tag, id, "ngwt:CalendarItem");
	case SOAP_TYPE_ngwt__CalendarFolderAttribute:
		return ((ngwt__CalendarFolderAttribute *)ptr)->soap_out(soap, tag, id, "ngwt:CalendarFolderAttribute");
	case SOAP_TYPE_ngwt__BoxEntry:
		return ((ngwt__BoxEntry *)ptr)->soap_out(soap, tag, id, "ngwt:BoxEntry");
	case SOAP_TYPE_ngwt__Authentication:
		return ((ngwt__Authentication *)ptr)->soap_out(soap, tag, id, "ngwt:Authentication");
	case SOAP_TYPE_ngwt__AttachmentItemInfo:
		return ((ngwt__AttachmentItemInfo *)ptr)->soap_out(soap, tag, id, "ngwt:AttachmentItemInfo");
	case SOAP_TYPE_ngwt__AttachmentInfo:
		return ((ngwt__AttachmentInfo *)ptr)->soap_out(soap, tag, id, "ngwt:AttachmentInfo");
	case SOAP_TYPE_ngwt__AttachmentID:
		return ((ngwt__AttachmentID *)ptr)->soap_out(soap, tag, id, "ngwt:AttachmentID");
	case SOAP_TYPE_ngwt__Appointment:
		return ((ngwt__Appointment *)ptr)->soap_out(soap, tag, id, "ngwt:Appointment");
	case SOAP_TYPE_ngwt__Alarm:
		return ((ngwt__Alarm *)ptr)->soap_out(soap, tag, id, "ngwt:Alarm");
	case SOAP_TYPE_ngwt__AddressBookList:
		return ((ngwt__AddressBookList *)ptr)->soap_out(soap, tag, id, "ngwt:AddressBookList");
	case SOAP_TYPE_ngwt__AddressBookItem:
		return ((ngwt__AddressBookItem *)ptr)->soap_out(soap, tag, id, "ngwt:AddressBookItem");
	case SOAP_TYPE_ngwt__AddressBook:
		return ((ngwt__AddressBook *)ptr)->soap_out(soap, tag, id, "ngwt:AddressBook");
	case SOAP_TYPE_ngwt__AccessRightList:
		return ((ngwt__AccessRightList *)ptr)->soap_out(soap, tag, id, "ngwt:AccessRightList");
	case SOAP_TYPE_ngwt__AccessRightEntry:
		return ((ngwt__AccessRightEntry *)ptr)->soap_out(soap, tag, id, "ngwt:AccessRightEntry");
	case SOAP_TYPE_ngwt__AccessRightChanges:
		return ((ngwt__AccessRightChanges *)ptr)->soap_out(soap, tag, id, "ngwt:AccessRightChanges");
	case SOAP_TYPE_ngwt__AccessRight:
		return ((ngwt__AccessRight *)ptr)->soap_out(soap, tag, id, "ngwt:AccessRight");
	case SOAP_TYPE_ngwt__AccessMiscRight:
		return ((ngwt__AccessMiscRight *)ptr)->soap_out(soap, tag, id, "ngwt:AccessMiscRight");
	case SOAP_TYPE_ngwt__AccessControlList:
		return ((ngwt__AccessControlList *)ptr)->soap_out(soap, tag, id, "ngwt:AccessControlList");
	case SOAP_TYPE_ngwt__AccessControlListEntry:
		return ((ngwt__AccessControlListEntry *)ptr)->soap_out(soap, tag, id, "ngwt:AccessControlListEntry");
	case SOAP_TYPE_xsd__language:
		return soap_out_xsd__language(soap, tag, id, (const std::string *)ptr, "xsd:language");
	case SOAP_TYPE_xsd__duration:
		return soap_out_xsd__duration(soap, tag, id, (const std::string *)ptr, "xsd:duration");
	case SOAP_TYPE_xsd__decimal:
		return soap_out_xsd__decimal(soap, tag, id, (const std::string *)ptr, "xsd:decimal");
	case SOAP_TYPE_xsd__date:
		return soap_out_xsd__date(soap, tag, id, (const std::string *)ptr, "xsd:date");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE_xsd__base64Binary:
		return ((xsd__base64Binary *)ptr)->soap_out(soap, tag, id, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_ngwe__removeEventsResponse:
		return soap_out_PointerTo_ngwe__removeEventsResponse(soap, tag, id, (_ngwe__removeEventsResponse *const*)ptr, "ngwe:removeEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__removeEventsRequest:
		return soap_out_PointerTo_ngwe__removeEventsRequest(soap, tag, id, (_ngwe__removeEventsRequest *const*)ptr, "ngwe:removeEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationResponse:
		return soap_out_PointerTo_ngwe__removeEventConfigurationResponse(soap, tag, id, (_ngwe__removeEventConfigurationResponse *const*)ptr, "ngwe:removeEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationRequest:
		return soap_out_PointerTo_ngwe__removeEventConfigurationRequest(soap, tag, id, (_ngwe__removeEventConfigurationRequest *const*)ptr, "ngwe:removeEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwe__getEventsResponse:
		return soap_out_PointerTo_ngwe__getEventsResponse(soap, tag, id, (_ngwe__getEventsResponse *const*)ptr, "ngwe:getEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__getEventsRequest:
		return soap_out_PointerTo_ngwe__getEventsRequest(soap, tag, id, (_ngwe__getEventsRequest *const*)ptr, "ngwe:getEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationResponse:
		return soap_out_PointerTo_ngwe__getEventConfigurationResponse(soap, tag, id, (_ngwe__getEventConfigurationResponse *const*)ptr, "ngwe:getEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationRequest:
		return soap_out_PointerTo_ngwe__getEventConfigurationRequest(soap, tag, id, (_ngwe__getEventConfigurationRequest *const*)ptr, "ngwe:getEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwe__configureEventsResponse:
		return soap_out_PointerTo_ngwe__configureEventsResponse(soap, tag, id, (_ngwe__configureEventsResponse *const*)ptr, "ngwe:configureEventsResponse");
	case SOAP_TYPE_PointerTo_ngwe__configureEventsRequest:
		return soap_out_PointerTo_ngwe__configureEventsRequest(soap, tag, id, (_ngwe__configureEventsRequest *const*)ptr, "ngwe:configureEventsRequest");
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationResponse:
		return soap_out_PointerTo_ngwe__cleanEventConfigurationResponse(soap, tag, id, (_ngwe__cleanEventConfigurationResponse *const*)ptr, "ngwe:cleanEventConfigurationResponse");
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationRequest:
		return soap_out_PointerTo_ngwe__cleanEventConfigurationRequest(soap, tag, id, (_ngwe__cleanEventConfigurationRequest *const*)ptr, "ngwe:cleanEventConfigurationRequest");
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusResponse:
		return soap_out_PointerTo_ngwm__updateVersionStatusResponse(soap, tag, id, (_ngwm__updateVersionStatusResponse *const*)ptr, "ngwm:updateVersionStatusResponse");
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusRequest:
		return soap_out_PointerTo_ngwm__updateVersionStatusRequest(soap, tag, id, (_ngwm__updateVersionStatusRequest *const*)ptr, "ngwm:updateVersionStatusRequest");
	case SOAP_TYPE_PointerTo_ngwm__uncompleteResponse:
		return soap_out_PointerTo_ngwm__uncompleteResponse(soap, tag, id, (_ngwm__uncompleteResponse *const*)ptr, "ngwm:uncompleteResponse");
	case SOAP_TYPE_PointerTo_ngwm__uncompleteRequest:
		return soap_out_PointerTo_ngwm__uncompleteRequest(soap, tag, id, (_ngwm__uncompleteRequest *const*)ptr, "ngwm:uncompleteRequest");
	case SOAP_TYPE_PointerTo_ngwm__unacceptResponse:
		return soap_out_PointerTo_ngwm__unacceptResponse(soap, tag, id, (_ngwm__unacceptResponse *const*)ptr, "ngwm:unacceptResponse");
	case SOAP_TYPE_PointerTo_ngwm__unacceptRequest:
		return soap_out_PointerTo_ngwm__unacceptRequest(soap, tag, id, (_ngwm__unacceptRequest *const*)ptr, "ngwm:unacceptRequest");
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionResponse:
		return soap_out_PointerTo_ngwm__startFreeBusySessionResponse(soap, tag, id, (_ngwm__startFreeBusySessionResponse *const*)ptr, "ngwm:startFreeBusySessionResponse");
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionRequest:
		return soap_out_PointerTo_ngwm__startFreeBusySessionRequest(soap, tag, id, (_ngwm__startFreeBusySessionRequest *const*)ptr, "ngwm:startFreeBusySessionRequest");
	case SOAP_TYPE_PointerTo_ngwm__setTimestampResponse:
		return soap_out_PointerTo_ngwm__setTimestampResponse(soap, tag, id, (_ngwm__setTimestampResponse *const*)ptr, "ngwm:setTimestampResponse");
	case SOAP_TYPE_PointerTo_ngwm__setTimestampRequest:
		return soap_out_PointerTo_ngwm__setTimestampRequest(soap, tag, id, (_ngwm__setTimestampRequest *const*)ptr, "ngwm:setTimestampRequest");
	case SOAP_TYPE_PointerTo_ngwm__sendItemResponse:
		return soap_out_PointerTo_ngwm__sendItemResponse(soap, tag, id, (_ngwm__sendItemResponse *const*)ptr, "ngwm:sendItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__sendItemRequest:
		return soap_out_PointerTo_ngwm__sendItemRequest(soap, tag, id, (_ngwm__sendItemRequest *const*)ptr, "ngwm:sendItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__retractResponse:
		return soap_out_PointerTo_ngwm__retractResponse(soap, tag, id, (_ngwm__retractResponse *const*)ptr, "ngwm:retractResponse");
	case SOAP_TYPE_PointerTo_ngwm__retractRequest:
		return soap_out_PointerTo_ngwm__retractRequest(soap, tag, id, (_ngwm__retractRequest *const*)ptr, "ngwm:retractRequest");
	case SOAP_TYPE_PointerTo_ngwm__replyResponse:
		return soap_out_PointerTo_ngwm__replyResponse(soap, tag, id, (_ngwm__replyResponse *const*)ptr, "ngwm:replyResponse");
	case SOAP_TYPE_PointerTo_ngwm__replyRequest:
		return soap_out_PointerTo_ngwm__replyRequest(soap, tag, id, (_ngwm__replyRequest *const*)ptr, "ngwm:replyRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureResponse:
		return soap_out_PointerTo_ngwm__removeSignatureResponse(soap, tag, id, (_ngwm__removeSignatureResponse *const*)ptr, "ngwm:removeSignatureResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureRequest:
		return soap_out_PointerTo_ngwm__removeSignatureRequest(soap, tag, id, (_ngwm__removeSignatureRequest *const*)ptr, "ngwm:removeSignatureRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserResponse:
		return soap_out_PointerTo_ngwm__removeProxyUserResponse(soap, tag, id, (_ngwm__removeProxyUserResponse *const*)ptr, "ngwm:removeProxyUserResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserRequest:
		return soap_out_PointerTo_ngwm__removeProxyUserRequest(soap, tag, id, (_ngwm__removeProxyUserRequest *const*)ptr, "ngwm:removeProxyUserRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessResponse:
		return soap_out_PointerTo_ngwm__removeProxyAccessResponse(soap, tag, id, (_ngwm__removeProxyAccessResponse *const*)ptr, "ngwm:removeProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessRequest:
		return soap_out_PointerTo_ngwm__removeProxyAccessRequest(soap, tag, id, (_ngwm__removeProxyAccessRequest *const*)ptr, "ngwm:removeProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeMembersResponse:
		return soap_out_PointerTo_ngwm__removeMembersResponse(soap, tag, id, (_ngwm__removeMembersResponse *const*)ptr, "ngwm:removeMembersResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeMembersRequest:
		return soap_out_PointerTo_ngwm__removeMembersRequest(soap, tag, id, (_ngwm__removeMembersRequest *const*)ptr, "ngwm:removeMembersRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryResponse:
		return soap_out_PointerTo_ngwm__removeJunkEntryResponse(soap, tag, id, (_ngwm__removeJunkEntryResponse *const*)ptr, "ngwm:removeJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryRequest:
		return soap_out_PointerTo_ngwm__removeJunkEntryRequest(soap, tag, id, (_ngwm__removeJunkEntryRequest *const*)ptr, "ngwm:removeJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeItemsResponse:
		return soap_out_PointerTo_ngwm__removeItemsResponse(soap, tag, id, (_ngwm__removeItemsResponse *const*)ptr, "ngwm:removeItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeItemsRequest:
		return soap_out_PointerTo_ngwm__removeItemsRequest(soap, tag, id, (_ngwm__removeItemsRequest *const*)ptr, "ngwm:removeItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeItemResponse:
		return soap_out_PointerTo_ngwm__removeItemResponse(soap, tag, id, (_ngwm__removeItemResponse *const*)ptr, "ngwm:removeItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeItemRequest:
		return soap_out_PointerTo_ngwm__removeItemRequest(soap, tag, id, (_ngwm__removeItemRequest *const*)ptr, "ngwm:removeItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionResponse:
		return soap_out_PointerTo_ngwm__removeCustomDefinitionResponse(soap, tag, id, (_ngwm__removeCustomDefinitionResponse *const*)ptr, "ngwm:removeCustomDefinitionResponse");
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionRequest:
		return soap_out_PointerTo_ngwm__removeCustomDefinitionRequest(soap, tag, id, (_ngwm__removeCustomDefinitionRequest *const*)ptr, "ngwm:removeCustomDefinitionRequest");
	case SOAP_TYPE_PointerTo_ngwm__readCursorResponse:
		return soap_out_PointerTo_ngwm__readCursorResponse(soap, tag, id, (_ngwm__readCursorResponse *const*)ptr, "ngwm:readCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__readCursorRequest:
		return soap_out_PointerTo_ngwm__readCursorRequest(soap, tag, id, (_ngwm__readCursorRequest *const*)ptr, "ngwm:readCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__purgeResponse:
		return soap_out_PointerTo_ngwm__purgeResponse(soap, tag, id, (_ngwm__purgeResponse *const*)ptr, "ngwm:purgeResponse");
	case SOAP_TYPE_PointerTo_ngwm__purgeRequest:
		return soap_out_PointerTo_ngwm__purgeRequest(soap, tag, id, (_ngwm__purgeRequest *const*)ptr, "ngwm:purgeRequest");
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsResponse:
		return soap_out_PointerTo_ngwm__purgeDeletedItemsResponse(soap, tag, id, (_ngwm__purgeDeletedItemsResponse *const*)ptr, "ngwm:purgeDeletedItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsRequest:
		return soap_out_PointerTo_ngwm__purgeDeletedItemsRequest(soap, tag, id, (_ngwm__purgeDeletedItemsRequest *const*)ptr, "ngwm:purgeDeletedItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__positionCursorResponse:
		return soap_out_PointerTo_ngwm__positionCursorResponse(soap, tag, id, (_ngwm__positionCursorResponse *const*)ptr, "ngwm:positionCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__positionCursorRequest:
		return soap_out_PointerTo_ngwm__positionCursorRequest(soap, tag, id, (_ngwm__positionCursorRequest *const*)ptr, "ngwm:positionCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__moveItemResponse:
		return soap_out_PointerTo_ngwm__moveItemResponse(soap, tag, id, (_ngwm__moveItemResponse *const*)ptr, "ngwm:moveItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__moveItemRequest:
		return soap_out_PointerTo_ngwm__moveItemRequest(soap, tag, id, (_ngwm__moveItemRequest *const*)ptr, "ngwm:moveItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesResponse:
		return soap_out_PointerTo_ngwm__modifySignaturesResponse(soap, tag, id, (_ngwm__modifySignaturesResponse *const*)ptr, "ngwm:modifySignaturesResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesRequest:
		return soap_out_PointerTo_ngwm__modifySignaturesRequest(soap, tag, id, (_ngwm__modifySignaturesRequest *const*)ptr, "ngwm:modifySignaturesRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsResponse:
		return soap_out_PointerTo_ngwm__modifySettingsResponse(soap, tag, id, (_ngwm__modifySettingsResponse *const*)ptr, "ngwm:modifySettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsRequest:
		return soap_out_PointerTo_ngwm__modifySettingsRequest(soap, tag, id, (_ngwm__modifySettingsRequest *const*)ptr, "ngwm:modifySettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessResponse:
		return soap_out_PointerTo_ngwm__modifyProxyAccessResponse(soap, tag, id, (_ngwm__modifyProxyAccessResponse *const*)ptr, "ngwm:modifyProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessRequest:
		return soap_out_PointerTo_ngwm__modifyProxyAccessRequest(soap, tag, id, (_ngwm__modifyProxyAccessRequest *const*)ptr, "ngwm:modifyProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordResponse:
		return soap_out_PointerTo_ngwm__modifyPasswordResponse(soap, tag, id, (_ngwm__modifyPasswordResponse *const*)ptr, "ngwm:modifyPasswordResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordRequest:
		return soap_out_PointerTo_ngwm__modifyPasswordRequest(soap, tag, id, (_ngwm__modifyPasswordRequest *const*)ptr, "ngwm:modifyPasswordRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsResponse:
		return soap_out_PointerTo_ngwm__modifyJunkMailSettingsResponse(soap, tag, id, (_ngwm__modifyJunkMailSettingsResponse *const*)ptr, "ngwm:modifyJunkMailSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsRequest:
		return soap_out_PointerTo_ngwm__modifyJunkMailSettingsRequest(soap, tag, id, (_ngwm__modifyJunkMailSettingsRequest *const*)ptr, "ngwm:modifyJunkMailSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryResponse:
		return soap_out_PointerTo_ngwm__modifyJunkEntryResponse(soap, tag, id, (_ngwm__modifyJunkEntryResponse *const*)ptr, "ngwm:modifyJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryRequest:
		return soap_out_PointerTo_ngwm__modifyJunkEntryRequest(soap, tag, id, (_ngwm__modifyJunkEntryRequest *const*)ptr, "ngwm:modifyJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__modifyItemResponse:
		return soap_out_PointerTo_ngwm__modifyItemResponse(soap, tag, id, (_ngwm__modifyItemResponse *const*)ptr, "ngwm:modifyItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__modifyItemRequest:
		return soap_out_PointerTo_ngwm__modifyItemRequest(soap, tag, id, (_ngwm__modifyItemRequest *const*)ptr, "ngwm:modifyItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__markUnReadResponse:
		return soap_out_PointerTo_ngwm__markUnReadResponse(soap, tag, id, (_ngwm__markUnReadResponse *const*)ptr, "ngwm:markUnReadResponse");
	case SOAP_TYPE_PointerTo_ngwm__markUnReadRequest:
		return soap_out_PointerTo_ngwm__markUnReadRequest(soap, tag, id, (_ngwm__markUnReadRequest *const*)ptr, "ngwm:markUnReadRequest");
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateResponse:
		return soap_out_PointerTo_ngwm__markUnPrivateResponse(soap, tag, id, (_ngwm__markUnPrivateResponse *const*)ptr, "ngwm:markUnPrivateResponse");
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateRequest:
		return soap_out_PointerTo_ngwm__markUnPrivateRequest(soap, tag, id, (_ngwm__markUnPrivateRequest *const*)ptr, "ngwm:markUnPrivateRequest");
	case SOAP_TYPE_PointerTo_ngwm__markReadResponse:
		return soap_out_PointerTo_ngwm__markReadResponse(soap, tag, id, (_ngwm__markReadResponse *const*)ptr, "ngwm:markReadResponse");
	case SOAP_TYPE_PointerTo_ngwm__markReadRequest:
		return soap_out_PointerTo_ngwm__markReadRequest(soap, tag, id, (_ngwm__markReadRequest *const*)ptr, "ngwm:markReadRequest");
	case SOAP_TYPE_PointerTo_ngwm__markPrivateResponse:
		return soap_out_PointerTo_ngwm__markPrivateResponse(soap, tag, id, (_ngwm__markPrivateResponse *const*)ptr, "ngwm:markPrivateResponse");
	case SOAP_TYPE_PointerTo_ngwm__markPrivateRequest:
		return soap_out_PointerTo_ngwm__markPrivateRequest(soap, tag, id, (_ngwm__markPrivateRequest *const*)ptr, "ngwm:markPrivateRequest");
	case SOAP_TYPE_PointerTo_ngwm__logoutResponse:
		return soap_out_PointerTo_ngwm__logoutResponse(soap, tag, id, (_ngwm__logoutResponse *const*)ptr, "ngwm:logoutResponse");
	case SOAP_TYPE_PointerTo_ngwm__logoutRequest:
		return soap_out_PointerTo_ngwm__logoutRequest(soap, tag, id, (_ngwm__logoutRequest *const*)ptr, "ngwm:logoutRequest");
	case SOAP_TYPE_PointerTo_ngwm__loginResponse:
		return soap_out_PointerTo_ngwm__loginResponse(soap, tag, id, (_ngwm__loginResponse *const*)ptr, "ngwm:loginResponse");
	case SOAP_TYPE_PointerTo_ngwm__loginRequest:
		return soap_out_PointerTo_ngwm__loginRequest(soap, tag, id, (_ngwm__loginRequest *const*)ptr, "ngwm:loginRequest");
	case SOAP_TYPE_PointerTo_ngwm__getUserListResponse:
		return soap_out_PointerTo_ngwm__getUserListResponse(soap, tag, id, (_ngwm__getUserListResponse *const*)ptr, "ngwm:getUserListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getUserListRequest:
		return soap_out_PointerTo_ngwm__getUserListRequest(soap, tag, id, (_ngwm__getUserListRequest *const*)ptr, "ngwm:getUserListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListResponse:
		return soap_out_PointerTo_ngwm__getTimezoneListResponse(soap, tag, id, (_ngwm__getTimezoneListResponse *const*)ptr, "ngwm:getTimezoneListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListRequest:
		return soap_out_PointerTo_ngwm__getTimezoneListRequest(soap, tag, id, (_ngwm__getTimezoneListRequest *const*)ptr, "ngwm:getTimezoneListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getTimestampResponse:
		return soap_out_PointerTo_ngwm__getTimestampResponse(soap, tag, id, (_ngwm__getTimestampResponse *const*)ptr, "ngwm:getTimestampResponse");
	case SOAP_TYPE_PointerTo_ngwm__getTimestampRequest:
		return soap_out_PointerTo_ngwm__getTimestampRequest(soap, tag, id, (_ngwm__getTimestampRequest *const*)ptr, "ngwm:getTimestampRequest");
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesResponse:
		return soap_out_PointerTo_ngwm__getSignaturesResponse(soap, tag, id, (_ngwm__getSignaturesResponse *const*)ptr, "ngwm:getSignaturesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesRequest:
		return soap_out_PointerTo_ngwm__getSignaturesRequest(soap, tag, id, (_ngwm__getSignaturesRequest *const*)ptr, "ngwm:getSignaturesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getSettingsResponse:
		return soap_out_PointerTo_ngwm__getSettingsResponse(soap, tag, id, (_ngwm__getSettingsResponse *const*)ptr, "ngwm:getSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getSettingsRequest:
		return soap_out_PointerTo_ngwm__getSettingsRequest(soap, tag, id, (_ngwm__getSettingsRequest *const*)ptr, "ngwm:getSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getRuleListResponse:
		return soap_out_PointerTo_ngwm__getRuleListResponse(soap, tag, id, (_ngwm__getRuleListResponse *const*)ptr, "ngwm:getRuleListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getRuleListRequest:
		return soap_out_PointerTo_ngwm__getRuleListRequest(soap, tag, id, (_ngwm__getRuleListRequest *const*)ptr, "ngwm:getRuleListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getProxyListResponse:
		return soap_out_PointerTo_ngwm__getProxyListResponse(soap, tag, id, (_ngwm__getProxyListResponse *const*)ptr, "ngwm:getProxyListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getProxyListRequest:
		return soap_out_PointerTo_ngwm__getProxyListRequest(soap, tag, id, (_ngwm__getProxyListRequest *const*)ptr, "ngwm:getProxyListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListResponse:
		return soap_out_PointerTo_ngwm__getProxyAccessListResponse(soap, tag, id, (_ngwm__getProxyAccessListResponse *const*)ptr, "ngwm:getProxyAccessListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListRequest:
		return soap_out_PointerTo_ngwm__getProxyAccessListRequest(soap, tag, id, (_ngwm__getProxyAccessListRequest *const*)ptr, "ngwm:getProxyAccessListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesResponse:
		return soap_out_PointerTo_ngwm__getQuickMessagesResponse(soap, tag, id, (_ngwm__getQuickMessagesResponse *const*)ptr, "ngwm:getQuickMessagesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesRequest:
		return soap_out_PointerTo_ngwm__getQuickMessagesRequest(soap, tag, id, (_ngwm__getQuickMessagesRequest *const*)ptr, "ngwm:getQuickMessagesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListResponse:
		return soap_out_PointerTo_ngwm__getLibraryListResponse(soap, tag, id, (_ngwm__getLibraryListResponse *const*)ptr, "ngwm:getLibraryListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListRequest:
		return soap_out_PointerTo_ngwm__getLibraryListRequest(soap, tag, id, (_ngwm__getLibraryListRequest *const*)ptr, "ngwm:getLibraryListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemResponse:
		return soap_out_PointerTo_ngwm__getLibraryItemResponse(soap, tag, id, (_ngwm__getLibraryItemResponse *const*)ptr, "ngwm:getLibraryItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemRequest:
		return soap_out_PointerTo_ngwm__getLibraryItemRequest(soap, tag, id, (_ngwm__getLibraryItemRequest *const*)ptr, "ngwm:getLibraryItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsResponse:
		return soap_out_PointerTo_ngwm__getJunkMailSettingsResponse(soap, tag, id, (_ngwm__getJunkMailSettingsResponse *const*)ptr, "ngwm:getJunkMailSettingsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsRequest:
		return soap_out_PointerTo_ngwm__getJunkMailSettingsRequest(soap, tag, id, (_ngwm__getJunkMailSettingsRequest *const*)ptr, "ngwm:getJunkMailSettingsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesResponse:
		return soap_out_PointerTo_ngwm__getJunkEntriesResponse(soap, tag, id, (_ngwm__getJunkEntriesResponse *const*)ptr, "ngwm:getJunkEntriesResponse");
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesRequest:
		return soap_out_PointerTo_ngwm__getJunkEntriesRequest(soap, tag, id, (_ngwm__getJunkEntriesRequest *const*)ptr, "ngwm:getJunkEntriesRequest");
	case SOAP_TYPE_PointerTo_ngwm__getItemsResponse:
		return soap_out_PointerTo_ngwm__getItemsResponse(soap, tag, id, (_ngwm__getItemsResponse *const*)ptr, "ngwm:getItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__getItemsRequest:
		return soap_out_PointerTo_ngwm__getItemsRequest(soap, tag, id, (_ngwm__getItemsRequest *const*)ptr, "ngwm:getItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__getItemResponse:
		return soap_out_PointerTo_ngwm__getItemResponse(soap, tag, id, (_ngwm__getItemResponse *const*)ptr, "ngwm:getItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__getItemRequest:
		return soap_out_PointerTo_ngwm__getItemRequest(soap, tag, id, (_ngwm__getItemRequest *const*)ptr, "ngwm:getItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyResponse:
		return soap_out_PointerTo_ngwm__getFreeBusyResponse(soap, tag, id, (_ngwm__getFreeBusyResponse *const*)ptr, "ngwm:getFreeBusyResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyRequest:
		return soap_out_PointerTo_ngwm__getFreeBusyRequest(soap, tag, id, (_ngwm__getFreeBusyRequest *const*)ptr, "ngwm:getFreeBusyRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFolderListResponse:
		return soap_out_PointerTo_ngwm__getFolderListResponse(soap, tag, id, (_ngwm__getFolderListResponse *const*)ptr, "ngwm:getFolderListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFolderListRequest:
		return soap_out_PointerTo_ngwm__getFolderListRequest(soap, tag, id, (_ngwm__getFolderListRequest *const*)ptr, "ngwm:getFolderListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getFolderResponse:
		return soap_out_PointerTo_ngwm__getFolderResponse(soap, tag, id, (_ngwm__getFolderResponse *const*)ptr, "ngwm:getFolderResponse");
	case SOAP_TYPE_PointerTo_ngwm__getFolderRequest:
		return soap_out_PointerTo_ngwm__getFolderRequest(soap, tag, id, (_ngwm__getFolderRequest *const*)ptr, "ngwm:getFolderRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListResponse:
		return soap_out_PointerTo_ngwm__getDocumentTypeListResponse(soap, tag, id, (_ngwm__getDocumentTypeListResponse *const*)ptr, "ngwm:getDocumentTypeListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListRequest:
		return soap_out_PointerTo_ngwm__getDocumentTypeListRequest(soap, tag, id, (_ngwm__getDocumentTypeListRequest *const*)ptr, "ngwm:getDocumentTypeListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoResponse:
		return soap_out_PointerTo_ngwm__getDeltaInfoResponse(soap, tag, id, (_ngwm__getDeltaInfoResponse *const*)ptr, "ngwm:getDeltaInfoResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoRequest:
		return soap_out_PointerTo_ngwm__getDeltaInfoRequest(soap, tag, id, (_ngwm__getDeltaInfoRequest *const*)ptr, "ngwm:getDeltaInfoRequest");
	case SOAP_TYPE_PointerTo_ngwm__getDeltasResponse:
		return soap_out_PointerTo_ngwm__getDeltasResponse(soap, tag, id, (_ngwm__getDeltasResponse *const*)ptr, "ngwm:getDeltasResponse");
	case SOAP_TYPE_PointerTo_ngwm__getDeltasRequest:
		return soap_out_PointerTo_ngwm__getDeltasRequest(soap, tag, id, (_ngwm__getDeltasRequest *const*)ptr, "ngwm:getDeltasRequest");
	case SOAP_TYPE_PointerTo_ngwm__getCustomListResponse:
		return soap_out_PointerTo_ngwm__getCustomListResponse(soap, tag, id, (_ngwm__getCustomListResponse *const*)ptr, "ngwm:getCustomListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getCustomListRequest:
		return soap_out_PointerTo_ngwm__getCustomListRequest(soap, tag, id, (_ngwm__getCustomListRequest *const*)ptr, "ngwm:getCustomListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListResponse:
		return soap_out_PointerTo_ngwm__getCategoryListResponse(soap, tag, id, (_ngwm__getCategoryListResponse *const*)ptr, "ngwm:getCategoryListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListRequest:
		return soap_out_PointerTo_ngwm__getCategoryListRequest(soap, tag, id, (_ngwm__getCategoryListRequest *const*)ptr, "ngwm:getCategoryListRequest");
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentResponse:
		return soap_out_PointerTo_ngwm__getAttachmentResponse(soap, tag, id, (_ngwm__getAttachmentResponse *const*)ptr, "ngwm:getAttachmentResponse");
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentRequest:
		return soap_out_PointerTo_ngwm__getAttachmentRequest(soap, tag, id, (_ngwm__getAttachmentRequest *const*)ptr, "ngwm:getAttachmentRequest");
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListResponse:
		return soap_out_PointerTo_ngwm__getAddressBookListResponse(soap, tag, id, (_ngwm__getAddressBookListResponse *const*)ptr, "ngwm:getAddressBookListResponse");
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListRequest:
		return soap_out_PointerTo_ngwm__getAddressBookListRequest(soap, tag, id, (_ngwm__getAddressBookListRequest *const*)ptr, "ngwm:getAddressBookListRequest");
	case SOAP_TYPE_PointerTo_ngwm__forwardResponse:
		return soap_out_PointerTo_ngwm__forwardResponse(soap, tag, id, (_ngwm__forwardResponse *const*)ptr, "ngwm:forwardResponse");
	case SOAP_TYPE_PointerTo_ngwm__forwardRequest:
		return soap_out_PointerTo_ngwm__forwardRequest(soap, tag, id, (_ngwm__forwardRequest *const*)ptr, "ngwm:forwardRequest");
	case SOAP_TYPE_PointerTo_ngwm__executeRuleResponse:
		return soap_out_PointerTo_ngwm__executeRuleResponse(soap, tag, id, (_ngwm__executeRuleResponse *const*)ptr, "ngwm:executeRuleResponse");
	case SOAP_TYPE_PointerTo_ngwm__executeRuleRequest:
		return soap_out_PointerTo_ngwm__executeRuleRequest(soap, tag, id, (_ngwm__executeRuleRequest *const*)ptr, "ngwm:executeRuleRequest");
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorResponse:
		return soap_out_PointerTo_ngwm__destroyCursorResponse(soap, tag, id, (_ngwm__destroyCursorResponse *const*)ptr, "ngwm:destroyCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorRequest:
		return soap_out_PointerTo_ngwm__destroyCursorRequest(soap, tag, id, (_ngwm__destroyCursorRequest *const*)ptr, "ngwm:destroyCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__delegateResponse:
		return soap_out_PointerTo_ngwm__delegateResponse(soap, tag, id, (_ngwm__delegateResponse *const*)ptr, "ngwm:delegateResponse");
	case SOAP_TYPE_PointerTo_ngwm__delegateRequest:
		return soap_out_PointerTo_ngwm__delegateRequest(soap, tag, id, (_ngwm__delegateRequest *const*)ptr, "ngwm:delegateRequest");
	case SOAP_TYPE_PointerTo_ngwm__declineResponse:
		return soap_out_PointerTo_ngwm__declineResponse(soap, tag, id, (_ngwm__declineResponse *const*)ptr, "ngwm:declineResponse");
	case SOAP_TYPE_PointerTo_ngwm__declineRequest:
		return soap_out_PointerTo_ngwm__declineRequest(soap, tag, id, (_ngwm__declineRequest *const*)ptr, "ngwm:declineRequest");
	case SOAP_TYPE_PointerTo_ngwm__createSignatureResponse:
		return soap_out_PointerTo_ngwm__createSignatureResponse(soap, tag, id, (_ngwm__createSignatureResponse *const*)ptr, "ngwm:createSignatureResponse");
	case SOAP_TYPE_PointerTo_ngwm__createSignatureRequest:
		return soap_out_PointerTo_ngwm__createSignatureRequest(soap, tag, id, (_ngwm__createSignatureRequest *const*)ptr, "ngwm:createSignatureRequest");
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessResponse:
		return soap_out_PointerTo_ngwm__createProxyAccessResponse(soap, tag, id, (_ngwm__createProxyAccessResponse *const*)ptr, "ngwm:createProxyAccessResponse");
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessRequest:
		return soap_out_PointerTo_ngwm__createProxyAccessRequest(soap, tag, id, (_ngwm__createProxyAccessRequest *const*)ptr, "ngwm:createProxyAccessRequest");
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryResponse:
		return soap_out_PointerTo_ngwm__createJunkEntryResponse(soap, tag, id, (_ngwm__createJunkEntryResponse *const*)ptr, "ngwm:createJunkEntryResponse");
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryRequest:
		return soap_out_PointerTo_ngwm__createJunkEntryRequest(soap, tag, id, (_ngwm__createJunkEntryRequest *const*)ptr, "ngwm:createJunkEntryRequest");
	case SOAP_TYPE_PointerTo_ngwm__createItemsResponse:
		return soap_out_PointerTo_ngwm__createItemsResponse(soap, tag, id, (_ngwm__createItemsResponse *const*)ptr, "ngwm:createItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__createItemsRequest:
		return soap_out_PointerTo_ngwm__createItemsRequest(soap, tag, id, (_ngwm__createItemsRequest *const*)ptr, "ngwm:createItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__createItemResponse:
		return soap_out_PointerTo_ngwm__createItemResponse(soap, tag, id, (_ngwm__createItemResponse *const*)ptr, "ngwm:createItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__createItemRequest:
		return soap_out_PointerTo_ngwm__createItemRequest(soap, tag, id, (_ngwm__createItemRequest *const*)ptr, "ngwm:createItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__createCursorResponse:
		return soap_out_PointerTo_ngwm__createCursorResponse(soap, tag, id, (_ngwm__createCursorResponse *const*)ptr, "ngwm:createCursorResponse");
	case SOAP_TYPE_PointerTo_ngwm__createCursorRequest:
		return soap_out_PointerTo_ngwm__createCursorRequest(soap, tag, id, (_ngwm__createCursorRequest *const*)ptr, "ngwm:createCursorRequest");
	case SOAP_TYPE_PointerTo_ngwm__completeResponse:
		return soap_out_PointerTo_ngwm__completeResponse(soap, tag, id, (_ngwm__completeResponse *const*)ptr, "ngwm:completeResponse");
	case SOAP_TYPE_PointerTo_ngwm__completeRequest:
		return soap_out_PointerTo_ngwm__completeRequest(soap, tag, id, (_ngwm__completeRequest *const*)ptr, "ngwm:completeRequest");
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionResponse:
		return soap_out_PointerTo_ngwm__closeFreeBusySessionResponse(soap, tag, id, (_ngwm__closeFreeBusySessionResponse *const*)ptr, "ngwm:closeFreeBusySessionResponse");
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionRequest:
		return soap_out_PointerTo_ngwm__closeFreeBusySessionRequest(soap, tag, id, (_ngwm__closeFreeBusySessionRequest *const*)ptr, "ngwm:closeFreeBusySessionRequest");
	case SOAP_TYPE_PointerTo_ngwm__addMembersResponse:
		return soap_out_PointerTo_ngwm__addMembersResponse(soap, tag, id, (_ngwm__addMembersResponse *const*)ptr, "ngwm:addMembersResponse");
	case SOAP_TYPE_PointerTo_ngwm__addMembersRequest:
		return soap_out_PointerTo_ngwm__addMembersRequest(soap, tag, id, (_ngwm__addMembersRequest *const*)ptr, "ngwm:addMembersRequest");
	case SOAP_TYPE_PointerTo_ngwm__addItemsResponse:
		return soap_out_PointerTo_ngwm__addItemsResponse(soap, tag, id, (_ngwm__addItemsResponse *const*)ptr, "ngwm:addItemsResponse");
	case SOAP_TYPE_PointerTo_ngwm__addItemsRequest:
		return soap_out_PointerTo_ngwm__addItemsRequest(soap, tag, id, (_ngwm__addItemsRequest *const*)ptr, "ngwm:addItemsRequest");
	case SOAP_TYPE_PointerTo_ngwm__addItemResponse:
		return soap_out_PointerTo_ngwm__addItemResponse(soap, tag, id, (_ngwm__addItemResponse *const*)ptr, "ngwm:addItemResponse");
	case SOAP_TYPE_PointerTo_ngwm__addItemRequest:
		return soap_out_PointerTo_ngwm__addItemRequest(soap, tag, id, (_ngwm__addItemRequest *const*)ptr, "ngwm:addItemRequest");
	case SOAP_TYPE_PointerTo_ngwm__acceptShareResponse:
		return soap_out_PointerTo_ngwm__acceptShareResponse(soap, tag, id, (_ngwm__acceptShareResponse *const*)ptr, "ngwm:acceptShareResponse");
	case SOAP_TYPE_PointerTo_ngwm__acceptShareRequest:
		return soap_out_PointerTo_ngwm__acceptShareRequest(soap, tag, id, (_ngwm__acceptShareRequest *const*)ptr, "ngwm:acceptShareRequest");
	case SOAP_TYPE_PointerTo_ngwm__acceptResponse:
		return soap_out_PointerTo_ngwm__acceptResponse(soap, tag, id, (_ngwm__acceptResponse *const*)ptr, "ngwm:acceptResponse");
	case SOAP_TYPE_PointerTo_ngwm__acceptRequest:
		return soap_out_PointerTo_ngwm__acceptRequest(soap, tag, id, (_ngwm__acceptRequest *const*)ptr, "ngwm:acceptRequest");
	case SOAP_TYPE_PointerTongwt__Alarm:
		return soap_out_PointerTongwt__Alarm(soap, tag, id, (ngwt__Alarm *const*)ptr, "ngwt:Alarm");
	case SOAP_TYPE_PointerTongwt__PhoneFlags:
		return soap_out_PointerTongwt__PhoneFlags(soap, tag, id, (ngwt__PhoneFlags *const*)ptr, "ngwt:PhoneFlags");
	case SOAP_TYPE_PointerTongwt__RecurrenceRule:
		return soap_out_PointerTongwt__RecurrenceRule(soap, tag, id, (ngwt__RecurrenceRule *const*)ptr, "ngwt:RecurrenceRule");
	case SOAP_TYPE_PointerTongwt__RecurrenceDateType:
		return soap_out_PointerTongwt__RecurrenceDateType(soap, tag, id, (ngwt__RecurrenceDateType *const*)ptr, "ngwt:RecurrenceDateType");
	case SOAP_TYPE_PointerTongwt__SMimeOperation:
		return soap_out_PointerTongwt__SMimeOperation(soap, tag, id, (ngwt__SMimeOperation *const*)ptr, "ngwt:SMimeOperation");
	case SOAP_TYPE_PointerTongwt__LinkInfo:
		return soap_out_PointerTongwt__LinkInfo(soap, tag, id, (ngwt__LinkInfo *const*)ptr, "ngwt:LinkInfo");
	case SOAP_TYPE_PointerTongwt__ItemOptions:
		return soap_out_PointerTongwt__ItemOptions(soap, tag, id, (ngwt__ItemOptions *const*)ptr, "ngwt:ItemOptions");
	case SOAP_TYPE_PointerTongwt__AttachmentInfo:
		return soap_out_PointerTongwt__AttachmentInfo(soap, tag, id, (ngwt__AttachmentInfo *const*)ptr, "ngwt:AttachmentInfo");
	case SOAP_TYPE_PointerTongwt__MessageBody:
		return soap_out_PointerTongwt__MessageBody(soap, tag, id, (ngwt__MessageBody *const*)ptr, "ngwt:MessageBody");
	case SOAP_TYPE_PointerTongwt__ReferenceInfo:
		return soap_out_PointerTongwt__ReferenceInfo(soap, tag, id, (ngwt__ReferenceInfo *const*)ptr, "ngwt:ReferenceInfo");
	case SOAP_TYPE_PointerTongwt__PersonalInfo:
		return soap_out_PointerTongwt__PersonalInfo(soap, tag, id, (ngwt__PersonalInfo *const*)ptr, "ngwt:PersonalInfo");
	case SOAP_TYPE_PointerTongwt__OfficeInfo:
		return soap_out_PointerTongwt__OfficeInfo(soap, tag, id, (ngwt__OfficeInfo *const*)ptr, "ngwt:OfficeInfo");
	case SOAP_TYPE_PointerTongwt__PostalAddressList:
		return soap_out_PointerTongwt__PostalAddressList(soap, tag, id, (ngwt__PostalAddressList *const*)ptr, "ngwt:PostalAddressList");
	case SOAP_TYPE_PointerTongwt__PhoneList:
		return soap_out_PointerTongwt__PhoneList(soap, tag, id, (ngwt__PhoneList *const*)ptr, "ngwt:PhoneList");
	case SOAP_TYPE_PointerTongwt__ImAddressList:
		return soap_out_PointerTongwt__ImAddressList(soap, tag, id, (ngwt__ImAddressList *const*)ptr, "ngwt:ImAddressList");
	case SOAP_TYPE_PointerTongwt__EmailAddressList:
		return soap_out_PointerTongwt__EmailAddressList(soap, tag, id, (ngwt__EmailAddressList *const*)ptr, "ngwt:EmailAddressList");
	case SOAP_TYPE_PointerTongwt__FullName:
		return soap_out_PointerTongwt__FullName(soap, tag, id, (ngwt__FullName *const*)ptr, "ngwt:FullName");
	case SOAP_TYPE_PointerTongwt__VersionStatus:
		return soap_out_PointerTongwt__VersionStatus(soap, tag, id, (enum ngwt__VersionStatus *const*)ptr, "ngwt:VersionStatus");
	case SOAP_TYPE_PointerTongwt__FolderACL:
		return soap_out_PointerTongwt__FolderACL(soap, tag, id, (ngwt__FolderACL *const*)ptr, "ngwt:FolderACL");
	case SOAP_TYPE_PointerTongwt__RuleActionList:
		return soap_out_PointerTongwt__RuleActionList(soap, tag, id, (ngwt__RuleActionList *const*)ptr, "ngwt:RuleActionList");
	case SOAP_TYPE_PointerTongwt__Execution:
		return soap_out_PointerTongwt__Execution(soap, tag, id, (enum ngwt__Execution *const*)ptr, "ngwt:Execution");
	case SOAP_TYPE_PointerTongwt__Query:
		return soap_out_PointerTongwt__Query(soap, tag, id, (ngwt__Query *const*)ptr, "ngwt:Query");
	case SOAP_TYPE_PointerTongwt__FolderACLStatus:
		return soap_out_PointerTongwt__FolderACLStatus(soap, tag, id, (enum ngwt__FolderACLStatus *const*)ptr, "ngwt:FolderACLStatus");
	case SOAP_TYPE_PointerTongwt__AccessControlList:
		return soap_out_PointerTongwt__AccessControlList(soap, tag, id, (ngwt__AccessControlList *const*)ptr, "ngwt:AccessControlList");
	case SOAP_TYPE_PointerTongwt__WeekOfYear:
		return soap_out_PointerTongwt__WeekOfYear(soap, tag, id, (short *const*)ptr, "ngwt:WeekOfYear");
	case SOAP_TYPE_PointerTongwt__OccurrenceType:
		return soap_out_PointerTongwt__OccurrenceType(soap, tag, id, (enum ngwt__OccurrenceType *const*)ptr, "ngwt:OccurrenceType");
	case SOAP_TYPE_PointerTongwt__ItemSecurity:
		return soap_out_PointerTongwt__ItemSecurity(soap, tag, id, (enum ngwt__ItemSecurity *const*)ptr, "ngwt:ItemSecurity");
	case SOAP_TYPE_PointerTongwt__ItemClass:
		return soap_out_PointerTongwt__ItemClass(soap, tag, id, (enum ngwt__ItemClass *const*)ptr, "ngwt:ItemClass");
	case SOAP_TYPE_PointerTongwt__ItemSource:
		return soap_out_PointerTongwt__ItemSource(soap, tag, id, (enum ngwt__ItemSource *const*)ptr, "ngwt:ItemSource");
	case SOAP_TYPE_PointerTongwt__ItemStatus:
		return soap_out_PointerTongwt__ItemStatus(soap, tag, id, (ngwt__ItemStatus *const*)ptr, "ngwt:ItemStatus");
	case SOAP_TYPE_PointerTongwt__DeltaSyncType:
		return soap_out_PointerTongwt__DeltaSyncType(soap, tag, id, (enum ngwt__DeltaSyncType *const*)ptr, "ngwt:DeltaSyncType");
	case SOAP_TYPE_PointerTongwt__RecipientStatus:
		return soap_out_PointerTongwt__RecipientStatus(soap, tag, id, (ngwt__RecipientStatus *const*)ptr, "ngwt:RecipientStatus");
	case SOAP_TYPE_PointerTongwt__FreeBusyBlockList:
		return soap_out_PointerTongwt__FreeBusyBlockList(soap, tag, id, (ngwt__FreeBusyBlockList *const*)ptr, "ngwt:FreeBusyBlockList");
	case SOAP_TYPE_PointerTongwt__CalendarFolderAttribute:
		return soap_out_PointerTongwt__CalendarFolderAttribute(soap, tag, id, (ngwt__CalendarFolderAttribute *const*)ptr, "ngwt:CalendarFolderAttribute");
	case SOAP_TYPE_PointerTongwt__FilterDate:
		return soap_out_PointerTongwt__FilterDate(soap, tag, id, (enum ngwt__FilterDate *const*)ptr, "ngwt:FilterDate");
	case SOAP_TYPE_PointerTongwt__ContainerRef:
		return soap_out_PointerTongwt__ContainerRef(soap, tag, id, (ngwt__ContainerRef *const*)ptr, "ngwt:ContainerRef");
	case SOAP_TYPE_PointerTongwt__CategoryType:
		return soap_out_PointerTongwt__CategoryType(soap, tag, id, (enum ngwt__CategoryType *const*)ptr, "ngwt:CategoryType");
	case SOAP_TYPE_PointerTongwt__AccessMiscRight:
		return soap_out_PointerTongwt__AccessMiscRight(soap, tag, id, (ngwt__AccessMiscRight *const*)ptr, "ngwt:AccessMiscRight");
	case SOAP_TYPE_PointerTongwt__AccessRight:
		return soap_out_PointerTongwt__AccessRight(soap, tag, id, (ngwt__AccessRight *const*)ptr, "ngwt:AccessRight");
	case SOAP_TYPE_PointerTongwt__Rights:
		return soap_out_PointerTongwt__Rights(soap, tag, id, (ngwt__Rights *const*)ptr, "ngwt:Rights");
	case SOAP_TYPE_PointerTongwe__EventList:
		return soap_out_PointerTongwe__EventList(soap, tag, id, (ngwe__EventList *const*)ptr, "ngwe:EventList");
	case SOAP_TYPE_PointerTongwe__EventsList:
		return soap_out_PointerTongwe__EventsList(soap, tag, id, (ngwe__EventsList *const*)ptr, "ngwe:EventsList");
	case SOAP_TYPE_PointerTongwe__Events:
		return soap_out_PointerTongwe__Events(soap, tag, id, (ngwe__Events *const*)ptr, "ngwe:Events");
	case SOAP_TYPE_PointerTongwe__EventDefinition:
		return soap_out_PointerTongwe__EventDefinition(soap, tag, id, (ngwe__EventDefinition *const*)ptr, "ngwe:EventDefinition");
	case SOAP_TYPE_PointerToxsd__duration:
		return soap_out_PointerToxsd__duration(soap, tag, id, (std::string *const*)ptr, "xsd:duration");
	case SOAP_TYPE_PointerTongwe__Event:
		return soap_out_PointerTongwe__Event(soap, tag, id, (ngwe__Event *const*)ptr, "ngwe:Event");
	case SOAP_TYPE_PointerTongwe__ContainerList:
		return soap_out_PointerTongwe__ContainerList(soap, tag, id, (ngwe__ContainerList *const*)ptr, "ngwe:ContainerList");
	case SOAP_TYPE_PointerTongwe__ItemTypeList:
		return soap_out_PointerTongwe__ItemTypeList(soap, tag, id, (enum ngwe__ItemTypeList *const*)ptr, "ngwe:ItemTypeList");
	case SOAP_TYPE_PointerTongwe__EventTypeList:
		return soap_out_PointerTongwe__EventTypeList(soap, tag, id, (ngwe__EventTypeList *const*)ptr, "ngwe:EventTypeList");
	case SOAP_TYPE_PointerTongwe__ItemType:
		return soap_out_PointerTongwe__ItemType(soap, tag, id, (enum ngwe__ItemType *const*)ptr, "ngwe:ItemType");
	case SOAP_TYPE_PointerTongwe__FieldList:
		return soap_out_PointerTongwe__FieldList(soap, tag, id, (enum ngwe__FieldList *const*)ptr, "ngwe:FieldList");
	case SOAP_TYPE_PointerTongwt__FreeBusyUserList:
		return soap_out_PointerTongwt__FreeBusyUserList(soap, tag, id, (ngwt__FreeBusyUserList *const*)ptr, "ngwt:FreeBusyUserList");
	case SOAP_TYPE_PointerTongwt__RetractType:
		return soap_out_PointerTongwt__RetractType(soap, tag, id, (enum ngwt__RetractType *const*)ptr, "ngwt:RetractType");
	case SOAP_TYPE_PointerTongwt__ItemList:
		return soap_out_PointerTongwt__ItemList(soap, tag, id, (ngwt__ItemList *const*)ptr, "ngwt:ItemList");
	case SOAP_TYPE_PointerTongwt__CursorSeek:
		return soap_out_PointerTongwt__CursorSeek(soap, tag, id, (enum ngwt__CursorSeek *const*)ptr, "ngwt:CursorSeek");
	case SOAP_TYPE_PointerTongwt__AccessRightChanges:
		return soap_out_PointerTongwt__AccessRightChanges(soap, tag, id, (ngwt__AccessRightChanges *const*)ptr, "ngwt:AccessRightChanges");
	case SOAP_TYPE_PointerTongwt__ModifyItem:
		return soap_out_PointerTongwt__ModifyItem(soap, tag, id, (ngwt__ModifyItem *const*)ptr, "ngwt:ModifyItem");
	case SOAP_TYPE_PointerTongwt__Host:
		return soap_out_PointerTongwt__Host(soap, tag, id, (ngwt__Host *const*)ptr, "ngwt:Host");
	case SOAP_TYPE_PointerTongwt__Authentication:
		return soap_out_PointerTongwt__Authentication(soap, tag, id, (ngwt__Authentication *const*)ptr, "ngwt:Authentication");
	case SOAP_TYPE_PointerTongwt__UserList:
		return soap_out_PointerTongwt__UserList(soap, tag, id, (ngwt__UserList *const*)ptr, "ngwt:UserList");
	case SOAP_TYPE_PointerTongwt__TimezoneList:
		return soap_out_PointerTongwt__TimezoneList(soap, tag, id, (ngwt__TimezoneList *const*)ptr, "ngwt:TimezoneList");
	case SOAP_TYPE_PointerTongwt__Signatures:
		return soap_out_PointerTongwt__Signatures(soap, tag, id, (ngwt__Signatures *const*)ptr, "ngwt:Signatures");
	case SOAP_TYPE_PointerTongwt__Settings:
		return soap_out_PointerTongwt__Settings(soap, tag, id, (ngwt__Settings *const*)ptr, "ngwt:Settings");
	case SOAP_TYPE_PointerTongwt__RuleList:
		return soap_out_PointerTongwt__RuleList(soap, tag, id, (ngwt__RuleList *const*)ptr, "ngwt:RuleList");
	case SOAP_TYPE_PointerTongwt__ProxyList:
		return soap_out_PointerTongwt__ProxyList(soap, tag, id, (ngwt__ProxyList *const*)ptr, "ngwt:ProxyList");
	case SOAP_TYPE_PointerTongwt__AccessRightList:
		return soap_out_PointerTongwt__AccessRightList(soap, tag, id, (ngwt__AccessRightList *const*)ptr, "ngwt:AccessRightList");
	case SOAP_TYPE_PointerTongwt__LibraryList:
		return soap_out_PointerTongwt__LibraryList(soap, tag, id, (ngwt__LibraryList *const*)ptr, "ngwt:LibraryList");
	case SOAP_TYPE_PointerTongwt__SettingsList:
		return soap_out_PointerTongwt__SettingsList(soap, tag, id, (ngwt__SettingsList *const*)ptr, "ngwt:SettingsList");
	case SOAP_TYPE_PointerTongwt__JunkHandlingList:
		return soap_out_PointerTongwt__JunkHandlingList(soap, tag, id, (ngwt__JunkHandlingList *const*)ptr, "ngwt:JunkHandlingList");
	case SOAP_TYPE_PointerTongwt__FreeBusyInfoList:
		return soap_out_PointerTongwt__FreeBusyInfoList(soap, tag, id, (ngwt__FreeBusyInfoList *const*)ptr, "ngwt:FreeBusyInfoList");
	case SOAP_TYPE_PointerTongwt__FreeBusyStats:
		return soap_out_PointerTongwt__FreeBusyStats(soap, tag, id, (ngwt__FreeBusyStats *const*)ptr, "ngwt:FreeBusyStats");
	case SOAP_TYPE_PointerTongwt__FolderList:
		return soap_out_PointerTongwt__FolderList(soap, tag, id, (ngwt__FolderList *const*)ptr, "ngwt:FolderList");
	case SOAP_TYPE_PointerTongwt__ItemSourceList:
		return soap_out_PointerTongwt__ItemSourceList(soap, tag, id, (enum ngwt__ItemSourceList *const*)ptr, "ngwt:ItemSourceList");
	case SOAP_TYPE_PointerTongwt__MessageTypeList:
		return soap_out_PointerTongwt__MessageTypeList(soap, tag, id, (enum ngwt__MessageTypeList *const*)ptr, "ngwt:MessageTypeList");
	case SOAP_TYPE_PointerTongwt__FolderType:
		return soap_out_PointerTongwt__FolderType(soap, tag, id, (enum ngwt__FolderType *const*)ptr, "ngwt:FolderType");
	case SOAP_TYPE_PointerTongwt__DocumentTypeList:
		return soap_out_PointerTongwt__DocumentTypeList(soap, tag, id, (ngwt__DocumentTypeList *const*)ptr, "ngwt:DocumentTypeList");
	case SOAP_TYPE_PointerTongwt__Items:
		return soap_out_PointerTongwt__Items(soap, tag, id, (ngwt__Items *const*)ptr, "ngwt:Items");
	case SOAP_TYPE_PointerTongwt__DeltaInfo:
		return soap_out_PointerTongwt__DeltaInfo(soap, tag, id, (ngwt__DeltaInfo *const*)ptr, "ngwt:DeltaInfo");
	case SOAP_TYPE_PointerTongwt__CustomList:
		return soap_out_PointerTongwt__CustomList(soap, tag, id, (ngwt__CustomList *const*)ptr, "ngwt:CustomList");
	case SOAP_TYPE_PointerTongwt__CategoryList:
		return soap_out_PointerTongwt__CategoryList(soap, tag, id, (ngwt__CategoryList *const*)ptr, "ngwt:CategoryList");
	case SOAP_TYPE_PointerTongwt__AddressBookList:
		return soap_out_PointerTongwt__AddressBookList(soap, tag, id, (ngwt__AddressBookList *const*)ptr, "ngwt:AddressBookList");
	case SOAP_TYPE_PointerTongwt__Distribution:
		return soap_out_PointerTongwt__Distribution(soap, tag, id, (ngwt__Distribution *const*)ptr, "ngwt:Distribution");
	case SOAP_TYPE_PointerTongwt__View:
		return soap_out_PointerTongwt__View(soap, tag, id, (std::string *const*)ptr, "ngwt:View");
	case SOAP_TYPE_PointerTongwt__Status:
		return soap_out_PointerTongwt__Status(soap, tag, id, (ngwt__Status *const*)ptr, "ngwt:Status");
	case SOAP_TYPE_PointerTongwt__ItemRefList:
		return soap_out_PointerTongwt__ItemRefList(soap, tag, id, (ngwt__ItemRefList *const*)ptr, "ngwt:ItemRefList");
	case SOAP_TYPE_PointerTongwt__UserInfo:
		return soap_out_PointerTongwt__UserInfo(soap, tag, id, (ngwt__UserInfo *const*)ptr, "ngwt:UserInfo");
	case SOAP_TYPE_PointerTongwt__RecipientType:
		return soap_out_PointerTongwt__RecipientType(soap, tag, id, (enum ngwt__RecipientType *const*)ptr, "ngwt:RecipientType");
	case SOAP_TYPE_PointerTongwt__Timezone:
		return soap_out_PointerTongwt__Timezone(soap, tag, id, (ngwt__Timezone *const*)ptr, "ngwt:Timezone");
	case SOAP_TYPE_PointerTongwt__Minute:
		return soap_out_PointerTongwt__Minute(soap, tag, id, (unsigned char *const*)ptr, "ngwt:Minute");
	case SOAP_TYPE_PointerTongwt__Hour:
		return soap_out_PointerTongwt__Hour(soap, tag, id, (unsigned char *const*)ptr, "ngwt:Hour");
	case SOAP_TYPE_PointerTongwt__DayOfWeek:
		return soap_out_PointerTongwt__DayOfWeek(soap, tag, id, (ngwt__DayOfWeek *const*)ptr, "ngwt:DayOfWeek");
	case SOAP_TYPE_PointerTongwt__Day:
		return soap_out_PointerTongwt__Day(soap, tag, id, (unsigned char *const*)ptr, "ngwt:Day");
	case SOAP_TYPE_PointerTongwt__Month:
		return soap_out_PointerTongwt__Month(soap, tag, id, (unsigned char *const*)ptr, "ngwt:Month");
	case SOAP_TYPE_PointerTongwt__TimezoneComponent:
		return soap_out_PointerTongwt__TimezoneComponent(soap, tag, id, (ngwt__TimezoneComponent *const*)ptr, "ngwt:TimezoneComponent");
	case SOAP_TYPE_PointerTongwt__ProblemList:
		return soap_out_PointerTongwt__ProblemList(soap, tag, id, (ngwt__ProblemList *const*)ptr, "ngwt:ProblemList");
	case SOAP_TYPE_PointerTongwt__Signature:
		return soap_out_PointerTongwt__Signature(soap, tag, id, (ngwt__Signature *const*)ptr, "ngwt:Signature");
	case SOAP_TYPE_PointerTongwt__SignatureData:
		return soap_out_PointerTongwt__SignatureData(soap, tag, id, (ngwt__SignatureData *const*)ptr, "ngwt:SignatureData");
	case SOAP_TYPE_PointerTongwt__SettingsGroup:
		return soap_out_PointerTongwt__SettingsGroup(soap, tag, id, (ngwt__SettingsGroup *const*)ptr, "ngwt:SettingsGroup");
	case SOAP_TYPE_PointerTongwt__ReturnNotification:
		return soap_out_PointerTongwt__ReturnNotification(soap, tag, id, (ngwt__ReturnNotification *const*)ptr, "ngwt:ReturnNotification");
	case SOAP_TYPE_PointerTongwt__StatusTracking:
		return soap_out_PointerTongwt__StatusTracking(soap, tag, id, (ngwt__StatusTracking *const*)ptr, "ngwt:StatusTracking");
	case SOAP_TYPE_PointerTongwt__SendOptionsRequestReply:
		return soap_out_PointerTongwt__SendOptionsRequestReply(soap, tag, id, (ngwt__SendOptionsRequestReply *const*)ptr, "ngwt:SendOptionsRequestReply");
	case SOAP_TYPE_PointerTongwt__Rule:
		return soap_out_PointerTongwt__Rule(soap, tag, id, (ngwt__Rule *const*)ptr, "ngwt:Rule");
	case SOAP_TYPE_PointerTongwt__RuleAction:
		return soap_out_PointerTongwt__RuleAction(soap, tag, id, (ngwt__RuleAction *const*)ptr, "ngwt:RuleAction");
	case SOAP_TYPE_PointerTongwt__CategoryRefList:
		return soap_out_PointerTongwt__CategoryRefList(soap, tag, id, (ngwt__CategoryRefList *const*)ptr, "ngwt:CategoryRefList");
	case SOAP_TYPE_PointerTongwt__Mail:
		return soap_out_PointerTongwt__Mail(soap, tag, id, (ngwt__Mail *const*)ptr, "ngwt:Mail");
	case SOAP_TYPE_PointerTongwt__ReturnNotificationOptions:
		return soap_out_PointerTongwt__ReturnNotificationOptions(soap, tag, id, (ngwt__ReturnNotificationOptions *const*)ptr, "ngwt:ReturnNotificationOptions");
	case SOAP_TYPE_PointerTongwt__MonthList:
		return soap_out_PointerTongwt__MonthList(soap, tag, id, (ngwt__MonthList *const*)ptr, "ngwt:MonthList");
	case SOAP_TYPE_PointerTongwt__DayOfYearList:
		return soap_out_PointerTongwt__DayOfYearList(soap, tag, id, (ngwt__DayOfYearList *const*)ptr, "ngwt:DayOfYearList");
	case SOAP_TYPE_PointerTongwt__DayOfMonthList:
		return soap_out_PointerTongwt__DayOfMonthList(soap, tag, id, (ngwt__DayOfMonthList *const*)ptr, "ngwt:DayOfMonthList");
	case SOAP_TYPE_PointerTongwt__DayOfYearWeekList:
		return soap_out_PointerTongwt__DayOfYearWeekList(soap, tag, id, (ngwt__DayOfYearWeekList *const*)ptr, "ngwt:DayOfYearWeekList");
	case SOAP_TYPE_PointerTongwt__Frequency:
		return soap_out_PointerTongwt__Frequency(soap, tag, id, (enum ngwt__Frequency *const*)ptr, "ngwt:Frequency");
	case SOAP_TYPE_PointerTongwt__DelegateeStatus:
		return soap_out_PointerTongwt__DelegateeStatus(soap, tag, id, (ngwt__DelegateeStatus *const*)ptr, "ngwt:DelegateeStatus");
	case SOAP_TYPE_PointerTongwt__DelegatedStatus:
		return soap_out_PointerTongwt__DelegatedStatus(soap, tag, id, (ngwt__DelegatedStatus *const*)ptr, "ngwt:DelegatedStatus");
	case SOAP_TYPE_PointerTongwt__CommentStatus:
		return soap_out_PointerTongwt__CommentStatus(soap, tag, id, (ngwt__CommentStatus *const*)ptr, "ngwt:CommentStatus");
	case SOAP_TYPE_PointerTongwt__TransferFailedStatus:
		return soap_out_PointerTongwt__TransferFailedStatus(soap, tag, id, (ngwt__TransferFailedStatus *const*)ptr, "ngwt:TransferFailedStatus");
	case SOAP_TYPE_PointerTongwt__Recipient:
		return soap_out_PointerTongwt__Recipient(soap, tag, id, (ngwt__Recipient *const*)ptr, "ngwt:Recipient");
	case SOAP_TYPE_PointerTongwt__Filter:
		return soap_out_PointerTongwt__Filter(soap, tag, id, (ngwt__Filter *const*)ptr, "ngwt:Filter");
	case SOAP_TYPE_PointerTongwt__QueryTarget:
		return soap_out_PointerTongwt__QueryTarget(soap, tag, id, (ngwt__QueryTarget *const*)ptr, "ngwt:QueryTarget");
	case SOAP_TYPE_PointerTongwt__ProxyUser:
		return soap_out_PointerTongwt__ProxyUser(soap, tag, id, (ngwt__ProxyUser *const*)ptr, "ngwt:ProxyUser");
	case SOAP_TYPE_PointerTongwt__ProblemEntry:
		return soap_out_PointerTongwt__ProblemEntry(soap, tag, id, (ngwt__ProblemEntry *const*)ptr, "ngwt:ProblemEntry");
	case SOAP_TYPE_PointerTongwt__PostalAddress:
		return soap_out_PointerTongwt__PostalAddress(soap, tag, id, (ngwt__PostalAddress *const*)ptr, "ngwt:PostalAddress");
	case SOAP_TYPE_PointerTongwt__PhoneNumber:
		return soap_out_PointerTongwt__PhoneNumber(soap, tag, id, (ngwt__PhoneNumber *const*)ptr, "ngwt:PhoneNumber");
	case SOAP_TYPE_PointerToxsd__date:
		return soap_out_PointerToxsd__date(soap, tag, id, (std::string *const*)ptr, "xsd:date");
	case SOAP_TYPE_PointerTongwt__ItemRef:
		return soap_out_PointerTongwt__ItemRef(soap, tag, id, (ngwt__ItemRef *const*)ptr, "ngwt:ItemRef");
	case SOAP_TYPE_PointerTongwt__UUID:
		return soap_out_PointerTongwt__UUID(soap, tag, id, (std::string *const*)ptr, "ngwt:UUID");
	case SOAP_TYPE_PointerTongwt__SharedFolderNotification:
		return soap_out_PointerTongwt__SharedFolderNotification(soap, tag, id, (ngwt__SharedFolderNotification *const*)ptr, "ngwt:SharedFolderNotification");
	case SOAP_TYPE_PointerTongwt__MessagePart:
		return soap_out_PointerTongwt__MessagePart(soap, tag, id, (ngwt__MessagePart *const*)ptr, "ngwt:MessagePart");
	case SOAP_TYPE_PointerTongwt__Library:
		return soap_out_PointerTongwt__Library(soap, tag, id, (ngwt__Library *const*)ptr, "ngwt:Library");
	case SOAP_TYPE_PointerTongwt__JunkEntry:
		return soap_out_PointerTongwt__JunkEntry(soap, tag, id, (ngwt__JunkEntry *const*)ptr, "ngwt:JunkEntry");
	case SOAP_TYPE_PointerTongwt__JunkHandlingListType:
		return soap_out_PointerTongwt__JunkHandlingListType(soap, tag, id, (enum ngwt__JunkHandlingListType *const*)ptr, "ngwt:JunkHandlingListType");
	case SOAP_TYPE_PointerTongwt__Item:
		return soap_out_PointerTongwt__Item(soap, tag, id, (ngwt__Item *const*)ptr, "ngwt:Item");
	case SOAP_TYPE_PointerTongwt__ItemChanges:
		return soap_out_PointerTongwt__ItemChanges(soap, tag, id, (ngwt__ItemChanges *const*)ptr, "ngwt:ItemChanges");
	case SOAP_TYPE_PointerTongwt__ImAddress:
		return soap_out_PointerTongwt__ImAddress(soap, tag, id, (ngwt__ImAddress *const*)ptr, "ngwt:ImAddress");
	case SOAP_TYPE_PointerTongwt__GroupMember:
		return soap_out_PointerTongwt__GroupMember(soap, tag, id, (ngwt__GroupMember *const*)ptr, "ngwt:GroupMember");
	case SOAP_TYPE_PointerTongwt__GroupMemberList:
		return soap_out_PointerTongwt__GroupMemberList(soap, tag, id, (ngwt__GroupMemberList *const*)ptr, "ngwt:GroupMemberList");
	case SOAP_TYPE_PointerTongwt__FreeBusyInfo:
		return soap_out_PointerTongwt__FreeBusyInfo(soap, tag, id, (ngwt__FreeBusyInfo *const*)ptr, "ngwt:FreeBusyInfo");
	case SOAP_TYPE_PointerTongwt__NameAndEmail:
		return soap_out_PointerTongwt__NameAndEmail(soap, tag, id, (ngwt__NameAndEmail *const*)ptr, "ngwt:NameAndEmail");
	case SOAP_TYPE_PointerTongwt__AcceptLevel:
		return soap_out_PointerTongwt__AcceptLevel(soap, tag, id, (enum ngwt__AcceptLevel *const*)ptr, "ngwt:AcceptLevel");
	case SOAP_TYPE_PointerTongwt__FreeBusyBlock:
		return soap_out_PointerTongwt__FreeBusyBlock(soap, tag, id, (ngwt__FreeBusyBlock *const*)ptr, "ngwt:FreeBusyBlock");
	case SOAP_TYPE_PointerTongwt__Folder:
		return soap_out_PointerTongwt__Folder(soap, tag, id, (ngwt__Folder *const*)ptr, "ngwt:Folder");
	case SOAP_TYPE_PointerTongwt__FolderACLEntry:
		return soap_out_PointerTongwt__FolderACLEntry(soap, tag, id, (ngwt__FolderACLEntry *const*)ptr, "ngwt:FolderACLEntry");
	case SOAP_TYPE_PointerTongwt__FilterElement:
		return soap_out_PointerTongwt__FilterElement(soap, tag, id, (ngwt__FilterElement *const*)ptr, "ngwt:FilterElement");
	case SOAP_TYPE_PointerTongwt__DocumentType:
		return soap_out_PointerTongwt__DocumentType(soap, tag, id, (ngwt__DocumentType *const*)ptr, "ngwt:DocumentType");
	case SOAP_TYPE_PointerTongwt__AgeAction:
		return soap_out_PointerTongwt__AgeAction(soap, tag, id, (enum ngwt__AgeAction *const*)ptr, "ngwt:AgeAction");
	case SOAP_TYPE_PointerTongwt__SendOptions:
		return soap_out_PointerTongwt__SendOptions(soap, tag, id, (ngwt__SendOptions *const*)ptr, "ngwt:SendOptions");
	case SOAP_TYPE_PointerTongwt__RecipientList:
		return soap_out_PointerTongwt__RecipientList(soap, tag, id, (ngwt__RecipientList *const*)ptr, "ngwt:RecipientList");
	case SOAP_TYPE_PointerTongwt__From:
		return soap_out_PointerTongwt__From(soap, tag, id, (ngwt__From *const*)ptr, "ngwt:From");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTongwt__DayOfYearWeek:
		return soap_out_PointerTongwt__DayOfYearWeek(soap, tag, id, (ngwt__DayOfYearWeek *const*)ptr, "ngwt:DayOfYearWeek");
	case SOAP_TYPE_PointerTongwt__Custom:
		return soap_out_PointerTongwt__Custom(soap, tag, id, (ngwt__Custom *const*)ptr, "ngwt:Custom");
	case SOAP_TYPE_PointerTongwt__CustomType:
		return soap_out_PointerTongwt__CustomType(soap, tag, id, (enum ngwt__CustomType *const*)ptr, "ngwt:CustomType");
	case SOAP_TYPE_PointerTongwt__uid:
		return soap_out_PointerTongwt__uid(soap, tag, id, (std::string *const*)ptr, "ngwt:uid");
	case SOAP_TYPE_PointerTongwt__Category:
		return soap_out_PointerTongwt__Category(soap, tag, id, (ngwt__Category *const*)ptr, "ngwt:Category");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTounsignedLong:
		return soap_out_PointerTounsignedLong(soap, tag, id, (unsigned long *const*)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTongwt__AttachmentID:
		return soap_out_PointerTongwt__AttachmentID(soap, tag, id, (ngwt__AttachmentID *const*)ptr, "ngwt:AttachmentID");
	case SOAP_TYPE_PointerTongwt__AttachmentItemInfo:
		return soap_out_PointerTongwt__AttachmentItemInfo(soap, tag, id, (ngwt__AttachmentItemInfo *const*)ptr, "ngwt:AttachmentItemInfo");
	case SOAP_TYPE_PointerTongwt__AddressBook:
		return soap_out_PointerTongwt__AddressBook(soap, tag, id, (ngwt__AddressBook *const*)ptr, "ngwt:AddressBook");
	case SOAP_TYPE_PointerTongwt__AccessRightEntry:
		return soap_out_PointerTongwt__AccessRightEntry(soap, tag, id, (ngwt__AccessRightEntry *const*)ptr, "ngwt:AccessRightEntry");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerTongwt__AccessControlListEntry:
		return soap_out_PointerTongwt__AccessControlListEntry(soap, tag, id, (ngwt__AccessControlListEntry *const*)ptr, "ngwt:AccessControlListEntry");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__TQName:
		return soap_out_string(soap, "TQName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ngwt__UUID:
		soap_serialize_ngwt__UUID(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_ngwt__uid:
		soap_serialize_ngwt__uid(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_ngwt__View:
		soap_serialize_ngwt__View(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__ngwe__removeEventsResponse:
		((_ngwe__removeEventsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__removeEventsRequest:
		((_ngwe__removeEventsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__removeEventConfigurationResponse:
		((_ngwe__removeEventConfigurationResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__removeEventConfigurationRequest:
		((_ngwe__removeEventConfigurationRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__getEventsResponse:
		((_ngwe__getEventsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__getEventsRequest:
		((_ngwe__getEventsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__getEventConfigurationResponse:
		((_ngwe__getEventConfigurationResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__getEventConfigurationRequest:
		((_ngwe__getEventConfigurationRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__configureEventsResponse:
		((_ngwe__configureEventsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__configureEventsRequest:
		((_ngwe__configureEventsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__cleanEventConfigurationResponse:
		((_ngwe__cleanEventConfigurationResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwe__cleanEventConfigurationRequest:
		((_ngwe__cleanEventConfigurationRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__Notify:
		((ngwe__Notify *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__EventTypeList:
		((ngwe__EventTypeList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__EventsList:
		((ngwe__EventsList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__Events:
		((ngwe__Events *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__EventList:
		((ngwe__EventList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__EventDefinition:
		((ngwe__EventDefinition *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__Event:
		((ngwe__Event *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwe__ContainerList:
		((ngwe__ContainerList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__updateVersionStatusResponse:
		((_ngwm__updateVersionStatusResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__updateVersionStatusRequest:
		((_ngwm__updateVersionStatusRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__uncompleteResponse:
		((_ngwm__uncompleteResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__uncompleteRequest:
		((_ngwm__uncompleteRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__unacceptResponse:
		((_ngwm__unacceptResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__unacceptRequest:
		((_ngwm__unacceptRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__startFreeBusySessionResponse:
		((_ngwm__startFreeBusySessionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__startFreeBusySessionRequest:
		((_ngwm__startFreeBusySessionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__setTimestampResponse:
		((_ngwm__setTimestampResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__setTimestampRequest:
		((_ngwm__setTimestampRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__sendItemResponse:
		((_ngwm__sendItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__sendItemRequest:
		((_ngwm__sendItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__retractResponse:
		((_ngwm__retractResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__retractRequest:
		((_ngwm__retractRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__replyResponse:
		((_ngwm__replyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__replyRequest:
		((_ngwm__replyRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeSignatureResponse:
		((_ngwm__removeSignatureResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeSignatureRequest:
		((_ngwm__removeSignatureRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeProxyUserResponse:
		((_ngwm__removeProxyUserResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeProxyUserRequest:
		((_ngwm__removeProxyUserRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeProxyAccessResponse:
		((_ngwm__removeProxyAccessResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeProxyAccessRequest:
		((_ngwm__removeProxyAccessRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeMembersResponse:
		((_ngwm__removeMembersResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeMembersRequest:
		((_ngwm__removeMembersRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeJunkEntryResponse:
		((_ngwm__removeJunkEntryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeJunkEntryRequest:
		((_ngwm__removeJunkEntryRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeItemsResponse:
		((_ngwm__removeItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeItemsRequest:
		((_ngwm__removeItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeItemResponse:
		((_ngwm__removeItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeItemRequest:
		((_ngwm__removeItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeCustomDefinitionResponse:
		((_ngwm__removeCustomDefinitionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__removeCustomDefinitionRequest:
		((_ngwm__removeCustomDefinitionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__readCursorResponse:
		((_ngwm__readCursorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__readCursorRequest:
		((_ngwm__readCursorRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__purgeResponse:
		((_ngwm__purgeResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__purgeRequest:
		((_ngwm__purgeRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__purgeDeletedItemsResponse:
		((_ngwm__purgeDeletedItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__purgeDeletedItemsRequest:
		((_ngwm__purgeDeletedItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__positionCursorResponse:
		((_ngwm__positionCursorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__positionCursorRequest:
		((_ngwm__positionCursorRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__moveItemResponse:
		((_ngwm__moveItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__moveItemRequest:
		((_ngwm__moveItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifySignaturesResponse:
		((_ngwm__modifySignaturesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifySignaturesRequest:
		((_ngwm__modifySignaturesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifySettingsResponse:
		((_ngwm__modifySettingsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifySettingsRequest:
		((_ngwm__modifySettingsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyProxyAccessResponse:
		((_ngwm__modifyProxyAccessResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyProxyAccessRequest:
		((_ngwm__modifyProxyAccessRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyPasswordResponse:
		((_ngwm__modifyPasswordResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyPasswordRequest:
		((_ngwm__modifyPasswordRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse:
		((_ngwm__modifyJunkMailSettingsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest:
		((_ngwm__modifyJunkMailSettingsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyJunkEntryResponse:
		((_ngwm__modifyJunkEntryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyJunkEntryRequest:
		((_ngwm__modifyJunkEntryRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyItemsResponse:
		((_ngwm__modifyItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyItemsRequest:
		((_ngwm__modifyItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyItemResponse:
		((_ngwm__modifyItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__modifyItemRequest:
		((_ngwm__modifyItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markUnReadResponse:
		((_ngwm__markUnReadResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markUnReadRequest:
		((_ngwm__markUnReadRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markUnPrivateResponse:
		((_ngwm__markUnPrivateResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markUnPrivateRequest:
		((_ngwm__markUnPrivateRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markReadResponse:
		((_ngwm__markReadResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markReadRequest:
		((_ngwm__markReadRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markPrivateResponse:
		((_ngwm__markPrivateResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__markPrivateRequest:
		((_ngwm__markPrivateRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__logoutResponse:
		((_ngwm__logoutResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__logoutRequest:
		((_ngwm__logoutRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__loginResponse:
		((_ngwm__loginResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__loginRequest:
		((_ngwm__loginRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getUserListResponse:
		((_ngwm__getUserListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getUserListRequest:
		((_ngwm__getUserListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getTimezoneListResponse:
		((_ngwm__getTimezoneListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getTimezoneListRequest:
		((_ngwm__getTimezoneListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getTimestampResponse:
		((_ngwm__getTimestampResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getTimestampRequest:
		((_ngwm__getTimestampRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getSignaturesResponse:
		((_ngwm__getSignaturesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getSignaturesRequest:
		((_ngwm__getSignaturesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getSettingsResponse:
		((_ngwm__getSettingsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getSettingsRequest:
		((_ngwm__getSettingsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getRuleListResponse:
		((_ngwm__getRuleListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getRuleListRequest:
		((_ngwm__getRuleListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getProxyListResponse:
		((_ngwm__getProxyListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getProxyListRequest:
		((_ngwm__getProxyListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getProxyAccessListResponse:
		((_ngwm__getProxyAccessListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getProxyAccessListRequest:
		((_ngwm__getProxyAccessListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getQuickMessagesResponse:
		((_ngwm__getQuickMessagesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getQuickMessagesRequest:
		((_ngwm__getQuickMessagesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getLibraryListResponse:
		((_ngwm__getLibraryListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getLibraryListRequest:
		((_ngwm__getLibraryListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getLibraryItemResponse:
		((_ngwm__getLibraryItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getLibraryItemRequest:
		((_ngwm__getLibraryItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getJunkMailSettingsResponse:
		((_ngwm__getJunkMailSettingsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getJunkMailSettingsRequest:
		((_ngwm__getJunkMailSettingsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getJunkEntriesResponse:
		((_ngwm__getJunkEntriesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getJunkEntriesRequest:
		((_ngwm__getJunkEntriesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getItemsResponse:
		((_ngwm__getItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getItemsRequest:
		((_ngwm__getItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getItemResponse:
		((_ngwm__getItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getItemRequest:
		((_ngwm__getItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFreeBusyResponse:
		((_ngwm__getFreeBusyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFreeBusyRequest:
		((_ngwm__getFreeBusyRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFolderListResponse:
		((_ngwm__getFolderListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFolderListRequest:
		((_ngwm__getFolderListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFolderResponse:
		((_ngwm__getFolderResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getFolderRequest:
		((_ngwm__getFolderRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDocumentTypeListResponse:
		((_ngwm__getDocumentTypeListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDocumentTypeListRequest:
		((_ngwm__getDocumentTypeListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDeltaInfoResponse:
		((_ngwm__getDeltaInfoResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDeltaInfoRequest:
		((_ngwm__getDeltaInfoRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDeltasResponse:
		((_ngwm__getDeltasResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getDeltasRequest:
		((_ngwm__getDeltasRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getCustomListResponse:
		((_ngwm__getCustomListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getCustomListRequest:
		((_ngwm__getCustomListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getCategoryListResponse:
		((_ngwm__getCategoryListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getCategoryListRequest:
		((_ngwm__getCategoryListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getAttachmentResponse:
		((_ngwm__getAttachmentResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getAttachmentRequest:
		((_ngwm__getAttachmentRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getAddressBookListResponse:
		((_ngwm__getAddressBookListResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__getAddressBookListRequest:
		((_ngwm__getAddressBookListRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__forwardResponse:
		((_ngwm__forwardResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__forwardRequest:
		((_ngwm__forwardRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__executeRuleResponse:
		((_ngwm__executeRuleResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__executeRuleRequest:
		((_ngwm__executeRuleRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__destroyCursorResponse:
		((_ngwm__destroyCursorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__destroyCursorRequest:
		((_ngwm__destroyCursorRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__delegateResponse:
		((_ngwm__delegateResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__delegateRequest:
		((_ngwm__delegateRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__declineResponse:
		((_ngwm__declineResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__declineRequest:
		((_ngwm__declineRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createSignatureResponse:
		((_ngwm__createSignatureResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createSignatureRequest:
		((_ngwm__createSignatureRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createProxyAccessResponse:
		((_ngwm__createProxyAccessResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createProxyAccessRequest:
		((_ngwm__createProxyAccessRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createJunkEntryResponse:
		((_ngwm__createJunkEntryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createJunkEntryRequest:
		((_ngwm__createJunkEntryRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createItemsResponse:
		((_ngwm__createItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createItemsRequest:
		((_ngwm__createItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createItemResponse:
		((_ngwm__createItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createItemRequest:
		((_ngwm__createItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createCursorResponse:
		((_ngwm__createCursorResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__createCursorRequest:
		((_ngwm__createCursorRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__completeResponse:
		((_ngwm__completeResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__completeRequest:
		((_ngwm__completeRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__closeFreeBusySessionResponse:
		((_ngwm__closeFreeBusySessionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__closeFreeBusySessionRequest:
		((_ngwm__closeFreeBusySessionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addMembersResponse:
		((_ngwm__addMembersResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addMembersRequest:
		((_ngwm__addMembersRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addItemsResponse:
		((_ngwm__addItemsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addItemsRequest:
		((_ngwm__addItemsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addItemResponse:
		((_ngwm__addItemResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__addItemRequest:
		((_ngwm__addItemRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__acceptShareResponse:
		((_ngwm__acceptShareResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__acceptShareRequest:
		((_ngwm__acceptShareRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__acceptResponse:
		((_ngwm__acceptResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ngwm__acceptRequest:
		((_ngwm__acceptRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__VersionEvent:
		((ngwt__VersionEvent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Version:
		((ngwt__Version *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__UserList:
		((ngwt__UserList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__UserInfo:
		((ngwt__UserInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__TrustedApplication:
		((ngwt__TrustedApplication *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__TransferFailedStatus:
		((ngwt__TransferFailedStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__TimezoneList:
		((ngwt__TimezoneList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__TimezoneComponent:
		((ngwt__TimezoneComponent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Timezone:
		((ngwt__Timezone *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Task:
		((ngwt__Task *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SystemFolder:
		((ngwt__SystemFolder *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__StatusTracking:
		((ngwt__StatusTracking *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Status:
		((ngwt__Status *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SMimeOperation:
		((ngwt__SMimeOperation *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SignatureData:
		((ngwt__SignatureData *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Signatures:
		((ngwt__Signatures *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Signature:
		((ngwt__Signature *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SharedNotification:
		((ngwt__SharedNotification *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SharedFolderNotification:
		((ngwt__SharedFolderNotification *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SharedFolder:
		((ngwt__SharedFolder *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SettingsList:
		((ngwt__SettingsList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SettingsGroup:
		((ngwt__SettingsGroup *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Settings:
		((ngwt__Settings *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SendOptions:
		((ngwt__SendOptions *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__SendOptionsRequestReply:
		((ngwt__SendOptionsRequestReply *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RuleList:
		((ngwt__RuleList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RuleActionList:
		((ngwt__RuleActionList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RuleAction:
		((ngwt__RuleAction *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Rule:
		((ngwt__Rule *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Rights:
		((ngwt__Rights *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ReturnNotificationOptions:
		((ngwt__ReturnNotificationOptions *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ReturnNotification:
		((ngwt__ReturnNotification *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Resource:
		((ngwt__Resource *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ReferenceInfo:
		((ngwt__ReferenceInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RecurrenceRule:
		((ngwt__RecurrenceRule *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RecurrenceDateType:
		((ngwt__RecurrenceDateType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RecipientStatus:
		((ngwt__RecipientStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__RecipientList:
		((ngwt__RecipientList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Recipient:
		((ngwt__Recipient *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__QueryTarget:
		((ngwt__QueryTarget *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__QueryFolder:
		((ngwt__QueryFolder *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Query:
		((ngwt__Query *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ProxyList:
		((ngwt__ProxyList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ProxyUser:
		((ngwt__ProxyUser *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Proxy:
		((ngwt__Proxy *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ProblemList:
		((ngwt__ProblemList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ProblemEntry:
		((ngwt__ProblemEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PostalAddressList:
		((ngwt__PostalAddressList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PostalAddress:
		((ngwt__PostalAddress *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PlainText:
		((ngwt__PlainText *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PhoneNumber:
		((ngwt__PhoneNumber *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PhoneMessage:
		((ngwt__PhoneMessage *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PhoneList:
		((ngwt__PhoneList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PhoneFlags:
		((ngwt__PhoneFlags *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__PersonalInfo:
		((ngwt__PersonalInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Organization:
		((ngwt__Organization *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__OfficeInfo:
		((ngwt__OfficeInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Note:
		((ngwt__Note *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__NameAndEmail:
		((ngwt__NameAndEmail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__MonthList:
		((ngwt__MonthList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ModifyItem:
		((ngwt__ModifyItem *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__MessagePart:
		((ngwt__MessagePart *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__MessageBody:
		((ngwt__MessageBody *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Mail:
		((ngwt__Mail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__LinkInfo:
		((ngwt__LinkInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__LibraryList:
		((ngwt__LibraryList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Library:
		((ngwt__Library *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__JunkHandlingList:
		((ngwt__JunkHandlingList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__JunkEntry:
		((ngwt__JunkEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemStatus:
		((ngwt__ItemStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Items:
		((ngwt__Items *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemRefList:
		((ngwt__ItemRefList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemRef:
		((ngwt__ItemRef *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemOptions:
		((ngwt__ItemOptions *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemList:
		((ngwt__ItemList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ItemChanges:
		((ngwt__ItemChanges *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Item:
		((ngwt__Item *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ImAddressList:
		((ngwt__ImAddressList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ImAddress:
		((ngwt__ImAddress *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Host:
		((ngwt__Host *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__GroupMemberList:
		((ngwt__GroupMemberList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__GroupMember:
		((ngwt__GroupMember *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Group:
		((ngwt__Group *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FullName:
		((ngwt__FullName *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__From:
		((ngwt__From *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyStats:
		((ngwt__FreeBusyStats *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyInfoList:
		((ngwt__FreeBusyInfoList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyUserList:
		((ngwt__FreeBusyUserList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyInfo:
		((ngwt__FreeBusyInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyBlock:
		((ngwt__FreeBusyBlock *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FreeBusyBlockList:
		((ngwt__FreeBusyBlockList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FolderList:
		((ngwt__FolderList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FolderACLEntry:
		((ngwt__FolderACLEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FolderACL:
		((ngwt__FolderACL *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Folder:
		((ngwt__Folder *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FilterGroup:
		((ngwt__FilterGroup *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FilterEntry:
		((ngwt__FilterEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__FilterElement:
		((ngwt__FilterElement *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Filter:
		((ngwt__Filter *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__EmailAddressList:
		((ngwt__EmailAddressList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DocumentTypeList:
		((ngwt__DocumentTypeList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DocumentType:
		((ngwt__DocumentType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DocumentRef:
		((ngwt__DocumentRef *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Document:
		((ngwt__Document *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Distribution:
		((ngwt__Distribution *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DeltaInfo:
		((ngwt__DeltaInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DelegateeStatus:
		((ngwt__DelegateeStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DelegatedStatus:
		((ngwt__DelegatedStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DayOfYearWeekList:
		((ngwt__DayOfYearWeekList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DayOfYearWeek:
		((ngwt__DayOfYearWeek *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DayOfYearList:
		((ngwt__DayOfYearList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DayOfWeek:
		((ngwt__DayOfWeek *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__DayOfMonthList:
		((ngwt__DayOfMonthList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CustomList:
		((ngwt__CustomList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Custom:
		((ngwt__Custom *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ContainerRef:
		((ngwt__ContainerRef *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ContainerItem:
		((ngwt__ContainerItem *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__ContactFolder:
		((ngwt__ContactFolder *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Contact:
		((ngwt__Contact *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CommentStatus:
		((ngwt__CommentStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CategoryRefList:
		((ngwt__CategoryRefList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CategoryList:
		((ngwt__CategoryList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Category:
		((ngwt__Category *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CalendarItem:
		((ngwt__CalendarItem *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__CalendarFolderAttribute:
		((ngwt__CalendarFolderAttribute *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__BoxEntry:
		((ngwt__BoxEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Authentication:
		((ngwt__Authentication *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AttachmentItemInfo:
		((ngwt__AttachmentItemInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AttachmentInfo:
		((ngwt__AttachmentInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AttachmentID:
		((ngwt__AttachmentID *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Appointment:
		((ngwt__Appointment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__Alarm:
		((ngwt__Alarm *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AddressBookList:
		((ngwt__AddressBookList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AddressBookItem:
		((ngwt__AddressBookItem *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AddressBook:
		((ngwt__AddressBook *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessRightList:
		((ngwt__AccessRightList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessRightEntry:
		((ngwt__AccessRightEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessRightChanges:
		((ngwt__AccessRightChanges *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessRight:
		((ngwt__AccessRight *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessMiscRight:
		((ngwt__AccessMiscRight *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessControlList:
		((ngwt__AccessControlList *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ngwt__AccessControlListEntry:
		((ngwt__AccessControlListEntry *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xsd__language:
		soap_serialize_xsd__language(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__duration:
		soap_serialize_xsd__duration(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__decimal:
		soap_serialize_xsd__decimal(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__date:
		soap_serialize_xsd__date(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		((xsd__base64Binary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___ngw__removeEventsRequest:
		soap_serialize___ngw__removeEventsRequest(soap, (const struct __ngw__removeEventsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeEventConfigurationRequest:
		soap_serialize___ngw__removeEventConfigurationRequest(soap, (const struct __ngw__removeEventConfigurationRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getEventsRequest:
		soap_serialize___ngw__getEventsRequest(soap, (const struct __ngw__getEventsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getEventConfigurationRequest:
		soap_serialize___ngw__getEventConfigurationRequest(soap, (const struct __ngw__getEventConfigurationRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__configureEventsRequest:
		soap_serialize___ngw__configureEventsRequest(soap, (const struct __ngw__configureEventsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__cleanEventConfigurationRequest:
		soap_serialize___ngw__cleanEventConfigurationRequest(soap, (const struct __ngw__cleanEventConfigurationRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__updateVersionStatusRequest:
		soap_serialize___ngw__updateVersionStatusRequest(soap, (const struct __ngw__updateVersionStatusRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__uncompleteRequest:
		soap_serialize___ngw__uncompleteRequest(soap, (const struct __ngw__uncompleteRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__unacceptRequest:
		soap_serialize___ngw__unacceptRequest(soap, (const struct __ngw__unacceptRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__startFreeBusySessionRequest:
		soap_serialize___ngw__startFreeBusySessionRequest(soap, (const struct __ngw__startFreeBusySessionRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__setTimestampRequest:
		soap_serialize___ngw__setTimestampRequest(soap, (const struct __ngw__setTimestampRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__sendItemRequest:
		soap_serialize___ngw__sendItemRequest(soap, (const struct __ngw__sendItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__retractRequest:
		soap_serialize___ngw__retractRequest(soap, (const struct __ngw__retractRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__replyRequest:
		soap_serialize___ngw__replyRequest(soap, (const struct __ngw__replyRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeSignatureRequest:
		soap_serialize___ngw__removeSignatureRequest(soap, (const struct __ngw__removeSignatureRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeProxyUserRequest:
		soap_serialize___ngw__removeProxyUserRequest(soap, (const struct __ngw__removeProxyUserRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeProxyAccessRequest:
		soap_serialize___ngw__removeProxyAccessRequest(soap, (const struct __ngw__removeProxyAccessRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeMembersRequest:
		soap_serialize___ngw__removeMembersRequest(soap, (const struct __ngw__removeMembersRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeJunkEntryRequest:
		soap_serialize___ngw__removeJunkEntryRequest(soap, (const struct __ngw__removeJunkEntryRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeItemsRequest:
		soap_serialize___ngw__removeItemsRequest(soap, (const struct __ngw__removeItemsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeItemRequest:
		soap_serialize___ngw__removeItemRequest(soap, (const struct __ngw__removeItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__removeCustomDefinitionRequest:
		soap_serialize___ngw__removeCustomDefinitionRequest(soap, (const struct __ngw__removeCustomDefinitionRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__readCursorRequest:
		soap_serialize___ngw__readCursorRequest(soap, (const struct __ngw__readCursorRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__purgeRequest:
		soap_serialize___ngw__purgeRequest(soap, (const struct __ngw__purgeRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__purgeDeletedItemsRequest:
		soap_serialize___ngw__purgeDeletedItemsRequest(soap, (const struct __ngw__purgeDeletedItemsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__positionCursorRequest:
		soap_serialize___ngw__positionCursorRequest(soap, (const struct __ngw__positionCursorRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__moveItemRequest:
		soap_serialize___ngw__moveItemRequest(soap, (const struct __ngw__moveItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifySignaturesRequest:
		soap_serialize___ngw__modifySignaturesRequest(soap, (const struct __ngw__modifySignaturesRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifySettingsRequest:
		soap_serialize___ngw__modifySettingsRequest(soap, (const struct __ngw__modifySettingsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifyProxyAccessRequest:
		soap_serialize___ngw__modifyProxyAccessRequest(soap, (const struct __ngw__modifyProxyAccessRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifyPasswordRequest:
		soap_serialize___ngw__modifyPasswordRequest(soap, (const struct __ngw__modifyPasswordRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifyJunkMailSettingsRequest:
		soap_serialize___ngw__modifyJunkMailSettingsRequest(soap, (const struct __ngw__modifyJunkMailSettingsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifyJunkEntryRequest:
		soap_serialize___ngw__modifyJunkEntryRequest(soap, (const struct __ngw__modifyJunkEntryRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__modifyItemRequest:
		soap_serialize___ngw__modifyItemRequest(soap, (const struct __ngw__modifyItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__markUnReadRequest:
		soap_serialize___ngw__markUnReadRequest(soap, (const struct __ngw__markUnReadRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__markUnPrivateRequest:
		soap_serialize___ngw__markUnPrivateRequest(soap, (const struct __ngw__markUnPrivateRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__markReadRequest:
		soap_serialize___ngw__markReadRequest(soap, (const struct __ngw__markReadRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__markPrivateRequest:
		soap_serialize___ngw__markPrivateRequest(soap, (const struct __ngw__markPrivateRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__logoutRequest:
		soap_serialize___ngw__logoutRequest(soap, (const struct __ngw__logoutRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__loginRequest:
		soap_serialize___ngw__loginRequest(soap, (const struct __ngw__loginRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getUserListRequest:
		soap_serialize___ngw__getUserListRequest(soap, (const struct __ngw__getUserListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getTimezoneListRequest:
		soap_serialize___ngw__getTimezoneListRequest(soap, (const struct __ngw__getTimezoneListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getTimestampRequest:
		soap_serialize___ngw__getTimestampRequest(soap, (const struct __ngw__getTimestampRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getSignaturesRequest:
		soap_serialize___ngw__getSignaturesRequest(soap, (const struct __ngw__getSignaturesRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getSettingsRequest:
		soap_serialize___ngw__getSettingsRequest(soap, (const struct __ngw__getSettingsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getRuleListRequest:
		soap_serialize___ngw__getRuleListRequest(soap, (const struct __ngw__getRuleListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getProxyListRequest:
		soap_serialize___ngw__getProxyListRequest(soap, (const struct __ngw__getProxyListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getProxyAccessListRequest:
		soap_serialize___ngw__getProxyAccessListRequest(soap, (const struct __ngw__getProxyAccessListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getQuickMessagesRequest:
		soap_serialize___ngw__getQuickMessagesRequest(soap, (const struct __ngw__getQuickMessagesRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getLibraryListRequest:
		soap_serialize___ngw__getLibraryListRequest(soap, (const struct __ngw__getLibraryListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getLibraryItemRequest:
		soap_serialize___ngw__getLibraryItemRequest(soap, (const struct __ngw__getLibraryItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getJunkMailSettingsRequest:
		soap_serialize___ngw__getJunkMailSettingsRequest(soap, (const struct __ngw__getJunkMailSettingsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getJunkEntriesRequest:
		soap_serialize___ngw__getJunkEntriesRequest(soap, (const struct __ngw__getJunkEntriesRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getItemsRequest:
		soap_serialize___ngw__getItemsRequest(soap, (const struct __ngw__getItemsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getItemRequest:
		soap_serialize___ngw__getItemRequest(soap, (const struct __ngw__getItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getFreeBusyRequest:
		soap_serialize___ngw__getFreeBusyRequest(soap, (const struct __ngw__getFreeBusyRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getFolderListRequest:
		soap_serialize___ngw__getFolderListRequest(soap, (const struct __ngw__getFolderListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getFolderRequest:
		soap_serialize___ngw__getFolderRequest(soap, (const struct __ngw__getFolderRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getDocumentTypeListRequest:
		soap_serialize___ngw__getDocumentTypeListRequest(soap, (const struct __ngw__getDocumentTypeListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getDeltaInfoRequest:
		soap_serialize___ngw__getDeltaInfoRequest(soap, (const struct __ngw__getDeltaInfoRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getDeltasRequest:
		soap_serialize___ngw__getDeltasRequest(soap, (const struct __ngw__getDeltasRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getCustomListRequest:
		soap_serialize___ngw__getCustomListRequest(soap, (const struct __ngw__getCustomListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getCategoryListRequest:
		soap_serialize___ngw__getCategoryListRequest(soap, (const struct __ngw__getCategoryListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__getAttachmentRequestMessage:
		soap_serialize___ngw__getAttachmentRequestMessage(soap, (const struct __ngw__getAttachmentRequestMessage *)ptr);
		break;
	case SOAP_TYPE___ngw__getAddressBookListRequest:
		soap_serialize___ngw__getAddressBookListRequest(soap, (const struct __ngw__getAddressBookListRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__forwardRequest:
		soap_serialize___ngw__forwardRequest(soap, (const struct __ngw__forwardRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__executeRuleRequest:
		soap_serialize___ngw__executeRuleRequest(soap, (const struct __ngw__executeRuleRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__destroyCursorRequest:
		soap_serialize___ngw__destroyCursorRequest(soap, (const struct __ngw__destroyCursorRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__delegateRequest:
		soap_serialize___ngw__delegateRequest(soap, (const struct __ngw__delegateRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__declineRequest:
		soap_serialize___ngw__declineRequest(soap, (const struct __ngw__declineRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createSignatureRequest:
		soap_serialize___ngw__createSignatureRequest(soap, (const struct __ngw__createSignatureRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createProxyAccessRequest:
		soap_serialize___ngw__createProxyAccessRequest(soap, (const struct __ngw__createProxyAccessRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createJunkEntryRequest:
		soap_serialize___ngw__createJunkEntryRequest(soap, (const struct __ngw__createJunkEntryRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createItemsRequest:
		soap_serialize___ngw__createItemsRequest(soap, (const struct __ngw__createItemsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createItemRequest:
		soap_serialize___ngw__createItemRequest(soap, (const struct __ngw__createItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__createCursorRequest:
		soap_serialize___ngw__createCursorRequest(soap, (const struct __ngw__createCursorRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__completeRequest:
		soap_serialize___ngw__completeRequest(soap, (const struct __ngw__completeRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__closeFreeBusySessionRequest:
		soap_serialize___ngw__closeFreeBusySessionRequest(soap, (const struct __ngw__closeFreeBusySessionRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__addMembersRequest:
		soap_serialize___ngw__addMembersRequest(soap, (const struct __ngw__addMembersRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__addItemsRequest:
		soap_serialize___ngw__addItemsRequest(soap, (const struct __ngw__addItemsRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__addItemRequest:
		soap_serialize___ngw__addItemRequest(soap, (const struct __ngw__addItemRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__acceptShareRequest:
		soap_serialize___ngw__acceptShareRequest(soap, (const struct __ngw__acceptShareRequest *)ptr);
		break;
	case SOAP_TYPE___ngw__acceptRequest:
		soap_serialize___ngw__acceptRequest(soap, (const struct __ngw__acceptRequest *)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__removeEventsResponse:
		soap_serialize_PointerTo_ngwe__removeEventsResponse(soap, (_ngwe__removeEventsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__removeEventsRequest:
		soap_serialize_PointerTo_ngwe__removeEventsRequest(soap, (_ngwe__removeEventsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationResponse:
		soap_serialize_PointerTo_ngwe__removeEventConfigurationResponse(soap, (_ngwe__removeEventConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__removeEventConfigurationRequest:
		soap_serialize_PointerTo_ngwe__removeEventConfigurationRequest(soap, (_ngwe__removeEventConfigurationRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__getEventsResponse:
		soap_serialize_PointerTo_ngwe__getEventsResponse(soap, (_ngwe__getEventsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__getEventsRequest:
		soap_serialize_PointerTo_ngwe__getEventsRequest(soap, (_ngwe__getEventsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationResponse:
		soap_serialize_PointerTo_ngwe__getEventConfigurationResponse(soap, (_ngwe__getEventConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__getEventConfigurationRequest:
		soap_serialize_PointerTo_ngwe__getEventConfigurationRequest(soap, (_ngwe__getEventConfigurationRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__configureEventsResponse:
		soap_serialize_PointerTo_ngwe__configureEventsResponse(soap, (_ngwe__configureEventsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__configureEventsRequest:
		soap_serialize_PointerTo_ngwe__configureEventsRequest(soap, (_ngwe__configureEventsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationResponse:
		soap_serialize_PointerTo_ngwe__cleanEventConfigurationResponse(soap, (_ngwe__cleanEventConfigurationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwe__cleanEventConfigurationRequest:
		soap_serialize_PointerTo_ngwe__cleanEventConfigurationRequest(soap, (_ngwe__cleanEventConfigurationRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusResponse:
		soap_serialize_PointerTo_ngwm__updateVersionStatusResponse(soap, (_ngwm__updateVersionStatusResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__updateVersionStatusRequest:
		soap_serialize_PointerTo_ngwm__updateVersionStatusRequest(soap, (_ngwm__updateVersionStatusRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__uncompleteResponse:
		soap_serialize_PointerTo_ngwm__uncompleteResponse(soap, (_ngwm__uncompleteResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__uncompleteRequest:
		soap_serialize_PointerTo_ngwm__uncompleteRequest(soap, (_ngwm__uncompleteRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__unacceptResponse:
		soap_serialize_PointerTo_ngwm__unacceptResponse(soap, (_ngwm__unacceptResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__unacceptRequest:
		soap_serialize_PointerTo_ngwm__unacceptRequest(soap, (_ngwm__unacceptRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionResponse:
		soap_serialize_PointerTo_ngwm__startFreeBusySessionResponse(soap, (_ngwm__startFreeBusySessionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__startFreeBusySessionRequest:
		soap_serialize_PointerTo_ngwm__startFreeBusySessionRequest(soap, (_ngwm__startFreeBusySessionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__setTimestampResponse:
		soap_serialize_PointerTo_ngwm__setTimestampResponse(soap, (_ngwm__setTimestampResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__setTimestampRequest:
		soap_serialize_PointerTo_ngwm__setTimestampRequest(soap, (_ngwm__setTimestampRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__sendItemResponse:
		soap_serialize_PointerTo_ngwm__sendItemResponse(soap, (_ngwm__sendItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__sendItemRequest:
		soap_serialize_PointerTo_ngwm__sendItemRequest(soap, (_ngwm__sendItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__retractResponse:
		soap_serialize_PointerTo_ngwm__retractResponse(soap, (_ngwm__retractResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__retractRequest:
		soap_serialize_PointerTo_ngwm__retractRequest(soap, (_ngwm__retractRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__replyResponse:
		soap_serialize_PointerTo_ngwm__replyResponse(soap, (_ngwm__replyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__replyRequest:
		soap_serialize_PointerTo_ngwm__replyRequest(soap, (_ngwm__replyRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureResponse:
		soap_serialize_PointerTo_ngwm__removeSignatureResponse(soap, (_ngwm__removeSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeSignatureRequest:
		soap_serialize_PointerTo_ngwm__removeSignatureRequest(soap, (_ngwm__removeSignatureRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserResponse:
		soap_serialize_PointerTo_ngwm__removeProxyUserResponse(soap, (_ngwm__removeProxyUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeProxyUserRequest:
		soap_serialize_PointerTo_ngwm__removeProxyUserRequest(soap, (_ngwm__removeProxyUserRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessResponse:
		soap_serialize_PointerTo_ngwm__removeProxyAccessResponse(soap, (_ngwm__removeProxyAccessResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeProxyAccessRequest:
		soap_serialize_PointerTo_ngwm__removeProxyAccessRequest(soap, (_ngwm__removeProxyAccessRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeMembersResponse:
		soap_serialize_PointerTo_ngwm__removeMembersResponse(soap, (_ngwm__removeMembersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeMembersRequest:
		soap_serialize_PointerTo_ngwm__removeMembersRequest(soap, (_ngwm__removeMembersRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryResponse:
		soap_serialize_PointerTo_ngwm__removeJunkEntryResponse(soap, (_ngwm__removeJunkEntryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeJunkEntryRequest:
		soap_serialize_PointerTo_ngwm__removeJunkEntryRequest(soap, (_ngwm__removeJunkEntryRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeItemsResponse:
		soap_serialize_PointerTo_ngwm__removeItemsResponse(soap, (_ngwm__removeItemsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeItemsRequest:
		soap_serialize_PointerTo_ngwm__removeItemsRequest(soap, (_ngwm__removeItemsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeItemResponse:
		soap_serialize_PointerTo_ngwm__removeItemResponse(soap, (_ngwm__removeItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeItemRequest:
		soap_serialize_PointerTo_ngwm__removeItemRequest(soap, (_ngwm__removeItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionResponse:
		soap_serialize_PointerTo_ngwm__removeCustomDefinitionResponse(soap, (_ngwm__removeCustomDefinitionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__removeCustomDefinitionRequest:
		soap_serialize_PointerTo_ngwm__removeCustomDefinitionRequest(soap, (_ngwm__removeCustomDefinitionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__readCursorResponse:
		soap_serialize_PointerTo_ngwm__readCursorResponse(soap, (_ngwm__readCursorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__readCursorRequest:
		soap_serialize_PointerTo_ngwm__readCursorRequest(soap, (_ngwm__readCursorRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__purgeResponse:
		soap_serialize_PointerTo_ngwm__purgeResponse(soap, (_ngwm__purgeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__purgeRequest:
		soap_serialize_PointerTo_ngwm__purgeRequest(soap, (_ngwm__purgeRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsResponse:
		soap_serialize_PointerTo_ngwm__purgeDeletedItemsResponse(soap, (_ngwm__purgeDeletedItemsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__purgeDeletedItemsRequest:
		soap_serialize_PointerTo_ngwm__purgeDeletedItemsRequest(soap, (_ngwm__purgeDeletedItemsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__positionCursorResponse:
		soap_serialize_PointerTo_ngwm__positionCursorResponse(soap, (_ngwm__positionCursorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__positionCursorRequest:
		soap_serialize_PointerTo_ngwm__positionCursorRequest(soap, (_ngwm__positionCursorRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__moveItemResponse:
		soap_serialize_PointerTo_ngwm__moveItemResponse(soap, (_ngwm__moveItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__moveItemRequest:
		soap_serialize_PointerTo_ngwm__moveItemRequest(soap, (_ngwm__moveItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesResponse:
		soap_serialize_PointerTo_ngwm__modifySignaturesResponse(soap, (_ngwm__modifySignaturesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifySignaturesRequest:
		soap_serialize_PointerTo_ngwm__modifySignaturesRequest(soap, (_ngwm__modifySignaturesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsResponse:
		soap_serialize_PointerTo_ngwm__modifySettingsResponse(soap, (_ngwm__modifySettingsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifySettingsRequest:
		soap_serialize_PointerTo_ngwm__modifySettingsRequest(soap, (_ngwm__modifySettingsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessResponse:
		soap_serialize_PointerTo_ngwm__modifyProxyAccessResponse(soap, (_ngwm__modifyProxyAccessResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyProxyAccessRequest:
		soap_serialize_PointerTo_ngwm__modifyProxyAccessRequest(soap, (_ngwm__modifyProxyAccessRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordResponse:
		soap_serialize_PointerTo_ngwm__modifyPasswordResponse(soap, (_ngwm__modifyPasswordResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyPasswordRequest:
		soap_serialize_PointerTo_ngwm__modifyPasswordRequest(soap, (_ngwm__modifyPasswordRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsResponse:
		soap_serialize_PointerTo_ngwm__modifyJunkMailSettingsResponse(soap, (_ngwm__modifyJunkMailSettingsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkMailSettingsRequest:
		soap_serialize_PointerTo_ngwm__modifyJunkMailSettingsRequest(soap, (_ngwm__modifyJunkMailSettingsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryResponse:
		soap_serialize_PointerTo_ngwm__modifyJunkEntryResponse(soap, (_ngwm__modifyJunkEntryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyJunkEntryRequest:
		soap_serialize_PointerTo_ngwm__modifyJunkEntryRequest(soap, (_ngwm__modifyJunkEntryRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyItemResponse:
		soap_serialize_PointerTo_ngwm__modifyItemResponse(soap, (_ngwm__modifyItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__modifyItemRequest:
		soap_serialize_PointerTo_ngwm__modifyItemRequest(soap, (_ngwm__modifyItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markUnReadResponse:
		soap_serialize_PointerTo_ngwm__markUnReadResponse(soap, (_ngwm__markUnReadResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markUnReadRequest:
		soap_serialize_PointerTo_ngwm__markUnReadRequest(soap, (_ngwm__markUnReadRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateResponse:
		soap_serialize_PointerTo_ngwm__markUnPrivateResponse(soap, (_ngwm__markUnPrivateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markUnPrivateRequest:
		soap_serialize_PointerTo_ngwm__markUnPrivateRequest(soap, (_ngwm__markUnPrivateRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markReadResponse:
		soap_serialize_PointerTo_ngwm__markReadResponse(soap, (_ngwm__markReadResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markReadRequest:
		soap_serialize_PointerTo_ngwm__markReadRequest(soap, (_ngwm__markReadRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markPrivateResponse:
		soap_serialize_PointerTo_ngwm__markPrivateResponse(soap, (_ngwm__markPrivateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__markPrivateRequest:
		soap_serialize_PointerTo_ngwm__markPrivateRequest(soap, (_ngwm__markPrivateRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__logoutResponse:
		soap_serialize_PointerTo_ngwm__logoutResponse(soap, (_ngwm__logoutResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__logoutRequest:
		soap_serialize_PointerTo_ngwm__logoutRequest(soap, (_ngwm__logoutRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__loginResponse:
		soap_serialize_PointerTo_ngwm__loginResponse(soap, (_ngwm__loginResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__loginRequest:
		soap_serialize_PointerTo_ngwm__loginRequest(soap, (_ngwm__loginRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getUserListResponse:
		soap_serialize_PointerTo_ngwm__getUserListResponse(soap, (_ngwm__getUserListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getUserListRequest:
		soap_serialize_PointerTo_ngwm__getUserListRequest(soap, (_ngwm__getUserListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListResponse:
		soap_serialize_PointerTo_ngwm__getTimezoneListResponse(soap, (_ngwm__getTimezoneListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getTimezoneListRequest:
		soap_serialize_PointerTo_ngwm__getTimezoneListRequest(soap, (_ngwm__getTimezoneListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getTimestampResponse:
		soap_serialize_PointerTo_ngwm__getTimestampResponse(soap, (_ngwm__getTimestampResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getTimestampRequest:
		soap_serialize_PointerTo_ngwm__getTimestampRequest(soap, (_ngwm__getTimestampRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesResponse:
		soap_serialize_PointerTo_ngwm__getSignaturesResponse(soap, (_ngwm__getSignaturesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getSignaturesRequest:
		soap_serialize_PointerTo_ngwm__getSignaturesRequest(soap, (_ngwm__getSignaturesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getSettingsResponse:
		soap_serialize_PointerTo_ngwm__getSettingsResponse(soap, (_ngwm__getSettingsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getSettingsRequest:
		soap_serialize_PointerTo_ngwm__getSettingsRequest(soap, (_ngwm__getSettingsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getRuleListResponse:
		soap_serialize_PointerTo_ngwm__getRuleListResponse(soap, (_ngwm__getRuleListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getRuleListRequest:
		soap_serialize_PointerTo_ngwm__getRuleListRequest(soap, (_ngwm__getRuleListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getProxyListResponse:
		soap_serialize_PointerTo_ngwm__getProxyListResponse(soap, (_ngwm__getProxyListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getProxyListRequest:
		soap_serialize_PointerTo_ngwm__getProxyListRequest(soap, (_ngwm__getProxyListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListResponse:
		soap_serialize_PointerTo_ngwm__getProxyAccessListResponse(soap, (_ngwm__getProxyAccessListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getProxyAccessListRequest:
		soap_serialize_PointerTo_ngwm__getProxyAccessListRequest(soap, (_ngwm__getProxyAccessListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesResponse:
		soap_serialize_PointerTo_ngwm__getQuickMessagesResponse(soap, (_ngwm__getQuickMessagesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getQuickMessagesRequest:
		soap_serialize_PointerTo_ngwm__getQuickMessagesRequest(soap, (_ngwm__getQuickMessagesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListResponse:
		soap_serialize_PointerTo_ngwm__getLibraryListResponse(soap, (_ngwm__getLibraryListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getLibraryListRequest:
		soap_serialize_PointerTo_ngwm__getLibraryListRequest(soap, (_ngwm__getLibraryListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemResponse:
		soap_serialize_PointerTo_ngwm__getLibraryItemResponse(soap, (_ngwm__getLibraryItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getLibraryItemRequest:
		soap_serialize_PointerTo_ngwm__getLibraryItemRequest(soap, (_ngwm__getLibraryItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsResponse:
		soap_serialize_PointerTo_ngwm__getJunkMailSettingsResponse(soap, (_ngwm__getJunkMailSettingsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getJunkMailSettingsRequest:
		soap_serialize_PointerTo_ngwm__getJunkMailSettingsRequest(soap, (_ngwm__getJunkMailSettingsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesResponse:
		soap_serialize_PointerTo_ngwm__getJunkEntriesResponse(soap, (_ngwm__getJunkEntriesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getJunkEntriesRequest:
		soap_serialize_PointerTo_ngwm__getJunkEntriesRequest(soap, (_ngwm__getJunkEntriesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getItemsResponse:
		soap_serialize_PointerTo_ngwm__getItemsResponse(soap, (_ngwm__getItemsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getItemsRequest:
		soap_serialize_PointerTo_ngwm__getItemsRequest(soap, (_ngwm__getItemsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getItemResponse:
		soap_serialize_PointerTo_ngwm__getItemResponse(soap, (_ngwm__getItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getItemRequest:
		soap_serialize_PointerTo_ngwm__getItemRequest(soap, (_ngwm__getItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyResponse:
		soap_serialize_PointerTo_ngwm__getFreeBusyResponse(soap, (_ngwm__getFreeBusyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFreeBusyRequest:
		soap_serialize_PointerTo_ngwm__getFreeBusyRequest(soap, (_ngwm__getFreeBusyRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFolderListResponse:
		soap_serialize_PointerTo_ngwm__getFolderListResponse(soap, (_ngwm__getFolderListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFolderListRequest:
		soap_serialize_PointerTo_ngwm__getFolderListRequest(soap, (_ngwm__getFolderListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFolderResponse:
		soap_serialize_PointerTo_ngwm__getFolderResponse(soap, (_ngwm__getFolderResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getFolderRequest:
		soap_serialize_PointerTo_ngwm__getFolderRequest(soap, (_ngwm__getFolderRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListResponse:
		soap_serialize_PointerTo_ngwm__getDocumentTypeListResponse(soap, (_ngwm__getDocumentTypeListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDocumentTypeListRequest:
		soap_serialize_PointerTo_ngwm__getDocumentTypeListRequest(soap, (_ngwm__getDocumentTypeListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoResponse:
		soap_serialize_PointerTo_ngwm__getDeltaInfoResponse(soap, (_ngwm__getDeltaInfoResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDeltaInfoRequest:
		soap_serialize_PointerTo_ngwm__getDeltaInfoRequest(soap, (_ngwm__getDeltaInfoRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDeltasResponse:
		soap_serialize_PointerTo_ngwm__getDeltasResponse(soap, (_ngwm__getDeltasResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getDeltasRequest:
		soap_serialize_PointerTo_ngwm__getDeltasRequest(soap, (_ngwm__getDeltasRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getCustomListResponse:
		soap_serialize_PointerTo_ngwm__getCustomListResponse(soap, (_ngwm__getCustomListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getCustomListRequest:
		soap_serialize_PointerTo_ngwm__getCustomListRequest(soap, (_ngwm__getCustomListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListResponse:
		soap_serialize_PointerTo_ngwm__getCategoryListResponse(soap, (_ngwm__getCategoryListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getCategoryListRequest:
		soap_serialize_PointerTo_ngwm__getCategoryListRequest(soap, (_ngwm__getCategoryListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentResponse:
		soap_serialize_PointerTo_ngwm__getAttachmentResponse(soap, (_ngwm__getAttachmentResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getAttachmentRequest:
		soap_serialize_PointerTo_ngwm__getAttachmentRequest(soap, (_ngwm__getAttachmentRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListResponse:
		soap_serialize_PointerTo_ngwm__getAddressBookListResponse(soap, (_ngwm__getAddressBookListResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__getAddressBookListRequest:
		soap_serialize_PointerTo_ngwm__getAddressBookListRequest(soap, (_ngwm__getAddressBookListRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__forwardResponse:
		soap_serialize_PointerTo_ngwm__forwardResponse(soap, (_ngwm__forwardResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__forwardRequest:
		soap_serialize_PointerTo_ngwm__forwardRequest(soap, (_ngwm__forwardRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__executeRuleResponse:
		soap_serialize_PointerTo_ngwm__executeRuleResponse(soap, (_ngwm__executeRuleResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__executeRuleRequest:
		soap_serialize_PointerTo_ngwm__executeRuleRequest(soap, (_ngwm__executeRuleRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorResponse:
		soap_serialize_PointerTo_ngwm__destroyCursorResponse(soap, (_ngwm__destroyCursorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__destroyCursorRequest:
		soap_serialize_PointerTo_ngwm__destroyCursorRequest(soap, (_ngwm__destroyCursorRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__delegateResponse:
		soap_serialize_PointerTo_ngwm__delegateResponse(soap, (_ngwm__delegateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__delegateRequest:
		soap_serialize_PointerTo_ngwm__delegateRequest(soap, (_ngwm__delegateRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__declineResponse:
		soap_serialize_PointerTo_ngwm__declineResponse(soap, (_ngwm__declineResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__declineRequest:
		soap_serialize_PointerTo_ngwm__declineRequest(soap, (_ngwm__declineRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createSignatureResponse:
		soap_serialize_PointerTo_ngwm__createSignatureResponse(soap, (_ngwm__createSignatureResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createSignatureRequest:
		soap_serialize_PointerTo_ngwm__createSignatureRequest(soap, (_ngwm__createSignatureRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessResponse:
		soap_serialize_PointerTo_ngwm__createProxyAccessResponse(soap, (_ngwm__createProxyAccessResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createProxyAccessRequest:
		soap_serialize_PointerTo_ngwm__createProxyAccessRequest(soap, (_ngwm__createProxyAccessRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryResponse:
		soap_serialize_PointerTo_ngwm__createJunkEntryResponse(soap, (_ngwm__createJunkEntryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createJunkEntryRequest:
		soap_serialize_PointerTo_ngwm__createJunkEntryRequest(soap, (_ngwm__createJunkEntryRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createItemsResponse:
		soap_serialize_PointerTo_ngwm__createItemsResponse(soap, (_ngwm__createItemsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createItemsRequest:
		soap_serialize_PointerTo_ngwm__createItemsRequest(soap, (_ngwm__createItemsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createItemResponse:
		soap_serialize_PointerTo_ngwm__createItemResponse(soap, (_ngwm__createItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createItemRequest:
		soap_serialize_PointerTo_ngwm__createItemRequest(soap, (_ngwm__createItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createCursorResponse:
		soap_serialize_PointerTo_ngwm__createCursorResponse(soap, (_ngwm__createCursorResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__createCursorRequest:
		soap_serialize_PointerTo_ngwm__createCursorRequest(soap, (_ngwm__createCursorRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__completeResponse:
		soap_serialize_PointerTo_ngwm__completeResponse(soap, (_ngwm__completeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__completeRequest:
		soap_serialize_PointerTo_ngwm__completeRequest(soap, (_ngwm__completeRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionResponse:
		soap_serialize_PointerTo_ngwm__closeFreeBusySessionResponse(soap, (_ngwm__closeFreeBusySessionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__closeFreeBusySessionRequest:
		soap_serialize_PointerTo_ngwm__closeFreeBusySessionRequest(soap, (_ngwm__closeFreeBusySessionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addMembersResponse:
		soap_serialize_PointerTo_ngwm__addMembersResponse(soap, (_ngwm__addMembersResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addMembersRequest:
		soap_serialize_PointerTo_ngwm__addMembersRequest(soap, (_ngwm__addMembersRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addItemsResponse:
		soap_serialize_PointerTo_ngwm__addItemsResponse(soap, (_ngwm__addItemsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addItemsRequest:
		soap_serialize_PointerTo_ngwm__addItemsRequest(soap, (_ngwm__addItemsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addItemResponse:
		soap_serialize_PointerTo_ngwm__addItemResponse(soap, (_ngwm__addItemResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__addItemRequest:
		soap_serialize_PointerTo_ngwm__addItemRequest(soap, (_ngwm__addItemRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__acceptShareResponse:
		soap_serialize_PointerTo_ngwm__acceptShareResponse(soap, (_ngwm__acceptShareResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__acceptShareRequest:
		soap_serialize_PointerTo_ngwm__acceptShareRequest(soap, (_ngwm__acceptShareRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__acceptResponse:
		soap_serialize_PointerTo_ngwm__acceptResponse(soap, (_ngwm__acceptResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ngwm__acceptRequest:
		soap_serialize_PointerTo_ngwm__acceptRequest(soap, (_ngwm__acceptRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Alarm:
		soap_serialize_PointerTongwt__Alarm(soap, (ngwt__Alarm *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PhoneFlags:
		soap_serialize_PointerTongwt__PhoneFlags(soap, (ngwt__PhoneFlags *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RecurrenceRule:
		soap_serialize_PointerTongwt__RecurrenceRule(soap, (ngwt__RecurrenceRule *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RecurrenceDateType:
		soap_serialize_PointerTongwt__RecurrenceDateType(soap, (ngwt__RecurrenceDateType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SMimeOperation:
		soap_serialize_PointerTongwt__SMimeOperation(soap, (ngwt__SMimeOperation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__LinkInfo:
		soap_serialize_PointerTongwt__LinkInfo(soap, (ngwt__LinkInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemOptions:
		soap_serialize_PointerTongwt__ItemOptions(soap, (ngwt__ItemOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AttachmentInfo:
		soap_serialize_PointerTongwt__AttachmentInfo(soap, (ngwt__AttachmentInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__MessageBody:
		soap_serialize_PointerTongwt__MessageBody(soap, (ngwt__MessageBody *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ReferenceInfo:
		soap_serialize_PointerTongwt__ReferenceInfo(soap, (ngwt__ReferenceInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PersonalInfo:
		soap_serialize_PointerTongwt__PersonalInfo(soap, (ngwt__PersonalInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__OfficeInfo:
		soap_serialize_PointerTongwt__OfficeInfo(soap, (ngwt__OfficeInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PostalAddressList:
		soap_serialize_PointerTongwt__PostalAddressList(soap, (ngwt__PostalAddressList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PhoneList:
		soap_serialize_PointerTongwt__PhoneList(soap, (ngwt__PhoneList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ImAddressList:
		soap_serialize_PointerTongwt__ImAddressList(soap, (ngwt__ImAddressList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__EmailAddressList:
		soap_serialize_PointerTongwt__EmailAddressList(soap, (ngwt__EmailAddressList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FullName:
		soap_serialize_PointerTongwt__FullName(soap, (ngwt__FullName *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__VersionStatus:
		soap_serialize_PointerTongwt__VersionStatus(soap, (enum ngwt__VersionStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FolderACL:
		soap_serialize_PointerTongwt__FolderACL(soap, (ngwt__FolderACL *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RuleActionList:
		soap_serialize_PointerTongwt__RuleActionList(soap, (ngwt__RuleActionList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Execution:
		soap_serialize_PointerTongwt__Execution(soap, (enum ngwt__Execution *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Query:
		soap_serialize_PointerTongwt__Query(soap, (ngwt__Query *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FolderACLStatus:
		soap_serialize_PointerTongwt__FolderACLStatus(soap, (enum ngwt__FolderACLStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessControlList:
		soap_serialize_PointerTongwt__AccessControlList(soap, (ngwt__AccessControlList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__WeekOfYear:
		soap_serialize_PointerTongwt__WeekOfYear(soap, (short *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__OccurrenceType:
		soap_serialize_PointerTongwt__OccurrenceType(soap, (enum ngwt__OccurrenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemSecurity:
		soap_serialize_PointerTongwt__ItemSecurity(soap, (enum ngwt__ItemSecurity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemClass:
		soap_serialize_PointerTongwt__ItemClass(soap, (enum ngwt__ItemClass *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemSource:
		soap_serialize_PointerTongwt__ItemSource(soap, (enum ngwt__ItemSource *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemStatus:
		soap_serialize_PointerTongwt__ItemStatus(soap, (ngwt__ItemStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DeltaSyncType:
		soap_serialize_PointerTongwt__DeltaSyncType(soap, (enum ngwt__DeltaSyncType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RecipientStatus:
		soap_serialize_PointerTongwt__RecipientStatus(soap, (ngwt__RecipientStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyBlockList:
		soap_serialize_PointerTongwt__FreeBusyBlockList(soap, (ngwt__FreeBusyBlockList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CalendarFolderAttribute:
		soap_serialize_PointerTongwt__CalendarFolderAttribute(soap, (ngwt__CalendarFolderAttribute *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FilterDate:
		soap_serialize_PointerTongwt__FilterDate(soap, (enum ngwt__FilterDate *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ContainerRef:
		soap_serialize_PointerTongwt__ContainerRef(soap, (ngwt__ContainerRef *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CategoryType:
		soap_serialize_PointerTongwt__CategoryType(soap, (enum ngwt__CategoryType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessMiscRight:
		soap_serialize_PointerTongwt__AccessMiscRight(soap, (ngwt__AccessMiscRight *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessRight:
		soap_serialize_PointerTongwt__AccessRight(soap, (ngwt__AccessRight *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Rights:
		soap_serialize_PointerTongwt__Rights(soap, (ngwt__Rights *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__EventList:
		soap_serialize_PointerTongwe__EventList(soap, (ngwe__EventList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__EventsList:
		soap_serialize_PointerTongwe__EventsList(soap, (ngwe__EventsList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__Events:
		soap_serialize_PointerTongwe__Events(soap, (ngwe__Events *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__EventDefinition:
		soap_serialize_PointerTongwe__EventDefinition(soap, (ngwe__EventDefinition *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__duration:
		soap_serialize_PointerToxsd__duration(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__Event:
		soap_serialize_PointerTongwe__Event(soap, (ngwe__Event *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__ContainerList:
		soap_serialize_PointerTongwe__ContainerList(soap, (ngwe__ContainerList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__ItemTypeList:
		soap_serialize_PointerTongwe__ItemTypeList(soap, (enum ngwe__ItemTypeList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__EventTypeList:
		soap_serialize_PointerTongwe__EventTypeList(soap, (ngwe__EventTypeList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__ItemType:
		soap_serialize_PointerTongwe__ItemType(soap, (enum ngwe__ItemType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwe__FieldList:
		soap_serialize_PointerTongwe__FieldList(soap, (enum ngwe__FieldList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyUserList:
		soap_serialize_PointerTongwt__FreeBusyUserList(soap, (ngwt__FreeBusyUserList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RetractType:
		soap_serialize_PointerTongwt__RetractType(soap, (enum ngwt__RetractType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemList:
		soap_serialize_PointerTongwt__ItemList(soap, (ngwt__ItemList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CursorSeek:
		soap_serialize_PointerTongwt__CursorSeek(soap, (enum ngwt__CursorSeek *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessRightChanges:
		soap_serialize_PointerTongwt__AccessRightChanges(soap, (ngwt__AccessRightChanges *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ModifyItem:
		soap_serialize_PointerTongwt__ModifyItem(soap, (ngwt__ModifyItem *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Host:
		soap_serialize_PointerTongwt__Host(soap, (ngwt__Host *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Authentication:
		soap_serialize_PointerTongwt__Authentication(soap, (ngwt__Authentication *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__UserList:
		soap_serialize_PointerTongwt__UserList(soap, (ngwt__UserList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__TimezoneList:
		soap_serialize_PointerTongwt__TimezoneList(soap, (ngwt__TimezoneList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Signatures:
		soap_serialize_PointerTongwt__Signatures(soap, (ngwt__Signatures *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Settings:
		soap_serialize_PointerTongwt__Settings(soap, (ngwt__Settings *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RuleList:
		soap_serialize_PointerTongwt__RuleList(soap, (ngwt__RuleList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ProxyList:
		soap_serialize_PointerTongwt__ProxyList(soap, (ngwt__ProxyList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessRightList:
		soap_serialize_PointerTongwt__AccessRightList(soap, (ngwt__AccessRightList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__LibraryList:
		soap_serialize_PointerTongwt__LibraryList(soap, (ngwt__LibraryList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SettingsList:
		soap_serialize_PointerTongwt__SettingsList(soap, (ngwt__SettingsList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__JunkHandlingList:
		soap_serialize_PointerTongwt__JunkHandlingList(soap, (ngwt__JunkHandlingList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyInfoList:
		soap_serialize_PointerTongwt__FreeBusyInfoList(soap, (ngwt__FreeBusyInfoList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyStats:
		soap_serialize_PointerTongwt__FreeBusyStats(soap, (ngwt__FreeBusyStats *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FolderList:
		soap_serialize_PointerTongwt__FolderList(soap, (ngwt__FolderList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemSourceList:
		soap_serialize_PointerTongwt__ItemSourceList(soap, (enum ngwt__ItemSourceList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__MessageTypeList:
		soap_serialize_PointerTongwt__MessageTypeList(soap, (enum ngwt__MessageTypeList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FolderType:
		soap_serialize_PointerTongwt__FolderType(soap, (enum ngwt__FolderType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DocumentTypeList:
		soap_serialize_PointerTongwt__DocumentTypeList(soap, (ngwt__DocumentTypeList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Items:
		soap_serialize_PointerTongwt__Items(soap, (ngwt__Items *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DeltaInfo:
		soap_serialize_PointerTongwt__DeltaInfo(soap, (ngwt__DeltaInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CustomList:
		soap_serialize_PointerTongwt__CustomList(soap, (ngwt__CustomList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CategoryList:
		soap_serialize_PointerTongwt__CategoryList(soap, (ngwt__CategoryList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AddressBookList:
		soap_serialize_PointerTongwt__AddressBookList(soap, (ngwt__AddressBookList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Distribution:
		soap_serialize_PointerTongwt__Distribution(soap, (ngwt__Distribution *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__View:
		soap_serialize_PointerTongwt__View(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Status:
		soap_serialize_PointerTongwt__Status(soap, (ngwt__Status *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemRefList:
		soap_serialize_PointerTongwt__ItemRefList(soap, (ngwt__ItemRefList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__UserInfo:
		soap_serialize_PointerTongwt__UserInfo(soap, (ngwt__UserInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RecipientType:
		soap_serialize_PointerTongwt__RecipientType(soap, (enum ngwt__RecipientType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Timezone:
		soap_serialize_PointerTongwt__Timezone(soap, (ngwt__Timezone *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Minute:
		soap_serialize_PointerTongwt__Minute(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Hour:
		soap_serialize_PointerTongwt__Hour(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DayOfWeek:
		soap_serialize_PointerTongwt__DayOfWeek(soap, (ngwt__DayOfWeek *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Day:
		soap_serialize_PointerTongwt__Day(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Month:
		soap_serialize_PointerTongwt__Month(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__TimezoneComponent:
		soap_serialize_PointerTongwt__TimezoneComponent(soap, (ngwt__TimezoneComponent *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ProblemList:
		soap_serialize_PointerTongwt__ProblemList(soap, (ngwt__ProblemList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Signature:
		soap_serialize_PointerTongwt__Signature(soap, (ngwt__Signature *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SignatureData:
		soap_serialize_PointerTongwt__SignatureData(soap, (ngwt__SignatureData *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SettingsGroup:
		soap_serialize_PointerTongwt__SettingsGroup(soap, (ngwt__SettingsGroup *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ReturnNotification:
		soap_serialize_PointerTongwt__ReturnNotification(soap, (ngwt__ReturnNotification *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__StatusTracking:
		soap_serialize_PointerTongwt__StatusTracking(soap, (ngwt__StatusTracking *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SendOptionsRequestReply:
		soap_serialize_PointerTongwt__SendOptionsRequestReply(soap, (ngwt__SendOptionsRequestReply *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Rule:
		soap_serialize_PointerTongwt__Rule(soap, (ngwt__Rule *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RuleAction:
		soap_serialize_PointerTongwt__RuleAction(soap, (ngwt__RuleAction *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CategoryRefList:
		soap_serialize_PointerTongwt__CategoryRefList(soap, (ngwt__CategoryRefList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Mail:
		soap_serialize_PointerTongwt__Mail(soap, (ngwt__Mail *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ReturnNotificationOptions:
		soap_serialize_PointerTongwt__ReturnNotificationOptions(soap, (ngwt__ReturnNotificationOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__MonthList:
		soap_serialize_PointerTongwt__MonthList(soap, (ngwt__MonthList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DayOfYearList:
		soap_serialize_PointerTongwt__DayOfYearList(soap, (ngwt__DayOfYearList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DayOfMonthList:
		soap_serialize_PointerTongwt__DayOfMonthList(soap, (ngwt__DayOfMonthList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DayOfYearWeekList:
		soap_serialize_PointerTongwt__DayOfYearWeekList(soap, (ngwt__DayOfYearWeekList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Frequency:
		soap_serialize_PointerTongwt__Frequency(soap, (enum ngwt__Frequency *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DelegateeStatus:
		soap_serialize_PointerTongwt__DelegateeStatus(soap, (ngwt__DelegateeStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DelegatedStatus:
		soap_serialize_PointerTongwt__DelegatedStatus(soap, (ngwt__DelegatedStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CommentStatus:
		soap_serialize_PointerTongwt__CommentStatus(soap, (ngwt__CommentStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__TransferFailedStatus:
		soap_serialize_PointerTongwt__TransferFailedStatus(soap, (ngwt__TransferFailedStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Recipient:
		soap_serialize_PointerTongwt__Recipient(soap, (ngwt__Recipient *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Filter:
		soap_serialize_PointerTongwt__Filter(soap, (ngwt__Filter *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__QueryTarget:
		soap_serialize_PointerTongwt__QueryTarget(soap, (ngwt__QueryTarget *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ProxyUser:
		soap_serialize_PointerTongwt__ProxyUser(soap, (ngwt__ProxyUser *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ProblemEntry:
		soap_serialize_PointerTongwt__ProblemEntry(soap, (ngwt__ProblemEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PostalAddress:
		soap_serialize_PointerTongwt__PostalAddress(soap, (ngwt__PostalAddress *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__PhoneNumber:
		soap_serialize_PointerTongwt__PhoneNumber(soap, (ngwt__PhoneNumber *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__date:
		soap_serialize_PointerToxsd__date(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemRef:
		soap_serialize_PointerTongwt__ItemRef(soap, (ngwt__ItemRef *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__UUID:
		soap_serialize_PointerTongwt__UUID(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SharedFolderNotification:
		soap_serialize_PointerTongwt__SharedFolderNotification(soap, (ngwt__SharedFolderNotification *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__MessagePart:
		soap_serialize_PointerTongwt__MessagePart(soap, (ngwt__MessagePart *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Library:
		soap_serialize_PointerTongwt__Library(soap, (ngwt__Library *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__JunkEntry:
		soap_serialize_PointerTongwt__JunkEntry(soap, (ngwt__JunkEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__JunkHandlingListType:
		soap_serialize_PointerTongwt__JunkHandlingListType(soap, (enum ngwt__JunkHandlingListType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Item:
		soap_serialize_PointerTongwt__Item(soap, (ngwt__Item *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ItemChanges:
		soap_serialize_PointerTongwt__ItemChanges(soap, (ngwt__ItemChanges *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__ImAddress:
		soap_serialize_PointerTongwt__ImAddress(soap, (ngwt__ImAddress *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__GroupMember:
		soap_serialize_PointerTongwt__GroupMember(soap, (ngwt__GroupMember *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__GroupMemberList:
		soap_serialize_PointerTongwt__GroupMemberList(soap, (ngwt__GroupMemberList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyInfo:
		soap_serialize_PointerTongwt__FreeBusyInfo(soap, (ngwt__FreeBusyInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__NameAndEmail:
		soap_serialize_PointerTongwt__NameAndEmail(soap, (ngwt__NameAndEmail *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AcceptLevel:
		soap_serialize_PointerTongwt__AcceptLevel(soap, (enum ngwt__AcceptLevel *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FreeBusyBlock:
		soap_serialize_PointerTongwt__FreeBusyBlock(soap, (ngwt__FreeBusyBlock *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Folder:
		soap_serialize_PointerTongwt__Folder(soap, (ngwt__Folder *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FolderACLEntry:
		soap_serialize_PointerTongwt__FolderACLEntry(soap, (ngwt__FolderACLEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__FilterElement:
		soap_serialize_PointerTongwt__FilterElement(soap, (ngwt__FilterElement *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DocumentType:
		soap_serialize_PointerTongwt__DocumentType(soap, (ngwt__DocumentType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AgeAction:
		soap_serialize_PointerTongwt__AgeAction(soap, (enum ngwt__AgeAction *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__SendOptions:
		soap_serialize_PointerTongwt__SendOptions(soap, (ngwt__SendOptions *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__RecipientList:
		soap_serialize_PointerTongwt__RecipientList(soap, (ngwt__RecipientList *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__From:
		soap_serialize_PointerTongwt__From(soap, (ngwt__From *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__DayOfYearWeek:
		soap_serialize_PointerTongwt__DayOfYearWeek(soap, (ngwt__DayOfYearWeek *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Custom:
		soap_serialize_PointerTongwt__Custom(soap, (ngwt__Custom *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__CustomType:
		soap_serialize_PointerTongwt__CustomType(soap, (enum ngwt__CustomType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__uid:
		soap_serialize_PointerTongwt__uid(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__Category:
		soap_serialize_PointerTongwt__Category(soap, (ngwt__Category *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedLong:
		soap_serialize_PointerTounsignedLong(soap, (unsigned long *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AttachmentID:
		soap_serialize_PointerTongwt__AttachmentID(soap, (ngwt__AttachmentID *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AttachmentItemInfo:
		soap_serialize_PointerTongwt__AttachmentItemInfo(soap, (ngwt__AttachmentItemInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AddressBook:
		soap_serialize_PointerTongwt__AddressBook(soap, (ngwt__AddressBook *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessRightEntry:
		soap_serialize_PointerTongwt__AccessRightEntry(soap, (ngwt__AccessRightEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerTongwt__AccessControlListEntry:
		soap_serialize_PointerTongwt__AccessControlListEntry(soap, (ngwt__AccessControlListEntry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__TQName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_xsd__base64Binary:
		return (void*)soap_instantiate_xsd__base64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessControlList:
		return (void*)soap_instantiate_ngwt__AccessControlList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessMiscRight:
		return (void*)soap_instantiate_ngwt__AccessMiscRight(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessRight:
		return (void*)soap_instantiate_ngwt__AccessRight(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessRightChanges:
		return (void*)soap_instantiate_ngwt__AccessRightChanges(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessRightList:
		return (void*)soap_instantiate_ngwt__AccessRightList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AddressBookList:
		return (void*)soap_instantiate_ngwt__AddressBookList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AttachmentInfo:
		return (void*)soap_instantiate_ngwt__AttachmentInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AttachmentItemInfo:
		return (void*)soap_instantiate_ngwt__AttachmentItemInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Authentication:
		return (void*)soap_instantiate_ngwt__Authentication(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CalendarFolderAttribute:
		return (void*)soap_instantiate_ngwt__CalendarFolderAttribute(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CategoryList:
		return (void*)soap_instantiate_ngwt__CategoryList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CategoryRefList:
		return (void*)soap_instantiate_ngwt__CategoryRefList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Custom:
		return (void*)soap_instantiate_ngwt__Custom(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CustomList:
		return (void*)soap_instantiate_ngwt__CustomList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DayOfMonthList:
		return (void*)soap_instantiate_ngwt__DayOfMonthList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DayOfYearList:
		return (void*)soap_instantiate_ngwt__DayOfYearList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DayOfYearWeekList:
		return (void*)soap_instantiate_ngwt__DayOfYearWeekList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DeltaInfo:
		return (void*)soap_instantiate_ngwt__DeltaInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Distribution:
		return (void*)soap_instantiate_ngwt__Distribution(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DocumentType:
		return (void*)soap_instantiate_ngwt__DocumentType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DocumentTypeList:
		return (void*)soap_instantiate_ngwt__DocumentTypeList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__EmailAddressList:
		return (void*)soap_instantiate_ngwt__EmailAddressList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Filter:
		return (void*)soap_instantiate_ngwt__Filter(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FilterElement:
		return (void*)soap_instantiate_ngwt__FilterElement(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FolderACL:
		return (void*)soap_instantiate_ngwt__FolderACL(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FolderList:
		return (void*)soap_instantiate_ngwt__FolderList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyBlockList:
		return (void*)soap_instantiate_ngwt__FreeBusyBlockList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyBlock:
		return (void*)soap_instantiate_ngwt__FreeBusyBlock(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyUserList:
		return (void*)soap_instantiate_ngwt__FreeBusyUserList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyInfoList:
		return (void*)soap_instantiate_ngwt__FreeBusyInfoList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyStats:
		return (void*)soap_instantiate_ngwt__FreeBusyStats(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FullName:
		return (void*)soap_instantiate_ngwt__FullName(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__GroupMember:
		return (void*)soap_instantiate_ngwt__GroupMember(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__GroupMemberList:
		return (void*)soap_instantiate_ngwt__GroupMemberList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Host:
		return (void*)soap_instantiate_ngwt__Host(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ImAddress:
		return (void*)soap_instantiate_ngwt__ImAddress(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ImAddressList:
		return (void*)soap_instantiate_ngwt__ImAddressList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Item:
		return (void*)soap_instantiate_ngwt__Item(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemChanges:
		return (void*)soap_instantiate_ngwt__ItemChanges(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemList:
		return (void*)soap_instantiate_ngwt__ItemList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemOptions:
		return (void*)soap_instantiate_ngwt__ItemOptions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemRefList:
		return (void*)soap_instantiate_ngwt__ItemRefList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Items:
		return (void*)soap_instantiate_ngwt__Items(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemStatus:
		return (void*)soap_instantiate_ngwt__ItemStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__JunkEntry:
		return (void*)soap_instantiate_ngwt__JunkEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__JunkHandlingList:
		return (void*)soap_instantiate_ngwt__JunkHandlingList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__LibraryList:
		return (void*)soap_instantiate_ngwt__LibraryList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__LinkInfo:
		return (void*)soap_instantiate_ngwt__LinkInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__MessageBody:
		return (void*)soap_instantiate_ngwt__MessageBody(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ModifyItem:
		return (void*)soap_instantiate_ngwt__ModifyItem(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__MonthList:
		return (void*)soap_instantiate_ngwt__MonthList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__NameAndEmail:
		return (void*)soap_instantiate_ngwt__NameAndEmail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__OfficeInfo:
		return (void*)soap_instantiate_ngwt__OfficeInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PersonalInfo:
		return (void*)soap_instantiate_ngwt__PersonalInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PhoneFlags:
		return (void*)soap_instantiate_ngwt__PhoneFlags(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PhoneList:
		return (void*)soap_instantiate_ngwt__PhoneList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PostalAddress:
		return (void*)soap_instantiate_ngwt__PostalAddress(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PostalAddressList:
		return (void*)soap_instantiate_ngwt__PostalAddressList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ProblemEntry:
		return (void*)soap_instantiate_ngwt__ProblemEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ProblemList:
		return (void*)soap_instantiate_ngwt__ProblemList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ProxyList:
		return (void*)soap_instantiate_ngwt__ProxyList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Query:
		return (void*)soap_instantiate_ngwt__Query(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__QueryTarget:
		return (void*)soap_instantiate_ngwt__QueryTarget(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RecipientList:
		return (void*)soap_instantiate_ngwt__RecipientList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RecipientStatus:
		return (void*)soap_instantiate_ngwt__RecipientStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RecurrenceDateType:
		return (void*)soap_instantiate_ngwt__RecurrenceDateType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RecurrenceRule:
		return (void*)soap_instantiate_ngwt__RecurrenceRule(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ReferenceInfo:
		return (void*)soap_instantiate_ngwt__ReferenceInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ReturnNotification:
		return (void*)soap_instantiate_ngwt__ReturnNotification(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ReturnNotificationOptions:
		return (void*)soap_instantiate_ngwt__ReturnNotificationOptions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Rights:
		return (void*)soap_instantiate_ngwt__Rights(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RuleAction:
		return (void*)soap_instantiate_ngwt__RuleAction(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RuleActionList:
		return (void*)soap_instantiate_ngwt__RuleActionList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__RuleList:
		return (void*)soap_instantiate_ngwt__RuleList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SendOptionsRequestReply:
		return (void*)soap_instantiate_ngwt__SendOptionsRequestReply(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SendOptions:
		return (void*)soap_instantiate_ngwt__SendOptions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Settings:
		return (void*)soap_instantiate_ngwt__Settings(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SettingsGroup:
		return (void*)soap_instantiate_ngwt__SettingsGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SettingsList:
		return (void*)soap_instantiate_ngwt__SettingsList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SharedFolderNotification:
		return (void*)soap_instantiate_ngwt__SharedFolderNotification(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Signature:
		return (void*)soap_instantiate_ngwt__Signature(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Signatures:
		return (void*)soap_instantiate_ngwt__Signatures(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SignatureData:
		return (void*)soap_instantiate_ngwt__SignatureData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SMimeOperation:
		return (void*)soap_instantiate_ngwt__SMimeOperation(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Status:
		return (void*)soap_instantiate_ngwt__Status(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Timezone:
		return (void*)soap_instantiate_ngwt__Timezone(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__TimezoneComponent:
		return (void*)soap_instantiate_ngwt__TimezoneComponent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__TimezoneList:
		return (void*)soap_instantiate_ngwt__TimezoneList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__UserInfo:
		return (void*)soap_instantiate_ngwt__UserInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__UserList:
		return (void*)soap_instantiate_ngwt__UserList(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__acceptRequest:
		return (void*)soap_instantiate__ngwm__acceptRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__acceptResponse:
		return (void*)soap_instantiate__ngwm__acceptResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__acceptShareRequest:
		return (void*)soap_instantiate__ngwm__acceptShareRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__acceptShareResponse:
		return (void*)soap_instantiate__ngwm__acceptShareResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addItemRequest:
		return (void*)soap_instantiate__ngwm__addItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addItemResponse:
		return (void*)soap_instantiate__ngwm__addItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addItemsRequest:
		return (void*)soap_instantiate__ngwm__addItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addItemsResponse:
		return (void*)soap_instantiate__ngwm__addItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addMembersRequest:
		return (void*)soap_instantiate__ngwm__addMembersRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__addMembersResponse:
		return (void*)soap_instantiate__ngwm__addMembersResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__closeFreeBusySessionRequest:
		return (void*)soap_instantiate__ngwm__closeFreeBusySessionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__closeFreeBusySessionResponse:
		return (void*)soap_instantiate__ngwm__closeFreeBusySessionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__completeRequest:
		return (void*)soap_instantiate__ngwm__completeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__completeResponse:
		return (void*)soap_instantiate__ngwm__completeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createCursorRequest:
		return (void*)soap_instantiate__ngwm__createCursorRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createCursorResponse:
		return (void*)soap_instantiate__ngwm__createCursorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createItemRequest:
		return (void*)soap_instantiate__ngwm__createItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createItemResponse:
		return (void*)soap_instantiate__ngwm__createItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createItemsRequest:
		return (void*)soap_instantiate__ngwm__createItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createItemsResponse:
		return (void*)soap_instantiate__ngwm__createItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createJunkEntryRequest:
		return (void*)soap_instantiate__ngwm__createJunkEntryRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createJunkEntryResponse:
		return (void*)soap_instantiate__ngwm__createJunkEntryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createProxyAccessRequest:
		return (void*)soap_instantiate__ngwm__createProxyAccessRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createProxyAccessResponse:
		return (void*)soap_instantiate__ngwm__createProxyAccessResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createSignatureRequest:
		return (void*)soap_instantiate__ngwm__createSignatureRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__createSignatureResponse:
		return (void*)soap_instantiate__ngwm__createSignatureResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__declineRequest:
		return (void*)soap_instantiate__ngwm__declineRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__declineResponse:
		return (void*)soap_instantiate__ngwm__declineResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__delegateRequest:
		return (void*)soap_instantiate__ngwm__delegateRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__delegateResponse:
		return (void*)soap_instantiate__ngwm__delegateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__destroyCursorRequest:
		return (void*)soap_instantiate__ngwm__destroyCursorRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__destroyCursorResponse:
		return (void*)soap_instantiate__ngwm__destroyCursorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__executeRuleRequest:
		return (void*)soap_instantiate__ngwm__executeRuleRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__executeRuleResponse:
		return (void*)soap_instantiate__ngwm__executeRuleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__forwardRequest:
		return (void*)soap_instantiate__ngwm__forwardRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__forwardResponse:
		return (void*)soap_instantiate__ngwm__forwardResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getAddressBookListRequest:
		return (void*)soap_instantiate__ngwm__getAddressBookListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getAddressBookListResponse:
		return (void*)soap_instantiate__ngwm__getAddressBookListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getAttachmentRequest:
		return (void*)soap_instantiate__ngwm__getAttachmentRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getAttachmentResponse:
		return (void*)soap_instantiate__ngwm__getAttachmentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getCategoryListRequest:
		return (void*)soap_instantiate__ngwm__getCategoryListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getCategoryListResponse:
		return (void*)soap_instantiate__ngwm__getCategoryListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getCustomListRequest:
		return (void*)soap_instantiate__ngwm__getCustomListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getCustomListResponse:
		return (void*)soap_instantiate__ngwm__getCustomListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDeltasRequest:
		return (void*)soap_instantiate__ngwm__getDeltasRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDeltasResponse:
		return (void*)soap_instantiate__ngwm__getDeltasResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDeltaInfoRequest:
		return (void*)soap_instantiate__ngwm__getDeltaInfoRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDeltaInfoResponse:
		return (void*)soap_instantiate__ngwm__getDeltaInfoResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDocumentTypeListRequest:
		return (void*)soap_instantiate__ngwm__getDocumentTypeListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getDocumentTypeListResponse:
		return (void*)soap_instantiate__ngwm__getDocumentTypeListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFolderRequest:
		return (void*)soap_instantiate__ngwm__getFolderRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFolderResponse:
		return (void*)soap_instantiate__ngwm__getFolderResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFolderListRequest:
		return (void*)soap_instantiate__ngwm__getFolderListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFolderListResponse:
		return (void*)soap_instantiate__ngwm__getFolderListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFreeBusyRequest:
		return (void*)soap_instantiate__ngwm__getFreeBusyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getFreeBusyResponse:
		return (void*)soap_instantiate__ngwm__getFreeBusyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getItemRequest:
		return (void*)soap_instantiate__ngwm__getItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getItemResponse:
		return (void*)soap_instantiate__ngwm__getItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getItemsRequest:
		return (void*)soap_instantiate__ngwm__getItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getItemsResponse:
		return (void*)soap_instantiate__ngwm__getItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getJunkEntriesRequest:
		return (void*)soap_instantiate__ngwm__getJunkEntriesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getJunkEntriesResponse:
		return (void*)soap_instantiate__ngwm__getJunkEntriesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getJunkMailSettingsRequest:
		return (void*)soap_instantiate__ngwm__getJunkMailSettingsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getJunkMailSettingsResponse:
		return (void*)soap_instantiate__ngwm__getJunkMailSettingsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getLibraryItemRequest:
		return (void*)soap_instantiate__ngwm__getLibraryItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getLibraryItemResponse:
		return (void*)soap_instantiate__ngwm__getLibraryItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getLibraryListRequest:
		return (void*)soap_instantiate__ngwm__getLibraryListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getLibraryListResponse:
		return (void*)soap_instantiate__ngwm__getLibraryListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getQuickMessagesRequest:
		return (void*)soap_instantiate__ngwm__getQuickMessagesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getQuickMessagesResponse:
		return (void*)soap_instantiate__ngwm__getQuickMessagesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getProxyAccessListRequest:
		return (void*)soap_instantiate__ngwm__getProxyAccessListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getProxyAccessListResponse:
		return (void*)soap_instantiate__ngwm__getProxyAccessListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getProxyListRequest:
		return (void*)soap_instantiate__ngwm__getProxyListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getProxyListResponse:
		return (void*)soap_instantiate__ngwm__getProxyListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getRuleListRequest:
		return (void*)soap_instantiate__ngwm__getRuleListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getRuleListResponse:
		return (void*)soap_instantiate__ngwm__getRuleListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getSettingsRequest:
		return (void*)soap_instantiate__ngwm__getSettingsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getSettingsResponse:
		return (void*)soap_instantiate__ngwm__getSettingsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getSignaturesRequest:
		return (void*)soap_instantiate__ngwm__getSignaturesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getSignaturesResponse:
		return (void*)soap_instantiate__ngwm__getSignaturesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getTimestampRequest:
		return (void*)soap_instantiate__ngwm__getTimestampRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getTimestampResponse:
		return (void*)soap_instantiate__ngwm__getTimestampResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getTimezoneListRequest:
		return (void*)soap_instantiate__ngwm__getTimezoneListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getTimezoneListResponse:
		return (void*)soap_instantiate__ngwm__getTimezoneListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getUserListRequest:
		return (void*)soap_instantiate__ngwm__getUserListRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__getUserListResponse:
		return (void*)soap_instantiate__ngwm__getUserListResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__loginRequest:
		return (void*)soap_instantiate__ngwm__loginRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__loginResponse:
		return (void*)soap_instantiate__ngwm__loginResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__logoutRequest:
		return (void*)soap_instantiate__ngwm__logoutRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__logoutResponse:
		return (void*)soap_instantiate__ngwm__logoutResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markPrivateRequest:
		return (void*)soap_instantiate__ngwm__markPrivateRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markPrivateResponse:
		return (void*)soap_instantiate__ngwm__markPrivateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markReadRequest:
		return (void*)soap_instantiate__ngwm__markReadRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markReadResponse:
		return (void*)soap_instantiate__ngwm__markReadResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markUnPrivateRequest:
		return (void*)soap_instantiate__ngwm__markUnPrivateRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markUnPrivateResponse:
		return (void*)soap_instantiate__ngwm__markUnPrivateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markUnReadRequest:
		return (void*)soap_instantiate__ngwm__markUnReadRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__markUnReadResponse:
		return (void*)soap_instantiate__ngwm__markUnReadResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyItemRequest:
		return (void*)soap_instantiate__ngwm__modifyItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyItemResponse:
		return (void*)soap_instantiate__ngwm__modifyItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyItemsRequest:
		return (void*)soap_instantiate__ngwm__modifyItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyItemsResponse:
		return (void*)soap_instantiate__ngwm__modifyItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyJunkEntryRequest:
		return (void*)soap_instantiate__ngwm__modifyJunkEntryRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyJunkEntryResponse:
		return (void*)soap_instantiate__ngwm__modifyJunkEntryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest:
		return (void*)soap_instantiate__ngwm__modifyJunkMailSettingsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse:
		return (void*)soap_instantiate__ngwm__modifyJunkMailSettingsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyPasswordRequest:
		return (void*)soap_instantiate__ngwm__modifyPasswordRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyPasswordResponse:
		return (void*)soap_instantiate__ngwm__modifyPasswordResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyProxyAccessRequest:
		return (void*)soap_instantiate__ngwm__modifyProxyAccessRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifyProxyAccessResponse:
		return (void*)soap_instantiate__ngwm__modifyProxyAccessResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifySettingsRequest:
		return (void*)soap_instantiate__ngwm__modifySettingsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifySettingsResponse:
		return (void*)soap_instantiate__ngwm__modifySettingsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifySignaturesRequest:
		return (void*)soap_instantiate__ngwm__modifySignaturesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__modifySignaturesResponse:
		return (void*)soap_instantiate__ngwm__modifySignaturesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__moveItemRequest:
		return (void*)soap_instantiate__ngwm__moveItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__moveItemResponse:
		return (void*)soap_instantiate__ngwm__moveItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__positionCursorRequest:
		return (void*)soap_instantiate__ngwm__positionCursorRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__positionCursorResponse:
		return (void*)soap_instantiate__ngwm__positionCursorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__purgeDeletedItemsRequest:
		return (void*)soap_instantiate__ngwm__purgeDeletedItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__purgeDeletedItemsResponse:
		return (void*)soap_instantiate__ngwm__purgeDeletedItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__purgeRequest:
		return (void*)soap_instantiate__ngwm__purgeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__purgeResponse:
		return (void*)soap_instantiate__ngwm__purgeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__readCursorRequest:
		return (void*)soap_instantiate__ngwm__readCursorRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__readCursorResponse:
		return (void*)soap_instantiate__ngwm__readCursorResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeCustomDefinitionRequest:
		return (void*)soap_instantiate__ngwm__removeCustomDefinitionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeCustomDefinitionResponse:
		return (void*)soap_instantiate__ngwm__removeCustomDefinitionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeItemRequest:
		return (void*)soap_instantiate__ngwm__removeItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeItemResponse:
		return (void*)soap_instantiate__ngwm__removeItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeItemsRequest:
		return (void*)soap_instantiate__ngwm__removeItemsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeItemsResponse:
		return (void*)soap_instantiate__ngwm__removeItemsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeJunkEntryRequest:
		return (void*)soap_instantiate__ngwm__removeJunkEntryRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeJunkEntryResponse:
		return (void*)soap_instantiate__ngwm__removeJunkEntryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeMembersRequest:
		return (void*)soap_instantiate__ngwm__removeMembersRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeMembersResponse:
		return (void*)soap_instantiate__ngwm__removeMembersResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeProxyAccessRequest:
		return (void*)soap_instantiate__ngwm__removeProxyAccessRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeProxyAccessResponse:
		return (void*)soap_instantiate__ngwm__removeProxyAccessResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeProxyUserRequest:
		return (void*)soap_instantiate__ngwm__removeProxyUserRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeProxyUserResponse:
		return (void*)soap_instantiate__ngwm__removeProxyUserResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeSignatureRequest:
		return (void*)soap_instantiate__ngwm__removeSignatureRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__removeSignatureResponse:
		return (void*)soap_instantiate__ngwm__removeSignatureResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__replyRequest:
		return (void*)soap_instantiate__ngwm__replyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__replyResponse:
		return (void*)soap_instantiate__ngwm__replyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__retractRequest:
		return (void*)soap_instantiate__ngwm__retractRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__retractResponse:
		return (void*)soap_instantiate__ngwm__retractResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__sendItemRequest:
		return (void*)soap_instantiate__ngwm__sendItemRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__sendItemResponse:
		return (void*)soap_instantiate__ngwm__sendItemResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__setTimestampRequest:
		return (void*)soap_instantiate__ngwm__setTimestampRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__setTimestampResponse:
		return (void*)soap_instantiate__ngwm__setTimestampResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__startFreeBusySessionRequest:
		return (void*)soap_instantiate__ngwm__startFreeBusySessionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__startFreeBusySessionResponse:
		return (void*)soap_instantiate__ngwm__startFreeBusySessionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__unacceptRequest:
		return (void*)soap_instantiate__ngwm__unacceptRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__unacceptResponse:
		return (void*)soap_instantiate__ngwm__unacceptResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__uncompleteRequest:
		return (void*)soap_instantiate__ngwm__uncompleteRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__uncompleteResponse:
		return (void*)soap_instantiate__ngwm__uncompleteResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__updateVersionStatusRequest:
		return (void*)soap_instantiate__ngwm__updateVersionStatusRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwm__updateVersionStatusResponse:
		return (void*)soap_instantiate__ngwm__updateVersionStatusResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__ContainerList:
		return (void*)soap_instantiate_ngwe__ContainerList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__Event:
		return (void*)soap_instantiate_ngwe__Event(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__EventDefinition:
		return (void*)soap_instantiate_ngwe__EventDefinition(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__EventList:
		return (void*)soap_instantiate_ngwe__EventList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__Events:
		return (void*)soap_instantiate_ngwe__Events(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__EventsList:
		return (void*)soap_instantiate_ngwe__EventsList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__EventTypeList:
		return (void*)soap_instantiate_ngwe__EventTypeList(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwe__Notify:
		return (void*)soap_instantiate_ngwe__Notify(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__cleanEventConfigurationRequest:
		return (void*)soap_instantiate__ngwe__cleanEventConfigurationRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__cleanEventConfigurationResponse:
		return (void*)soap_instantiate__ngwe__cleanEventConfigurationResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__configureEventsRequest:
		return (void*)soap_instantiate__ngwe__configureEventsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__configureEventsResponse:
		return (void*)soap_instantiate__ngwe__configureEventsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__getEventConfigurationRequest:
		return (void*)soap_instantiate__ngwe__getEventConfigurationRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__getEventConfigurationResponse:
		return (void*)soap_instantiate__ngwe__getEventConfigurationResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__getEventsRequest:
		return (void*)soap_instantiate__ngwe__getEventsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__getEventsResponse:
		return (void*)soap_instantiate__ngwe__getEventsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__removeEventConfigurationRequest:
		return (void*)soap_instantiate__ngwe__removeEventConfigurationRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__removeEventConfigurationResponse:
		return (void*)soap_instantiate__ngwe__removeEventConfigurationResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__removeEventsRequest:
		return (void*)soap_instantiate__ngwe__removeEventsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ngwe__removeEventsResponse:
		return (void*)soap_instantiate__ngwe__removeEventsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessControlListEntry:
		return (void*)soap_instantiate_ngwt__AccessControlListEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AccessRightEntry:
		return (void*)soap_instantiate_ngwt__AccessRightEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AddressBook:
		return (void*)soap_instantiate_ngwt__AddressBook(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Alarm:
		return (void*)soap_instantiate_ngwt__Alarm(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Category:
		return (void*)soap_instantiate_ngwt__Category(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CommentStatus:
		return (void*)soap_instantiate_ngwt__CommentStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ContainerItem:
		return (void*)soap_instantiate_ngwt__ContainerItem(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ContainerRef:
		return (void*)soap_instantiate_ngwt__ContainerRef(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DelegatedStatus:
		return (void*)soap_instantiate_ngwt__DelegatedStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DelegateeStatus:
		return (void*)soap_instantiate_ngwt__DelegateeStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FilterEntry:
		return (void*)soap_instantiate_ngwt__FilterEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FilterGroup:
		return (void*)soap_instantiate_ngwt__FilterGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Folder:
		return (void*)soap_instantiate_ngwt__Folder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FreeBusyInfo:
		return (void*)soap_instantiate_ngwt__FreeBusyInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__From:
		return (void*)soap_instantiate_ngwt__From(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ItemRef:
		return (void*)soap_instantiate_ngwt__ItemRef(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Library:
		return (void*)soap_instantiate_ngwt__Library(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__MessagePart:
		return (void*)soap_instantiate_ngwt__MessagePart(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PhoneNumber:
		return (void*)soap_instantiate_ngwt__PhoneNumber(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PlainText:
		return (void*)soap_instantiate_ngwt__PlainText(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Proxy:
		return (void*)soap_instantiate_ngwt__Proxy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ProxyUser:
		return (void*)soap_instantiate_ngwt__ProxyUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Recipient:
		return (void*)soap_instantiate_ngwt__Recipient(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__TransferFailedStatus:
		return (void*)soap_instantiate_ngwt__TransferFailedStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__TrustedApplication:
		return (void*)soap_instantiate_ngwt__TrustedApplication(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AddressBookItem:
		return (void*)soap_instantiate_ngwt__AddressBookItem(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__AttachmentID:
		return (void*)soap_instantiate_ngwt__AttachmentID(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__BoxEntry:
		return (void*)soap_instantiate_ngwt__BoxEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DayOfWeek:
		return (void*)soap_instantiate_ngwt__DayOfWeek(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DayOfYearWeek:
		return (void*)soap_instantiate_ngwt__DayOfYearWeek(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Document:
		return (void*)soap_instantiate_ngwt__Document(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__FolderACLEntry:
		return (void*)soap_instantiate_ngwt__FolderACLEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__QueryFolder:
		return (void*)soap_instantiate_ngwt__QueryFolder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Rule:
		return (void*)soap_instantiate_ngwt__Rule(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SharedFolder:
		return (void*)soap_instantiate_ngwt__SharedFolder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__StatusTracking:
		return (void*)soap_instantiate_ngwt__StatusTracking(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SystemFolder:
		return (void*)soap_instantiate_ngwt__SystemFolder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Version:
		return (void*)soap_instantiate_ngwt__Version(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__VersionEvent:
		return (void*)soap_instantiate_ngwt__VersionEvent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Contact:
		return (void*)soap_instantiate_ngwt__Contact(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__ContactFolder:
		return (void*)soap_instantiate_ngwt__ContactFolder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Group:
		return (void*)soap_instantiate_ngwt__Group(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Mail:
		return (void*)soap_instantiate_ngwt__Mail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Organization:
		return (void*)soap_instantiate_ngwt__Organization(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Resource:
		return (void*)soap_instantiate_ngwt__Resource(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__CalendarItem:
		return (void*)soap_instantiate_ngwt__CalendarItem(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__DocumentRef:
		return (void*)soap_instantiate_ngwt__DocumentRef(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__PhoneMessage:
		return (void*)soap_instantiate_ngwt__PhoneMessage(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__SharedNotification:
		return (void*)soap_instantiate_ngwt__SharedNotification(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Appointment:
		return (void*)soap_instantiate_ngwt__Appointment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Note:
		return (void*)soap_instantiate_ngwt__Note(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__Task:
		return (void*)soap_instantiate_ngwt__Task(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__date:
		return (void*)soap_instantiate_xsd__date(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__decimal:
		return (void*)soap_instantiate_xsd__decimal(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__duration:
		return (void*)soap_instantiate_xsd__duration(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__language:
		return (void*)soap_instantiate_xsd__language(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__View:
		return (void*)soap_instantiate_ngwt__View(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__uid:
		return (void*)soap_instantiate_ngwt__uid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ngwt__UUID:
		return (void*)soap_instantiate_ngwt__UUID(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FilterElement:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__FilterElement(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ContainerRef:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__ContainerRef(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwe__EventType:
		return (void*)soap_instantiate_std__vectorTemplateOfngwe__EventType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Events:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwe__Events(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Event:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwe__Event(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstring:
		return (void*)soap_instantiate_std__vectorTemplateOfstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ModifyItem:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__ModifyItem(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Host:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Host(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__UserInfo:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__UserInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Timezone:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Timezone(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Signature:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Signature(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__SettingsGroup:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__SettingsGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Rule:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Rule(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__RuleAction:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__RuleAction(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfxsd__date:
		return (void*)soap_instantiate_std__vectorTemplateOfxsd__date(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DelegateeStatus:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__DelegateeStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Recipient:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Recipient(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProxyUser:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__ProxyUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProblemEntry:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__ProblemEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PostalAddress:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__PostalAddress(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PhoneNumber:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__PhoneNumber(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwt__Month:
		return (void*)soap_instantiate_std__vectorTemplateOfngwt__Month(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__MessagePart:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__MessagePart(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Library:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Library(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__JunkEntry:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__JunkEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Item:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Item(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ImAddress:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__ImAddress(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__GroupMember:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__GroupMember(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyInfo:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__FreeBusyInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__NameAndEmail:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__NameAndEmail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyBlock:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__FreeBusyBlock(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Folder:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Folder(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FolderACLEntry:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__FolderACLEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfstd__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DocumentType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__DocumentType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DayOfYearWeek:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__DayOfYearWeek(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfYear:
		return (void*)soap_instantiate_std__vectorTemplateOfngwt__DayOfYear(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfMonth:
		return (void*)soap_instantiate_std__vectorTemplateOfngwt__DayOfMonth(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Custom:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Custom(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwt__uid:
		return (void*)soap_instantiate_std__vectorTemplateOfngwt__uid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Category:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__Category(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfngwt__CalendarFolderFlags:
		return (void*)soap_instantiate_std__vectorTemplateOfngwt__CalendarFolderFlags(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AttachmentItemInfo:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__AttachmentItemInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AddressBook:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__AddressBook(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessRightEntry:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__AccessRightEntry(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessControlListEntry:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTongwt__AccessControlListEntry(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_xsd__base64Binary:
		if (p->size < 0)
			delete (xsd__base64Binary*)p->ptr;
		else
			delete[] (xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessControlList:
		if (p->size < 0)
			delete (ngwt__AccessControlList*)p->ptr;
		else
			delete[] (ngwt__AccessControlList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessMiscRight:
		if (p->size < 0)
			delete (ngwt__AccessMiscRight*)p->ptr;
		else
			delete[] (ngwt__AccessMiscRight*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessRight:
		if (p->size < 0)
			delete (ngwt__AccessRight*)p->ptr;
		else
			delete[] (ngwt__AccessRight*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessRightChanges:
		if (p->size < 0)
			delete (ngwt__AccessRightChanges*)p->ptr;
		else
			delete[] (ngwt__AccessRightChanges*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessRightList:
		if (p->size < 0)
			delete (ngwt__AccessRightList*)p->ptr;
		else
			delete[] (ngwt__AccessRightList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AddressBookList:
		if (p->size < 0)
			delete (ngwt__AddressBookList*)p->ptr;
		else
			delete[] (ngwt__AddressBookList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AttachmentInfo:
		if (p->size < 0)
			delete (ngwt__AttachmentInfo*)p->ptr;
		else
			delete[] (ngwt__AttachmentInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AttachmentItemInfo:
		if (p->size < 0)
			delete (ngwt__AttachmentItemInfo*)p->ptr;
		else
			delete[] (ngwt__AttachmentItemInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Authentication:
		if (p->size < 0)
			delete (ngwt__Authentication*)p->ptr;
		else
			delete[] (ngwt__Authentication*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CalendarFolderAttribute:
		if (p->size < 0)
			delete (ngwt__CalendarFolderAttribute*)p->ptr;
		else
			delete[] (ngwt__CalendarFolderAttribute*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CategoryList:
		if (p->size < 0)
			delete (ngwt__CategoryList*)p->ptr;
		else
			delete[] (ngwt__CategoryList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CategoryRefList:
		if (p->size < 0)
			delete (ngwt__CategoryRefList*)p->ptr;
		else
			delete[] (ngwt__CategoryRefList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Custom:
		if (p->size < 0)
			delete (ngwt__Custom*)p->ptr;
		else
			delete[] (ngwt__Custom*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CustomList:
		if (p->size < 0)
			delete (ngwt__CustomList*)p->ptr;
		else
			delete[] (ngwt__CustomList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DayOfMonthList:
		if (p->size < 0)
			delete (ngwt__DayOfMonthList*)p->ptr;
		else
			delete[] (ngwt__DayOfMonthList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DayOfYearList:
		if (p->size < 0)
			delete (ngwt__DayOfYearList*)p->ptr;
		else
			delete[] (ngwt__DayOfYearList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DayOfYearWeekList:
		if (p->size < 0)
			delete (ngwt__DayOfYearWeekList*)p->ptr;
		else
			delete[] (ngwt__DayOfYearWeekList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DeltaInfo:
		if (p->size < 0)
			delete (ngwt__DeltaInfo*)p->ptr;
		else
			delete[] (ngwt__DeltaInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Distribution:
		if (p->size < 0)
			delete (ngwt__Distribution*)p->ptr;
		else
			delete[] (ngwt__Distribution*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DocumentType:
		if (p->size < 0)
			delete (ngwt__DocumentType*)p->ptr;
		else
			delete[] (ngwt__DocumentType*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DocumentTypeList:
		if (p->size < 0)
			delete (ngwt__DocumentTypeList*)p->ptr;
		else
			delete[] (ngwt__DocumentTypeList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__EmailAddressList:
		if (p->size < 0)
			delete (ngwt__EmailAddressList*)p->ptr;
		else
			delete[] (ngwt__EmailAddressList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Filter:
		if (p->size < 0)
			delete (ngwt__Filter*)p->ptr;
		else
			delete[] (ngwt__Filter*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FilterElement:
		if (p->size < 0)
			delete (ngwt__FilterElement*)p->ptr;
		else
			delete[] (ngwt__FilterElement*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FolderACL:
		if (p->size < 0)
			delete (ngwt__FolderACL*)p->ptr;
		else
			delete[] (ngwt__FolderACL*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FolderList:
		if (p->size < 0)
			delete (ngwt__FolderList*)p->ptr;
		else
			delete[] (ngwt__FolderList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyBlockList:
		if (p->size < 0)
			delete (ngwt__FreeBusyBlockList*)p->ptr;
		else
			delete[] (ngwt__FreeBusyBlockList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyBlock:
		if (p->size < 0)
			delete (ngwt__FreeBusyBlock*)p->ptr;
		else
			delete[] (ngwt__FreeBusyBlock*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyUserList:
		if (p->size < 0)
			delete (ngwt__FreeBusyUserList*)p->ptr;
		else
			delete[] (ngwt__FreeBusyUserList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyInfoList:
		if (p->size < 0)
			delete (ngwt__FreeBusyInfoList*)p->ptr;
		else
			delete[] (ngwt__FreeBusyInfoList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyStats:
		if (p->size < 0)
			delete (ngwt__FreeBusyStats*)p->ptr;
		else
			delete[] (ngwt__FreeBusyStats*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FullName:
		if (p->size < 0)
			delete (ngwt__FullName*)p->ptr;
		else
			delete[] (ngwt__FullName*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__GroupMember:
		if (p->size < 0)
			delete (ngwt__GroupMember*)p->ptr;
		else
			delete[] (ngwt__GroupMember*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__GroupMemberList:
		if (p->size < 0)
			delete (ngwt__GroupMemberList*)p->ptr;
		else
			delete[] (ngwt__GroupMemberList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Host:
		if (p->size < 0)
			delete (ngwt__Host*)p->ptr;
		else
			delete[] (ngwt__Host*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ImAddress:
		if (p->size < 0)
			delete (ngwt__ImAddress*)p->ptr;
		else
			delete[] (ngwt__ImAddress*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ImAddressList:
		if (p->size < 0)
			delete (ngwt__ImAddressList*)p->ptr;
		else
			delete[] (ngwt__ImAddressList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Item:
		if (p->size < 0)
			delete (ngwt__Item*)p->ptr;
		else
			delete[] (ngwt__Item*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemChanges:
		if (p->size < 0)
			delete (ngwt__ItemChanges*)p->ptr;
		else
			delete[] (ngwt__ItemChanges*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemList:
		if (p->size < 0)
			delete (ngwt__ItemList*)p->ptr;
		else
			delete[] (ngwt__ItemList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemOptions:
		if (p->size < 0)
			delete (ngwt__ItemOptions*)p->ptr;
		else
			delete[] (ngwt__ItemOptions*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemRefList:
		if (p->size < 0)
			delete (ngwt__ItemRefList*)p->ptr;
		else
			delete[] (ngwt__ItemRefList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Items:
		if (p->size < 0)
			delete (ngwt__Items*)p->ptr;
		else
			delete[] (ngwt__Items*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemStatus:
		if (p->size < 0)
			delete (ngwt__ItemStatus*)p->ptr;
		else
			delete[] (ngwt__ItemStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__JunkEntry:
		if (p->size < 0)
			delete (ngwt__JunkEntry*)p->ptr;
		else
			delete[] (ngwt__JunkEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__JunkHandlingList:
		if (p->size < 0)
			delete (ngwt__JunkHandlingList*)p->ptr;
		else
			delete[] (ngwt__JunkHandlingList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__LibraryList:
		if (p->size < 0)
			delete (ngwt__LibraryList*)p->ptr;
		else
			delete[] (ngwt__LibraryList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__LinkInfo:
		if (p->size < 0)
			delete (ngwt__LinkInfo*)p->ptr;
		else
			delete[] (ngwt__LinkInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__MessageBody:
		if (p->size < 0)
			delete (ngwt__MessageBody*)p->ptr;
		else
			delete[] (ngwt__MessageBody*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ModifyItem:
		if (p->size < 0)
			delete (ngwt__ModifyItem*)p->ptr;
		else
			delete[] (ngwt__ModifyItem*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__MonthList:
		if (p->size < 0)
			delete (ngwt__MonthList*)p->ptr;
		else
			delete[] (ngwt__MonthList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__NameAndEmail:
		if (p->size < 0)
			delete (ngwt__NameAndEmail*)p->ptr;
		else
			delete[] (ngwt__NameAndEmail*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__OfficeInfo:
		if (p->size < 0)
			delete (ngwt__OfficeInfo*)p->ptr;
		else
			delete[] (ngwt__OfficeInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PersonalInfo:
		if (p->size < 0)
			delete (ngwt__PersonalInfo*)p->ptr;
		else
			delete[] (ngwt__PersonalInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PhoneFlags:
		if (p->size < 0)
			delete (ngwt__PhoneFlags*)p->ptr;
		else
			delete[] (ngwt__PhoneFlags*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PhoneList:
		if (p->size < 0)
			delete (ngwt__PhoneList*)p->ptr;
		else
			delete[] (ngwt__PhoneList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PostalAddress:
		if (p->size < 0)
			delete (ngwt__PostalAddress*)p->ptr;
		else
			delete[] (ngwt__PostalAddress*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PostalAddressList:
		if (p->size < 0)
			delete (ngwt__PostalAddressList*)p->ptr;
		else
			delete[] (ngwt__PostalAddressList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ProblemEntry:
		if (p->size < 0)
			delete (ngwt__ProblemEntry*)p->ptr;
		else
			delete[] (ngwt__ProblemEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ProblemList:
		if (p->size < 0)
			delete (ngwt__ProblemList*)p->ptr;
		else
			delete[] (ngwt__ProblemList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ProxyList:
		if (p->size < 0)
			delete (ngwt__ProxyList*)p->ptr;
		else
			delete[] (ngwt__ProxyList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Query:
		if (p->size < 0)
			delete (ngwt__Query*)p->ptr;
		else
			delete[] (ngwt__Query*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__QueryTarget:
		if (p->size < 0)
			delete (ngwt__QueryTarget*)p->ptr;
		else
			delete[] (ngwt__QueryTarget*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RecipientList:
		if (p->size < 0)
			delete (ngwt__RecipientList*)p->ptr;
		else
			delete[] (ngwt__RecipientList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RecipientStatus:
		if (p->size < 0)
			delete (ngwt__RecipientStatus*)p->ptr;
		else
			delete[] (ngwt__RecipientStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RecurrenceDateType:
		if (p->size < 0)
			delete (ngwt__RecurrenceDateType*)p->ptr;
		else
			delete[] (ngwt__RecurrenceDateType*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RecurrenceRule:
		if (p->size < 0)
			delete (ngwt__RecurrenceRule*)p->ptr;
		else
			delete[] (ngwt__RecurrenceRule*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ReferenceInfo:
		if (p->size < 0)
			delete (ngwt__ReferenceInfo*)p->ptr;
		else
			delete[] (ngwt__ReferenceInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ReturnNotification:
		if (p->size < 0)
			delete (ngwt__ReturnNotification*)p->ptr;
		else
			delete[] (ngwt__ReturnNotification*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ReturnNotificationOptions:
		if (p->size < 0)
			delete (ngwt__ReturnNotificationOptions*)p->ptr;
		else
			delete[] (ngwt__ReturnNotificationOptions*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Rights:
		if (p->size < 0)
			delete (ngwt__Rights*)p->ptr;
		else
			delete[] (ngwt__Rights*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RuleAction:
		if (p->size < 0)
			delete (ngwt__RuleAction*)p->ptr;
		else
			delete[] (ngwt__RuleAction*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RuleActionList:
		if (p->size < 0)
			delete (ngwt__RuleActionList*)p->ptr;
		else
			delete[] (ngwt__RuleActionList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__RuleList:
		if (p->size < 0)
			delete (ngwt__RuleList*)p->ptr;
		else
			delete[] (ngwt__RuleList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SendOptionsRequestReply:
		if (p->size < 0)
			delete (ngwt__SendOptionsRequestReply*)p->ptr;
		else
			delete[] (ngwt__SendOptionsRequestReply*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SendOptions:
		if (p->size < 0)
			delete (ngwt__SendOptions*)p->ptr;
		else
			delete[] (ngwt__SendOptions*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Settings:
		if (p->size < 0)
			delete (ngwt__Settings*)p->ptr;
		else
			delete[] (ngwt__Settings*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SettingsGroup:
		if (p->size < 0)
			delete (ngwt__SettingsGroup*)p->ptr;
		else
			delete[] (ngwt__SettingsGroup*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SettingsList:
		if (p->size < 0)
			delete (ngwt__SettingsList*)p->ptr;
		else
			delete[] (ngwt__SettingsList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SharedFolderNotification:
		if (p->size < 0)
			delete (ngwt__SharedFolderNotification*)p->ptr;
		else
			delete[] (ngwt__SharedFolderNotification*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Signature:
		if (p->size < 0)
			delete (ngwt__Signature*)p->ptr;
		else
			delete[] (ngwt__Signature*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Signatures:
		if (p->size < 0)
			delete (ngwt__Signatures*)p->ptr;
		else
			delete[] (ngwt__Signatures*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SignatureData:
		if (p->size < 0)
			delete (ngwt__SignatureData*)p->ptr;
		else
			delete[] (ngwt__SignatureData*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SMimeOperation:
		if (p->size < 0)
			delete (ngwt__SMimeOperation*)p->ptr;
		else
			delete[] (ngwt__SMimeOperation*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Status:
		if (p->size < 0)
			delete (ngwt__Status*)p->ptr;
		else
			delete[] (ngwt__Status*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Timezone:
		if (p->size < 0)
			delete (ngwt__Timezone*)p->ptr;
		else
			delete[] (ngwt__Timezone*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__TimezoneComponent:
		if (p->size < 0)
			delete (ngwt__TimezoneComponent*)p->ptr;
		else
			delete[] (ngwt__TimezoneComponent*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__TimezoneList:
		if (p->size < 0)
			delete (ngwt__TimezoneList*)p->ptr;
		else
			delete[] (ngwt__TimezoneList*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__UserInfo:
		if (p->size < 0)
			delete (ngwt__UserInfo*)p->ptr;
		else
			delete[] (ngwt__UserInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__UserList:
		if (p->size < 0)
			delete (ngwt__UserList*)p->ptr;
		else
			delete[] (ngwt__UserList*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__acceptRequest:
		if (p->size < 0)
			delete (_ngwm__acceptRequest*)p->ptr;
		else
			delete[] (_ngwm__acceptRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__acceptResponse:
		if (p->size < 0)
			delete (_ngwm__acceptResponse*)p->ptr;
		else
			delete[] (_ngwm__acceptResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__acceptShareRequest:
		if (p->size < 0)
			delete (_ngwm__acceptShareRequest*)p->ptr;
		else
			delete[] (_ngwm__acceptShareRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__acceptShareResponse:
		if (p->size < 0)
			delete (_ngwm__acceptShareResponse*)p->ptr;
		else
			delete[] (_ngwm__acceptShareResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addItemRequest:
		if (p->size < 0)
			delete (_ngwm__addItemRequest*)p->ptr;
		else
			delete[] (_ngwm__addItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addItemResponse:
		if (p->size < 0)
			delete (_ngwm__addItemResponse*)p->ptr;
		else
			delete[] (_ngwm__addItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addItemsRequest:
		if (p->size < 0)
			delete (_ngwm__addItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__addItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addItemsResponse:
		if (p->size < 0)
			delete (_ngwm__addItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__addItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addMembersRequest:
		if (p->size < 0)
			delete (_ngwm__addMembersRequest*)p->ptr;
		else
			delete[] (_ngwm__addMembersRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__addMembersResponse:
		if (p->size < 0)
			delete (_ngwm__addMembersResponse*)p->ptr;
		else
			delete[] (_ngwm__addMembersResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__closeFreeBusySessionRequest:
		if (p->size < 0)
			delete (_ngwm__closeFreeBusySessionRequest*)p->ptr;
		else
			delete[] (_ngwm__closeFreeBusySessionRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__closeFreeBusySessionResponse:
		if (p->size < 0)
			delete (_ngwm__closeFreeBusySessionResponse*)p->ptr;
		else
			delete[] (_ngwm__closeFreeBusySessionResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__completeRequest:
		if (p->size < 0)
			delete (_ngwm__completeRequest*)p->ptr;
		else
			delete[] (_ngwm__completeRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__completeResponse:
		if (p->size < 0)
			delete (_ngwm__completeResponse*)p->ptr;
		else
			delete[] (_ngwm__completeResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createCursorRequest:
		if (p->size < 0)
			delete (_ngwm__createCursorRequest*)p->ptr;
		else
			delete[] (_ngwm__createCursorRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createCursorResponse:
		if (p->size < 0)
			delete (_ngwm__createCursorResponse*)p->ptr;
		else
			delete[] (_ngwm__createCursorResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createItemRequest:
		if (p->size < 0)
			delete (_ngwm__createItemRequest*)p->ptr;
		else
			delete[] (_ngwm__createItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createItemResponse:
		if (p->size < 0)
			delete (_ngwm__createItemResponse*)p->ptr;
		else
			delete[] (_ngwm__createItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createItemsRequest:
		if (p->size < 0)
			delete (_ngwm__createItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__createItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createItemsResponse:
		if (p->size < 0)
			delete (_ngwm__createItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__createItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createJunkEntryRequest:
		if (p->size < 0)
			delete (_ngwm__createJunkEntryRequest*)p->ptr;
		else
			delete[] (_ngwm__createJunkEntryRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createJunkEntryResponse:
		if (p->size < 0)
			delete (_ngwm__createJunkEntryResponse*)p->ptr;
		else
			delete[] (_ngwm__createJunkEntryResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createProxyAccessRequest:
		if (p->size < 0)
			delete (_ngwm__createProxyAccessRequest*)p->ptr;
		else
			delete[] (_ngwm__createProxyAccessRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createProxyAccessResponse:
		if (p->size < 0)
			delete (_ngwm__createProxyAccessResponse*)p->ptr;
		else
			delete[] (_ngwm__createProxyAccessResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createSignatureRequest:
		if (p->size < 0)
			delete (_ngwm__createSignatureRequest*)p->ptr;
		else
			delete[] (_ngwm__createSignatureRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__createSignatureResponse:
		if (p->size < 0)
			delete (_ngwm__createSignatureResponse*)p->ptr;
		else
			delete[] (_ngwm__createSignatureResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__declineRequest:
		if (p->size < 0)
			delete (_ngwm__declineRequest*)p->ptr;
		else
			delete[] (_ngwm__declineRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__declineResponse:
		if (p->size < 0)
			delete (_ngwm__declineResponse*)p->ptr;
		else
			delete[] (_ngwm__declineResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__delegateRequest:
		if (p->size < 0)
			delete (_ngwm__delegateRequest*)p->ptr;
		else
			delete[] (_ngwm__delegateRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__delegateResponse:
		if (p->size < 0)
			delete (_ngwm__delegateResponse*)p->ptr;
		else
			delete[] (_ngwm__delegateResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__destroyCursorRequest:
		if (p->size < 0)
			delete (_ngwm__destroyCursorRequest*)p->ptr;
		else
			delete[] (_ngwm__destroyCursorRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__destroyCursorResponse:
		if (p->size < 0)
			delete (_ngwm__destroyCursorResponse*)p->ptr;
		else
			delete[] (_ngwm__destroyCursorResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__executeRuleRequest:
		if (p->size < 0)
			delete (_ngwm__executeRuleRequest*)p->ptr;
		else
			delete[] (_ngwm__executeRuleRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__executeRuleResponse:
		if (p->size < 0)
			delete (_ngwm__executeRuleResponse*)p->ptr;
		else
			delete[] (_ngwm__executeRuleResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__forwardRequest:
		if (p->size < 0)
			delete (_ngwm__forwardRequest*)p->ptr;
		else
			delete[] (_ngwm__forwardRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__forwardResponse:
		if (p->size < 0)
			delete (_ngwm__forwardResponse*)p->ptr;
		else
			delete[] (_ngwm__forwardResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getAddressBookListRequest:
		if (p->size < 0)
			delete (_ngwm__getAddressBookListRequest*)p->ptr;
		else
			delete[] (_ngwm__getAddressBookListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getAddressBookListResponse:
		if (p->size < 0)
			delete (_ngwm__getAddressBookListResponse*)p->ptr;
		else
			delete[] (_ngwm__getAddressBookListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getAttachmentRequest:
		if (p->size < 0)
			delete (_ngwm__getAttachmentRequest*)p->ptr;
		else
			delete[] (_ngwm__getAttachmentRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getAttachmentResponse:
		if (p->size < 0)
			delete (_ngwm__getAttachmentResponse*)p->ptr;
		else
			delete[] (_ngwm__getAttachmentResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getCategoryListRequest:
		if (p->size < 0)
			delete (_ngwm__getCategoryListRequest*)p->ptr;
		else
			delete[] (_ngwm__getCategoryListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getCategoryListResponse:
		if (p->size < 0)
			delete (_ngwm__getCategoryListResponse*)p->ptr;
		else
			delete[] (_ngwm__getCategoryListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getCustomListRequest:
		if (p->size < 0)
			delete (_ngwm__getCustomListRequest*)p->ptr;
		else
			delete[] (_ngwm__getCustomListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getCustomListResponse:
		if (p->size < 0)
			delete (_ngwm__getCustomListResponse*)p->ptr;
		else
			delete[] (_ngwm__getCustomListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDeltasRequest:
		if (p->size < 0)
			delete (_ngwm__getDeltasRequest*)p->ptr;
		else
			delete[] (_ngwm__getDeltasRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDeltasResponse:
		if (p->size < 0)
			delete (_ngwm__getDeltasResponse*)p->ptr;
		else
			delete[] (_ngwm__getDeltasResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDeltaInfoRequest:
		if (p->size < 0)
			delete (_ngwm__getDeltaInfoRequest*)p->ptr;
		else
			delete[] (_ngwm__getDeltaInfoRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDeltaInfoResponse:
		if (p->size < 0)
			delete (_ngwm__getDeltaInfoResponse*)p->ptr;
		else
			delete[] (_ngwm__getDeltaInfoResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDocumentTypeListRequest:
		if (p->size < 0)
			delete (_ngwm__getDocumentTypeListRequest*)p->ptr;
		else
			delete[] (_ngwm__getDocumentTypeListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getDocumentTypeListResponse:
		if (p->size < 0)
			delete (_ngwm__getDocumentTypeListResponse*)p->ptr;
		else
			delete[] (_ngwm__getDocumentTypeListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFolderRequest:
		if (p->size < 0)
			delete (_ngwm__getFolderRequest*)p->ptr;
		else
			delete[] (_ngwm__getFolderRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFolderResponse:
		if (p->size < 0)
			delete (_ngwm__getFolderResponse*)p->ptr;
		else
			delete[] (_ngwm__getFolderResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFolderListRequest:
		if (p->size < 0)
			delete (_ngwm__getFolderListRequest*)p->ptr;
		else
			delete[] (_ngwm__getFolderListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFolderListResponse:
		if (p->size < 0)
			delete (_ngwm__getFolderListResponse*)p->ptr;
		else
			delete[] (_ngwm__getFolderListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFreeBusyRequest:
		if (p->size < 0)
			delete (_ngwm__getFreeBusyRequest*)p->ptr;
		else
			delete[] (_ngwm__getFreeBusyRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getFreeBusyResponse:
		if (p->size < 0)
			delete (_ngwm__getFreeBusyResponse*)p->ptr;
		else
			delete[] (_ngwm__getFreeBusyResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getItemRequest:
		if (p->size < 0)
			delete (_ngwm__getItemRequest*)p->ptr;
		else
			delete[] (_ngwm__getItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getItemResponse:
		if (p->size < 0)
			delete (_ngwm__getItemResponse*)p->ptr;
		else
			delete[] (_ngwm__getItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getItemsRequest:
		if (p->size < 0)
			delete (_ngwm__getItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__getItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getItemsResponse:
		if (p->size < 0)
			delete (_ngwm__getItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__getItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getJunkEntriesRequest:
		if (p->size < 0)
			delete (_ngwm__getJunkEntriesRequest*)p->ptr;
		else
			delete[] (_ngwm__getJunkEntriesRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getJunkEntriesResponse:
		if (p->size < 0)
			delete (_ngwm__getJunkEntriesResponse*)p->ptr;
		else
			delete[] (_ngwm__getJunkEntriesResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getJunkMailSettingsRequest:
		if (p->size < 0)
			delete (_ngwm__getJunkMailSettingsRequest*)p->ptr;
		else
			delete[] (_ngwm__getJunkMailSettingsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getJunkMailSettingsResponse:
		if (p->size < 0)
			delete (_ngwm__getJunkMailSettingsResponse*)p->ptr;
		else
			delete[] (_ngwm__getJunkMailSettingsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getLibraryItemRequest:
		if (p->size < 0)
			delete (_ngwm__getLibraryItemRequest*)p->ptr;
		else
			delete[] (_ngwm__getLibraryItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getLibraryItemResponse:
		if (p->size < 0)
			delete (_ngwm__getLibraryItemResponse*)p->ptr;
		else
			delete[] (_ngwm__getLibraryItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getLibraryListRequest:
		if (p->size < 0)
			delete (_ngwm__getLibraryListRequest*)p->ptr;
		else
			delete[] (_ngwm__getLibraryListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getLibraryListResponse:
		if (p->size < 0)
			delete (_ngwm__getLibraryListResponse*)p->ptr;
		else
			delete[] (_ngwm__getLibraryListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getQuickMessagesRequest:
		if (p->size < 0)
			delete (_ngwm__getQuickMessagesRequest*)p->ptr;
		else
			delete[] (_ngwm__getQuickMessagesRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getQuickMessagesResponse:
		if (p->size < 0)
			delete (_ngwm__getQuickMessagesResponse*)p->ptr;
		else
			delete[] (_ngwm__getQuickMessagesResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getProxyAccessListRequest:
		if (p->size < 0)
			delete (_ngwm__getProxyAccessListRequest*)p->ptr;
		else
			delete[] (_ngwm__getProxyAccessListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getProxyAccessListResponse:
		if (p->size < 0)
			delete (_ngwm__getProxyAccessListResponse*)p->ptr;
		else
			delete[] (_ngwm__getProxyAccessListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getProxyListRequest:
		if (p->size < 0)
			delete (_ngwm__getProxyListRequest*)p->ptr;
		else
			delete[] (_ngwm__getProxyListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getProxyListResponse:
		if (p->size < 0)
			delete (_ngwm__getProxyListResponse*)p->ptr;
		else
			delete[] (_ngwm__getProxyListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getRuleListRequest:
		if (p->size < 0)
			delete (_ngwm__getRuleListRequest*)p->ptr;
		else
			delete[] (_ngwm__getRuleListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getRuleListResponse:
		if (p->size < 0)
			delete (_ngwm__getRuleListResponse*)p->ptr;
		else
			delete[] (_ngwm__getRuleListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getSettingsRequest:
		if (p->size < 0)
			delete (_ngwm__getSettingsRequest*)p->ptr;
		else
			delete[] (_ngwm__getSettingsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getSettingsResponse:
		if (p->size < 0)
			delete (_ngwm__getSettingsResponse*)p->ptr;
		else
			delete[] (_ngwm__getSettingsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getSignaturesRequest:
		if (p->size < 0)
			delete (_ngwm__getSignaturesRequest*)p->ptr;
		else
			delete[] (_ngwm__getSignaturesRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getSignaturesResponse:
		if (p->size < 0)
			delete (_ngwm__getSignaturesResponse*)p->ptr;
		else
			delete[] (_ngwm__getSignaturesResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getTimestampRequest:
		if (p->size < 0)
			delete (_ngwm__getTimestampRequest*)p->ptr;
		else
			delete[] (_ngwm__getTimestampRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getTimestampResponse:
		if (p->size < 0)
			delete (_ngwm__getTimestampResponse*)p->ptr;
		else
			delete[] (_ngwm__getTimestampResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getTimezoneListRequest:
		if (p->size < 0)
			delete (_ngwm__getTimezoneListRequest*)p->ptr;
		else
			delete[] (_ngwm__getTimezoneListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getTimezoneListResponse:
		if (p->size < 0)
			delete (_ngwm__getTimezoneListResponse*)p->ptr;
		else
			delete[] (_ngwm__getTimezoneListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getUserListRequest:
		if (p->size < 0)
			delete (_ngwm__getUserListRequest*)p->ptr;
		else
			delete[] (_ngwm__getUserListRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__getUserListResponse:
		if (p->size < 0)
			delete (_ngwm__getUserListResponse*)p->ptr;
		else
			delete[] (_ngwm__getUserListResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__loginRequest:
		if (p->size < 0)
			delete (_ngwm__loginRequest*)p->ptr;
		else
			delete[] (_ngwm__loginRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__loginResponse:
		if (p->size < 0)
			delete (_ngwm__loginResponse*)p->ptr;
		else
			delete[] (_ngwm__loginResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__logoutRequest:
		if (p->size < 0)
			delete (_ngwm__logoutRequest*)p->ptr;
		else
			delete[] (_ngwm__logoutRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__logoutResponse:
		if (p->size < 0)
			delete (_ngwm__logoutResponse*)p->ptr;
		else
			delete[] (_ngwm__logoutResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markPrivateRequest:
		if (p->size < 0)
			delete (_ngwm__markPrivateRequest*)p->ptr;
		else
			delete[] (_ngwm__markPrivateRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markPrivateResponse:
		if (p->size < 0)
			delete (_ngwm__markPrivateResponse*)p->ptr;
		else
			delete[] (_ngwm__markPrivateResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markReadRequest:
		if (p->size < 0)
			delete (_ngwm__markReadRequest*)p->ptr;
		else
			delete[] (_ngwm__markReadRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markReadResponse:
		if (p->size < 0)
			delete (_ngwm__markReadResponse*)p->ptr;
		else
			delete[] (_ngwm__markReadResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markUnPrivateRequest:
		if (p->size < 0)
			delete (_ngwm__markUnPrivateRequest*)p->ptr;
		else
			delete[] (_ngwm__markUnPrivateRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markUnPrivateResponse:
		if (p->size < 0)
			delete (_ngwm__markUnPrivateResponse*)p->ptr;
		else
			delete[] (_ngwm__markUnPrivateResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markUnReadRequest:
		if (p->size < 0)
			delete (_ngwm__markUnReadRequest*)p->ptr;
		else
			delete[] (_ngwm__markUnReadRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__markUnReadResponse:
		if (p->size < 0)
			delete (_ngwm__markUnReadResponse*)p->ptr;
		else
			delete[] (_ngwm__markUnReadResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyItemRequest:
		if (p->size < 0)
			delete (_ngwm__modifyItemRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyItemResponse:
		if (p->size < 0)
			delete (_ngwm__modifyItemResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyItemsRequest:
		if (p->size < 0)
			delete (_ngwm__modifyItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyItemsResponse:
		if (p->size < 0)
			delete (_ngwm__modifyItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyJunkEntryRequest:
		if (p->size < 0)
			delete (_ngwm__modifyJunkEntryRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyJunkEntryRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyJunkEntryResponse:
		if (p->size < 0)
			delete (_ngwm__modifyJunkEntryResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyJunkEntryResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsRequest:
		if (p->size < 0)
			delete (_ngwm__modifyJunkMailSettingsRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyJunkMailSettingsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyJunkMailSettingsResponse:
		if (p->size < 0)
			delete (_ngwm__modifyJunkMailSettingsResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyJunkMailSettingsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyPasswordRequest:
		if (p->size < 0)
			delete (_ngwm__modifyPasswordRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyPasswordRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyPasswordResponse:
		if (p->size < 0)
			delete (_ngwm__modifyPasswordResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyPasswordResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyProxyAccessRequest:
		if (p->size < 0)
			delete (_ngwm__modifyProxyAccessRequest*)p->ptr;
		else
			delete[] (_ngwm__modifyProxyAccessRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifyProxyAccessResponse:
		if (p->size < 0)
			delete (_ngwm__modifyProxyAccessResponse*)p->ptr;
		else
			delete[] (_ngwm__modifyProxyAccessResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifySettingsRequest:
		if (p->size < 0)
			delete (_ngwm__modifySettingsRequest*)p->ptr;
		else
			delete[] (_ngwm__modifySettingsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifySettingsResponse:
		if (p->size < 0)
			delete (_ngwm__modifySettingsResponse*)p->ptr;
		else
			delete[] (_ngwm__modifySettingsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifySignaturesRequest:
		if (p->size < 0)
			delete (_ngwm__modifySignaturesRequest*)p->ptr;
		else
			delete[] (_ngwm__modifySignaturesRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__modifySignaturesResponse:
		if (p->size < 0)
			delete (_ngwm__modifySignaturesResponse*)p->ptr;
		else
			delete[] (_ngwm__modifySignaturesResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__moveItemRequest:
		if (p->size < 0)
			delete (_ngwm__moveItemRequest*)p->ptr;
		else
			delete[] (_ngwm__moveItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__moveItemResponse:
		if (p->size < 0)
			delete (_ngwm__moveItemResponse*)p->ptr;
		else
			delete[] (_ngwm__moveItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__positionCursorRequest:
		if (p->size < 0)
			delete (_ngwm__positionCursorRequest*)p->ptr;
		else
			delete[] (_ngwm__positionCursorRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__positionCursorResponse:
		if (p->size < 0)
			delete (_ngwm__positionCursorResponse*)p->ptr;
		else
			delete[] (_ngwm__positionCursorResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__purgeDeletedItemsRequest:
		if (p->size < 0)
			delete (_ngwm__purgeDeletedItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__purgeDeletedItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__purgeDeletedItemsResponse:
		if (p->size < 0)
			delete (_ngwm__purgeDeletedItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__purgeDeletedItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__purgeRequest:
		if (p->size < 0)
			delete (_ngwm__purgeRequest*)p->ptr;
		else
			delete[] (_ngwm__purgeRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__purgeResponse:
		if (p->size < 0)
			delete (_ngwm__purgeResponse*)p->ptr;
		else
			delete[] (_ngwm__purgeResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__readCursorRequest:
		if (p->size < 0)
			delete (_ngwm__readCursorRequest*)p->ptr;
		else
			delete[] (_ngwm__readCursorRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__readCursorResponse:
		if (p->size < 0)
			delete (_ngwm__readCursorResponse*)p->ptr;
		else
			delete[] (_ngwm__readCursorResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeCustomDefinitionRequest:
		if (p->size < 0)
			delete (_ngwm__removeCustomDefinitionRequest*)p->ptr;
		else
			delete[] (_ngwm__removeCustomDefinitionRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeCustomDefinitionResponse:
		if (p->size < 0)
			delete (_ngwm__removeCustomDefinitionResponse*)p->ptr;
		else
			delete[] (_ngwm__removeCustomDefinitionResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeItemRequest:
		if (p->size < 0)
			delete (_ngwm__removeItemRequest*)p->ptr;
		else
			delete[] (_ngwm__removeItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeItemResponse:
		if (p->size < 0)
			delete (_ngwm__removeItemResponse*)p->ptr;
		else
			delete[] (_ngwm__removeItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeItemsRequest:
		if (p->size < 0)
			delete (_ngwm__removeItemsRequest*)p->ptr;
		else
			delete[] (_ngwm__removeItemsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeItemsResponse:
		if (p->size < 0)
			delete (_ngwm__removeItemsResponse*)p->ptr;
		else
			delete[] (_ngwm__removeItemsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeJunkEntryRequest:
		if (p->size < 0)
			delete (_ngwm__removeJunkEntryRequest*)p->ptr;
		else
			delete[] (_ngwm__removeJunkEntryRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeJunkEntryResponse:
		if (p->size < 0)
			delete (_ngwm__removeJunkEntryResponse*)p->ptr;
		else
			delete[] (_ngwm__removeJunkEntryResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeMembersRequest:
		if (p->size < 0)
			delete (_ngwm__removeMembersRequest*)p->ptr;
		else
			delete[] (_ngwm__removeMembersRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeMembersResponse:
		if (p->size < 0)
			delete (_ngwm__removeMembersResponse*)p->ptr;
		else
			delete[] (_ngwm__removeMembersResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeProxyAccessRequest:
		if (p->size < 0)
			delete (_ngwm__removeProxyAccessRequest*)p->ptr;
		else
			delete[] (_ngwm__removeProxyAccessRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeProxyAccessResponse:
		if (p->size < 0)
			delete (_ngwm__removeProxyAccessResponse*)p->ptr;
		else
			delete[] (_ngwm__removeProxyAccessResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeProxyUserRequest:
		if (p->size < 0)
			delete (_ngwm__removeProxyUserRequest*)p->ptr;
		else
			delete[] (_ngwm__removeProxyUserRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeProxyUserResponse:
		if (p->size < 0)
			delete (_ngwm__removeProxyUserResponse*)p->ptr;
		else
			delete[] (_ngwm__removeProxyUserResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeSignatureRequest:
		if (p->size < 0)
			delete (_ngwm__removeSignatureRequest*)p->ptr;
		else
			delete[] (_ngwm__removeSignatureRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__removeSignatureResponse:
		if (p->size < 0)
			delete (_ngwm__removeSignatureResponse*)p->ptr;
		else
			delete[] (_ngwm__removeSignatureResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__replyRequest:
		if (p->size < 0)
			delete (_ngwm__replyRequest*)p->ptr;
		else
			delete[] (_ngwm__replyRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__replyResponse:
		if (p->size < 0)
			delete (_ngwm__replyResponse*)p->ptr;
		else
			delete[] (_ngwm__replyResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__retractRequest:
		if (p->size < 0)
			delete (_ngwm__retractRequest*)p->ptr;
		else
			delete[] (_ngwm__retractRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__retractResponse:
		if (p->size < 0)
			delete (_ngwm__retractResponse*)p->ptr;
		else
			delete[] (_ngwm__retractResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__sendItemRequest:
		if (p->size < 0)
			delete (_ngwm__sendItemRequest*)p->ptr;
		else
			delete[] (_ngwm__sendItemRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__sendItemResponse:
		if (p->size < 0)
			delete (_ngwm__sendItemResponse*)p->ptr;
		else
			delete[] (_ngwm__sendItemResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__setTimestampRequest:
		if (p->size < 0)
			delete (_ngwm__setTimestampRequest*)p->ptr;
		else
			delete[] (_ngwm__setTimestampRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__setTimestampResponse:
		if (p->size < 0)
			delete (_ngwm__setTimestampResponse*)p->ptr;
		else
			delete[] (_ngwm__setTimestampResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__startFreeBusySessionRequest:
		if (p->size < 0)
			delete (_ngwm__startFreeBusySessionRequest*)p->ptr;
		else
			delete[] (_ngwm__startFreeBusySessionRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__startFreeBusySessionResponse:
		if (p->size < 0)
			delete (_ngwm__startFreeBusySessionResponse*)p->ptr;
		else
			delete[] (_ngwm__startFreeBusySessionResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__unacceptRequest:
		if (p->size < 0)
			delete (_ngwm__unacceptRequest*)p->ptr;
		else
			delete[] (_ngwm__unacceptRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__unacceptResponse:
		if (p->size < 0)
			delete (_ngwm__unacceptResponse*)p->ptr;
		else
			delete[] (_ngwm__unacceptResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__uncompleteRequest:
		if (p->size < 0)
			delete (_ngwm__uncompleteRequest*)p->ptr;
		else
			delete[] (_ngwm__uncompleteRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__uncompleteResponse:
		if (p->size < 0)
			delete (_ngwm__uncompleteResponse*)p->ptr;
		else
			delete[] (_ngwm__uncompleteResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__updateVersionStatusRequest:
		if (p->size < 0)
			delete (_ngwm__updateVersionStatusRequest*)p->ptr;
		else
			delete[] (_ngwm__updateVersionStatusRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwm__updateVersionStatusResponse:
		if (p->size < 0)
			delete (_ngwm__updateVersionStatusResponse*)p->ptr;
		else
			delete[] (_ngwm__updateVersionStatusResponse*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__ContainerList:
		if (p->size < 0)
			delete (ngwe__ContainerList*)p->ptr;
		else
			delete[] (ngwe__ContainerList*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__Event:
		if (p->size < 0)
			delete (ngwe__Event*)p->ptr;
		else
			delete[] (ngwe__Event*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__EventDefinition:
		if (p->size < 0)
			delete (ngwe__EventDefinition*)p->ptr;
		else
			delete[] (ngwe__EventDefinition*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__EventList:
		if (p->size < 0)
			delete (ngwe__EventList*)p->ptr;
		else
			delete[] (ngwe__EventList*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__Events:
		if (p->size < 0)
			delete (ngwe__Events*)p->ptr;
		else
			delete[] (ngwe__Events*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__EventsList:
		if (p->size < 0)
			delete (ngwe__EventsList*)p->ptr;
		else
			delete[] (ngwe__EventsList*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__EventTypeList:
		if (p->size < 0)
			delete (ngwe__EventTypeList*)p->ptr;
		else
			delete[] (ngwe__EventTypeList*)p->ptr;
		break;
	case SOAP_TYPE_ngwe__Notify:
		if (p->size < 0)
			delete (ngwe__Notify*)p->ptr;
		else
			delete[] (ngwe__Notify*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__cleanEventConfigurationRequest:
		if (p->size < 0)
			delete (_ngwe__cleanEventConfigurationRequest*)p->ptr;
		else
			delete[] (_ngwe__cleanEventConfigurationRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__cleanEventConfigurationResponse:
		if (p->size < 0)
			delete (_ngwe__cleanEventConfigurationResponse*)p->ptr;
		else
			delete[] (_ngwe__cleanEventConfigurationResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__configureEventsRequest:
		if (p->size < 0)
			delete (_ngwe__configureEventsRequest*)p->ptr;
		else
			delete[] (_ngwe__configureEventsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__configureEventsResponse:
		if (p->size < 0)
			delete (_ngwe__configureEventsResponse*)p->ptr;
		else
			delete[] (_ngwe__configureEventsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__getEventConfigurationRequest:
		if (p->size < 0)
			delete (_ngwe__getEventConfigurationRequest*)p->ptr;
		else
			delete[] (_ngwe__getEventConfigurationRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__getEventConfigurationResponse:
		if (p->size < 0)
			delete (_ngwe__getEventConfigurationResponse*)p->ptr;
		else
			delete[] (_ngwe__getEventConfigurationResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__getEventsRequest:
		if (p->size < 0)
			delete (_ngwe__getEventsRequest*)p->ptr;
		else
			delete[] (_ngwe__getEventsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__getEventsResponse:
		if (p->size < 0)
			delete (_ngwe__getEventsResponse*)p->ptr;
		else
			delete[] (_ngwe__getEventsResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__removeEventConfigurationRequest:
		if (p->size < 0)
			delete (_ngwe__removeEventConfigurationRequest*)p->ptr;
		else
			delete[] (_ngwe__removeEventConfigurationRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__removeEventConfigurationResponse:
		if (p->size < 0)
			delete (_ngwe__removeEventConfigurationResponse*)p->ptr;
		else
			delete[] (_ngwe__removeEventConfigurationResponse*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__removeEventsRequest:
		if (p->size < 0)
			delete (_ngwe__removeEventsRequest*)p->ptr;
		else
			delete[] (_ngwe__removeEventsRequest*)p->ptr;
		break;
	case SOAP_TYPE__ngwe__removeEventsResponse:
		if (p->size < 0)
			delete (_ngwe__removeEventsResponse*)p->ptr;
		else
			delete[] (_ngwe__removeEventsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessControlListEntry:
		if (p->size < 0)
			delete (ngwt__AccessControlListEntry*)p->ptr;
		else
			delete[] (ngwt__AccessControlListEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AccessRightEntry:
		if (p->size < 0)
			delete (ngwt__AccessRightEntry*)p->ptr;
		else
			delete[] (ngwt__AccessRightEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AddressBook:
		if (p->size < 0)
			delete (ngwt__AddressBook*)p->ptr;
		else
			delete[] (ngwt__AddressBook*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Alarm:
		if (p->size < 0)
			delete (ngwt__Alarm*)p->ptr;
		else
			delete[] (ngwt__Alarm*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Category:
		if (p->size < 0)
			delete (ngwt__Category*)p->ptr;
		else
			delete[] (ngwt__Category*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CommentStatus:
		if (p->size < 0)
			delete (ngwt__CommentStatus*)p->ptr;
		else
			delete[] (ngwt__CommentStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ContainerItem:
		if (p->size < 0)
			delete (ngwt__ContainerItem*)p->ptr;
		else
			delete[] (ngwt__ContainerItem*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ContainerRef:
		if (p->size < 0)
			delete (ngwt__ContainerRef*)p->ptr;
		else
			delete[] (ngwt__ContainerRef*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DelegatedStatus:
		if (p->size < 0)
			delete (ngwt__DelegatedStatus*)p->ptr;
		else
			delete[] (ngwt__DelegatedStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DelegateeStatus:
		if (p->size < 0)
			delete (ngwt__DelegateeStatus*)p->ptr;
		else
			delete[] (ngwt__DelegateeStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FilterEntry:
		if (p->size < 0)
			delete (ngwt__FilterEntry*)p->ptr;
		else
			delete[] (ngwt__FilterEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FilterGroup:
		if (p->size < 0)
			delete (ngwt__FilterGroup*)p->ptr;
		else
			delete[] (ngwt__FilterGroup*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Folder:
		if (p->size < 0)
			delete (ngwt__Folder*)p->ptr;
		else
			delete[] (ngwt__Folder*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FreeBusyInfo:
		if (p->size < 0)
			delete (ngwt__FreeBusyInfo*)p->ptr;
		else
			delete[] (ngwt__FreeBusyInfo*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__From:
		if (p->size < 0)
			delete (ngwt__From*)p->ptr;
		else
			delete[] (ngwt__From*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ItemRef:
		if (p->size < 0)
			delete (ngwt__ItemRef*)p->ptr;
		else
			delete[] (ngwt__ItemRef*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Library:
		if (p->size < 0)
			delete (ngwt__Library*)p->ptr;
		else
			delete[] (ngwt__Library*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__MessagePart:
		if (p->size < 0)
			delete (ngwt__MessagePart*)p->ptr;
		else
			delete[] (ngwt__MessagePart*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PhoneNumber:
		if (p->size < 0)
			delete (ngwt__PhoneNumber*)p->ptr;
		else
			delete[] (ngwt__PhoneNumber*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PlainText:
		if (p->size < 0)
			delete (ngwt__PlainText*)p->ptr;
		else
			delete[] (ngwt__PlainText*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Proxy:
		if (p->size < 0)
			delete (ngwt__Proxy*)p->ptr;
		else
			delete[] (ngwt__Proxy*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ProxyUser:
		if (p->size < 0)
			delete (ngwt__ProxyUser*)p->ptr;
		else
			delete[] (ngwt__ProxyUser*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Recipient:
		if (p->size < 0)
			delete (ngwt__Recipient*)p->ptr;
		else
			delete[] (ngwt__Recipient*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__TransferFailedStatus:
		if (p->size < 0)
			delete (ngwt__TransferFailedStatus*)p->ptr;
		else
			delete[] (ngwt__TransferFailedStatus*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__TrustedApplication:
		if (p->size < 0)
			delete (ngwt__TrustedApplication*)p->ptr;
		else
			delete[] (ngwt__TrustedApplication*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AddressBookItem:
		if (p->size < 0)
			delete (ngwt__AddressBookItem*)p->ptr;
		else
			delete[] (ngwt__AddressBookItem*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__AttachmentID:
		if (p->size < 0)
			delete (ngwt__AttachmentID*)p->ptr;
		else
			delete[] (ngwt__AttachmentID*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__BoxEntry:
		if (p->size < 0)
			delete (ngwt__BoxEntry*)p->ptr;
		else
			delete[] (ngwt__BoxEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DayOfWeek:
		if (p->size < 0)
			delete (ngwt__DayOfWeek*)p->ptr;
		else
			delete[] (ngwt__DayOfWeek*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DayOfYearWeek:
		if (p->size < 0)
			delete (ngwt__DayOfYearWeek*)p->ptr;
		else
			delete[] (ngwt__DayOfYearWeek*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Document:
		if (p->size < 0)
			delete (ngwt__Document*)p->ptr;
		else
			delete[] (ngwt__Document*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__FolderACLEntry:
		if (p->size < 0)
			delete (ngwt__FolderACLEntry*)p->ptr;
		else
			delete[] (ngwt__FolderACLEntry*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__QueryFolder:
		if (p->size < 0)
			delete (ngwt__QueryFolder*)p->ptr;
		else
			delete[] (ngwt__QueryFolder*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Rule:
		if (p->size < 0)
			delete (ngwt__Rule*)p->ptr;
		else
			delete[] (ngwt__Rule*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SharedFolder:
		if (p->size < 0)
			delete (ngwt__SharedFolder*)p->ptr;
		else
			delete[] (ngwt__SharedFolder*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__StatusTracking:
		if (p->size < 0)
			delete (ngwt__StatusTracking*)p->ptr;
		else
			delete[] (ngwt__StatusTracking*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SystemFolder:
		if (p->size < 0)
			delete (ngwt__SystemFolder*)p->ptr;
		else
			delete[] (ngwt__SystemFolder*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Version:
		if (p->size < 0)
			delete (ngwt__Version*)p->ptr;
		else
			delete[] (ngwt__Version*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__VersionEvent:
		if (p->size < 0)
			delete (ngwt__VersionEvent*)p->ptr;
		else
			delete[] (ngwt__VersionEvent*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Contact:
		if (p->size < 0)
			delete (ngwt__Contact*)p->ptr;
		else
			delete[] (ngwt__Contact*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__ContactFolder:
		if (p->size < 0)
			delete (ngwt__ContactFolder*)p->ptr;
		else
			delete[] (ngwt__ContactFolder*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Group:
		if (p->size < 0)
			delete (ngwt__Group*)p->ptr;
		else
			delete[] (ngwt__Group*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Mail:
		if (p->size < 0)
			delete (ngwt__Mail*)p->ptr;
		else
			delete[] (ngwt__Mail*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Organization:
		if (p->size < 0)
			delete (ngwt__Organization*)p->ptr;
		else
			delete[] (ngwt__Organization*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Resource:
		if (p->size < 0)
			delete (ngwt__Resource*)p->ptr;
		else
			delete[] (ngwt__Resource*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__CalendarItem:
		if (p->size < 0)
			delete (ngwt__CalendarItem*)p->ptr;
		else
			delete[] (ngwt__CalendarItem*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__DocumentRef:
		if (p->size < 0)
			delete (ngwt__DocumentRef*)p->ptr;
		else
			delete[] (ngwt__DocumentRef*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__PhoneMessage:
		if (p->size < 0)
			delete (ngwt__PhoneMessage*)p->ptr;
		else
			delete[] (ngwt__PhoneMessage*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__SharedNotification:
		if (p->size < 0)
			delete (ngwt__SharedNotification*)p->ptr;
		else
			delete[] (ngwt__SharedNotification*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Appointment:
		if (p->size < 0)
			delete (ngwt__Appointment*)p->ptr;
		else
			delete[] (ngwt__Appointment*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Note:
		if (p->size < 0)
			delete (ngwt__Note*)p->ptr;
		else
			delete[] (ngwt__Note*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__Task:
		if (p->size < 0)
			delete (ngwt__Task*)p->ptr;
		else
			delete[] (ngwt__Task*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_xsd__date:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__decimal:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__duration:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__language:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__View:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__uid:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_ngwt__UUID:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FilterElement:
		if (p->size < 0)
			delete (std::vector<ngwt__FilterElement * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__FilterElement * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ContainerRef:
		if (p->size < 0)
			delete (std::vector<ngwt__ContainerRef * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__ContainerRef * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwe__EventType:
		if (p->size < 0)
			delete (std::vector<enum ngwe__EventType >*)p->ptr;
		else
			delete[] (std::vector<enum ngwe__EventType >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Events:
		if (p->size < 0)
			delete (std::vector<ngwe__Events * >*)p->ptr;
		else
			delete[] (std::vector<ngwe__Events * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Event:
		if (p->size < 0)
			delete (std::vector<ngwe__Event * >*)p->ptr;
		else
			delete[] (std::vector<ngwe__Event * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstring:
		if (p->size < 0)
			delete (std::vector<char * >*)p->ptr;
		else
			delete[] (std::vector<char * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ModifyItem:
		if (p->size < 0)
			delete (std::vector<ngwt__ModifyItem * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__ModifyItem * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Host:
		if (p->size < 0)
			delete (std::vector<ngwt__Host * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Host * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__UserInfo:
		if (p->size < 0)
			delete (std::vector<ngwt__UserInfo * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__UserInfo * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Timezone:
		if (p->size < 0)
			delete (std::vector<ngwt__Timezone * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Timezone * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Signature:
		if (p->size < 0)
			delete (std::vector<ngwt__Signature * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Signature * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__SettingsGroup:
		if (p->size < 0)
			delete (std::vector<ngwt__SettingsGroup * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__SettingsGroup * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Rule:
		if (p->size < 0)
			delete (std::vector<ngwt__Rule * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Rule * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__RuleAction:
		if (p->size < 0)
			delete (std::vector<ngwt__RuleAction * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__RuleAction * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__date:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DelegateeStatus:
		if (p->size < 0)
			delete (std::vector<ngwt__DelegateeStatus * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__DelegateeStatus * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Recipient:
		if (p->size < 0)
			delete (std::vector<ngwt__Recipient * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Recipient * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProxyUser:
		if (p->size < 0)
			delete (std::vector<ngwt__ProxyUser * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__ProxyUser * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProblemEntry:
		if (p->size < 0)
			delete (std::vector<ngwt__ProblemEntry * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__ProblemEntry * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PostalAddress:
		if (p->size < 0)
			delete (std::vector<ngwt__PostalAddress * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__PostalAddress * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PhoneNumber:
		if (p->size < 0)
			delete (std::vector<ngwt__PhoneNumber * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__PhoneNumber * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__Month:
		if (p->size < 0)
			delete (std::vector<unsigned char >*)p->ptr;
		else
			delete[] (std::vector<unsigned char >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__MessagePart:
		if (p->size < 0)
			delete (std::vector<ngwt__MessagePart * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__MessagePart * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Library:
		if (p->size < 0)
			delete (std::vector<ngwt__Library * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Library * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__JunkEntry:
		if (p->size < 0)
			delete (std::vector<ngwt__JunkEntry * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__JunkEntry * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Item:
		if (p->size < 0)
			delete (std::vector<ngwt__Item * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Item * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ImAddress:
		if (p->size < 0)
			delete (std::vector<ngwt__ImAddress * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__ImAddress * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__GroupMember:
		if (p->size < 0)
			delete (std::vector<ngwt__GroupMember * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__GroupMember * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyInfo:
		if (p->size < 0)
			delete (std::vector<ngwt__FreeBusyInfo * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__FreeBusyInfo * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__NameAndEmail:
		if (p->size < 0)
			delete (std::vector<ngwt__NameAndEmail * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__NameAndEmail * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyBlock:
		if (p->size < 0)
			delete (std::vector<ngwt__FreeBusyBlock * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__FreeBusyBlock * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Folder:
		if (p->size < 0)
			delete (std::vector<ngwt__Folder * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Folder * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FolderACLEntry:
		if (p->size < 0)
			delete (std::vector<ngwt__FolderACLEntry * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__FolderACLEntry * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DocumentType:
		if (p->size < 0)
			delete (std::vector<ngwt__DocumentType * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__DocumentType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DayOfYearWeek:
		if (p->size < 0)
			delete (std::vector<ngwt__DayOfYearWeek * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__DayOfYearWeek * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfYear:
		if (p->size < 0)
			delete (std::vector<short >*)p->ptr;
		else
			delete[] (std::vector<short >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfMonth:
		if (p->size < 0)
			delete (std::vector<char >*)p->ptr;
		else
			delete[] (std::vector<char >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Custom:
		if (p->size < 0)
			delete (std::vector<ngwt__Custom * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Custom * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__uid:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Category:
		if (p->size < 0)
			delete (std::vector<ngwt__Category * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__Category * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__CalendarFolderFlags:
		if (p->size < 0)
			delete (std::vector<enum ngwt__CalendarFolderFlags >*)p->ptr;
		else
			delete[] (std::vector<enum ngwt__CalendarFolderFlags >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AttachmentItemInfo:
		if (p->size < 0)
			delete (std::vector<ngwt__AttachmentItemInfo * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__AttachmentItemInfo * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AddressBook:
		if (p->size < 0)
			delete (std::vector<ngwt__AddressBook * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__AddressBook * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessRightEntry:
		if (p->size < 0)
			delete (std::vector<ngwt__AccessRightEntry * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__AccessRightEntry * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessControlListEntry:
		if (p->size < 0)
			delete (std::vector<ngwt__AccessControlListEntry * >*)p->ptr;
		else
			delete[] (std::vector<ngwt__AccessControlListEntry * >*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FilterElement:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__FilterElement * >*)p)->insert(((std::vector<ngwt__FilterElement * >*)p)->end(), *(ngwt__FilterElement **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ContainerRef:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__ContainerRef * >*)p)->insert(((std::vector<ngwt__ContainerRef * >*)p)->end(), *(ngwt__ContainerRef **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwe__EventType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<enum ngwe__EventType >*)p)->insert(((std::vector<enum ngwe__EventType >*)p)->end(), *(enum ngwe__EventType *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Events:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwe__Events * >*)p)->insert(((std::vector<ngwe__Events * >*)p)->end(), *(ngwe__Events **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwe__Event:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwe__Event * >*)p)->insert(((std::vector<ngwe__Event * >*)p)->end(), *(ngwe__Event **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfstring:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<char * >*)p)->insert(((std::vector<char * >*)p)->end(), *(char **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ModifyItem:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__ModifyItem * >*)p)->insert(((std::vector<ngwt__ModifyItem * >*)p)->end(), *(ngwt__ModifyItem **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Host:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Host * >*)p)->insert(((std::vector<ngwt__Host * >*)p)->end(), *(ngwt__Host **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__UserInfo:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__UserInfo * >*)p)->insert(((std::vector<ngwt__UserInfo * >*)p)->end(), *(ngwt__UserInfo **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Timezone:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Timezone * >*)p)->insert(((std::vector<ngwt__Timezone * >*)p)->end(), *(ngwt__Timezone **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Signature:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Signature * >*)p)->insert(((std::vector<ngwt__Signature * >*)p)->end(), *(ngwt__Signature **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__SettingsGroup:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__SettingsGroup * >*)p)->insert(((std::vector<ngwt__SettingsGroup * >*)p)->end(), *(ngwt__SettingsGroup **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Rule:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Rule * >*)p)->insert(((std::vector<ngwt__Rule * >*)p)->end(), *(ngwt__Rule **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__RuleAction:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__RuleAction * >*)p)->insert(((std::vector<ngwt__RuleAction * >*)p)->end(), *(ngwt__RuleAction **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfxsd__date:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<std::string >*)p)->insert(((std::vector<std::string >*)p)->end(), *(std::string *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DelegateeStatus:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__DelegateeStatus * >*)p)->insert(((std::vector<ngwt__DelegateeStatus * >*)p)->end(), *(ngwt__DelegateeStatus **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Recipient:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Recipient * >*)p)->insert(((std::vector<ngwt__Recipient * >*)p)->end(), *(ngwt__Recipient **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProxyUser:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__ProxyUser * >*)p)->insert(((std::vector<ngwt__ProxyUser * >*)p)->end(), *(ngwt__ProxyUser **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ProblemEntry:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__ProblemEntry * >*)p)->insert(((std::vector<ngwt__ProblemEntry * >*)p)->end(), *(ngwt__ProblemEntry **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PostalAddress:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__PostalAddress * >*)p)->insert(((std::vector<ngwt__PostalAddress * >*)p)->end(), *(ngwt__PostalAddress **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__PhoneNumber:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__PhoneNumber * >*)p)->insert(((std::vector<ngwt__PhoneNumber * >*)p)->end(), *(ngwt__PhoneNumber **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__Month:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<unsigned char >*)p)->insert(((std::vector<unsigned char >*)p)->end(), *(unsigned char *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__MessagePart:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__MessagePart * >*)p)->insert(((std::vector<ngwt__MessagePart * >*)p)->end(), *(ngwt__MessagePart **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Library:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Library * >*)p)->insert(((std::vector<ngwt__Library * >*)p)->end(), *(ngwt__Library **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__JunkEntry:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__JunkEntry * >*)p)->insert(((std::vector<ngwt__JunkEntry * >*)p)->end(), *(ngwt__JunkEntry **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Item:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Item * >*)p)->insert(((std::vector<ngwt__Item * >*)p)->end(), *(ngwt__Item **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__ImAddress:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__ImAddress * >*)p)->insert(((std::vector<ngwt__ImAddress * >*)p)->end(), *(ngwt__ImAddress **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__GroupMember:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__GroupMember * >*)p)->insert(((std::vector<ngwt__GroupMember * >*)p)->end(), *(ngwt__GroupMember **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyInfo:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__FreeBusyInfo * >*)p)->insert(((std::vector<ngwt__FreeBusyInfo * >*)p)->end(), *(ngwt__FreeBusyInfo **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__NameAndEmail:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__NameAndEmail * >*)p)->insert(((std::vector<ngwt__NameAndEmail * >*)p)->end(), *(ngwt__NameAndEmail **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FreeBusyBlock:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__FreeBusyBlock * >*)p)->insert(((std::vector<ngwt__FreeBusyBlock * >*)p)->end(), *(ngwt__FreeBusyBlock **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Folder:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Folder * >*)p)->insert(((std::vector<ngwt__Folder * >*)p)->end(), *(ngwt__Folder **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__FolderACLEntry:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__FolderACLEntry * >*)p)->insert(((std::vector<ngwt__FolderACLEntry * >*)p)->end(), *(ngwt__FolderACLEntry **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<std::string >*)p)->insert(((std::vector<std::string >*)p)->end(), *(std::string *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DocumentType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__DocumentType * >*)p)->insert(((std::vector<ngwt__DocumentType * >*)p)->end(), *(ngwt__DocumentType **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__DayOfYearWeek:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__DayOfYearWeek * >*)p)->insert(((std::vector<ngwt__DayOfYearWeek * >*)p)->end(), *(ngwt__DayOfYearWeek **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfYear:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<short >*)p)->insert(((std::vector<short >*)p)->end(), *(short *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__DayOfMonth:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<char >*)p)->insert(((std::vector<char >*)p)->end(), *(char *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Custom:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Custom * >*)p)->insert(((std::vector<ngwt__Custom * >*)p)->end(), *(ngwt__Custom **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__uid:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<std::string >*)p)->insert(((std::vector<std::string >*)p)->end(), *(std::string *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__Category:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__Category * >*)p)->insert(((std::vector<ngwt__Category * >*)p)->end(), *(ngwt__Category **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfngwt__CalendarFolderFlags:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<enum ngwt__CalendarFolderFlags >*)p)->insert(((std::vector<enum ngwt__CalendarFolderFlags >*)p)->end(), *(enum ngwt__CalendarFolderFlags *)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AttachmentItemInfo:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__AttachmentItemInfo * >*)p)->insert(((std::vector<ngwt__AttachmentItemInfo * >*)p)->end(), *(ngwt__AttachmentItemInfo **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AddressBook:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__AddressBook * >*)p)->insert(((std::vector<ngwt__AddressBook * >*)p)->end(), *(ngwt__AddressBook **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessRightEntry:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__AccessRightEntry * >*)p)->insert(((std::vector<ngwt__AccessRightEntry * >*)p)->end(), *(ngwt__AccessRightEntry **)q);
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTongwt__AccessControlListEntry:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p\n", st, tt, p, q));
		((std::vector<ngwt__AccessControlListEntry * >*)p)->insert(((std::vector<ngwt__AccessControlListEntry * >*)p)->end(), *(ngwt__AccessControlListEntry **)q);
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__DayOfMonth(struct soap *soap, char *a)
{	soap_default_byte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__DayOfMonth(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__DayOfMonth);
	if (soap_out_ngwt__DayOfMonth(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__DayOfMonth(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_ngwt__DayOfMonth);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_ngwt__DayOfMonth(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__DayOfMonth(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_ngwt__DayOfMonth(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_ngwt__DayOfMonth);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__WeekOfYear(struct soap *soap, short *a)
{	soap_default_short(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__WeekOfYear(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__WeekOfYear);
	if (soap_out_ngwt__WeekOfYear(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__WeekOfYear(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_ngwt__WeekOfYear);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_ngwt__WeekOfYear(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__WeekOfYear(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_ngwt__WeekOfYear(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_ngwt__WeekOfYear);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__DayOfYear(struct soap *soap, short *a)
{	soap_default_short(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__DayOfYear(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__DayOfYear);
	if (soap_out_ngwt__DayOfYear(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__DayOfYear(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_ngwt__DayOfYear);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_ngwt__DayOfYear(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__DayOfYear(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_ngwt__DayOfYear(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_ngwt__DayOfYear);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_short(struct soap *soap, short *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_short
	*a = SOAP_DEFAULT_short;
#else
	*a = (short)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_short(struct soap *soap, const short *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_short);
	if (soap_out_short(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_short(struct soap *soap, const char *tag, int id, const short *a, const char *type)
{
	return soap_outshort(soap, tag, id, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_get_short(struct soap *soap, short *p, const char *tag, const char *type)
{
	if ((p = soap_in_short(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 short * SOAP_FMAC4 soap_in_short(struct soap *soap, const char *tag, short *a, const char *type)
{
	return soap_inshort(soap, tag, a, type, SOAP_TYPE_short);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__GMTOffset(struct soap *soap, int *a)
{	soap_default_int(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__GMTOffset(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__GMTOffset);
	if (soap_out_ngwt__GMTOffset(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__GMTOffset(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_ngwt__GMTOffset);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_ngwt__GMTOffset(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__GMTOffset(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_ngwt__GMTOffset(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_ngwt__GMTOffset);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Month(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Month(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Month);
	if (soap_out_ngwt__Month(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Month(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_ngwt__Month);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_ngwt__Month(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Month(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_ngwt__Month(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_ngwt__Month);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Minute(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Minute(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Minute);
	if (soap_out_ngwt__Minute(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Minute(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_ngwt__Minute);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_ngwt__Minute(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Minute(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_ngwt__Minute(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_ngwt__Minute);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Hour(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Hour(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Hour);
	if (soap_out_ngwt__Hour(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Hour(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_ngwt__Hour);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_ngwt__Hour(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Hour(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_ngwt__Hour(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_ngwt__Hour);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Day(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Day(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Day);
	if (soap_out_ngwt__Day(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Day(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_ngwt__Day);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_ngwt__Day(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Day(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_ngwt__Day(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_ngwt__Day);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLong(struct soap *soap, unsigned long *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLong
	*a = SOAP_DEFAULT_unsignedLong;
#else
	*a = (unsigned long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLong(struct soap *soap, const unsigned long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLong);
	if (soap_out_unsignedLong(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLong(struct soap *soap, const char *tag, int id, const unsigned long *a, const char *type)
{
	return soap_outunsignedLong(soap, tag, id, a, type, SOAP_TYPE_unsignedLong);
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_get_unsignedLong(struct soap *soap, unsigned long *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLong(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_in_unsignedLong(struct soap *soap, const char *tag, unsigned long *a, const char *type)
{
	return soap_inunsignedLong(soap, tag, a, type, SOAP_TYPE_unsignedLong);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_str_code(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (bool)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwe__ItemType(struct soap *soap, enum ngwe__ItemType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwe__ItemType
	*a = SOAP_DEFAULT_ngwe__ItemType;
#else
	*a = (enum ngwe__ItemType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwe__ItemType(struct soap *soap, const enum ngwe__ItemType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwe__ItemType);
	if (soap_out_ngwe__ItemType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwe__ItemType[] =
{	{ (long)AddressBookItem_, "AddressBookItem" },
	{ (long)Appointment___, "Appointment" },
	{ (long)CalendarItem___, "CalendarItem" },
	{ (long)Contact____, "Contact" },
	{ (long)Group__, "Group" },
	{ (long)Mail___, "Mail" },
	{ (long)Note___, "Note" },
	{ (long)Organization____, "Organization" },
	{ (long)PhoneMessage___, "PhoneMessage" },
	{ (long)Resource___, "Resource" },
	{ (long)Task___, "Task" },
	{ (long)DocumentRef_, "DocumentRef" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwe__ItemType2s(struct soap *soap, enum ngwe__ItemType n)
{	const char *s = soap_str_code(soap_codes_ngwe__ItemType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__ItemType(struct soap *soap, const char *tag, int id, const enum ngwe__ItemType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__ItemType), type);
	soap_send(soap, soap_ngwe__ItemType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwe__ItemType * SOAP_FMAC4 soap_get_ngwe__ItemType(struct soap *soap, enum ngwe__ItemType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__ItemType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwe__ItemType(struct soap *soap, const char *s, enum ngwe__ItemType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwe__ItemType, s);
	if (map)
		*a = (enum ngwe__ItemType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwe__ItemType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwe__ItemType * SOAP_FMAC4 soap_in_ngwe__ItemType(struct soap *soap, const char *tag, enum ngwe__ItemType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwe__ItemType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__ItemType, sizeof(enum ngwe__ItemType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwe__ItemType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwe__ItemType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__ItemType, 0, sizeof(enum ngwe__ItemType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwe__Field(struct soap *soap, enum ngwe__Field *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwe__Field
	*a = SOAP_DEFAULT_ngwe__Field;
#else
	*a = (enum ngwe__Field)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwe__Field(struct soap *soap, const enum ngwe__Field *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwe__Field);
	if (soap_out_ngwe__Field(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwe__Field[] =
{	{ (long)AcceptLevel_, "AcceptLevel" },
	{ (long)Alarm_, "Alarm" },
	{ (long)AllDayEvent_, "AllDayEvent" },
	{ (long)Attachment_, "Attachment" },
	{ (long)Category__, "Category" },
	{ (long)Classification_, "Classification" },
	{ (long)Contact___, "Contact" },
	{ (long)DueDate_, "DueDate" },
	{ (long)Duration_, "Duration" },
	{ (long)EmailAddress_, "EmailAddress" },
	{ (long)ExpirationDate_, "ExpirationDate" },
	{ (long)Hidden_, "Hidden" },
	{ (long)IMAddress_, "IMAddress" },
	{ (long)MessageBody_, "MessageBody" },
	{ (long)Name_, "Name" },
	{ (long)Organization___, "Organization" },
	{ (long)Owner_, "Owner" },
	{ (long)PersonalSubject_, "PersonalSubject" },
	{ (long)PhoneNumber_, "PhoneNumber" },
	{ (long)Place_, "Place" },
	{ (long)PostalAddress_, "PostalAddress" },
	{ (long)RecipientStatus_, "RecipientStatus" },
	{ (long)Rights_, "Rights" },
	{ (long)Security_, "Security" },
	{ (long)SendPriority_, "SendPriority" },
	{ (long)StartDate_, "StartDate" },
	{ (long)Subject_, "Subject" },
	{ (long)TaskCategory_, "TaskCategory" },
	{ (long)TaskPriority_, "TaskPriority" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwe__Field2s(struct soap *soap, enum ngwe__Field n)
{	const char *s = soap_str_code(soap_codes_ngwe__Field, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__Field(struct soap *soap, const char *tag, int id, const enum ngwe__Field *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__Field), type);
	soap_send(soap, soap_ngwe__Field2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwe__Field * SOAP_FMAC4 soap_get_ngwe__Field(struct soap *soap, enum ngwe__Field *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__Field(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwe__Field(struct soap *soap, const char *s, enum ngwe__Field *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwe__Field, s);
	if (map)
		*a = (enum ngwe__Field)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwe__Field)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwe__Field * SOAP_FMAC4 soap_in_ngwe__Field(struct soap *soap, const char *tag, enum ngwe__Field *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwe__Field *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__Field, sizeof(enum ngwe__Field), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwe__Field(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwe__Field *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__Field, 0, sizeof(enum ngwe__Field), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwe__EventType(struct soap *soap, enum ngwe__EventType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwe__EventType
	*a = SOAP_DEFAULT_ngwe__EventType;
#else
	*a = (enum ngwe__EventType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwe__EventType(struct soap *soap, const enum ngwe__EventType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwe__EventType);
	if (soap_out_ngwe__EventType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwe__EventType[] =
{	{ (long)AddressBookAdd, "AddressBookAdd" },
	{ (long)AddressBookDelete, "AddressBookDelete" },
	{ (long)AddressBookModify, "AddressBookModify" },
	{ (long)AddressBookItemAdd, "AddressBookItemAdd" },
	{ (long)AddressBookItemDelete, "AddressBookItemDelete" },
	{ (long)AddressBookItemModify, "AddressBookItemModify" },
	{ (long)FolderAccept, "FolderAccept" },
	{ (long)FolderAdd, "FolderAdd" },
	{ (long)FolderDelete, "FolderDelete" },
	{ (long)FolderItemAdd, "FolderItemAdd" },
	{ (long)FolderItemDelete, "FolderItemDelete" },
	{ (long)FolderItemMove, "FolderItemMove" },
	{ (long)FolderModify, "FolderModify" },
	{ (long)ItemAccept, "ItemAccept" },
	{ (long)ItemArchive, "ItemArchive" },
	{ (long)ItemComplete, "ItemComplete" },
	{ (long)ItemDecline, "ItemDecline" },
	{ (long)ItemDelete, "ItemDelete" },
	{ (long)ItemMarkPrivate, "ItemMarkPrivate" },
	{ (long)ItemMarkRead, "ItemMarkRead" },
	{ (long)ItemMarkUnread, "ItemMarkUnread" },
	{ (long)ItemModify, "ItemModify" },
	{ (long)ItemPurge, "ItemPurge" },
	{ (long)ItemUnarchive, "ItemUnarchive" },
	{ (long)ItemUndelete, "ItemUndelete" },
	{ (long)Login, "Login" },
	{ (long)Logout, "Logout" },
	{ (long)ProxyAccessAdd, "ProxyAccessAdd" },
	{ (long)ProxyAccessModify, "ProxyAccessModify" },
	{ (long)ProxyAccessDelete, "ProxyAccessDelete" },
	{ (long)ProxyLogin, "ProxyLogin" },
	{ (long)SessionTimedOut, "SessionTimedOut" },
	{ (long)TrustedApplicationLogin, "TrustedApplicationLogin" },
	{ (long)ItemMarkUnprivate, "ItemMarkUnprivate" },
	{ (long)ItemUnaccept, "ItemUnaccept" },
	{ (long)ItemUncomplete, "ItemUncomplete" },
	{ (long)PersonalGroupItemAdd, "PersonalGroupItemAdd" },
	{ (long)PersonalGroupItemDelete, "PersonalGroupItemDelete" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwe__EventType2s(struct soap *soap, enum ngwe__EventType n)
{	const char *s = soap_str_code(soap_codes_ngwe__EventType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__EventType(struct soap *soap, const char *tag, int id, const enum ngwe__EventType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__EventType), type);
	soap_send(soap, soap_ngwe__EventType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwe__EventType * SOAP_FMAC4 soap_get_ngwe__EventType(struct soap *soap, enum ngwe__EventType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__EventType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwe__EventType(struct soap *soap, const char *s, enum ngwe__EventType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwe__EventType, s);
	if (map)
		*a = (enum ngwe__EventType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwe__EventType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwe__EventType * SOAP_FMAC4 soap_in_ngwe__EventType(struct soap *soap, const char *tag, enum ngwe__EventType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwe__EventType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__EventType, sizeof(enum ngwe__EventType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwe__EventType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwe__EventType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__EventType, 0, sizeof(enum ngwe__EventType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__WeekDay(struct soap *soap, enum ngwt__WeekDay *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__WeekDay
	*a = SOAP_DEFAULT_ngwt__WeekDay;
#else
	*a = (enum ngwt__WeekDay)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__WeekDay(struct soap *soap, const enum ngwt__WeekDay *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__WeekDay);
	if (soap_out_ngwt__WeekDay(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__WeekDay[] =
{	{ (long)Sunday, "Sunday" },
	{ (long)Monday, "Monday" },
	{ (long)Tuesday, "Tuesday" },
	{ (long)Wednesday, "Wednesday" },
	{ (long)Thursday, "Thursday" },
	{ (long)Friday, "Friday" },
	{ (long)Saturday, "Saturday" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__WeekDay2s(struct soap *soap, enum ngwt__WeekDay n)
{	const char *s = soap_str_code(soap_codes_ngwt__WeekDay, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__WeekDay(struct soap *soap, const char *tag, int id, const enum ngwt__WeekDay *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__WeekDay), type);
	soap_send(soap, soap_ngwt__WeekDay2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__WeekDay * SOAP_FMAC4 soap_get_ngwt__WeekDay(struct soap *soap, enum ngwt__WeekDay *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__WeekDay(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__WeekDay(struct soap *soap, const char *s, enum ngwt__WeekDay *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__WeekDay, s);
	if (map)
		*a = (enum ngwt__WeekDay)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__WeekDay)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__WeekDay * SOAP_FMAC4 soap_in_ngwt__WeekDay(struct soap *soap, const char *tag, enum ngwt__WeekDay *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__WeekDay *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__WeekDay, sizeof(enum ngwt__WeekDay), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__WeekDay(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__WeekDay *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__WeekDay, 0, sizeof(enum ngwt__WeekDay), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__VersionStatus(struct soap *soap, enum ngwt__VersionStatus *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__VersionStatus
	*a = SOAP_DEFAULT_ngwt__VersionStatus;
#else
	*a = (enum ngwt__VersionStatus)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__VersionStatus(struct soap *soap, const enum ngwt__VersionStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__VersionStatus);
	if (soap_out_ngwt__VersionStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__VersionStatus[] =
{	{ (long)available, "available" },
	{ (long)checkedOut, "checkedOut" },
	{ (long)inUse, "inUse" },
	{ (long)deleted_, "deleted" },
	{ (long)archived, "archived" },
	{ (long)massInUse, "massInUse" },
	{ (long)unavailable, "unavailable" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__VersionStatus2s(struct soap *soap, enum ngwt__VersionStatus n)
{	const char *s = soap_str_code(soap_codes_ngwt__VersionStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__VersionStatus(struct soap *soap, const char *tag, int id, const enum ngwt__VersionStatus *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__VersionStatus), type);
	soap_send(soap, soap_ngwt__VersionStatus2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__VersionStatus * SOAP_FMAC4 soap_get_ngwt__VersionStatus(struct soap *soap, enum ngwt__VersionStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__VersionStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__VersionStatus(struct soap *soap, const char *s, enum ngwt__VersionStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__VersionStatus, s);
	if (map)
		*a = (enum ngwt__VersionStatus)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__VersionStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__VersionStatus * SOAP_FMAC4 soap_in_ngwt__VersionStatus(struct soap *soap, const char *tag, enum ngwt__VersionStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__VersionStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__VersionStatus, sizeof(enum ngwt__VersionStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__VersionStatus(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__VersionStatus *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__VersionStatus, 0, sizeof(enum ngwt__VersionStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__VersionEventType(struct soap *soap, enum ngwt__VersionEventType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__VersionEventType
	*a = SOAP_DEFAULT_ngwt__VersionEventType;
#else
	*a = (enum ngwt__VersionEventType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__VersionEventType(struct soap *soap, const enum ngwt__VersionEventType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__VersionEventType);
	if (soap_out_ngwt__VersionEventType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__VersionEventType[] =
{	{ (long)archive_, "archive" },
	{ (long)checkIn, "checkIn" },
	{ (long)checkOut, "checkOut" },
	{ (long)copyIn, "copyIn" },
	{ (long)copyOut, "copyOut" },
	{ (long)copyVersion, "copyVersion" },
	{ (long)created, "created" },
	{ (long)deleteVersion, "deleteVersion" },
	{ (long)endAccess, "endAccess" },
	{ (long)resetStatus, "resetStatus" },
	{ (long)restore, "restore" },
	{ (long)retrieve, "retrieve" },
	{ (long)securityModified, "securityModified" },
	{ (long)versionDownloaded, "versionDownloaded" },
	{ (long)viewed, "viewed" },
	{ (long)unknown, "unknown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__VersionEventType2s(struct soap *soap, enum ngwt__VersionEventType n)
{	const char *s = soap_str_code(soap_codes_ngwt__VersionEventType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__VersionEventType(struct soap *soap, const char *tag, int id, const enum ngwt__VersionEventType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__VersionEventType), type);
	soap_send(soap, soap_ngwt__VersionEventType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__VersionEventType * SOAP_FMAC4 soap_get_ngwt__VersionEventType(struct soap *soap, enum ngwt__VersionEventType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__VersionEventType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__VersionEventType(struct soap *soap, const char *s, enum ngwt__VersionEventType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__VersionEventType, s);
	if (map)
		*a = (enum ngwt__VersionEventType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__VersionEventType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__VersionEventType * SOAP_FMAC4 soap_in_ngwt__VersionEventType(struct soap *soap, const char *tag, enum ngwt__VersionEventType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__VersionEventType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__VersionEventType, sizeof(enum ngwt__VersionEventType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__VersionEventType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__VersionEventType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__VersionEventType, 0, sizeof(enum ngwt__VersionEventType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__StatusTrackingOptions(struct soap *soap, enum ngwt__StatusTrackingOptions *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__StatusTrackingOptions
	*a = SOAP_DEFAULT_ngwt__StatusTrackingOptions;
#else
	*a = (enum ngwt__StatusTrackingOptions)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__StatusTrackingOptions(struct soap *soap, const enum ngwt__StatusTrackingOptions *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__StatusTrackingOptions);
	if (soap_out_ngwt__StatusTrackingOptions(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__StatusTrackingOptions[] =
{	{ (long)None, "None" },
	{ (long)Delivered, "Delivered" },
	{ (long)DeliveredAndOpened, "DeliveredAndOpened" },
	{ (long)All_, "All" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__StatusTrackingOptions2s(struct soap *soap, enum ngwt__StatusTrackingOptions n)
{	const char *s = soap_str_code(soap_codes_ngwt__StatusTrackingOptions, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__StatusTrackingOptions(struct soap *soap, const char *tag, int id, const enum ngwt__StatusTrackingOptions *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__StatusTrackingOptions), type);
	soap_send(soap, soap_ngwt__StatusTrackingOptions2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__StatusTrackingOptions * SOAP_FMAC4 soap_get_ngwt__StatusTrackingOptions(struct soap *soap, enum ngwt__StatusTrackingOptions *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__StatusTrackingOptions(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__StatusTrackingOptions(struct soap *soap, const char *s, enum ngwt__StatusTrackingOptions *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__StatusTrackingOptions, s);
	if (map)
		*a = (enum ngwt__StatusTrackingOptions)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__StatusTrackingOptions)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__StatusTrackingOptions * SOAP_FMAC4 soap_in_ngwt__StatusTrackingOptions(struct soap *soap, const char *tag, enum ngwt__StatusTrackingOptions *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__StatusTrackingOptions *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__StatusTrackingOptions, sizeof(enum ngwt__StatusTrackingOptions), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__StatusTrackingOptions(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__StatusTrackingOptions *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__StatusTrackingOptions, 0, sizeof(enum ngwt__StatusTrackingOptions), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__RuleActionType(struct soap *soap, enum ngwt__RuleActionType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__RuleActionType
	*a = SOAP_DEFAULT_ngwt__RuleActionType;
#else
	*a = (enum ngwt__RuleActionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__RuleActionType(struct soap *soap, const enum ngwt__RuleActionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__RuleActionType);
	if (soap_out_ngwt__RuleActionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__RuleActionType[] =
{	{ (long)Accept, "Accept" },
	{ (long)Archive, "Archive" },
	{ (long)Category_, "Category" },
	{ (long)Delegate, "Delegate" },
	{ (long)Delete, "Delete" },
	{ (long)Forward, "Forward" },
	{ (long)Link, "Link" },
	{ (long)MarkPrivate, "MarkPrivate" },
	{ (long)MarkRead, "MarkRead" },
	{ (long)MarkUnread, "MarkUnread" },
	{ (long)Move, "Move" },
	{ (long)Purge, "Purge" },
	{ (long)Reply, "Reply" },
	{ (long)Send, "Send" },
	{ (long)StopRules, "StopRules" },
	{ (long)Unknown, "Unknown" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__RuleActionType2s(struct soap *soap, enum ngwt__RuleActionType n)
{	const char *s = soap_str_code(soap_codes_ngwt__RuleActionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__RuleActionType(struct soap *soap, const char *tag, int id, const enum ngwt__RuleActionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__RuleActionType), type);
	soap_send(soap, soap_ngwt__RuleActionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__RuleActionType * SOAP_FMAC4 soap_get_ngwt__RuleActionType(struct soap *soap, enum ngwt__RuleActionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__RuleActionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__RuleActionType(struct soap *soap, const char *s, enum ngwt__RuleActionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__RuleActionType, s);
	if (map)
		*a = (enum ngwt__RuleActionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__RuleActionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__RuleActionType * SOAP_FMAC4 soap_in_ngwt__RuleActionType(struct soap *soap, const char *tag, enum ngwt__RuleActionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__RuleActionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__RuleActionType, sizeof(enum ngwt__RuleActionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__RuleActionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__RuleActionType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__RuleActionType, 0, sizeof(enum ngwt__RuleActionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__RetractType(struct soap *soap, enum ngwt__RetractType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__RetractType
	*a = SOAP_DEFAULT_ngwt__RetractType;
#else
	*a = (enum ngwt__RetractType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__RetractType(struct soap *soap, const enum ngwt__RetractType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__RetractType);
	if (soap_out_ngwt__RetractType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__RetractType[] =
{	{ (long)myMailbox, "myMailbox" },
	{ (long)recipientMailboxes, "recipientMailboxes" },
	{ (long)allMailboxes, "allMailboxes" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__RetractType2s(struct soap *soap, enum ngwt__RetractType n)
{	const char *s = soap_str_code(soap_codes_ngwt__RetractType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__RetractType(struct soap *soap, const char *tag, int id, const enum ngwt__RetractType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__RetractType), type);
	soap_send(soap, soap_ngwt__RetractType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__RetractType * SOAP_FMAC4 soap_get_ngwt__RetractType(struct soap *soap, enum ngwt__RetractType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__RetractType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__RetractType(struct soap *soap, const char *s, enum ngwt__RetractType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__RetractType, s);
	if (map)
		*a = (enum ngwt__RetractType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__RetractType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__RetractType * SOAP_FMAC4 soap_in_ngwt__RetractType(struct soap *soap, const char *tag, enum ngwt__RetractType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__RetractType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__RetractType, sizeof(enum ngwt__RetractType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__RetractType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__RetractType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__RetractType, 0, sizeof(enum ngwt__RetractType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__RecipientType(struct soap *soap, enum ngwt__RecipientType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__RecipientType
	*a = SOAP_DEFAULT_ngwt__RecipientType;
#else
	*a = (enum ngwt__RecipientType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__RecipientType(struct soap *soap, const enum ngwt__RecipientType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__RecipientType);
	if (soap_out_ngwt__RecipientType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__RecipientType[] =
{	{ (long)User_, "User" },
	{ (long)Resource__, "Resource" },
	{ (long)PersonalGroup, "PersonalGroup" },
	{ (long)SystemGroup, "SystemGroup" },
	{ (long)PersonalGroupMember, "PersonalGroupMember" },
	{ (long)SystemGroupMember, "SystemGroupMember" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__RecipientType2s(struct soap *soap, enum ngwt__RecipientType n)
{	const char *s = soap_str_code(soap_codes_ngwt__RecipientType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__RecipientType(struct soap *soap, const char *tag, int id, const enum ngwt__RecipientType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__RecipientType), type);
	soap_send(soap, soap_ngwt__RecipientType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__RecipientType * SOAP_FMAC4 soap_get_ngwt__RecipientType(struct soap *soap, enum ngwt__RecipientType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__RecipientType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__RecipientType(struct soap *soap, const char *s, enum ngwt__RecipientType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__RecipientType, s);
	if (map)
		*a = (enum ngwt__RecipientType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__RecipientType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__RecipientType * SOAP_FMAC4 soap_in_ngwt__RecipientType(struct soap *soap, const char *tag, enum ngwt__RecipientType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__RecipientType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__RecipientType, sizeof(enum ngwt__RecipientType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__RecipientType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__RecipientType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__RecipientType, 0, sizeof(enum ngwt__RecipientType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__PostalAddressType(struct soap *soap, enum ngwt__PostalAddressType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__PostalAddressType
	*a = SOAP_DEFAULT_ngwt__PostalAddressType;
#else
	*a = (enum ngwt__PostalAddressType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__PostalAddressType(struct soap *soap, const enum ngwt__PostalAddressType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__PostalAddressType);
	if (soap_out_ngwt__PostalAddressType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__PostalAddressType[] =
{	{ (long)Home_, "Home" },
	{ (long)Office_, "Office" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__PostalAddressType2s(struct soap *soap, enum ngwt__PostalAddressType n)
{	const char *s = soap_str_code(soap_codes_ngwt__PostalAddressType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__PostalAddressType(struct soap *soap, const char *tag, int id, const enum ngwt__PostalAddressType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__PostalAddressType), type);
	soap_send(soap, soap_ngwt__PostalAddressType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__PostalAddressType * SOAP_FMAC4 soap_get_ngwt__PostalAddressType(struct soap *soap, enum ngwt__PostalAddressType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__PostalAddressType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__PostalAddressType(struct soap *soap, const char *s, enum ngwt__PostalAddressType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__PostalAddressType, s);
	if (map)
		*a = (enum ngwt__PostalAddressType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__PostalAddressType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__PostalAddressType * SOAP_FMAC4 soap_in_ngwt__PostalAddressType(struct soap *soap, const char *tag, enum ngwt__PostalAddressType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__PostalAddressType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__PostalAddressType, sizeof(enum ngwt__PostalAddressType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__PostalAddressType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__PostalAddressType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__PostalAddressType, 0, sizeof(enum ngwt__PostalAddressType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__PhoneNumberType(struct soap *soap, enum ngwt__PhoneNumberType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__PhoneNumberType
	*a = SOAP_DEFAULT_ngwt__PhoneNumberType;
#else
	*a = (enum ngwt__PhoneNumberType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__PhoneNumberType(struct soap *soap, const enum ngwt__PhoneNumberType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__PhoneNumberType);
	if (soap_out_ngwt__PhoneNumberType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__PhoneNumberType[] =
{	{ (long)Fax, "Fax" },
	{ (long)Home, "Home" },
	{ (long)Mobile, "Mobile" },
	{ (long)Office, "Office" },
	{ (long)Pager, "Pager" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__PhoneNumberType2s(struct soap *soap, enum ngwt__PhoneNumberType n)
{	const char *s = soap_str_code(soap_codes_ngwt__PhoneNumberType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__PhoneNumberType(struct soap *soap, const char *tag, int id, const enum ngwt__PhoneNumberType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__PhoneNumberType), type);
	soap_send(soap, soap_ngwt__PhoneNumberType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__PhoneNumberType * SOAP_FMAC4 soap_get_ngwt__PhoneNumberType(struct soap *soap, enum ngwt__PhoneNumberType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__PhoneNumberType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__PhoneNumberType(struct soap *soap, const char *s, enum ngwt__PhoneNumberType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__PhoneNumberType, s);
	if (map)
		*a = (enum ngwt__PhoneNumberType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__PhoneNumberType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__PhoneNumberType * SOAP_FMAC4 soap_in_ngwt__PhoneNumberType(struct soap *soap, const char *tag, enum ngwt__PhoneNumberType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__PhoneNumberType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__PhoneNumberType, sizeof(enum ngwt__PhoneNumberType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__PhoneNumberType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__PhoneNumberType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__PhoneNumberType, 0, sizeof(enum ngwt__PhoneNumberType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__OccurrenceType(struct soap *soap, enum ngwt__OccurrenceType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__OccurrenceType
	*a = SOAP_DEFAULT_ngwt__OccurrenceType;
#else
	*a = (enum ngwt__OccurrenceType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__OccurrenceType(struct soap *soap, const enum ngwt__OccurrenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__OccurrenceType);
	if (soap_out_ngwt__OccurrenceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__OccurrenceType[] =
{	{ (long)First, "First" },
	{ (long)Second, "Second" },
	{ (long)Third, "Third" },
	{ (long)Fourth, "Fourth" },
	{ (long)Fifth, "Fifth" },
	{ (long)Last, "Last" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__OccurrenceType2s(struct soap *soap, enum ngwt__OccurrenceType n)
{	const char *s = soap_str_code(soap_codes_ngwt__OccurrenceType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__OccurrenceType(struct soap *soap, const char *tag, int id, const enum ngwt__OccurrenceType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__OccurrenceType), type);
	soap_send(soap, soap_ngwt__OccurrenceType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__OccurrenceType * SOAP_FMAC4 soap_get_ngwt__OccurrenceType(struct soap *soap, enum ngwt__OccurrenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__OccurrenceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__OccurrenceType(struct soap *soap, const char *s, enum ngwt__OccurrenceType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__OccurrenceType, s);
	if (map)
		*a = (enum ngwt__OccurrenceType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__OccurrenceType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__OccurrenceType * SOAP_FMAC4 soap_in_ngwt__OccurrenceType(struct soap *soap, const char *tag, enum ngwt__OccurrenceType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__OccurrenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__OccurrenceType, sizeof(enum ngwt__OccurrenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__OccurrenceType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__OccurrenceType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__OccurrenceType, 0, sizeof(enum ngwt__OccurrenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__NotificationType(struct soap *soap, enum ngwt__NotificationType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__NotificationType
	*a = SOAP_DEFAULT_ngwt__NotificationType;
#else
	*a = (enum ngwt__NotificationType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__NotificationType(struct soap *soap, const enum ngwt__NotificationType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__NotificationType);
	if (soap_out_ngwt__NotificationType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__NotificationType[] =
{	{ (long)SharedAddressBook, "SharedAddressBook" },
	{ (long)SharedFolder, "SharedFolder" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__NotificationType2s(struct soap *soap, enum ngwt__NotificationType n)
{	const char *s = soap_str_code(soap_codes_ngwt__NotificationType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__NotificationType(struct soap *soap, const char *tag, int id, const enum ngwt__NotificationType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__NotificationType), type);
	soap_send(soap, soap_ngwt__NotificationType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__NotificationType * SOAP_FMAC4 soap_get_ngwt__NotificationType(struct soap *soap, enum ngwt__NotificationType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__NotificationType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__NotificationType(struct soap *soap, const char *s, enum ngwt__NotificationType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__NotificationType, s);
	if (map)
		*a = (enum ngwt__NotificationType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__NotificationType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__NotificationType * SOAP_FMAC4 soap_in_ngwt__NotificationType(struct soap *soap, const char *tag, enum ngwt__NotificationType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__NotificationType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__NotificationType, sizeof(enum ngwt__NotificationType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__NotificationType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__NotificationType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__NotificationType, 0, sizeof(enum ngwt__NotificationType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__MessageType(struct soap *soap, enum ngwt__MessageType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__MessageType
	*a = SOAP_DEFAULT_ngwt__MessageType;
#else
	*a = (enum ngwt__MessageType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__MessageType(struct soap *soap, const enum ngwt__MessageType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__MessageType);
	if (soap_out_ngwt__MessageType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__MessageType[] =
{	{ (long)Appointment__, "Appointment" },
	{ (long)CalendarItem__, "CalendarItem" },
	{ (long)DocumentReference_, "DocumentReference" },
	{ (long)Mail__, "Mail" },
	{ (long)Note__, "Note" },
	{ (long)PhoneMessage__, "PhoneMessage" },
	{ (long)Task__, "Task" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__MessageType2s(struct soap *soap, enum ngwt__MessageType n)
{	const char *s = soap_str_code(soap_codes_ngwt__MessageType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__MessageType(struct soap *soap, const char *tag, int id, const enum ngwt__MessageType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__MessageType), type);
	soap_send(soap, soap_ngwt__MessageType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__MessageType * SOAP_FMAC4 soap_get_ngwt__MessageType(struct soap *soap, enum ngwt__MessageType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__MessageType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__MessageType(struct soap *soap, const char *s, enum ngwt__MessageType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	soap_s2TQName(soap, s, &t);
	map = soap_code(soap_codes_ngwt__MessageType, t);
	if (map)
		*a = (enum ngwt__MessageType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__MessageType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__MessageType * SOAP_FMAC4 soap_in_ngwt__MessageType(struct soap *soap, const char *tag, enum ngwt__MessageType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__MessageType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__MessageType, sizeof(enum ngwt__MessageType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__MessageType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__MessageType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__MessageType, 0, sizeof(enum ngwt__MessageType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__MessageList(struct soap *soap, enum ngwt__MessageList *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__MessageList
	*a = SOAP_DEFAULT_ngwt__MessageList;
#else
	*a = (enum ngwt__MessageList)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__MessageList(struct soap *soap, const enum ngwt__MessageList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__MessageList);
	if (soap_out_ngwt__MessageList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__MessageList[] =
{	{ (long)All, "All" },
	{ (long)Modified, "Modified" },
	{ (long)New_, "New" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__MessageList2s(struct soap *soap, enum ngwt__MessageList n)
{	const char *s = soap_str_code(soap_codes_ngwt__MessageList, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__MessageList(struct soap *soap, const char *tag, int id, const enum ngwt__MessageList *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__MessageList), type);
	soap_send(soap, soap_ngwt__MessageList2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__MessageList * SOAP_FMAC4 soap_get_ngwt__MessageList(struct soap *soap, enum ngwt__MessageList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__MessageList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__MessageList(struct soap *soap, const char *s, enum ngwt__MessageList *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__MessageList, s);
	if (map)
		*a = (enum ngwt__MessageList)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__MessageList)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__MessageList * SOAP_FMAC4 soap_in_ngwt__MessageList(struct soap *soap, const char *tag, enum ngwt__MessageList *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__MessageList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__MessageList, sizeof(enum ngwt__MessageList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__MessageList(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__MessageList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__MessageList, 0, sizeof(enum ngwt__MessageList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__LinkType(struct soap *soap, enum ngwt__LinkType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__LinkType
	*a = SOAP_DEFAULT_ngwt__LinkType;
#else
	*a = (enum ngwt__LinkType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__LinkType(struct soap *soap, const enum ngwt__LinkType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__LinkType);
	if (soap_out_ngwt__LinkType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__LinkType[] =
{	{ (long)forward, "forward" },
	{ (long)reply, "reply" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__LinkType2s(struct soap *soap, enum ngwt__LinkType n)
{	const char *s = soap_str_code(soap_codes_ngwt__LinkType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__LinkType(struct soap *soap, const char *tag, int id, const enum ngwt__LinkType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__LinkType), type);
	soap_send(soap, soap_ngwt__LinkType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__LinkType * SOAP_FMAC4 soap_get_ngwt__LinkType(struct soap *soap, enum ngwt__LinkType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__LinkType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__LinkType(struct soap *soap, const char *s, enum ngwt__LinkType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__LinkType, s);
	if (map)
		*a = (enum ngwt__LinkType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__LinkType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__LinkType * SOAP_FMAC4 soap_in_ngwt__LinkType(struct soap *soap, const char *tag, enum ngwt__LinkType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__LinkType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__LinkType, sizeof(enum ngwt__LinkType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__LinkType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__LinkType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__LinkType, 0, sizeof(enum ngwt__LinkType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__JunkMatchType(struct soap *soap, enum ngwt__JunkMatchType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__JunkMatchType
	*a = SOAP_DEFAULT_ngwt__JunkMatchType;
#else
	*a = (enum ngwt__JunkMatchType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__JunkMatchType(struct soap *soap, const enum ngwt__JunkMatchType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__JunkMatchType);
	if (soap_out_ngwt__JunkMatchType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__JunkMatchType[] =
{	{ (long)email, "email" },
	{ (long)domain, "domain" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__JunkMatchType2s(struct soap *soap, enum ngwt__JunkMatchType n)
{	const char *s = soap_str_code(soap_codes_ngwt__JunkMatchType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__JunkMatchType(struct soap *soap, const char *tag, int id, const enum ngwt__JunkMatchType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__JunkMatchType), type);
	soap_send(soap, soap_ngwt__JunkMatchType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__JunkMatchType * SOAP_FMAC4 soap_get_ngwt__JunkMatchType(struct soap *soap, enum ngwt__JunkMatchType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__JunkMatchType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__JunkMatchType(struct soap *soap, const char *s, enum ngwt__JunkMatchType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__JunkMatchType, s);
	if (map)
		*a = (enum ngwt__JunkMatchType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__JunkMatchType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__JunkMatchType * SOAP_FMAC4 soap_in_ngwt__JunkMatchType(struct soap *soap, const char *tag, enum ngwt__JunkMatchType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__JunkMatchType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__JunkMatchType, sizeof(enum ngwt__JunkMatchType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__JunkMatchType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__JunkMatchType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__JunkMatchType, 0, sizeof(enum ngwt__JunkMatchType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__JunkHandlingListType(struct soap *soap, enum ngwt__JunkHandlingListType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__JunkHandlingListType
	*a = SOAP_DEFAULT_ngwt__JunkHandlingListType;
#else
	*a = (enum ngwt__JunkHandlingListType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__JunkHandlingListType(struct soap *soap, const enum ngwt__JunkHandlingListType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__JunkHandlingListType);
	if (soap_out_ngwt__JunkHandlingListType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__JunkHandlingListType[] =
{	{ (long)junk, "junk" },
	{ (long)block, "block" },
	{ (long)trust, "trust" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__JunkHandlingListType2s(struct soap *soap, enum ngwt__JunkHandlingListType n)
{	const char *s = soap_str_code(soap_codes_ngwt__JunkHandlingListType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__JunkHandlingListType(struct soap *soap, const char *tag, int id, const enum ngwt__JunkHandlingListType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__JunkHandlingListType), type);
	soap_send(soap, soap_ngwt__JunkHandlingListType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__JunkHandlingListType * SOAP_FMAC4 soap_get_ngwt__JunkHandlingListType(struct soap *soap, enum ngwt__JunkHandlingListType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__JunkHandlingListType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__JunkHandlingListType(struct soap *soap, const char *s, enum ngwt__JunkHandlingListType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__JunkHandlingListType, s);
	if (map)
		*a = (enum ngwt__JunkHandlingListType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__JunkHandlingListType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__JunkHandlingListType * SOAP_FMAC4 soap_in_ngwt__JunkHandlingListType(struct soap *soap, const char *tag, enum ngwt__JunkHandlingListType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__JunkHandlingListType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__JunkHandlingListType, sizeof(enum ngwt__JunkHandlingListType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__JunkHandlingListType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__JunkHandlingListType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__JunkHandlingListType, 0, sizeof(enum ngwt__JunkHandlingListType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ItemSource(struct soap *soap, enum ngwt__ItemSource *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ItemSource
	*a = SOAP_DEFAULT_ngwt__ItemSource;
#else
	*a = (enum ngwt__ItemSource)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ItemSource(struct soap *soap, const enum ngwt__ItemSource *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ItemSource);
	if (soap_out_ngwt__ItemSource(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ItemSource[] =
{	{ (long)received_, "received" },
	{ (long)sent_, "sent" },
	{ (long)draft_, "draft" },
	{ (long)personal_, "personal" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__ItemSource2s(struct soap *soap, enum ngwt__ItemSource n)
{	const char *s = soap_str_code(soap_codes_ngwt__ItemSource, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ItemSource(struct soap *soap, const char *tag, int id, const enum ngwt__ItemSource *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ItemSource), type);
	soap_send(soap, soap_ngwt__ItemSource2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ItemSource * SOAP_FMAC4 soap_get_ngwt__ItemSource(struct soap *soap, enum ngwt__ItemSource *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ItemSource(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__ItemSource(struct soap *soap, const char *s, enum ngwt__ItemSource *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__ItemSource, s);
	if (map)
		*a = (enum ngwt__ItemSource)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__ItemSource)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__ItemSource * SOAP_FMAC4 soap_in_ngwt__ItemSource(struct soap *soap, const char *tag, enum ngwt__ItemSource *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ItemSource *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ItemSource, sizeof(enum ngwt__ItemSource), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__ItemSource(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ItemSource *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ItemSource, 0, sizeof(enum ngwt__ItemSource), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ItemSecurity(struct soap *soap, enum ngwt__ItemSecurity *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ItemSecurity
	*a = SOAP_DEFAULT_ngwt__ItemSecurity;
#else
	*a = (enum ngwt__ItemSecurity)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ItemSecurity(struct soap *soap, const enum ngwt__ItemSecurity *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ItemSecurity);
	if (soap_out_ngwt__ItemSecurity(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ItemSecurity[] =
{	{ (long)Normal__, "Normal" },
	{ (long)Proprietary, "Proprietary" },
	{ (long)Confidential, "Confidential" },
	{ (long)Secret, "Secret" },
	{ (long)TopSecret, "TopSecret" },
	{ (long)ForYourEyesOnly, "ForYourEyesOnly" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__ItemSecurity2s(struct soap *soap, enum ngwt__ItemSecurity n)
{	const char *s = soap_str_code(soap_codes_ngwt__ItemSecurity, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ItemSecurity(struct soap *soap, const char *tag, int id, const enum ngwt__ItemSecurity *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ItemSecurity), type);
	soap_send(soap, soap_ngwt__ItemSecurity2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ItemSecurity * SOAP_FMAC4 soap_get_ngwt__ItemSecurity(struct soap *soap, enum ngwt__ItemSecurity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ItemSecurity(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__ItemSecurity(struct soap *soap, const char *s, enum ngwt__ItemSecurity *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	//soap_s2TQName(soap, s, &t);
	map = soap_code(soap_codes_ngwt__ItemSecurity, s);
	if (map)
		*a = (enum ngwt__ItemSecurity)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__ItemSecurity)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__ItemSecurity * SOAP_FMAC4 soap_in_ngwt__ItemSecurity(struct soap *soap, const char *tag, enum ngwt__ItemSecurity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ItemSecurity *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ItemSecurity, sizeof(enum ngwt__ItemSecurity), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__ItemSecurity(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ItemSecurity *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ItemSecurity, 0, sizeof(enum ngwt__ItemSecurity), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ItemOptionsPriority(struct soap *soap, enum ngwt__ItemOptionsPriority *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ItemOptionsPriority
	*a = SOAP_DEFAULT_ngwt__ItemOptionsPriority;
#else
	*a = (enum ngwt__ItemOptionsPriority)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ItemOptionsPriority(struct soap *soap, const enum ngwt__ItemOptionsPriority *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ItemOptionsPriority);
	if (soap_out_ngwt__ItemOptionsPriority(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ItemOptionsPriority[] =
{	{ (long)High, "High" },
	{ (long)Standard, "Standard" },
	{ (long)Low, "Low" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__ItemOptionsPriority2s(struct soap *soap, enum ngwt__ItemOptionsPriority n)
{	const char *s = soap_str_code(soap_codes_ngwt__ItemOptionsPriority, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ItemOptionsPriority(struct soap *soap, const char *tag, int id, const enum ngwt__ItemOptionsPriority *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ItemOptionsPriority), type);
	soap_send(soap, soap_ngwt__ItemOptionsPriority2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ItemOptionsPriority * SOAP_FMAC4 soap_get_ngwt__ItemOptionsPriority(struct soap *soap, enum ngwt__ItemOptionsPriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ItemOptionsPriority(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__ItemOptionsPriority(struct soap *soap, const char *s, enum ngwt__ItemOptionsPriority *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__ItemOptionsPriority, s);
	if (map)
		*a = (enum ngwt__ItemOptionsPriority)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__ItemOptionsPriority)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__ItemOptionsPriority * SOAP_FMAC4 soap_in_ngwt__ItemOptionsPriority(struct soap *soap, const char *tag, enum ngwt__ItemOptionsPriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ItemOptionsPriority *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ItemOptionsPriority, sizeof(enum ngwt__ItemOptionsPriority), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__ItemOptionsPriority(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ItemOptionsPriority *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ItemOptionsPriority, 0, sizeof(enum ngwt__ItemOptionsPriority), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ItemClass(struct soap *soap, enum ngwt__ItemClass *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ItemClass
	*a = SOAP_DEFAULT_ngwt__ItemClass;
#else
	*a = (enum ngwt__ItemClass)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ItemClass(struct soap *soap, const enum ngwt__ItemClass *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ItemClass);
	if (soap_out_ngwt__ItemClass(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ItemClass[] =
{	{ (long)Public, "Public" },
	{ (long)Private, "Private" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__ItemClass2s(struct soap *soap, enum ngwt__ItemClass n)
{	const char *s = soap_str_code(soap_codes_ngwt__ItemClass, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ItemClass(struct soap *soap, const char *tag, int id, const enum ngwt__ItemClass *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ItemClass), type);
	soap_send(soap, soap_ngwt__ItemClass2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ItemClass * SOAP_FMAC4 soap_get_ngwt__ItemClass(struct soap *soap, enum ngwt__ItemClass *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ItemClass(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__ItemClass(struct soap *soap, const char *s, enum ngwt__ItemClass *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__ItemClass, s);
	if (map)
		*a = (enum ngwt__ItemClass)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__ItemClass)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__ItemClass * SOAP_FMAC4 soap_in_ngwt__ItemClass(struct soap *soap, const char *tag, enum ngwt__ItemClass *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ItemClass *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ItemClass, sizeof(enum ngwt__ItemClass), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__ItemClass(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ItemClass *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ItemClass, 0, sizeof(enum ngwt__ItemClass), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Frequency(struct soap *soap, enum ngwt__Frequency *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__Frequency
	*a = SOAP_DEFAULT_ngwt__Frequency;
#else
	*a = (enum ngwt__Frequency)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Frequency(struct soap *soap, const enum ngwt__Frequency *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Frequency);
	if (soap_out_ngwt__Frequency(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__Frequency[] =
{	{ (long)Daily, "Daily" },
	{ (long)Weekly, "Weekly" },
	{ (long)Monthly, "Monthly" },
	{ (long)Yearly, "Yearly" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__Frequency2s(struct soap *soap, enum ngwt__Frequency n)
{	const char *s = soap_str_code(soap_codes_ngwt__Frequency, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Frequency(struct soap *soap, const char *tag, int id, const enum ngwt__Frequency *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__Frequency), type);
	soap_send(soap, soap_ngwt__Frequency2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__Frequency * SOAP_FMAC4 soap_get_ngwt__Frequency(struct soap *soap, enum ngwt__Frequency *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Frequency(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__Frequency(struct soap *soap, const char *s, enum ngwt__Frequency *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__Frequency, s);
	if (map)
		*a = (enum ngwt__Frequency)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__Frequency)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__Frequency * SOAP_FMAC4 soap_in_ngwt__Frequency(struct soap *soap, const char *tag, enum ngwt__Frequency *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__Frequency *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__Frequency, sizeof(enum ngwt__Frequency), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__Frequency(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__Frequency *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__Frequency, 0, sizeof(enum ngwt__Frequency), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__FolderType(struct soap *soap, enum ngwt__FolderType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__FolderType
	*a = SOAP_DEFAULT_ngwt__FolderType;
#else
	*a = (enum ngwt__FolderType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__FolderType(struct soap *soap, const enum ngwt__FolderType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__FolderType);
	if (soap_out_ngwt__FolderType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__FolderType[] =
{	{ (long)Mailbox, "Mailbox" },
	{ (long)SentItems, "SentItems" },
	{ (long)Draft, "Draft" },
	{ (long)Trash, "Trash" },
	{ (long)Calendar, "Calendar" },
	{ (long)Contacts, "Contacts" },
	{ (long)Documents, "Documents" },
	{ (long)Checklist, "Checklist" },
	{ (long)Cabinet, "Cabinet" },
	{ (long)Normal_, "Normal" },
	{ (long)NNTPServer, "NNTPServer" },
	{ (long)NNTPNewsGroup, "NNTPNewsGroup" },
	{ (long)IMAP, "IMAP" },
	{ (long)Query, "Query" },
	{ (long)Root, "Root" },
	{ (long)JunkMail, "JunkMail" },
	{ (long)Notes, "Notes" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__FolderType2s(struct soap *soap, enum ngwt__FolderType n)
{	const char *s = soap_str_code(soap_codes_ngwt__FolderType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__FolderType(struct soap *soap, const char *tag, int id, const enum ngwt__FolderType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__FolderType), type);
	soap_send(soap, soap_ngwt__FolderType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__FolderType * SOAP_FMAC4 soap_get_ngwt__FolderType(struct soap *soap, enum ngwt__FolderType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__FolderType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__FolderType(struct soap *soap, const char *s, enum ngwt__FolderType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__FolderType, s);
	if (map)
		*a = (enum ngwt__FolderType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__FolderType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__FolderType * SOAP_FMAC4 soap_in_ngwt__FolderType(struct soap *soap, const char *tag, enum ngwt__FolderType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__FolderType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__FolderType, sizeof(enum ngwt__FolderType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__FolderType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__FolderType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__FolderType, 0, sizeof(enum ngwt__FolderType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__FolderACLStatus(struct soap *soap, enum ngwt__FolderACLStatus *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__FolderACLStatus
	*a = SOAP_DEFAULT_ngwt__FolderACLStatus;
#else
	*a = (enum ngwt__FolderACLStatus)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__FolderACLStatus(struct soap *soap, const enum ngwt__FolderACLStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__FolderACLStatus);
	if (soap_out_ngwt__FolderACLStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__FolderACLStatus[] =
{	{ (long)pending, "pending" },
	{ (long)accepted, "accepted" },
	{ (long)deleted, "deleted" },
	{ (long)opened, "opened" },
	{ (long)owner, "owner" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__FolderACLStatus2s(struct soap *soap, enum ngwt__FolderACLStatus n)
{	const char *s = soap_str_code(soap_codes_ngwt__FolderACLStatus, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__FolderACLStatus(struct soap *soap, const char *tag, int id, const enum ngwt__FolderACLStatus *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__FolderACLStatus), type);
	soap_send(soap, soap_ngwt__FolderACLStatus2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__FolderACLStatus * SOAP_FMAC4 soap_get_ngwt__FolderACLStatus(struct soap *soap, enum ngwt__FolderACLStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__FolderACLStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__FolderACLStatus(struct soap *soap, const char *s, enum ngwt__FolderACLStatus *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__FolderACLStatus, s);
	if (map)
		*a = (enum ngwt__FolderACLStatus)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__FolderACLStatus)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__FolderACLStatus * SOAP_FMAC4 soap_in_ngwt__FolderACLStatus(struct soap *soap, const char *tag, enum ngwt__FolderACLStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__FolderACLStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__FolderACLStatus, sizeof(enum ngwt__FolderACLStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__FolderACLStatus(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__FolderACLStatus *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__FolderACLStatus, 0, sizeof(enum ngwt__FolderACLStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__FilterOp(struct soap *soap, enum ngwt__FilterOp *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__FilterOp
	*a = SOAP_DEFAULT_ngwt__FilterOp;
#else
	*a = (enum ngwt__FilterOp)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__FilterOp(struct soap *soap, const enum ngwt__FilterOp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__FilterOp);
	if (soap_out_ngwt__FilterOp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__FilterOp[] =
{	{ (long)and_, "and" },
	{ (long)or_, "or" },
	{ (long)not_, "not" },
	{ (long)eq, "eq" },
	{ (long)ne, "ne" },
	{ (long)gt, "gt" },
	{ (long)lt, "lt" },
	{ (long)gte, "gte" },
	{ (long)lte, "lte" },
	{ (long)contains, "contains" },
	{ (long)containsWord, "containsWord" },
	{ (long)begins, "begins" },
	{ (long)exists, "exists" },
	{ (long)notExist, "notExist" },
	{ (long)isOf, "isOf" },
	{ (long)isNotOf, "isNotOf" },
	{ (long)fieldEqual, "fieldEqual" },
	{ (long)fieldGTE, "fieldGTE" },
	{ (long)fieldGT, "fieldGT" },
	{ (long)fieldLTE, "fieldLTE" },
	{ (long)fieldLT, "fieldLT" },
	{ (long)fieldNE, "fieldNE" },
	{ (long)fieldDateEqual, "fieldDateEqual" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__FilterOp2s(struct soap *soap, enum ngwt__FilterOp n)
{	const char *s = soap_str_code(soap_codes_ngwt__FilterOp, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__FilterOp(struct soap *soap, const char *tag, int id, const enum ngwt__FilterOp *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__FilterOp), type);
	soap_send(soap, soap_ngwt__FilterOp2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__FilterOp * SOAP_FMAC4 soap_get_ngwt__FilterOp(struct soap *soap, enum ngwt__FilterOp *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__FilterOp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__FilterOp(struct soap *soap, const char *s, enum ngwt__FilterOp *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__FilterOp, s);
	if (map)
		*a = (enum ngwt__FilterOp)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__FilterOp)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__FilterOp * SOAP_FMAC4 soap_in_ngwt__FilterOp(struct soap *soap, const char *tag, enum ngwt__FilterOp *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__FilterOp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__FilterOp, sizeof(enum ngwt__FilterOp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__FilterOp(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__FilterOp *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__FilterOp, 0, sizeof(enum ngwt__FilterOp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__FilterDate(struct soap *soap, enum ngwt__FilterDate *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__FilterDate
	*a = SOAP_DEFAULT_ngwt__FilterDate;
#else
	*a = (enum ngwt__FilterDate)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__FilterDate(struct soap *soap, const enum ngwt__FilterDate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__FilterDate);
	if (soap_out_ngwt__FilterDate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__FilterDate[] =
{	{ (long)Today, "Today" },
	{ (long)Tomorrow, "Tomorrow" },
	{ (long)ThisMonth, "ThisMonth" },
	{ (long)ThisWeek, "ThisWeek" },
	{ (long)ThisYear, "ThisYear" },
	{ (long)Yesterday, "Yesterday" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__FilterDate2s(struct soap *soap, enum ngwt__FilterDate n)
{	const char *s = soap_str_code(soap_codes_ngwt__FilterDate, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__FilterDate(struct soap *soap, const char *tag, int id, const enum ngwt__FilterDate *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__FilterDate), type);
	soap_send(soap, soap_ngwt__FilterDate2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__FilterDate * SOAP_FMAC4 soap_get_ngwt__FilterDate(struct soap *soap, enum ngwt__FilterDate *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__FilterDate(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__FilterDate(struct soap *soap, const char *s, enum ngwt__FilterDate *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__FilterDate, s);
	if (map)
		*a = (enum ngwt__FilterDate)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__FilterDate)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__FilterDate * SOAP_FMAC4 soap_in_ngwt__FilterDate(struct soap *soap, const char *tag, enum ngwt__FilterDate *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__FilterDate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__FilterDate, sizeof(enum ngwt__FilterDate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__FilterDate(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__FilterDate *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__FilterDate, 0, sizeof(enum ngwt__FilterDate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__Execution(struct soap *soap, enum ngwt__Execution *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__Execution
	*a = SOAP_DEFAULT_ngwt__Execution;
#else
	*a = (enum ngwt__Execution)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__Execution(struct soap *soap, const enum ngwt__Execution *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__Execution);
	if (soap_out_ngwt__Execution(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__Execution[] =
{	{ (long)Startup, "Startup" },
	{ (long)Exit, "Exit" },
	{ (long)New, "New" },
	{ (long)FolderOpen, "FolderOpen" },
	{ (long)FolderClose, "FolderClose" },
	{ (long)FolderNew, "FolderNew" },
	{ (long)User, "User" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__Execution2s(struct soap *soap, enum ngwt__Execution n)
{	const char *s = soap_str_code(soap_codes_ngwt__Execution, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__Execution(struct soap *soap, const char *tag, int id, const enum ngwt__Execution *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__Execution), type);
	soap_send(soap, soap_ngwt__Execution2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__Execution * SOAP_FMAC4 soap_get_ngwt__Execution(struct soap *soap, enum ngwt__Execution *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__Execution(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__Execution(struct soap *soap, const char *s, enum ngwt__Execution *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__Execution, s);
	if (map)
		*a = (enum ngwt__Execution)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__Execution)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__Execution * SOAP_FMAC4 soap_in_ngwt__Execution(struct soap *soap, const char *tag, enum ngwt__Execution *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__Execution *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__Execution, sizeof(enum ngwt__Execution), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__Execution(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__Execution *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__Execution, 0, sizeof(enum ngwt__Execution), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__DistributionType(struct soap *soap, enum ngwt__DistributionType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__DistributionType
	*a = SOAP_DEFAULT_ngwt__DistributionType;
#else
	*a = (enum ngwt__DistributionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__DistributionType(struct soap *soap, const enum ngwt__DistributionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__DistributionType);
	if (soap_out_ngwt__DistributionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__DistributionType[] =
{	{ (long)TO, "TO" },
	{ (long)CC, "CC" },
	{ (long)BC, "BC" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__DistributionType2s(struct soap *soap, enum ngwt__DistributionType n)
{	const char *s = soap_str_code(soap_codes_ngwt__DistributionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__DistributionType(struct soap *soap, const char *tag, int id, const enum ngwt__DistributionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__DistributionType), type);
	soap_send(soap, soap_ngwt__DistributionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__DistributionType * SOAP_FMAC4 soap_get_ngwt__DistributionType(struct soap *soap, enum ngwt__DistributionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__DistributionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__DistributionType(struct soap *soap, const char *s, enum ngwt__DistributionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__DistributionType, s);
	if (map)
		*a = (enum ngwt__DistributionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__DistributionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__DistributionType * SOAP_FMAC4 soap_in_ngwt__DistributionType(struct soap *soap, const char *tag, enum ngwt__DistributionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__DistributionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__DistributionType, sizeof(enum ngwt__DistributionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__DistributionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__DistributionType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__DistributionType, 0, sizeof(enum ngwt__DistributionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__DeltaSyncType(struct soap *soap, enum ngwt__DeltaSyncType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__DeltaSyncType
	*a = SOAP_DEFAULT_ngwt__DeltaSyncType;
#else
	*a = (enum ngwt__DeltaSyncType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__DeltaSyncType(struct soap *soap, const enum ngwt__DeltaSyncType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__DeltaSyncType);
	if (soap_out_ngwt__DeltaSyncType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__DeltaSyncType[] =
{	{ (long)add, "add" },
	{ (long)delete_, "delete" },
	{ (long)update, "update" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__DeltaSyncType2s(struct soap *soap, enum ngwt__DeltaSyncType n)
{	const char *s = soap_str_code(soap_codes_ngwt__DeltaSyncType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__DeltaSyncType(struct soap *soap, const char *tag, int id, const enum ngwt__DeltaSyncType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__DeltaSyncType), type);
	soap_send(soap, soap_ngwt__DeltaSyncType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__DeltaSyncType * SOAP_FMAC4 soap_get_ngwt__DeltaSyncType(struct soap *soap, enum ngwt__DeltaSyncType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__DeltaSyncType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__DeltaSyncType(struct soap *soap, const char *s, enum ngwt__DeltaSyncType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__DeltaSyncType, s);
	if (map)
		*a = (enum ngwt__DeltaSyncType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__DeltaSyncType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__DeltaSyncType * SOAP_FMAC4 soap_in_ngwt__DeltaSyncType(struct soap *soap, const char *tag, enum ngwt__DeltaSyncType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__DeltaSyncType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__DeltaSyncType, sizeof(enum ngwt__DeltaSyncType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__DeltaSyncType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__DeltaSyncType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__DeltaSyncType, 0, sizeof(enum ngwt__DeltaSyncType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__CustomType(struct soap *soap, enum ngwt__CustomType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__CustomType
	*a = SOAP_DEFAULT_ngwt__CustomType;
#else
	*a = (enum ngwt__CustomType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__CustomType(struct soap *soap, const enum ngwt__CustomType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__CustomType);
	if (soap_out_ngwt__CustomType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__CustomType[] =
{	{ (long)String, "String" },
	{ (long)Numeric, "Numeric" },
	{ (long)Date, "Date" },
	{ (long)Binary, "Binary" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__CustomType2s(struct soap *soap, enum ngwt__CustomType n)
{	const char *s = soap_str_code(soap_codes_ngwt__CustomType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__CustomType(struct soap *soap, const char *tag, int id, const enum ngwt__CustomType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__CustomType), type);
	soap_send(soap, soap_ngwt__CustomType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__CustomType * SOAP_FMAC4 soap_get_ngwt__CustomType(struct soap *soap, enum ngwt__CustomType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__CustomType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__CustomType(struct soap *soap, const char *s, enum ngwt__CustomType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__CustomType, s);
	if (map)
		*a = (enum ngwt__CustomType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__CustomType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__CustomType * SOAP_FMAC4 soap_in_ngwt__CustomType(struct soap *soap, const char *tag, enum ngwt__CustomType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__CustomType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__CustomType, sizeof(enum ngwt__CustomType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__CustomType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__CustomType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__CustomType, 0, sizeof(enum ngwt__CustomType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__CursorSeek(struct soap *soap, enum ngwt__CursorSeek *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__CursorSeek
	*a = SOAP_DEFAULT_ngwt__CursorSeek;
#else
	*a = (enum ngwt__CursorSeek)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__CursorSeek(struct soap *soap, const enum ngwt__CursorSeek *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__CursorSeek);
	if (soap_out_ngwt__CursorSeek(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__CursorSeek[] =
{	{ (long)current, "current" },
	{ (long)start, "start" },
	{ (long)end, "end" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__CursorSeek2s(struct soap *soap, enum ngwt__CursorSeek n)
{	const char *s = soap_str_code(soap_codes_ngwt__CursorSeek, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__CursorSeek(struct soap *soap, const char *tag, int id, const enum ngwt__CursorSeek *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__CursorSeek), type);
	soap_send(soap, soap_ngwt__CursorSeek2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__CursorSeek * SOAP_FMAC4 soap_get_ngwt__CursorSeek(struct soap *soap, enum ngwt__CursorSeek *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__CursorSeek(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__CursorSeek(struct soap *soap, const char *s, enum ngwt__CursorSeek *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__CursorSeek, s);
	if (map)
		*a = (enum ngwt__CursorSeek)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__CursorSeek)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__CursorSeek * SOAP_FMAC4 soap_in_ngwt__CursorSeek(struct soap *soap, const char *tag, enum ngwt__CursorSeek *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__CursorSeek *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__CursorSeek, sizeof(enum ngwt__CursorSeek), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__CursorSeek(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__CursorSeek *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__CursorSeek, 0, sizeof(enum ngwt__CursorSeek), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ContactType(struct soap *soap, enum ngwt__ContactType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ContactType
	*a = SOAP_DEFAULT_ngwt__ContactType;
#else
	*a = (enum ngwt__ContactType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ContactType(struct soap *soap, const enum ngwt__ContactType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ContactType);
	if (soap_out_ngwt__ContactType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ContactType[] =
{	{ (long)Contact__, "Contact" },
	{ (long)Group_, "Group" },
	{ (long)Resource_, "Resource" },
	{ (long)Organization__, "Organization" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__ContactType2s(struct soap *soap, enum ngwt__ContactType n)
{	const char *s = soap_str_code(soap_codes_ngwt__ContactType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ContactType(struct soap *soap, const char *tag, int id, const enum ngwt__ContactType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ContactType), type);
	soap_send(soap, soap_ngwt__ContactType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ContactType * SOAP_FMAC4 soap_get_ngwt__ContactType(struct soap *soap, enum ngwt__ContactType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ContactType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__ContactType(struct soap *soap, const char *s, enum ngwt__ContactType *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return SOAP_OK;
	soap_s2TQName(soap, s, &t);
	map = soap_code(soap_codes_ngwt__ContactType, t);
	if (map)
		*a = (enum ngwt__ContactType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__ContactType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__ContactType * SOAP_FMAC4 soap_in_ngwt__ContactType(struct soap *soap, const char *tag, enum ngwt__ContactType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ContactType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ContactType, sizeof(enum ngwt__ContactType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__ContactType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ContactType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ContactType, 0, sizeof(enum ngwt__ContactType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__CategoryType(struct soap *soap, enum ngwt__CategoryType *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__CategoryType
	*a = SOAP_DEFAULT_ngwt__CategoryType;
#else
	*a = (enum ngwt__CategoryType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__CategoryType(struct soap *soap, const enum ngwt__CategoryType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__CategoryType);
	if (soap_out_ngwt__CategoryType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__CategoryType[] =
{	{ (long)Normal, "Normal" },
	{ (long)Personal, "Personal" },
	{ (long)FollowUp, "FollowUp" },
	{ (long)Urgent, "Urgent" },
	{ (long)LowPriority, "LowPriority" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__CategoryType2s(struct soap *soap, enum ngwt__CategoryType n)
{	const char *s = soap_str_code(soap_codes_ngwt__CategoryType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__CategoryType(struct soap *soap, const char *tag, int id, const enum ngwt__CategoryType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__CategoryType), type);
	soap_send(soap, soap_ngwt__CategoryType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__CategoryType * SOAP_FMAC4 soap_get_ngwt__CategoryType(struct soap *soap, enum ngwt__CategoryType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__CategoryType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__CategoryType(struct soap *soap, const char *s, enum ngwt__CategoryType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__CategoryType, s);
	if (map)
		*a = (enum ngwt__CategoryType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__CategoryType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__CategoryType * SOAP_FMAC4 soap_in_ngwt__CategoryType(struct soap *soap, const char *tag, enum ngwt__CategoryType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__CategoryType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__CategoryType, sizeof(enum ngwt__CategoryType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__CategoryType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__CategoryType *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__CategoryType, 0, sizeof(enum ngwt__CategoryType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__CalendarFolderFlags(struct soap *soap, enum ngwt__CalendarFolderFlags *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__CalendarFolderFlags
	*a = SOAP_DEFAULT_ngwt__CalendarFolderFlags;
#else
	*a = (enum ngwt__CalendarFolderFlags)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__CalendarFolderFlags(struct soap *soap, const enum ngwt__CalendarFolderFlags *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__CalendarFolderFlags);
	if (soap_out_ngwt__CalendarFolderFlags(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__CalendarFolderFlags[] =
{	{ (long)ShowInList, "ShowInList" },
	{ (long)DontIncludeContent, "DontIncludeContent" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__CalendarFolderFlags2s(struct soap *soap, enum ngwt__CalendarFolderFlags n)
{	const char *s = soap_str_code(soap_codes_ngwt__CalendarFolderFlags, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__CalendarFolderFlags(struct soap *soap, const char *tag, int id, const enum ngwt__CalendarFolderFlags *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__CalendarFolderFlags), type);
	soap_send(soap, soap_ngwt__CalendarFolderFlags2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__CalendarFolderFlags * SOAP_FMAC4 soap_get_ngwt__CalendarFolderFlags(struct soap *soap, enum ngwt__CalendarFolderFlags *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__CalendarFolderFlags(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__CalendarFolderFlags(struct soap *soap, const char *s, enum ngwt__CalendarFolderFlags *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__CalendarFolderFlags, s);
	if (map)
		*a = (enum ngwt__CalendarFolderFlags)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__CalendarFolderFlags)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__CalendarFolderFlags * SOAP_FMAC4 soap_in_ngwt__CalendarFolderFlags(struct soap *soap, const char *tag, enum ngwt__CalendarFolderFlags *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__CalendarFolderFlags *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__CalendarFolderFlags, sizeof(enum ngwt__CalendarFolderFlags), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__CalendarFolderFlags(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__CalendarFolderFlags *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__CalendarFolderFlags, 0, sizeof(enum ngwt__CalendarFolderFlags), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__AppointmentConflict(struct soap *soap, enum ngwt__AppointmentConflict *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__AppointmentConflict
	*a = SOAP_DEFAULT_ngwt__AppointmentConflict;
#else
	*a = (enum ngwt__AppointmentConflict)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__AppointmentConflict(struct soap *soap, const enum ngwt__AppointmentConflict *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__AppointmentConflict);
	if (soap_out_ngwt__AppointmentConflict(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__AppointmentConflict[] =
{	{ (long)Yes, "Yes" },
	{ (long)No, "No" },
	{ (long)Ignore, "Ignore" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__AppointmentConflict2s(struct soap *soap, enum ngwt__AppointmentConflict n)
{	const char *s = soap_str_code(soap_codes_ngwt__AppointmentConflict, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__AppointmentConflict(struct soap *soap, const char *tag, int id, const enum ngwt__AppointmentConflict *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__AppointmentConflict), type);
	soap_send(soap, soap_ngwt__AppointmentConflict2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__AppointmentConflict * SOAP_FMAC4 soap_get_ngwt__AppointmentConflict(struct soap *soap, enum ngwt__AppointmentConflict *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__AppointmentConflict(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__AppointmentConflict(struct soap *soap, const char *s, enum ngwt__AppointmentConflict *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__AppointmentConflict, s);
	if (map)
		*a = (enum ngwt__AppointmentConflict)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__AppointmentConflict)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__AppointmentConflict * SOAP_FMAC4 soap_in_ngwt__AppointmentConflict(struct soap *soap, const char *tag, enum ngwt__AppointmentConflict *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__AppointmentConflict *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__AppointmentConflict, sizeof(enum ngwt__AppointmentConflict), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__AppointmentConflict(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__AppointmentConflict *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__AppointmentConflict, 0, sizeof(enum ngwt__AppointmentConflict), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__AgeAction(struct soap *soap, enum ngwt__AgeAction *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__AgeAction
	*a = SOAP_DEFAULT_ngwt__AgeAction;
#else
	*a = (enum ngwt__AgeAction)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__AgeAction(struct soap *soap, const enum ngwt__AgeAction *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__AgeAction);
	if (soap_out_ngwt__AgeAction(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__AgeAction[] =
{	{ (long)archive, "archive" },
	{ (long)delete__, "delete" },
	{ (long)retain, "retain" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__AgeAction2s(struct soap *soap, enum ngwt__AgeAction n)
{	const char *s = soap_str_code(soap_codes_ngwt__AgeAction, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__AgeAction(struct soap *soap, const char *tag, int id, const enum ngwt__AgeAction *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__AgeAction), type);
	soap_send(soap, soap_ngwt__AgeAction2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__AgeAction * SOAP_FMAC4 soap_get_ngwt__AgeAction(struct soap *soap, enum ngwt__AgeAction *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__AgeAction(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__AgeAction(struct soap *soap, const char *s, enum ngwt__AgeAction *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__AgeAction, s);
	if (map)
		*a = (enum ngwt__AgeAction)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__AgeAction)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__AgeAction * SOAP_FMAC4 soap_in_ngwt__AgeAction(struct soap *soap, const char *tag, enum ngwt__AgeAction *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__AgeAction *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__AgeAction, sizeof(enum ngwt__AgeAction), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__AgeAction(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__AgeAction *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__AgeAction, 0, sizeof(enum ngwt__AgeAction), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__AcceptLevel(struct soap *soap, enum ngwt__AcceptLevel *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__AcceptLevel
	*a = SOAP_DEFAULT_ngwt__AcceptLevel;
#else
	*a = (enum ngwt__AcceptLevel)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__AcceptLevel(struct soap *soap, const enum ngwt__AcceptLevel *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__AcceptLevel);
	if (soap_out_ngwt__AcceptLevel(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__AcceptLevel[] =
{	{ (long)Free, "Free" },
	{ (long)Tentative, "Tentative" },
	{ (long)Busy, "Busy" },
	{ (long)OutOfOffice, "OutOfOffice" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_ngwt__AcceptLevel2s(struct soap *soap, enum ngwt__AcceptLevel n)
{	const char *s = soap_str_code(soap_codes_ngwt__AcceptLevel, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__AcceptLevel(struct soap *soap, const char *tag, int id, const enum ngwt__AcceptLevel *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__AcceptLevel), type);
	soap_send(soap, soap_ngwt__AcceptLevel2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__AcceptLevel * SOAP_FMAC4 soap_get_ngwt__AcceptLevel(struct soap *soap, enum ngwt__AcceptLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__AcceptLevel(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2ngwt__AcceptLevel(struct soap *soap, const char *s, enum ngwt__AcceptLevel *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_ngwt__AcceptLevel, s);
	if (map)
		*a = (enum ngwt__AcceptLevel)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n))
			return soap->error;
		*a = (enum ngwt__AcceptLevel)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum ngwt__AcceptLevel * SOAP_FMAC4 soap_in_ngwt__AcceptLevel(struct soap *soap, const char *tag, enum ngwt__AcceptLevel *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__AcceptLevel *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__AcceptLevel, sizeof(enum ngwt__AcceptLevel), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2ngwt__AcceptLevel(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__AcceptLevel *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__AcceptLevel, 0, sizeof(enum ngwt__AcceptLevel), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwe__ItemTypeList(struct soap *soap, enum ngwe__ItemTypeList *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwe__ItemTypeList
	*a = SOAP_DEFAULT_ngwe__ItemTypeList;
#else
	*a = (enum ngwe__ItemTypeList)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwe__ItemTypeList(struct soap *soap, const enum ngwe__ItemTypeList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwe__ItemTypeList);
	if (soap_out_ngwe__ItemTypeList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwe__ItemTypeList[] =
{	{ (long)AddressBookItem, "AddressBookItem" },
	{ (long)Appointment_, "Appointment" },
	{ (long)CalendarItem_, "CalendarItem" },
	{ (long)Contact_, "Contact" },
	{ (long)Group, "Group" },
	{ (long)Mail_, "Mail" },
	{ (long)Note_, "Note" },
	{ (long)Organization_, "Organization" },
	{ (long)PhoneMessage_, "PhoneMessage" },
	{ (long)Resource, "Resource" },
	{ (long)Task_, "Task" },
	{ (long)DocumentRef, "DocumentRef" },
	{ 0, NULL }
};

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__ItemTypeList(struct soap *soap, const char *tag, int id, const enum ngwe__ItemTypeList *a, const char *type)
{	long i;
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__ItemTypeList), type);
	for (i = 1; i; i <<= 1)
		switch ((long)*a & i)
		{
			case 1: soap_send(soap, "AddressBookItem "); break;
			case 2: soap_send(soap, "Appointment "); break;
			case 4: soap_send(soap, "CalendarItem "); break;
			case 8: soap_send(soap, "Contact "); break;
			case 16: soap_send(soap, "Group "); break;
			case 32: soap_send(soap, "Mail "); break;
			case 64: soap_send(soap, "Note "); break;
			case 128: soap_send(soap, "Organization "); break;
			case 256: soap_send(soap, "PhoneMessage "); break;
			case 512: soap_send(soap, "Resource "); break;
			case 1024: soap_send(soap, "Task "); break;
			case 2048: soap_send(soap, "DocumentRef "); break;
		}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwe__ItemTypeList * SOAP_FMAC4 soap_get_ngwe__ItemTypeList(struct soap *soap, enum ngwe__ItemTypeList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__ItemTypeList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum ngwe__ItemTypeList * SOAP_FMAC4 soap_in_ngwe__ItemTypeList(struct soap *soap, const char *tag, enum ngwe__ItemTypeList *a, const char *type)
{
	const char *s;
	LONG64 i;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwe__ItemTypeList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__ItemTypeList, sizeof(enum ngwe__ItemTypeList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	i = 0;
		while (*(s = soap_token(soap)))
			if (!strcmp(s, "AddressBookItem"))
				i |= (LONG64)AddressBookItem;
			else if (!strcmp(s, "Appointment"))
				i |= (LONG64)Appointment_;
			else if (!strcmp(s, "CalendarItem"))
				i |= (LONG64)CalendarItem_;
			else if (!strcmp(s, "Contact"))
				i |= (LONG64)Contact_;
			else if (!strcmp(s, "Group"))
				i |= (LONG64)Group;
			else if (!strcmp(s, "Mail"))
				i |= (LONG64)Mail_;
			else if (!strcmp(s, "Note"))
				i |= (LONG64)Note_;
			else if (!strcmp(s, "Organization"))
				i |= (LONG64)Organization_;
			else if (!strcmp(s, "PhoneMessage"))
				i |= (LONG64)PhoneMessage_;
			else if (!strcmp(s, "Resource"))
				i |= (LONG64)Resource;
			else if (!strcmp(s, "Task"))
				i |= (LONG64)Task_;
			else if (!strcmp(s, "DocumentRef"))
				i |= (LONG64)DocumentRef;
			else 
			{	soap->error = SOAP_TYPE;
				return NULL;
			}
		*a = (enum ngwe__ItemTypeList)i;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwe__ItemTypeList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__ItemTypeList, 0, sizeof(enum ngwe__ItemTypeList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwe__FieldList(struct soap *soap, enum ngwe__FieldList *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwe__FieldList
	*a = SOAP_DEFAULT_ngwe__FieldList;
#else
	*a = (enum ngwe__FieldList)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwe__FieldList(struct soap *soap, const enum ngwe__FieldList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwe__FieldList);
	if (soap_out_ngwe__FieldList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwe__FieldList[] =
{	{ (long)AcceptLevel, "AcceptLevel" },
	{ (long)Alarm, "Alarm" },
	{ (long)AllDayEvent, "AllDayEvent" },
	{ (long)Attachment, "Attachment" },
	{ (long)Category, "Category" },
	{ (long)Classification, "Classification" },
	{ (long)Contact, "Contact" },
	{ (long)DueDate, "DueDate" },
	{ (long)Duration, "Duration" },
	{ (long)EmailAddress, "EmailAddress" },
	{ (long)ExpirationDate, "ExpirationDate" },
	{ (long)Hidden, "Hidden" },
	{ (long)IMAddress, "IMAddress" },
	{ (long)MessageBody, "MessageBody" },
	{ (long)Name, "Name" },
	{ (long)Organization, "Organization" },
	{ (long)Owner, "Owner" },
	{ (long)PersonalSubject, "PersonalSubject" },
	{ (long)PhoneNumber, "PhoneNumber" },
	{ (long)Place, "Place" },
	{ (long)PostalAddress, "PostalAddress" },
	{ (long)RecipientStatus, "RecipientStatus" },
	{ (long)Rights, "Rights" },
	{ (long)Security, "Security" },
	{ (long)SendPriority, "SendPriority" },
	{ (long)StartDate, "StartDate" },
	{ (long)Subject, "Subject" },
	{ (long)TaskCategory, "TaskCategory" },
	{ (long)TaskPriority, "TaskPriority" },
	{ 0, NULL }
};

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__FieldList(struct soap *soap, const char *tag, int id, const enum ngwe__FieldList *a, const char *type)
{	long i;
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__FieldList), type);
	for (i = 1; i; i <<= 1)
		switch ((long)*a & i)
		{
			case 1: soap_send(soap, "AcceptLevel "); break;
			case 2: soap_send(soap, "Alarm "); break;
			case 4: soap_send(soap, "AllDayEvent "); break;
			case 8: soap_send(soap, "Attachment "); break;
			case 16: soap_send(soap, "Category "); break;
			case 32: soap_send(soap, "Classification "); break;
			case 64: soap_send(soap, "Contact "); break;
			case 128: soap_send(soap, "DueDate "); break;
			case 256: soap_send(soap, "Duration "); break;
			case 512: soap_send(soap, "EmailAddress "); break;
			case 1024: soap_send(soap, "ExpirationDate "); break;
			case 2048: soap_send(soap, "Hidden "); break;
			case 4096: soap_send(soap, "IMAddress "); break;
			case 8192: soap_send(soap, "MessageBody "); break;
			case 16384: soap_send(soap, "Name "); break;
			case 32768: soap_send(soap, "Organization "); break;
			case 65536: soap_send(soap, "Owner "); break;
			case 131072: soap_send(soap, "PersonalSubject "); break;
			case 262144: soap_send(soap, "PhoneNumber "); break;
			case 524288: soap_send(soap, "Place "); break;
			case 1048576: soap_send(soap, "PostalAddress "); break;
			case 2097152: soap_send(soap, "RecipientStatus "); break;
			case 4194304: soap_send(soap, "Rights "); break;
			case 8388608: soap_send(soap, "Security "); break;
			case 16777216: soap_send(soap, "SendPriority "); break;
			case 33554432: soap_send(soap, "StartDate "); break;
			case 67108864: soap_send(soap, "Subject "); break;
			case 134217728: soap_send(soap, "TaskCategory "); break;
			case 268435456: soap_send(soap, "TaskPriority "); break;
		}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwe__FieldList * SOAP_FMAC4 soap_get_ngwe__FieldList(struct soap *soap, enum ngwe__FieldList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__FieldList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum ngwe__FieldList * SOAP_FMAC4 soap_in_ngwe__FieldList(struct soap *soap, const char *tag, enum ngwe__FieldList *a, const char *type)
{
	const char *s;
	LONG64 i;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwe__FieldList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__FieldList, sizeof(enum ngwe__FieldList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	i = 0;
		while (*(s = soap_token(soap)))
			if (!strcmp(s, "AcceptLevel"))
				i |= (LONG64)AcceptLevel;
			else if (!strcmp(s, "Alarm"))
				i |= (LONG64)Alarm;
			else if (!strcmp(s, "AllDayEvent"))
				i |= (LONG64)AllDayEvent;
			else if (!strcmp(s, "Attachment"))
				i |= (LONG64)Attachment;
			else if (!strcmp(s, "Category"))
				i |= (LONG64)Category;
			else if (!strcmp(s, "Classification"))
				i |= (LONG64)Classification;
			else if (!strcmp(s, "Contact"))
				i |= (LONG64)Contact;
			else if (!strcmp(s, "DueDate"))
				i |= (LONG64)DueDate;
			else if (!strcmp(s, "Duration"))
				i |= (LONG64)Duration;
			else if (!strcmp(s, "EmailAddress"))
				i |= (LONG64)EmailAddress;
			else if (!strcmp(s, "ExpirationDate"))
				i |= (LONG64)ExpirationDate;
			else if (!strcmp(s, "Hidden"))
				i |= (LONG64)Hidden;
			else if (!strcmp(s, "IMAddress"))
				i |= (LONG64)IMAddress;
			else if (!strcmp(s, "MessageBody"))
				i |= (LONG64)MessageBody;
			else if (!strcmp(s, "Name"))
				i |= (LONG64)Name;
			else if (!strcmp(s, "Organization"))
				i |= (LONG64)Organization;
			else if (!strcmp(s, "Owner"))
				i |= (LONG64)Owner;
			else if (!strcmp(s, "PersonalSubject"))
				i |= (LONG64)PersonalSubject;
			else if (!strcmp(s, "PhoneNumber"))
				i |= (LONG64)PhoneNumber;
			else if (!strcmp(s, "Place"))
				i |= (LONG64)Place;
			else if (!strcmp(s, "PostalAddress"))
				i |= (LONG64)PostalAddress;
			else if (!strcmp(s, "RecipientStatus"))
				i |= (LONG64)RecipientStatus;
			else if (!strcmp(s, "Rights"))
				i |= (LONG64)Rights;
			else if (!strcmp(s, "Security"))
				i |= (LONG64)Security;
			else if (!strcmp(s, "SendPriority"))
				i |= (LONG64)SendPriority;
			else if (!strcmp(s, "StartDate"))
				i |= (LONG64)StartDate;
			else if (!strcmp(s, "Subject"))
				i |= (LONG64)Subject;
			else if (!strcmp(s, "TaskCategory"))
				i |= (LONG64)TaskCategory;
			else if (!strcmp(s, "TaskPriority"))
				i |= (LONG64)TaskPriority;
			else 
			{	soap->error = SOAP_TYPE;
				return NULL;
			}
		*a = (enum ngwe__FieldList)i;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwe__FieldList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__FieldList, 0, sizeof(enum ngwe__FieldList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__MessageTypeList(struct soap *soap, enum ngwt__MessageTypeList *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__MessageTypeList
	*a = SOAP_DEFAULT_ngwt__MessageTypeList;
#else
	*a = (enum ngwt__MessageTypeList)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__MessageTypeList(struct soap *soap, const enum ngwt__MessageTypeList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__MessageTypeList);
	if (soap_out_ngwt__MessageTypeList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__MessageTypeList[] =
{	{ (long)Appointment, "Appointment" },
	{ (long)CalendarItem, "CalendarItem" },
	{ (long)DocumentReference, "DocumentReference" },
	{ (long)Mail, "Mail" },
	{ (long)Note, "Note" },
	{ (long)PhoneMessage, "PhoneMessage" },
	{ (long)Task, "Task" },
	{ 0, NULL }
};

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__MessageTypeList(struct soap *soap, const char *tag, int id, const enum ngwt__MessageTypeList *a, const char *type)
{	long i;
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__MessageTypeList), type);
	for (i = 1; i; i <<= 1)
		switch ((long)*a & i)
		{
			case 1: soap_send(soap, "Appointment "); break;
			case 2: soap_send(soap, "CalendarItem "); break;
			case 4: soap_send(soap, "DocumentReference "); break;
			case 8: soap_send(soap, "Mail "); break;
			case 16: soap_send(soap, "Note "); break;
			case 32: soap_send(soap, "PhoneMessage "); break;
			case 64: soap_send(soap, "Task "); break;
		}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__MessageTypeList * SOAP_FMAC4 soap_get_ngwt__MessageTypeList(struct soap *soap, enum ngwt__MessageTypeList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__MessageTypeList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum ngwt__MessageTypeList * SOAP_FMAC4 soap_in_ngwt__MessageTypeList(struct soap *soap, const char *tag, enum ngwt__MessageTypeList *a, const char *type)
{
	const char *s;
	LONG64 i;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__MessageTypeList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__MessageTypeList, sizeof(enum ngwt__MessageTypeList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	i = 0;
		while (*(s = soap_token(soap)))
			if (!strcmp(s, "Appointment"))
				i |= (LONG64)Appointment;
			else if (!strcmp(s, "CalendarItem"))
				i |= (LONG64)CalendarItem;
			else if (!strcmp(s, "DocumentReference"))
				i |= (LONG64)DocumentReference;
			else if (!strcmp(s, "Mail"))
				i |= (LONG64)Mail;
			else if (!strcmp(s, "Note"))
				i |= (LONG64)Note;
			else if (!strcmp(s, "PhoneMessage"))
				i |= (LONG64)PhoneMessage;
			else if (!strcmp(s, "Task"))
				i |= (LONG64)Task;
			else 
			{	soap->error = SOAP_TYPE;
				return NULL;
			}
		*a = (enum ngwt__MessageTypeList)i;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__MessageTypeList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__MessageTypeList, 0, sizeof(enum ngwt__MessageTypeList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__ItemSourceList(struct soap *soap, enum ngwt__ItemSourceList *a)
{
(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_ngwt__ItemSourceList
	*a = SOAP_DEFAULT_ngwt__ItemSourceList;
#else
	*a = (enum ngwt__ItemSourceList)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__ItemSourceList(struct soap *soap, const enum ngwt__ItemSourceList *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__ItemSourceList);
	if (soap_out_ngwt__ItemSourceList(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_ngwt__ItemSourceList[] =
{	{ (long)received, "received" },
	{ (long)sent, "sent" },
	{ (long)draft, "draft" },
	{ (long)personal, "personal" },
	{ 0, NULL }
};

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__ItemSourceList(struct soap *soap, const char *tag, int id, const enum ngwt__ItemSourceList *a, const char *type)
{	long i;
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwt__ItemSourceList), type);
	for (i = 1; i; i <<= 1)
		switch ((long)*a & i)
		{
			case 1: soap_send(soap, "received "); break;
			case 2: soap_send(soap, "sent "); break;
			case 4: soap_send(soap, "draft "); break;
			case 8: soap_send(soap, "personal "); break;
		}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum ngwt__ItemSourceList * SOAP_FMAC4 soap_get_ngwt__ItemSourceList(struct soap *soap, enum ngwt__ItemSourceList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__ItemSourceList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum ngwt__ItemSourceList * SOAP_FMAC4 soap_in_ngwt__ItemSourceList(struct soap *soap, const char *tag, enum ngwt__ItemSourceList *a, const char *type)
{
	const char *s;
	LONG64 i;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum ngwt__ItemSourceList *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ngwt__ItemSourceList, sizeof(enum ngwt__ItemSourceList), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	i = 0;
		while (*(s = soap_token(soap)))
			if (!strcmp(s, "received"))
				i |= (LONG64)received;
			else if (!strcmp(s, "sent"))
				i |= (LONG64)sent;
			else if (!strcmp(s, "draft"))
				i |= (LONG64)draft;
			else if (!strcmp(s, "personal"))
				i |= (LONG64)personal;
			else 
			{	soap->error = SOAP_TYPE;
				return NULL;
			}
		*a = (enum ngwt__ItemSourceList)i;
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum ngwt__ItemSourceList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwt__ItemSourceList, 0, sizeof(enum ngwt__ItemSourceList), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ngwt__UUID(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__UUID(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__UUID(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__UUID);
	if (soap_out_ngwt__UUID(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__UUID(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_ngwt__UUID), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_ngwt__UUID(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__UUID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_ngwt__UUID(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__UUID, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__UUID, sizeof(std::string), soap->type, soap->arrayType), SOAP_TYPE_ngwt__UUID, 0, sizeof(std::string), 0, soap_copy_ngwt__UUID);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_ngwt__UUID(struct soap *soap, int n)
{	return soap_instantiate_ngwt__UUID(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwt__UUID(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_instantiate_ngwt__UUID(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwt__UUID(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwt__UUID, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwt__UUID(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ngwt__uid(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__uid(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__uid(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__uid);
	if (soap_out_ngwt__uid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__uid(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_ngwt__uid), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_ngwt__uid(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__uid(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_ngwt__uid(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__uid, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__uid, sizeof(std::string), soap->type, soap->arrayType), SOAP_TYPE_ngwt__uid, 0, sizeof(std::string), 0, soap_copy_ngwt__uid);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_ngwt__uid(struct soap *soap, int n)
{	return soap_instantiate_ngwt__uid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwt__uid(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_instantiate_ngwt__uid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwt__uid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwt__uid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwt__uid(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ngwt__View(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ngwt__View(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ngwt__View(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ngwt__View);
	if (soap_out_ngwt__View(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwt__View(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_ngwt__View), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_ngwt__View(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwt__View(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_ngwt__View(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__View, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, 0, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_ngwt__View, sizeof(std::string), soap->type, soap->arrayType), SOAP_TYPE_ngwt__View, 0, sizeof(std::string), 0, soap_copy_ngwt__View);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_ngwt__View(struct soap *soap, int n)
{	return soap_instantiate_ngwt__View(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwt__View(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_instantiate_ngwt__View(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwt__View(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwt__View, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwt__View(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void _ngwe__removeEventsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__removeEventsResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__removeEventsResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__removeEventsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__removeEventsResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__removeEventsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__removeEventsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__removeEventsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__removeEventsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__removeEventsResponse(struct soap *soap, const char *tag, int id, const _ngwe__removeEventsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__removeEventsResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__removeEventsResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__removeEventsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__removeEventsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__removeEventsResponse * SOAP_FMAC4 soap_get__ngwe__removeEventsResponse(struct soap *soap, _ngwe__removeEventsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__removeEventsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__removeEventsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__removeEventsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__removeEventsResponse * SOAP_FMAC4 soap_in__ngwe__removeEventsResponse(struct soap *soap, const char *tag, _ngwe__removeEventsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__removeEventsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__removeEventsResponse, sizeof(_ngwe__removeEventsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__removeEventsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__removeEventsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__removeEventsResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__removeEventsResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__removeEventsResponse, 0, sizeof(_ngwe__removeEventsResponse), 0, soap_copy__ngwe__removeEventsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__removeEventsResponse * SOAP_FMAC6 soap_new__ngwe__removeEventsResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__removeEventsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__removeEventsResponse(struct soap *soap, _ngwe__removeEventsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__removeEventsResponse * SOAP_FMAC6 soap_instantiate__ngwe__removeEventsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__removeEventsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__removeEventsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__removeEventsResponse;
		if (size)
			*size = sizeof(_ngwe__removeEventsResponse);
		((_ngwe__removeEventsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__removeEventsResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__removeEventsResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__removeEventsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__removeEventsResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__removeEventsResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__removeEventsResponse %p -> %p\n", q, p));
	*(_ngwe__removeEventsResponse*)p = *(_ngwe__removeEventsResponse*)q;
}

void _ngwe__removeEventsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__removeEventsRequest*)this)->key, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((_ngwe__removeEventsRequest*)this)->key);
	soap_embedded(soap, &((_ngwe__removeEventsRequest*)this)->from, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwe__removeEventsRequest*)this)->from);
	soap_embedded(soap, &((_ngwe__removeEventsRequest*)this)->until, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwe__removeEventsRequest*)this)->until);
	/* transient soap skipped */
}

void _ngwe__removeEventsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((_ngwe__removeEventsRequest*)this)->key);
	soap_default_string(soap, &((_ngwe__removeEventsRequest*)this)->from);
	soap_default_string(soap, &((_ngwe__removeEventsRequest*)this)->until);
	/* transient soap skipped */
}

int _ngwe__removeEventsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__removeEventsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__removeEventsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__removeEventsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__removeEventsRequest(struct soap *soap, const char *tag, int id, const _ngwe__removeEventsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__removeEventsRequest), type);
	soap_out_std__string(soap, "ngwe:key", -1, &(((_ngwe__removeEventsRequest*)a)->key), "");
	soap_out_string(soap, "ngwe:from", -1, &(((_ngwe__removeEventsRequest*)a)->from), "");
	soap_out_string(soap, "ngwe:until", -1, &(((_ngwe__removeEventsRequest*)a)->until), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__removeEventsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__removeEventsRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__removeEventsRequest * SOAP_FMAC4 soap_get__ngwe__removeEventsRequest(struct soap *soap, _ngwe__removeEventsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__removeEventsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__removeEventsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__removeEventsRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__removeEventsRequest * SOAP_FMAC4 soap_in__ngwe__removeEventsRequest(struct soap *soap, const char *tag, _ngwe__removeEventsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__removeEventsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__removeEventsRequest, sizeof(_ngwe__removeEventsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__removeEventsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__removeEventsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_key1 = 1, soap_flag_from1 = 1, soap_flag_until1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:key", &(((_ngwe__removeEventsRequest*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			if (soap_flag_from1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwe:from", &(((_ngwe__removeEventsRequest*)a)->from), ""))
				{	soap_flag_from1 = 0;
					continue;
				}
			if (soap_flag_until1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwe:until", &(((_ngwe__removeEventsRequest*)a)->until), ""))
				{	soap_flag_until1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__removeEventsRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__removeEventsRequest, 0, sizeof(_ngwe__removeEventsRequest), 0, soap_copy__ngwe__removeEventsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__removeEventsRequest * SOAP_FMAC6 soap_new__ngwe__removeEventsRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__removeEventsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__removeEventsRequest(struct soap *soap, _ngwe__removeEventsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__removeEventsRequest * SOAP_FMAC6 soap_instantiate__ngwe__removeEventsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__removeEventsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__removeEventsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__removeEventsRequest;
		if (size)
			*size = sizeof(_ngwe__removeEventsRequest);
		((_ngwe__removeEventsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__removeEventsRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__removeEventsRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__removeEventsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__removeEventsRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__removeEventsRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__removeEventsRequest %p -> %p\n", q, p));
	*(_ngwe__removeEventsRequest*)p = *(_ngwe__removeEventsRequest*)q;
}

void _ngwe__removeEventConfigurationResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__removeEventConfigurationResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__removeEventConfigurationResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__removeEventConfigurationResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__removeEventConfigurationResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__removeEventConfigurationResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__removeEventConfigurationResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__removeEventConfigurationResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__removeEventConfigurationResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__removeEventConfigurationResponse(struct soap *soap, const char *tag, int id, const _ngwe__removeEventConfigurationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__removeEventConfigurationResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__removeEventConfigurationResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__removeEventConfigurationResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__removeEventConfigurationResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__removeEventConfigurationResponse * SOAP_FMAC4 soap_get__ngwe__removeEventConfigurationResponse(struct soap *soap, _ngwe__removeEventConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__removeEventConfigurationResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__removeEventConfigurationResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__removeEventConfigurationResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__removeEventConfigurationResponse * SOAP_FMAC4 soap_in__ngwe__removeEventConfigurationResponse(struct soap *soap, const char *tag, _ngwe__removeEventConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__removeEventConfigurationResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__removeEventConfigurationResponse, sizeof(_ngwe__removeEventConfigurationResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__removeEventConfigurationResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__removeEventConfigurationResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__removeEventConfigurationResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__removeEventConfigurationResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__removeEventConfigurationResponse, 0, sizeof(_ngwe__removeEventConfigurationResponse), 0, soap_copy__ngwe__removeEventConfigurationResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__removeEventConfigurationResponse * SOAP_FMAC6 soap_new__ngwe__removeEventConfigurationResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__removeEventConfigurationResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__removeEventConfigurationResponse(struct soap *soap, _ngwe__removeEventConfigurationResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__removeEventConfigurationResponse * SOAP_FMAC6 soap_instantiate__ngwe__removeEventConfigurationResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__removeEventConfigurationResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__removeEventConfigurationResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__removeEventConfigurationResponse;
		if (size)
			*size = sizeof(_ngwe__removeEventConfigurationResponse);
		((_ngwe__removeEventConfigurationResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__removeEventConfigurationResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__removeEventConfigurationResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__removeEventConfigurationResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__removeEventConfigurationResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__removeEventConfigurationResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__removeEventConfigurationResponse %p -> %p\n", q, p));
	*(_ngwe__removeEventConfigurationResponse*)p = *(_ngwe__removeEventConfigurationResponse*)q;
}

void _ngwe__removeEventConfigurationRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__removeEventConfigurationRequest*)this)->key, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((_ngwe__removeEventConfigurationRequest*)this)->key);
	/* transient soap skipped */
}

void _ngwe__removeEventConfigurationRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((_ngwe__removeEventConfigurationRequest*)this)->key);
	/* transient soap skipped */
}

int _ngwe__removeEventConfigurationRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__removeEventConfigurationRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__removeEventConfigurationRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__removeEventConfigurationRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__removeEventConfigurationRequest(struct soap *soap, const char *tag, int id, const _ngwe__removeEventConfigurationRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__removeEventConfigurationRequest), type);
	soap_out_std__string(soap, "ngwe:key", -1, &(((_ngwe__removeEventConfigurationRequest*)a)->key), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__removeEventConfigurationRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__removeEventConfigurationRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__removeEventConfigurationRequest * SOAP_FMAC4 soap_get__ngwe__removeEventConfigurationRequest(struct soap *soap, _ngwe__removeEventConfigurationRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__removeEventConfigurationRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__removeEventConfigurationRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__removeEventConfigurationRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__removeEventConfigurationRequest * SOAP_FMAC4 soap_in__ngwe__removeEventConfigurationRequest(struct soap *soap, const char *tag, _ngwe__removeEventConfigurationRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__removeEventConfigurationRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__removeEventConfigurationRequest, sizeof(_ngwe__removeEventConfigurationRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__removeEventConfigurationRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__removeEventConfigurationRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_key1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:key", &(((_ngwe__removeEventConfigurationRequest*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__removeEventConfigurationRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__removeEventConfigurationRequest, 0, sizeof(_ngwe__removeEventConfigurationRequest), 0, soap_copy__ngwe__removeEventConfigurationRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__removeEventConfigurationRequest * SOAP_FMAC6 soap_new__ngwe__removeEventConfigurationRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__removeEventConfigurationRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__removeEventConfigurationRequest(struct soap *soap, _ngwe__removeEventConfigurationRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__removeEventConfigurationRequest * SOAP_FMAC6 soap_instantiate__ngwe__removeEventConfigurationRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__removeEventConfigurationRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__removeEventConfigurationRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__removeEventConfigurationRequest;
		if (size)
			*size = sizeof(_ngwe__removeEventConfigurationRequest);
		((_ngwe__removeEventConfigurationRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__removeEventConfigurationRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__removeEventConfigurationRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__removeEventConfigurationRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__removeEventConfigurationRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__removeEventConfigurationRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__removeEventConfigurationRequest %p -> %p\n", q, p));
	*(_ngwe__removeEventConfigurationRequest*)p = *(_ngwe__removeEventConfigurationRequest*)q;
}

void _ngwe__getEventsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__getEventsResponse*)this)->events, SOAP_TYPE_PointerTongwe__EventList);
	soap_serialize_PointerTongwe__EventList(soap, &((_ngwe__getEventsResponse*)this)->events);
	soap_embedded(soap, &((_ngwe__getEventsResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__getEventsResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__getEventsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__getEventsResponse*)this)->events = NULL;
	((_ngwe__getEventsResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__getEventsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__getEventsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__getEventsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__getEventsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__getEventsResponse(struct soap *soap, const char *tag, int id, const _ngwe__getEventsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__getEventsResponse), type);
	soap_out_PointerTongwe__EventList(soap, "ngwe:events", -1, &(((_ngwe__getEventsResponse*)a)->events), "");
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__getEventsResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__getEventsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__getEventsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__getEventsResponse * SOAP_FMAC4 soap_get__ngwe__getEventsResponse(struct soap *soap, _ngwe__getEventsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__getEventsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__getEventsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__getEventsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__getEventsResponse * SOAP_FMAC4 soap_in__ngwe__getEventsResponse(struct soap *soap, const char *tag, _ngwe__getEventsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__getEventsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__getEventsResponse, sizeof(_ngwe__getEventsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__getEventsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__getEventsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_events1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_events1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__EventList(soap, "ngwe:events", &(((_ngwe__getEventsResponse*)a)->events), "ngwe:EventList"))
				{	soap_flag_events1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__getEventsResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__getEventsResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__getEventsResponse, 0, sizeof(_ngwe__getEventsResponse), 0, soap_copy__ngwe__getEventsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__getEventsResponse * SOAP_FMAC6 soap_new__ngwe__getEventsResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__getEventsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__getEventsResponse(struct soap *soap, _ngwe__getEventsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__getEventsResponse * SOAP_FMAC6 soap_instantiate__ngwe__getEventsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__getEventsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__getEventsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__getEventsResponse;
		if (size)
			*size = sizeof(_ngwe__getEventsResponse);
		((_ngwe__getEventsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__getEventsResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__getEventsResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__getEventsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__getEventsResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__getEventsResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__getEventsResponse %p -> %p\n", q, p));
	*(_ngwe__getEventsResponse*)p = *(_ngwe__getEventsResponse*)q;
}

void _ngwe__getEventsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->key, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((_ngwe__getEventsRequest*)this)->key);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->from, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwe__getEventsRequest*)this)->from);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->until, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwe__getEventsRequest*)this)->until);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->uid, SOAP_TYPE_PointerTounsignedLong);
	soap_serialize_PointerTounsignedLong(soap, &((_ngwe__getEventsRequest*)this)->uid);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->count, SOAP_TYPE_int);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->remove, SOAP_TYPE_bool);
	soap_embedded(soap, &((_ngwe__getEventsRequest*)this)->notify, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void _ngwe__getEventsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((_ngwe__getEventsRequest*)this)->key);
	soap_default_string(soap, &((_ngwe__getEventsRequest*)this)->from);
	soap_default_string(soap, &((_ngwe__getEventsRequest*)this)->until);
	((_ngwe__getEventsRequest*)this)->uid = NULL;
	((_ngwe__getEventsRequest*)this)->count = -1;
	((_ngwe__getEventsRequest*)this)->remove = (bool)0;
	((_ngwe__getEventsRequest*)this)->notify = (bool)0;
	/* transient soap skipped */
}

int _ngwe__getEventsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__getEventsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__getEventsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__getEventsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__getEventsRequest(struct soap *soap, const char *tag, int id, const _ngwe__getEventsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__getEventsRequest), type);
	soap_out_std__string(soap, "ngwe:key", -1, &(((_ngwe__getEventsRequest*)a)->key), "");
	soap_out_string(soap, "ngwe:from", -1, &(((_ngwe__getEventsRequest*)a)->from), "");
	soap_out_string(soap, "ngwe:until", -1, &(((_ngwe__getEventsRequest*)a)->until), "");
	soap_out_PointerTounsignedLong(soap, "ngwe:uid", -1, &(((_ngwe__getEventsRequest*)a)->uid), "");
	soap_out_int(soap, "ngwe:count", -1, &(((_ngwe__getEventsRequest*)a)->count), "");
	soap_out_bool(soap, "ngwe:remove", -1, &(((_ngwe__getEventsRequest*)a)->remove), "");
	soap_out_bool(soap, "ngwe:notify", -1, &(((_ngwe__getEventsRequest*)a)->notify), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__getEventsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__getEventsRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__getEventsRequest * SOAP_FMAC4 soap_get__ngwe__getEventsRequest(struct soap *soap, _ngwe__getEventsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__getEventsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__getEventsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__getEventsRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__getEventsRequest * SOAP_FMAC4 soap_in__ngwe__getEventsRequest(struct soap *soap, const char *tag, _ngwe__getEventsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__getEventsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__getEventsRequest, sizeof(_ngwe__getEventsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__getEventsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__getEventsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_key1 = 1, soap_flag_from1 = 1, soap_flag_until1 = 1, soap_flag_uid1 = 1, soap_flag_count1 = 1, soap_flag_remove1 = 1, soap_flag_notify1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:key", &(((_ngwe__getEventsRequest*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			if (soap_flag_from1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwe:from", &(((_ngwe__getEventsRequest*)a)->from), ""))
				{	soap_flag_from1 = 0;
					continue;
				}
			if (soap_flag_until1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwe:until", &(((_ngwe__getEventsRequest*)a)->until), ""))
				{	soap_flag_until1 = 0;
					continue;
				}
			if (soap_flag_uid1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLong(soap, "ngwe:uid", &(((_ngwe__getEventsRequest*)a)->uid), ""))
				{	soap_flag_uid1 = 0;
					continue;
				}
			if (soap_flag_count1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ngwe:count", &(((_ngwe__getEventsRequest*)a)->count), ""))
				{	soap_flag_count1 = 0;
					continue;
				}
			if (soap_flag_remove1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwe:remove", &(((_ngwe__getEventsRequest*)a)->remove), ""))
				{	soap_flag_remove1 = 0;
					continue;
				}
			if (soap_flag_notify1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwe:notify", &(((_ngwe__getEventsRequest*)a)->notify), ""))
				{	soap_flag_notify1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__getEventsRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__getEventsRequest, 0, sizeof(_ngwe__getEventsRequest), 0, soap_copy__ngwe__getEventsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__getEventsRequest * SOAP_FMAC6 soap_new__ngwe__getEventsRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__getEventsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__getEventsRequest(struct soap *soap, _ngwe__getEventsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__getEventsRequest * SOAP_FMAC6 soap_instantiate__ngwe__getEventsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__getEventsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__getEventsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__getEventsRequest;
		if (size)
			*size = sizeof(_ngwe__getEventsRequest);
		((_ngwe__getEventsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__getEventsRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__getEventsRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__getEventsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__getEventsRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__getEventsRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__getEventsRequest %p -> %p\n", q, p));
	*(_ngwe__getEventsRequest*)p = *(_ngwe__getEventsRequest*)q;
}

void _ngwe__getEventConfigurationResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__getEventConfigurationResponse*)this)->events, SOAP_TYPE_PointerTongwe__EventsList);
	soap_serialize_PointerTongwe__EventsList(soap, &((_ngwe__getEventConfigurationResponse*)this)->events);
	soap_embedded(soap, &((_ngwe__getEventConfigurationResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__getEventConfigurationResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__getEventConfigurationResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__getEventConfigurationResponse*)this)->events = NULL;
	((_ngwe__getEventConfigurationResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__getEventConfigurationResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__getEventConfigurationResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__getEventConfigurationResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__getEventConfigurationResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__getEventConfigurationResponse(struct soap *soap, const char *tag, int id, const _ngwe__getEventConfigurationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__getEventConfigurationResponse), type);
	soap_out_PointerTongwe__EventsList(soap, "ngwe:events", -1, &(((_ngwe__getEventConfigurationResponse*)a)->events), "");
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__getEventConfigurationResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__getEventConfigurationResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__getEventConfigurationResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__getEventConfigurationResponse * SOAP_FMAC4 soap_get__ngwe__getEventConfigurationResponse(struct soap *soap, _ngwe__getEventConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__getEventConfigurationResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__getEventConfigurationResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__getEventConfigurationResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__getEventConfigurationResponse * SOAP_FMAC4 soap_in__ngwe__getEventConfigurationResponse(struct soap *soap, const char *tag, _ngwe__getEventConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__getEventConfigurationResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__getEventConfigurationResponse, sizeof(_ngwe__getEventConfigurationResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__getEventConfigurationResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__getEventConfigurationResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_events1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_events1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__EventsList(soap, "ngwe:events", &(((_ngwe__getEventConfigurationResponse*)a)->events), "ngwe:EventsList"))
				{	soap_flag_events1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__getEventConfigurationResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__getEventConfigurationResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__getEventConfigurationResponse, 0, sizeof(_ngwe__getEventConfigurationResponse), 0, soap_copy__ngwe__getEventConfigurationResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__getEventConfigurationResponse * SOAP_FMAC6 soap_new__ngwe__getEventConfigurationResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__getEventConfigurationResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__getEventConfigurationResponse(struct soap *soap, _ngwe__getEventConfigurationResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__getEventConfigurationResponse * SOAP_FMAC6 soap_instantiate__ngwe__getEventConfigurationResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__getEventConfigurationResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__getEventConfigurationResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__getEventConfigurationResponse;
		if (size)
			*size = sizeof(_ngwe__getEventConfigurationResponse);
		((_ngwe__getEventConfigurationResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__getEventConfigurationResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__getEventConfigurationResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__getEventConfigurationResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__getEventConfigurationResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__getEventConfigurationResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__getEventConfigurationResponse %p -> %p\n", q, p));
	*(_ngwe__getEventConfigurationResponse*)p = *(_ngwe__getEventConfigurationResponse*)q;
}

void _ngwe__getEventConfigurationRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__getEventConfigurationRequest*)this)->key, SOAP_TYPE_PointerTostd__string);
	soap_serialize_PointerTostd__string(soap, &((_ngwe__getEventConfigurationRequest*)this)->key);
	/* transient soap skipped */
}

void _ngwe__getEventConfigurationRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__getEventConfigurationRequest*)this)->key = NULL;
	/* transient soap skipped */
}

int _ngwe__getEventConfigurationRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__getEventConfigurationRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__getEventConfigurationRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__getEventConfigurationRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__getEventConfigurationRequest(struct soap *soap, const char *tag, int id, const _ngwe__getEventConfigurationRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__getEventConfigurationRequest), type);
	soap_out_PointerTostd__string(soap, "ngwe:key", -1, &(((_ngwe__getEventConfigurationRequest*)a)->key), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__getEventConfigurationRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__getEventConfigurationRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__getEventConfigurationRequest * SOAP_FMAC4 soap_get__ngwe__getEventConfigurationRequest(struct soap *soap, _ngwe__getEventConfigurationRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__getEventConfigurationRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__getEventConfigurationRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__getEventConfigurationRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__getEventConfigurationRequest * SOAP_FMAC4 soap_in__ngwe__getEventConfigurationRequest(struct soap *soap, const char *tag, _ngwe__getEventConfigurationRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__getEventConfigurationRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__getEventConfigurationRequest, sizeof(_ngwe__getEventConfigurationRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__getEventConfigurationRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__getEventConfigurationRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_key1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ngwe:key", &(((_ngwe__getEventConfigurationRequest*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__getEventConfigurationRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__getEventConfigurationRequest, 0, sizeof(_ngwe__getEventConfigurationRequest), 0, soap_copy__ngwe__getEventConfigurationRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__getEventConfigurationRequest * SOAP_FMAC6 soap_new__ngwe__getEventConfigurationRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__getEventConfigurationRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__getEventConfigurationRequest(struct soap *soap, _ngwe__getEventConfigurationRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__getEventConfigurationRequest * SOAP_FMAC6 soap_instantiate__ngwe__getEventConfigurationRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__getEventConfigurationRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__getEventConfigurationRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__getEventConfigurationRequest;
		if (size)
			*size = sizeof(_ngwe__getEventConfigurationRequest);
		((_ngwe__getEventConfigurationRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__getEventConfigurationRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__getEventConfigurationRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__getEventConfigurationRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__getEventConfigurationRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__getEventConfigurationRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__getEventConfigurationRequest %p -> %p\n", q, p));
	*(_ngwe__getEventConfigurationRequest*)p = *(_ngwe__getEventConfigurationRequest*)q;
}

void _ngwe__configureEventsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__configureEventsResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__configureEventsResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__configureEventsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__configureEventsResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__configureEventsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__configureEventsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__configureEventsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__configureEventsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__configureEventsResponse(struct soap *soap, const char *tag, int id, const _ngwe__configureEventsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__configureEventsResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__configureEventsResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__configureEventsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__configureEventsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__configureEventsResponse * SOAP_FMAC4 soap_get__ngwe__configureEventsResponse(struct soap *soap, _ngwe__configureEventsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__configureEventsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__configureEventsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__configureEventsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__configureEventsResponse * SOAP_FMAC4 soap_in__ngwe__configureEventsResponse(struct soap *soap, const char *tag, _ngwe__configureEventsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__configureEventsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__configureEventsResponse, sizeof(_ngwe__configureEventsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__configureEventsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__configureEventsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__configureEventsResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__configureEventsResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__configureEventsResponse, 0, sizeof(_ngwe__configureEventsResponse), 0, soap_copy__ngwe__configureEventsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__configureEventsResponse * SOAP_FMAC6 soap_new__ngwe__configureEventsResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__configureEventsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__configureEventsResponse(struct soap *soap, _ngwe__configureEventsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__configureEventsResponse * SOAP_FMAC6 soap_instantiate__ngwe__configureEventsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__configureEventsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__configureEventsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__configureEventsResponse;
		if (size)
			*size = sizeof(_ngwe__configureEventsResponse);
		((_ngwe__configureEventsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__configureEventsResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__configureEventsResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__configureEventsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__configureEventsResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__configureEventsResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__configureEventsResponse %p -> %p\n", q, p));
	*(_ngwe__configureEventsResponse*)p = *(_ngwe__configureEventsResponse*)q;
}

void _ngwe__configureEventsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__configureEventsRequest*)this)->events, SOAP_TYPE_PointerTongwe__Events);
	soap_serialize_PointerTongwe__Events(soap, &((_ngwe__configureEventsRequest*)this)->events);
	/* transient soap skipped */
}

void _ngwe__configureEventsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__configureEventsRequest*)this)->events = NULL;
	/* transient soap skipped */
}

int _ngwe__configureEventsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__configureEventsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__configureEventsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__configureEventsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__configureEventsRequest(struct soap *soap, const char *tag, int id, const _ngwe__configureEventsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__configureEventsRequest), type);
	soap_out_PointerTongwe__Events(soap, "ngwe:events", -1, &(((_ngwe__configureEventsRequest*)a)->events), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__configureEventsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__configureEventsRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__configureEventsRequest * SOAP_FMAC4 soap_get__ngwe__configureEventsRequest(struct soap *soap, _ngwe__configureEventsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__configureEventsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__configureEventsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__configureEventsRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__configureEventsRequest * SOAP_FMAC4 soap_in__ngwe__configureEventsRequest(struct soap *soap, const char *tag, _ngwe__configureEventsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__configureEventsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__configureEventsRequest, sizeof(_ngwe__configureEventsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__configureEventsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__configureEventsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_events1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_events1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__Events(soap, "ngwe:events", &(((_ngwe__configureEventsRequest*)a)->events), "ngwe:Events"))
				{	soap_flag_events1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__configureEventsRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__configureEventsRequest, 0, sizeof(_ngwe__configureEventsRequest), 0, soap_copy__ngwe__configureEventsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__configureEventsRequest * SOAP_FMAC6 soap_new__ngwe__configureEventsRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__configureEventsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__configureEventsRequest(struct soap *soap, _ngwe__configureEventsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__configureEventsRequest * SOAP_FMAC6 soap_instantiate__ngwe__configureEventsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__configureEventsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__configureEventsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__configureEventsRequest;
		if (size)
			*size = sizeof(_ngwe__configureEventsRequest);
		((_ngwe__configureEventsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__configureEventsRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__configureEventsRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__configureEventsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__configureEventsRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__configureEventsRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__configureEventsRequest %p -> %p\n", q, p));
	*(_ngwe__configureEventsRequest*)p = *(_ngwe__configureEventsRequest*)q;
}

void _ngwe__cleanEventConfigurationResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__cleanEventConfigurationResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwe__cleanEventConfigurationResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwe__cleanEventConfigurationResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__cleanEventConfigurationResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwe__cleanEventConfigurationResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__cleanEventConfigurationResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__cleanEventConfigurationResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__cleanEventConfigurationResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__cleanEventConfigurationResponse(struct soap *soap, const char *tag, int id, const _ngwe__cleanEventConfigurationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__cleanEventConfigurationResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwe:status", -1, &(((_ngwe__cleanEventConfigurationResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__cleanEventConfigurationResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__cleanEventConfigurationResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__cleanEventConfigurationResponse * SOAP_FMAC4 soap_get__ngwe__cleanEventConfigurationResponse(struct soap *soap, _ngwe__cleanEventConfigurationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__cleanEventConfigurationResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__cleanEventConfigurationResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__cleanEventConfigurationResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__cleanEventConfigurationResponse * SOAP_FMAC4 soap_in__ngwe__cleanEventConfigurationResponse(struct soap *soap, const char *tag, _ngwe__cleanEventConfigurationResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__cleanEventConfigurationResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__cleanEventConfigurationResponse, sizeof(_ngwe__cleanEventConfigurationResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__cleanEventConfigurationResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__cleanEventConfigurationResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwe:status", &(((_ngwe__cleanEventConfigurationResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__cleanEventConfigurationResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__cleanEventConfigurationResponse, 0, sizeof(_ngwe__cleanEventConfigurationResponse), 0, soap_copy__ngwe__cleanEventConfigurationResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__cleanEventConfigurationResponse * SOAP_FMAC6 soap_new__ngwe__cleanEventConfigurationResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwe__cleanEventConfigurationResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__cleanEventConfigurationResponse(struct soap *soap, _ngwe__cleanEventConfigurationResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__cleanEventConfigurationResponse * SOAP_FMAC6 soap_instantiate__ngwe__cleanEventConfigurationResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__cleanEventConfigurationResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__cleanEventConfigurationResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__cleanEventConfigurationResponse;
		if (size)
			*size = sizeof(_ngwe__cleanEventConfigurationResponse);
		((_ngwe__cleanEventConfigurationResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__cleanEventConfigurationResponse[n];
		if (size)
			*size = n * sizeof(_ngwe__cleanEventConfigurationResponse);
		for (int i = 0; i < n; i++)
			((_ngwe__cleanEventConfigurationResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__cleanEventConfigurationResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__cleanEventConfigurationResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__cleanEventConfigurationResponse %p -> %p\n", q, p));
	*(_ngwe__cleanEventConfigurationResponse*)p = *(_ngwe__cleanEventConfigurationResponse*)q;
}

void _ngwe__cleanEventConfigurationRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwe__cleanEventConfigurationRequest*)this)->all, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void _ngwe__cleanEventConfigurationRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwe__cleanEventConfigurationRequest*)this)->all = (bool)0;
	/* transient soap skipped */
}

int _ngwe__cleanEventConfigurationRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwe__cleanEventConfigurationRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwe__cleanEventConfigurationRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwe__cleanEventConfigurationRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwe__cleanEventConfigurationRequest(struct soap *soap, const char *tag, int id, const _ngwe__cleanEventConfigurationRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwe__cleanEventConfigurationRequest), type);
	soap_out_bool(soap, "ngwe:all", -1, &(((_ngwe__cleanEventConfigurationRequest*)a)->all), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwe__cleanEventConfigurationRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwe__cleanEventConfigurationRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwe__cleanEventConfigurationRequest * SOAP_FMAC4 soap_get__ngwe__cleanEventConfigurationRequest(struct soap *soap, _ngwe__cleanEventConfigurationRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwe__cleanEventConfigurationRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwe__cleanEventConfigurationRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwe__cleanEventConfigurationRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwe__cleanEventConfigurationRequest * SOAP_FMAC4 soap_in__ngwe__cleanEventConfigurationRequest(struct soap *soap, const char *tag, _ngwe__cleanEventConfigurationRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwe__cleanEventConfigurationRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwe__cleanEventConfigurationRequest, sizeof(_ngwe__cleanEventConfigurationRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwe__cleanEventConfigurationRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwe__cleanEventConfigurationRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_all1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwe:all", &(((_ngwe__cleanEventConfigurationRequest*)a)->all), ""))
				{	soap_flag_all1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwe__cleanEventConfigurationRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwe__cleanEventConfigurationRequest, 0, sizeof(_ngwe__cleanEventConfigurationRequest), 0, soap_copy__ngwe__cleanEventConfigurationRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwe__cleanEventConfigurationRequest * SOAP_FMAC6 soap_new__ngwe__cleanEventConfigurationRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwe__cleanEventConfigurationRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwe__cleanEventConfigurationRequest(struct soap *soap, _ngwe__cleanEventConfigurationRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwe__cleanEventConfigurationRequest * SOAP_FMAC6 soap_instantiate__ngwe__cleanEventConfigurationRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwe__cleanEventConfigurationRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwe__cleanEventConfigurationRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwe__cleanEventConfigurationRequest;
		if (size)
			*size = sizeof(_ngwe__cleanEventConfigurationRequest);
		((_ngwe__cleanEventConfigurationRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwe__cleanEventConfigurationRequest[n];
		if (size)
			*size = n * sizeof(_ngwe__cleanEventConfigurationRequest);
		for (int i = 0; i < n; i++)
			((_ngwe__cleanEventConfigurationRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwe__cleanEventConfigurationRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwe__cleanEventConfigurationRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwe__cleanEventConfigurationRequest %p -> %p\n", q, p));
	*(_ngwe__cleanEventConfigurationRequest*)p = *(_ngwe__cleanEventConfigurationRequest*)q;
}

void ngwe__Notify::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((ngwe__Notify*)this)->userid, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((ngwe__Notify*)this)->userid);
	soap_embedded(soap, &((ngwe__Notify*)this)->key, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((ngwe__Notify*)this)->key);
	/* transient soap skipped */
}

void ngwe__Notify::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((ngwe__Notify*)this)->userid);
	soap_default_std__string(soap, &((ngwe__Notify*)this)->key);
	/* transient soap skipped */
}

int ngwe__Notify::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__Notify);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__Notify::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__Notify(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__Notify(struct soap *soap, const char *tag, int id, const ngwe__Notify *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__Notify), type);
	soap_out_std__string(soap, "ngwe:userid", -1, &(((ngwe__Notify*)a)->userid), "");
	soap_out_std__string(soap, "ngwe:key", -1, &(((ngwe__Notify*)a)->key), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__Notify::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__Notify(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__Notify * SOAP_FMAC4 soap_get_ngwe__Notify(struct soap *soap, ngwe__Notify *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__Notify(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__Notify::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__Notify(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__Notify * SOAP_FMAC4 soap_in_ngwe__Notify(struct soap *soap, const char *tag, ngwe__Notify *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__Notify *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__Notify, sizeof(ngwe__Notify), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__Notify)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__Notify *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userid1 = 1, soap_flag_key1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userid1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:userid", &(((ngwe__Notify*)a)->userid), ""))
				{	soap_flag_userid1 = 0;
					continue;
				}
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:key", &(((ngwe__Notify*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_userid1 || soap_flag_key1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__Notify *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__Notify, 0, sizeof(ngwe__Notify), 0, soap_copy_ngwe__Notify);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__Notify * SOAP_FMAC6 soap_new_ngwe__Notify(struct soap *soap, int n)
{	return soap_instantiate_ngwe__Notify(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__Notify(struct soap *soap, ngwe__Notify *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__Notify * SOAP_FMAC6 soap_instantiate_ngwe__Notify(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__Notify(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__Notify, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__Notify;
		if (size)
			*size = sizeof(ngwe__Notify);
		((ngwe__Notify*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__Notify[n];
		if (size)
			*size = n * sizeof(ngwe__Notify);
		for (int i = 0; i < n; i++)
			((ngwe__Notify*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__Notify*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__Notify(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__Notify %p -> %p\n", q, p));
	*(ngwe__Notify*)p = *(ngwe__Notify*)q;
}

void ngwe__EventTypeList::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfngwe__EventType(soap, &((ngwe__EventTypeList*)this)->event);
	/* transient soap skipped */
}

void ngwe__EventTypeList::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfngwe__EventType(soap, &((ngwe__EventTypeList*)this)->event);
	/* transient soap skipped */
}

int ngwe__EventTypeList::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__EventTypeList);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__EventTypeList::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__EventTypeList(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__EventTypeList(struct soap *soap, const char *tag, int id, const ngwe__EventTypeList *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__EventTypeList), type);
	soap_out_std__vectorTemplateOfngwe__EventType(soap, "ngwe:event", -1, &(((ngwe__EventTypeList*)a)->event), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__EventTypeList::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__EventTypeList(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__EventTypeList * SOAP_FMAC4 soap_get_ngwe__EventTypeList(struct soap *soap, ngwe__EventTypeList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__EventTypeList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__EventTypeList::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__EventTypeList(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__EventTypeList * SOAP_FMAC4 soap_in_ngwe__EventTypeList(struct soap *soap, const char *tag, ngwe__EventTypeList *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__EventTypeList *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__EventTypeList, sizeof(ngwe__EventTypeList), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__EventTypeList)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__EventTypeList *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfngwe__EventType(soap, "ngwe:event", &(((ngwe__EventTypeList*)a)->event), ""))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (((ngwe__EventTypeList*)a)->event.size() > 36))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__EventTypeList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__EventTypeList, 0, sizeof(ngwe__EventTypeList), 0, soap_copy_ngwe__EventTypeList);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__EventTypeList * SOAP_FMAC6 soap_new_ngwe__EventTypeList(struct soap *soap, int n)
{	return soap_instantiate_ngwe__EventTypeList(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__EventTypeList(struct soap *soap, ngwe__EventTypeList *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__EventTypeList * SOAP_FMAC6 soap_instantiate_ngwe__EventTypeList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__EventTypeList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__EventTypeList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__EventTypeList;
		if (size)
			*size = sizeof(ngwe__EventTypeList);
		((ngwe__EventTypeList*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__EventTypeList[n];
		if (size)
			*size = n * sizeof(ngwe__EventTypeList);
		for (int i = 0; i < n; i++)
			((ngwe__EventTypeList*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__EventTypeList*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__EventTypeList(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__EventTypeList %p -> %p\n", q, p));
	*(ngwe__EventTypeList*)p = *(ngwe__EventTypeList*)q;
}

void ngwe__EventsList::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTongwe__Events(soap, &((ngwe__EventsList*)this)->event);
	/* transient soap skipped */
}

void ngwe__EventsList::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTongwe__Events(soap, &((ngwe__EventsList*)this)->event);
	/* transient soap skipped */
}

int ngwe__EventsList::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__EventsList);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__EventsList::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__EventsList(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__EventsList(struct soap *soap, const char *tag, int id, const ngwe__EventsList *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__EventsList), type);
	soap_out_std__vectorTemplateOfPointerTongwe__Events(soap, "ngwe:event", -1, &(((ngwe__EventsList*)a)->event), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__EventsList::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__EventsList(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__EventsList * SOAP_FMAC4 soap_get_ngwe__EventsList(struct soap *soap, ngwe__EventsList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__EventsList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__EventsList::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__EventsList(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__EventsList * SOAP_FMAC4 soap_in_ngwe__EventsList(struct soap *soap, const char *tag, ngwe__EventsList *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__EventsList *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__EventsList, sizeof(ngwe__EventsList), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__EventsList)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__EventsList *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTongwe__Events(soap, "ngwe:event", &(((ngwe__EventsList*)a)->event), "ngwe:Events"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__EventsList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__EventsList, 0, sizeof(ngwe__EventsList), 0, soap_copy_ngwe__EventsList);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__EventsList * SOAP_FMAC6 soap_new_ngwe__EventsList(struct soap *soap, int n)
{	return soap_instantiate_ngwe__EventsList(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__EventsList(struct soap *soap, ngwe__EventsList *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__EventsList * SOAP_FMAC6 soap_instantiate_ngwe__EventsList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__EventsList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__EventsList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__EventsList;
		if (size)
			*size = sizeof(ngwe__EventsList);
		((ngwe__EventsList*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__EventsList[n];
		if (size)
			*size = n * sizeof(ngwe__EventsList);
		for (int i = 0; i < n; i++)
			((ngwe__EventsList*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__EventsList*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__EventsList(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__EventsList %p -> %p\n", q, p));
	*(ngwe__EventsList*)p = *(ngwe__EventsList*)q;
}

void ngwe__Events::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((ngwe__Events*)this)->key, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((ngwe__Events*)this)->key);
	soap_embedded(soap, &((ngwe__Events*)this)->persistence, SOAP_TYPE_PointerToxsd__duration);
	soap_serialize_PointerToxsd__duration(soap, &((ngwe__Events*)this)->persistence);
	soap_embedded(soap, &((ngwe__Events*)this)->ipAddress, SOAP_TYPE_PointerTostd__string);
	soap_serialize_PointerTostd__string(soap, &((ngwe__Events*)this)->ipAddress);
	soap_embedded(soap, &((ngwe__Events*)this)->port, SOAP_TYPE_PointerToint);
	soap_serialize_PointerToint(soap, &((ngwe__Events*)this)->port);
	soap_embedded(soap, &((ngwe__Events*)this)->http, SOAP_TYPE_bool);
	soap_embedded(soap, &((ngwe__Events*)this)->definition, SOAP_TYPE_PointerTongwe__EventDefinition);
	soap_serialize_PointerTongwe__EventDefinition(soap, &((ngwe__Events*)this)->definition);
	/* transient soap skipped */
}

void ngwe__Events::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((ngwe__Events*)this)->key);
	((ngwe__Events*)this)->persistence = NULL;
	((ngwe__Events*)this)->ipAddress = NULL;
	((ngwe__Events*)this)->port = NULL;
	((ngwe__Events*)this)->http = (bool)0;
	((ngwe__Events*)this)->definition = NULL;
	((ngwe__Events*)this)->enabled = NULL;
	/* transient soap skipped */
}

int ngwe__Events::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__Events);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__Events::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__Events(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__Events(struct soap *soap, const char *tag, int id, const ngwe__Events *a, const char *type)
{
	if (((ngwe__Events *)a)->enabled)
		soap_set_attr(soap, "enabled", soap_bool2s(soap, *((ngwe__Events *)a)->enabled));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__Events), type);
	soap_out_std__string(soap, "ngwe:key", -1, &(((ngwe__Events*)a)->key), "");
	soap_out_PointerToxsd__duration(soap, "ngwe:persistence", -1, &(((ngwe__Events*)a)->persistence), "");
	soap_out_PointerTostd__string(soap, "ngwe:ipAddress", -1, &(((ngwe__Events*)a)->ipAddress), "");
	soap_out_PointerToint(soap, "ngwe:port", -1, &(((ngwe__Events*)a)->port), "");
	soap_out_bool(soap, "ngwe:http", -1, &(((ngwe__Events*)a)->http), "");
	soap_out_PointerTongwe__EventDefinition(soap, "ngwe:definition", -1, &(((ngwe__Events*)a)->definition), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__Events::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__Events(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__Events * SOAP_FMAC4 soap_get_ngwe__Events(struct soap *soap, ngwe__Events *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__Events(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__Events::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__Events(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__Events * SOAP_FMAC4 soap_in_ngwe__Events(struct soap *soap, const char *tag, ngwe__Events *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__Events *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__Events, sizeof(ngwe__Events), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__Events)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__Events *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "enabled", 0);
		if (t)
		{	if (!(((ngwe__Events *)a)->enabled = (bool *)soap_malloc(soap, sizeof(bool))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2bool(soap, t, ((ngwe__Events *)a)->enabled))
		return NULL;
		}
	}
	short soap_flag_key1 = 1, soap_flag_persistence1 = 1, soap_flag_ipAddress1 = 1, soap_flag_port1 = 1, soap_flag_http1 = 1, soap_flag_definition1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "ngwe:key", &(((ngwe__Events*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			if (soap_flag_persistence1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerToxsd__duration(soap, "ngwe:persistence", &(((ngwe__Events*)a)->persistence), "xsd:duration"))
				{	soap_flag_persistence1 = 0;
					continue;
				}
			if (soap_flag_ipAddress1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ngwe:ipAddress", &(((ngwe__Events*)a)->ipAddress), ""))
				{	soap_flag_ipAddress1 = 0;
					continue;
				}
			if (soap_flag_port1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ngwe:port", &(((ngwe__Events*)a)->port), ""))
				{	soap_flag_port1 = 0;
					continue;
				}
			if (soap_flag_http1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwe:http", &(((ngwe__Events*)a)->http), ""))
				{	soap_flag_http1 = 0;
					continue;
				}
			if (soap_flag_definition1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__EventDefinition(soap, "ngwe:definition", &(((ngwe__Events*)a)->definition), "ngwe:EventDefinition"))
				{	soap_flag_definition1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_key1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__Events *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__Events, 0, sizeof(ngwe__Events), 0, soap_copy_ngwe__Events);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__Events * SOAP_FMAC6 soap_new_ngwe__Events(struct soap *soap, int n)
{	return soap_instantiate_ngwe__Events(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__Events(struct soap *soap, ngwe__Events *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__Events * SOAP_FMAC6 soap_instantiate_ngwe__Events(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__Events(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__Events, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__Events;
		if (size)
			*size = sizeof(ngwe__Events);
		((ngwe__Events*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__Events[n];
		if (size)
			*size = n * sizeof(ngwe__Events);
		for (int i = 0; i < n; i++)
			((ngwe__Events*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__Events*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__Events(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__Events %p -> %p\n", q, p));
	*(ngwe__Events*)p = *(ngwe__Events*)q;
}

void ngwe__EventList::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfPointerTongwe__Event(soap, &((ngwe__EventList*)this)->event);
	/* transient soap skipped */
}

void ngwe__EventList::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfPointerTongwe__Event(soap, &((ngwe__EventList*)this)->event);
	/* transient soap skipped */
}

int ngwe__EventList::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__EventList);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__EventList::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__EventList(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__EventList(struct soap *soap, const char *tag, int id, const ngwe__EventList *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__EventList), type);
	soap_out_std__vectorTemplateOfPointerTongwe__Event(soap, "ngwe:event", -1, &(((ngwe__EventList*)a)->event), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__EventList::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__EventList(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__EventList * SOAP_FMAC4 soap_get_ngwe__EventList(struct soap *soap, ngwe__EventList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__EventList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__EventList::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__EventList(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__EventList * SOAP_FMAC4 soap_in_ngwe__EventList(struct soap *soap, const char *tag, ngwe__EventList *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__EventList *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__EventList, sizeof(ngwe__EventList), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__EventList)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__EventList *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTongwe__Event(soap, "ngwe:event", &(((ngwe__EventList*)a)->event), "ngwe:Event"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__EventList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__EventList, 0, sizeof(ngwe__EventList), 0, soap_copy_ngwe__EventList);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__EventList * SOAP_FMAC6 soap_new_ngwe__EventList(struct soap *soap, int n)
{	return soap_instantiate_ngwe__EventList(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__EventList(struct soap *soap, ngwe__EventList *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__EventList * SOAP_FMAC6 soap_instantiate_ngwe__EventList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__EventList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__EventList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__EventList;
		if (size)
			*size = sizeof(ngwe__EventList);
		((ngwe__EventList*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__EventList[n];
		if (size)
			*size = n * sizeof(ngwe__EventList);
		for (int i = 0; i < n; i++)
			((ngwe__EventList*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__EventList*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__EventList(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__EventList %p -> %p\n", q, p));
	*(ngwe__EventList*)p = *(ngwe__EventList*)q;
}

void ngwe__EventDefinition::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((ngwe__EventDefinition*)this)->events, SOAP_TYPE_PointerTongwe__EventTypeList);
	soap_serialize_PointerTongwe__EventTypeList(soap, &((ngwe__EventDefinition*)this)->events);
	soap_embedded(soap, &((ngwe__EventDefinition*)this)->type, SOAP_TYPE_PointerTongwe__ItemTypeList);
	soap_serialize_PointerTongwe__ItemTypeList(soap, &((ngwe__EventDefinition*)this)->type);
	soap_embedded(soap, &((ngwe__EventDefinition*)this)->field, SOAP_TYPE_PointerTongwe__FieldList);
	soap_serialize_PointerTongwe__FieldList(soap, &((ngwe__EventDefinition*)this)->field);
	soap_embedded(soap, &((ngwe__EventDefinition*)this)->containers, SOAP_TYPE_PointerTongwe__ContainerList);
	soap_serialize_PointerTongwe__ContainerList(soap, &((ngwe__EventDefinition*)this)->containers);
	soap_embedded(soap, &((ngwe__EventDefinition*)this)->subType, SOAP_TYPE_PointerTostd__string);
	soap_serialize_PointerTostd__string(soap, &((ngwe__EventDefinition*)this)->subType);
	/* transient soap skipped */
}

void ngwe__EventDefinition::soap_default(struct soap *soap)
{
	this->soap = soap;
	((ngwe__EventDefinition*)this)->events = NULL;
	((ngwe__EventDefinition*)this)->type = NULL;
	((ngwe__EventDefinition*)this)->field = NULL;
	((ngwe__EventDefinition*)this)->containers = NULL;
	((ngwe__EventDefinition*)this)->subType = NULL;
	/* transient soap skipped */
}

int ngwe__EventDefinition::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__EventDefinition);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__EventDefinition::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__EventDefinition(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__EventDefinition(struct soap *soap, const char *tag, int id, const ngwe__EventDefinition *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__EventDefinition), type);
	soap_out_PointerTongwe__EventTypeList(soap, "ngwe:events", -1, &(((ngwe__EventDefinition*)a)->events), "");
	soap_out_PointerTongwe__ItemTypeList(soap, "ngwe:type", -1, &(((ngwe__EventDefinition*)a)->type), "");
	soap_out_PointerTongwe__FieldList(soap, "ngwe:field", -1, &(((ngwe__EventDefinition*)a)->field), "");
	soap_out_PointerTongwe__ContainerList(soap, "ngwe:containers", -1, &(((ngwe__EventDefinition*)a)->containers), "");
	soap_out_PointerTostd__string(soap, "ngwe:subType", -1, &(((ngwe__EventDefinition*)a)->subType), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__EventDefinition::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__EventDefinition(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__EventDefinition * SOAP_FMAC4 soap_get_ngwe__EventDefinition(struct soap *soap, ngwe__EventDefinition *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__EventDefinition(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__EventDefinition::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__EventDefinition(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__EventDefinition * SOAP_FMAC4 soap_in_ngwe__EventDefinition(struct soap *soap, const char *tag, ngwe__EventDefinition *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__EventDefinition *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__EventDefinition, sizeof(ngwe__EventDefinition), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__EventDefinition)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__EventDefinition *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_events1 = 1, soap_flag_type1 = 1, soap_flag_field1 = 1, soap_flag_containers1 = 1, soap_flag_subType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_events1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__EventTypeList(soap, "ngwe:events", &(((ngwe__EventDefinition*)a)->events), "ngwe:EventTypeList"))
				{	soap_flag_events1 = 0;
					continue;
				}
			if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__ItemTypeList(soap, "ngwe:type", &(((ngwe__EventDefinition*)a)->type), ""))
				{	soap_flag_type1 = 0;
					continue;
				}
			if (soap_flag_field1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__FieldList(soap, "ngwe:field", &(((ngwe__EventDefinition*)a)->field), ""))
				{	soap_flag_field1 = 0;
					continue;
				}
			if (soap_flag_containers1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__ContainerList(soap, "ngwe:containers", &(((ngwe__EventDefinition*)a)->containers), "ngwe:ContainerList"))
				{	soap_flag_containers1 = 0;
					continue;
				}
			if (soap_flag_subType1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ngwe:subType", &(((ngwe__EventDefinition*)a)->subType), ""))
				{	soap_flag_subType1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_events1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__EventDefinition *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__EventDefinition, 0, sizeof(ngwe__EventDefinition), 0, soap_copy_ngwe__EventDefinition);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__EventDefinition * SOAP_FMAC6 soap_new_ngwe__EventDefinition(struct soap *soap, int n)
{	return soap_instantiate_ngwe__EventDefinition(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__EventDefinition(struct soap *soap, ngwe__EventDefinition *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__EventDefinition * SOAP_FMAC6 soap_instantiate_ngwe__EventDefinition(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__EventDefinition(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__EventDefinition, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__EventDefinition;
		if (size)
			*size = sizeof(ngwe__EventDefinition);
		((ngwe__EventDefinition*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__EventDefinition[n];
		if (size)
			*size = n * sizeof(ngwe__EventDefinition);
		for (int i = 0; i < n; i++)
			((ngwe__EventDefinition*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__EventDefinition*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__EventDefinition(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__EventDefinition %p -> %p\n", q, p));
	*(ngwe__EventDefinition*)p = *(ngwe__EventDefinition*)q;
}

void ngwe__Event::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((ngwe__Event*)this)->event, SOAP_TYPE_ngwe__EventType);
	soap_embedded(soap, &((ngwe__Event*)this)->id, SOAP_TYPE_PointerTongwt__uid);
	soap_serialize_PointerTongwt__uid(soap, &((ngwe__Event*)this)->id);
	soap_embedded(soap, &((ngwe__Event*)this)->timeStamp, SOAP_TYPE_string);
	soap_serialize_string(soap, &((ngwe__Event*)this)->timeStamp);
	soap_embedded(soap, &((ngwe__Event*)this)->field, SOAP_TYPE_PointerTongwe__FieldList);
	soap_serialize_PointerTongwe__FieldList(soap, &((ngwe__Event*)this)->field);
	soap_embedded(soap, &((ngwe__Event*)this)->container, SOAP_TYPE_PointerTongwt__uid);
	soap_serialize_PointerTongwt__uid(soap, &((ngwe__Event*)this)->container);
	soap_embedded(soap, &((ngwe__Event*)this)->from, SOAP_TYPE_PointerTongwt__uid);
	soap_serialize_PointerTongwt__uid(soap, &((ngwe__Event*)this)->from);
	soap_embedded(soap, &((ngwe__Event*)this)->key, SOAP_TYPE_PointerTostd__string);
	soap_serialize_PointerTostd__string(soap, &((ngwe__Event*)this)->key);
	soap_embedded(soap, &((ngwe__Event*)this)->uid, SOAP_TYPE_PointerTounsignedLong);
	soap_serialize_PointerTounsignedLong(soap, &((ngwe__Event*)this)->uid);
	soap_embedded(soap, &((ngwe__Event*)this)->type, SOAP_TYPE_PointerTongwe__ItemType);
	soap_serialize_PointerTongwe__ItemType(soap, &((ngwe__Event*)this)->type);
	/* transient soap skipped */
}

void ngwe__Event::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwe__EventType(soap, &((ngwe__Event*)this)->event);
	((ngwe__Event*)this)->id = NULL;
	soap_default_string(soap, &((ngwe__Event*)this)->timeStamp);
	((ngwe__Event*)this)->field = NULL;
	((ngwe__Event*)this)->container = NULL;
	((ngwe__Event*)this)->from = NULL;
	((ngwe__Event*)this)->key = NULL;
	((ngwe__Event*)this)->uid = NULL;
	((ngwe__Event*)this)->type = NULL;
	/* transient soap skipped */
}

int ngwe__Event::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__Event);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__Event::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__Event(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__Event(struct soap *soap, const char *tag, int id, const ngwe__Event *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__Event), type);
	soap_out_ngwe__EventType(soap, "ngwe:event", -1, &(((ngwe__Event*)a)->event), "");
	soap_out_PointerTongwt__uid(soap, "ngwe:id", -1, &(((ngwe__Event*)a)->id), "");
	soap_out_string(soap, "ngwe:timeStamp", -1, &(((ngwe__Event*)a)->timeStamp), "");
	soap_out_PointerTongwe__FieldList(soap, "ngwe:field", -1, &(((ngwe__Event*)a)->field), "");
	soap_out_PointerTongwt__uid(soap, "ngwe:container", -1, &(((ngwe__Event*)a)->container), "");
	soap_out_PointerTongwt__uid(soap, "ngwe:from", -1, &(((ngwe__Event*)a)->from), "");
	soap_out_PointerTostd__string(soap, "ngwe:key", -1, &(((ngwe__Event*)a)->key), "");
	soap_out_PointerTounsignedLong(soap, "ngwe:uid", -1, &(((ngwe__Event*)a)->uid), "");
	soap_out_PointerTongwe__ItemType(soap, "ngwe:type", -1, &(((ngwe__Event*)a)->type), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__Event::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__Event(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__Event * SOAP_FMAC4 soap_get_ngwe__Event(struct soap *soap, ngwe__Event *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__Event(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__Event::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__Event(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__Event * SOAP_FMAC4 soap_in_ngwe__Event(struct soap *soap, const char *tag, ngwe__Event *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__Event *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__Event, sizeof(ngwe__Event), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__Event)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__Event *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_event1 = 1, soap_flag_id1 = 1, soap_flag_timeStamp1 = 1, soap_flag_field1 = 1, soap_flag_container1 = 1, soap_flag_from1 = 1, soap_flag_key1 = 1, soap_flag_uid1 = 1, soap_flag_type1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_event1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ngwe__EventType(soap, "ngwe:event", &(((ngwe__Event*)a)->event), ""))
				{	soap_flag_event1 = 0;
					continue;
				}
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__uid(soap, "ngwe:id", &(((ngwe__Event*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			if (soap_flag_timeStamp1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwe:timeStamp", &(((ngwe__Event*)a)->timeStamp), ""))
				{	soap_flag_timeStamp1 = 0;
					continue;
				}
			if (soap_flag_field1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__FieldList(soap, "ngwe:field", &(((ngwe__Event*)a)->field), ""))
				{	soap_flag_field1 = 0;
					continue;
				}
			if (soap_flag_container1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__uid(soap, "ngwe:container", &(((ngwe__Event*)a)->container), "ngwt:uid"))
				{	soap_flag_container1 = 0;
					continue;
				}
			if (soap_flag_from1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__uid(soap, "ngwe:from", &(((ngwe__Event*)a)->from), "ngwt:uid"))
				{	soap_flag_from1 = 0;
					continue;
				}
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ngwe:key", &(((ngwe__Event*)a)->key), ""))
				{	soap_flag_key1 = 0;
					continue;
				}
			if (soap_flag_uid1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLong(soap, "ngwe:uid", &(((ngwe__Event*)a)->uid), ""))
				{	soap_flag_uid1 = 0;
					continue;
				}
			if (soap_flag_type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwe__ItemType(soap, "ngwe:type", &(((ngwe__Event*)a)->type), ""))
				{	soap_flag_type1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_event1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__Event *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__Event, 0, sizeof(ngwe__Event), 0, soap_copy_ngwe__Event);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__Event * SOAP_FMAC6 soap_new_ngwe__Event(struct soap *soap, int n)
{	return soap_instantiate_ngwe__Event(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__Event(struct soap *soap, ngwe__Event *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__Event * SOAP_FMAC6 soap_instantiate_ngwe__Event(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__Event(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__Event, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__Event;
		if (size)
			*size = sizeof(ngwe__Event);
		((ngwe__Event*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__Event[n];
		if (size)
			*size = n * sizeof(ngwe__Event);
		for (int i = 0; i < n; i++)
			((ngwe__Event*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__Event*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__Event(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__Event %p -> %p\n", q, p));
	*(ngwe__Event*)p = *(ngwe__Event*)q;
}

void ngwe__ContainerList::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfngwt__uid(soap, &((ngwe__ContainerList*)this)->container);
	/* transient soap skipped */
}

void ngwe__ContainerList::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfngwt__uid(soap, &((ngwe__ContainerList*)this)->container);
	((ngwe__ContainerList*)this)->not_ = NULL;
	/* transient soap skipped */
}

int ngwe__ContainerList::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ngwe__ContainerList);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int ngwe__ContainerList::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ngwe__ContainerList(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ngwe__ContainerList(struct soap *soap, const char *tag, int id, const ngwe__ContainerList *a, const char *type)
{
	if (((ngwe__ContainerList *)a)->not_)
		soap_set_attr(soap, "not", soap_bool2s(soap, *((ngwe__ContainerList *)a)->not_));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ngwe__ContainerList), type);
	soap_out_std__vectorTemplateOfngwt__uid(soap, "ngwe:container", -1, &(((ngwe__ContainerList*)a)->container), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *ngwe__ContainerList::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ngwe__ContainerList(soap, this, tag, type);
}

SOAP_FMAC3 ngwe__ContainerList * SOAP_FMAC4 soap_get_ngwe__ContainerList(struct soap *soap, ngwe__ContainerList *p, const char *tag, const char *type)
{
	if ((p = soap_in_ngwe__ContainerList(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *ngwe__ContainerList::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ngwe__ContainerList(soap, tag, this, type);
}

SOAP_FMAC3 ngwe__ContainerList * SOAP_FMAC4 soap_in_ngwe__ContainerList(struct soap *soap, const char *tag, ngwe__ContainerList *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (ngwe__ContainerList *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ngwe__ContainerList, sizeof(ngwe__ContainerList), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ngwe__ContainerList)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ngwe__ContainerList *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "not", 0);
		if (t)
		{	if (!(((ngwe__ContainerList *)a)->not_ = (bool *)soap_malloc(soap, sizeof(bool))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2bool(soap, t, ((ngwe__ContainerList *)a)->not_))
		return NULL;
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfngwt__uid(soap, "ngwe:container", &(((ngwe__ContainerList*)a)->container), "ngwt:uid"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ngwe__ContainerList *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE_ngwe__ContainerList, 0, sizeof(ngwe__ContainerList), 0, soap_copy_ngwe__ContainerList);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 ngwe__ContainerList * SOAP_FMAC6 soap_new_ngwe__ContainerList(struct soap *soap, int n)
{	return soap_instantiate_ngwe__ContainerList(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ngwe__ContainerList(struct soap *soap, ngwe__ContainerList *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 ngwe__ContainerList * SOAP_FMAC6 soap_instantiate_ngwe__ContainerList(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ngwe__ContainerList(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ngwe__ContainerList, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new ngwe__ContainerList;
		if (size)
			*size = sizeof(ngwe__ContainerList);
		((ngwe__ContainerList*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new ngwe__ContainerList[n];
		if (size)
			*size = n * sizeof(ngwe__ContainerList);
		for (int i = 0; i < n; i++)
			((ngwe__ContainerList*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ngwe__ContainerList*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy_ngwe__ContainerList(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ngwe__ContainerList %p -> %p\n", q, p));
	*(ngwe__ContainerList*)p = *(ngwe__ContainerList*)q;
}

void _ngwm__updateVersionStatusResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__updateVersionStatusResponse*)this)->part, SOAP_TYPE_PointerTongwt__SignatureData);
	soap_serialize_PointerTongwt__SignatureData(soap, &((_ngwm__updateVersionStatusResponse*)this)->part);
	soap_embedded(soap, &((_ngwm__updateVersionStatusResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__updateVersionStatusResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__updateVersionStatusResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__updateVersionStatusResponse*)this)->part = NULL;
	((_ngwm__updateVersionStatusResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__updateVersionStatusResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__updateVersionStatusResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__updateVersionStatusResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__updateVersionStatusResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__updateVersionStatusResponse(struct soap *soap, const char *tag, int id, const _ngwm__updateVersionStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__updateVersionStatusResponse), type);
	soap_out_PointerTongwt__SignatureData(soap, "ngwm:part", -1, &(((_ngwm__updateVersionStatusResponse*)a)->part), "");
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__updateVersionStatusResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__updateVersionStatusResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__updateVersionStatusResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__updateVersionStatusResponse * SOAP_FMAC4 soap_get__ngwm__updateVersionStatusResponse(struct soap *soap, _ngwm__updateVersionStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__updateVersionStatusResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__updateVersionStatusResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__updateVersionStatusResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__updateVersionStatusResponse * SOAP_FMAC4 soap_in__ngwm__updateVersionStatusResponse(struct soap *soap, const char *tag, _ngwm__updateVersionStatusResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__updateVersionStatusResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__updateVersionStatusResponse, sizeof(_ngwm__updateVersionStatusResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__updateVersionStatusResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__updateVersionStatusResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_part1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_part1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__SignatureData(soap, "ngwm:part", &(((_ngwm__updateVersionStatusResponse*)a)->part), "ngwt:SignatureData"))
				{	soap_flag_part1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__updateVersionStatusResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__updateVersionStatusResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__updateVersionStatusResponse, 0, sizeof(_ngwm__updateVersionStatusResponse), 0, soap_copy__ngwm__updateVersionStatusResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__updateVersionStatusResponse * SOAP_FMAC6 soap_new__ngwm__updateVersionStatusResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__updateVersionStatusResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__updateVersionStatusResponse(struct soap *soap, _ngwm__updateVersionStatusResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__updateVersionStatusResponse * SOAP_FMAC6 soap_instantiate__ngwm__updateVersionStatusResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__updateVersionStatusResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__updateVersionStatusResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__updateVersionStatusResponse;
		if (size)
			*size = sizeof(_ngwm__updateVersionStatusResponse);
		((_ngwm__updateVersionStatusResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__updateVersionStatusResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__updateVersionStatusResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__updateVersionStatusResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__updateVersionStatusResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__updateVersionStatusResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__updateVersionStatusResponse %p -> %p\n", q, p));
	*(_ngwm__updateVersionStatusResponse*)p = *(_ngwm__updateVersionStatusResponse*)q;
}

void _ngwm__updateVersionStatusRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__updateVersionStatusRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__updateVersionStatusRequest*)this)->id);
	soap_embedded(soap, &((_ngwm__updateVersionStatusRequest*)this)->event, SOAP_TYPE_ngwt__VersionEventType);
	soap_embedded(soap, &((_ngwm__updateVersionStatusRequest*)this)->part, SOAP_TYPE_PointerTongwt__SignatureData);
	soap_serialize_PointerTongwt__SignatureData(soap, &((_ngwm__updateVersionStatusRequest*)this)->part);
	/* transient soap skipped */
}

void _ngwm__updateVersionStatusRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__updateVersionStatusRequest*)this)->id);
	soap_default_ngwt__VersionEventType(soap, &((_ngwm__updateVersionStatusRequest*)this)->event);
	((_ngwm__updateVersionStatusRequest*)this)->part = NULL;
	/* transient soap skipped */
}

int _ngwm__updateVersionStatusRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__updateVersionStatusRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__updateVersionStatusRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__updateVersionStatusRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__updateVersionStatusRequest(struct soap *soap, const char *tag, int id, const _ngwm__updateVersionStatusRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__updateVersionStatusRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__updateVersionStatusRequest*)a)->id), "");
	soap_out_ngwt__VersionEventType(soap, "ngwm:event", -1, &(((_ngwm__updateVersionStatusRequest*)a)->event), "");
	soap_out_PointerTongwt__SignatureData(soap, "ngwm:part", -1, &(((_ngwm__updateVersionStatusRequest*)a)->part), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__updateVersionStatusRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__updateVersionStatusRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__updateVersionStatusRequest * SOAP_FMAC4 soap_get__ngwm__updateVersionStatusRequest(struct soap *soap, _ngwm__updateVersionStatusRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__updateVersionStatusRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__updateVersionStatusRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__updateVersionStatusRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__updateVersionStatusRequest * SOAP_FMAC4 soap_in__ngwm__updateVersionStatusRequest(struct soap *soap, const char *tag, _ngwm__updateVersionStatusRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__updateVersionStatusRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__updateVersionStatusRequest, sizeof(_ngwm__updateVersionStatusRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__updateVersionStatusRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__updateVersionStatusRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_event1 = 1, soap_flag_part1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__updateVersionStatusRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			if (soap_flag_event1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ngwt__VersionEventType(soap, "ngwm:event", &(((_ngwm__updateVersionStatusRequest*)a)->event), ""))
				{	soap_flag_event1 = 0;
					continue;
				}
			if (soap_flag_part1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__SignatureData(soap, "ngwm:part", &(((_ngwm__updateVersionStatusRequest*)a)->part), "ngwt:SignatureData"))
				{	soap_flag_part1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1 || soap_flag_event1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__updateVersionStatusRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__updateVersionStatusRequest, 0, sizeof(_ngwm__updateVersionStatusRequest), 0, soap_copy__ngwm__updateVersionStatusRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__updateVersionStatusRequest * SOAP_FMAC6 soap_new__ngwm__updateVersionStatusRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__updateVersionStatusRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__updateVersionStatusRequest(struct soap *soap, _ngwm__updateVersionStatusRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__updateVersionStatusRequest * SOAP_FMAC6 soap_instantiate__ngwm__updateVersionStatusRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__updateVersionStatusRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__updateVersionStatusRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__updateVersionStatusRequest;
		if (size)
			*size = sizeof(_ngwm__updateVersionStatusRequest);
		((_ngwm__updateVersionStatusRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__updateVersionStatusRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__updateVersionStatusRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__updateVersionStatusRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__updateVersionStatusRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__updateVersionStatusRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__updateVersionStatusRequest %p -> %p\n", q, p));
	*(_ngwm__updateVersionStatusRequest*)p = *(_ngwm__updateVersionStatusRequest*)q;
}

void _ngwm__uncompleteResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__uncompleteResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__uncompleteResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__uncompleteResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__uncompleteResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__uncompleteResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__uncompleteResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__uncompleteResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__uncompleteResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__uncompleteResponse(struct soap *soap, const char *tag, int id, const _ngwm__uncompleteResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__uncompleteResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__uncompleteResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__uncompleteResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__uncompleteResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__uncompleteResponse * SOAP_FMAC4 soap_get__ngwm__uncompleteResponse(struct soap *soap, _ngwm__uncompleteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__uncompleteResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__uncompleteResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__uncompleteResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__uncompleteResponse * SOAP_FMAC4 soap_in__ngwm__uncompleteResponse(struct soap *soap, const char *tag, _ngwm__uncompleteResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__uncompleteResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__uncompleteResponse, sizeof(_ngwm__uncompleteResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__uncompleteResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__uncompleteResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__uncompleteResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__uncompleteResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__uncompleteResponse, 0, sizeof(_ngwm__uncompleteResponse), 0, soap_copy__ngwm__uncompleteResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__uncompleteResponse * SOAP_FMAC6 soap_new__ngwm__uncompleteResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__uncompleteResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__uncompleteResponse(struct soap *soap, _ngwm__uncompleteResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__uncompleteResponse * SOAP_FMAC6 soap_instantiate__ngwm__uncompleteResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__uncompleteResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__uncompleteResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__uncompleteResponse;
		if (size)
			*size = sizeof(_ngwm__uncompleteResponse);
		((_ngwm__uncompleteResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__uncompleteResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__uncompleteResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__uncompleteResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__uncompleteResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__uncompleteResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__uncompleteResponse %p -> %p\n", q, p));
	*(_ngwm__uncompleteResponse*)p = *(_ngwm__uncompleteResponse*)q;
}

void _ngwm__uncompleteRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__uncompleteRequest*)this)->items, SOAP_TYPE_PointerTongwt__ItemRefList);
	soap_serialize_PointerTongwt__ItemRefList(soap, &((_ngwm__uncompleteRequest*)this)->items);
	/* transient soap skipped */
}

void _ngwm__uncompleteRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__uncompleteRequest*)this)->items = NULL;
	/* transient soap skipped */
}

int _ngwm__uncompleteRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__uncompleteRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__uncompleteRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__uncompleteRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__uncompleteRequest(struct soap *soap, const char *tag, int id, const _ngwm__uncompleteRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__uncompleteRequest), type);
	soap_out_PointerTongwt__ItemRefList(soap, "ngwm:items", -1, &(((_ngwm__uncompleteRequest*)a)->items), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__uncompleteRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__uncompleteRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__uncompleteRequest * SOAP_FMAC4 soap_get__ngwm__uncompleteRequest(struct soap *soap, _ngwm__uncompleteRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__uncompleteRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__uncompleteRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__uncompleteRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__uncompleteRequest * SOAP_FMAC4 soap_in__ngwm__uncompleteRequest(struct soap *soap, const char *tag, _ngwm__uncompleteRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__uncompleteRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__uncompleteRequest, sizeof(_ngwm__uncompleteRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__uncompleteRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__uncompleteRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_items1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemRefList(soap, "ngwm:items", &(((_ngwm__uncompleteRequest*)a)->items), "ngwt:ItemRefList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_items1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__uncompleteRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__uncompleteRequest, 0, sizeof(_ngwm__uncompleteRequest), 0, soap_copy__ngwm__uncompleteRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__uncompleteRequest * SOAP_FMAC6 soap_new__ngwm__uncompleteRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__uncompleteRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__uncompleteRequest(struct soap *soap, _ngwm__uncompleteRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__uncompleteRequest * SOAP_FMAC6 soap_instantiate__ngwm__uncompleteRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__uncompleteRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__uncompleteRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__uncompleteRequest;
		if (size)
			*size = sizeof(_ngwm__uncompleteRequest);
		((_ngwm__uncompleteRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__uncompleteRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__uncompleteRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__uncompleteRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__uncompleteRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__uncompleteRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__uncompleteRequest %p -> %p\n", q, p));
	*(_ngwm__uncompleteRequest*)p = *(_ngwm__uncompleteRequest*)q;
}

void _ngwm__unacceptResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__unacceptResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__unacceptResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__unacceptResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__unacceptResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__unacceptResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__unacceptResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__unacceptResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__unacceptResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__unacceptResponse(struct soap *soap, const char *tag, int id, const _ngwm__unacceptResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__unacceptResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__unacceptResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__unacceptResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__unacceptResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__unacceptResponse * SOAP_FMAC4 soap_get__ngwm__unacceptResponse(struct soap *soap, _ngwm__unacceptResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__unacceptResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__unacceptResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__unacceptResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__unacceptResponse * SOAP_FMAC4 soap_in__ngwm__unacceptResponse(struct soap *soap, const char *tag, _ngwm__unacceptResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__unacceptResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__unacceptResponse, sizeof(_ngwm__unacceptResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__unacceptResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__unacceptResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__unacceptResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__unacceptResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__unacceptResponse, 0, sizeof(_ngwm__unacceptResponse), 0, soap_copy__ngwm__unacceptResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__unacceptResponse * SOAP_FMAC6 soap_new__ngwm__unacceptResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__unacceptResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__unacceptResponse(struct soap *soap, _ngwm__unacceptResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__unacceptResponse * SOAP_FMAC6 soap_instantiate__ngwm__unacceptResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__unacceptResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__unacceptResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__unacceptResponse;
		if (size)
			*size = sizeof(_ngwm__unacceptResponse);
		((_ngwm__unacceptResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__unacceptResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__unacceptResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__unacceptResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__unacceptResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__unacceptResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__unacceptResponse %p -> %p\n", q, p));
	*(_ngwm__unacceptResponse*)p = *(_ngwm__unacceptResponse*)q;
}

void _ngwm__unacceptRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__unacceptRequest*)this)->items, SOAP_TYPE_PointerTongwt__ItemRefList);
	soap_serialize_PointerTongwt__ItemRefList(soap, &((_ngwm__unacceptRequest*)this)->items);
	/* transient soap skipped */
}

void _ngwm__unacceptRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__unacceptRequest*)this)->items = NULL;
	/* transient soap skipped */
}

int _ngwm__unacceptRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__unacceptRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__unacceptRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__unacceptRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__unacceptRequest(struct soap *soap, const char *tag, int id, const _ngwm__unacceptRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__unacceptRequest), type);
	soap_out_PointerTongwt__ItemRefList(soap, "ngwm:items", -1, &(((_ngwm__unacceptRequest*)a)->items), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__unacceptRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__unacceptRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__unacceptRequest * SOAP_FMAC4 soap_get__ngwm__unacceptRequest(struct soap *soap, _ngwm__unacceptRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__unacceptRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__unacceptRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__unacceptRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__unacceptRequest * SOAP_FMAC4 soap_in__ngwm__unacceptRequest(struct soap *soap, const char *tag, _ngwm__unacceptRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__unacceptRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__unacceptRequest, sizeof(_ngwm__unacceptRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__unacceptRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__unacceptRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_items1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemRefList(soap, "ngwm:items", &(((_ngwm__unacceptRequest*)a)->items), "ngwt:ItemRefList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_items1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__unacceptRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__unacceptRequest, 0, sizeof(_ngwm__unacceptRequest), 0, soap_copy__ngwm__unacceptRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__unacceptRequest * SOAP_FMAC6 soap_new__ngwm__unacceptRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__unacceptRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__unacceptRequest(struct soap *soap, _ngwm__unacceptRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__unacceptRequest * SOAP_FMAC6 soap_instantiate__ngwm__unacceptRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__unacceptRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__unacceptRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__unacceptRequest;
		if (size)
			*size = sizeof(_ngwm__unacceptRequest);
		((_ngwm__unacceptRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__unacceptRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__unacceptRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__unacceptRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__unacceptRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__unacceptRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__unacceptRequest %p -> %p\n", q, p));
	*(_ngwm__unacceptRequest*)p = *(_ngwm__unacceptRequest*)q;
}

void _ngwm__startFreeBusySessionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__startFreeBusySessionResponse*)this)->freeBusySessionId, SOAP_TYPE_PointerToint);
	soap_serialize_PointerToint(soap, &((_ngwm__startFreeBusySessionResponse*)this)->freeBusySessionId);
	soap_embedded(soap, &((_ngwm__startFreeBusySessionResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__startFreeBusySessionResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__startFreeBusySessionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__startFreeBusySessionResponse*)this)->freeBusySessionId = NULL;
	((_ngwm__startFreeBusySessionResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__startFreeBusySessionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__startFreeBusySessionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__startFreeBusySessionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__startFreeBusySessionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__startFreeBusySessionResponse(struct soap *soap, const char *tag, int id, const _ngwm__startFreeBusySessionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__startFreeBusySessionResponse), type);
	soap_out_PointerToint(soap, "ngwm:freeBusySessionId", -1, &(((_ngwm__startFreeBusySessionResponse*)a)->freeBusySessionId), "");
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__startFreeBusySessionResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__startFreeBusySessionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__startFreeBusySessionResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__startFreeBusySessionResponse * SOAP_FMAC4 soap_get__ngwm__startFreeBusySessionResponse(struct soap *soap, _ngwm__startFreeBusySessionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__startFreeBusySessionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__startFreeBusySessionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__startFreeBusySessionResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__startFreeBusySessionResponse * SOAP_FMAC4 soap_in__ngwm__startFreeBusySessionResponse(struct soap *soap, const char *tag, _ngwm__startFreeBusySessionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__startFreeBusySessionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__startFreeBusySessionResponse, sizeof(_ngwm__startFreeBusySessionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__startFreeBusySessionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__startFreeBusySessionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_freeBusySessionId1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_freeBusySessionId1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ngwm:freeBusySessionId", &(((_ngwm__startFreeBusySessionResponse*)a)->freeBusySessionId), ""))
				{	soap_flag_freeBusySessionId1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__startFreeBusySessionResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__startFreeBusySessionResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__startFreeBusySessionResponse, 0, sizeof(_ngwm__startFreeBusySessionResponse), 0, soap_copy__ngwm__startFreeBusySessionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__startFreeBusySessionResponse * SOAP_FMAC6 soap_new__ngwm__startFreeBusySessionResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__startFreeBusySessionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__startFreeBusySessionResponse(struct soap *soap, _ngwm__startFreeBusySessionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__startFreeBusySessionResponse * SOAP_FMAC6 soap_instantiate__ngwm__startFreeBusySessionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__startFreeBusySessionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__startFreeBusySessionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__startFreeBusySessionResponse;
		if (size)
			*size = sizeof(_ngwm__startFreeBusySessionResponse);
		((_ngwm__startFreeBusySessionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__startFreeBusySessionResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__startFreeBusySessionResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__startFreeBusySessionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__startFreeBusySessionResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__startFreeBusySessionResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__startFreeBusySessionResponse %p -> %p\n", q, p));
	*(_ngwm__startFreeBusySessionResponse*)p = *(_ngwm__startFreeBusySessionResponse*)q;
}

void _ngwm__startFreeBusySessionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__startFreeBusySessionRequest*)this)->users, SOAP_TYPE_PointerTongwt__FreeBusyUserList);
	soap_serialize_PointerTongwt__FreeBusyUserList(soap, &((_ngwm__startFreeBusySessionRequest*)this)->users);
	soap_embedded(soap, &((_ngwm__startFreeBusySessionRequest*)this)->startDate, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwm__startFreeBusySessionRequest*)this)->startDate);
	soap_embedded(soap, &((_ngwm__startFreeBusySessionRequest*)this)->endDate, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwm__startFreeBusySessionRequest*)this)->endDate);
	/* transient soap skipped */
}

void _ngwm__startFreeBusySessionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__startFreeBusySessionRequest*)this)->users = NULL;
	soap_default_string(soap, &((_ngwm__startFreeBusySessionRequest*)this)->startDate);
	soap_default_string(soap, &((_ngwm__startFreeBusySessionRequest*)this)->endDate);
	/* transient soap skipped */
}

int _ngwm__startFreeBusySessionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__startFreeBusySessionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__startFreeBusySessionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__startFreeBusySessionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__startFreeBusySessionRequest(struct soap *soap, const char *tag, int id, const _ngwm__startFreeBusySessionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__startFreeBusySessionRequest), type);
	soap_out_PointerTongwt__FreeBusyUserList(soap, "ngwm:users", -1, &(((_ngwm__startFreeBusySessionRequest*)a)->users), "");
	soap_out_string(soap, "ngwm:startDate", -1, &(((_ngwm__startFreeBusySessionRequest*)a)->startDate), "");
	soap_out_string(soap, "ngwm:endDate", -1, &(((_ngwm__startFreeBusySessionRequest*)a)->endDate), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__startFreeBusySessionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__startFreeBusySessionRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__startFreeBusySessionRequest * SOAP_FMAC4 soap_get__ngwm__startFreeBusySessionRequest(struct soap *soap, _ngwm__startFreeBusySessionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__startFreeBusySessionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__startFreeBusySessionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__startFreeBusySessionRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__startFreeBusySessionRequest * SOAP_FMAC4 soap_in__ngwm__startFreeBusySessionRequest(struct soap *soap, const char *tag, _ngwm__startFreeBusySessionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__startFreeBusySessionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__startFreeBusySessionRequest, sizeof(_ngwm__startFreeBusySessionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__startFreeBusySessionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__startFreeBusySessionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_users1 = 1, soap_flag_startDate1 = 1, soap_flag_endDate1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_users1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__FreeBusyUserList(soap, "ngwm:users", &(((_ngwm__startFreeBusySessionRequest*)a)->users), "ngwt:FreeBusyUserList"))
				{	soap_flag_users1 = 0;
					continue;
				}
			if (soap_flag_startDate1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwm:startDate", &(((_ngwm__startFreeBusySessionRequest*)a)->startDate), ""))
				{	soap_flag_startDate1 = 0;
					continue;
				}
			if (soap_flag_endDate1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwm:endDate", &(((_ngwm__startFreeBusySessionRequest*)a)->endDate), ""))
				{	soap_flag_endDate1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_users1 || soap_flag_startDate1 || soap_flag_endDate1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__startFreeBusySessionRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__startFreeBusySessionRequest, 0, sizeof(_ngwm__startFreeBusySessionRequest), 0, soap_copy__ngwm__startFreeBusySessionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__startFreeBusySessionRequest * SOAP_FMAC6 soap_new__ngwm__startFreeBusySessionRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__startFreeBusySessionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__startFreeBusySessionRequest(struct soap *soap, _ngwm__startFreeBusySessionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__startFreeBusySessionRequest * SOAP_FMAC6 soap_instantiate__ngwm__startFreeBusySessionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__startFreeBusySessionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__startFreeBusySessionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__startFreeBusySessionRequest;
		if (size)
			*size = sizeof(_ngwm__startFreeBusySessionRequest);
		((_ngwm__startFreeBusySessionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__startFreeBusySessionRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__startFreeBusySessionRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__startFreeBusySessionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__startFreeBusySessionRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__startFreeBusySessionRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__startFreeBusySessionRequest %p -> %p\n", q, p));
	*(_ngwm__startFreeBusySessionRequest*)p = *(_ngwm__startFreeBusySessionRequest*)q;
}

void _ngwm__setTimestampResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__setTimestampResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__setTimestampResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__setTimestampResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__setTimestampResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__setTimestampResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__setTimestampResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__setTimestampResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__setTimestampResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__setTimestampResponse(struct soap *soap, const char *tag, int id, const _ngwm__setTimestampResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__setTimestampResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__setTimestampResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__setTimestampResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__setTimestampResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__setTimestampResponse * SOAP_FMAC4 soap_get__ngwm__setTimestampResponse(struct soap *soap, _ngwm__setTimestampResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__setTimestampResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__setTimestampResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__setTimestampResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__setTimestampResponse * SOAP_FMAC4 soap_in__ngwm__setTimestampResponse(struct soap *soap, const char *tag, _ngwm__setTimestampResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__setTimestampResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__setTimestampResponse, sizeof(_ngwm__setTimestampResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__setTimestampResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__setTimestampResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__setTimestampResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__setTimestampResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__setTimestampResponse, 0, sizeof(_ngwm__setTimestampResponse), 0, soap_copy__ngwm__setTimestampResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__setTimestampResponse * SOAP_FMAC6 soap_new__ngwm__setTimestampResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__setTimestampResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__setTimestampResponse(struct soap *soap, _ngwm__setTimestampResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__setTimestampResponse * SOAP_FMAC6 soap_instantiate__ngwm__setTimestampResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__setTimestampResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__setTimestampResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__setTimestampResponse;
		if (size)
			*size = sizeof(_ngwm__setTimestampResponse);
		((_ngwm__setTimestampResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__setTimestampResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__setTimestampResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__setTimestampResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__setTimestampResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__setTimestampResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__setTimestampResponse %p -> %p\n", q, p));
	*(_ngwm__setTimestampResponse*)p = *(_ngwm__setTimestampResponse*)q;
}

void _ngwm__setTimestampRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__setTimestampRequest*)this)->backup, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwm__setTimestampRequest*)this)->backup);
	soap_embedded(soap, &((_ngwm__setTimestampRequest*)this)->retention, SOAP_TYPE_string);
	soap_serialize_string(soap, &((_ngwm__setTimestampRequest*)this)->retention);
	/* transient soap skipped */
}

void _ngwm__setTimestampRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((_ngwm__setTimestampRequest*)this)->backup);
	soap_default_string(soap, &((_ngwm__setTimestampRequest*)this)->retention);
	/* transient soap skipped */
}

int _ngwm__setTimestampRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__setTimestampRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__setTimestampRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__setTimestampRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__setTimestampRequest(struct soap *soap, const char *tag, int id, const _ngwm__setTimestampRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__setTimestampRequest), type);
	soap_out_string(soap, "ngwm:backup", -1, &(((_ngwm__setTimestampRequest*)a)->backup), "");
	soap_out_string(soap, "ngwm:retention", -1, &(((_ngwm__setTimestampRequest*)a)->retention), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__setTimestampRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__setTimestampRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__setTimestampRequest * SOAP_FMAC4 soap_get__ngwm__setTimestampRequest(struct soap *soap, _ngwm__setTimestampRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__setTimestampRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__setTimestampRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__setTimestampRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__setTimestampRequest * SOAP_FMAC4 soap_in__ngwm__setTimestampRequest(struct soap *soap, const char *tag, _ngwm__setTimestampRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__setTimestampRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__setTimestampRequest, sizeof(_ngwm__setTimestampRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__setTimestampRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__setTimestampRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_backup1 = 1, soap_flag_retention1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_backup1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwm:backup", &(((_ngwm__setTimestampRequest*)a)->backup), ""))
				{	soap_flag_backup1 = 0;
					continue;
				}
			if (soap_flag_retention1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ngwm:retention", &(((_ngwm__setTimestampRequest*)a)->retention), ""))
				{	soap_flag_retention1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__setTimestampRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__setTimestampRequest, 0, sizeof(_ngwm__setTimestampRequest), 0, soap_copy__ngwm__setTimestampRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__setTimestampRequest * SOAP_FMAC6 soap_new__ngwm__setTimestampRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__setTimestampRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__setTimestampRequest(struct soap *soap, _ngwm__setTimestampRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__setTimestampRequest * SOAP_FMAC6 soap_instantiate__ngwm__setTimestampRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__setTimestampRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__setTimestampRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__setTimestampRequest;
		if (size)
			*size = sizeof(_ngwm__setTimestampRequest);
		((_ngwm__setTimestampRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__setTimestampRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__setTimestampRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__setTimestampRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__setTimestampRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__setTimestampRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__setTimestampRequest %p -> %p\n", q, p));
	*(_ngwm__setTimestampRequest*)p = *(_ngwm__setTimestampRequest*)q;
}

void _ngwm__sendItemResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfngwt__uid(soap, &((_ngwm__sendItemResponse*)this)->id);
	soap_embedded(soap, &((_ngwm__sendItemResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__sendItemResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__sendItemResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfngwt__uid(soap, &((_ngwm__sendItemResponse*)this)->id);
	((_ngwm__sendItemResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__sendItemResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__sendItemResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__sendItemResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__sendItemResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__sendItemResponse(struct soap *soap, const char *tag, int id, const _ngwm__sendItemResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__sendItemResponse), type);
	soap_out_std__vectorTemplateOfngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__sendItemResponse*)a)->id), "");
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__sendItemResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__sendItemResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__sendItemResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__sendItemResponse * SOAP_FMAC4 soap_get__ngwm__sendItemResponse(struct soap *soap, _ngwm__sendItemResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__sendItemResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__sendItemResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__sendItemResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__sendItemResponse * SOAP_FMAC4 soap_in__ngwm__sendItemResponse(struct soap *soap, const char *tag, _ngwm__sendItemResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__sendItemResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__sendItemResponse, sizeof(_ngwm__sendItemResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__sendItemResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__sendItemResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfngwt__uid(soap, "ngwm:id", &(((_ngwm__sendItemResponse*)a)->id), "ngwt:uid"))
					continue;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__sendItemResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__sendItemResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__sendItemResponse, 0, sizeof(_ngwm__sendItemResponse), 0, soap_copy__ngwm__sendItemResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__sendItemResponse * SOAP_FMAC6 soap_new__ngwm__sendItemResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__sendItemResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__sendItemResponse(struct soap *soap, _ngwm__sendItemResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__sendItemResponse * SOAP_FMAC6 soap_instantiate__ngwm__sendItemResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__sendItemResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__sendItemResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__sendItemResponse;
		if (size)
			*size = sizeof(_ngwm__sendItemResponse);
		((_ngwm__sendItemResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__sendItemResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__sendItemResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__sendItemResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__sendItemResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__sendItemResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__sendItemResponse %p -> %p\n", q, p));
	*(_ngwm__sendItemResponse*)p = *(_ngwm__sendItemResponse*)q;
}

void _ngwm__sendItemRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__sendItemRequest*)this)->item, SOAP_TYPE_PointerTongwt__Item);
	soap_serialize_PointerTongwt__Item(soap, &((_ngwm__sendItemRequest*)this)->item);
	/* transient soap skipped */
}

void _ngwm__sendItemRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__sendItemRequest*)this)->item = NULL;
	/* transient soap skipped */
}

int _ngwm__sendItemRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__sendItemRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__sendItemRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__sendItemRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__sendItemRequest(struct soap *soap, const char *tag, int id, const _ngwm__sendItemRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__sendItemRequest), type);
	soap_out_PointerTongwt__Item(soap, "ngwm:item", -1, &(((_ngwm__sendItemRequest*)a)->item), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__sendItemRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__sendItemRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__sendItemRequest * SOAP_FMAC4 soap_get__ngwm__sendItemRequest(struct soap *soap, _ngwm__sendItemRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__sendItemRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__sendItemRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__sendItemRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__sendItemRequest * SOAP_FMAC4 soap_in__ngwm__sendItemRequest(struct soap *soap, const char *tag, _ngwm__sendItemRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__sendItemRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__sendItemRequest, sizeof(_ngwm__sendItemRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__sendItemRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__sendItemRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_item1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_item1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Item(soap, "ngwm:item", &(((_ngwm__sendItemRequest*)a)->item), "ngwt:Item"))
				{	soap_flag_item1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_item1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__sendItemRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__sendItemRequest, 0, sizeof(_ngwm__sendItemRequest), 0, soap_copy__ngwm__sendItemRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__sendItemRequest * SOAP_FMAC6 soap_new__ngwm__sendItemRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__sendItemRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__sendItemRequest(struct soap *soap, _ngwm__sendItemRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__sendItemRequest * SOAP_FMAC6 soap_instantiate__ngwm__sendItemRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__sendItemRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__sendItemRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__sendItemRequest;
		if (size)
			*size = sizeof(_ngwm__sendItemRequest);
		((_ngwm__sendItemRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__sendItemRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__sendItemRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__sendItemRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__sendItemRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__sendItemRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__sendItemRequest %p -> %p\n", q, p));
	*(_ngwm__sendItemRequest*)p = *(_ngwm__sendItemRequest*)q;
}

void _ngwm__retractResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__retractResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__retractResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__retractResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__retractResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__retractResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__retractResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__retractResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__retractResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__retractResponse(struct soap *soap, const char *tag, int id, const _ngwm__retractResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__retractResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__retractResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__retractResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__retractResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__retractResponse * SOAP_FMAC4 soap_get__ngwm__retractResponse(struct soap *soap, _ngwm__retractResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__retractResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__retractResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__retractResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__retractResponse * SOAP_FMAC4 soap_in__ngwm__retractResponse(struct soap *soap, const char *tag, _ngwm__retractResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__retractResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__retractResponse, sizeof(_ngwm__retractResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__retractResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__retractResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__retractResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__retractResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__retractResponse, 0, sizeof(_ngwm__retractResponse), 0, soap_copy__ngwm__retractResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__retractResponse * SOAP_FMAC6 soap_new__ngwm__retractResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__retractResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__retractResponse(struct soap *soap, _ngwm__retractResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__retractResponse * SOAP_FMAC6 soap_instantiate__ngwm__retractResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__retractResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__retractResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__retractResponse;
		if (size)
			*size = sizeof(_ngwm__retractResponse);
		((_ngwm__retractResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__retractResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__retractResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__retractResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__retractResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__retractResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__retractResponse %p -> %p\n", q, p));
	*(_ngwm__retractResponse*)p = *(_ngwm__retractResponse*)q;
}

void _ngwm__retractRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__retractRequest*)this)->items, SOAP_TYPE_PointerTongwt__ItemRefList);
	soap_serialize_PointerTongwt__ItemRefList(soap, &((_ngwm__retractRequest*)this)->items);
	soap_embedded(soap, &((_ngwm__retractRequest*)this)->comment, SOAP_TYPE_PointerTostd__string);
	soap_serialize_PointerTostd__string(soap, &((_ngwm__retractRequest*)this)->comment);
	soap_embedded(soap, &((_ngwm__retractRequest*)this)->retractingAllInstances, SOAP_TYPE_bool);
	soap_embedded(soap, &((_ngwm__retractRequest*)this)->retractCausedByResend, SOAP_TYPE_bool);
	soap_embedded(soap, &((_ngwm__retractRequest*)this)->retractType, SOAP_TYPE_PointerTongwt__RetractType);
	soap_serialize_PointerTongwt__RetractType(soap, &((_ngwm__retractRequest*)this)->retractType);
	/* transient soap skipped */
}

void _ngwm__retractRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__retractRequest*)this)->items = NULL;
	((_ngwm__retractRequest*)this)->comment = NULL;
	((_ngwm__retractRequest*)this)->retractingAllInstances = (bool)0;
	((_ngwm__retractRequest*)this)->retractCausedByResend = (bool)0;
	((_ngwm__retractRequest*)this)->retractType = NULL;
	/* transient soap skipped */
}

int _ngwm__retractRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__retractRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__retractRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__retractRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__retractRequest(struct soap *soap, const char *tag, int id, const _ngwm__retractRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__retractRequest), type);
	soap_out_PointerTongwt__ItemRefList(soap, "ngwm:items", -1, &(((_ngwm__retractRequest*)a)->items), "");
	soap_out_PointerTostd__string(soap, "ngwm:comment", -1, &(((_ngwm__retractRequest*)a)->comment), "");
	soap_out_bool(soap, "ngwm:retractingAllInstances", -1, &(((_ngwm__retractRequest*)a)->retractingAllInstances), "");
	soap_out_bool(soap, "ngwm:retractCausedByResend", -1, &(((_ngwm__retractRequest*)a)->retractCausedByResend), "");
	soap_out_PointerTongwt__RetractType(soap, "ngwm:retractType", -1, &(((_ngwm__retractRequest*)a)->retractType), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__retractRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__retractRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__retractRequest * SOAP_FMAC4 soap_get__ngwm__retractRequest(struct soap *soap, _ngwm__retractRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__retractRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__retractRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__retractRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__retractRequest * SOAP_FMAC4 soap_in__ngwm__retractRequest(struct soap *soap, const char *tag, _ngwm__retractRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__retractRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__retractRequest, sizeof(_ngwm__retractRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__retractRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__retractRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_items1 = 1, soap_flag_comment1 = 1, soap_flag_retractingAllInstances1 = 1, soap_flag_retractCausedByResend1 = 1, soap_flag_retractType1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemRefList(soap, "ngwm:items", &(((_ngwm__retractRequest*)a)->items), "ngwt:ItemRefList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			if (soap_flag_comment1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ngwm:comment", &(((_ngwm__retractRequest*)a)->comment), ""))
				{	soap_flag_comment1 = 0;
					continue;
				}
			if (soap_flag_retractingAllInstances1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:retractingAllInstances", &(((_ngwm__retractRequest*)a)->retractingAllInstances), ""))
				{	soap_flag_retractingAllInstances1 = 0;
					continue;
				}
			if (soap_flag_retractCausedByResend1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:retractCausedByResend", &(((_ngwm__retractRequest*)a)->retractCausedByResend), ""))
				{	soap_flag_retractCausedByResend1 = 0;
					continue;
				}
			if (soap_flag_retractType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__RetractType(soap, "ngwm:retractType", &(((_ngwm__retractRequest*)a)->retractType), ""))
				{	soap_flag_retractType1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_items1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__retractRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__retractRequest, 0, sizeof(_ngwm__retractRequest), 0, soap_copy__ngwm__retractRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__retractRequest * SOAP_FMAC6 soap_new__ngwm__retractRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__retractRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__retractRequest(struct soap *soap, _ngwm__retractRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__retractRequest * SOAP_FMAC6 soap_instantiate__ngwm__retractRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__retractRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__retractRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__retractRequest;
		if (size)
			*size = sizeof(_ngwm__retractRequest);
		((_ngwm__retractRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__retractRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__retractRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__retractRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__retractRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__retractRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__retractRequest %p -> %p\n", q, p));
	*(_ngwm__retractRequest*)p = *(_ngwm__retractRequest*)q;
}

void _ngwm__replyResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__replyResponse*)this)->item, SOAP_TYPE_PointerTongwt__Item);
	soap_serialize_PointerTongwt__Item(soap, &((_ngwm__replyResponse*)this)->item);
	soap_embedded(soap, &((_ngwm__replyResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__replyResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__replyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__replyResponse*)this)->item = NULL;
	((_ngwm__replyResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__replyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__replyResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__replyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__replyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__replyResponse(struct soap *soap, const char *tag, int id, const _ngwm__replyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__replyResponse), type);
	soap_out_PointerTongwt__Item(soap, "ngwm:item", -1, &(((_ngwm__replyResponse*)a)->item), "");
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__replyResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__replyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__replyResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__replyResponse * SOAP_FMAC4 soap_get__ngwm__replyResponse(struct soap *soap, _ngwm__replyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__replyResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__replyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__replyResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__replyResponse * SOAP_FMAC4 soap_in__ngwm__replyResponse(struct soap *soap, const char *tag, _ngwm__replyResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__replyResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__replyResponse, sizeof(_ngwm__replyResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__replyResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__replyResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_item1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_item1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Item(soap, "ngwm:item", &(((_ngwm__replyResponse*)a)->item), "ngwt:Item"))
				{	soap_flag_item1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__replyResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__replyResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__replyResponse, 0, sizeof(_ngwm__replyResponse), 0, soap_copy__ngwm__replyResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__replyResponse * SOAP_FMAC6 soap_new__ngwm__replyResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__replyResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__replyResponse(struct soap *soap, _ngwm__replyResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__replyResponse * SOAP_FMAC6 soap_instantiate__ngwm__replyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__replyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__replyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__replyResponse;
		if (size)
			*size = sizeof(_ngwm__replyResponse);
		((_ngwm__replyResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__replyResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__replyResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__replyResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__replyResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__replyResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__replyResponse %p -> %p\n", q, p));
	*(_ngwm__replyResponse*)p = *(_ngwm__replyResponse*)q;
}

void _ngwm__replyRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__replyRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__replyRequest*)this)->id);
	soap_embedded(soap, &((_ngwm__replyRequest*)this)->view, SOAP_TYPE_PointerTongwt__View);
	soap_serialize_PointerTongwt__View(soap, &((_ngwm__replyRequest*)this)->view);
	/* transient soap skipped */
}

void _ngwm__replyRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__replyRequest*)this)->id);
	((_ngwm__replyRequest*)this)->view = NULL;
	/* transient soap skipped */
}

int _ngwm__replyRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__replyRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__replyRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__replyRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__replyRequest(struct soap *soap, const char *tag, int id, const _ngwm__replyRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__replyRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__replyRequest*)a)->id), "");
	soap_out_PointerTongwt__View(soap, "ngwm:view", -1, &(((_ngwm__replyRequest*)a)->view), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__replyRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__replyRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__replyRequest * SOAP_FMAC4 soap_get__ngwm__replyRequest(struct soap *soap, _ngwm__replyRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__replyRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__replyRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__replyRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__replyRequest * SOAP_FMAC4 soap_in__ngwm__replyRequest(struct soap *soap, const char *tag, _ngwm__replyRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__replyRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__replyRequest, sizeof(_ngwm__replyRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__replyRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__replyRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_view1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__replyRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			if (soap_flag_view1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__View(soap, "ngwm:view", &(((_ngwm__replyRequest*)a)->view), "ngwt:View"))
				{	soap_flag_view1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__replyRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__replyRequest, 0, sizeof(_ngwm__replyRequest), 0, soap_copy__ngwm__replyRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__replyRequest * SOAP_FMAC6 soap_new__ngwm__replyRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__replyRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__replyRequest(struct soap *soap, _ngwm__replyRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__replyRequest * SOAP_FMAC6 soap_instantiate__ngwm__replyRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__replyRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__replyRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__replyRequest;
		if (size)
			*size = sizeof(_ngwm__replyRequest);
		((_ngwm__replyRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__replyRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__replyRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__replyRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__replyRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__replyRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__replyRequest %p -> %p\n", q, p));
	*(_ngwm__replyRequest*)p = *(_ngwm__replyRequest*)q;
}

void _ngwm__removeSignatureResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeSignatureResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeSignatureResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeSignatureResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeSignatureResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeSignatureResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeSignatureResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeSignatureResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeSignatureResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeSignatureResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeSignatureResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeSignatureResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeSignatureResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeSignatureResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeSignatureResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeSignatureResponse * SOAP_FMAC4 soap_get__ngwm__removeSignatureResponse(struct soap *soap, _ngwm__removeSignatureResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeSignatureResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeSignatureResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeSignatureResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeSignatureResponse * SOAP_FMAC4 soap_in__ngwm__removeSignatureResponse(struct soap *soap, const char *tag, _ngwm__removeSignatureResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeSignatureResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeSignatureResponse, sizeof(_ngwm__removeSignatureResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeSignatureResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeSignatureResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeSignatureResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeSignatureResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeSignatureResponse, 0, sizeof(_ngwm__removeSignatureResponse), 0, soap_copy__ngwm__removeSignatureResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeSignatureResponse * SOAP_FMAC6 soap_new__ngwm__removeSignatureResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeSignatureResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeSignatureResponse(struct soap *soap, _ngwm__removeSignatureResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeSignatureResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeSignatureResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeSignatureResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeSignatureResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeSignatureResponse;
		if (size)
			*size = sizeof(_ngwm__removeSignatureResponse);
		((_ngwm__removeSignatureResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeSignatureResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeSignatureResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeSignatureResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeSignatureResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeSignatureResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeSignatureResponse %p -> %p\n", q, p));
	*(_ngwm__removeSignatureResponse*)p = *(_ngwm__removeSignatureResponse*)q;
}

void _ngwm__removeSignatureRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeSignatureRequest*)this)->id, SOAP_TYPE_PointerTongwt__uid);
	soap_serialize_PointerTongwt__uid(soap, &((_ngwm__removeSignatureRequest*)this)->id);
	soap_embedded(soap, &((_ngwm__removeSignatureRequest*)this)->all, SOAP_TYPE_PointerTobool);
	soap_serialize_PointerTobool(soap, &((_ngwm__removeSignatureRequest*)this)->all);
	soap_embedded(soap, &((_ngwm__removeSignatureRequest*)this)->global, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void _ngwm__removeSignatureRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeSignatureRequest*)this)->id = NULL;
	((_ngwm__removeSignatureRequest*)this)->all = NULL;
	((_ngwm__removeSignatureRequest*)this)->global = (bool)0;
	/* transient soap skipped */
}

int _ngwm__removeSignatureRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeSignatureRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeSignatureRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeSignatureRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeSignatureRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeSignatureRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeSignatureRequest), type);
	soap_out_PointerTongwt__uid(soap, "ngwm:id", -1, &(((_ngwm__removeSignatureRequest*)a)->id), "");
	soap_out_PointerTobool(soap, "ngwm:all", -1, &(((_ngwm__removeSignatureRequest*)a)->all), "");
	soap_out_bool(soap, "ngwm:global", -1, &(((_ngwm__removeSignatureRequest*)a)->global), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeSignatureRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeSignatureRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeSignatureRequest * SOAP_FMAC4 soap_get__ngwm__removeSignatureRequest(struct soap *soap, _ngwm__removeSignatureRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeSignatureRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeSignatureRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeSignatureRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeSignatureRequest * SOAP_FMAC4 soap_in__ngwm__removeSignatureRequest(struct soap *soap, const char *tag, _ngwm__removeSignatureRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeSignatureRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeSignatureRequest, sizeof(_ngwm__removeSignatureRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeSignatureRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeSignatureRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1, soap_flag_all1 = 1, soap_flag_global1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__uid(soap, "ngwm:id", &(((_ngwm__removeSignatureRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			if (soap_flag_all1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "ngwm:all", &(((_ngwm__removeSignatureRequest*)a)->all), ""))
				{	soap_flag_all1 = 0;
					continue;
				}
			if (soap_flag_global1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:global", &(((_ngwm__removeSignatureRequest*)a)->global), ""))
				{	soap_flag_global1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeSignatureRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeSignatureRequest, 0, sizeof(_ngwm__removeSignatureRequest), 0, soap_copy__ngwm__removeSignatureRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeSignatureRequest * SOAP_FMAC6 soap_new__ngwm__removeSignatureRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeSignatureRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeSignatureRequest(struct soap *soap, _ngwm__removeSignatureRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeSignatureRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeSignatureRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeSignatureRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeSignatureRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeSignatureRequest;
		if (size)
			*size = sizeof(_ngwm__removeSignatureRequest);
		((_ngwm__removeSignatureRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeSignatureRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeSignatureRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeSignatureRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeSignatureRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeSignatureRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeSignatureRequest %p -> %p\n", q, p));
	*(_ngwm__removeSignatureRequest*)p = *(_ngwm__removeSignatureRequest*)q;
}

void _ngwm__removeProxyUserResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeProxyUserResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeProxyUserResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeProxyUserResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeProxyUserResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeProxyUserResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeProxyUserResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeProxyUserResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeProxyUserResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeProxyUserResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeProxyUserResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeProxyUserResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeProxyUserResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeProxyUserResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeProxyUserResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeProxyUserResponse * SOAP_FMAC4 soap_get__ngwm__removeProxyUserResponse(struct soap *soap, _ngwm__removeProxyUserResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeProxyUserResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeProxyUserResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeProxyUserResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeProxyUserResponse * SOAP_FMAC4 soap_in__ngwm__removeProxyUserResponse(struct soap *soap, const char *tag, _ngwm__removeProxyUserResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeProxyUserResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeProxyUserResponse, sizeof(_ngwm__removeProxyUserResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeProxyUserResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeProxyUserResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeProxyUserResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeProxyUserResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeProxyUserResponse, 0, sizeof(_ngwm__removeProxyUserResponse), 0, soap_copy__ngwm__removeProxyUserResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeProxyUserResponse * SOAP_FMAC6 soap_new__ngwm__removeProxyUserResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeProxyUserResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeProxyUserResponse(struct soap *soap, _ngwm__removeProxyUserResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeProxyUserResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeProxyUserResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeProxyUserResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeProxyUserResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeProxyUserResponse;
		if (size)
			*size = sizeof(_ngwm__removeProxyUserResponse);
		((_ngwm__removeProxyUserResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeProxyUserResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeProxyUserResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeProxyUserResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeProxyUserResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeProxyUserResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeProxyUserResponse %p -> %p\n", q, p));
	*(_ngwm__removeProxyUserResponse*)p = *(_ngwm__removeProxyUserResponse*)q;
}

void _ngwm__removeProxyUserRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeProxyUserRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeProxyUserRequest*)this)->id);
	/* transient soap skipped */
}

void _ngwm__removeProxyUserRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__removeProxyUserRequest*)this)->id);
	/* transient soap skipped */
}

int _ngwm__removeProxyUserRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeProxyUserRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeProxyUserRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeProxyUserRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeProxyUserRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeProxyUserRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeProxyUserRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__removeProxyUserRequest*)a)->id), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeProxyUserRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeProxyUserRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeProxyUserRequest * SOAP_FMAC4 soap_get__ngwm__removeProxyUserRequest(struct soap *soap, _ngwm__removeProxyUserRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeProxyUserRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeProxyUserRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeProxyUserRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeProxyUserRequest * SOAP_FMAC4 soap_in__ngwm__removeProxyUserRequest(struct soap *soap, const char *tag, _ngwm__removeProxyUserRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeProxyUserRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeProxyUserRequest, sizeof(_ngwm__removeProxyUserRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeProxyUserRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeProxyUserRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__removeProxyUserRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeProxyUserRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeProxyUserRequest, 0, sizeof(_ngwm__removeProxyUserRequest), 0, soap_copy__ngwm__removeProxyUserRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeProxyUserRequest * SOAP_FMAC6 soap_new__ngwm__removeProxyUserRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeProxyUserRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeProxyUserRequest(struct soap *soap, _ngwm__removeProxyUserRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeProxyUserRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeProxyUserRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeProxyUserRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeProxyUserRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeProxyUserRequest;
		if (size)
			*size = sizeof(_ngwm__removeProxyUserRequest);
		((_ngwm__removeProxyUserRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeProxyUserRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeProxyUserRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeProxyUserRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeProxyUserRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeProxyUserRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeProxyUserRequest %p -> %p\n", q, p));
	*(_ngwm__removeProxyUserRequest*)p = *(_ngwm__removeProxyUserRequest*)q;
}

void _ngwm__removeProxyAccessResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeProxyAccessResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeProxyAccessResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeProxyAccessResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeProxyAccessResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeProxyAccessResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeProxyAccessResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeProxyAccessResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeProxyAccessResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeProxyAccessResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeProxyAccessResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeProxyAccessResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeProxyAccessResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeProxyAccessResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeProxyAccessResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeProxyAccessResponse * SOAP_FMAC4 soap_get__ngwm__removeProxyAccessResponse(struct soap *soap, _ngwm__removeProxyAccessResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeProxyAccessResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeProxyAccessResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeProxyAccessResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeProxyAccessResponse * SOAP_FMAC4 soap_in__ngwm__removeProxyAccessResponse(struct soap *soap, const char *tag, _ngwm__removeProxyAccessResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeProxyAccessResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeProxyAccessResponse, sizeof(_ngwm__removeProxyAccessResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeProxyAccessResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeProxyAccessResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeProxyAccessResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeProxyAccessResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeProxyAccessResponse, 0, sizeof(_ngwm__removeProxyAccessResponse), 0, soap_copy__ngwm__removeProxyAccessResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeProxyAccessResponse * SOAP_FMAC6 soap_new__ngwm__removeProxyAccessResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeProxyAccessResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeProxyAccessResponse(struct soap *soap, _ngwm__removeProxyAccessResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeProxyAccessResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeProxyAccessResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeProxyAccessResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeProxyAccessResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeProxyAccessResponse;
		if (size)
			*size = sizeof(_ngwm__removeProxyAccessResponse);
		((_ngwm__removeProxyAccessResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeProxyAccessResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeProxyAccessResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeProxyAccessResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeProxyAccessResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeProxyAccessResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeProxyAccessResponse %p -> %p\n", q, p));
	*(_ngwm__removeProxyAccessResponse*)p = *(_ngwm__removeProxyAccessResponse*)q;
}

void _ngwm__removeProxyAccessRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeProxyAccessRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeProxyAccessRequest*)this)->id);
	/* transient soap skipped */
}

void _ngwm__removeProxyAccessRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__removeProxyAccessRequest*)this)->id);
	/* transient soap skipped */
}

int _ngwm__removeProxyAccessRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeProxyAccessRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeProxyAccessRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeProxyAccessRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeProxyAccessRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeProxyAccessRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeProxyAccessRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__removeProxyAccessRequest*)a)->id), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeProxyAccessRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeProxyAccessRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeProxyAccessRequest * SOAP_FMAC4 soap_get__ngwm__removeProxyAccessRequest(struct soap *soap, _ngwm__removeProxyAccessRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeProxyAccessRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeProxyAccessRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeProxyAccessRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeProxyAccessRequest * SOAP_FMAC4 soap_in__ngwm__removeProxyAccessRequest(struct soap *soap, const char *tag, _ngwm__removeProxyAccessRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeProxyAccessRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeProxyAccessRequest, sizeof(_ngwm__removeProxyAccessRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeProxyAccessRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeProxyAccessRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__removeProxyAccessRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeProxyAccessRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeProxyAccessRequest, 0, sizeof(_ngwm__removeProxyAccessRequest), 0, soap_copy__ngwm__removeProxyAccessRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeProxyAccessRequest * SOAP_FMAC6 soap_new__ngwm__removeProxyAccessRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeProxyAccessRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeProxyAccessRequest(struct soap *soap, _ngwm__removeProxyAccessRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeProxyAccessRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeProxyAccessRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeProxyAccessRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeProxyAccessRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeProxyAccessRequest;
		if (size)
			*size = sizeof(_ngwm__removeProxyAccessRequest);
		((_ngwm__removeProxyAccessRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeProxyAccessRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeProxyAccessRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeProxyAccessRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeProxyAccessRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeProxyAccessRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeProxyAccessRequest %p -> %p\n", q, p));
	*(_ngwm__removeProxyAccessRequest*)p = *(_ngwm__removeProxyAccessRequest*)q;
}

void _ngwm__removeMembersResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeMembersResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeMembersResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeMembersResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeMembersResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeMembersResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeMembersResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeMembersResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeMembersResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeMembersResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeMembersResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeMembersResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeMembersResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeMembersResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeMembersResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeMembersResponse * SOAP_FMAC4 soap_get__ngwm__removeMembersResponse(struct soap *soap, _ngwm__removeMembersResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeMembersResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeMembersResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeMembersResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeMembersResponse * SOAP_FMAC4 soap_in__ngwm__removeMembersResponse(struct soap *soap, const char *tag, _ngwm__removeMembersResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeMembersResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeMembersResponse, sizeof(_ngwm__removeMembersResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeMembersResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeMembersResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeMembersResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeMembersResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeMembersResponse, 0, sizeof(_ngwm__removeMembersResponse), 0, soap_copy__ngwm__removeMembersResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeMembersResponse * SOAP_FMAC6 soap_new__ngwm__removeMembersResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeMembersResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeMembersResponse(struct soap *soap, _ngwm__removeMembersResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeMembersResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeMembersResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeMembersResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeMembersResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeMembersResponse;
		if (size)
			*size = sizeof(_ngwm__removeMembersResponse);
		((_ngwm__removeMembersResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeMembersResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeMembersResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeMembersResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeMembersResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeMembersResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeMembersResponse %p -> %p\n", q, p));
	*(_ngwm__removeMembersResponse*)p = *(_ngwm__removeMembersResponse*)q;
}

void _ngwm__removeMembersRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeMembersRequest*)this)->container, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeMembersRequest*)this)->container);
	soap_embedded(soap, &((_ngwm__removeMembersRequest*)this)->members, SOAP_TYPE_PointerTongwt__GroupMemberList);
	soap_serialize_PointerTongwt__GroupMemberList(soap, &((_ngwm__removeMembersRequest*)this)->members);
	/* transient soap skipped */
}

void _ngwm__removeMembersRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__removeMembersRequest*)this)->container);
	((_ngwm__removeMembersRequest*)this)->members = NULL;
	/* transient soap skipped */
}

int _ngwm__removeMembersRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeMembersRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeMembersRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeMembersRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeMembersRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeMembersRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeMembersRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:container", -1, &(((_ngwm__removeMembersRequest*)a)->container), "");
	soap_out_PointerTongwt__GroupMemberList(soap, "ngwm:members", -1, &(((_ngwm__removeMembersRequest*)a)->members), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeMembersRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeMembersRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeMembersRequest * SOAP_FMAC4 soap_get__ngwm__removeMembersRequest(struct soap *soap, _ngwm__removeMembersRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeMembersRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeMembersRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeMembersRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeMembersRequest * SOAP_FMAC4 soap_in__ngwm__removeMembersRequest(struct soap *soap, const char *tag, _ngwm__removeMembersRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeMembersRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeMembersRequest, sizeof(_ngwm__removeMembersRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeMembersRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeMembersRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_container1 = 1, soap_flag_members1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_container1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:container", &(((_ngwm__removeMembersRequest*)a)->container), "ngwt:uid"))
				{	soap_flag_container1 = 0;
					continue;
				}
			if (soap_flag_members1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__GroupMemberList(soap, "ngwm:members", &(((_ngwm__removeMembersRequest*)a)->members), "ngwt:GroupMemberList"))
				{	soap_flag_members1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_container1 || soap_flag_members1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeMembersRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeMembersRequest, 0, sizeof(_ngwm__removeMembersRequest), 0, soap_copy__ngwm__removeMembersRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeMembersRequest * SOAP_FMAC6 soap_new__ngwm__removeMembersRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeMembersRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeMembersRequest(struct soap *soap, _ngwm__removeMembersRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeMembersRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeMembersRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeMembersRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeMembersRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeMembersRequest;
		if (size)
			*size = sizeof(_ngwm__removeMembersRequest);
		((_ngwm__removeMembersRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeMembersRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeMembersRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeMembersRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeMembersRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeMembersRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeMembersRequest %p -> %p\n", q, p));
	*(_ngwm__removeMembersRequest*)p = *(_ngwm__removeMembersRequest*)q;
}

void _ngwm__removeJunkEntryResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeJunkEntryResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeJunkEntryResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeJunkEntryResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeJunkEntryResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeJunkEntryResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeJunkEntryResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeJunkEntryResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeJunkEntryResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeJunkEntryResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeJunkEntryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeJunkEntryResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeJunkEntryResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeJunkEntryResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeJunkEntryResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeJunkEntryResponse * SOAP_FMAC4 soap_get__ngwm__removeJunkEntryResponse(struct soap *soap, _ngwm__removeJunkEntryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeJunkEntryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeJunkEntryResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeJunkEntryResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeJunkEntryResponse * SOAP_FMAC4 soap_in__ngwm__removeJunkEntryResponse(struct soap *soap, const char *tag, _ngwm__removeJunkEntryResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeJunkEntryResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeJunkEntryResponse, sizeof(_ngwm__removeJunkEntryResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeJunkEntryResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeJunkEntryResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeJunkEntryResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeJunkEntryResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeJunkEntryResponse, 0, sizeof(_ngwm__removeJunkEntryResponse), 0, soap_copy__ngwm__removeJunkEntryResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeJunkEntryResponse * SOAP_FMAC6 soap_new__ngwm__removeJunkEntryResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeJunkEntryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeJunkEntryResponse(struct soap *soap, _ngwm__removeJunkEntryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeJunkEntryResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeJunkEntryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeJunkEntryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeJunkEntryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeJunkEntryResponse;
		if (size)
			*size = sizeof(_ngwm__removeJunkEntryResponse);
		((_ngwm__removeJunkEntryResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeJunkEntryResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeJunkEntryResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeJunkEntryResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeJunkEntryResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeJunkEntryResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeJunkEntryResponse %p -> %p\n", q, p));
	*(_ngwm__removeJunkEntryResponse*)p = *(_ngwm__removeJunkEntryResponse*)q;
}

void _ngwm__removeJunkEntryRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeJunkEntryRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeJunkEntryRequest*)this)->id);
	/* transient soap skipped */
}

void _ngwm__removeJunkEntryRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__removeJunkEntryRequest*)this)->id);
	/* transient soap skipped */
}

int _ngwm__removeJunkEntryRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeJunkEntryRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeJunkEntryRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeJunkEntryRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeJunkEntryRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeJunkEntryRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeJunkEntryRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__removeJunkEntryRequest*)a)->id), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeJunkEntryRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeJunkEntryRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeJunkEntryRequest * SOAP_FMAC4 soap_get__ngwm__removeJunkEntryRequest(struct soap *soap, _ngwm__removeJunkEntryRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeJunkEntryRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeJunkEntryRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeJunkEntryRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeJunkEntryRequest * SOAP_FMAC4 soap_in__ngwm__removeJunkEntryRequest(struct soap *soap, const char *tag, _ngwm__removeJunkEntryRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeJunkEntryRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeJunkEntryRequest, sizeof(_ngwm__removeJunkEntryRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeJunkEntryRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeJunkEntryRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_id1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__removeJunkEntryRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeJunkEntryRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeJunkEntryRequest, 0, sizeof(_ngwm__removeJunkEntryRequest), 0, soap_copy__ngwm__removeJunkEntryRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeJunkEntryRequest * SOAP_FMAC6 soap_new__ngwm__removeJunkEntryRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeJunkEntryRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeJunkEntryRequest(struct soap *soap, _ngwm__removeJunkEntryRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeJunkEntryRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeJunkEntryRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeJunkEntryRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeJunkEntryRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeJunkEntryRequest;
		if (size)
			*size = sizeof(_ngwm__removeJunkEntryRequest);
		((_ngwm__removeJunkEntryRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeJunkEntryRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeJunkEntryRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeJunkEntryRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeJunkEntryRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeJunkEntryRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeJunkEntryRequest %p -> %p\n", q, p));
	*(_ngwm__removeJunkEntryRequest*)p = *(_ngwm__removeJunkEntryRequest*)q;
}

void _ngwm__removeItemsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeItemsResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeItemsResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeItemsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeItemsResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeItemsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeItemsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeItemsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeItemsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeItemsResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeItemsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeItemsResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeItemsResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeItemsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeItemsResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeItemsResponse * SOAP_FMAC4 soap_get__ngwm__removeItemsResponse(struct soap *soap, _ngwm__removeItemsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeItemsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeItemsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeItemsResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeItemsResponse * SOAP_FMAC4 soap_in__ngwm__removeItemsResponse(struct soap *soap, const char *tag, _ngwm__removeItemsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeItemsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeItemsResponse, sizeof(_ngwm__removeItemsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeItemsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeItemsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeItemsResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeItemsResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeItemsResponse, 0, sizeof(_ngwm__removeItemsResponse), 0, soap_copy__ngwm__removeItemsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeItemsResponse * SOAP_FMAC6 soap_new__ngwm__removeItemsResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeItemsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeItemsResponse(struct soap *soap, _ngwm__removeItemsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeItemsResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeItemsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeItemsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeItemsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeItemsResponse;
		if (size)
			*size = sizeof(_ngwm__removeItemsResponse);
		((_ngwm__removeItemsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeItemsResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeItemsResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeItemsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeItemsResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeItemsResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeItemsResponse %p -> %p\n", q, p));
	*(_ngwm__removeItemsResponse*)p = *(_ngwm__removeItemsResponse*)q;
}

void _ngwm__removeItemsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeItemsRequest*)this)->container, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeItemsRequest*)this)->container);
	soap_embedded(soap, &((_ngwm__removeItemsRequest*)this)->items, SOAP_TYPE_PointerTongwt__ItemRefList);
	soap_serialize_PointerTongwt__ItemRefList(soap, &((_ngwm__removeItemsRequest*)this)->items);
	/* transient soap skipped */
}

void _ngwm__removeItemsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__removeItemsRequest*)this)->container);
	((_ngwm__removeItemsRequest*)this)->items = NULL;
	/* transient soap skipped */
}

int _ngwm__removeItemsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeItemsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeItemsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeItemsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeItemsRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeItemsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeItemsRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:container", -1, &(((_ngwm__removeItemsRequest*)a)->container), "");
	soap_out_PointerTongwt__ItemRefList(soap, "ngwm:items", -1, &(((_ngwm__removeItemsRequest*)a)->items), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeItemsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeItemsRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeItemsRequest * SOAP_FMAC4 soap_get__ngwm__removeItemsRequest(struct soap *soap, _ngwm__removeItemsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeItemsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeItemsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeItemsRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeItemsRequest * SOAP_FMAC4 soap_in__ngwm__removeItemsRequest(struct soap *soap, const char *tag, _ngwm__removeItemsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeItemsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeItemsRequest, sizeof(_ngwm__removeItemsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeItemsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeItemsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_container1 = 1, soap_flag_items1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_container1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:container", &(((_ngwm__removeItemsRequest*)a)->container), "ngwt:uid"))
				{	soap_flag_container1 = 0;
					continue;
				}
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemRefList(soap, "ngwm:items", &(((_ngwm__removeItemsRequest*)a)->items), "ngwt:ItemRefList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_container1 || soap_flag_items1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeItemsRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeItemsRequest, 0, sizeof(_ngwm__removeItemsRequest), 0, soap_copy__ngwm__removeItemsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeItemsRequest * SOAP_FMAC6 soap_new__ngwm__removeItemsRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeItemsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeItemsRequest(struct soap *soap, _ngwm__removeItemsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeItemsRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeItemsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeItemsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeItemsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeItemsRequest;
		if (size)
			*size = sizeof(_ngwm__removeItemsRequest);
		((_ngwm__removeItemsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeItemsRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeItemsRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeItemsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeItemsRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeItemsRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeItemsRequest %p -> %p\n", q, p));
	*(_ngwm__removeItemsRequest*)p = *(_ngwm__removeItemsRequest*)q;
}

void _ngwm__removeItemResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeItemResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeItemResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeItemResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeItemResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeItemResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeItemResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeItemResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeItemResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeItemResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeItemResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeItemResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeItemResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeItemResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeItemResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeItemResponse * SOAP_FMAC4 soap_get__ngwm__removeItemResponse(struct soap *soap, _ngwm__removeItemResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeItemResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeItemResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeItemResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeItemResponse * SOAP_FMAC4 soap_in__ngwm__removeItemResponse(struct soap *soap, const char *tag, _ngwm__removeItemResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeItemResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeItemResponse, sizeof(_ngwm__removeItemResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeItemResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeItemResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeItemResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeItemResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeItemResponse, 0, sizeof(_ngwm__removeItemResponse), 0, soap_copy__ngwm__removeItemResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeItemResponse * SOAP_FMAC6 soap_new__ngwm__removeItemResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeItemResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeItemResponse(struct soap *soap, _ngwm__removeItemResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeItemResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeItemResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeItemResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeItemResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeItemResponse;
		if (size)
			*size = sizeof(_ngwm__removeItemResponse);
		((_ngwm__removeItemResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeItemResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeItemResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeItemResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeItemResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeItemResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeItemResponse %p -> %p\n", q, p));
	*(_ngwm__removeItemResponse*)p = *(_ngwm__removeItemResponse*)q;
}

void _ngwm__removeItemRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeItemRequest*)this)->container, SOAP_TYPE_PointerTongwt__uid);
	soap_serialize_PointerTongwt__uid(soap, &((_ngwm__removeItemRequest*)this)->container);
	soap_embedded(soap, &((_ngwm__removeItemRequest*)this)->id, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__removeItemRequest*)this)->id);
	/* transient soap skipped */
}

void _ngwm__removeItemRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeItemRequest*)this)->container = NULL;
	soap_default_ngwt__uid(soap, &((_ngwm__removeItemRequest*)this)->id);
	/* transient soap skipped */
}

int _ngwm__removeItemRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeItemRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeItemRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeItemRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeItemRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeItemRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeItemRequest), type);
	soap_out_PointerTongwt__uid(soap, "ngwm:container", -1, &(((_ngwm__removeItemRequest*)a)->container), "");
	soap_out_ngwt__uid(soap, "ngwm:id", -1, &(((_ngwm__removeItemRequest*)a)->id), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeItemRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeItemRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeItemRequest * SOAP_FMAC4 soap_get__ngwm__removeItemRequest(struct soap *soap, _ngwm__removeItemRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeItemRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeItemRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeItemRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeItemRequest * SOAP_FMAC4 soap_in__ngwm__removeItemRequest(struct soap *soap, const char *tag, _ngwm__removeItemRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeItemRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeItemRequest, sizeof(_ngwm__removeItemRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeItemRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeItemRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_container1 = 1, soap_flag_id1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_container1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTongwt__uid(soap, "ngwm:container", &(((_ngwm__removeItemRequest*)a)->container), "ngwt:uid"))
				{	soap_flag_container1 = 0;
					continue;
				}
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:id", &(((_ngwm__removeItemRequest*)a)->id), "ngwt:uid"))
				{	soap_flag_id1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeItemRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeItemRequest, 0, sizeof(_ngwm__removeItemRequest), 0, soap_copy__ngwm__removeItemRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeItemRequest * SOAP_FMAC6 soap_new__ngwm__removeItemRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeItemRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeItemRequest(struct soap *soap, _ngwm__removeItemRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeItemRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeItemRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeItemRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeItemRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeItemRequest;
		if (size)
			*size = sizeof(_ngwm__removeItemRequest);
		((_ngwm__removeItemRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeItemRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeItemRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeItemRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeItemRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeItemRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeItemRequest %p -> %p\n", q, p));
	*(_ngwm__removeItemRequest*)p = *(_ngwm__removeItemRequest*)q;
}

void _ngwm__removeCustomDefinitionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeCustomDefinitionResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__removeCustomDefinitionResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__removeCustomDefinitionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeCustomDefinitionResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__removeCustomDefinitionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeCustomDefinitionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeCustomDefinitionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeCustomDefinitionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeCustomDefinitionResponse(struct soap *soap, const char *tag, int id, const _ngwm__removeCustomDefinitionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeCustomDefinitionResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__removeCustomDefinitionResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeCustomDefinitionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeCustomDefinitionResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeCustomDefinitionResponse * SOAP_FMAC4 soap_get__ngwm__removeCustomDefinitionResponse(struct soap *soap, _ngwm__removeCustomDefinitionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeCustomDefinitionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeCustomDefinitionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeCustomDefinitionResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeCustomDefinitionResponse * SOAP_FMAC4 soap_in__ngwm__removeCustomDefinitionResponse(struct soap *soap, const char *tag, _ngwm__removeCustomDefinitionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeCustomDefinitionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeCustomDefinitionResponse, sizeof(_ngwm__removeCustomDefinitionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeCustomDefinitionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeCustomDefinitionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__removeCustomDefinitionResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeCustomDefinitionResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeCustomDefinitionResponse, 0, sizeof(_ngwm__removeCustomDefinitionResponse), 0, soap_copy__ngwm__removeCustomDefinitionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeCustomDefinitionResponse * SOAP_FMAC6 soap_new__ngwm__removeCustomDefinitionResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeCustomDefinitionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeCustomDefinitionResponse(struct soap *soap, _ngwm__removeCustomDefinitionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeCustomDefinitionResponse * SOAP_FMAC6 soap_instantiate__ngwm__removeCustomDefinitionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeCustomDefinitionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeCustomDefinitionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeCustomDefinitionResponse;
		if (size)
			*size = sizeof(_ngwm__removeCustomDefinitionResponse);
		((_ngwm__removeCustomDefinitionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeCustomDefinitionResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__removeCustomDefinitionResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__removeCustomDefinitionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeCustomDefinitionResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeCustomDefinitionResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeCustomDefinitionResponse %p -> %p\n", q, p));
	*(_ngwm__removeCustomDefinitionResponse*)p = *(_ngwm__removeCustomDefinitionResponse*)q;
}

void _ngwm__removeCustomDefinitionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__removeCustomDefinitionRequest*)this)->customs, SOAP_TYPE_PointerTongwt__CustomList);
	soap_serialize_PointerTongwt__CustomList(soap, &((_ngwm__removeCustomDefinitionRequest*)this)->customs);
	soap_embedded(soap, &((_ngwm__removeCustomDefinitionRequest*)this)->books, SOAP_TYPE_bool);
	soap_embedded(soap, &((_ngwm__removeCustomDefinitionRequest*)this)->doAsynchronous, SOAP_TYPE_bool);
	/* transient soap skipped */
}

void _ngwm__removeCustomDefinitionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__removeCustomDefinitionRequest*)this)->customs = NULL;
	((_ngwm__removeCustomDefinitionRequest*)this)->books = (bool)0;
	((_ngwm__removeCustomDefinitionRequest*)this)->doAsynchronous = (bool)0;
	/* transient soap skipped */
}

int _ngwm__removeCustomDefinitionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__removeCustomDefinitionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__removeCustomDefinitionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__removeCustomDefinitionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__removeCustomDefinitionRequest(struct soap *soap, const char *tag, int id, const _ngwm__removeCustomDefinitionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__removeCustomDefinitionRequest), type);
	soap_out_PointerTongwt__CustomList(soap, "ngwm:customs", -1, &(((_ngwm__removeCustomDefinitionRequest*)a)->customs), "");
	soap_out_bool(soap, "ngwm:books", -1, &(((_ngwm__removeCustomDefinitionRequest*)a)->books), "");
	soap_out_bool(soap, "ngwm:doAsynchronous", -1, &(((_ngwm__removeCustomDefinitionRequest*)a)->doAsynchronous), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__removeCustomDefinitionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__removeCustomDefinitionRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__removeCustomDefinitionRequest * SOAP_FMAC4 soap_get__ngwm__removeCustomDefinitionRequest(struct soap *soap, _ngwm__removeCustomDefinitionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__removeCustomDefinitionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__removeCustomDefinitionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__removeCustomDefinitionRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__removeCustomDefinitionRequest * SOAP_FMAC4 soap_in__ngwm__removeCustomDefinitionRequest(struct soap *soap, const char *tag, _ngwm__removeCustomDefinitionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__removeCustomDefinitionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__removeCustomDefinitionRequest, sizeof(_ngwm__removeCustomDefinitionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__removeCustomDefinitionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__removeCustomDefinitionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_customs1 = 1, soap_flag_books1 = 1, soap_flag_doAsynchronous1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_customs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__CustomList(soap, "ngwm:customs", &(((_ngwm__removeCustomDefinitionRequest*)a)->customs), "ngwt:CustomList"))
				{	soap_flag_customs1 = 0;
					continue;
				}
			if (soap_flag_books1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:books", &(((_ngwm__removeCustomDefinitionRequest*)a)->books), ""))
				{	soap_flag_books1 = 0;
					continue;
				}
			if (soap_flag_doAsynchronous1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:doAsynchronous", &(((_ngwm__removeCustomDefinitionRequest*)a)->doAsynchronous), ""))
				{	soap_flag_doAsynchronous1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__removeCustomDefinitionRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__removeCustomDefinitionRequest, 0, sizeof(_ngwm__removeCustomDefinitionRequest), 0, soap_copy__ngwm__removeCustomDefinitionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__removeCustomDefinitionRequest * SOAP_FMAC6 soap_new__ngwm__removeCustomDefinitionRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__removeCustomDefinitionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__removeCustomDefinitionRequest(struct soap *soap, _ngwm__removeCustomDefinitionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__removeCustomDefinitionRequest * SOAP_FMAC6 soap_instantiate__ngwm__removeCustomDefinitionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__removeCustomDefinitionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__removeCustomDefinitionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__removeCustomDefinitionRequest;
		if (size)
			*size = sizeof(_ngwm__removeCustomDefinitionRequest);
		((_ngwm__removeCustomDefinitionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__removeCustomDefinitionRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__removeCustomDefinitionRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__removeCustomDefinitionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__removeCustomDefinitionRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__removeCustomDefinitionRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__removeCustomDefinitionRequest %p -> %p\n", q, p));
	*(_ngwm__removeCustomDefinitionRequest*)p = *(_ngwm__removeCustomDefinitionRequest*)q;
}

void _ngwm__readCursorResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__readCursorResponse*)this)->items, SOAP_TYPE_PointerTongwt__ItemList);
	soap_serialize_PointerTongwt__ItemList(soap, &((_ngwm__readCursorResponse*)this)->items);
	soap_embedded(soap, &((_ngwm__readCursorResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__readCursorResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__readCursorResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__readCursorResponse*)this)->items = NULL;
	((_ngwm__readCursorResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__readCursorResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__readCursorResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__readCursorResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__readCursorResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__readCursorResponse(struct soap *soap, const char *tag, int id, const _ngwm__readCursorResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__readCursorResponse), type);
	soap_out_PointerTongwt__ItemList(soap, "ngwm:items", -1, &(((_ngwm__readCursorResponse*)a)->items), "");
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__readCursorResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__readCursorResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__readCursorResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__readCursorResponse * SOAP_FMAC4 soap_get__ngwm__readCursorResponse(struct soap *soap, _ngwm__readCursorResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__readCursorResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__readCursorResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__readCursorResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__readCursorResponse * SOAP_FMAC4 soap_in__ngwm__readCursorResponse(struct soap *soap, const char *tag, _ngwm__readCursorResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__readCursorResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__readCursorResponse, sizeof(_ngwm__readCursorResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__readCursorResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__readCursorResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_items1 = 1, soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemList(soap, "ngwm:items", &(((_ngwm__readCursorResponse*)a)->items), "ngwt:ItemList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__readCursorResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__readCursorResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__readCursorResponse, 0, sizeof(_ngwm__readCursorResponse), 0, soap_copy__ngwm__readCursorResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__readCursorResponse * SOAP_FMAC6 soap_new__ngwm__readCursorResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__readCursorResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__readCursorResponse(struct soap *soap, _ngwm__readCursorResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__readCursorResponse * SOAP_FMAC6 soap_instantiate__ngwm__readCursorResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__readCursorResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__readCursorResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__readCursorResponse;
		if (size)
			*size = sizeof(_ngwm__readCursorResponse);
		((_ngwm__readCursorResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__readCursorResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__readCursorResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__readCursorResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__readCursorResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__readCursorResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__readCursorResponse %p -> %p\n", q, p));
	*(_ngwm__readCursorResponse*)p = *(_ngwm__readCursorResponse*)q;
}

void _ngwm__readCursorRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__readCursorRequest*)this)->container, SOAP_TYPE_ngwt__uid);
	soap_serialize_ngwt__uid(soap, &((_ngwm__readCursorRequest*)this)->container);
	soap_embedded(soap, &((_ngwm__readCursorRequest*)this)->cursor, SOAP_TYPE_int);
	soap_embedded(soap, &((_ngwm__readCursorRequest*)this)->forward, SOAP_TYPE_bool);
	soap_embedded(soap, &((_ngwm__readCursorRequest*)this)->position, SOAP_TYPE_PointerTongwt__CursorSeek);
	soap_serialize_PointerTongwt__CursorSeek(soap, &((_ngwm__readCursorRequest*)this)->position);
	soap_embedded(soap, &((_ngwm__readCursorRequest*)this)->count, SOAP_TYPE_PointerToint);
	soap_serialize_PointerToint(soap, &((_ngwm__readCursorRequest*)this)->count);
	/* transient soap skipped */
}

void _ngwm__readCursorRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_ngwt__uid(soap, &((_ngwm__readCursorRequest*)this)->container);
	soap_default_int(soap, &((_ngwm__readCursorRequest*)this)->cursor);
	((_ngwm__readCursorRequest*)this)->forward = (bool)1;
	((_ngwm__readCursorRequest*)this)->position = NULL;
	((_ngwm__readCursorRequest*)this)->count = NULL;
	/* transient soap skipped */
}

int _ngwm__readCursorRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__readCursorRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__readCursorRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__readCursorRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__readCursorRequest(struct soap *soap, const char *tag, int id, const _ngwm__readCursorRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__readCursorRequest), type);
	soap_out_ngwt__uid(soap, "ngwm:container", -1, &(((_ngwm__readCursorRequest*)a)->container), "");
	soap_out_int(soap, "ngwm:cursor", -1, &(((_ngwm__readCursorRequest*)a)->cursor), "");
	soap_out_bool(soap, "ngwm:forward", -1, &(((_ngwm__readCursorRequest*)a)->forward), "");
	soap_out_PointerTongwt__CursorSeek(soap, "ngwm:position", -1, &(((_ngwm__readCursorRequest*)a)->position), "");
	soap_out_PointerToint(soap, "ngwm:count", -1, &(((_ngwm__readCursorRequest*)a)->count), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__readCursorRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__readCursorRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__readCursorRequest * SOAP_FMAC4 soap_get__ngwm__readCursorRequest(struct soap *soap, _ngwm__readCursorRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__readCursorRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__readCursorRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__readCursorRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__readCursorRequest * SOAP_FMAC4 soap_in__ngwm__readCursorRequest(struct soap *soap, const char *tag, _ngwm__readCursorRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__readCursorRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__readCursorRequest, sizeof(_ngwm__readCursorRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__readCursorRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__readCursorRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_container1 = 1, soap_flag_cursor1 = 1, soap_flag_forward1 = 1, soap_flag_position1 = 1, soap_flag_count1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_container1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_ngwt__uid(soap, "ngwm:container", &(((_ngwm__readCursorRequest*)a)->container), "ngwt:uid"))
				{	soap_flag_container1 = 0;
					continue;
				}
			if (soap_flag_cursor1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ngwm:cursor", &(((_ngwm__readCursorRequest*)a)->cursor), ""))
				{	soap_flag_cursor1 = 0;
					continue;
				}
			if (soap_flag_forward1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "ngwm:forward", &(((_ngwm__readCursorRequest*)a)->forward), ""))
				{	soap_flag_forward1 = 0;
					continue;
				}
			if (soap_flag_position1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__CursorSeek(soap, "ngwm:position", &(((_ngwm__readCursorRequest*)a)->position), ""))
				{	soap_flag_position1 = 0;
					continue;
				}
			if (soap_flag_count1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ngwm:count", &(((_ngwm__readCursorRequest*)a)->count), ""))
				{	soap_flag_count1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_container1 || soap_flag_cursor1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__readCursorRequest *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__readCursorRequest, 0, sizeof(_ngwm__readCursorRequest), 0, soap_copy__ngwm__readCursorRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__readCursorRequest * SOAP_FMAC6 soap_new__ngwm__readCursorRequest(struct soap *soap, int n)
{	return soap_instantiate__ngwm__readCursorRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__readCursorRequest(struct soap *soap, _ngwm__readCursorRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__readCursorRequest * SOAP_FMAC6 soap_instantiate__ngwm__readCursorRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__readCursorRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__readCursorRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__readCursorRequest;
		if (size)
			*size = sizeof(_ngwm__readCursorRequest);
		((_ngwm__readCursorRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__readCursorRequest[n];
		if (size)
			*size = n * sizeof(_ngwm__readCursorRequest);
		for (int i = 0; i < n; i++)
			((_ngwm__readCursorRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__readCursorRequest*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__readCursorRequest(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__readCursorRequest %p -> %p\n", q, p));
	*(_ngwm__readCursorRequest*)p = *(_ngwm__readCursorRequest*)q;
}

void _ngwm__purgeResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__purgeResponse*)this)->status, SOAP_TYPE_PointerTongwt__Status);
	soap_serialize_PointerTongwt__Status(soap, &((_ngwm__purgeResponse*)this)->status);
	/* transient soap skipped */
}

void _ngwm__purgeResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__purgeResponse*)this)->status = NULL;
	/* transient soap skipped */
}

int _ngwm__purgeResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__purgeResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__purgeResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__purgeResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__purgeResponse(struct soap *soap, const char *tag, int id, const _ngwm__purgeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__purgeResponse), type);
	soap_out_PointerTongwt__Status(soap, "ngwm:status", -1, &(((_ngwm__purgeResponse*)a)->status), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__purgeResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__purgeResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__purgeResponse * SOAP_FMAC4 soap_get__ngwm__purgeResponse(struct soap *soap, _ngwm__purgeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__purgeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__purgeResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__purgeResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__purgeResponse * SOAP_FMAC4 soap_in__ngwm__purgeResponse(struct soap *soap, const char *tag, _ngwm__purgeResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__purgeResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__purgeResponse, sizeof(_ngwm__purgeResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__purgeResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__purgeResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_status1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__Status(soap, "ngwm:status", &(((_ngwm__purgeResponse*)a)->status), "ngwt:Status"))
				{	soap_flag_status1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_status1))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ngwm__purgeResponse *)soap_id_forward(soap, soap->href, (void**)a, SOAP_TYPE__ngwm__purgeResponse, 0, sizeof(_ngwm__purgeResponse), 0, soap_copy__ngwm__purgeResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 _ngwm__purgeResponse * SOAP_FMAC6 soap_new__ngwm__purgeResponse(struct soap *soap, int n)
{	return soap_instantiate__ngwm__purgeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete__ngwm__purgeResponse(struct soap *soap, _ngwm__purgeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC5 _ngwm__purgeResponse * SOAP_FMAC6 soap_instantiate__ngwm__purgeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ngwm__purgeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ngwm__purgeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new _ngwm__purgeResponse;
		if (size)
			*size = sizeof(_ngwm__purgeResponse);
		((_ngwm__purgeResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new _ngwm__purgeResponse[n];
		if (size)
			*size = n * sizeof(_ngwm__purgeResponse);
		for (int i = 0; i < n; i++)
			((_ngwm__purgeResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ngwm__purgeResponse*)cp->ptr;
}

SOAP_FMAC5 void SOAP_FMAC6 soap_copy__ngwm__purgeResponse(struct soap *soap, int st, int tt, void *p, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ngwm__purgeResponse %p -> %p\n", q, p));
	*(_ngwm__purgeResponse*)p = *(_ngwm__purgeResponse*)q;
}

void _ngwm__purgeRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((_ngwm__purgeRequest*)this)->items, SOAP_TYPE_PointerTongwt__ItemRefList);
	soap_serialize_PointerTongwt__ItemRefList(soap, &((_ngwm__purgeRequest*)this)->items);
	/* transient soap skipped */
}

void _ngwm__purgeRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((_ngwm__purgeRequest*)this)->items = NULL;
	/* transient soap skipped */
}

int _ngwm__purgeRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ngwm__purgeRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int _ngwm__purgeRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ngwm__purgeRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ngwm__purgeRequest(struct soap *soap, const char *tag, int id, const _ngwm__purgeRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ngwm__purgeRequest), type);
	soap_out_PointerTongwt__ItemRefList(soap, "ngwm:items", -1, &(((_ngwm__purgeRequest*)a)->items), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *_ngwm__purgeRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ngwm__purgeRequest(soap, this, tag, type);
}

SOAP_FMAC3 _ngwm__purgeRequest * SOAP_FMAC4 soap_get__ngwm__purgeRequest(struct soap *soap, _ngwm__purgeRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ngwm__purgeRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *_ngwm__purgeRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ngwm__purgeRequest(soap, tag, this, type);
}

SOAP_FMAC3 _ngwm__purgeRequest * SOAP_FMAC4 soap_in__ngwm__purgeRequest(struct soap *soap, const char *tag, _ngwm__purgeRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (_ngwm__purgeRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ngwm__purgeRequest, sizeof(_ngwm__purgeRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ngwm__purgeRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ngwm__purgeRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_items1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_items1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTongwt__ItemRefList(soap, "ngwm:items", &(((_ngwm__purgeRequest*)a)->items), "ngwt:ItemRefList"))
				{	soap_flag_items1 = 0;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_items1))
		{	soap->error = SOAP_OCCURS;