#include "pframe.h"


PObject *
PFrame::createWidget(CreateArgs &ca)
{
  PFrame *pw = new PFrame(ca.parent);
  TQFrame *tf;
  if(ca.parent != 0 &&
     ca.parent->widget()->isWidgetType() == TRUE)
    tf = new TQFrame((TQWidget *) ca.parent->widget());
  else
    tf = new TQFrame();
  pw->setWidget(tf);
  pw->setWidgetId(ca.pwI);
  pw->setPukeController(ca.pc);  
  return pw;
}


PFrame::PFrame( PObject *parent)
  : PWidget(parent)
{
  //  kdDebug(5008) << "PFrame PFrame called" << endl;
  frame = 0;
}

PFrame::~PFrame()
{
  //  kdDebug(5008) << "PFrame: in destructor" << endl;
  /*
  delete frame; // Delete the frame
  frame=0;      // Set it to 0
  setWidget(frame); // Now set all widget() calls to 0.
  */
}

void PFrame::messageHandler(int fd, PukeMessage *pm)
{
  //  kdDebug(5008) << "PFrame handler called" << endl;
  PukeMessage pmRet;
  switch(pm->iCommand){
  case PUKE_TQFRAME_SET_FRAME:
    widget()->setFrameStyle(pm->iArg);
    pmRet.iCommand = PUKE_TQFRAME_SET_FRAME_ACK;
    pmRet.iWinId = pm->iWinId;
    pmRet.iArg = widget()->frameStyle();
    pmRet.cArg = 0;
    emit outputMessage(fd, &pmRet);
    break;
  case PUKE_TQFRAME_SET_LINEWIDTH:
    widget()->setLineWidth(pm->iArg);
    pmRet.iCommand = PUKE_TQFRAME_SET_LINEWIDTH_ACK;
    pmRet.iWinId = pm->iWinId;
    pmRet.iArg = widget()->lineWidth();
    pmRet.cArg = 0;
    emit outputMessage(fd, &pmRet);
    break;
  default:
    PWidget::messageHandler(fd, pm);
  }
}

void PFrame::setWidget(TQObject *w)
{
  if(w != 0 && w->inherits(TQFRAME_OBJECT_NAME_STRING) == FALSE)
  {
    errorInvalidSet(w);
    return;
  }

  frame = (TQFrame *) w;
  PWidget::setWidget((TQWidget *) w);
}


TQFrame *PFrame::widget()
{
  //  kdDebug(5008) << "PFrame widget called" << endl;
  return frame;
}

#include "pframe.moc"

