/*
   irceditaccountwidget.h - IRC Account Widget

    Kopete    (c) 2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/



#ifndef IRCEDITACCOUNTWIDEGET_H
#define IRCEDITACCOUNTWIDEGET_H

#include "editaccountwidget.h"
#include "irceditaccount.h"

class IRCProtocol;
class IRCAccount;
class TDEListView;
class TQListViewItem;

class IRCEditAccountWidget : public IRCEditAccountBase, public KopeteEditAccountWidget
{
	Q_OBJECT
  

	public:
		IRCEditAccountWidget(IRCProtocol *proto, IRCAccount *, TQWidget *parent=0, const char *name=0);
		~IRCEditAccountWidget();

		IRCAccount *account();
		virtual bool validateData();
		virtual Kopete::Account *apply();

	private slots:
		void slotCommandContextMenu( TDEListView*, TQListViewItem*, const TQPoint & );
		void slotCtcpContextMenu( TDEListView*, TQListViewItem*, const TQPoint & );
		void slotAddCommand();
		void slotAddCtcp();
		void slotEditNetworks();
		void slotUpdateNetworks( const TQString & );
		void slotUpdateNetworkDescription( const TQString & );

	private:
		void readNetworks();
		TQString generateAccountId( const TQString &network );

		IRCProtocol *mProtocol;
};

#endif

// vim: set noet ts=4 sts=4 sw=4:

