/***************************************************************************
 *   Copyright (C) 2006 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqtimer.h>
#include <tqframe.h>

#include <kdebug.h>
#include <tdeparts/part.h>
#include <klibloader.h>
#include <kde_terminal_interface.h>
#include <kprocess.h>

#include "kdevshellwidget.h"

KDevShellWidget::KDevShellWidget(TQWidget *parent, const char *name)
 : TQVBox(parent, name), m_doAutoActivate( false ), m_isRunning( false )
{
}


KDevShellWidget::~KDevShellWidget()
{
}

void KDevShellWidget::setShell( const TQString & shell, const TQStrList & arguments )
{
	m_shellName = shell;
	m_shellArguments = arguments;
}

void KDevShellWidget::activate( )
{
	KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");
	if ( !factory ) return;

  	m_konsolePart = (KParts::ReadOnlyPart *) factory->create( TQT_TQOBJECT(this), "libkonsolepart", "KParts::ReadOnlyPart" );
	if ( !m_konsolePart ) return;

	connect( m_konsolePart, TQT_SIGNAL( processExited(TDEProcess *) ), this, TQT_SLOT( processExited(TDEProcess *) ) );
	connect( m_konsolePart, TQT_SIGNAL( receivedData( const TQString& ) ), this, TQT_SIGNAL( receivedData( const TQString& ) ) );
	connect( m_konsolePart, TQT_SIGNAL(destroyed()), this, TQT_SLOT(partDestroyed()) );

 	m_konsolePart->widget()->setFocusPolicy( TQ_WheelFocus );
 	setFocusProxy( m_konsolePart->widget() );
 	m_konsolePart->widget()->setFocus();

 	if ( m_konsolePart->widget()->inherits(TQFRAME_OBJECT_NAME_STRING) )
 		((TQFrame*)m_konsolePart->widget())->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );

	m_konsolePart->widget()->show();

	TerminalInterface* ti = static_cast<TerminalInterface*>( m_konsolePart->tqt_cast( "TerminalInterface" ) );
	if( !ti ) return;

	if ( !m_shellName.isEmpty() )
		ti->startProgram( m_shellName, m_shellArguments );

	m_isRunning = true;

}

void KDevShellWidget::partDestroyed( )
{
	if ( m_doAutoActivate )
	{
		activate();
	}
}

void KDevShellWidget::processExited( TDEProcess * proc )
{
	m_isRunning = false;

	if ( !proc ) return;

	kdDebug(9000) << proc->args() << endl;

	if ( proc->normalExit() )
		emit shellExited( proc->exitStatus() );
	else if ( proc->signalled() )
		emit shellSignalled( proc->exitSignal() );
}

void KDevShellWidget::sendInput( const TQString & text )
{
	if ( !m_konsolePart ) return;
	TerminalInterface* ti = static_cast<TerminalInterface*>( m_konsolePart->tqt_cast( "TerminalInterface" ) );
	if( !ti ) return;

	ti->sendInput( text );
}

bool KDevShellWidget::isRunning( )
{
	return m_isRunning;
}

void KDevShellWidget::setAutoReactivateOnClose( bool doAutoActivate )
{
	// to auto reactivate can be dangerous, do it like this to avoid
	// reactivating with a non-working setting (the partDestroyed()
	// slot will have ran before m_doAutoActivate is set)
	if ( doAutoActivate )
		TQTimer::singleShot( 3000, this, TQT_SLOT(setAutoReactivateOnCloseDelayed()) );
	else
		m_doAutoActivate = false;
}

void KDevShellWidget::setAutoReactivateOnCloseDelayed( )
{
	m_doAutoActivate = true;
}


#include "kdevshellwidget.moc"

// kate: space-indent off; indent-width 4; tab-width 4; show-tabs off;
