/**********************************************************************
** Copyright (C) 2001 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef OUTPUTWINDOW_H
#define OUTPUTWINDOW_H

#include <tqtabwidget.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqlistview.h>

struct DesignerOutputDock;
class TQTextEdit;
class TQListView;

class ErrorItem : public TQListViewItem
{
public:
    enum Type { Error, Warning };

    ErrorItem( TQListView *parent, TQListViewItem *after, const TQString &message, int line,
	       const TQString &locationString, TQObject *locationObject );

    void paintCell( TQPainter *, const TQColorGroup & cg,
		    int column, int width, int alignment );

    void setRead( bool b ) { read = b; repaint(); }

    TQObject *location() const { return object; }
    int line() const { return text( 2 ).toInt(); }

private:
    TQObject *object;
    Type type;
    bool read;

};

class OutputWindow : public TQTabWidget
{
    Q_OBJECT
  

public:
    OutputWindow( TQWidget *parent );
    ~OutputWindow();

    void setErrorMessages( const TQStringList &errors, const TQValueList<uint> &lines,
			   bool clear, const TQStringList &locations,
			   const TQObjectList &locationObjects );
    void appendDebug( const TQString& );
    void clearErrorMessages();
    void clearDebug();
    void showDebugTab();

    DesignerOutputDock *iFace();

    void shuttingDown();

    static TQtMsgHandler oldMsgHandler;

private slots:
    void currentErrorChanged( TQListViewItem *i );

private:
    void setupError();
    void setupDebug();

    TQTextEdit *debugView;
    TQListView *errorView;

    DesignerOutputDock *iface;

};

#endif
