
#include "bugjob.h"

#include "kbbprefs.h"

#include <tdeio/job.h>

#include <string.h>
#include <tdelocale.h>
#include <kdebug.h>

BugJob::BugJob( BugServer *server )
    : Job( false ), mServer( server )
{
}

BugJob::~BugJob()
{
}

void BugJob::start( const KURL &url )
{
    kdDebug() << "BugJob::start(): " << url.url() << endl;

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveQuery( url );
    }

    // ### obey post, if necessary

    TDEIO::Job *job = TDEIO::get( url, true /*always 'reload=true', we have our own cache*/, false );

    connect( job, TQT_SIGNAL( result( TDEIO::Job * ) ),
             this, TQT_SLOT( ioResult( TDEIO::Job * ) ) );
    connect( job, TQT_SIGNAL( data( TDEIO::Job *, const TQByteArray & ) ),
             this, TQT_SLOT( ioData( TDEIO::Job *, const TQByteArray & ) ) );
    connect( job, TQT_SIGNAL( infoMessage( TDEIO::Job *, const TQString & ) ),
             this, TQT_SLOT( ioInfoMessage( TDEIO::Job *, const TQString & ) ) );
    connect( job, TQT_SIGNAL( percent( TDEIO::Job *, unsigned long ) ),
             this, TQT_SLOT( ioInfoPercent( TDEIO::Job *, unsigned long ) ) );
}

void BugJob::ioResult( TDEIO::Job *job )
{
    m_error = job->error();
    m_errorText = job->errorText();

    if ( job->error() )
    {
        emit error( m_errorText );
        BugSystem::self()->unregisterJob(this);
        this->kill();
        return;
    }

    infoMessage( i18n( "Parsing..." ) );

#if 0
    kdDebug() << "--START:" << m_data << ":END--" << endl;
#endif

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveResponse( m_data );
    }

    process( m_data );
    infoMessage( i18n( "Ready." ) );

    emit jobEnded( this );

    delete this;
}

void BugJob::ioData( TDEIO::Job *, const TQByteArray &data )
{
    unsigned int start = m_data.size();

    m_data.resize( m_data.size() + data.size() );
    memcpy( m_data.data() + start, data.data(), data.size() );
}

void BugJob::ioInfoMessage( TDEIO::Job *, const TQString &_text )
{
    TQString text = _text;
    emit infoMessage( text );
}

void BugJob::ioInfoPercent( TDEIO::Job *, unsigned long percent )
{
    emit infoPercent( percent );
}

#include "bugjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
