/****************************************************************************
**
** Implementation of TQWidget class
**
** Created : 931031
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the xt extension of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#ifndef QXTEVENTLOOP_H
#define QXTEVENTLOOP_H

#include <tqglobal.h>

// #if TQT_VERSION >= 0x030100
#include <tqeventloop.h>



#include <X11/Intrinsic.h>

class QXtEventLoopPrivate;

class QXtEventLoop : public TQEventLoop
{
    Q_OBJECT
    

public:
    QXtEventLoop( const char *applicationClass, XtAppContext context = NULL, XrmOptionDescRec *options = 0, int numOptions = 0);
    ~QXtEventLoop();

    XtAppContext applicationContext() const;

    void registerSocketNotifier( TQSocketNotifier * );
    void unregisterSocketNotifier( TQSocketNotifier * );

    static void registerWidget( TQWidget* );
    static void unregisterWidget( TQWidget* );
    static bool redeliverEvent( XEvent *event );
    static XEvent* lastEvent();

protected:
    bool processEvents( ProcessEventsFlags flags );

private:
    void appStartingUp();
    void appClosingDown();
    QXtEventLoopPrivate *d;

};

// #endif

#endif // QMOTIF_H
