/* This file is part of the KDE project
   Copyright (C) 2003 Fabian Wolf <fabianw@gmx.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef audiopreview_h
#define audiopreview_h

#include <tqvbox.h>

namespace KMediaPlayer
{
  class Player;
}

class TQPixmap;
class TQLabel;
class AudioPreview : public TQVBox
{
  Q_OBJECT
  
public:
  AudioPreview(TQWidget *parent, const char *name, const TQString &fileName, const TQString &mimeType);
  ~AudioPreview();

private slots:
  void downloadFile(const TQString& url);

private:
  void initView(const TQString& mimeType);

  TQLabel *pic;
  TQLabel *description;
  TQString m_localFile;
  bool m_isTempFile;

  KMediaPlayer::Player *m_player;
};
#endif























