#ifndef FFRS_H
#define FFRS_H

#include <noatun/pref.h>
#include <noatun/plugin.h>


class View : public TQWidget
{
Q_OBJECT
  
public:
	View(int width, int height, int block, int unblock, TQColor front, TQColor back, int channel);
	~View();

	void draw(float intensity);

    virtual void mouseMoveEvent(TQMouseEvent *e);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void mouseReleaseEvent(TQMouseEvent *e);

private:
	int units;
	TQColor fg, bg;
	bool moving;
	TQPoint mMousePoint;
	int mChannel;
};

class FFRSPrefs;

class FFRS : public TQObject, public Plugin, public StereoScope
{
Q_OBJECT
  

public:
	FFRS();
	~FFRS();

	virtual void scopeEvent(float *left, float *right, int len);

public slots:
	void changed();

private:
	View *dpyleft, *dpyright;
	FFRSPrefs *prefs;
};


class KIntNumInput;
class KColorButton;

class FFRSPrefs : public CModule
{
Q_OBJECT
  

public:
	FFRSPrefs( TQObject *parent );
	virtual void save();

	int width();
	int height();
	int fgblock();
	int bgblock();
	int rate();
	
	TQColor bgcolor();
	TQColor fgcolor();

signals:
	void changed();

private:
	KIntNumInput *mWidth, *mHeight, *mFgblock, *mBgblock, *mRate;
	KColorButton *mBgcolor, *mFgcolor;
};


#endif

