// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; tab-width: 8; -*-

/***************************************************************************
                          nsstacktabwidget.h  -  description
                             -------------------
    begin                : Sat 07.09.2002
    copyright            : (C) 2002-2004 Marcus Camen
    email                : mcamen@mcamen.de
***************************************************************************/

/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef _NSSTACKTABWIDGET_H_
#define _NSSTACKTABWIDGET_H_

#include <tqptrdict.h>
#include "nspanel.h"


class TQVBoxLayout;
class TQPushButton;
class TQStringList;
class TDEPopupMenu;
class TDEAboutData;
class TDEAboutApplication;
class KBugReport;
class TDEConfigDialog;

namespace KSB_News {

  class NewRssSourceDlg;

  class NSStackTabWidget : public TQWidget {
    Q_OBJECT
  

  public:
    NSStackTabWidget(TQWidget *parent = 0, const char *name = 0,
                     TQPixmap appIcon = TQPixmap());
    void addStackTab(NSPanel *nsp, TQWidget *page);
    void delStackTab(NSPanel *nsp);
    void updateTitle(NSPanel *nsp);
    void updatePixmap(NSPanel *nsp);
    bool isEmpty() const;
    bool isRegistered(const TQString &key);

  protected:
    bool eventFilter(TQObject *obj, TQEvent *ev);

  private slots:
    void buttonClicked();
    void slotShowAbout();
    void slotShowBugreport();
    void slotRefresh();
    void slotClose();
    void slotConfigure();
    void slotConfigure_okClicked();

  private:
    TQPtrDict<TQWidget> pages;
    TQPtrDict<TQWidget> pagesheader;
    TQVBoxLayout *layout;
    TQWidget *currentPage;
    TDEPopupMenu *popup, *helpmenu;
    TDEAboutData *m_aboutdata;
    TDEAboutApplication *m_about;
    KBugReport *m_bugreport;
    TQPushButton *m_last_button_rightclicked;
    TDEConfigDialog *m_confdlg;
    TQStringList m_our_rsssources;
  };


} // namespace KSB_News


#endif
