#include <tqstring.h>
#include <tqlayout.h>
#include <tqstringlist.h>
#include <tqframe.h>
#include <tqptrlist.h>
#include <tqlabel.h>

#include <kcolorbutton.h>
#include <kdialogbase.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kurllabel.h>

#include "boardinfo.h"

BoardInfoDlg::BoardInfoDlg(bool editable, BoardInfo *info, TQWidget *parent, const char *_name, bool modal)
	: KDialogBase(KDialogBase::Tabbed, i18n("Gameboard Information"), (editable? Ok|Apply|Cancel : Close), (editable? Ok : Close), parent, _name, modal)
{
	if (!info)
		return;
	this->info = info;

	setWFlags(WDestructiveClose);

	TQFrame *about = addPage(i18n("Information"));
	TQVBoxLayout *aboutLayout = new TQVBoxLayout(about, spacingHint());

	if (editable)
	{
		aboutLayout->addWidget(name = new KLineEdit(about));
		name->setText(info->name);
	}
	else
	{
		aboutLayout->addWidget(new TQLabel(info->name, about));
		name = 0;
	}

	TQHBoxLayout *versionLayout = new TQHBoxLayout(aboutLayout, spacingHint());
	versionLayout->addWidget(new TQLabel(i18n("Version:"), about));
	if (editable)
	{
		versionLayout->addWidget(version = new KLineEdit(about));
		version->setText(info->version);
	}
	else
		versionLayout->addWidget(new TQLabel(info->version, about));

	TQHBoxLayout *urlLayout = new TQHBoxLayout(aboutLayout, spacingHint());
	urlLayout->addWidget(new TQLabel(i18n("URL:"), about));
	if (editable)
		urlLayout->addWidget(url = new KLineEdit(info->url, about));
	else
		urlLayout->addWidget(new KURLLabel(info->url, info->url, about));

	aboutLayout->addStretch(3);

	aboutLayout->addWidget(new TQLabel(i18n("Description:"), about));
	aboutLayout->addStretch();
	aboutLayout->addWidget(description = new KLineEdit(about));
	description->setText(info->description);
	if (!editable)
	{
		description->setReadOnly(true);
	}

	if (editable)
	{
		TQHBoxLayout *bgLayout = new TQHBoxLayout(aboutLayout, spacingHint());
		bgLayout->addWidget(new TQLabel(i18n("Background color:"), about));
		bgColor = new KColorButton(info->bgColor, about);
		bgLayout->addWidget(bgColor);
	}
	else
		bgColor = 0;

	TQFrame *authorsFrame = addPage(i18n("&Authors"));
	TQVBoxLayout *authorsLayout = new TQVBoxLayout(authorsFrame, spacingHint());
	authorsLayout->addWidget(authors = new LotsaEdits(editable, info->authors, authorsFrame));

	TQFrame *creditsFrame = addPage(i18n("&Thanks To"));
	TQVBoxLayout *creditsLayout = new TQVBoxLayout(creditsFrame, spacingHint());
	creditsLayout->addWidget(credits = new LotsaEdits(editable, info->credits, creditsFrame));
}

void BoardInfoDlg::slotApply()
{
	info->name = name->text();
	info->description = description->text();
	info->version = version->text();
	info->url = url->text();
	info->authors = authors->save();
	info->credits = credits->save();

	if (bgColor)
		info->bgColor = bgColor->color().name();

	emit okClicked();
	KDialogBase::slotApply();
}

void BoardInfoDlg::slotOk()
{
	slotApply();

	KDialogBase::slotOk();
}

///////////////////////////////////

LotsaEdits::LotsaEdits(bool editable, TQStringList defaults, TQWidget *parent, const char *name) : TQWidget(parent, name)
{
	list.setAutoDelete(true);
	this->editable = editable;

	layout = new TQVBoxLayout(this, KDialogBase::spacingHint());
	TQHBoxLayout *hlayout = new TQHBoxLayout(layout, KDialogBase::spacingHint());

	if (editable)
	{
		KPushButton *more = new KPushButton(i18n("&Add Name"), this);
		hlayout->addWidget(more);
		connect(more, TQT_SIGNAL(clicked()), this, TQT_SLOT(more()));
		hlayout->addStretch();
		KPushButton *less= new KPushButton(i18n("&Delete Name"), this);
		hlayout->addWidget(less);
		connect(less, TQT_SIGNAL(clicked()), this, TQT_SLOT(less()));
	}

	layout->addStretch();

	for (TQStringList::Iterator it = defaults.begin(); it != defaults.end(); ++it)
	{
		more();
		if (editable)
			static_cast<KLineEdit *>(list.last())->setText(*it);
		else
			static_cast<TQLabel *>(list.last())->setText(*it);
	}
}

void LotsaEdits::more()
{
	TQWidget *edit;
	if (editable)
		edit = new KLineEdit(this);
	else
		edit = new TQLabel(this);
	layout->addWidget(edit);
	list.append(edit);
	edit->show();
}

void LotsaEdits::less()
{
	list.removeLast();
	   /*
	TQWidget *edit = 0;
	for (edit = list.first(); edit; edit = list.next())
	{
		if (edit->hasFocus())
		{
			list.remove();
			break;
		}
	}
	*/
}

TQStringList LotsaEdits::save()
{
	TQStringList ret;

	TQWidget *edit = 0;
	for (edit = list.first(); edit; edit = list.next())
		if (editable)
			ret.append(static_cast<KLineEdit *>(edit)->text());
		else
			ret.append(static_cast<TQLabel *>(edit)->text());

	return ret;
}

#include "boardinfo.moc"
