// -*- c++ -*-

/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsbinding.h>
#include <kjsembed/kjsembedpart.h>
#include <kjsembed/customobject_imp.h>
#include <tqvariant.h>


#include "customqobject_plugin.h"

namespace KJSEmbed {
namespace Bindings {

MyCustomTQObjectLoader::MyCustomTQObjectLoader( TQObject *parent, const char *name, const TQStringList &args ) :
	JSBindingPlugin(parent, name, args)
{
}

KJS::Object MyCustomTQObjectLoader::createBinding(KJSEmbedPart *jspart, KJS::ExecState *exec, const KJS::List &args) const
{
	kdDebug() << "Loading a custom object" << endl;

	TQObject *parent = 0L;
	JSObjectProxy *proxy = JSProxy::toObjectProxy( args[0].imp() );
	if ( proxy )
		parent = proxy->object();
	MyCustomTQObjectImp *imp =  new MyCustomTQObjectImp(parent, "MyCustomTQObject" );
	JSObjectProxy *prx = new JSObjectProxy( jspart, imp );

	KJS::Object proxyObj( prx );
	prx->addBindings( exec, proxyObj );
	CustomObjectImp::addBindings( exec, proxyObj );
	return proxyObj;
}

MyCustomTQObjectImp::MyCustomTQObjectImp(TQObject *parent, const char *name )
    : TQObject(parent, name)
{
	kdDebug() << "New MyCustomTQObjectImp " << endl;
}

MyCustomTQObjectImp::~MyCustomTQObjectImp()
{
}

MyCustomTQObjectImp::Mode MyCustomTQObjectImp::mode() const
{
	kdDebug() << "mode() " << endl;
	return m_mode;
}
void MyCustomTQObjectImp::setMode( Mode md)
{
	kdDebug() << "setMode() " << endl;
	m_mode = md;
}
TQString MyCustomTQObjectImp::thing() const
{
	kdDebug() << "thing()" << endl;
	return m_thing;
}
void MyCustomTQObjectImp::setThing( const TQString &t)
{
	kdDebug() << "setThing() " << t << endl;
	m_thing = t;
}
} // namespace KJSEmbed::Bindings
} // namespace KJSEmbed


#include <kgenericfactory.h>
typedef KGenericFactory<KJSEmbed::Bindings::MyCustomTQObjectLoader> MyCustomTQObjectLoaderFactory;
K_EXPORT_COMPONENT_FACTORY( libcustomqobjectplugin, MyCustomTQObjectLoaderFactory( "MyCustomTQObjectLoader" ) )


#include "customqobject_plugin.moc"
