//
// C++ Interface: aboutdialog
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ABOUTDIALOG_H
#define ABOUTDIALOG_H

#include <tqlabel.h>
#include <kommanderwidget.h>

class TDEAboutApplication;
class TDEAboutData;

/**
	@author Andras Mantia <amantia@kdewebdev.org>
*/
class AboutDialog : public TQLabel, public KommanderWidget
{
  Q_OBJECT
  
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
public:
    AboutDialog(TQWidget *parent = 0, const char *name = 0);

    ~AboutDialog();

  virtual bool isKommanderWidget() const;
  virtual TQString currentState() const;
  virtual bool isFunctionSupported(int function);
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  virtual TQStringList associatedText() const;
  virtual void setAssociatedText(const TQStringList&);

public slots:
  virtual void populate();
  virtual void execute();

private:
  void initialize(const TQString& appName, const TQString &icon, const TQString& version, const TQString& copyright);  
  void addAuthor(const TQString& author, const TQString &task, const TQString& email, const TQString &webAddress);
  void addTranslator(const TQString& author, const TQString& email);
  void setDescription(const TQString& description);
  void setHomepage(const TQString &homepage);
  void setBugAddress(const TQString &bugAddress);
  void setLicense(const TQString &license);

  TDEAboutData *m_aboutData;
  TQString m_version;
  TQString m_appName;
  TQString m_copyright;
  TQString m_icon;
  TQString m_bugaddress;
  TQStringList m_authors;
  TQStringList m_emails;
  TQStringList m_tasks;
  TQStringList m_addresses;
  TQString m_description;
  TQString m_homepage;
  TQString m_license;
};

#endif
