#include <config.h>

#include <tqpushbutton.h>

#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdemenubar.h>
#include <tdetoolbar.h>
#include <kiconloader.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <kstdgameaction.h>

#include "version.h"
#include "gamecore.h"
#include "mainwin.h"
#include "mainwin.moc"
#include "gameboard.h"

// KonquestMainWindow


MainWindow::MainWindow()
{
    setCaption( i18n("Galactic Conquest") );

    setupGameBoard();
    setupTDEAction();
    setupGUI();
}

MainWindow::~MainWindow()
{
}

void
MainWindow::setupTDEAction()
{
    KStdGameAction::gameNew( TQT_TQOBJECT(gameBoard), TQT_SLOT( startNewGame() ), actionCollection() );
    KStdGameAction::quit( TQT_TQOBJECT(this), TQT_SLOT( close() ), actionCollection() );
    endAction = KStdGameAction::end( TQT_TQOBJECT(gameBoard), TQT_SLOT( shutdownGame() ), actionCollection() );
    endAction->setEnabled(false);

    //AB: there is no icon for disabled - TDEToolBar::insertButton shows the
    //different state - TDEAction not :-(
    measureAction = new TDEAction( i18n("&Measure Distance"), "ruler", 0, TQT_TQOBJECT(gameBoard), TQT_SLOT( measureDistance() ), actionCollection(), "game_measure" );
    measureAction->setEnabled(false);
    standingAction = new TDEAction( i18n("&Show Standings"), "help", 0, TQT_TQOBJECT(gameBoard), TQT_SLOT( showScores() ), actionCollection(), "game_scores" );
    standingAction->setEnabled(false);
    fleetAction = new TDEAction( i18n("&Fleet Overview"), "launch", 0, TQT_TQOBJECT(gameBoard), TQT_SLOT( showFleets() ), actionCollection(), "game_fleets" );
    fleetAction->setEnabled(false);
    toolBar()->setBarPos( TDEToolBar::Left );
    toolBar()->setMovingEnabled( false );
}

void
MainWindow::setupGameBoard()
{
    gameBoard = new GameBoard( this );
    setCentralWidget(gameBoard);

    connect( gameBoard, TQT_SIGNAL( newGameState( GameState )), TQT_TQOBJECT(this), TQT_SLOT( gameStateChange( GameState ) ) );
}


void
MainWindow::gameStateChange( GameState newState )
{
    endAction->setEnabled( gameBoard->isGameInProgress() );
    measureAction->setEnabled( newState==SOURCE_PLANET );
    standingAction->setEnabled( newState==SOURCE_PLANET );
    fleetAction->setEnabled( newState==SOURCE_PLANET );
}



