 /*
    This file is part of libkcal.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_RESOURCEREMOTEDIR_H
#define KCAL_RESOURCEREMOTEDIR_H

#include <tqptrlist.h>
#include <tqstring.h>
#include <tqdatetime.h>

#include <kurl.h>
#include <tdeconfig.h>
#include <kdirwatch.h>
#include <tdepimmacros.h>

#include <libtdepim/progressmanager.h>

#include <libkcal/incidence.h>
#include <libkcal/calendarlocal.h>
#include <libkcal/icalformat.h>

#include <libkcal/resourcecached.h>

namespace TDEIO {
class FileCopyJob;
class Job;
}

namespace KCal {

/**
  This class provides a calendar stored as a remote file.
*/
class KDE_EXPORT ResourceRemote : public ResourceCached
{
    Q_OBJECT
  

    friend class ResourceRemoteConfig;

  public:
    /**
      Create resource from configuration information stored in TDEConfig object.
    */
    ResourceRemote( const TDEConfig * );
    /**
      Create remote resource.
      
      @param downloadUrl URL used to download iCalendar file
      @param uploadUrl   URL used to upload iCalendar file
    */
    ResourceRemote( const KURL &downloadUrl, const KURL &uploadUrl = KURL() );
    virtual ~ResourceRemote();

    void readConfig( const TDEConfig *config );
    void writeConfig( TDEConfig *config );

    void setDownloadUrl( const KURL & );
    KURL downloadUrl() const;

    void setUploadUrl( const KURL & );
    KURL uploadUrl() const;

    void setUseProgressManager( bool useProgressManager );
    bool useProgressManager() const;

    void setUseCacheFile( bool useCacheFile );
    bool useCacheFile() const;

    TDEABC::Lock *lock();

    bool isSaving();

    void dump() const;

    bool setValue( const TQString &key, const TQString &value );


  protected slots:
    void slotLoadJobResult( TDEIO::Job * );
    void slotSaveJobResult( TDEIO::Job * );

    void slotPercent( TDEIO::Job *, unsigned long percent );

  protected:
    bool doLoad();
    bool doSave();

    void addInfoText( TQString & ) const;

  private:
    void init();

    KURL mDownloadUrl;
    KURL mUploadUrl;

    bool mUseProgressManager;
    bool mUseCacheFile;

    TDEIO::FileCopyJob *mDownloadJob;
    TDEIO::FileCopyJob *mUploadJob;
    
    KPIM::ProgressItem *mProgress;

    Incidence::List mChangedIncidences;
    
    TDEABC::Lock *mLock;

    class Private;
    Private *d;
};

}

#endif
