/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KRECFILEWIDGETS_H
#define KRECFILEWIDGETS_H

#include <tqframe.h>
#include <tqvaluelist.h>
#include <tqpoint.h>

class KRecFile;
class KRecBuffer;
class TimeDisplay;
class TQBoxLayout;
class TQLabel;
class TQLineEdit;

class KRecFileWidget;
class KRecBufferWidget;
class KRecTimeBar;
class KRecTimeDisplay;

class TQRegion;
class TQPainter;
class TDEAction;
class TDEToggleAction;

class KRecFileWidget : public TQFrame {
   Q_OBJECT
  
public:
	KRecFileWidget( KRecFile*, TQWidget*, const char* =0 );
	~KRecFileWidget();

	void setFile( KRecFile* );

	void resizeEvent( TQResizeEvent* =0 );
	void mouseReleaseEvent( TQMouseEvent* );
public slots:
	void newBuffer( KRecBuffer* );
	void deleteBuffer( KRecBuffer* );
private slots:
	void popupMenu( KRecBufferWidget*, TQPoint );
private:
	KRecFile *_file;
	TQValueList<KRecBufferWidget*> bufferwidgets;
};

class Sample : public TQObject {
   Q_OBJECT
  
public:
	Sample() : _values( 0 ), _min( 0 ), _max( 0 ) {}

	void addValue( float n ) { _values += n; ++_count; addMin( n ); addMax( n ); }
	void addMin( float n ) { if ( n < _min ) _min = n; }
	void addMax( float n ) { if ( n > _max ) _max = n; }

	float getValue() const { return _values / _count; }
	float getMax() const { return ( _max>1 )?1:_max; }
	float getMin() const { return ( _min<-1 )?-1:_min; }
	int getCount() const { return _count; }
private:
	float _values, _min, _max;
	int _count;
};

class KRecBufferWidget : public TQFrame {
   Q_OBJECT
  
public:
	KRecBufferWidget( KRecBuffer*, TQWidget*, const char* =0 );
	~KRecBufferWidget();

	const KRecBuffer* buffer() { return _buffer; }

	void resizeEvent( TQResizeEvent* );

	void drawFrame( TQPainter* );
	void drawContents( TQPainter* );
	void paintEvent( TQPaintEvent* );

	void mousePressEvent( TQMouseEvent* );
	void mouseDoubleClickEvent( TQMouseEvent* );
signals:
	void popupMenu( KRecBufferWidget*, TQPoint );
private slots:
	void initSamples();
	void changeTitle();
	void changeComment();
private:
	void initLayout();
	KRecBuffer *_buffer;
	TQRegion *_main_region, *_title_region, *_fileend_region;
	TQPoint _topleft, _bottomleft, _bottomright, _topright, _topmiddle, _bottommiddle;
	int _title_height;
	TQValueList <Sample*> samples1, samples2;
	uint alreadyreadsize;
};

#endif

// vim:sw=4:ts=4
