/*
 * forwmachpage.h
 *
 * Copyright (c) 1998 David Faure
 *
 * Requires the TQt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __KCONTROL_KFORWMACHPAGE_H__
#define __KCONTROL_KFORWMACHPAGE_H__

#include <tqdir.h>
/* has to be before everything because of #define Unsorted 0 in X11/X.h !! */

#include <tqobject.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>
#include <tqbutton.h>
#include <tqcheckbox.h> 

#include <tdecmodule.h>

class KSimpleConfig;

class KForwmachPageConfig : public TDECModule
{
  Q_OBJECT
  

public:
    KForwmachPageConfig( TQWidget *parent=0, const char* name=0,
	                     KSimpleConfig *config=0);
    ~KForwmachPageConfig( );
	
    void load();
    void save();
    void defaults();

protected:
    void  resizeEvent(TQResizeEvent *e);

private slots:
    void forwmachOnOff();
	void slotChanged();
 
private:
	KSimpleConfig *config;
	bool delete_config;

    TQCheckBox *forwmach_cb;
    TQLabel *address_label;
    TQLineEdit *address_edit;
    TQLabel *method_label;
    TQComboBox * method_combo;
    TQLabel *expl_label;
};

#endif

