// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *               2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _TQVIDEOSTREAM_H
#define _TQVIDEOSTREAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GL
#include <tqgl.h>
#include <GL/gl.h>
#endif

#include <tqwidget.h>
#include "qvideo.h"

class QVideoStreamPrivate;

/**
 * QT-style video stream driver.
 */
class QVideoStream : public TQObject, public QVideo
{
	Q_OBJECT
  

public:
	QVideoStream(TQWidget *widget, const char* name = 0);
	~QVideoStream();

	/* output method */
	bool haveMethod(VideoMethod method) const;
	VideoMethod method() const;
	VideoMethod setMethod(VideoMethod method);

	/* max output sizes */
	TQSize maxSize() const;
	int   maxWidth() const;
	int   maxHeight() const;

	/* output sizes */
	TQSize size() const;
	int   width() const;
	int   height() const;

	TQSize setSize(const TQSize& sz);
	int   setWidth(int width);
	int   setHeight(int height);

	/* input sizes */
	TQSize inputSize() const;
	int   inputWidth() const;
	int   inputHeight() const;

	TQSize setInputSize(const TQSize& sz);
	int setInputWidth(int width);
	int setInputHeight(int height);

    /* input format */
    ImageFormat format() const;
    bool setFormat(ImageFormat format);

    /* functions to find out about formats */
    ImageFormat formatsForMethod(VideoMethod method);
    bool supportsFormat(VideoMethod method, ImageFormat format);

    /* Display image */
	QVideoStream& operator<<(const unsigned char *const img);
    
public slots:
	int displayFrame(const unsigned char *const img);
	int displayFrame(const unsigned char *const img, int x, int y, int sw, int sh);

private:
    QVideoStreamPrivate* d;

	TQWidget*    _w;
	VideoMethod _methods; // list of methods
	VideoMethod _method;  // the current method
    ImageFormat _format;
	TQSize       _size;
	TQSize       _inputSize;
	bool        _init;
    ImageFormat _xFormat;

	void deInit();
	void init();
};

#endif

