/*
    kopeteballoon.cpp  -  Nice Balloon

    Copyright (c) 2002      by Duncan Mac-Vicar Prett <duncan@kde.org>

    Kopete    (c) 2002-2005      by the Kopete developers  <kopete-devel@kde.org>

    Portions of this code based on Kim Applet code
    Copyright (c) 2000-2002 by Malte Starostik        <malte@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqpointarray.h>
#include <tqpushbutton.h>
#include <tqtooltip.h>
#include <tqlayout.h>
#include <tqtimer.h>

#include <tdeversion.h>
#include <tdeglobalsettings.h>

#include <tdeapplication.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <kprotocolinfo.h>
#include <kurl.h>
#include <krun.h>

#include "kopeteballoon.h"
#include "systemtray.h"
#include "kopeteprefs.h"

KopeteActiveLabel::KopeteActiveLabel( TQWidget *parent, const char *name )
	: KActiveLabel( parent, name ) 
{
}

KopeteActiveLabel::KopeteActiveLabel( const TQString& text, TQWidget *parent,
	const char *name ) : KActiveLabel( text, parent, name )
{
}

void KopeteActiveLabel::openLink( const TQString& link )
{
	KURL url( link );
	TQString protocol = url.protocol();
	
	if ( protocol == "mailto" )
		kapp->invokeMailer(url);
	else 
	{
		if ( KProtocolInfo::protocolClass( protocol ) == ":internet" ) // http, ftp, etc.
			new KRun( url, this );
	}
}

KopeteBalloon::KopeteBalloon(const TQString &text, const TQString &pix)
: TQWidget(0L, "KopeteBalloon", WStyle_StaysOnTop | WStyle_Customize |
	WStyle_NoBorder | WStyle_Tool | WX11BypassWM)
{
	setCaption("");

	TQVBoxLayout *BalloonLayout = new TQVBoxLayout(this, 22,
		KDialog::spacingHint(), "BalloonLayout");

	// BEGIN Layout1
	TQHBoxLayout *Layout1 = new TQHBoxLayout(BalloonLayout,
		KDialog::spacingHint(), "Layout1");
	//TQLabel *mCaption = new TQLabel(text, this, "mCaption");
	KopeteActiveLabel *mCaption = new KopeteActiveLabel(text, this, "mCaption");
	mCaption->setPalette(TQToolTip::palette());
	mCaption->setSizePolicy( TQSizePolicy::Minimum, TQSizePolicy::Minimum );

	if (!pix.isEmpty())
	{
		TQLabel *mImage = new TQLabel(this, "mImage");
		mImage->setScaledContents(FALSE);
		mImage->setPixmap(locate("data", pix));

		Layout1->addWidget(mImage);
	}
	Layout1->addWidget(mCaption);
	// END Layout1


	// BEGIN Layout2
	TQHBoxLayout *Layout2 = new TQHBoxLayout(BalloonLayout,
		KDialog::spacingHint(), "Layout2");
	TQPushButton *mViewButton = new TQPushButton(i18n("to view", "View"), this,
		"mViewButton");
	TQPushButton *mIgnoreButton = new TQPushButton(i18n("Ignore"), this,
		"mIgnoreButton");

	Layout2->addStretch();
	Layout2->addWidget(mViewButton);
	Layout2->addWidget(mIgnoreButton);
	Layout2->addStretch();
	// END Layout2

	setPalette(TQToolTip::palette());
	setAutoMask(TRUE);

	connect(mViewButton, TQT_SIGNAL(clicked()),
		this, TQT_SIGNAL(signalButtonClicked()));
	connect(mViewButton, TQT_SIGNAL(clicked()),
		this, TQT_SLOT(deleteLater()));
	connect(mIgnoreButton, TQT_SIGNAL(clicked()),
		this, TQT_SIGNAL(signalIgnoreButtonClicked()));
	connect(mIgnoreButton, TQT_SIGNAL(clicked()),
		this, TQT_SLOT(deleteLater()));
	connect(mCaption, TQT_SIGNAL(linkClicked(const TQString &)),
		this, TQT_SIGNAL(signalIgnoreButtonClicked()));
	connect(mCaption, TQT_SIGNAL(linkClicked(const TQString &)),
		this, TQT_SLOT(deleteLater()));
	
	KopetePrefs *p = KopetePrefs::prefs();
	// Autoclose balloon 
	if (p->balloonClose())
		TQTimer::singleShot( p->balloonCloseDelay() * 1000, this, TQT_SIGNAL( signalTimeout( ) ) );
}

void KopeteBalloon::setAnchor(const TQPoint &anchor)
{
	mAnchor = anchor;
	updateMask();
}

void KopeteBalloon::updateMask()
{
	TQRegion mask(10, 10, width() - 20, height() - 20);

	TQPoint corners[8] = {
		TQPoint(width() - 50, 10),
		TQPoint(10, 10),
		TQPoint(10, height() - 50),
		TQPoint(width() - 50, height() - 50),
		TQPoint(width() - 10, 10),
		TQPoint(10, 10),
		TQPoint(10, height() - 10),
		TQPoint(width() - 10, height() - 10)
	};

	for (int i = 0; i < 4; ++i)
	{
		TQPointArray corner;
		corner.makeArc(corners[i].x(), corners[i].y(), 40, 40,
			i * 16 * 90, 16 * 90);
		corner.resize(corner.size() + 1);
		corner.setPoint(corner.size() - 1, corners[i + 4]);
		mask -= corner;
	}

	// get screen-geometry for screen our anchor is on
	// (geometry can differ from screen to screen!
		TQRect deskRect = TDEGlobalSettings::desktopGeometry(mAnchor);

	bool bottom = (mAnchor.y() + height()) > ((deskRect.y() + deskRect.height()-48));
	bool right = (mAnchor.x() + width()) > ((deskRect.x() + deskRect.width()-48));

	TQPointArray arrow(4);
	arrow.setPoint(0, TQPoint(right ? width() : 0, bottom ? height() : 0));
	arrow.setPoint(1, TQPoint(right ? width() - 10 : 10,
		bottom ? height() - 30 : 30));
	arrow.setPoint(2, TQPoint(right ? width() - 30 : 30,
		bottom ? height() - 10 : 10));
	arrow.setPoint(3, arrow[0]);
	mask += arrow;
	setMask(mask);

	move( right ? mAnchor.x() - width() : ( mAnchor.x() < 0 ? 0 : mAnchor.x() ),
	      bottom ? mAnchor.y() - height() : ( mAnchor.y() < 0 ? 0 : mAnchor.y() )  );

	//kdDebug(14000) << k_funcinfo << "finalpos: x=" << x() << ", y=" << y() << endl;
}

#include "kopeteballoon.moc"
// vim: set noet ts=4 sts=4 sw=4:
