/***************************************************************************
                          hiddenfileview.h  -  description
                             -------------------
    begin                : Wed Jan 1 2003
    copyright            : (C) 2003 by Jan Sch�fer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *  This file is part of KSambaPlugin.                                          *
 *                                                                            *
 *  KSambaPlugin is free software; you can redistribute it and/or modify            *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  KSambaPlugin is distributed in the hope that it will be useful,                 *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with KSambaPlugin; if not, write to the Free Software                     *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA  *
 *                                                                            *
 ******************************************************************************/

#ifndef _HIDDENFILEVIEW_H_
#define _HIDDENFILEVIEW_H_

#include <tdefileitem.h>
#include <tdelistview.h>

#include "qmultichecklistitem.h"

class KDirLister;
class TQRegExp;
class ShareDlgImpl;
class SambaShare;

class HiddenListViewItem : public QMultiCheckListItem
{
Q_OBJECT
  
public:
  HiddenListViewItem( TQListView *parent, KFileItem *fi, bool hidden, bool veto, bool vetoOplock );
  ~HiddenListViewItem();

  virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);

  KFileItem* getFileItem();
protected:
  KFileItem *_fileItem;
};

class TDEToggleAction;
class TDEPopupMenu;
class ShareDlgImpl;


/**
 * Widget which shows a list of files
 * from a directory.
 * It gets the directory from the SambaShare
 * It also interprets the hidden files parameter
 * of the SambaShare an offers the possibility of
 * selecting the files which should be hidden
 **/
class HiddenFileView : public TQObject
{
Q_OBJECT
  

public:
  HiddenFileView(ShareDlgImpl* shareDlg, SambaShare* share);
  ~HiddenFileView();

  /**
   * Load the values from the share and show them
   **/
  void load();

  /**
   * Save changings to the share
   **/
  void save();

protected:
  SambaShare* _share;
  ShareDlgImpl* _dlg;

  KDirLister* _dir;
  TQPtrList<TQRegExp> _hiddenList;
  TQPtrList<TQRegExp> _vetoList;
  TQPtrList<TQRegExp> _vetoOplockList;

  TDEToggleAction* _hiddenActn;
  TDEToggleAction* _vetoActn;
  TDEToggleAction* _vetoOplockActn;

  TDEPopupMenu* _popup;

  void initListView();

  TQPtrList<TQRegExp> createRegExpList(const TQString & s);
  bool matchHidden(const TQString & s);
  bool matchVeto(const TQString & s);
  bool matchVetoOplock(const TQString & s);
  bool matchRegExpList(const TQString & s, TQPtrList<TQRegExp> & lst);

  TQRegExp* getHiddenMatch(const TQString & s);
  TQRegExp* getVetoMatch(const TQString & s);
  TQRegExp* getRegExpListMatch(const TQString & s, TQPtrList<TQRegExp> & lst);

  TQPtrList<HiddenListViewItem> getMatchingItems(const TQRegExp & rx);

  void setState(TQPtrList<HiddenListViewItem> & lst,int column, bool b);
  void deselect(TQPtrList<HiddenListViewItem> & lst);

  void updateEdit(TQLineEdit* edit, TQPtrList<TQRegExp> & lst);

protected slots:
  // slots for KDirListener :
  void insertNewFiles(const KFileItemList &newone);
  void deleteItem( KFileItem *_fileItem );
  void refreshItems( const KFileItemList& items );
  
  void selectionChanged();
  void hiddenChkClicked(bool b);
  void vetoChkClicked(bool b);
  void vetoOplockChkClicked(bool b);
  void checkBoxClicked(TQCheckBox* chkBox,TDEToggleAction* action,TQLineEdit* edit,int column,TQPtrList<TQRegExp> &reqExpList,bool b);
  void columnClicked(int column);
  void showContextMenu();
  void updateView();
  void hideDotFilesChkClicked(bool);
  void hideUnreadableChkClicked(bool);
  void slotMouseButtonPressed( int button, TQListViewItem * item, const TQPoint & pos, int c );
};

#endif
