/*
 * answmachpage.h
 *
 * Copyright (c) 1998 David Faure
 *
 * Requires the TQt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef __KCONTROL_KANSWMACHPAGE_H__
#define __KCONTROL_KANSWMACHPAGE_H__

#include <tqdir.h>
/* has to be before everything because of #define Unsorted 0 in X11/X.h !! */

#include <tqobject.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqmultilineedit.h>
#include <tqpushbutton.h>
#include <tqbutton.h>
#include <tqcheckbox.h> 

#include <tdecmodule.h>

class KSimpleConfig;

class KAnswmachPageConfig : public TDECModule
{
  Q_OBJECT
  

public:
	KAnswmachPageConfig( TQWidget *parent=0, const char* name=0, 
	                     KSimpleConfig *config=0 );
    ~KAnswmachPageConfig( );
	
    void load();
    void save();
    void defaults();

protected:
    void  resizeEvent(TQResizeEvent *e);

private slots:
    void answmachOnOff();
    void slotChanged();
 
private:
	KSimpleConfig *config;
	bool delete_config;

    TQCheckBox *answmach_cb;
    TQLabel *mail_label;
    TQLineEdit *mail_edit;
    TQLabel *subj_label;
    TQLineEdit *subj_edit;
    TQLabel *subj_tip;
    TQLabel *head_label;
    TQLineEdit *head_edit;
    TQLabel *head_tip;
    TQCheckBox *emptymail_cb;
    TQLabel *msg_label;
    TQMultiLineEdit *msg_ml;

    TQString *msg_default;
};

#endif

